#ifndef _qed_windows_h_
#define _qed_windows_h_

#define CLASS_ALL			0			/* Alle Klassen */
#define CLASS_EDIT		1			/* Textfenster */
#define CLASS_PROJEKT	2			/* Projektfenster */
#define CLASS_ICON		3			/* Iconifiziertes Fenster fr AllIconify */

#define WI_NONE			0x0000	/* Keine Flags */
#define WI_OPEN			0x0001	/* Fenster ist offen */
#define WI_TEXT			0x0002	/* Fenster enthlt Text mit TAB und CR */ 
#define WI_FONTSIZE		0x0004	/* Bei Fontnderung Grenanpassung */
#define WI_REDRAW			0x0008	/* Fenster ganz redrawen bei size */
#define WI_NOTDRAWED 	0x0010	/* Eine redraw-Msg wird geschluckt */
#define WI_ICONIFIED		0x0020	/* Fenster ist Icon */
#define WI_FULLED			0x0040	/* Fenster auf voller Gre */
#define WI_CHANGED		0x0080	/* Fenster wurde verndert '*' */
#define WI_SHADED			0x0100	/* Fenster wurde ge'shaded (MagiC, WINX) */

/* Aktionen auf Icons */
#define DO_UNDO			0
#define DO_CUT				1
#define DO_COPY			2
#define DO_PASTE			3
#define DO_SELALL			4
#define DO_CLOSE			5
#define DO_OPEN			6
#define DO_INFO			7
#define DO_HELP			8
#define DO_LEFT			9
#define DO_RIGHT			10
#define DO_FORMAT			11
#define DO_PRINT			12
#define DO_ABAND			13
#define DO_SAVE			14
#define DO_SAVENEW		15
#define DO_FIND			16
#define DO_FINDNEXT		17
#define DO_ADD				18
#define DO_GOTO			19
#define DO_STRIPLINES	20
#define DO_TAB2LZ			21
#define DO_UPDATE			22
#define DO_LZ2TAB			23
#define DO_LINECOPY		24
#define DO_ZEICHTAB		25
#define DO_SWAPCHAR		26
#define DO_ONE_LEFT		27
#define DO_ONE_RIGHT		28
#define DO_BIG2SMALL		29
#define DO_SMALL2BIG		30
#define DO_CHNG_SMBG		31
#define DO_CAPS			32
#define DO_UMLAUT			33
#define DO_AUTOSAVE		34
#define DO_FEHLER			35
#define DO_DELETE			36
#define DO_SORT			37

#define DO_ANZ				38		/* bei nderung -> menu_nr[MENU] anpassen */


#define HORIZONTAL	0x01	/* Fr Scrolling... */
#define VERTICAL		0x02	/* ...und Schieber setzen */

#define SLPOS			0x01	/* Fr Schieber setzen */
#define SLSIZE			0x02

/*
 * exportierte Variablen
*/

EXTERN WINDOWP 	sel_window;		/* Zeiger auf selektiertes Fenster */
EXTERN SET			sel_objs;		/* Menge selektierter Objekte */
EXTERN BOOLEAN		all_iconified;	/* sind wir komplett iconified?? */

/*
 * Funktionen
*/

EXTERN WORD 	num_openwin			(WORD class);
EXTERN WINDOWP get_window			(WORD handle);
EXTERN VOID 	do_all_window		(WORD class, WIN_DOFUNC func);
EXTERN WINDOWP winlist_top			(VOID);
EXTERN VOID 	get_realtop			(VOID);
EXTERN WINDOWP real_top				(VOID);
EXTERN BOOLEAN rc_first				(WORD wh, CONST GRECT *b, GRECT *r);
EXTERN BOOLEAN rc_next				(WORD wh, GRECT *r);
EXTERN VOID 	clr_area 			(CONST GRECT *area);
EXTERN BOOLEAN free_for_draw		(WINDOWP w);
EXTERN VOID 	redraw_window		(WINDOWP w, CONST GRECT *area);
EXTERN VOID 	size_window			(WINDOWP w, CONST GRECT *new, BOOLEAN border);
EXTERN VOID 	full_window			(WINDOWP w);
EXTERN VOID 	iconify_window		(WINDOWP w, CONST GRECT *new);
EXTERN VOID 	uniconify_window	(WINDOWP w, CONST GRECT *new);
EXTERN VOID		all_iconify			(CONST GRECT *new);
EXTERN VOID 	all_uniconify		(CONST GRECT *new);
EXTERN VOID 	move_window			(WINDOWP w, CONST GRECT *new);
EXTERN VOID 	ontop_window		(WINDOWP w);
EXTERN VOID 	untop_window		(WINDOWP w);
EXTERN VOID 	top_window			(WINDOWP w);
EXTERN VOID 	cycle_window		(VOID);
EXTERN VOID 	bottom_window		(WINDOWP w, WORD which);
EXTERN VOID		shade_window		(WINDOWP w, WORD mode);
EXTERN VOID 	scroll_vertical	(CONST GRECT *area, WORD delta);
EXTERN VOID 	arrow_window		(WINDOWP w, WORD arrow, LONG amount);
EXTERN VOID 	h_slider				(WINDOWP w, WORD new_value);
EXTERN VOID 	v_slider				(WINDOWP w, WORD new_value);
EXTERN VOID 	set_sliders			(WINDOWP w, WORD which, WORD mode);
EXTERN VOID 	set_wtitle			(WINDOWP w, CONST UBYTE *filename);
EXTERN VOID 	set_winfo			(WINDOWP w, CONST UBYTE *info);
EXTERN VOID 	change_window 		(WINDOWP w, CONST UBYTE *filename, BOOLEAN changed);
EXTERN WINDOWP create_window		(WORD kind, WORD class, WIN_CRTFUNC crt);
EXTERN BOOLEAN open_window			(WINDOWP w);
EXTERN VOID 	close_window		(WINDOWP w);
EXTERN VOID 	do_font_change		(WINDOWP w);
EXTERN VOID 	click_window		(WINDOWP w, MOUSEDATA *mouse);
EXTERN VOID 	unclick_window 	(VOID);
EXTERN BOOLEAN	key_window			(WINDOWP w, KEYDATA *key);
EXTERN VOID		arrange_window		(WORD mode);

EXTERN VOID 	init_window			(VOID);
EXTERN VOID		term_window			(VOID);

#endif
