/*
 * Listenverwaltung fr die Fenster.
 *
 * Es gibt zwei verschiedene Listen:
 *		used_list: - enthlt alle offenen Fenster
 *					  - erstes Element ist das Top-Window
 *					  - einfach verkettet
 *
 *		free_list: - enthlt die unbenutzten Fenster, deren Gre bekannt ist
 *					  - einfach verkettet mit Reihenfolge des w->init
 *
 * Wird ein neues Fenster bentigt, wird in der free_list nach dem mit dem
 * kleinsten init der entsprechenden Klasse gesucht. Wird keins gefunden,
 * wird in der free_list ein neues Element angehngt.
 * Das Fenster aus der free_list wird dann in die used_list umgehngt und in
 * der free_list gelscht.
 * Wird ein Fenster nicht mehr bentigt, wird es in used_list gelscht und in
 * free_list entsprechend seinem init einsortiert.
 * Das erste Fenster einer Klasse steht in free_list immer ganz vorne.
*/
#include "global.h"
#include "qed.h"
#include "winlist.h"

GLOBAL WINDOWP	used_list;

LOCAL WINDOWP	free_list;
LOCAL WORD		init_count;

#if 0
GLOBAL VOID dump_winlist(VOID)
{
	WINDOWP	p;

	p = used_list;
	Debug("used_list:\n");
	while (p)
	{
		Debug(" class= %d, init= %d, title= %s\n", p->class, p->init, p->title);
		p = p->next;
	}

	p = free_list;
	Debug("free_list:\n");
	while (p)
	{
		Debug(" class= %d, init= %d, title= %s\n", p->class, p->init, p->title);
		p = p->next;
	}
	Debug("\n");
}
#endif

/*
 * free_list: Neues Element in die Liste einhngen.
*/
LOCAL WINDOWP new_list_elem(WORD class)
{
	WINDOWP	new, p;

	new = (WINDOWP)calloc(1, sizeof(WINDOW));
	if (new != NULL)
	{
		new->next = NULL;

		if (free_list == NULL)				/* Erstes Element -> Wurzel */
			free_list = new;
		else
		{
			p = free_list;

			while (p->next != NULL)			/* Am Ende der Liste anhngen */
				p = p->next;
			p->next = new;
		}
		new->class = class;
		new->handle = UNUSED;
		new->init = init_count;
		init_count++;
		return new;
	}
	else
		note(1, NOMEMORY);
	return NULL;
}

#if 0
/*
 * Ein Element lschen.
*/
LOCAL VOID del_list_elem(WINDOWP w)
{
	if (w == win_list)					/* Wurzel? */
		win_list = win_list->next;
	else
	{
		WINDOWP	p = win_list;

		while (p->next != w)				/* Vorgnger suchen */
			p = p->next;
		p->next = w->next;				/* und Aushngen */
	}
	free(w);
	w = NULL;
}

/*
 * Gesamte Listen lschen
*/
LOCAL VOID kill_list(VOID)
{
	while (win_list != NULL)
		del_list_elem(win_list);
}
#endif

/*
 * Fenster aus einer Liste aushnge, aber nicht lschen!
*/
LOCAL VOID unlink_elem(WINDOWP *list, WINDOWP w)
{
	if (w == *list)						/* Wurzel? */
		*list = (*list)->next;
	else
	{
		WINDOWP	p = *list;

		while (p->next != w)				/* Vorgnger suchen */
			p = p->next;
		p->next = w->next;				/* und Aushngen */
	}
}

/*
 * Fenster aus der free_list an den Anfang der used_list.
*/
LOCAL VOID free_to_used(WINDOWP w)
{
	unlink_elem(&free_list, w);

	if (used_list == NULL)
	{
		used_list = w;
		w->next = NULL;
	}
	else
	{
		w->next = used_list;
		used_list = w;
	}
}

/*
 * Fenster aus der used_list in die free_list einsortieren.
*/
LOCAL VOID used_to_free(WINDOWP w)
{
	WINDOWP	p, last;
	
	unlink_elem(&used_list, w);

	p = free_list;
	if (free_list == NULL)					/* kein Element */
	{
		free_list = w;
		w->next = NULL;
	}
	else if (w->init < free_list->init)	/* vor dem ersten einfgen */
	{
		w->next = free_list;
		free_list = w;
	}
	else
	{
		p = free_list;
		last = free_list;
		while ((p) && (p->init < w->init))
		{
			last = p;
			p = p->next;
		}
		w->next = last->next;
		last->next = w;
	}
}

/*
 * used_list: Listenelement ganz an Anfang bzw. Ende
*/
GLOBAL VOID move_to_top(WINDOWP w)
{
	WINDOWP p;

	if (used_list == NULL)
		return;

	if (w == used_list) 						/* ist schon oben */
		return;

	p = used_list;
	while (p->next != w)						/* Vorgnger suchen */
		p = p->next;
	p->next = w->next;
	w->next = used_list;
	used_list = w;
}

GLOBAL VOID move_to_end (WINDOWP w)
{
	WINDOWP p;

	if (used_list == NULL)
		return;

	if (w->next == NULL)						/* ist schon letzter */
		return;

	if (w == used_list)						/* ist erster */
		used_list = w->next;
	else											/* mitten drin */
	{
		p = used_list;
		while (p->next != w)					/* Vorgnger suchen */
			p = p->next;
		p->next = w->next;
	}
	p = used_list;
	while (p->next != NULL)					/* letzten suchen */
		p = p->next;
	p->next = w;
	w->next = NULL;
}

/*
 * Abmessungen eines Fensters aus der Konfig in die Liste einhngen
*/
GLOBAL VOID add_winlist(WORD class, GRECT *r)
{
	WINDOWP	w;

	w = new_list_elem(class);
	if (w)
		w->work = *r;
}

/*
 * Fensterparameter sichern.
*/
LOCAL WINDOWP search_init(WINDOWP list, WORD init)
{
	WINDOWP	p = list;
	
	while (p)
	{
		if (p->init == init)
			break;
		p = p->next;
	}	
	return p;
}

GLOBAL VOID save_winlist(FILE *fd)
{
	WORD		i;
	WINDOWP	p;
		
	i = 0;
	while (i < init_count)
	{
		p = search_init(used_list, i);
		if (!p)
			p = search_init(free_list, i);
		if (p)
			fprintf(fd, "Window=%d %d %d %d %d\n", p->class,  
							p->work.g_x, p->work.g_y, p->work.g_w, p->work.g_h);
		i++;
	}
}

/*
 * Freies Fenster einer Klasse suchen, ggf. neu anlegen.
*/
GLOBAL WINDOWP get_new_window(WORD class)
{
	WINDOWP	p;
	
	p = free_list;
	while (p)								/* zunchst unbenutzes suchen */
	{
		if ((p->handle == UNUSED) && (p->class == class))
			break;
		p = p->next;
	}
	if (p == NULL)							/* kein unbenutztes gefunden */
		p = new_list_elem(class);
	free_to_used(p);
	return p;
}

/*
 * Fenster freigeben.
*/
GLOBAL VOID free_window(WINDOWP w)
{
	used_to_free(w);
	w->handle = UNUSED;
}


GLOBAL VOID init_winlist(VOID)
{
	used_list = NULL;
	free_list = NULL;
	init_count = 0;
}

GLOBAL VOID term_winlist(VOID)
{
}
