/*
 * Dieses Modul basiert auf einem Modula2-Quelltext von Uwe Mindrup @ LB
*/
#include <string.h>
#include <osbind.h>
#include <time.h>

#include "wp-print.h"

/*
 * Exportierte Variablen
*/
GLOBAL	BOOLEAN	wp_config_read = FALSE;


#define MaxSequence		0x4F
#define MaxTranslations 0xFF
/* es folgen die Konstanten fr den Tabelleneingang der Funktionen: */
#define VERTPOS			5
#define BOLD				6
#define ITALIC 			0xA
#define LIGHT				0xE
#define SUPERSCRIPT		0x12
#define SUBSCRIPT 		0x16
#define _UNDERLINE 		0x1A
#define HORZINIT			0x1F
#define VERTINIT			0x20
#define PRINTERINIT		0x21

#define _1STTYPE			0x28
#define _1STCOLOR 		0x30
#define PROP				0x35
#define FORMFEED			0x1E
#define WRITELN			1
#define TAB 				0x09

typedef struct
{
	WORD	len;
	WORD	pos;
} TABLEENTRY;


/*
 * lokale Variablen
*/
LOCAL TABLEENTRY	SeqTable[MaxSequence + 1],
				 		TransTable[MaxTranslations + 1];
LOCAL UBYTE 		*cfgPtr;
LOCAL WORD			PrnHdl,
						CharPos, 					/* Position des Zeichens in der aktuellen Zeile */
						NrSpaces,					/* Anzahl Leerzeichen */
						NLQSet,						/* [0..2] */
						AktMode,	AktColor,
						TabSize,
						PropSize;
LOCAL BOOLEAN		Proportional;


/*
 * lokale Prozeduren
*/
LOCAL VOID InitTables(VOID)						/* Tabellen initialisieren */
{
	WORD	i;

	for (i = 0; i <= MaxSequence; i++)
		SeqTable[i].len = 0;
	for (i = 0; i <= MaxTranslations; i++)
		TransTable[i].len = 0;
	CharPos = 0;
}

LOCAL BOOLEAN Out(UBYTE ch)
{
	if (PrnHdl == -2)
		Cauxout(ch);
	else if (PrnHdl == -3)
		Cprnout(ch);
	else
		Fwrite(PrnHdl, 1, &ch);
	return TRUE;
}


LOCAL BOOLEAN PrintSeq(WORD which)
{
	WORD		i;
	BOOLEAN	ok;

	for (i = SeqTable[which].pos; i <= SeqTable[which].pos + SeqTable[which].len - 1; i++)
	{
		ok = Out(cfgPtr[i]);
		if (!ok)
			break;
	}
	return ok;
}


LOCAL BOOLEAN Print(WORD entry, BOOLEAN set)		/* Ausgabe der angewhlten Steuersequenz */
{
	if (!set)
		entry++;
	return PrintSeq(entry + NLQSet);
}


LOCAL BOOLEAN WriteChar(UBYTE ch)
{
	WORD		i;
	BOOLEAN	ok;

	if (TransTable[ch].len > 0)
	{
		for (i = TransTable[ch].pos; i <= TransTable[ch].pos + TransTable[ch].len - 1; i++)
		{
			ok = Out(cfgPtr[i]);
			if (!ok)
				break;
		}
		CharPos++;
	}
	else
	{
		ok = Out(ch);
		CharPos++;
	}
	return ok;
}


LOCAL BOOLEAN SetHead(VOID)							/*  Druckkopf neu positionieren */
{
	WORD		i, len, pos;
	BOOLEAN	ok;

	len = SeqTable[VERTPOS].len;
	pos = SeqTable[VERTPOS].pos;
	for (i = pos; i <= pos + len - 1; i++)
	{
		if (cfgPtr[i] == 0x80)
			ok = Out((CharPos * 60 / PropSize) % 256);
		else if (cfgPtr[i] == 0x81)
			ok = Out((CharPos * 60 / PropSize) / 256);
		else
			ok = Out(cfgPtr[i]);
		if (!ok)
			break;
	}
	NrSpaces = 0;
	return ok;
}


/*
 * exportierte Prozeduren
*/
GLOBAL BOOLEAN WPLoadCFGFile(UBYTE *name)
{
	LONG		Length, err;
	WORD		f, i, j, Pos, Len;

	if (wp_config_read)									/* Config bereits geladen */
		return TRUE;

	err = Fopen(name, 0);
	if (err < 0)
		return FALSE;
	f = (short)err;

	if (cfgPtr != NULL)
		Mfree(cfgPtr);

	Length = Fseek(0, f, 2);						/* ganz ans Ende */

	cfgPtr = Malloc(Length);
	if (cfgPtr == NULL)
	{
		Fclose(f);
		return FALSE;
	}

	Fseek(0, f, 0);									/* zurck zum Anfang */
	err = Fread(f, Length, cfgPtr);
	Fclose(f);

	InitTables();

	/* Kennung berprfen: */
	if (strncmp(cfgPtr, "GST-CFG:", 8) != 0)
		return FALSE;									/* keine GST-CFG-Datei !!! */

	/* Jetzt mssen die Tabellen aufgebaut werden: */
	i = 8;												/* Druckernamen berspringen */
	while (cfgPtr[i] != '\0')
		i++;
	i += 7;												/* Druckeranpassungen interessieren nicht.  */

	/* zunchst die Tabelle der Druckerbesonderheiten:  */
	while (cfgPtr[i] != '\0')						/* Tabelle wird mit einem NUL-Byte beendet */
	{
		Len = cfgPtr[i];
		Pos = cfgPtr[i+1];							/* Tabelleneintrag */
		SeqTable[Pos].len = Len - 2;
		SeqTable[Pos].pos = i + 2;
		i += Len;
	}
	i++;													/* Tabellenende berspringen */

	/* jetzt die bersetzungsTabelle:	*/
	while (cfgPtr[i] != '\0')						/* Tabelle wird mit einem NUL-Byte beendet */
	{
		Len = cfgPtr[i];
		Pos = cfgPtr[i+1];
		TransTable[Pos].len = Len - 2;
		TransTable[Pos].pos = i + 2;
		i += Len;
	}

	/* Optimierung der Druckercharakteristik-Tabelle: */
	/* 1. die Texteffekte: */
	for (i = BOLD; i <= _UNDERLINE; i+=4)
		for (j = i; j <= i+1; j++)
		{
			if ((SeqTable[j].len == 0) && (SeqTable[j+2].len != 0))
				SeqTable[j] = SeqTable[j+2];
			if ((SeqTable[j+2].len == 0) && (SeqTable[j].len != 0))
				SeqTable[j+2] = SeqTable[j];
		}

	/* 2. die Schriftarten: */
	for (i = _1STTYPE; i <= _1STTYPE + 6; i+=2)
	{
		if ((SeqTable[i].len == 0) && (SeqTable[i+1].len != 0))
			SeqTable[i] = SeqTable[i+1];
		if ((SeqTable[i+1].len == 0) && (SeqTable[i].len != 0))
			SeqTable[i+1] = SeqTable[i];
	}
	wp_config_read = TRUE;
	return TRUE;
}


GLOBAL VOID WPGetPrnName(UBYTE *Printername, WORD max_len)
{
	WORD	i;

	if (cfgPtr != NULL)
	{
		i = 8;
		while ((cfgPtr[i] != '\0') && (i < (max_len + 8)))
		{
			Printername[i-8] = cfgPtr[i];
			i++;
		}
		Printername[i - 8] = '\0';
	}
	else
		Printername[0] = '\0';
}

GLOBAL BOOLEAN WPSendInit(BOOLEAN use_nlq)
{
	BOOLEAN	ok;

	if (use_nlq)
		NLQSet = 2;
	else
		NLQSet = 0;
	PrintSeq(HORZINIT);					/* Horizontale Initialisierung */
	PrintSeq(VERTINIT);					/* Vertikale Initialisierung	*/
	Print(BOLD, FALSE);					/* Fettschrift aus.				*/
	Print(ITALIC, FALSE);				/* Kursivschrift aus. 			*/
	Print(LIGHT, FALSE);					/* Light aus.						*/
	Print(SUPERSCRIPT, FALSE);			/* Superscript aus.				*/
	Print(SUBSCRIPT, FALSE);			/* Subscript aus.					*/
	Print(_UNDERLINE, FALSE);			/* Unterstreichung aus.			*/
  	AktMode = -1;
 	PrintSeq(_1STTYPE);					/* PICA (10 CPI)					*/
	AktColor = -1;
	PrintSeq(_1STCOLOR);					/* Color-Einstellung: Black.	*/
	Proportional = FALSE;
	ok = PrintSeq(PROP + 1);			/* Proportional-Schrift aus.	*/
	return ok;
}


GLOBAL BOOLEAN WPSendExit(VOID)
{
	return PrintSeq(PRINTERINIT);
}


GLOBAL BOOLEAN WPSetMode(WORD mode)
{
	BOOLEAN	ok = TRUE;

	if ((mode >= PICA) && (mode <= EXPANDED))
	{
		if (mode != AktMode)
		{
			ok = PrintSeq(2 * mode + _1STTYPE + (NLQSet / 2));
			AktMode = mode;
		}
	}
	return ok;
}


GLOBAL BOOLEAN WPFormFeed(VOID)
{
	return PrintSeq(FORMFEED);
}


GLOBAL VOID WPSetTabSize(WORD tab)
{
	TabSize = tab;
}


GLOBAL BOOLEAN WPWriteLn(VOID)
{
	BOOLEAN	ok;

	ok = PrintSeq(WRITELN);
	CharPos = 0;
	return ok;
}


GLOBAL BOOLEAN WPWrite(UBYTE ch)
{
	WORD		i;
	BOOLEAN	ok;

	if ((ch == TAB) || (ch == ' '))
	{
		if (Proportional)
		{
			if  (ch == ' ')
			{
				CharPos++;
				NrSpaces++;
			}
			else
			{
				CharPos += TabSize;
				NrSpaces += TabSize;
			}
		}
		else
		{
		  	if (ch == ' ')
				ok = WriteChar(' ');
			else
			 	for (i = 1; i <= TabSize; i++)
					ok = WriteChar(' ');
		}
	}
	else
	{
		if (NrSpaces > 1)
			ok = SetHead();
		else if (NrSpaces == 1)
		{
			ok = WriteChar(' ');
			NrSpaces = 0;
		}
		ok = WriteChar(ch);
	}
	return ok;
}


GLOBAL BOOLEAN WPWriteString(UBYTE *Str)
{
	WORD		i;
	BOOLEAN	ok = TRUE;

	i = 0;
	while ((Str[i] != '\0') && ok)
	{
		ok = WPWrite(Str[i]);
		i++;
	}
	return ok;
}


GLOBAL BOOLEAN WPOpen(UBYTE *name)
{
	LONG	err;

	if (strcmp(name, "PRN:") == 0)
		PrnHdl = -3;
	else if (strcmp(name, "AUX:") == 0)
		PrnHdl = -2;
	else
	{
		err = Fopen(name, 1);
		if (err == -33)
			err = Fcreate(name, 0);
		else if (err > 0)
		{
			PrnHdl = (short) err;
			Fseek(0, PrnHdl, 2);
		}
	}
	return (PrnHdl > -31);
}


GLOBAL VOID WPClose(VOID)
{
	Fclose(PrnHdl);
}
