/*
 * Schnittstelle fr ASCII-Druckfunktionen, die einen Wordplus-Treiber
 * benutzen.
 * Basiert auf Modula2-Quellen von Uwe Mindrup, 1993
 * PureC-Portierung von Christian Felsch, 1995
 *
 *  Druckertreiber;
 *  Der Druckertreiber dient dazu, Texte mit Hilfe der reichlich vorhandenen
 *  Druckeranpassungen fr Wordplus ausdrucken zu knnen. Zur Initialisierung
 *  mu eine CFG-Datei geladen werden.
 *  Aufbau einer CFG-Datei:
 *  - Header 'GST-CFG:'; dient als Kennung zur Unterscheidung von anderen
 *                       Formaten.
 *  - Es folgen sechs Bytes mit folgender Bedeutung:
 *    (1)   1 fr Typenrad mit horizontalem Spacing, sonst 0
 *    (2)   Zeichenbreite in Druckereinheiten (Typenrad)
 *    (3)   Zeilenabstand in Druckereinheiten
 *    (4)   Wagenmitte (Typenrad); Pixel/Inch (Matrixdrucker)
 *    (5)   Zeichenabstand bei Fettdruck (Typenrad)
 *    (6)   1 Pause mit Abfrage zwischen Seiten, sonst 0
 *    Diese Werte werden vom vorliegenden Modul ignoriert.
 *
 *  - Jetzt folgen die Druckercharakteristiken.
 *    Diese Tabelle enthlt die Steuersequenzen, die zur Steuerung des
 *    Druckers benutzt werden (hoch, tief, fett, unterstrichen, kursiv,
 *    Draft, NLQ etc).
 *    Die Tabelle endet mit einem Null-Byte.
 *  - Zuletzt folgt die bersetzungstabelle. Hier werden einzelne Zeichen
 *    in andere Zeichen (-folgen) umgesetzt.
 *    Auch diese Tabelle endet mit einem Null-Byte.
 *
 *  Bei einer Initialisierung werden alle Aussschaltsequenzen der aktuellen
 *  Druckqualitt sowie die horizontale und vertikale Initialisierung durch-
 *  laufen.
 *  Sind die Sequenzen der Druckercharakteristiken fr die beiden
 *  Druckqualitten gleich (unterscheiden sich also nur durch die Ein/Ausschalt-
 *  sequenz fr NLQ/Draft), dann reicht es aus, nur bei einer Ausschaltsequenz
 *  die entsprechende Schriftqualitt zu setzen (am besten bei einer selten
 *  bentigten Sequenz, z.B. Index unten).
 *  Mehr noch: Fr die brigen Druckercharakteristiken reicht es aus, wenn die
 *  Sequenz nur in der einen Schriftqualitt gesetzt wird. Der Treiber setzt die
 *  Sequenz automatisch auch fr die andere Schriftqualitt ein.
 *
 */
#ifndef _wp_print_h_ 
#define _wp_print_h_ 

#include "portab.h"

/* 
 * Exportierte Variablen
*/
EXTERN	BOOLEAN	wp_config_read;


#define PICA       0    /* 10 cpi */
#define ELITE      1    /* 12 cpi */
#define CONDENSED  2    /* 17 cpi */
#define EXPANDED   3    /*  6 cpi */
/* 
 * Werte fr die Zeichenbreite (SetMode)
*/


BOOLEAN	WPLoadCFGFile	(UBYTE *name);
/* 
 * Erffnung einer CFG-Datei. Der komplette Dateiname mu bergeben werden.
 * Die Extension wird ggfs. automatisch korrigiert.
 * Die Datei wird nach Erffnung auf die Dateikennung in den ersten 8 Bytes
 * berprft ('GST-CFG:'). 
*/

VOID	WPGetPrnName		(UBYTE *Printername, WORD max_len);
/* 
 * Eingetragenen Druckernamen liefern. Falls keiner vorhanden ist, dann
 * wird ein Leerstring ('') geliefert.
 * max_len begrenzt die Namenslnge.
*/

BOOLEAN	WPSendExit		(VOID);
/* 
 * Es wird Eintrag 21H (Allgemeiner Druckerreset am Textende) gesendet.
*/

BOOLEAN	WPSendInit		(BOOLEAN use_nlq);
/*
 * Drucker-Initialisierung senden. Es werden nacheinander folgende
 * Eintrge geschickt (in Klammern die NLQ-Eintrge):
 * - Eintrag 20H       Horizontale Initialisierung
 * - Eintrag 1FH       Vertikale Initialisierung
 * - Eintrag  7H ( 9H) Fettschrift aus.
 * - Eintrag  BH ( DH) Kursivschrift aus.
 * - Eintrag  FH (11H) Light aus.
 * - Eintrag 13H (15H) Superscript aus.
 * - Eintrag 17H (19H) Subscript aus.
 * - Eintrag 1BH (1DH) Unterstreichung aus.
 * - Falls vorhanden, werden noch die folgenden Sequenzn geschickt:
 * - Eintrag 28H (29H) PICA (10 CPI).
 * - Eintrag 30H       Color-Einstellung: Black.
 * - Eintrag 35H       Proportional-Schrift wird ausgeschaltet.
*/

BOOLEAN	WPSetMode		(WORD Mode);
/*
 * Zeichenbreite einstellen.
 *   Achtung: vorher 'SendInit' durchfhren!
 *   Untersttzt werden:
 *   - PICA      = 0;    (* 10 cpi *)
 *   - ELITE     = 1;    (* 12 cpi *)
 *   - CONDENSED = 2;    (* 17 cpi *)
 *   - EXPANDED  = 3;    (*  6 cpi *)
*/

BOOLEAN	WPFormFeed		(VOID);
/* 
 * Seitenvorschub ausgeben
*/

VOID	WPSetTabSize		(WORD tab);
/* 
 * Tabulatorweite einstellen
*/

BOOLEAN	WPWriteLn		(VOID);
/* 
 * Zeilenvorschub generieren
*/

BOOLEAN	WPWrite			(UBYTE ch);

BOOLEAN	WPWriteString	(UBYTE *Str);

BOOLEAN	WPOpen			(UBYTE *Name);
/* 
 * Erffnung eines Druckerkanals
*/

VOID	WPClose				(VOID);
/* 
 * Schlieung eines Druckerkanals
*/

#endif
