/**************************************************************************/
/* Definitionen fr den xUFSL                                             */
/*                                                                        */
/* 10.09.94 Version 1.00                                                  */
/* 14.09.94 Erweitert um Definitionen des UFSL Version 0.91-0.97          */
/*          Event-Funktion aus dem xUFSL-Aufruf entfernt                  */
/*          Rckgabewerte an UFSL angepat. Die Wert UFS_NO_FONTS und     */
/*          UFS_NO_FONTSIZE sind nur aus Kompatibilittsgrnden defi-     */
/*          niert. Solche Fehler werden intern vom xUFSL abfangen (hof-   */
/*          fentlich...).                                                 */
/* 18.09.94 Neue Flags UFS_AUTO_UPDATE und UFS_ERROR_MSG.                 */
/* 28.09.94 Neue Flags UFS_BITMAP_FONTS und UFS_KERNING_INFO.             */
/*          Schriftbreite erweitert: Struktur FW_INFO. In der Struktur    */
/*          wird neben der Zeichenbreite die Weite des Track-Kernings     */
/*          und die Aktivierung des Paar-Kernings zurckgegeben.          */
/*          Definition der max. Zeichenbreite MAX_CHAR_WIDTH.             */
/* 01.10.94 UFS_AUTO_UPDATE wieder abgeschafft.                           */
/*          Neues Flag UFS_INDIRECT und Struktur XUFSL_LIST.              */
/*          Wenn UFS_INDIRECT gesetzt ist, wird der Parameter info beim   */
/*          beim xUFSL-Aufruf als Zeiger auf eine XUFSL_LIST interpre-    */
/*          tiert. Die Anzahl der Eintrge in dieser Liste mu im Parame- */
/*          ter fontid, der erste selektierte Eintrag in fontsize berge- */
/*          ben werden. ber ein Popup knnen dann die in der Liste ange- */
/*          gebenen Sets in EINEM xUFSL-Dialog gendert werden! Von den   */
/*          weiteren Parametern werden in diesem Fall nur noch die Dia-   */
/*          logfont-IDs beachtet. Der xUFSL versorgt die Eintrge in der  */
/*          XUFSL_LIST.                                                   */
/*          Verwendungsbeispiel: Siehe CALLUFSL.C!                        */
/**************************************************************************/

#if !defined( __XUFSL__)

#define __XUFSL__

/**************************************************************************/
/* Kennung des xUfsl                                                      */
/**************************************************************************/
#define xUFS_ID           'xUFS'

/**************************************************************************/
/* Rckgabewerte des xUfsl                                                */
/**************************************************************************/
#define UFS_RES_ERROR    -7       /* Auflsung kleiner als 640*400 Punkte */
#define UFS_NO_HANDLE    -6       /* Kein Handle frei                     */
#define UFS_NO_WINDOW    -5       /* Kein Fenster frei                    */
#define UFS_NO_FONTS     -4       /* Keine Fonts geladen                  */
#define UFS_NO_FONTSIZE  -3       /* Fontgre nicht identifizierbar      */
#define UFS_ACTIVE       -2       /* Fontselektor ist bereits aktiv       */
#define UFS_ERROR        -1       /* Speichermangel o..                  */
#define UFS_STOP          0       /* <Abbruch> gewhlt                    */
#define UFS_OK            1       /* <Ok> gewhlt                         */

/**************************************************************************/
/* Dialogtypen --> dialtyp, s.u.                                          */
/**************************************************************************/
#define UFS_DIALOG        0       /* Modaler Dialog                       */
#define UFS_WINDOW        1       /* Unmodaler Dialog                     */

/**************************************************************************/
/* Flags fr xUFSL --> flags, s.u.                                        */
/**************************************************************************/
#define UFS_SIZE_CHANGE   0x00000001  /* Schriftgre nderbar?           */
#define UFS_WIDTH_CHANGE  0x00000002  /* Schriftbreite nderbar?          */
#define UFS_ATTR_CHANGE   0x00000004  /* Schriftattribute whlbar?        */
#define UFS_SKEW_CHANGE   0x00000008  /* Schriftneigung nderbar?         */
#define UFS_COLOR_CHANGE  0x00000010  /* Schriftfarbe nderbar?           */
#define UFS_SIZE_DEFAULT  0x00000020  /* Schriftgre "DEFAULT" erlaubt?  */
#define UFS_ATTR_INVERS   0x00000040  /* Sonderattribut "invers" whlbar? */
#define UFS_KERNING_INFO  0x00000080  /* Kerning-Informationen nderbar?  */
#define UFS_GDOS_FONTS    0x00000100  /* GDOS-Fonts erlaubt?              */
#define UFS_PROP_FONTS    0x00000200  /* Proportionalfonts erlaubt?       */
#define UFS_BITMAP_FONTS  0x00000400  /* Nur Bitmap-Fonts erlaubt?        */
#define UFS_WIND_DIALOG   0x00001000  /* Dialog im Fenster?               */
#define UFS_ERROR_MSG     0x00008000  /* Fehler als Alertbox anzeigen?    */
#define UFS_INDIRECT      0x80000000L /* Wird eine XUFSL_LIST verwendet?  */

/**************************************************************************/
/* UFSL-Initialisierungsfunktion, nur aus Kompatibilittsgrnden imple-   */
/* mentiert. Liefert immer SUCCESS.                                       */
/**************************************************************************/
typedef WORD cdecl (*UFSL_INIT)(void);

/**************************************************************************/
/* Standard-Fontselektor                                                  */
/**************************************************************************/
typedef WORD cdecl (*UFSL)(
  WORD   handle,   /* Handle der VDI-Workstation                           */
  WORD   fonts,    /* Gesamtzahl der geladenen Fonts                       */
  WORD   flag,     /* 0=Alle Fonts, 1=Nur unproportionale Fonts            */
  UBYTE	*info,    /* Infotext                                             */
  WORD   *fontid,  /* Gewhlte Font-ID                                     */
  WORD   *fontsize /* Gewhlte Font-Gre                                  */
);

/**************************************************************************/
/* Neuer Standard-Fontselektor ab UFSL 0.97                               */
/**************************************************************************/
typedef WORD cdecl (*NUFSL)(
  WORD   handle,   /* Handle der VDI-Workstation                           */
  WORD   flag,     /* 0=Alle Fonts, 1=Nur unproportionale Fonts            */
  UBYTE	*info,    /* Infotext                                             */
  WORD   *fontid,  /* Gewhlte Font-ID                                     */
  WORD   *fontsize /* Gewhlte Font-Gre                                  */
);

/**************************************************************************/
/* Benutzerdefinierte Hilfefunktion, sofern gewnscht. Nur wenn diese     */
/* ungleich NULL ist, wird der Hilfe-Knopf berhaupt aktiviert.           */
/**************************************************************************/
typedef WORD cdecl (*UFSL_HELP)(void);

/**************************************************************************/
/* Redraw-Funktion                                                        */
/* Die Redraw-Funktion wird NICHT bei folgenden Ereignissen aufgerufen:   */
/* WM_TOPPED, WM_NEWTOP, WM_CLOSED.                                       */
/**************************************************************************/
typedef void cdecl (*MSGFUNC)(
  WORD event,    /* Event                                                  */
  WORD *msgbuff  /* Message-Puffer                                         */
);

/**************************************************************************/
/* Schriftbreiten-Informationsstruktur ('FontWidthInfo')                  */
/* pair   Pair-Kerning (0=nein, 1=ja): "Zusammenschieben" bestimmter      */
/*        Buchstabenpaare (z.B. "Fa", "Ve").                              */
/* track  Art des Track-Kernings (0=ohne, 1=normal, 2=eng, 3=sehr eng):   */
/*        Hiermit wird der generelle Abstand zwischen den Buchstaben be-  */
/*        stimmt.                                                         */
/* width  Schriftbreite (0..MAX_CHAR_WIDTH Punkte)                        */
/**************************************************************************/
#define MAX_CHAR_WIDTH  8191

#if 0

 Ist auch in xfsl.h definiert!!

typedef struct {
  UWORD  pair  : 1;
  UWORD  track : 2;
  UWORD  width : 13;
} FW_INFO;

#endif

/**************************************************************************/
/* Bei gesetztem UFS_INDIRECT-Bit wird statt in info ein Zeiger auf eine  */
/* XUFSL_LIST bergeben. Die Anzahl der Eintrge dieser Liste mu im Pa-  */
/* rameter fontid bergeben werden.                                       */
/**************************************************************************/
typedef struct {
  ULONG flags;        /* Flags zur Funktionsberwachung           */
  UBYTE			*entry;       /* Popup-Eintrag, mu eindeutig sein!       */
  WORD         fontid;       /* Voreingestellte/gewhlte ID              */
  WORD         fontsize;     /* Voreingestellte/gewhlte Gre           */
  FW_INFO      fontwidth;    /* Voreingestellte/gewhlte Breite+Kerning  */
  WORD         fontattr;     /* Voreingestellte/gewhlte Attribute       */
  WORD         fontcol;      /* Voreingestellte/gewhlte Farbe           */
  WORD         fontskew;     /* Voreingestellte/gewhlte Neigung         */
} XUFSL_LIST;

/**************************************************************************/
/* Extended-Fontselektor                                                  */
/**************************************************************************/
typedef WORD cdecl (*XUFSL)(
  WORD	handle,       /* Handle der VDI-Workstation               */
  ULONG	flags,        /* Flags zur Funktionsberwachung           */
  UBYTE	*title,       /* Fenstertitel, Default: Copyright-Info    */
  UBYTE	*info,        /* Fensterinfo, Default: 'Schriftauswahl'   */
                              /* bzw. Zeiger auf eine XUFSL_LIST          */
  WORD   smallid,      /* ID SMALL-Zeichensatz im xUFSL-Dialog     */
  WORD   ibmid,        /* ID IBM-Zeichensatz im xUFSL-Dialog       */
  WORD   *fontid,      /* Voreingestellte/gewhlte ID              */
                              /* bzw. Anzahl der Eintrge der XUFSL_LIST  */
  WORD   *fontsize,    /* Voreingestellte/gewhlte Gre           */
                              /* bzw. Aufsatzpunkt in der XUFSL_LIST      */
  FW_INFO       *fontwidth,   /* Voreingestellte/gewhlte Breite und      */
                              /* Kerning-Informationen                    */
  WORD           *fontattr,    /* Voreingestellte/gewhlte Attribute       */
  WORD           *fontcol,     /* Voreingestellte/gewhlte Farbe           */
  WORD           *fontskew     /* Voreingestellte/gewhlte Neigung         */
);

/**************************************************************************/
/* Eigentliche xUFSL-Struktur                                             */
/**************************************************************************/
typedef struct {
  ULONG 			id;               /* Kennung des xUFSL (xUFS)             */
  UWORD  		version;          /* Version (BCD-Format)                 */
  UWORD  		dialtyp;          /* Dialogtyp                            */
  UFSL_INIT		fontsel_init;     /* Initialisierungsfunktion (Dummy)     */
  UFSL         fontsel_input;    /* Standard-Selektorfunktion            */
  OBJECT       *helpbutton;      /* Hilfe-Knopf (BOXTEXT), maximale      */
                                 /* Textlnge 9 Zeichen (OHNE Prfung!). */
  UFSL_HELP    helpfunc;         /* Eigene Hilfefunktion                 */
  UBYTE        *examplestr;      /* Beispieltext fr Fontdarstellung     */
  MSGFUNC      msgfunc;          /* Redrawfunktion                       */
  NUFSL        fontsel_exinput;  /* Neuer Standard-Selektor              */
  XUFSL        font_selexinput;  /* Extended-Selektorfunktion            */
} xUFSL_struct;

#endif
