.\" @(#) mgif 1.0 90/12/16 rosenkra
.\" name,sec,chapter,version,date,format style
.TH MGIF 1 "" "" "" ONLINE
.SH NAME
mgif \- display a GIF image in monochrome
.SH SYNOPSIS
.\"	mgif [ -sn ] [ -dn ] [ -e ] [ -i ] [ -m ] [ -xn ] [ -yn ]
.\"     [ -N ] [ +90 | -90 ] [ -o file ] file ...
.\"
.\"	mgif -q [ -h ] file ...
.B mgif
[
.B \-s\fIn
] [
.B \-d\fIn
] [
.B \-e
] [
.B \-i
] [
.B \-m
] [
.B \-x\fIn
] [
.B \-y\fIn
]
.br
[
.B \-N
] [
.B +90
|
.B \-90
] [
.B \-o
.I file
]
.IR file ...
.sp
.B mgif
.B \-q
[
.B \-h
]
.IR file ...
.SH DESCRIPTION
.B Mgif
displays color GIF images on a monochrome ST display.
It uses Floyd-Steinberg dithering to simulate color.
GIF files carry the extensions \*(lq.gif\*(rq and are compressed using
LZW codes.
.B Mgif
allows you to increase or decrease the overall "brightness" of the image
(see the
.B \-s
flag) as well as do any combination of invert (swap black and white pixels),
rotate +90 or -90 degress, mirror (left to right),
or enlarge small images (expand by a factor of
2 in both width and height).
.PP
.B Mgif
also plots (or prints) a histogram of intensities.
If not using the
.B \-q
option (inquiry), the
.B mgif
plots the histogram in two formats: 1) in "color map" order (i.e. increasing
values in the vertical axis are the index into the color map), and 2) in
"intensity" order (i.e. increasing values in the vertical axis are intensities
from the color map).
.SH OPTIONS
.IP "\fB\-q\fR"
Inquire about the file but do not display it.
Output contains information like image size, number of bits per pixel,
the color maps, and
whether or not the image is interlaced or sequential.
.IP "\fB\-h\fR"
Along with the inquiry, also produce a printed histogram.
Specifying
.B \-h
also forces
.BR \-q .
.IP "\fB\-s\fIn\fR"
Specify the scale factor to apply to the image.
Values for
.I n
can range from 1 to 100.
The higher numbers make the image lighter while lower numbers make the image
appear darker.
The default value is 50.
.IP "\fB\-d\fIn\fR"
Specify the device intensity.
Typical values for
.I n
can be from 24 to 2000.
By default, this value is defined as 3 * (1 << bits).
Use higher numbers for images with more bits per pixel (e.g. -d1000 for
5 or 6 bits, -d2000 for 7 or 8 bits).
Both
.B \-d
and
.B \-s
pretty much accomplish the same thing.
.IP "\fB\-e\fR"
Expand smaller images to fit the screen.
This is only for 320 x 200 (or smaller) images.
.IP "\fB\-i\fR"
Invert the image, i.e. reverse black and white pixels.
.IP "\fB\-m\fR"
Mirror image.
.IP "\fB\-x\fIn\fR"
Starting location of original image, x coordinate.
This will map as much of the original image starting at this point
to the screen.
If the entire image fits on the screen as is (or enlarged), this value is
ignored.
.IP "\fB\-y\fIn\fR"
Starting pixel of original image, y coordinate.
.IP "\fB\-N\fR"
Use the classic NTSC equation for computing luminescense from RGB values,
that is:
.sp
.RS
lum = 0.299 R + 0.587 G + 0.114 B
.RE
.sp
Otherwise the values are unweighted.
This option only makes sense for files with color maps in which the
entry for each color uses different values for red, green, and blue.
I have never seen a GIF file like this (yet).
.IP "\fB+90\fR"
Rotate image 90 degrees counter-clockwise.
.IP "\fB\-90\fR"
Rotate image 90 degrees clockwise.
.IP "\fB\-o\fR \fIfile\fR"
Output a PI3 file called
.IR file .
.IP "\fIfile\fR"
One or more GIF files, though all will use the same values of scale factor
and device intensity.
It is best to do more than one file only if each of the images uses the
same number of bits per pixel.
.SH FILES
.nf
*.gif     GIF image files
.fi
.SH "SEE ALSO"
gif(5)
.br
Burger and Gillies, Interactive Computer Graphics (dithering)
.SH DIAGNOSTICS
Various warnings attempting to isolate corrupted files.
The usual messages about errors openning files, etc.
.SH NOTES
You can exit during the image drawing portion (which takes the longest)
by entering any key.
.SH BUGS
There should be no need for the
.B \-d
option.
.PP
Panning of large images (.i.e
.B \-x
and
.BR \-y )
is not complete.
.SH AUTHOR
.nf
Bill Rosenkranz
rosenkra@convex.com
.fi
.SH VERSION
mgif 1.0 90/12/16 rosenkra
.EX
