/****************************************************************/
/* File name:	WHEREIS.C	Revised:	1990.11.28	*/
/* Revised by:	U.R. Andersson	Sozoboned:	1990.11.27	*/
/* Copyright:	(c)1990 Les Kneeling, all rights reserved.	*/
/*   but...	Rights for non-commercial uses released to PD.	*/
/****************************************************************/

/*
 *--------------------------------------------------------------------------
 *  WHEREIS? - by Les Kneeling
 *
 *  Lost a file? Don't know which folder it is in? Give the file name to
 *  WHEREIS? and it will search all of the disk for it. When it finds an
 *  exact match for the filename it will display the full path on screen.
 *  WHEREIS? will find all of the files with the specified name on the
 *  disk. Only exact matches will be found.
 *
 *  Sorry about the readability of the code but it was the only way I
 *  could get it into 22 lines. (expanded now. U.R. Andersson)
 *--------------------------------------------------------------------------
 * Ported to Sozobon C by U.R. Andersson, and at the same time improved
 * to allow multiple searches on multiple drives with wildcard filenames.
 *--------------------------------------------------------------------------
 */

#include	<stdio.h>	/* WHEREIS.TTP - search a disk for a file(s) */ 
#include	<osbind.h>	/* Written in Laser C by Les Kneeling	     */
#include	<string.h>	/* Ported to Sozobon C by U.R. Andersson     */
#include	<ctype.h>

typedef	struct	dta
{	char	r[21];
	char	fattr;
	char	r2[8];
	char	fname[14];
} DTA;

char	spec[15], path[160];

int	foundct;

main( argc, argv )
int	argc;
char	**argv;
{	int	done = 0;
	do {	foundct = 0;
		if (done || argc != 2)
		{	perrorf("Must have a file specifier, to seek.");
			perrorf("Drive specifier optionally included.");
			printf("File = ");
			scanf("%14s", spec);
		}
		else
			strncpy( spec, argv[1],14);
		spec[14] = '\0';
		if (*spec == '\0')
		{	perrorf("NULL drivespec, means no work!");
			exit(0);
		}
		strcpy(path,"a:\\");
		if (isascii(*spec) && isalpha(*spec) && spec[1] == ':')
		{	*path = *spec;
			strcpy( spec, spec+2);
		}
		else
			*path += Dgetdrv();
		strcat(path, spec);
		locate( path );
		if (foundct == 0)
			perrorf("No matching files on drive %c: !", *path);
		puts("Done: <space> repeats, other key exits.");
		done = Crawcin();
	} while (done == ' ');
} /* ends main(argc, argv) */

locate( path )
char *path;
{	DTA	newdta;
	int	error;
	char	newpath[160];
	char	temp[160];
	char	*tp;
	strcpy( newpath, path );
	Fsetdta( &newdta );
	tp = strrchr( newpath, '\\');
	error = Fsfirst( newpath, 0x0 );
	while(!error)
	{	*tp = '\0';
		printf("Found: %s\\%s\n", newpath, newdta.fname);
		*tp = '\\';
		foundct++;
		error = Fsnext();
	}
	*strrchr( newpath, '\\' ) = '\0';
	strcat( newpath, "\\*.*" );
	error = Fsfirst( newpath, 0x10 );
	while(!error)
	{	if( (newdta.fattr & 0x10) && (newdta.fname[0] != '.') )
		{	strcpy(temp,newpath);
			sprintf( strrchr( temp, '\\' ),
				"\\%s\\%s", newdta.fname, spec );
			locate( temp );
			Fsetdta( &newdta );
		}
		error = Fsnext();
	}
} /* ends locate(path) */

/* End of:	WHEREIS.C	*/
