/*---------------------------------------------*/
/*                                             */ 
/*  Software zum GAL-Prommer  V 1.0 (08.11.89) */
/*                                             */
/*            Autor: Thomas Werner             */
/*                                             */
/*       (c) MAXON Computer GmbH, 1989         */
/*                                             */
/*---------------------------------------------*/

# include <stdio.h>
# include <tos.h>
# include <aes.h>

# define version  "V1.0 (08.11.89)"

# define timera     0     /* Daten fr Timer A */
# define contr_1ms  0x02  /* zum Erzeugen      */
# define contr_off  0     /* eines Interrupts  */
# define data_1ms   246   /* nach jeweils 1 ms */

# define daten    0x8f
# define strobe   0x20

# define busyort  0xfffa01L
# define busybit  0x01

# define j_groesse    2706
# define acw_groesse  82

/* Offset im ACW */
# define a_xor1 49
# define a_xor2 35
# define a_ac1  44
# define a_fg1  0
# define a_fg2  50
# define a_syn  45
# define a_ac0  36

# define init_r1  0x0
# define edit_aus 0xf3
# define spg_aus  0x03
# define r_in     0x80
# define r2       0x40
# define r1       0x20

# define p_v      0x10    /* P_V-Leitung
                             im Register 1 */

# define p_v_time     1   /* ms mu P,V
                             anliegen */
# define z_end_time   1
# define str_time     10  /* ms mu STR anliegen
                             beim Programmieren*/
# define str_loeschen 50  /* ms mu STR anliegen
                             beim Lschen */

# define spg_wait       500 /* Wartezeit nach
                         Einschlaten der 5 V */
# define spg_aus_wait   50
# define edit_wait      500 /* Wartezeit nach
                      Einschalten der 16,5 V */
# define edit_aus_wait  50
# define zeile_wait     50  /* Wartezeit nach 
                     Setzten der neuen Zeile */

# define control_word 60  /* Reihe des ACW */
# define security     61  /* der Security Cell */
# define loesch       63  /* zum Lschen */

enum _bool
  {
    nein,
    ja
  };

enum _typ
  {
    gal16v8,
    gal20v8
  };

typedef enum _bool  JA_NEIN;
typedef enum _typ   typ_wahl;


typ_wahl  typ;

char  gal_text[2][5] = {"16v8", "20v8"},
      *an_text,
      zw_r2, zw_d,
      zeile,
      jedec[j_groesse],
      mask[8] = {0x80, 0x40, 0x20, 0x10, 0x08,
                 0x04, 0x02, 0x01},
      str[2]  = {0x08, 0x10},
      sclk[2] = {0x01, 0x02},
      sdin[2] = {0x02, 0x04};


int   zeil_end[2] = {32, 40},
      j_xor1[2] = {2048, 2560}, /* Adresse der */
      j_xor2[2] = {2052, 2564}, /* Felder in   */
      j_id[2] =   {2056, 2568}, /* im JEDEC-   */
      j_ac1[2] =  {2120, 2632}, /* File        */
      j_fg1[2] =  {2128, 2640},
      j_fg2[2] =  {2160, 2672},
      j_syn[2] =  {2192, 2704},
      j_ac0[2] =  {2193, 2705},
      eingabe;

/* Externe Funktion fr den Timer */
extern void wait_ir(void);

void Wait(char);
void Send(char, char);
void Init_Prommer(void);
void An_Prommer(void);
void Aus_Prommer(void);
void Setz_Zeile(int);
void Leeren(void);
int  Lade_Jedec(void);
void Brenn_Jedec(void);
void send_zeichen(char);
void schreib_reihe(void);
void Brennen(void);
void Sichern(void);
void Auslesen(void);

/*---------------------------------------------*/
/*                                             */ 
/*                Hauptprogramm                */
/*                                             */ 
/*---------------------------------------------*/

int main () 

{ 
  Init_Prommer();
  typ = gal16v8;
  for (;;)
  {
    printf("\n\n\n****** Gal-Prommer-Software "
                        "%s ******\n", version);
    printf("               von Thomas Werner\n");
    printf("         "
              "(c) MAXON Computer GmbH, 1989\n");
    printf("\n1. Typ wechseln (zur Zeit: %s)\n",
                                  gal_text[typ]);
    printf("2. Gal lschen\n");
    printf("3. Gal brennen\n");
    printf("4. Gal sichern\n");
    printf("5. Gal auslesen\n");
    printf("\n9. Ende\n");
    printf("\nWas darf's denn sein?");
    switch((char) Crawcin())
    {
      case '1':
        Aus_Prommer();
        typ = (typ) ? gal16v8 : gal20v8;
      break;
      case '2':
        Leeren();
      break;
      case '3':
        Brennen();
      break;
      case '4':
        Sichern();
      break;
      case '5':
        Auslesen();
      break;
      case '9':
        Aus_Prommer();
        Init_Prommer();
        return 0;
      default:
        printf("\n\nHab' ich leider nicht!!!\n");
        
    }
    printf("\n\nWeiter mit Taste.");
    Crawcin();  
  }
}



/*---------------------------------------------*/
/*                                             */ 
/*              zeit ms warten                 */
/*                                             */ 
/*---------------------------------------------*/

void Wait(char zeit)

{
  extern char wait_end; /* Ist im Assembler-
                           Teil definiert */
  wait_end = zeit;
  Xbtimer(timera, contr_1ms, data_1ms, wait_ir);
  while (wait_end);
  Xbtimer(timera, contr_off, data_1ms, wait_ir);
}


/*---------------------------------------------*/
/*                                             */ 
/*       Zeichen zu den Registern senden       */
/*                                             */ 
/* ziel:    Zielregister                       */
/* zeichen: Neuer Registerinhalt               */
/*                                             */ 
/*---------------------------------------------*/

void Send(char ziel, char zeichen)

{
  char  takt, out;
  int   i;
  
  for (i = 0; i < 8; i++)
  {
    out = (zeichen & mask[i]) ? zw_d|r_in : zw_d;
    Giaccess(out, daten);
    takt = out | ziel;        /* der Takt */
    Giaccess(takt, daten);
  }
  Giaccess(zw_d, daten);
  Wait(1);
  Ongibit(strobe);
  Offgibit(~strobe);
}


/*---------------------------------------------*/
/*                                             */ 
/*          Prommerinitialisierung             */
/*                                             */ 
/* Daten- und Strobeleitungen, Register und    */
/* Spannungen werden gelscht                  */
/*                                             */ 
/*---------------------------------------------*/

void Init_Prommer()

{
  Offgibit(~strobe);    /* Strobe lschen*/
  zw_d = 0x0;
  Giaccess(zw_d, daten); /* Datenleit. lschen*/
  Aus_Prommer();
}

/*---------------------------------------------*/
/*                                             */ 
/*          Spannungen einschalten             */
/*                                             */ 
/*---------------------------------------------*/
  
void An_Prommer()

{
  char spgan[2] = {0xfd, 0xfe}; 
                /* Bit zum einschalten der 5V */
  char editan[2] ={0x08, 0x04};
            /* Bit zum Einschalten der 16,5 V */
  char d2_an = 0xdf;
    
  printf("\n\n%s ", an_text);
  printf("Bitte Gal %s einstecken und "
                "Taste drcken.", gal_text[typ]);
  Crawcin();
  zw_r2 = (typ) ? zw_r2 & d2_an : zw_r2 | ~d2_an;
  zw_r2 = zw_r2 & spgan[typ];
  Send(r2, zw_r2);
  zw_d = zw_d | str[typ];
  Giaccess(zw_d, daten);  
                    /* Str setzen (low aktiv) */
  Wait(spg_wait);
  zw_r2 = zw_r2 | editan[typ];
  Send(r2, zw_r2);
  Wait(edit_wait);
}


/*---------------------------------------------*/
/*                                             */ 
/* Register initialisieren und                 */
/* Spannungen ausschalten                      */
/*                                             */ 
/*---------------------------------------------*/

void Aus_Prommer()

{
  Setz_Zeile(0);
        /* Register 1 initialisieren (lschen) */
  zw_r2 = zw_r2 & edit_aus;
  Send(r2, zw_r2);
     /* Register 2 initialisieren (Spg lschen)*/
  Wait(edit_aus_wait);
  zw_d = zw_d & ~str[typ]; 
  Giaccess(zw_d, daten);        /* Str lschen */
  zw_r2 = zw_r2 | spg_aus;
  Send(r2, zw_r2);
  Wait(spg_aus_wait);
}


/*---------------------------------------------*/
/*                                             */ 
/*    Zeile zum Lesen oder Schreiben setzen    */
/*                                             */ 
/* zeile: neue Zeilennummer                    */
/*                                             */ 
/*---------------------------------------------*/

void Setz_Zeile(int zeile)

{
  char adr = 0;
  
  if (typ)       /* Reihenadresse beim GAL20v8 */
  {
    adr = zeile & mask[7];
    adr = adr | ((zeile & mask[5])>>1);
    adr = adr | ((zeile & mask[4])>>1);
    adr = adr | ((zeile & mask[3])<<1);
    adr = adr | ((zeile & mask[6])<<5);
    zw_d = (zw_d & ~mask[7]) 
                        | ((zeile & mask[2])>>5);
    Giaccess(zw_d, daten);
  }
  else            /*Reihenadresse beim GAL16v8 */
  {
    adr = zeile;
  }
  Send(r1, adr);
  Wait(zeile_wait);
}


/*---------------------------------------------*/
/*                                             */ 
/*                 Gal lschen                 */
/*                                             */ 
/*---------------------------------------------*/

void Leeren()

{
  printf("\n\nSoll Gal %s gelscht werden?",
                                  gal_text[typ]);
  eingabe = (char) Crawcin();
  if (eingabe == 'j')
  {
    an_text = "Zum Lschen:";
    An_Prommer();
    printf("\n\nLsche Gal %s...",gal_text[typ]);
    zw_r2 = zw_r2 | p_v;
    Send(r2, zw_r2);
               /* P,V zum Programmieren setzen */
    Setz_Zeile(loesch);   
                      /* Reihe 63 (Bulk Erase) */
    Wait(p_v_time);
    Giaccess((zw_d | sdin[typ])&~str[typ],daten);
                         /* Reihe 63 schreiben */
    Wait(str_loeschen);
    Giaccess(zw_d, daten);
                   /* alten Zustand herstellen */
    zw_r2 = zw_r2 & ~p_v;
    Send(r2, zw_r2);
    Wait(p_v_time);
    Aus_Prommer();
    printf("\n\nGal %s ist gelscht.",
                                  gal_text[typ]);
  }
}


/*---------------------------------------------*/
/*                                             */ 
/*              JEDEC-Datei laden              */
/*                                             */ 
/* jedec: Brennmatrix                          */
/*                                             */ 
/*---------------------------------------------*/

int Lade_Jedec()

{
  int     i, ort, index;
  char    zahl[4], name[20], zeichen;
  JA_NEIN weiter;
  FILE    *j_file;
  
  printf("\n\nBitte vollstndigen Namen "
         "(Laufwerk, Ordner und Dateiname) "
         "eingeben:\n");
  gets(name);
  j_file = fopen(name, "r");
  if (!j_file)
  {
    printf("\n\nFile %s konnte nicht geffnet "
                              "werden!\n", name);
    return (1);
  }
  else
    for(;;)
    {
      switch(getc(j_file))
      {
        case 'F':
          zeichen = getc(j_file);
          for (i = 0; i < j_groesse; i++)
            jedec[i] = zeichen;
        break;
         
        case 'L':
          for (i = 0; i < 4; i++)
            zahl[i] = getc(j_file);
          index = 0;
          sscanf(zahl, "%d", &ort);
          weiter = ja;
          do
          {
            zeichen = getc(j_file);
            switch(zeichen)
            {
              case '0':
              case '1':
                jedec[ort + index++] = zeichen;
              break;

              case  EOF:
                return (0);

              case '*':
                weiter = nein;
            }
          }
          while (weiter);
        break;
        
        case 'C' :
          i = 0;
          while (getc(j_file), i++, i < 4);
        break;

        case '\x03' :
          i = 0;
          while (getc(j_file), i++, i < 4);
        break;

        case EOF :
          return (0);
      }
    } 
}


/*---------------------------------------------*/
/*                                             */ 
/*                Jedec-Brennen                */
/*                                             */ 
/*          Brennt Jedec-Datei ins Gal         */
/*                                             */ 
/*---------------------------------------------*/

void Brenn_Jedec()

{
  int zeile, spalte, i;
  char acw[acw_groesse];
    
  printf("\n\nBrenne Gal %s", gal_text[typ]);
  zw_r2 = zw_r2 | p_v;
  Send(r2, zw_r2);
               /* P-V zum Programmieren setzen */
  Wait(p_v_time);
                       /* Logik-Matrix brennen */
  for (zeile = 0; zeile < zeil_end[typ]; zeile++)
  {
    Setz_Zeile(zeile);
    for (spalte = 0; spalte < 64; spalte++)
      send_zeichen(jedec[(spalte * zeil_end[typ])
                                       + zeile]);
    printf(".");
    schreib_reihe();
  }
                                 /* ID brennen */
  Setz_Zeile(zeil_end[typ]);
  for (spalte = 0; spalte < 64; spalte++)
    send_zeichen(jedec[j_id[typ] + spalte]);
  printf(".");
  schreib_reihe();
                              /* ACW erstellen */
  for (i=0; i<4; i++)
    acw[a_xor1-i] = jedec[j_xor1[typ]+i];
  for (i=0; i<4; i++)
    acw[a_xor2-i] = jedec[j_xor2[typ]+i];
  for (i=0; i<8; i++)
    acw[a_ac1-i] = jedec[j_ac1[typ]+i];
  for (i=0; i<32; i++)
    acw[a_fg1+i] = jedec[j_fg1[typ]+i];
  for (i=0; i<32; i++)
    acw[a_fg2+i] = jedec[j_fg2[typ]+i];
  acw[a_syn] = jedec[j_syn[typ]];
  acw[a_ac0] = jedec[j_ac0[typ]];
                                /* ACW brennen */
  Setz_Zeile(control_word);
  for (i=0 ; i < acw_groesse ; i++)
      send_zeichen(acw[i]);
  printf(".");
  schreib_reihe();
  zw_d = zw_d & ~sdin[typ];
  Giaccess(zw_d, daten);
  zw_r2 = zw_r2 & ~p_v;
  Send(r2, zw_r2);
  printf("\n\nBin fertig mit Brennen.");
}


/*---------------------------------------------*/
/*                                             */ 
/*            Zeichen zum GAL senden           */
/*                                             */ 
/*---------------------------------------------*/

void send_zeichen(char zeichen)

{
  zw_d = (zeichen == '0') 
          ? zw_d & ~sdin[typ] : zw_d | sdin[typ];
  Giaccess(zw_d, daten);
  Giaccess(zw_d | sclk[typ], daten);
  Giaccess(zw_d, daten);
}


/*---------------------------------------------*/
/*                                             */ 
/*            Reihe ins GAL brennen            */
/*                                             */ 
/*---------------------------------------------*/

void schreib_reihe()

{
  Giaccess(zw_d & ~str[typ], daten);
                            /* Reihe schreiben */
  Wait(str_time);
  Giaccess(zw_d, daten);
                   /* alten Zustand herstellen */
}


/*---------------------------------------------*/
/*                                             */ 
/*               Gal brennen                   */
/*                                             */ 
/* Brennmatrix wird Jedec-Datei entnommen      */
/*                                             */ 
/*---------------------------------------------*/

void Brennen()

{
  if (Lade_Jedec() == 0)
   {
    an_text = "Zum Brennen:";
    An_Prommer();
    Brenn_Jedec();
    Aus_Prommer();
  }
}

/*---------------------------------------------*/
/*                                             */ 
/*     Logik-Matrix gegen auslesen sichern     */
/*                                             */ 
/*        Security-Cell wird gebrannt          */
/*                                             */ 
/*---------------------------------------------*/

void Sichern()

{
  printf("\n\nSoll Gal %s gegen auslesen "
             "geschtzt werden?", gal_text[typ]);
  eingabe = (char) Crawcin();
  if (eingabe == 'j')
  {
    an_text = "Zum Sichern:";
    An_Prommer();
    printf("\n\nSichere Gal %s..",gal_text[typ]);
    Send(r2, zw_r2 | p_v);
               /* P-V zum Programmieren setzen */
    Setz_Zeile(security);
                       /* Reihe 61 (Sicherung) */
    Wait(p_v_time);
    Giaccess((zw_d | sdin[typ])&~str[typ],daten);
    Wait(str_time);      /* Reihe 61 schreiben */
    Giaccess(zw_d, daten);
                   /* alten Zustand herstellen */
    Send(r2, zw_r2);
    Aus_Prommer();
    printf("\n\nGal %s ist gesichert!",
                                  gal_text[typ]);
  }
}


/*---------------------------------------------*/
/*                                             */ 
/*                Gal auslesen                 */
/*                                             */ 
/*---------------------------------------------*/

void Auslesen()

{
  int zeile, spalte;
  char inhalt[j_groesse];
  char acw_in[acw_groesse];
  char *busy = (char *)busyort;
  long old_super_stack;
  
  an_text = "Zum Auslesen:";
  An_Prommer();
  printf("\n\nLese Gal %s", gal_text[typ]);
  old_super_stack = Super(0L);
  for (zeile = 0; zeile < zeil_end[typ]; zeile++)
  {
    Setz_Zeile(zeile);
    Giaccess(zw_d & ~str[typ], daten);
    Giaccess(zw_d, daten);
    for (spalte = 0; spalte < 64; spalte++)
    {
      inhalt[(spalte * zeil_end[typ]) + zeile] =
                   (*busy & busybit) ? '-' : '*';
      Giaccess(zw_d | sclk[typ], daten);
      Giaccess(zw_d, daten);
    }
    printf(".");
  }
  Setz_Zeile(zeil_end[typ]);
  Giaccess(zw_d & ~str[typ], daten);
  Giaccess(zw_d, daten);
  for (spalte = 0; spalte < 64; spalte++)
  {
    inhalt[(64 * zeil_end[typ]) + spalte] =
                   (*busy & busybit) ? '1' : '0';
    Giaccess(zw_d | sclk[typ], daten);
    Giaccess(zw_d, daten);
  }
  printf(".");
  Setz_Zeile(control_word);
  Giaccess(zw_d & ~str[typ], daten);
  Giaccess(zw_d, daten);
  for (spalte = 0; spalte < acw_groesse; spalte++)
  {
    acw_in[spalte] = (*busy & busybit) ? '1':'0';
    Giaccess(zw_d | sclk[typ], daten);
    Giaccess(zw_d, daten);
  }
  printf(".");
  Super((void *)old_super_stack);
  Aus_Prommer();

  printf("\n\nInhalt des Gal %s :\n\n",
                                  gal_text[typ]);
  printf("Reihe                   Fusematrix\n");
  for (spalte=0; spalte<64; spalte++)
  {
    printf("%2d:", spalte);
    for (zeile=0; zeile < zeil_end[typ];zeile++)
    {
      if ((zeile % 4 ==0) & (zeile != 0)) 
        printf ("|");
      else
        if (zeile % 2 ==0) printf(" ");
      printf("%c",inhalt[(spalte * zeil_end[typ]) 
                                       + zeile]);
    }
    printf("\n");
    if ((spalte + 1) % 8 == 0)
    {
      Crawcin();
      printf("\n");
    }
  }
  printf("ID: ");
  for (spalte = 0; spalte < 64; spalte++)
  printf("%c", inhalt[(64 * zeil_end[typ])
                                      + spalte]);
  printf("\n\nPTD: ");
  for (spalte = 0; spalte < 32; spalte++)
    printf("%c", acw_in[spalte]);
  for (spalte = 50; spalte < 82; spalte++)
    printf("%c", acw_in[spalte]);
  printf("\n\nXOR (12 - 19): ");
  for (spalte = 49; spalte > 45; spalte--)
    printf("%c", acw_in[spalte]);
  for (spalte = 35; spalte > 31; spalte--)
    printf("%c", acw_in[spalte]);
  printf("\n\nAC1 (12 - 19): ");
  for (spalte = 44; spalte > 36; spalte--)
    printf("%c", acw_in[spalte]);
  printf("\n\nAC0: %c    SYN: %c", 
                         acw_in[36], acw_in[45]);
}