

/****************************************/
/* fader.c                              */
/*                                      */
/* Written by Mike Fulton               */
/* Last modified 6:15pm, 7/24/92        */
/****************************************/

#include <aes.h>
#include <osbind.h>

#include "sndbind.h"

#include "scroll.h"
#include "fader.h"

/*****************************************************************************/

#define MAX_GAIN_VALUE 15
#define MAX_ATTEN_VALUE 15

/*****************************************************************************/

short prescale, lf_gain, rt_gain, lf_atten, rt_atten;
char wkstr[300];

/*****************************************************************************/

OBJECT *obj_addr;
short xdial, ydial, wdial, hdial;

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/

ScrollBox fader_slider[] = {
	ATTEN_L_SLIDER, ATTEN_L_SCROLL, ATTEN_L_UP, ATTEN_L_DOWN,
	0, 0, 0, MAX_ATTEN_VALUE, 0L, 1, 0, 0, 0, 1, 0L, 0L,

	ATTEN_R_SLIDER, ATTEN_R_SCROLL, ATTEN_R_UP, ATTEN_R_DOWN,
	0, 0, 0, MAX_ATTEN_VALUE, 0L, 1, 0, 0, 0, 1, 0L, 0L,

	GAIN_L_SLIDER, GAIN_L_SCROLL, GAIN_L_UP, GAIN_L_DOWN,
	0, 0, 0, MAX_GAIN_VALUE, 0L, 1, 0, 0, 0, 1, 0L, 0L,

	GAIN_R_SLIDER, GAIN_R_SCROLL, GAIN_R_UP, GAIN_R_DOWN,
	0, 0, 0, MAX_GAIN_VALUE, 0L, 1, 0, 0, 0, 1, 0L, 0L,
};

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/

void
main()
{
short snd_status;

	appl_init();

	graf_mouse( BUSY_BEE, 0L );
	rsrc_load( "FADER.RSC" );
	graf_mouse( ARROW, 0L );


	snd_status = (short)locksnd();

	if( snd_status == 1 )
	{
		fader_control();
		unlocksnd();
	}
	else
	{
		form_alert( 1, "[1][Sound System locked! | ][ Exit ]" );
	}

	rsrc_free();
	appl_exit();
}

void
mouse_info( x, y, b )
short *x, *y, *b;
{
short k;

	graf_mkstate( x, y, b, &k );
}

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/

void
obj_draw( obj )
short obj;
{
	objc_draw( obj_addr, obj, MAX_DEPTH, xdial, ydial, wdial, hdial );
}

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/

void
set_sound()
{

	lf_atten = (fader_slider[0].value << 4) & 0x00f0;
	rt_atten = (fader_slider[1].value << 4) & 0x00f0;

	lf_gain = (fader_slider[2].value << 4) & 0x00f0;
	rt_gain = (fader_slider[3].value << 4) & 0x00f0;

	soundcmd( LTATTEN, lf_atten );
	soundcmd( RTATTEN, rt_atten );

	soundcmd( LTGAIN, lf_gain );
	soundcmd( RTGAIN, rt_gain );

	soundcmd( ADDERIN, 2 );
	soundcmd( ADCINPUT, 0 );
}

void
fader_control()
{
short exit_obj, doubleclick, slider, obj;

static short prescale_values[] = {
	1, 2, 3, 4, 5, 7, 9, 11
};

static short prescale_buttons[] =
{
	SAMPLE_RATE_50,SAMPLE_RATE_33,SAMPLE_RATE_25,SAMPLE_RATE_20,
	SAMPLE_RATE_16,SAMPLE_RATE_12,SAMPLE_RATE_10,SAMPLE_RATE_8
};

/**************/

	rsrc_gaddr( R_TREE, CODEC_CONTROL, &obj_addr );

/**************/

	prescale = prescale_values[0];
	obj_addr[prescale_buttons[0]].ob_state |= SELECTED;

	devconnect( 3, 8, 0, prescale, 1 );

	soundcmd( LTATTEN, 0 );
	soundcmd( RTATTEN, 0 );

	soundcmd( LTGAIN, 0 );
	soundcmd( RTGAIN, 0 );

	soundcmd( ADDERIN, 2 );
	soundcmd( ADCINPUT, 0 );

/**************/

	init_slider( &fader_slider[0], 0, 100, MAX_GAIN_VALUE );
	init_slider( &fader_slider[1], 0, 100, MAX_GAIN_VALUE );
	init_slider( &fader_slider[2], 0, 100, MAX_ATTEN_VALUE );
	init_slider( &fader_slider[3], 0, 100, MAX_ATTEN_VALUE );

	rsrc_gaddr( R_TREE, CODEC_CONTROL, &obj_addr );

	wind_update( BEG_UPDATE );

	form_center( obj_addr, &xdial, &ydial, &wdial, &hdial );
	form_dial( 0, 0, 0, 0, 0, xdial, ydial, wdial, hdial );
	form_dial( 1, 0, 0, 0, 0, xdial, ydial, wdial, hdial );
	objc_draw( obj_addr, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial );

	do
	{
		exit_obj = form_do( obj_addr, -1 );
		doubleclick = exit_obj & 0x8000;
		exit_obj &= 0x7fff;

		for( slider = 0; slider < 4;  slider++ )
		{
			if( process_scroll( &fader_slider[slider], exit_obj ) )
			{
				set_slider( &fader_slider[slider], 1 );
				set_sound();
			}
			else if( exit_obj != EXIT_THE_DIALOG )
			{
				for( obj = 0; obj < 8; obj++ )
				{
					if( exit_obj == prescale_buttons[obj] )
					  prescale = prescale_values[obj];
				}
				devconnect( 3, 8, 0, prescale, 1 );
			}
		}
	}
	while( exit_obj != EXIT_THE_DIALOG );

	form_dial( 2, 0, 0, 0, 0, xdial, ydial, wdial, hdial );
	form_dial( 3, 0, 0, 0, 0, xdial, ydial, wdial, hdial );
	wind_update( END_UPDATE );
}
