
#include <aes.h>
#include "scroll.h"

/*****************************************************************************/

extern OBJECT *obj_addr;

/*****************************************************************************/

void
set_slider( scr, drawflag )
ScrollBox *scr;
short drawflag;
{
long x, z;
OBJECT *scroll, *slider;

	scroll = &obj_addr[scr->scrollobj];
	slider = &obj_addr[scr->sliderobj];

	x = (long)(scr->value) * 1000L;
	z = (long)scr->maxvalue;

	if( (x > 0) && z )
	  scr->sliderpos = (short)(x / z);
	else
	  scr->sliderpos = 0;

	if( scr->alignflag )
	{
		x = z = (long)scroll->ob_height;

		if( scr->adj_size )
		{
			x *= scr->slidersize;
			x /= 1000;
			slider->ob_height = (short)x;
		}
		else
		  x = slider->ob_height;

		x = z - x;
		x *= scr->sliderpos;
		x /= 1000;

		if( ! scr->inverted )
		  slider->ob_y = (short)x;
		else
		  slider->ob_y = scroll->ob_height - slider->ob_height - (short)x;
	}
	else
	{
		x = z = (long)scroll->ob_width;

		if( scr->adj_size )
		{
			x *= scr->slidersize;
			x /= 1000;
			slider->ob_width = (short)x;
		}
		else
		  x = slider->ob_width;

		x = z - x;
		x *= scr->sliderpos;
		x /= 1000;

		if( ! scr->inverted )
		  slider->ob_x = (short)x;
		else
		  slider->ob_x = scroll->ob_width - slider->ob_width - (short)x;
	}

	if( scr->val )
	{
		if( (scr->value <= scr->maxvalue) && (scr->value >= 0) )
		  sprintf( scr->val, "%d", scr->value );
		else
		  sprintf( scr->val, "-" );
	}
	if( drawflag )
	  obj_draw( scr->scrollobj );
}

void
reset_slider( scr, val, drawflag )
ScrollBox *scr;
short val, drawflag;
{
	scr->value = val;
	set_slider( scr, drawflag );
}

void
init_slider( scr, val, numshown, numitems )
ScrollBox *scr;
short val, numshown, numitems;
{
TEDINFO *teddy;

	scr->value = val;
	scr->numshown = numshown;
	scr->numitems = numitems;

	if( scr->adj_size )
	{
		scr->maxvalue = (numitems + 1 - numshown);
		scr->slidersize = ((5+(scr->numshown * 1000)) / scr->numitems);
	}

	if( obj_addr[scr->sliderobj].ob_type == G_BOXTEXT )
	{
		teddy = (TEDINFO *)obj_addr[scr->sliderobj].ob_spec;
		scr->val = teddy->te_ptext;
	}

	set_slider( scr, 0 );
}

void
scroll_bounds( scr )
ScrollBox *scr;
{
	if( scr->value > scr->maxvalue )
	  scr->value = scr->maxvalue;

	if( scr->value < 0 )
	  scr->value = 0;
}


short
process_scroll( scr, obj )
ScrollBox *scr;
short obj;
{
short xpos, ypos, button, obj_x, obj_y, obj_bottom;
long tmp;

	if( obj == scr->sliderobj )
	{
		scr->sliderpos = graf_slidebox( obj_addr, scr->scrollobj, scr->sliderobj, scr->alignflag );

		if( scr->inverted )
		  scr->sliderpos = 1000 - scr->sliderpos;

		tmp = ((long)scr->maxvalue * (long)scr->sliderpos) / 1000L;
		scr->value = (short)tmp;

		scroll_bounds( scr );
		return(1);
	}

	if( obj == scr->scrollobj )
	{
		mouse_info( &xpos, &ypos, &button );
		objc_offset( obj_addr, scr->sliderobj, &obj_x, &obj_y );

		if( scr->alignflag )
		{
			obj_bottom = obj_y + obj_addr[scr->sliderobj].ob_height;
			if( scr->inverted )
			{
				if( ypos < obj_y )
				  scr->value += scr->numshown;
				if( ypos > obj_bottom )
				  scr->value -= scr->numshown;
			}
			else
			{
				if( ypos < obj_y )
				  scr->value -= scr->numshown;
				if( ypos > obj_bottom )
				  scr->value += scr->numshown;
			}
		}
		else
		{
			obj_bottom = obj_x + obj_addr[scr->sliderobj].ob_width;

			if( scr->inverted )
			{
				if( xpos < obj_x )
				  scr->value -= scr->numshown;
				if( xpos > obj_bottom )
				  scr->value += scr->numshown;
			}
			else
			{
				if( xpos < obj_x )
				  scr->value += scr->numshown;
				if( xpos > obj_bottom )
				  scr->value -= scr->numshown;
			}

		}
		scroll_bounds( scr );
		return(1);
	}

	if( obj == scr->up_arrow )
	{
		if( scr->mv_up )
		{
			(*scr->mv_up)();
		}
		else
		{
			if( scr->inverted )
			  scr->value++;
			else
			  scr->value--;
		}

		scroll_bounds( scr );
		return(1);
	}

	if( obj == scr->down_arrow )
	{
		if( scr->mv_dwn )
		{
			(*scr->mv_dwn)();
		}
		else
		{
			if( scr->inverted )
			  scr->value--;
			else
			  scr->value++;
		}

		scroll_bounds( scr );
		return(1);
	}

	return(0);
}

