/*
         Name: LOD to binary
         Type: C
       Author: Fredrik Noring
      Version: 0.9
 Date Entered: 22 April 1995
  Last Change: 11 June 1995

  Description: This program converts DSP 56001 LOD files to binary files.
*/

#define VERSION "v0.9"
#define LOD_BUF 96*1024

#define WORD short
#define LONG int

#include <stdio.h>
#include <string.h>
#include <osbind.h>
#include <falcon.h>

char LOD_buf[LOD_BUF];	/* LOD buffer */

int main(int argc, char **argv)
{
	long size;
	FILE *fp_o;
	char *name, *out, *error = NULL;

	switch (argc) {
		case 2:
			name = argv[1];
			out = "out.dsp";
			break;
		case 3:
			name = argv[1];
			out = argv[2];
			break;
		default:
			name = "";
			out = "";
	}

	if (!strcmp(name, "-v") || !strcmp(name, "-h")) {
		fprintf(stderr, "DSP 56001 LOD to binary converter "VERSION"\n");
		fprintf(stderr, "Usage: %s <LOD file> [output file]", argv[0]);
		return 0;
	}

	if ((fp_o = fopen(out, "wb")) == NULL)
		error = out;
	else {
		size = Dsp_LodToBinary(name, (char*) LOD_buf);
		if (size >= 0) {
			fwrite(LOD_buf, 3, (int) size, fp_o);
		} else {
			fprintf(stderr, "%s: An error occured during the "
			                "conversion process.\n", argv[0]);
		}
		fclose(fp_o);
	}

	if (error)
		fprintf(stderr, "%s: can\'t open \"%s\" file\n", argv[0], error);

	if (error)
		return -1;
	return 0 ;
}

