package dumpvar;

sub main'dumpvar {
    ($package) = @_;

    # This next line gives us an alias for the associative array
    # containing the symbol table for the specified package.

    local(*stab) = eval("*_$package");

    # Now that we have defined %stab, look at all the symbol
    # table entries it contains.

    while (($key,$val) = each(%stab)) {

	# Alias the particular symbol table entry.

	local(*entry) = $val;

	# Now check for different objects of that name.
	# Is there a scalar?

	if (defined $entry) {
	    print "\$$key = '$entry'\n";
	}

	# Is there a normal array?

	if (defined @entry) {
	    print "\@$key = (\n";
	    foreach $num ($[ .. $#entry) {
		print "  $num\t'",$entry[$num],"'\n";
	    }
	    print ")\n";
	}

	# Is there an associative array that isn't the one
	# we're currently iterating through?

	if ($key ne "_$package" && defined %entry) {
	    print "\%$key = (\n";
	    foreach $key (sort keys(%entry)) {
		print "  $key\t'",$entry{$key},"'\n";
	    }
	    print ")\n";
	}
    }
}
