#!/usr/local/bin/perl
######################################
#
# Picture Frame 1.0
# Written for the Web Page for Brian Wilson
# by Mike Wheeler
# mwheeler@command-o.com
#
# Copyright 1996, Mike Wheeler, All Rights Reserved
#
#If you find this script useful, we would appreciate a 
#donation to keep this service active for the community.
#Command-O Software, P.O. Box 12200, Jackson WY 83002
#
######################################
$title = "Freescripts Photo Gallery";
# This is the title of your page

$bgcolor = "ffffff";
# This is the background color for the pages this script creates

$border = "6";
# This is the size of the border you want around the large images.

$dir_url = "http://www.freescripts.com/demos/images";
# This is the url to the directory where the full size images are.

$tn_dir_url = "http://www.freescripts.com/demos/images/tn";
# This is the url to the directory where the thumbnail images are.
# The thumbnail images MUST have the same name as the full size images.

$tn_dir = "/usr/local/etc/httpd/htdocs/demos/images/tn";
# This is the path to the directory where the thumbnail images are.

$caption_file = "";
# This is the full path (including the file name to the captions file) of 
# the caption file if you choose to use one. Only images in the caption file 
# will be displayed. If you don't want captions leave this blank, and the 
# script will display every image in the $tn_dir and none will have captions.

$script_name = "picture_frame.pl";
# This is the script name, as you have it on your server.

$header = <<EOM;
<!-- begin header -->
<center><h1>Freescripts</h1>
<h2>Photo Gallery</h2>
</center>
<!-- end header -->
EOM
1;

# This is where you put the html that goes in the header. Everything MUST
# be after <!-- begin header --> and before <!-- end header --> You DO NOT
# need to put a backslash (\) before quotation marks or @ symbols.

$footer = <<EOM;
<!-- begin footer -->
Return to Freescripts <a href="$script_name"> Photo Gallery</a><p>
Return to the <a 
href="http://www.freescripts.com">Freescripts Main Page</a><p>

<!-- end footer -->
EOM
1;
# This is where you put the html that goes in the footer. Everything MUST
# be after <!-- begin footer --> and before <!-- end footer -->. You DO NOT
# need to put a backslash (\) before quotation marks or @ symbols.
#
# That's it!
# You must get my permission by e-mail (mwheeler@command-o.com)
# to change anything below this point.
#####################################
if ($ENV{'QUERY_STRING'} eq ""){
   &table;
   exit;
}
else {
   &display;
   exit;
}
#########################
# Display requested picture

sub display {

   $file = "$ENV{'QUERY_STRING'}";
   print "Content-type: text/html\n\n";
   print "<html><head><title>$title: $file</title></head>\n";
   print "<body bgcolor=$bgcolor>\n";
   print "$header\n";
   print "<p><hr><center><img border=$border src=\"$dir_url/$file\"></center><hr><p>\n";
   print "$footer\n";
   print "<hr>This script written by Mike Wheeler for <a 
href=\"http://command-o.com\">Command-O
Software</a>\n";
   print "</body></html>\n";
}
#######################
# Make table page

sub table {
   if ($caption_file ne "") {
      open(CAPS,"$caption_file");
      while (<CAPS>) {
        chop;
        ($key,$value) = split(/:/);
        $photos{$key} = $value;
      }
      close(CAPS);

      foreach (sort keys %photos) {
         push (@tnlist,$_);
         push (@captions,$photos{$_});
      }
   }
   else {
      opendir (TN, "$tn_dir");
      rewinddir (TN);
      @tnlist =  grep(!/^\.\.?$/, readdir (TN));
      closedir (TN);
      $temp = pop @tnlist;
      @tntemp = reverse(@tnlist);
      push (@tntemp,$temp);
      @tnlist = reverse(@tntemp);
   }

   $tnnum = @tnlist;
   $anum = int ($tnnum / 3);
   $bnum = ((($tnnum / 3) - $anum) * 3);
   print "Content-type: text/html\n\n";
   print "<html><head><title>$title</title></head>\n";
   print "<body bgcolor=$bgcolor>\n";
   print "$header\n";
      print "<hr><center><h3>Click on any image to see a full-size version of it</h3></center>\n";

   if ($bnum eq "0") {
      &main_table;
      &end;
   }
   if ($bnum eq "1") {
      &main_table;
      print "<hr><table width=100% border=5 cellpadding=3>\n";
      print "<tr align=center>\n";
      print "<td width=33%></td>\n";
      print "<td width=33%><a href=\"$script_name\?$tnlist[($anum * 3)]\"><img src=\"$tn_dir_url/$tnlist[($anum * 3)]\"></a><br>$captions[($anum * 3)]<br></td>\n";
      print "<td width=33%></td>\n";
      print "</tr></table><hr>\n";
   }
   if ($bnum eq "2") {
      &main_table;
      print "<hr><table width=100% border=5 cellpadding=3>\n";
      print "<tr align=center>\n";
      print "<td width=33%><a href=\"$script_name\?$tnlist[($anum * 3)]\"><img src=\"$tn_dir_url/$tnlist[($anum * 3)]\"></a><br>$captions[($anum * 3)]<br></td>\n";
      print "<td width=34%></td>\n";
      print "<td width=33%><a href=\"$script_name\?$tnlist[($anum * 3) + 1]\"><img src=\"$tn_dir_url/$tnlist[($anum * 3) + 1]\"></a><br>$captions[($anum * 3) + 1]<br></td>\n";
      print "</tr></table><hr>\n";
   }
   print "<center><h3>Click on any image to see a full-size version ofit</h3></center><hr>\n";
   print "$footer\n";
   print "<hr>This script written by <a href=\"http://gladstone.uoregon.edu/~mwheeler/cgi\">Mike Wheeler</a>\n";
   print "</body></html>\n";
}
sub main_table {
   $dnum = ($anum * 3);
   $cnum = "0";
   while ($dnum > $cnum) {
      print "<hr><table width=100% border=5 cellpadding=3>\n";
      print "<tr align=center>\n";
      print "<td width=33%><a href=\"$script_name\?$tnlist[$cnum]\"><img src=\"$tn_dir_url/$tnlist[$cnum]\"></a><br>$captions[$cnum]<br></td>\n";
      print "<td width=33%><a href=\"$script_name\?$tnlist[$cnum + 1]\"><img src=\"$tn_dir_url/$tnlist[$cnum + 1]\"></a><br>$captions[$cnum + 1]<br></td>\n";
      print "<td width=33%><a href=\"$script_name\?$tnlist[$cnum + 2]\"><img src=\"$tn_dir_url/$tnlist[$cnum + 2]\"></a><br>$captions[$cnum + 2]<br></td>\n";
      print "</tr></table>\n";
      $cnum = $cnum + 3;
      print "<hr>\n";
   }
}
