*-------------------------------------------------------------------------*		
*		copie de la rom TOS 4.04+modifs de la rom
*-------------------------------------------------------------------------*		
		TEXT
*-------------------------------------------------------------------------*		
		
		opt	o+,ow-,x-
		
		INCLUDE	BIOS.EQU
		INCLUDE	GEM.EQU
		
		include	FLASH.RS
		
		output	D:\EXECS\CT2A_1.ZAP

*-------------------------------------------------------------------------*		

		*-------------------*
debut:
		dc.b	"yop!"		;marque de dbut
		dc.l	reset_cpu
					;pour sauter dans la flash
		*-------------------*
reset_cpu		
		move    #$2700,sr
		
	* reset combel (et init chip-ram?)
		or.b	#$80,ct2_reg
		move.w  $FFFF8006.w,D0
		reset   
		or.b	#$80,ct2_reg
		move.w  $FFFF8006.w,D0

	* coupe le dcodage de la flash en $00xxxxxx
		;or.b	#$80,ct2_reg

	* coupe les GPIOs
		move.w  #7,$FFFF8940.w
		
	* teste cartouche diagnostique
		cmpi.l  #-$5ADDCA1,$FA0000
		bne.s   T_E0005A
		lea     T_E0005A(PC),A6
		jmp     $FA0004
	* init
T_E0005A:      
	* initialise FAST-RAM
		move.l	#-1,$f7308788		;init controleur

	* je pourrais mettre le setup ici...
		

	* ...et revenir pour sauter au TOS
	* voire carrement recopier la suite en RAM, aussi,
	* et comme a je pourrai cacher la flash
	
		move.l  #$808,D0
		movec.l D0,CACR
		moveq   #0,D0
		movec.l D0,VBR
	* pmmu
		pmove.l   $E49430,tc
		pmove.l   $E49430,tt0
		pmove.l   $E49430,tt1
	* vido
		move.w  #$20,$FFFF828C.w	;HSS
		move.w  #$10,$FFFF8282.w	;HHT
		
		move.b  #$25,$FFFF8007.w	;ste bus off+
					;blitter  fond+
					;bus  fond
	* dmarrage  froid?
		btst    #6,$FFFF8007.w
		
		beq.s   T_E000C8	;non...
		
		lea     T_E000A4(PC),A6
		jmp     $E00C1C
T_E000A4:      
		bne.s   T_E000C8
		move.b  $424.w,$FFFF8001.w ;memconf
T_E000AC:      
		cmpi.l  #$31415926,$426.w ;resvalid
		bne.s   T_E000C8
		move.l  $42A.w,D0       ;resvector
		btst    #0,D0
		bne.s   T_E000C8
		movea.l D0,A0
		lea     T_E000AC(PC),A6
		jmp     (A0)	;=>reset_vector

	* init yamaha
T_E000C8:      
		lea     $FFFF8800.w,A0  ;giselect
		move.b  #7,(A0)	;reg 7: mixer control
		move.b  #$C0,2(A0)	;port A et B out
		move.b  #14,(A0)	;reg 14: port A
		move.b  #7,2(A0)	;select drive a et b et face 2?
		
	* palette ST
		lea     $FFFF8240.w,A1  ;color0
		moveq   #15,D0
		lea     $E00C3A,A0
T_E000EA:      
		move.w  (A0)+,(A1)+
		dbra    D0,T_E000EA

	* palette Falcon
		move.b  #0,$FFFF8266.w
		lea     $FFFF9800.w,A1
		moveq   #15,D0
T_E000FC:      
		move.l  (A0)+,(A1)+
		dbra    D0,T_E000FC
		
	* vido pipo: ST BASSE en $10000
		move.b  #0,$FFFF8260.w  ;shiftmd: ST BASSE
				;=> pal st
		* adresse =$10000
		
		move.b  #1,$FFFF8201.w  ;dbaseh
		clr.b   $FFFF8203.w     ;dbasel

	* reset  froid, encore!
		bset    #6,$FFFF8007.w
		beq.s   T_E0013A
		
		cmpi.l  #$752019F3,$420.w ;memvalid
		bne.s   T_E0013A
		cmpi.l  #$237698AA,$43A.w ;memval2
		bne.s   T_E0013A
		cmpi.l  #$5555AAAA,$51A.w ;memval3
		beq     T_E001DA
T_E0013A:      
	* rinitialise la machine: reset  froid
		
	* Chip-Ram
		move.b	$ffff8006.w,d0
		lsr.b	#3,d0
		and	#%110,d0	;bits de config
		
		move.l	#1*1024*1024,d5
		lsl.l	d0,d5
		subq	#%100,d0
		blo.s	.chip_ok
		move.l	#14*1024*1024,d5	;cas 14Mo
		
.chip_ok
	* efface la RAM  partir de $300-> la fin -$100
		lea     $400.w,A4       ;etv_timer
		move.l  D5,D4
		sub.l   A4,D4	:ram-vecteurs 680xx
		lsr.l   #8,D4	;/256
		subq.l  #1,D4	;-1
		
		lea     $200.w,A5	incrment
		
		moveq   #0,D0	;effaceurs...
		movea.l D0,A0
		moveq   #0,D1
		movea.l D1,A1
		moveq   #0,D2
		movea.l D2,A2
		moveq   #0,D3
		movea.l D3,A3
		
		lea     $100(A4),A4	;init  $500.w
T_E0018A:      
		movem.l D0-D3/A0-A3,-(A4)	;32 octets
		movem.l D0-D3/A0-A3,-(A4)
		movem.l D0-D3/A0-A3,-(A4)
		movem.l D0-D3/A0-A3,-(A4)
		movem.l D0-D3/A0-A3,-(A4)
		movem.l D0-D3/A0-A3,-(A4)
		movem.l D0-D3/A0-A3,-(A4)
		movem.l D0-D3/A0-A3,-(A4)	;256 en tout
		adda.l  A5,A4		;+256
		dbra    D4,T_E0018A
		
		move.l  D5,$42E.w       ;phystop
		
		move.l  #$752019F3,$420.w ;memvalid
		move.l  #$237698AA,$43A.w ;memval2
		move.l  #$5555AAAA,$51A.w ;memval3
		;clr.l   $5A4.w            ;ramtop: Fastram
		;move.l  #$1357BD13,$5A8.w ;ramvalid
	
	* Fast-Ram
		move.l	#$12345678,d0
		lea	$5000000,a0	;dbut de la fast
		move.l	d0,-4(a0)
		cmp.l	-4(a0),d0
		bne.s	.no_fast
		
		;add.l	#$1000000,a0
		
		move.l	d0,(a0)
		cmp.l	(a0),d0
		bne.s	.ok_fast
		add.l	#$1000000,a0
		bra.s	.ok_fast
.no_fast
		sub.l	a0,a0
.ok_fast
		move.l	#$1357BD13,$5A8.w ;ramvalid
		move.l	a0,$5a4.w
		beq.s	.quit_fast
		
		move.l	a0,d0
	
		sub.l	#$4000000,d0
		lsr.l	#5,d0
.clr_fast
		rept	8
		clr.l	-(a0)
		endr
		subq.l	#1,d0
		bne.s	.clr_fast
.quit_fast
	* Si reset  chaud...
T_E001DA:      
		movea.l #$8870,SP	;pile super
		
		lea     $E00D52,A3	;"RTE"
		lea     $E00C04,A4	;"RTS"
		lea     $E0398C,A1	;reset violent
		
		lea     $8.w,A0         ;bus_error
		move.w  #$3F,D0
T_E001F6:      
		move.l  A1,(A0)+	;tout les vecteurs
		dbra    D0,T_E001F6
		
		move.l  A3,$14.w        ;divbyzero
	
	* initialise les autovecteurs
		move.l  A3,$7C.w        ;autov_int7
		moveq   #6,D0
		lea     $64.w,A1        ;autov_int1
T_E0020A:      
		move.l  #$E00D52,(A1)+	;=>"RTE"
		dbra    D0,T_E0020A
	* VBL
		move.l  #$E00CB0,$70.w  ;autov_int4
	* HBL
		move.l  #$E00C9A,$68.w  ;autov_int2
	* AES/VDI
		move.l  A3,$88.w        ;trp2vec ("RTE")
	* BIOS
		move.l  #$E00D7C,$B4.w  ;trp13vec
	* XBIOS
		move.l  #$E00D76,$B8.w  ;trp14vec
	* LINEA
		move.l  #$E094EA,$28.w  ;linea_vec
	* ETV_TIMER
		move.l  A4,$400.w       ;etv_timer
	
	* ETV_CRITIC
		move.l  #$E00D72,$404.w ;etv_critic
	* ETV_TERM
		move.l  A4,$408.w       ;etv_term

	* VBL queue
		lea     $4CE.w,A0       ;_vbl_list
		move.l  A0,$456.w       ;_vblqueue
		move.w  #7,D0
T_E0025C:      
		clr.l   (A0)+
		dbra    D0,T_E0025C
		lea     $E00E56,A0
		
		movea.w #$51E,A1
		moveq   #$1F,D0
T_E0026E:      
		move.l  (A0)+,(A1)+
		dbra    D0,T_E0026E

	* test du bus error ?!
		movea.l $8.w,A0         ;bus_error
		movea.l SP,A1
		move.l  #.retour,$8.w   ;bus_error
.retour
		move.l  A0,$8.w         ;bus_error
		movea.l A1,SP
	
	* init vido
		move.b  $FFFF8006.w,D0
		move.b  D0,D1
		lsl.b   #6,D1
		and.b   #$80,D1
		lsr.b   #6,D0
		or.b    D0,D1
		move.w  D1,$FFFF82C0.w	;_VCO
		st      $A86
		sf      $A87

		movea.l #$F99C,A1		;carrment
		movea.l #$A88,A0		;la fin de l'os
		moveq   #0,D0		;dans le code!!!
T_E002B6:      
		move.w  D0,(A0)+
		cmpa.l  A0,A1
		bne.s   T_E002B6
		
	* arbre PMMU
		jsr     $E014D0		;arbre PMMU
		
	* installe un cran de 32ko
		movea.l $42E.w,A0       ;phystop
		suba.l  #$8000,A0
		move.w  #$7FF,D1	;premier cran en haut de la
				;RAM
		move.l  A0,$44E.w       ;_v_bas_ad
		
		move.b  $44F.w,$FFFF8201.w ;dbaseh
		move.b  $450.w,$FFFF8203.w ;dbasel
		moveq   #0,D0
T_E002E0:      
		move.l  D0,(A0)+
		move.l  D0,(A0)+
		move.l  D0,(A0)+
		move.l  D0,(A0)+
		dbra    D1,T_E002E0	;efface l'cran
	
		movea.l $E00014,A0
		cmpi.l  #-$789ABCDF,(A0)	;$87654321
		beq.s   T_E002FE
		lea     $E00008,A0	;on y va jamais
T_E002FE:      
		move.l  4(A0),$4FA.w    ;end_os
		move.l  8(A0),$4FE.w    ;exec_os
		
		move.l  #$E04792,$46A.w ;hdv_init
		move.l  #$E04C5C,$476.w ;hdv_rw
		move.l  #$E0480C,$472.w ;hdv_bpb
		move.l  #$E04A6C,$47E.w ;hdv_mediach
		move.l  #$E04F54,$47A.w ;hdv_boot
		move.l  #$E02492,$506.w ;prv_lsto
		move.l  #$E023EC,$50A.w ;prv_lst
		move.l  #$E02504,$50E.w ;prv_auxo
		move.l  #$E0251C,$512.w ;prv_aux
		move.l  #$E01228,$502.w ;scr_dump
		
		move.l  $44E.w,$436.w   ;_memtop
		
		* insre le _FRB entre la fin du systme
		* et le dbut de la zone utilisateur
		
		move.l  $4FA.w,d0
		add.l	#64*1024,d0	;buffer _FRB
		move.l	d0,$432.w   ;_membot
		
		move.w  #8,$454.w       ;nvbls
		st      $444.w          ;_fverify
		move.w  #3,$440.w       ;seekrate
		move.l  #$1CC6,$4C6.w   ;_dskbufp
		move.w  #-$1,$4EE.w     ;_prt_cnt
		
		move.l  #$E00000,$4F2.w ;_sysbase
		
		move.l  #$93A,$4A2.w    ;savptr
		move.l  #$E00C04,$46E.w ;swv_vec
		
		clr.l   $4C2.w          ;_drvbits
		
		move.l  #$E03D4A,$5AC.w ;bell_hook
		move.l  #$E0390A,$5B0.w ;kcl_hook
		
		jsr     $E01392		;init vars systme
					;recopie de end_os
		
	* installe les cookies
		lea     $980,A0
		move.l  A0,$5A0.w       ;_p_cookies
		
		move.l	#"CT2a",(a0)+
		move.l	#$13021998,(a0)+
		
	* _CPU
		move.l  #$5F435055,(A0)+	;_CPU
		moveq   #0,D1
		movea.w #$10,A2	;illegal
		movea.l (A2),A3	;ancien vecteur
		movea.l SP,A1
		move.l  #$E003F8,(A2)
		move	ccr,d0	; >=68010?
		;dc.w    $42C0           ;B
		
		moveq   #10,D1	;=>68010
		extb.l	d0	; >=68020?
		;dc.w    $49C0           ;I
		
		moveq   #$14,D1	;=>68020
		movec.l CACR,D0
		bset    #9,D0	; >=68030?
		movec.l D0,CACR
		movec.l CACR,D0
		bclr    #9,D0
		beq.s   T_E003F8	
		
		moveq   #$1E,D1	;=>68030
		movec.l D0,CACR
T_E003F8:      			;<=retour illegal
		movea.l A1,SP
		move.l  A3,(A2)
		move.l  D1,(A0)+
		sne     $59F.w	;stack_frame
		
	* _VDO
		move.l  #$5F56444F,(A0)+	;_VDO
		move.l  #$30000,(A0)+	;VIDEL
		
	* _MCH
		move.l  #$5F4D4348,(A0)+
		move.l  #$30000,(A0)+	;Falcon
	* _SWI
		move.b  #$7F,D0
		tst.b   $A87
		bne.s   T_E00436
		
		move.l  #$5F535749,(A0)+
		moveq   #0,D0
		move.w  $FFFF9200.w,D0
		lsr.w   #8,D0
		move.l  D0,(A0)+
	* _SND
T_E00436:      
		moveq   #$1F,D1
		move.l  #$5F534E44,(A0)+
		btst    #7,D0
		bne.s   T_E00448
		bclr    #1,D1
T_E00448:      
		move.l  D1,(A0)+
	* _FDC
		btst    #6,D0
		bne.s   T_E00464
		move.b  #8,$16D4
		move.l  #$5F464443,(A0)+
		move.l  #$1415443,(A0)+
	* _FPU
T_E00464:      
		move.l  #$5F465055,(A0)+
		moveq   #0,D7
		movem.l $2C.w,A3        ;linef_vec
		movea.l $34.w,A4	;protocole
		
		move.l  .E004AE(pc),$2C.w  ;linef_vec
		;move.l  #$E004AE,$2C.w  ;linef_vec
		move.l  .E004AE(pc),$34.w	;protocole
		;move.l  #$E004AE,$34.w	;protocole
		
		movea.w #$C0,A2
		movem.l (A2),D0-D6
		movea.l .E004A8(pc),A5
		;movea.l #$E004A8,A5
		
		move.l  A5,(A2)+
		move.l  A5,(A2)+
		move.l  A5,(A2)+
		move.l  A5,(A2)+
		move.l  A5,(A2)+
		move.l  A5,(A2)+
		move.l  A5,(A2)+
		clr.l   -(SP)
		movea.l SP,A2
		frestore (SP)

	* retour vecteur copro
.e004a8
		move.l  #$20000,D7
.e004ae
		movea.l A2,SP
		addq.w  #4,SP
		move.l  A3,$2C.w        ;linef_vec
		move.l  A4,$34.w
		movem.l D0-D6,$C0.w
		move.l  D7,(A0)+
		
	* _FRB
		move.l	#"_FRB",(a0)+
		move.l	$4fa.w,(a0)+

	* NVRAM
		link    A6,#-$14
		movea.l SP,A5
		move.l  A0,(A5)
		pea     4(A5)
		move.w  #$10,-(SP)
		clr.l   -(SP)
		
		jsr     $E0216C
		
		movea.l (A5)+,A0
		tst.w   D0
		beq.s   T_E004E6
		lea     $E49B82,A5
		moveq   #0,D0
T_E004E6:      
		move.w  (A5),$A80.w
		addq.w  #6,A5
	* _AKP
		move.l  #$5F414B50,(A0)+
		move.w  D0,(A0)+
		move.w  (A5)+,(A0)+
	* _IDT
		move.l  #$5F494454,(A0)+
		move.w  D0,(A0)+
		move.w  (A5)+,(A0)+

		move.l  (A5)+,$A82.w
		moveq   #$50,D0
		cmp.b   $A82.w,D0
		bcc.s   T_E00510
		move.b  D0,$A82.w
T_E00510:      
		bfextu	($ffff8006.w,za0){0:2},d1
		
		move.w  (A5),D0
		bne.s	.ya_mode
		;move.w  #$82,D0
			 ;FSOPV8NNN
		move.w	#%000101010,d0 ;par dfaut / PAL
		btst	#0,d1
		bne	T_E00518
		or	#%000010000,d0	;VGA
		bra	T_E00518
.ya_mode
		tst	d1
		bne.s	.pas_sm124
			 ;FSOPV8NNN
		move	#%000001000,d0
		bra	T_E00518
.pas_sm124
		btst	#0,d1
		bne.s	.tv
.vga
		and	#%110011111,d0
		move	d0,d1
		and	#%111,d1
		bne.s	.vga_col
		or	#%000001000,d0
		bra.s	.vga_st
.vga_col
		cmp	#%100,d1
		bne.s	.vga_st
		and	#%110010111,d0
.vga_st
		btst	#7,d0
		beq.s	T_E00518
		tst	d1
		beq.s	.vga_haute
		cmp	#1,d1
		beq.s	.vga_moy
.vga_basse
		move	#%110010010,d0
		bra.s	T_E00518
.vga_moy
		move	#%110011001,d0
		bra.s	T_E00518
.vga_haute
		move	#%010011000,d0
		bra.s	T_E00518
.tv
		move	d0,d2
		and	#%000100000,d2	;PAL
		and	#%110101111,d0
		move	d0,d1
		and	#%111,d1
		bne.s	.tv_col
		or	#%000001000,d0
.tv_col
		btst	#7,d0
		beq.s	T_E00518
		tst	d1
		beq.s	.tv_haute
		cmp	#1,d1
		beq.s	.tv_moy
.tv_basse
		move	#%110010010,d0
		or	d2,d0
		bra.s	T_E00518
.tv_moy
		move	#%110011001,d0
		or	d2,d0
		bra.s	T_E00518
.tv_haute
		move	#%010011000,d0
		or	d2,d0
		bra.s	T_E00518
T_E00518:      
		move.w  D0,$184C.w	;mode vido de dpart...
		unlk    A6

	* fin cookies
		clr.l   (A0)+
		move.l  #$20,(A0)+

	* Clavier, timer c et timer d
		jsr     $E025DC	;init clavier

	* init timer a =>50 pr-div compteur nul : 49152 Hz
		move.w  #$400,D0
		
		jsr     $E01422	;init timera
		
		move.l  #$E00858,-(SP)
		move.w  #1,-(SP)
		jsr     $E0257C	;=> clavier
		addq.l  #6,SP
	
	* init timer a =>200 pr-div compteur nul : 12288 Hz
		move.w  #$700,D0
		move.w  #14,D1
T_E0054C:      
		jsr     $E01422	;15 fois!!!
		
		dbra    D1,T_E0054C

	* test cartouche
		moveq   #2,D0
		jsr     $E00BD2	;=>cartouche
		
		moveq   #3,D1
		move.w  $184C.w,D2
		bne.s   T_E00566
		move.w  #$82,D2
T_E00566:      
		move.w  D2,$184C.w

	* vecteur pour les changements de rsolution
	*  Q: faudrait-il sauter dans la flash?
		
		move.l  #$E00030,$46E.w ;swv_vec

	* met en route la vbl systme
		move.w  #1,$452.w       ;vblsem

	* test cartouche
		clr.w   D0
		jsr     $E00BD2	;=>cartouche
		
	* Lache les interruptions: vrrrooooummmmmmm!!!!!!
	
		move    #$2300,sr
		
		moveq	#1,d0
		jsr	$e00bd2
		
		move.l	#$e00872,$20.w
		move.l	$42e.w,$436.w	;phystop->_memtop
		
	* init GEMDOS, VDI, ...
		jsr	$e1de84
		
	* dclare Fast-Ram
		lea	$4000000,a0
		move.l	$5a4.w,d0
		sub.l	a0,d0
		move.l	d0,-(sp)
		pea	(a0)
		move	#$14,-(sp)	;Maddalt
		trap	#1
		lea	10(sp),sp

	* change de rsolution
		move	$184c.w,-(sp)
		move	#3,-(sp)
		clr.l	-(sp)
		clr.l	-(sp)
		jsr	$e08b5c
		lea	12(sp),sp
	
	* on retourne au tos 4.04
		jmp	$e005b2

		*/------------/*
		
		dc.b	"!poy"		;marque de fin
fin:		dc.l	0

		*-------------------*

*-------------------------------------------------------------------------*		
