*----------------------------------------------------------------------------*
*		Analyse du env
*----------------------------------------------------------------------------*

		*------------*

		OPT	nocase
		opt	O+
		opt	nowarn
		opt	noeven
		opt	odl
		OPT	X-
		opt	p=68030
		opt	p=68881
		
		COMMENT	HEAD=FastLoad
		
		OUTPUT	D:\EXECS\ENV_FILE.PRG

		*------------*

*-------------------------------------------------------------------------*

		*------------*

		include	D:\DOLMEN\SOURCES\XLIB\GEM.EQU
		include	D:\DOLMEN\SOURCES\XLIB\BIOS.EQU
		include	D:\DOLMEN\SOURCES\XLIB\XBIOS.EQU
		include	D:\DOLMEN\SOURCES\FLASH.CT2\FLASH.RS

		*------------*

*-------------------------------------------------------------------------*

		*------------*
AUTO_MGR
		
		move.l	4(sp),a0
		move.l	a0,cent_base
		lea	cent_stack,sp

		move.l	12(a0),a1
		add.l	20(a0),a1
		add.l	28(a0),a1

		pea	256(a1)
		pea	(a0)
		clr	-(sp)
		GEM	MSHRINK

		*------------*
		
		move.l	cent_base(pc),a1
		
	* recherche d'un fichier 'ENV'
		clr	-(sp)
		pea	env_file(pc)
		GEM	Fopen
		move	d0,d1
		bmi	.no_env
		
	* Quel est sa taille?
		move	#2,-(sp)
		move	d1,-(sp)
		clr.l	-(sp)
		GEM	Fseek
		move.l	d0,d2
		move.l	d0,d3
		
	* on lui rajoute 4Ko et on arrondie sa taille
	* a un multiple de 16 (alignement des mallocs
		
		moveq	#$f,d0
		add.l	d0,d2
		add.l	#4*1024,d2
		not.l	d0
		and.l	d0,d2
		move	#3,-(sp)
		move.l	d2,-(sp)
		GEM	Mxalloc
		move.l	d0,a2
		
		clr	-(sp)
		move	d1,-(sp)
		clr.l	-(sp)
		GEM	Fseek
		
	* on charge le fichier en ram
		pea	(a2)
		move.l	d3,-(sp)
		move	d1,-(sp)
		GEM	Fread
		tst.l	d0
		bmi.s	.close
		
	* si tout c'est bien pass, on prends le bloc
	* mmoire contenant le fichier comme pointeur
	* sur la nouvelle chaine d'environement

		move.l	a2,p_env(a1)
		
	* transformation du fichier d'environement
	* en une suite de variables d'environement

		moveq	#"#",d2	;caractre commenant une ligne
				;de commentaire
		moveq	#13,d3	;CR: fin de ligne

		moveq	#10,d4	;LF: si Atari

	* dbut de la conversion
.cont
		tst.b	(a2)	;fin de fichier atteints
		beq.s	.end_file
		
		cmp.b	(a2)+,d2	;commentaire?
		bne.s	.cont	;=>non
		
	* recherche du dbut de la ligne suivant et
	* on compacte le fichier
		
		move.l	a2,a3	;travaille sur un pointeur temporaire
.suite_ligne
		cmp.b	(a3)+,d3
		bne.s	.suite_ligne
		
		cmp.b	(a3),d4
		bne.s	.pas_lf
		lea	1(a3),a3
.pas_lf
		lea	-1(a2),a2	;on remonte pour craser '#'
		move.l	a2,a0	;var temp
.compacte
		move.b	(a3)+,(a0)+
		bne.s	.compacte
.vars
		bra.s	.cont
.end_file
	* fichier compact
.close
		move	d1,-(sp)
		GEM	Fclose
.no_env
		*------------*

		move	d0,-(sp)
		GEM	Pterm

		*------------*

*-------------------------------------------------------------------------*
		DATA
*-------------------------------------------------------------------------*

		*------------*
		
env_file		dc.b	"F:\ENV",0
		even
		

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*

		*------------*

cent_base		ds.l	1

stack		ds.l	1000
cent_stack	ds.l	1

		*------------*
		
*-------------------------------------------------------------------------*
