*----------------------------------------------------------------------------*
*		AUTO MANAGER
*
*		Install dans le dossier DOLMEN.SYS
*----------------------------------------------------------------------------*

		*------------*

		OPT	nocase
		opt	O+
		opt	nowarn
		opt	noeven
		opt	odl
		OPT	X-
		opt	p=68030
		opt	p=68881
		
		COMMENT	HEAD=FastLoad
		
		OUTPUT	D:\BIN\FFORCE.PRG

		*------------*

ver_tsr		equ	$102
		
		*------------*

		include	D:\DOLMEN\SOURCES\XLIB\GEM.EQU
		include	D:\DOLMEN\SOURCES\XLIB\BIOS.EQU
		include	D:\DOLMEN\SOURCES\XLIB\XBIOS.EQU

		*------------*

*-------------------------------------------------------------------------*

		*------------*
AUTO_MGR
		move.l	4(sp),a0
		move.l	a0,cent_base
		lea	cent_stack(pc),sp

		move.l	12(a0),a1
		add.l	20(a0),a1
		add.l	28(a0),a1

		pea	256(a1)
		pea	(a0)
		clr	-(sp)
		GEM	MSHRINK

		clr	-(sp)
		pea	bootlog(pc)
		GEM	Fcreate
		move	d0,d6
		
		move	d6,-(sp)
		move	#1,-(sp)
		GEM	Fforce

		pea	coucou(pc)
		GEM	Cconws

		move	d6,-(sp)
		GEM	Fclose

		GEM	Pterm0

		*------------*

*-------------------------------------------------------------------------*
		DATA
*-------------------------------------------------------------------------*

		*------------*
		
bootlog		dc.b	"BOOTLOG.TSR",0
		even
		
		*------------*

		cnop	0,16
coucou		dc.b	27,"E"
		dc.b	" ***************************",13,10
		dc.b	" *                         *",13,10
		dc.b	" *         DOLMEN         *",13,10
		dc.b	" *       TSR MANAGER       *",13,10
		dc.b	" *        rev: "
		dc.b	((ver_tsr>>8)&$f)+'0','.'
		dc.b	((ver_tsr>>4)&$f)+'0','.'
		dc.b	((ver_tsr>>0)&$f)+'0',"       *",13,10
		dc.b	" *                         *",13,10
		dc.b	" ***************************",13,10
		dc.b	13,10
		dc.b	0
		even
		
		*------------*

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*

		*------------*

cent_base		ds.l	1

stack		ds.l	1000
cent_stack	ds.l	1

		*------------*
		
*-------------------------------------------------------------------------*
