*-------------------------------------------------------------------------*		
*		Logiciel d'installation de la Flash
*
*  Prendre un fichier .ZAP et tirer le dessus
*-------------------------------------------------------------------------*		
		TEXT
*-------------------------------------------------------------------------*		
		
		opt	o+,ow-,x-
		
		INCLUDE	GEM.EQU
		INCLUDE	BIOS.EQU
		INCLUDE	XBIOS.EQU
		
		include	FLASH.RS
		
		output	D:\EXECS\FLASH_IT.PRG

buffer_cmd	equ	$f4000000
buffer_data	equ	$f4000000


Taille_maxi	equ	64*1024		;64 ko

		*-------------*
		* header de programme
		RSRESET
		
cprg_header	rs.w	1
cprg_text		rs.l	1
cprg_data		rs.l	1
cprg_bss		rs.l	1
cprg_symbol	rs.l	1
cprg_resvd	rs.b	10

*-------------------------------------------------------------------------*		
		
		*-------------------*

		* unite = 6.5us
WAIT		MACRO
		
		moveq	#-11,d0
		sub.b	#\1,d0
		add.b	$fffffa1f.w,d0
.wait\@
		cmp.b	$fffffa1f.w,d0
		bhi	.wait\@
		ENDM

		*-------------------*

*-------------------------------------------------------------------------*		

		*-------------------*
Main		
		move.l	4(sp),cent_base
		lea	cent_stack,sp
		
		move.l	cent_base,a0
		move.l	12(a0),a1
		add.l	20(a0),a1
		add.l	28(a0),a1

		pea	256(a1)
		pea	(a0)
		clr	-(sp)
		GEM	MSHRINK
		
		*-------------------*
		
		pea	present
		GEM	Cconws

		*-------------------*
		
		move.l	cent_base,a6
		lea	$80(a6),a6
		move.b	(a6)+,d0
		bne.s	.conv
.error
		pea	Bad_file
		GEM	Cconws
		
		GEM	Crawcin
		
		GEM	Pterm0
.conv
		clr.w	-(sp)
		move.l	a6,-(sp)
		GEM	FOPEN
		move.w	d0,d2
		bmi	.error

		move.w	#2,-(sp)
		move.w	d2,-(sp)
		clr.l	-(sp)
		GEM	FSEEK
		move.l	d0,d7

		clr.w	-(sp)
		move.w	d2,-(sp)
		clr.l	-(sp)
		GEM	FSEEK
		
		pea	header
		move.l	#28,-(sp)
		move	d2,-(sp)
		GEM	Fread
		
		lea	header,a6
		cmpi	#$601a,cprg_header(a6)
		bne	.pas_zap

		move.l	cprg_text(a6),d6
		add.l	cprg_data(a6),d6
		add.l	cprg_bss(a6),d6
		
		cmp.l	#taille_maxi,d6
		bls.s	.ok_size

		move	d2,-(sp)
		gem	Fclose
		
		pea	trop_gros
		GEM	Cconws
		
		GEM	Crawcin
		
		GEM	Pterm0
.ok_size
		cmp.l	d6,d7
		bhs.s	.d7_ok
		move.l	d6,d7
.d7_ok
		move.l	d7,flash_zap_size
		
		move.l	d7,-(sp)
		GEM	MALLOC
		move.l	d0,a2
		move.l	a2,flash_zap_start

		move.l	a2,-(sp)
		move.l	d7,-(sp)
		move.w	d2,-(sp)
		GEM	FREAD
		
		cmp.l	#"yop!",(a2)
		beq.s	.bon_zap

		move.l	a2,-(sp)
		GEM	Mfree
.pas_zap		
		pea	pas_zap
		GEM	Cconws
		
		GEM	Crawcin

		GEM	Pterm0
.bon_zap

		move.w	d2,-(sp)
		GEM	FCLOSE
		
		*-------------------*
		* on passe en superviseur
		
		clr.l	-(sp)
		GEM	SUPER
		move.l	d0,d7
		
		*-------------------*
		* sauvegarde du mfp
		
		lea	$fffffa00.w,a0
		move.b	$07(a0),save_iera
		move.b	$13(a0),save_imra
		move.b	$19(a0),save_tacr
		
		* init mfp
		bclr.b	#5,$07(a0)
		bclr.b	#5,$13(a0)
		move.b	#$ff,$1f(a0)	;compteur  fond
		move.b	#$3,$19(a0)	;/16=>inc 6.5us
		
		*-------------------*
		* on vrifie que la RAM est  0
		
		pea	verif_0
		GEM	Cconws
		
		lea	buffer_cmd,a4
		lea	buffer_data,a5
		
		move.w	#65536-1,d6	;toute la flash
		clr.b	(a4)		;read cmd
verify
		tst.b	(a5)+
		bne.s	.err_0
		
		dbra	d6,verify
		
		pea	OK
		GEM	Cconws
		
		bra	mise_1

		* erreur...
.Err_0
		
		move.l	a5,d0
		subq.l	#1,d0
		lea	adr_00+4,a0
		moveq	#4-1,d2
.conv
		move	d0,d1
		lsr	#4,d0
		
		and.b	#$f,d1
		cmp.b	#10,d1
		bhs.s	.plus_10
		add.b	#"0",d1
		bra.s	.wr
.plus_10
		add.b	#"A"-10,d1
.wr
		move.b	d1,-(a0)
		dbra	d2,.conv
		
		pea	error_00
		GEM	Cconws
		
		*-------------------*
		; test AMD FlashErase
		* en fait, il faut tout mettre  0
		
		lea	buffer_cmd,a4
		lea	buffer_data,a5
		
		pea	erase_0
		GEM	Cconws
		
		move.w	#65536-1,d6	;toute la flash
		clr	d1
clr		
		clr	d5		;pulse-count=0
.retry_clr		
		move.b	#$40,(a4)		;programme
		clr.b	(a5)		;data
		
		WAIT	2		;2*6.5us
		
		move.b	#$c0,(a4)		;verify
		
		WAIT	1
		
		tst.b	(a5)		;data
		beq.s	.ok		;=>OK
		
		addq	#1,d1		;espion...
		addq	#1,d5		;pulse-count+1
		cmp	#25,d5		;pas plus de 25 fois
		bne	.retry_clr	;=>retry
		bra	.error_clr0	;erreur
.ok
		addq.l	#1,a4		;adresse suivante
		addq.l	#1,a5		;adresse suivante
			
		dbf	d6,clr
		
		* fini mise  0
		
		lea	buffer_cmd,a4
		clr.b	(a4)		;read cmd

		pea	OK
		bra.s	.aff_0

		* erreur...
.Error_clr0
		move.l	a5,d0
		lea	adr_0+4,a0
		moveq	#4-1,d2
.conv
		move	d0,d1
		lsr	#4,d0
		
		and.b	#$f,d1
		cmp.b	#10,d1
		bhs.s	.plus_10
		add.b	#"0",d1
		bra.s	.wr
.plus_10
		add.b	#"A"-10,d1
.wr
		move.b	d1,-(a0)
		dbra	d2,.conv
		
		pea	error_0
.aff_0
		GEM	Cconws
		
		*-------------------*
		* mise  1...
mise_1
		pea	erase_1
		GEM	Cconws
re_erase		
		move.w	#65536-1,d6	;toute la flash
		clr	d5		;pulse-count
		lea	buffer_cmd,a4	;hors de la boucle
		lea	buffer_data,a5	;pour ne vrifier que les
					;nouvelles adresses et
					;pas celles dj valides
.recommence		
		move.b	#$20,(a4)		;erase operation
		move.b	#$20,(a5)
		
		moveq	#2+1,d0		;10ms
		add.l	$4ba.w,d0		;compteur 200Hz
.time1		
		cmp.l	$4ba.w,d0
		bhs	.time1
		
		* effacement fini, on vrifie...
.verify
		move.b	#$a0,(a4)		;erase verify
		
		WAIT	1
		
		move.b	(a5),d1
		cmp.b	#$ff,d1
		beq.s	.ok
		
		add	#1,d5
		cmp	#3000,d5
		bne	.recommence	;retry erase
		bra	.Error_clr1	;=>error
.ok
		addq.l	#1,a4
		addq.l	#1,a5
		dbra	d6,.verify

		* fini mise  1
		
		lea	buffer_cmd,a4
		clr.b	(a4)		;read cmd

		pea	OK
		bra.s	.aff_1

		* erreur...
.Error_clr1
		move.l	a5,d0
		lea	adr_1+4,a0
		moveq	#4-1,d2
.conv
		move	d0,d1
		lsr	#4,d0
		
		and.b	#$f,d1
		cmp.b	#10,d1
		bhs.s	.plus_10
		add.b	#"0",d1
		bra.s	.wr
.plus_10
		add.b	#"A"-10,d1
.wr
		move.b	d1,-(a0)
		dbra	d2,.conv
		pea	error_1
.aff_1
		GEM	Cconws
		
		*-------------------*
		; test AMD FlashRite
reloge
		lea	buffer_cmd,a4
		lea	buffer_data,a5	;destination
	* reloge
		
		move.l	a5,d0
		
		move.l	a2,a0
		move.l	a2,a1
		add.l	cprg_text(a6),a1
		add.l	cprg_data(a6),a1
		move.l	a1,a3
		add.l	cprg_symbol(a6),a1
		clr.l	d1

		tst.l	(a1)
		beq.s	.makebss
		
		add.l	(a1)+,a0
		add.l	d0,(a0)

.again		move.b	(a1)+,d1
		beq.s	.makebss
		cmpi	#1,d1
		bne.s	.normal
		lea	254(a0),a0
		bra.s	.again

.normal		lea	(a0,d1.w),a0
		add.l	d0,(a0)
		bra.s	.again
	* bss...
.makebss		move.l	cprg_bss(a6),d0
		beq.s	.fin_reloc
		lsr.l	d0
.bssloop		
		clr.w	(a3)+
		subq.l	#1,d0
		bhi.s	.bssloop
.fin_reloc
	* installe dans la Flash
		
		pea	ecrit
		GEM	Cconws
programm
		clr	d5		;pulse-count=0
		move.b	(a2)+,d1
.retry_prg	
		move.b	#$40,(a4)		;programme
		move.b	d1,(a5)		;data
		
		WAIT	2
		
		move.b	#$c0,(a4)		;verify
		
		WAIT	1
		
		cmp.b	(a5),d1
		beq.s	.ok		;=>OK
		
		addq	#1,d5		;pulse-count+1
		cmp	#25,d5		;pas plus de 25 fois
		bne	.retry_prg	;=>retry
		bra	error_wr		;=>erreur
.ok
		addq.l	#1,a4		;adresse suivante
		addq.l	#1,a5		;adresse suivante
			
		cmp.l	a2,a3		;la fin
		bhi	programm		;=>non
		
		* fini mise  0
		
		lea	buffer_cmd,a4
		clr.b	(a4)		;read cmd
		
		pea	OK
		bra	QUIT
		
		*-------------------*
Error_wr
		move.l	a5,d0
		lea	adr_wr+4,a0
		moveq	#4-1,d2
.conv
		move	d0,d1
		lsr	#4,d0
		
		and.b	#$f,d1
		cmp.b	#10,d1
		bhs.s	.plus_10
		add.b	#"0",d1
		bra.s	.wr
.plus_10
		add.b	#"A"-10,d1
.wr
		move.b	d1,-(a0)
		dbra	d2,.conv
		pea	error_prg
QUIT
		GEM	Cconws
		
		*-------------------*
		
		lea	buffer_cmd,a4
		move.b	#-1,(a4)	;RESET CMD
		move.b	#-1,(a4)
		
		clr.b	(a4)	;READ CMD
		
		*-------------------*
		* restaure le MFP
		
		lea	$fffffa00.w,a0
		move.b	save_iera,$07(a0)
		move.b	save_imra,$13(a0)
		move.b	save_tacr,$19(a0)
free
		move.l	flash_zap_start,-(sp)
		GEM	Mfree
		
		*-------------------*
		
		pea	quitte
		GEM	Cconws
		
		GEM	Crawcin
		
		*-------------------*
		
		move.l	d7,-(sp)
		GEM	SUPER
		
		GEM	PTERM0
		
		*-------------------*
		
*-------------------------------------------------------------------------*
		DATA
*-------------------------------------------------------------------------*

		*-------------------*

present		dc.b	27,"E"
		dc.b	"Mise  jour de la Flash de la CENTurbo 2",13,10
		dc.b	13,10,0
		even

		*-------------------*
		
Bad_file		dc.b	"Pas de fichier .ZAP trouv!",13,10
		dC.b	"  ... Appuyez sur une touche ...",0
		even
		
		*-------------------*
		
trop_gros		dc.b	"Fichier .ZAP trop gros!",13,10
		dC.b	"  ... Appuyez sur une touche ...",0
		even
		
		*-------------------*
		
pas_zap		dc.b	"Ce n'est pas un fichier .ZAP!",13,10
		dC.b	"  ... Appuyez sur une touche ...",0
		even
		
		*-------------------*
		
quitte		dc.b	13,10,13,10
		dc.b	"  Programme fini",13,10
		dC.b	"  ... Appuyez sur une touche ...",0
		even
		
		*-------------------*

ok		dc.b	" OK",13,10,0
		even

		*-------------------*
		* vrification

verif_0		dc.b	"  Contenu de la flash  0...",0
		even

Error_00		dc.b	"  Non nul  l'adresse: $F800"
adr_00		dc.b	"1234",13,10,0
		even

		*-------------------*
		* mise  0

Erase_0		dc.b	"  Mise  0 en cours...",0
		even

Error_0		dc.b	"  Erreur! Adresse: $F800"
adr_0		dc.b	"1234",13,10,0
		even

		*-------------------*
		* mise  1: effacement

Erase_1		dC.b	"  Mise  1 en cours...",0
		even

Error_1		dc.b	"  Erreur! Adresse: $F800"
adr_1		dc.b	"1234",13,10,0
		even

		*-------------------*
		* programmation
		
Ecrit		dc.b	"  Ecriture programme en cours...",0
		even

Error_prg	dc.b	"  Erreur! Adresse: $F800"
adr_wr		dc.b	"1234",13,10,0
		even
		
		*-------------------*

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*

		*-------------------*

header		ds.b	28

flash_zap_start	ds.l	1
flash_zap_size	ds.l	1

		*-------------------*

save_iera		ds.b	1
save_imra		ds.b	1
save_tacr		ds.b	1
		ds.b	1

		*-------------------*

cent_base		ds.l	1
stack		ds.l	1000
cent_stack	ds.l	1

*-------------------------------------------------------------------------*
