*-------------------------------------------------------------------------*		
*		SUITE DE LA ROM 4.04
*-------------------------------------------------------------------------*		
T_E005b2
	* Init DSP
		jsr     A_E0567E(PC)

	* Init SDMA
		move.w  #1,-(SP)
		move.w  #0,-(SP)
		move.w  #0,-(SP)
		move.w  #8,-(SP)
		move.w  #0,-(SP)
		jsr     $E06504
		addq.w  #6,SP
		
		clr.w   (SP)
		jsr     $E063F8
		
		move.l  #$20080,(SP)
		jsr     $E0620C
		
		move.w  #3,(SP)
		jsr     $E0620C
		
		move.l  #$60003,(SP)
		jsr     $E0620C
		
		move.w  #4,(SP)
		jsr     $E0620C
		
		move.w  #5,(SP)
		jsr     $E0620C
		addq.w  #4,SP
	
	* NVRAM: lit l'heure
		move.w  $E0001E,$6CFE
		jsr     $E01FA4
		beq.s   T_E0062E
		
		jsr     $E022A0
		swap    D0
		tst.b   D0
		beq.s   T_E0062E
		move.w  D0,$6CFE
		swap    D0
		move.w  D0,$6CFC
T_E0062E:      
	* coupe le timer A
		clr.b   $FFFFFA19.w     ;tacr
		bclr    #5,$FFFFFA07.w  ;iera
	* init le cache
		move.l  #$3111,D0	;je le fais au dbut du boot
		movec.l D0,CACR	;=>plus rapide

	* dessine le logo?
		lea     $ACE.w,A0
		move.l  #$10001,(A0)+
		clr.w   (A0)
		lea     $E4984A,A0	;coordonnes
		lea     $AD4.w,A1
		move.l  (A0)+,(A1)+
		move.l  (A0)+,(A1)+
		move.l  (A0)+,(A1)+
		move.l  (A0),(A1)

		pea     $E4983C	;mfdb logo 96*86*1
		jsr     $E01082	;affiche le mfdb
		addq.w  #4,SP

	* positionne le curseur texte
		moveq   #$27,D7		;st moyenne et st haute
		tst.b   $44C.w          ;sshiftmd
		bne.s   T_E00676
		moveq   #$2C,D7		;autre ?
T_E00676:      
		move.l  #$30002,D6
		move.w  #$1B,-(SP)	;ESC
		move.l  D6,-(SP)
		trap    #13             ;bios 3
		move.w  #$59,4(SP)	;"Y"
		move.l  D6,(SP)
		trap    #13             ;bios 3
		move.w  D7,4(SP)	;Y: 32+7(ST)/12(autres)
		move.l  D6,(SP)
		trap    #13	;bios 3
		move.w  #$20,4(SP)	;X: 32+0 
		move.l  D6,(SP)
		trap    #13             ;bios 3
		addq.w  #6,SP
		
		;cmpi.l  #$3E80,$4BA     ;_hz_200
		;bcc     T_E00746	;pause avant le lancement...
		
		;nop     		;tout ce qui suit ne sert plus
		;nop     		; il devait y avoir le crc et
		;nop     		; des tas d'autres conneries
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;bra.s   T_E00746
		;subq.w  #3,D1
		;addq.w  #1,A6
		;dc.w    $494E           ;IN
		;dc.w    $473A           ;G:
		;movea.l D2,A0
		;dc.w    $4144           ;AD
		;movea.l (A2),A0
		;dc.w    $4F4D           ;OM
		;movea.l D3,A0
		;addq.w  #1,D3
		;movea.l A1,A0
		;dc.w    $4E20           ;N 
		;dc.w    $4348           ;CH
		;dc.w    $4950           ;IP
		;move.l  D0,D0
		;move.l  A5,D7
		;dc.w    $0A00           ;  
		;move.l  A5,D5
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
		;nop     
T_E00746:      
		move.l  #$BFFFF,-(SP)
		trap    #13             ;Kbshift
		addq.w  #4,SP
		btst    #3,D0	;ALT
		beq.s   T_E00760
		
		move.l  #$808,D0	;coupe et vide les caches?!
		movec.l D0,CACR
T_E00760:      
		jsr     $E01C8C	;reset SCSI: ccile le fait
		
	* met en place le truc des bombes...
		clr.l   D1
		lea     $E00FB6,A0
		adda.l  D1,A0
		adda.l  D1,A0
		
		lea     $8.w,A1         ;bus_error
		move.w  #$3F,D0
		move.l  #$E0398C,D2	;reset violent
T_E0077E:      
		cmp.l   (A1)+,D2
		bne.s   T_E00786
		move.l  A0,-$4(A1)	;remplace les resets violents
				;par l'affichage des bombes
T_E00786:      
		adda.l  D1,A0	;+2
		dbra    D0,T_E0077E	;+4

	* boot cartouche+boot disquette+init disquette
	*  pour la disquette:
	*    saute en hdv_boot ($47a)=>d0=0: boot en _dskbufp ($4c6)
	*			d0=1: pas de disquette
	*			d0=4: pas de boot mais un disquette
	*    si boot saute dedans (jsr)
	
		bsr     T_E0096E 	;+4=>e00790

	* teste ram...+pause et attente de touche 
	* (ALT+CTRL+UNDO=>reset nvm)
	* puis lance le test des boots des disques durs
		bsr     T_E00986

	* recherche le mot magique ($12123456) ?!?!?!?!
		bsr     T_E01320

	* boot de l'os: on peut arrter ici...
T_E00798
		tst.w   $482            ;_cmdload
		beq.s   T_E007BE

	* chargement de command.prg ?!
		bsr     T_E01102	;dossier auto
		
		move.l  #$E00000,$4F2   ;_sysbase
		pea     T_E00855(PC)
		pea     T_E00855(PC)
		pea     T_E00842(PC)
		clr.w   -(SP)
		bra.s   T_E00826

	* boot de l'os en rom
T_E007BE:      
		bsr     T_E01102	;dossier auto
		
		move.l  #$E00000,$4F2   ;_sysbase
		lea     T_E00836(PC),A0
		
		movea.l #$840,A1	;chane o sera le "PATH
T_E007D6:      
		cmpi.b  #"#",(A0)
		bne.s   T_E007DE
		movea.l A1,A2
T_E007DE:      
		move.b  (A0)+,(A1)+
		bpl.s   T_E007D6
		
		move.b  $446,D0         ;_bootdev
		add.b   #"A",D0
		move.b  D0,(A2)
		
		pea     $840		;"PATH=",0,"x:\",0
		pea     $E00855		;null
		pea     T_E00855(PC)	;null
		move.w  #5,-(SP)		;cr une BasePage
		move.w  #$4B,-(SP)
		trap    #1              ;Pexec
		adda.w  #14,SP
		
		movea.l D0,A0		;pointeur sur la BasePage
		move.l  $4FE,8(A0)      ;exec_os
		pea     $840	;null
		move.l  A0,-(SP)	;adresse de la BasePage
		pea     T_E00855(PC)
		move.w  #4,-(SP)	;excute la "BasePage"
T_E00826:      
		move.w  #$4B,-(SP)
		trap    #1              ;Pexec
		adda.w  #14,SP
		
		jmp     $E00030
T_E00836:      
		dc.b	"PATH=",0
		dc.b	"#:\",0
		
		;addq.w  #8,D1
		;addq.w  #2,A0
		;move.w  D0,-(A6)
		;move.l  A_E0643E(PC),-(A1)
		
		dc.w    $00FF           ;$ff pour finir la recopie
				;du path
T_E00842:      
		dc.b	"COMMAND.PRG",0
		dc.b	"GEM.PRG"

T_E00855		dc.b	0
		
		dc.w	$0
		dc.b	$80,$01		;reset clavier
		
		;dc.w    $434F           ;CO
		;dc.w    $4D4D           ;MM
		;dc.w    $414E           ;AN
		;neg.b   $5052(A6)
		;dc.w    $4700           ;G 
		;dc.w    $4745           ;GE
		;dc.w    $4D2E           ;M.
		;addq.w  #8,(A2)
		;dc.w    $4700           ;G 
		;dc.w    $0000           ;  
		;or.b    D1,D0
T_E0085A:      
		move    sr,-(SP)
		ori     #$700,sr
		movec.l CACR,D0
		or.l    #$808,D0
		movec.l D0,CACR
		move    (SP)+,sr
		rts     

		movem.l D0-D2,-(SP)
		move.l  A1,-(SP)
		move.l  A0,-(SP)
		movea.l $16(SP),A0
		move.w  (A0),D0
		move.w  D0,D1
		and.w   #-$40,D0
		cmp.w   #$40C0,D0
		bne     T_E00960
		move.l  #$30004E71,$A88.w
		move.l  #$4E714E75,$A8C.w
		move.w  D1,D0
		and.w   #7,D0
		lsl.w   #8,D0
		lsl.w   #1,D0
		or.w    D0,$A88.w
		move.w  D1,D0
		and.w   #$38,D0
		lsl.w   #3,D0
		or.w    D0,$A88.w
		moveq   #2,D2
		cmp.w   #$180,D0
		beq     T_E00960
		tst.w   D0
		beq.s   T_E00920
		cmp.w   #$140,D0
		beq.s   T_E008EA
		cmp.w   #$1C0,D0
		bne.s   T_E008F2
		and.w   #7,D1
		beq.s   T_E008E0
		addq.w  #2,D2
		move.w  4(A0),$A8C.w
T_E008E0:      
		addq.w  #2,D2
		move.w  2(A0),$A8A.w
		bra.s   T_E00946
T_E008EA:      
		addq.w  #2,D2
		move.w  2(A0),$A8A.w
T_E008F2:      
		and.w   #7,D1
		cmp.w   #7,D1
		bne.s   T_E00946
		move    usp,A1
		andi.w  #-$C01,$A88.w
		add.l   D2,$16(SP)
		bsr     T_E0085A
		move.w  $14(SP),D0
		jsr     $A88.w
		move    A1,usp
		movea.l (SP)+,A0
		movea.l (SP)+,A1
		movem.l (SP)+,D0-D2
		rte     
T_E00920:      
		add.l   D2,$16(SP)
		ori.w   #$10,$A88.w
		bsr     T_E0085A
		lea     $14(SP),A0
		movem.l 8(SP),D0-D2
		jsr     $A88.w
		movea.l (SP)+,A0
		movea.l (SP)+,A1
		adda.w  #12,SP
		rte     
T_E00946:      
		add.l   D2,$16(SP)
		bsr     T_E0085A
		movea.l (SP)+,A0
		movea.l (SP)+,A1
		move.w  12(SP),D0
		jsr     $A88.w
		movem.l (SP)+,D0-D2
		rte     
T_E00960:      
		movea.l (SP)+,A0
		movea.l (SP)+,A1
		movem.l (SP)+,D0-D2
		jmp     $E00FB6

	**********************************
	* saute dans la cartouche
	* initialise la prsence du lecteur de disquette
	* excute le boot d'une disquette
T_E0096E:      
		moveq   #3,D0
		bsr     T_E00BD2	;Cartouche disque
		
		movea.l $47A.w,A0       ;hdv_boot (1seul fois)
		jsr     (A0)	;repre le(s) lecteur(s) de disquettes
				;d0=0: boot disquette charg et
				;excutable
				:d0=1: pas de disquette
				:d0=4: disquette mais pas bootable
		tst.w   D0	
		bne.s   T_E00984
		
		movea.l $4C6.w,A0       ;_dskbufp: le boot a t charg l
		jsr     (A0)	;=>saute dans le boot de la disquette
T_E00984:      
		rts     

	***********************************
T_E00986:      
		move.l  #$C8,D5
		moveq   #0,D4
		move.b  $A82.w,D4	;pause demand en NVRAM: ne sert qu'au boot
		move.l  D4,D7
		muls    D5,D7	;*200
		cmp.l   $4BA,D7         ;_hz_200
		bcs     T_E00B22
	
	* affichage test ---- ram
		movea.w #0,A5
T_E009A4:      
		cmpa.w  #0,A5
		bne     T_E00A50
		
		bsr     A_E07936	:memory test:+affichage
		
		movea.w D0,A5
		beq     T_E00A84
		
		move.w  #$1B,-(SP)		;ESC
		move.l  #$30002,-(SP)
		trap    #13             ;Bconout
		move.w  #$70,4(SP)		;"p": inverse vido
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		move.w  #$1B,4(SP)		;ESC
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		move.w  #$77,4(SP)		;"w" dsactive dbordement
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		
		btst    #3,$184D.w	;rsol: bit 80c
		bne.s   T_E009F8
		lsl.l   #1,D5	;dlai *2	(40 colonnes
		lsr.l   #1,D4	;pause
T_E009F8:      
		subq.w  #1,D4
		move.l  D5,D6
		move.l  D4,D3
T_E009FE:      
		move.w  #$20,4(SP)		;" "
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		dbra    D4,T_E009FE
		
		move.w  #13,4(SP)		;CR
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		
		subq.l  #1,D3
T_E00A20:      
		move.w  #$20,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		dbra    D3,T_E00A20
		
		move.w  #$1B,4(SP)		:ESC
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		
		move.w  #$71,4(SP)		;"q": plus d'inverse
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		addq.l  #6,SP
T_E00A50:      
		cmp.l   $4BA,D6         ;_hz_200
		bhi.s   T_E00A84	;pause
		
		move.w  #$1B,-(SP)		;ESC
		move.l  #$30002,-(SP)
		trap    #13             ;Bconout
		
		move.w  #$4B,4(SP)		;"K"
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		move.w  #8,4(SP)		;8
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		addq.w  #6,SP
		
		add.l   D5,D6
T_E00A84:      
		cmpa.w  #0,A5
		beq.s   T_E00A92
		cmp.l   $4BA,D7         ;_hz_200
		bls.s   T_E00AF2	;fini...
T_E00A92:      
		move.l  #$10002,-(SP)
		trap    #13             ;Bconstat
		addq.l  #4,SP
		tst.l   D0	;1 car dispo
		beq     T_E009A4	;reboucle

	* fin pause par appui d'une touche
		move.l  #$20002,-(SP)	;lit le car
		trap    #13             ;Bconin
		addq.l  #4,SP
		
		and.l   #$FF0000,D0
		cmp.l   #$610000,D0	;undo
		bne.s   T_E00AE0
		
		move.b  $1187.w,D0
		and.b   #12,D0	:CTRL+ALT
		cmp.b   #12,D0	
		bne.s   T_E00AE0	;NON
		
		clr.l   -(SP)
		clr.l   -(SP)
		move.w  #2,-(SP)	;init:ZERO THE NVM
		move.w  #$2E,-(SP)
		trap    #14             ;NVMaccess
		adda.w  #12,SP
		jmp     $E0398C	;RESET violent
T_E00AE0:      
		cmpa.w  #0,A5	;retour memory test
		bne.s   T_E00AF2
		
		bsr     A_E07B84	;CR+LF et d0=-1
		move.l  D7,$4BA         ;_hz_200: force le temps
				;comme si le dcompte s'tait fait!
		bra.s   T_E00B22	;boot...

	* efface la ligne en cours et ramne le curseur au dbut.
	* ESC+"l" aurait suffit...
T_E00AF2:      
		move.l  D7,$4BA         ;_hz_200: idem au dessus
		
		move.w  #13,-(SP)		;CR: <=
		move.l  #$30002,-(SP)
		trap    #13             ;Bconout
		move.w  #$1B,4(SP)		;ESC
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		move.w  #$4B,4(SP)		;"K" effacer reste de ligne
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		addq.l  #6,SP

	* fin de la pause...
T_E00B22:      
		clr.w   $840

	* lit le premier mot de la nvram		
		pea     $A80.w
		move.w  #2,-(SP)		;->2
		clr.l   -(SP)		;read 0
		jsr     A_E0216C(PC)	;nvmaccess
		adda.w  #10,SP
		tst.w   D0
		beq.s   T_E00B42
		clr.w   $A80.w
T_E00B42:      
		move.w  #1,D1
T_E00B46:      
		move.w  D1,-(SP)
		
		move.w  $840,D4
		move.b  T_E00BA4(PC,D4.w),D4
		
		move.w  D4,-(SP)	;id
		move.l  $4C6.w,-(SP)    ;buffer:_dskbufp
		move.w  #1,-(SP)	;count
		clr.l   -(SP)	;sector
		jsr     $E017CE	;dmaread
		adda.w  #12,SP
		
		move.w  (SP)+,D1
		tst.l   D0
		beq.s   T_E00B76
		addq.l  #1,D0
		dbeq    D1,T_E00B46
		
		bra.s   T_E00B8C
T_E00B76:      
	* calcul de la checksum du boot: doit tre gale  $1234
	* pour tre excutable
		movea.l $4C6.w,A0       ;_dskbufp
		move.w  #$FF,D0
		moveq   #0,D1
T_E00B80:      
		add.w   (A0)+,D1
		dbra    D0,T_E00B80
		
		cmp.w   #$1234,D1	;checksum
		beq.s   T_E00BAE	;=>ok
T_E00B8C:      
		move.w  $840,D4
		addq.w  #1,D4
		move.w  D4,$840
		dc.w    $0C3B           ; ;
		dc.w    $00FF           ; 
		dc.w    $4008           ;@ 
		bne.s   T_E00B42
	
		rts     
	
	* ordre de test des disques durs pour chercher le boot
T_E00BA4:      
		dc.b	$8	;scsi 0: pour booter plus vite
		dc.b	$10	;ide 0
		dc.b	$9	;scsi 1
		dc.b	$a
		dc.b	$b
		dc.b	$c
		dc.b	$d
		dc.b	$e
		dc.b	$f	;scsi 7
		dc.b	$ff	;fin de la liste
	
	**********************************
	* boot ok
	* on saute dans le boot avec:
	* A0: pointe sur le boot (inutile)
	* D3="DMAr"
	* D4= id du boot
	* D5= 1er mot de la nvram systme
T_E00BAE:      
		movea.l $4C6.w,A0       ;_dskbufp
		move.l  #$444D4172,D3
		move.w  D4,D7
		asl.w   #5,D7
		move.w  $A80.w,D5
		move.l  $476,-(SP)      ;hdv_rw
		jsr     (A0)
		move.l  (SP)+,D0
		cmp.l   $476.w,D0       ;hdv_rw
		beq.s   T_E00B8C
		
		rts     

	***********************************
	* CARTOUCHE: Version disque
T_E00BD2:      
		lea     $FA0000,A0
		cmpi.l  #$ABCDEF42,(A0)+
		bne.s   T_E00C02
T_E00BE0:      
		btst    D0,4(A0)
		beq.s   T_E00BFC
		
		movem.l D0-A6,-(SP)
		move.l  4(A0),D0
		and.l   #$FFFFFF,D0
		movea.l D0,A0
		jsr     (A0)
		movem.l (SP)+,D0-A6
T_E00BFC:      
		tst.l   (A0)
		movea.l (A0),A0
		bne.s   T_E00BE0
T_E00C02:      
		rts     

	************************************
T_E00C04:      
		rts     
		
		adda.l  D1,A0
		clr.w   D0
		lea     $1F8(A0),A1
T_E00C0E:      
		cmp.w   (A0)+,D0
		bne.s   T_E00C1A
		add.w   #-$5AC,D0
		cmpa.l  A0,A1
		bne.s   T_E00C0E
T_E00C1A:      
		jmp     (A4)
	
	************************************
	* premier test reset froid
	* A6 pointe en T_E000A4
	* on revient tout le temps...
T_E00C1C:      
		cmpi.l  #$752019F3,$420.w ;memvalid
		bne.s   T_E00C38
		cmpi.l  #$237698AA,$43A.w ;memval2
		bne.s   T_E00C38
		cmpi.l  #$5555AAAA,$51A.w ;memval3
T_E00C38:      
		jmp     (A6)

	************************************

T_E00C3A:      
		dc.w    $0FFF           ; 
		btst    D7,D0
		dc.w    $00F0           ; 
		bset    D7,15(A0,D0.w)
		movep.w $FF(SP),D7
		bchg    D2,(A5)
		btst    D1,([$3F30FF3,A3,D0.l*8],$33F0F3F)
		dc.w    $03FF           ; 
		dc.w    $0000           ;  
		dc.w    $FFFF           ;
		dc.w    $00FF           ; 
		dc.w    $FF00           ; 
		ori.b   #$FF,D0
		dc.w    $0000           ;  
		dc.w    $FFFF           ;
		ori.b   #0,D0
		dc.w    $00FF           ; 
		dc.w    $FF00           ; 
		dc.w    $00FF           ; 
		dc.w    $00FF           ; 
		dc.w    $00FF           ; 
		dc.w    $AAAA           ;
		ori.l   #$55550055,-$AB(A2)
		ori.w   #$55FF,(A5)
		ori.w   #-$1,(A5)
		ori.w   #$5555,(A5)
		dc.w    $00FF           ; 
		frestore (A5)
		dc.w    $00FF           ; 
		dc.w    $55FF           ;U
		dc.w    $00FF           ; 
		ori.b   #0,D0

	************************************
	* HBL SYSTEM
T_E00C9A
		move.w  D0,-(SP)
		move.w  2(SP),D0
		and.w   #$700,D0
		bne.s   T_E00CAC
		ori.w   #$300,2(SP)
T_E00CAC:      
		move.w  (SP)+,D0
		rte     
	
	************************************
	* VBL SYSTEM
T_E00CB0	
		addq.l  #1,$466         ;_frclock
		subq.w  #1,$452         ;vblsem
		bmi     T_E00D4C
		movem.l D0-A6,-(SP)
		addq.l  #1,$462         ;_vbclock
		move.l  $45A.w,D0       ;colorptr
		beq.s   T_E00CF2
		bclr    #0,D0
		beq.s   T_E00CE0
		move.w  $18C4.w,D1
		lea     $FFFF9800.w,A1
		bra.s   T_E00CE6
T_E00CE0:      
		moveq   #7,D1
		lea     $FFFF8240.w,A1  ;color0
T_E00CE6:      
		movea.l D0,A0
T_E00CE8:      
		move.l  (A0)+,(A1)+
		dbra    D1,T_E00CE8
		clr.l   $45A.w          ;colorptr
T_E00CF2:      
		move.w  $454,D7         ;nvbls
		beq.s   T_E00D3E
		subq.l  #1,D7
		movea.l $456.w,A0       ;_vblqueue
T_E00D00:      
		movea.l (A0)+,A1
		cmpa.w  #0,A1
		beq.s   T_E00D12
		movem.l D7/A0,-(SP)
		jsr     (A1)
		movem.l (SP)+,D7/A0
T_E00D12:      
		dbra    D7,T_E00D00
		jsr     $E090F2
		tst.l   $45E.w          ;screenpt
		beq.s   T_E00D3A
		move.l  $45E.w,$44E.w   ;_v_bas_ad
		move.b  $450.w,$FFFF8203.w ;dbasel
		move.b  $44F.w,$FFFF8201.w ;dbaseh
		move.b  $451.w,$FFFF820D.w ;vbaselo
T_E00D3A:      
		bsr     A_E0429A
T_E00D3E:      
		tst.w   $4EE.w          ;_prt_cnt
		bne.s   T_E00D48
		bsr     T_E01216
T_E00D48:      
		movem.l (SP)+,D0-A6
T_E00D4C:      
		addq.w  #1,$452         ;vblsem
T_E00D52:      
		rte     

	************************************
	* VSYNC: modifie le niveau d'ipl !!!
T_E00D54:      
		move    sr,-(SP)
		andi    #-$401,sr
		move.l  $466,D0         ;_frclock
T_E00D60:      
		cmp.l   $466,D0         ;_frclock
		beq.s   T_E00D60
		move    (SP)+,sr
		rts     

	************************************
T_E00D6C
		move.l  $404,-(SP)      ;etv_critic
T_E00D72		
		moveq   #$FF,D0	;$404 pointe ici au dbut
		rts     

	************************************
	* TRAP 14
T_E00D76
		lea     T_E0156C(PC),A0
		bra.s   T_E00D80

	************************************
	* TRAP 13
T_E00D7C
		lea     T_E0153A(PC),A0

	************************************
	* TRAP 13&14
T_E00D80:      
		movea.l $4A2,A1         ;savptr
		
		move.w  (SP)+,D0	;SR
		move.w  D0,-(A1)
		move.l  (SP)+,-(A1)	;PC
		tst.w   $59E.w          ;_longframe
		beq.s   T_E00D94
		tst.w   (SP)+	;FORMAT
T_E00D94:      
		movem.l D3-D7/A3-A7,-(A1);sauvegarde tout les regs!
		
		move.l  A1,$4A2         ;savptr
		btst    #13,D0	;on tait en super?
		bne.s   T_E00DA6
		move    usp,SP	:non=>rcupre pile usp
T_E00DA6:      
		move.w  (SP)+,D0	;num fonction
		cmp.w   (A0)+,D0	;fct maxi
		bge.s   T_E00DC2	;=> quitte
		
		move.w  D0,D1
		lsl.w   #2,D1
		move.l  0(A0,D1.w),D1
		bclr    #0,D1
		movea.l D1,A0
		
		beq.s   T_E00DBE
		movea.l (A0),A0
T_E00DBE:      
		suba.l  A5,A5
		jsr     (A0)	;=> fonction
T_E00DC2:      
		movea.l $4A2,A1         ;savptr
		movem.l (A1)+,D3-D7/A3-A7
		tst.w   $59E.w          ;_longframe
		beq.s   T_E00DD4
		clr.w   -(SP)
T_E00DD4:      
		move.l  (A1)+,-(SP)
		move.w  (A1)+,-(SP)
		move.l  A1,$4A2         ;savptr
		rte     
	
	************************************
Rwabs
		btst    #0,1(SP)
		bne.s   T_E00DEE
		move.l  #$E00DF4,(SP)
T_E00DEE:      
		movea.l $476.w,A0       ;hdv_rw
		jmp     (A0)

		move.l  D0,-(SP)
		bsr     T_E0085A
		move.l  (SP)+,D0
		jmp     $E00DC2
		movea.l 4(SP),A0
		jmp     (A0)
		lea     $51E.w,A0       ;xconstat
		moveq   #0,D1
		bra.s   T_E00E26
		lea     $53E.w,A0       ;xconin
		moveq   #4,D1
		bra.s   T_E00E26
		lea     $55E.w,A0       ;xcostat
		moveq   #8,D1
		bra.s   T_E00E26
		lea     $57E.w,A0       ;xconout
		moveq   #12,D1
T_E00E26:      move.w  4(SP),D0
		cmp.w   #5,D0
		bls.s   T_E00E4E
		subq.l  #6,D0
		cmp.w   $11CA.w,D0
		bcc.s   T_E00E4A
		movea.l $11C6.w,A0
		asl.w   #3,D0
		adda.w  D0,A0
		add.w   D0,D0
		adda.w  D0,A0
		movea.l 0(A0,D1.w),A0
		jmp     (A0)
T_E00E4A:      moveq   #0,D0
		rts     
T_E00E4E:      lsl.w   #2,D0
		movea.l 0(A0,D0.w),A0
		jmp     (A0)

	************************************
	* table IOS
T_E00E56
		dc.w    $00E0           ; 
		cmpi.b  #$E0,D4
		move.l  -(A2),(A2)
		dc.w    $00E0           ; 
		move.l  A6,$E0(A2,D0.w)
		move.l  (A4)+,$E0(A1,D0.w)
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		movea.l $E0(A0,D0.w),A2
		move.l  $E0.w,(A2)
		move.l  -(A4),$E0(A2,D0.w)
		move.l  $E0(A6,D0.w),4(A1,D0.l*4)
		dc.w    $00E0           ; 
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		move.l  (A2),(A2)
		dc.w    $00E0           ; 
		move.l  D4,-(A2)
		dc.w    $00E0           ; 
		dc.w    $25D8           ;%
		dc.w    $00E0           ; 
		move.l  D4,$E0(A2)
		move.l  -(A2),$E0(A1)
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		move.l  $E0(A4),$251C00E0
		dc.w    $8D4C           ;L
		dc.w    $00E0           ; 
		move.l  $E0(A2,D0.w),$2554(A1)
		dc.w    $00E0           ; 
		pack    D0,D6,#E0
		cmpi.b  #$E0,D4
		dc.w    $0C04           ;  
		move.l  $4C2.w,D0       ;_drvbits
		rts     
		moveq   #0,D0
		move.b  $1187.w,D0
		move.w  4(SP),D1
		bmi.s   T_E00EEC
		move.b  D1,$1187.w
T_E00EEC:      
		rts     
		
		movea.l 4(SP),A0
		lea     $48E.w,A1       ;themd
		move.l  A1,(A0)
		clr.l   4(A0)
		clr.l   8(A0)
		clr.l   (A1)
		move.l  $432.w,4(A1)    ;_membot
		move.l  $436.w,D0       ;_memtop
		sub.l   $432.w,D0       ;_membot
		move.l  D0,8(A1)
		clr.l   12(A1)
		rts     
		move.w  4(SP),D0
		lsl.w   #2,D0
		suba.l  A0,A0
		lea     0(A0,D0.w),A0
		move.l  (A0),D0
		move.l  6(SP),D1
		bmi.s   T_E00F30
		move.l  D1,(A0)
T_E00F30:      rts     
		moveq   #0,D0
		move.w  $442.w,D0       ;_timr_ms
		rts     
		moveq   #0,D0
		move.b  $FFFF8201.w,D0  ;dbaseh
		lsl.w   #8,D0
		move.b  $FFFF8203.w,D0  ;dbasel
		lsl.l   #8,D0
		tst.b   $A87
		bne.s   T_E00F54
		move.b  $FFFF820D.w,D0  ;vbaselo
T_E00F54:      rts     
		move.l  $44E.w,D0       ;_v_bas_ad
		rts     
		jmp     $E10864
		move.l  4(SP),$45A.w    ;colorptr
		rts     
		move.w  4(SP),D1
		add.w   D1,D1
		and.w   #$1F,D1
		lea     $FFFF8240.w,A0  ;color0
		move.w  0(A0,D1.w),D0
		tst.b   $A87
		beq.s   T_E00F8A
		and.w   #$777,D0
		bra.s   T_E00F8E
T_E00F8A:      and.w   #$FFF,D0
T_E00F8E:      tst.w   6(SP)
		bmi.s   T_E00F9A
		move.w  6(SP),0(A0,D1.w)
T_E00F9A:      rts     
		movea.l A_E00014(PC),A0
		cmpi.l  #-$789ABCDF,(A0)
		bne.s   T_E00FB4
		cmpa.l  $42E.w,A0       ;phystop
		bge.s   T_E00FB4
		clr.l   (A0)
		bra     T_E00030
T_E00FB4:      rts     

	************************************
	* BUS ERROR ET AUTRES
	* => modification: ne pas afficher des bombes
	*    mais un text en clair
T_E00FB6:      
		movem.l D0-A7,$384.w    ;proc_dregs
		move.l  2(SP),$3C4.w    ;proc_enum (pc.24bits)
		move.w  6(SP),D0
		and.w   #$FFF,D0
		asr.w   #2,D0
		move.b  D0,$3C4.w       ;proc_enum (num vecteur
					;8bits poids fort)
		move    usp,A0
		move.l  A0,$3C8.w       ;proc_usp
		moveq   #15,D0
		lea     $3CC.w,A0       ;proc_stk
		movea.l SP,A1
T_E00FDE:      
		move.w  (A1)+,(A0)+
		dbra    D0,T_E00FDE
		
		move.l  #$12345678,$380.w ;proc_lives
		
		moveq   #0,D1
		move.b  $3C4.w,D1       ;proc_enum
		subq.w  #1,D1
		
		bsr.s   T_E0100C
		
		move.l  #$93A,$4A2.w    ;savptr
		move.w  #-$1,-(SP)
		move.w  #$4C,-(SP)
		trap    #1              ;Pterm
		bra     T_E00030
T_E0100C:      
		lea     $ACE.w,A0
		move.l  #$10001,(A0)+
		clr.w   (A0)
		lea     $AD4.w,A0
		moveq   #15,D6
		clr.l   (A0)+
		move.w  D6,(A0)+
		move.w  D6,(A0)+
		clr.w   (A0)+
		move.l  A0,-(SP)
		dc.w    $A000           ;init
		move.w  -$4(A0),D7
		movea.l (SP)+,A0
		lsr.w   #1,D7
		subq.w  #8,D7
		move.w  D7,(A0)+
		move.w  D6,(A0)+
		add.w   D6,D7
		move.w  D7,(A0)
		addq.w  #1,D6
		move.w  D1,D7
		pea     $E012DC	;mfdb
T_E01046:      
		bsr.s   T_E01082	;affiche mfdb
		add.w   D6,$ADC.w
		add.w   D6,$AE0.w
		dbra    D7,T_E01046
		addq.w  #4,SP
		moveq   #$1D,D7
T_E01058:      
		bsr     T_E00D54	;VSYNC
		dbra    D7,T_E01058
		rts     
		
	************************************
		
		ori.b   #1,D3
		ori.b   #0,D0
		ori.b   #0,D3
		ori.b   #7,D0
		ori.l   #$A00050,-(A0)
		dc.w    $0000           ;  
		bchg    D0,D0
		ori.b   #$A0,D0
		bchg    D0,D0

	************************************
	* affichage d'un bitmap: ptr sur mfdb sur la pile
T_E01082:      
		lea     $ABA.w,A0
		clr.l   (A0)
		move.l  A0,$AA2.w
		lea     $AA6.w,A1
		move.l  A1,$A9E.w
		movea.l 4(SP),A0	;mfdb source
		move.l  (A0)+,(A1)+
		move.l  (A0)+,(A1)+
		move.l  (A0)+,(A1)+
		move.w  (A0),(A1)
		
		dc.w    $A000           ;init
		clr.w   $36(A0)	;CLIP
		move.w  #1,$74(A0)	;COPYTRAN
		addq.w  #4,A0
		lea     $A90.w,A1
		move.l  A1,(A0)+	;CONTROL
		lea     $ACE.w,A1
		move.l  A1,(A0)+	;INTIN
		lea     $AD4.w,A1
		move.l  A1,(A0)	;PTSIN
		
		nop     		
		;dc.w	$a00e
		
		rts     

		movea.l 4(SP),A0
		movea.l 8(SP),A1
		move.w  #$3F,D0
T_E010D0:      
		move.b  (A0)+,(A1)+
		move.b  (A0)+,(A1)+
		move.b  (A0)+,(A1)+
		move.b  (A0)+,(A1)+
		move.b  (A0)+,(A1)+
		move.b  (A0)+,(A1)+
		move.b  (A0)+,(A1)+
		move.b  (A0)+,(A1)+
		dbra    D0,T_E010D0
		rts     
		
		move.l  $46A,-(SP)      ;hdv_init
		rts     
T_E010EE:      
		dc.b	"\AUTO\"
		;addq.w  #6,D1
		;subq.w  #2,(A4)
		;dc.w    $4F5C           ;O\
T_E010F4:      
		dc.b	"*.PRG",0
		;move.l  $5052(A6),D5
		;dc.w    $4700           ;G 
T_E010FE:		dc.w	$1234
		dc.w	$5678
		dc.w	$9abc
		dc.w	$def0
		;move.b  $78(A4,D5.w*8),D1
		;sub.l   #-$210FD0C4,D5
	
	************************************
	*  squence auto
T_E01102:
		move.l	#$bffff,-(sp)
		;dc.w    $000B           ;  
		;dc.w    $FFFF           ;
		trap    #13
		addq.l  #4,SP
		btst    #2,D0		;CONTROL
		bne.s   T_E01172	;=>oui
		
		move.l  $4C2.w,D0       ;_drvbits
		move.w  $446,D1         ;_bootdev
		btst    D1,D0
		beq.s   T_E01172	;partoche inexistante?
		
		lea     T_E010EE(PC),A0	;"\AUTO\"
		lea     T_E010F4(PC),A1	;"*.PRG",0
		move.l  (SP)+,$AE4	;pointeur de retour
		
		move.l  A0,$AE8.w
		move.l  A1,$AEC.w
		lea     T_E00855(PC),A0	;pointeur sur
					;chane nulle
		
		move.l  A0,-(SP)
		move.l  A0,-(SP)
		move.l  A0,-(SP)
		move.w  #5,-(SP)		;cre une basepage
		move.w  #$4B,-(SP)
		trap    #1              ;Pexec
		adda.w  #$10,SP
		
		movea.l D0,A0		;adresse de la basepage
		move.l  #$E01174,8(A0)
		move.l  A3,-(SP)
		move.l  D0,-(SP)
		move.l  A3,-(SP)
		move.w  #4,-(SP)
		move.w  #$4B,-(SP)
		trap    #1              ;Pexec
		adda.w  #$10,SP
		
		move.l  $AE4,-(SP)	;on sort de ce sous-programme
T_E01172:      
		rts     			;fin
	
	************************************
	* excution du dossier AUTO
T_E01174
		clr.l   -(SP)
		move.w  #$20,-(SP)
		trap    #1              ;Super
		addq.w  #6,SP
		
		movea.l D0,A4
		movea.l 4(SP),A6
		lea     $100(A6),SP
		
		move.l  #$100,-(SP)
		move.l  A6,-(SP)
		clr.w   -(SP)
		move.w  #$4A,-(SP)
		trap    #1              ;Mshrink
		addq.w  #6,SP
		tst.w   D0
		bne.s   T_E01208
		
		move.w  #7,-(SP)
		move.l  $AE8,-(SP)
		move.w  #$4E,-(SP)	;Fsfirst
		moveq   #8,D7
T_E011AE:      
		pea     $AF0
		move.w  #$1A,-(SP)
		trap    #1              ;Fsetdta
		addq.w  #6,SP
		trap    #1	;Fsfirst
		adda.w  D7,SP
		tst.w   D0
		bne.s   T_E01208
		
		movea.l $AE8,A0
		movea.l $AEC,A2
		lea     $B1C,A1
T_E011D6:      
		move.b  (A0)+,(A1)+
		cmpa.l  A0,A2
		bne.s   T_E011D6
		
		lea     $B0E,A0
T_E011E2:      
		move.b  (A0)+,(A1)+
		bne.s   T_E011E2
		
		pea     T_E00855(PC)
		pea     T_E00855(PC)
		pea     $B1C
		clr.w   -(SP)
		move.w  #$4B,-(SP)
		trap    #1              ;Pexec
		adda.w  #$10,SP
		moveq   #2,D7
		
		move.w  #$4F,-(SP)	;FsNext
		bra.s   T_E011AE
T_E01208:      
		lea     $8870,SP
		move.l  $AE4,-(SP)
		rts     

	************************************
T_E01216:      
		movea.l $502,A0         ;scr_dump
		jsr     (A0)
		move.w  #-$1,$4EE       ;_prt_cnt
		rts     
		move.l  $44E.w,$B3C.w   ;_v_bas_ad
		clr.w   $B40.w
		clr.w   D0
		move.b  $44C.w,D0       ;sshiftmd
		move.w  D0,$B4A.w
		add.w   D0,D0
		lea     T_E012A8(PC),A0
		move.w  0(A0,D0.w),$B42.w
		move.w  6(A0,D0.w),$B44.w
		clr.w   $B46.w
		clr.w   $B48.w
		move.l  #-$7DC0,$B4E.w
		clr.w   $B56.w
		move.w  $11C2.w,D1
		lsr.w   #3,D1
		and.w   #1,D1
		move.w  D1,$B4C.w
		move.w  $11C2.w,D1
		move.w  D1,D0
		lsr.w   #4,D0
		and.w   #1,D0
		move.w  D0,$B54.w
		and.w   #7,D1
		move.b  T_E012B4(PC,D1.w),D0
		move.w  D0,$B52
		pea     $B3C.w
		move.w  #1,$4EE.w       ;_prt_cnt
		bsr     A_E06854
		move.w  #-$1,$4EE       ;_prt_cnt
		addq.w  #4,SP
		rts     
T_E012A8:      
		bchg    D0,D0
		andi.l  #$28000C8,D0
		dc.w    $00C8           ; 
		bclr    D0,(A0)
T_E012B4:      
		dc.w    $0002           ;  
		dc.w    $01FF           ; 
		dc.w    $03FF           ; 
		dc.w    $FFFF           ;

	* dessin de la bombe
T_E012BC
		dc.w    $0600           ;  
		move.l  D0,-(A4)
		ori.l   #$484011F0,D0
		bset    D0,$FC(A0,D0.w*8)
		dc.w    $0FFE           ; 
		dc.w    $0DFE           ; 
		dc.w    $1FFF           ; 
		dc.w    $1FEF           ; 
		bset    D7,$FDE(A6)
		dc.w    $07FC           ; 
		bset    D1,$E0.w
	* mfdb de la bombe
T_E012DC
		dc.w    $00E0           ; 
		move.b  #$10,(A1)
		ori.b   #1,(A0)
		ori.b   #1,D0
	* ???
T_E012EA
		lea     $FFFFFA21.w,A0  ;tbdr
		lea     $FFFFFA1B.w,A1  ;tbcr
		bclr    #0,$FFFFFA07.w  ;iera
		moveq   #1,D4
		clr.b   (A1)
		move.b  #$F0,(A0)
		move.b  #8,(A1)
T_E01304:      cmp.b   (A0),D4
		bne.s   T_E01304
T_E01308:      move.b  (A0),D4
		move.w  #$267,D3
T_E0130E:      cmp.b   (A0),D4
		bne.s   T_E01308
		dbra    D3,T_E0130E
		move.b  #$10,(A1)
		jmp     (A6)
		bra     T_E00D54

	************************************
	* fonction compltement bizarre:
	*  recherche d'un mot magique ($12123456)
	*  tout les $200  partir de phystop
	*  une fois trouv, il compare le pointeur
	*  avec la valeur  l'adresse+4
	*  dans ce cas il calcul une checksum
	*  des 256 mots  partir du pointeur
	*  et le compare  $5678.
	*  Et enfin il saute dans la routine
	*  dont le pointeur est l'adresse+8.
	*  !!!!!!!!!!!!!!!
T_E01320:      
		movea.l $42E,A0         ;phystop
T_E01326:      
		suba.w  #$200,A0
		cmpa.w  #$400,A0
		bls.s   T_E0135C
		
		cmpi.l  #$12123456,(A0)
		bne.s   T_E01326
		
		cmpa.l  4(A0),A0
		bne.s   T_E01326
		
		clr.w   D0
		movea.l A0,A1
		move.w  #$FF,D1
T_E01346:      
		add.w   (A1)+,D0
		dbra    D1,T_E01346
		cmp.w   #$5678,D0
		bne.s   T_E01326
		
		move.l  A0,-(SP)
		jsr     8(A0)
		movea.l (SP)+,A0
		bra.s   T_E01326
T_E0135C:      
		rts     
	
	************************************
		
		lea     $E01FD4,A3
		lea     $E022A0,A4
		bra.s   T_E01388
		move.w  4(SP),$6CFE
		move.w  6(SP),$6CFC
		lea     $E0207A,A3
		lea     $E022CA,A4
T_E01388:      bsr     A_E02112
		bcc.s   T_E01390
		movea.l A4,A3
T_E01390:      jmp     (A3)
T_E01392:      lea     A_E00000(PC),A0
		lea     $940,A1
		moveq   #$2F,D0
T_E0139E:      move.b  0(A0,D0.w),0(A1,D0.w)
		dbra    D0,T_E0139E
		move.w  T_E013C6(PC),-$6(A1)
		move.l  4(A1),-$4(A1)
		move.w  T_E013CA(PC),(A1)
		move.w  $1E(A1),$1C(A1)
		move.l  A1,$4F2         ;_sysbase
		rts     
T_E013C6:      jmp     $0.w            ;reset_ssp
T_E013CA:      bra.s   T_E013C6
		bsr.s   T_E013F8
		move.w  D0,D4
		move.w  D0,D5
		lsr.w   #1,D5
		or.w    #-$2,D5
		jsr     $E09B2C
		move.w  D0,D3
		move.w  4(SP),D0
		bmi.s   T_E013F4
		and.w   D5,D0
		or.w    D4,D0
		bset    #0,D0
		jsr     $E09AF2
T_E013F4:      move.w  D3,D0
		rts     
T_E013F8:      move    sr,D1
		move.w  #0,D0
		suba.l  A0,A0
		movea.l SP,A2
		ori     #$700,sr
		movea.l 8(A0),A1
		move.l  #$E01418,8(A0)
		tst.w   -$7600(A0)
		moveq   #2,D0
		move.l  A1,8(A0)
		move    D1,sr
		movea.l A2,SP
		rts     
T_E01422:      bsr.s   T_E01432
T_E01424:      btst    #5,$FFFFFA0B.w  ;ipra
		beq.s   T_E01424
		clr.b   $FFFFFA19.w     ;tacr
		rts     
T_E01432:      move    sr,-(SP)
		ori     #$700,sr
		clr.b   $FFFFFA19.w     ;tacr
		bclr    #5,$FFFFFA07.w  ;iera
		move.b  #$DF,$FFFFFA0B.w ;ipra
		bclr    #5,$FFFFFA13.w  ;imra
		bset    #5,$FFFFFA07.w  ;iera
		move    (SP)+,sr
		move.b  D0,$FFFFFA1F.w  ;tadr
		ror.w   #8,D0
		move.b  D0,$FFFFFA19.w  ;tacr
		rol.w   #8,D0
		rts     
		movea.l 4(SP),A0
		movea.l 8(SP),A1
		movem.l D3-D7/A3,-(SP)
		moveq   #0,D1
		moveq   #0,D2
		moveq   #0,D3
		moveq   #0,D4
		moveq   #0,D5
		moveq   #0,D6
		moveq   #0,D7
		movea.w D7,A3
		move.l  A0,D0
		btst    #0,D0
		beq.s   T_E0148A
		move.b  D1,(A0)+
T_E0148A:      move.l  A1,D0
		sub.l   A0,D0
		and.l   #-$100,D0
		beq.s   T_E014C2
		lea     0(A0,D0.l),A0
		movea.l A0,A2
		lsr.l   #8,D0
T_E0149E:      movem.l D1-D7/A3,-(A2)
		movem.l D1-D7/A3,-(A2)
		movem.l D1-D7/A3,-(A2)
		movem.l D1-D7/A3,-(A2)
		movem.l D1-D7/A3,-(A2)
		movem.l D1-D7/A3,-(A2)
		movem.l D1-D7/A3,-(A2)
		movem.l D1-D7/A3,-(A2)
		subq.l  #1,D0
		bne.s   T_E0149E
T_E014C2:      cmpa.l  A0,A1
		beq.s   T_E014CA
		move.b  D1,(A0)+
		bra.s   T_E014C2
T_E014CA:      movem.l (SP)+,D3-D7/A3
		rts     
T_E014D0:      lea     $700,A0
		lea     $E4985A,A1
		move.w  #$3F,D0
T_E014E0:      move.l  (A1)+,(A0)+
		dbra    D0,T_E014E0
		pmove   $E4995A,crp
		pmove   $E49962,tc
		pmove   $E49966,tt0
		pmove   $E4996A,tt1
		rts     
		movea.l 4(SP),A0
		move.l  8(SP),D2
		movea.w 12(SP),A1
		clr.w   D0
		clr.w   D1
		clr.w   D3
		lea     $E4996E,A2
T_E01520:      move.w  D0,D1
		lsl.w   #8,D0
		lsr.w   #8,D1
		move.b  (A0),D3
		adda.l  A1,A0
		eor.b   D3,D1
		add.w   D1,D1
		move.w  0(A2,D1.w),D4
		eor.w   D4,D0
		subq.l  #1,D2
		bne.s   T_E01520
		rts     

	* table BIOS
T_E0153A:      
		dc.w    $000C           ;  
		dc.w    $00E0           ; 
		dc.w    $0EEE           ; 
		dc.w    $00E0           ; 
		dc.w    $0E08           ;  
		dc.w    $00E0           ; 
		moves.b (A0),D0
		moves.b -(A0),D0
		bset    D6,-(A0)
		dc.w    $00E0           ; 
		btst    D7,(A2)+
		dc.w    $00E0           ; 
		btst    D7,0(A2,D0.w)
		subi.w  #$E0,$18(A3,D0.l*8)
		dc.w    $0000           ;  
		dc.w    $047F           ; 
		dc.w    $00E0           ; 
		dc.w    $0ED6           ; 
		dc.w    $00E0           ; 
		dc.w    $0EDC           ; 

	* table XBIOS
T_E0156C:      
		ori.l   #$E03A62,-(A0)
		dc.w    $00E0           ; 
		cmpi.b  #$E0,D4
		dc.w    $0F3A           ; :
		dc.w    $00E0           ; 
		bchg    D7,(A6)
		dc.w    $00E0           ; 
		or.b    D5,(A6)
		dc.w    $00E0           ; 
		or.w    D5,(A4)+
		dc.w    $00E0           ; 
		bchg    D7,-(A2)
		dc.w    $00E0           ; 
		bchg    D7,$E0(A2)
		move.w  $E0(A4,D0.w),$B0(A6,D3.l*8)
		dc.w    $00E0           ; 
		move.w  -(A0),$E0(SP,D0.w)
		tst.w   -(A2)
		dc.w    $00E0           ; 
		move.l  A0,$E0(A1,D0.w)
		movea.l (A0),A4
		dc.w    $00E0           ; 
		move.l  -(A0),(A5)+
		dc.w    $00E0           ; 
		move.l  D0,-(A5)
		dc.w    $00E0           ; 
		move.w  -(A4),$E0(A5)
		dc.w    $4F04           ;O 
		dc.w    $00E0           ; 
		dc.w    $4FCE           ;O
		dc.w    $00E0           ; 
		chk     (A2)+,D0
		dc.w    $00E0           ; 
		move.b  (A6),D1
		dc.w    $00E0           ; 
		sub.b   D0,$E0(A2)
		move.b  $E0(A4),$135E(A1)
		dc.w    $00E0           ; 
		move.w  (A0),$E0(A5,D0.w)
		move.l  #$E0287A,$E0(A2)
		move.l  $E0(A0,D0.w),(A4)
		dc.w    $39DA           ;9
		dc.w    $00E0           ; 
		move.w  T_E016C6(PC),D5
		move.w  (A2),D5
		dc.w    $00E0           ; 
		move.w  $E0(A2),-(A5)
		move.w  D0,D6
		dc.w    $00E0           ; 
		move.w  (A4),D6
		dc.w    $00E0           ; 
		movea.w A0,A6
		dc.w    $00E0           ; 
		move.w  -(A6),D6
		dc.w    $00E0           ; 
		bvc.s   T_E01656
		dc.w    $00E0           ; 
		bchg    D6,(A4)
		dc.w    $00E0           ; 
		dc.w    $0E02           ;  
		dc.w    $00E0           ; 
		bclr    D7,(A4)+
		dc.w    $00E0           ; 
		cmpi.b  #$E0,D4
		not.w   $E0(A0,D0.w)
		dc.w    $17CE           ; 
		dc.w    $00E0           ; 
		dc.w    $17DC           ; 
		dc.w    $00E0           ; 
		move.l  $E0(A2,D0.w),D6
		cmpi.b  #$E0,D4
		move.l  $E0(A4),$2140(A0)
		dc.w    $00E0           ; 
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		dc.w    $0C04           ;  
T_E01656:      
		dc.w    $00E0           ; 
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		move.b  A4,$E00C04
		dc.w    $00E0           ; 
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
T_E016B8:      cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		dc.w    $0C04           ;  
T_E016C6:      dc.w    $00E0           ; 
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		dc.w    $868E           ;
		dc.w    $00E0           ; 
		divu    $E0(A2,D0.w),D3
		sbcd    D2,D3
		dc.w    $00E0           ; 
		or.w    D3,(A0)
		dc.w    $00E0           ; 
		dc.w    $877C           ;|
		dc.w    $00E0           ; 
		or.l    (A6),D4
		dc.w    $00E0           ; 
		or.l    D4,$E0(A2)
		dc.w    $8A88           ;
		dc.w    $00E0           ; 
		subq.b  #8,(A4)
		dc.w    $00E0           ; 
		subq.w  #8,-(A6)
		dc.w    $00E0           ; 
T_E016F8:      subq.l  #8,$E0.w
		dc.w    $537E           ;S~
		dc.w    $00E0           ; 
		dbls    D2,T_E017E2
		addq.l  #1,(A6)
		dc.w    $00E0           ; 
		addq.l  #2,$E0(A4,D0.w)
		scc     D0
		dc.w    $00E0           ; 
		bra.s   T_E0174C
		dc.w    $00E0           ; 
		bra.s   T_E01766
		dc.w    $00E0           ; 
T_E01718:      bra.s   T_E01796
		dc.w    $00E0           ; 
		bra.s   T_E016B8
T_E0171E:      dc.w    $00E0           ; 
T_E01720:      svc     -(A2)
		dc.w    $00E0           ; 
		subq.b  #4,$E0(A6)
		addq.w  #7,$E0(A4,D0.w)
		addq.l  #4,$E0(A6)
T_E01730:      bra.s   T_E0175E
		dc.w    $00E0           ; 
T_E01734:      bra.s   T_E0170A
		dc.w    $00E0           ; 
		bra.s   T_E01720
		dc.w    $00E0           ; 
		dc.w    $570E           ;W 
		dc.w    $00E0           ; 
		subq.w  #3,D4
		dc.w    $00E0           ; 
		bra.s   T_E01734
		dc.w    $00E0           ; 
		sle     -(A0)
		dc.w    $00E0           ; 
T_E0174C:      bsr.s   T_E01788
		dc.w    $00E0           ; 
T_E01750:      bsr.s   T_E017D0
		dc.w    $00E0           ; 
		bsr.s   T_E01718
		dc.w    $00E0           ; 
		bsr.s   T_E01730
		dc.w    $00E0           ; 
		dc.w    $51FA           ;Q
T_E0175E:      dc.w    $00E0           ; 
		addq.w  #1,D4
		dc.w    $00E0           ; 
		bsr.s   T_E01750
T_E01766:      dc.w    $00E0           ; 
		scc     D6
T_E0176A:      dc.w    $00E0           ; 
		subq.l  #2,A0
		dc.w    $00E0           ; 
		bls.s   T_E017D6
		dc.w    $00E0           ; 
		bls.s   T_E016F8
		dc.w    $00E0           ; 
		bhi.s   T_E01786
T_E0177A:      dc.w    $00E0           ; 
		bls.s   T_E01718
		dc.w    $00E0           ; 
		bls.s   T_E0177A
		dc.w    $00E0           ; 
		bcc.s   T_E01796
T_E01786:      dc.w    $00E0           ; 
T_E01788:      bcc.s   T_E017C6
		dc.w    $00E0           ; 
		bcc.s   T_E017E4
T_E0178E:      dc.w    $00E0           ; 
		beq.s   T_E017EA
		dc.w    $00E0           ; 
		bcc.s   T_E0171E
T_E01796:      dc.w    $00E0           ; 
		bcc.s   T_E0175E
		dc.w    $00E0           ; 
		bcs.s   T_E017A2
		dc.w    $00E0           ; 
		bne.s   T_E0176A
T_E017A2:      dc.w    $00E0           ; 
		beq.s   T_E0178E
		dc.w    $00E0           ; 
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		cmpi.b  #$E0,D4
		dc.w    $0C04           ;  
T_E017C6:      dc.w    $00E0           ; 
		fbor.w  T_E018AA
		dc.w    $F214           ; 
T_E017CE		
		move.b	#0,$b68
		;dc.w    $13FC           ; 
T_E017D0:      ;ori.b   #0,D0
		;dc.w    $0B68           ; h
T_E017D6:      move.w  #8,D1
		bra.s   T_E017E8
		move.b  #1,$B68
T_E017E4:      move.w  #10,D1
T_E017E8:      dc.w    $0C6F           ; o
T_E017EA:      ori.b   #14,(A0)
		bhi     T_E018F0
		cmpi.w  #15,14(SP)
		bhi.s   T_E01840
		lea     $B5E,A0
		move.b  D1,(A0)+
		move.b  5(SP),(A0)+
		move.b  6(SP),(A0)+
		move.b  7(SP),(A0)+
		move.b  9(SP),(A0)+
		clr.b   (A0)
		move.w  14(SP),D0
		moveq   #6,D2
		movea.l 10(SP),A0
		tst.b   $B68
		bne.s   T_E0182E
		bsr     T_E018F4
		bra     T_E018CA
T_E0182E:      bsr     T_E01900
		bra     T_E018CA
		movea.l A1,SP
		move.l  A0,$8.w         ;bus_error
		bra     T_E018F0
T_E01840:      movea.l $8.w,A0         ;bus_error
		movea.l SP,A1
		move.l  #$E01836,$8.w   ;bus_error
		tst.b   $FFF00039
		movea.l A1,SP
		move.l  A0,$8.w         ;bus_error
		move.b  15(SP),D0
		bsr     T_E01F02
		beq     T_E018F0
		moveq   #2,D0
		add.l   $4BA.w,D0       ;_hz_200
T_E0186C:      cmp.l   $4BA.w,D0       ;_hz_200
		bcc.s   T_E0186C
		pea     $B6A
		move.w  $12(SP),-(SP)
		bsr     T_E01E8E
		addq.w  #6,SP
		tst.w   D0
		bmi.s   T_E018EE
		bne.s   T_E018E2
		moveq   #2,D0
		add.l   $4BA.w,D0       ;_hz_200
T_E0188E:      cmp.l   $4BA.w,D0       ;_hz_200
		bcc.s   T_E0188E
		pea     $B6A
		bsr     T_E01F32
		addq.w  #4,SP
		move.w  14(SP),-(SP)
		move.l  12(SP),-(SP)
		dc.w    $3F2F           ;?/
T_E018AA:      dc.w    $000E           ;  
		move.l  12(SP),-(SP)
		move.w  D2,-(SP)
		move.w  D1,-(SP)
		tst.b   $B68
		bne.s   T_E018C2
		bsr     T_E01DC8
		bra.s   T_E018C6
T_E018C2:      bsr     T_E01E06
T_E018C6:      adda.w  #$10,SP
T_E018CA:      
		move    sr,-(SP)
		ori     #$700,sr
		movec.l CACR,D1
		ori.w   #$808,D1
		movec.l D1,CACR
		move    (SP)+,sr
		tst.w   D0
		ble.s   T_E018EE
T_E018E2:      
		moveq   #$F5,D0
		tst.b   $B68
		beq.s   T_E018EE
		moveq   #$F6,D0
T_E018EE:      
		rts     
T_E018F0:      
		moveq   #$F1,D0
		bra.s   T_E018EE
T_E018F4:      
		bsr     T_E01A9E
		rts     
		bsr     T_E01992
		rts     
T_E01900:      bsr     T_E01B18
		rts     
		bsr     T_E019DC
		rts     
T_E0190C:      move.l  #$258,D0
		bra.s   T_E01916
T_E01914:      moveq   #$14,D0
T_E01916:      move.l  D0,-(SP)
		moveq   #2,D0
		add.l   $4BA.w,D0       ;_hz_200
T_E0191E:      cmp.l   $4BA.w,D0       ;_hz_200
		bge.s   T_E0191E
		move.l  (SP)+,D0
		add.l   $4BA.w,D0       ;_hz_200
T_E0192A:      cmp.l   $4BA.w,D0       ;_hz_200
		bcs.s   T_E0193C
		btst    #5,$FFFFFA01.w  ;gpip
		bne.s   T_E0192A
		moveq   #0,D0
		rts     
T_E0193C:      moveq   #$FF,D0
		rts     
T_E01940:      bsr.s   T_E0190C
		bmi.s   T_E01964
		move    sr,-(SP)
		ori     #$700,sr
		movec.l CACR,D0
		ori.w   #$800,D0
		movec.l D0,CACR
		move    (SP)+,sr
		move.w  D1,$FFFF8606.w  ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		and.w   #$FF,D0
T_E01964:      move.l  $4BA.w,$B5A     ;_hz_200
		addq.l  #2,$B5A
		rts     
T_E01974:      move.w  #$80,$FFFF8606.w ;fifo
		sf      $43E.w          ;flock
		rts     
T_E01980:      move.l  D0,-(SP)
		move.l  $B5A,D0
T_E01988:      cmp.l   $4BA.w,D0       ;_hz_200
		bcc.s   T_E01988
		move.l  (SP)+,D0
		rts     
T_E01992:      movea.l $8.w,A1         ;bus_error
		movea.l SP,A2
		move.l  #$E01A20,$8.w   ;bus_error
		tst.w   $FFFF8606.w     ;fifo
		move.l  A1,$8.w         ;bus_error
		movea.l A2,SP
		st      $43E.w          ;flock
		bsr.s   T_E01980
		movea.w #-$79FC,A1
		bsr     T_E01A6E
		move.w  #$190,2(A1)
		bsr     T_E01A8C
		move.w  #$90,2(A1)
		bsr     T_E01A8C
		bsr     T_E01A86
		lea     $B5E,A0
		moveq   #0,D1
		bsr.s   T_E01A2A
		bra.s   T_E01974
T_E019DC:      movea.l $8.w,A1         ;bus_error
		movea.l SP,A2
		move.l  #$E01A20,$8.w   ;bus_error
		tst.w   $FFFF8604.w     ;diskctl
		move.l  A1,$8.w         ;bus_error
		movea.l A2,SP
		st      $43E.w          ;flock
		bsr.s   T_E01980
		movea.w #-$79FC,A1
		bsr.s   T_E01A6E
		move.w  #$90,2(A1)
		bsr     T_E01A8C
		move.w  #$190,2(A1)
		bsr.s   T_E01A8C
		bsr.s   T_E01A86
		move.l  #$100,D1
		bsr.s   T_E01A2A
		bra     T_E01974
		moveq   #$F1,D0
		movea.l A2,SP
		move.l  A1,$8.w         ;bus_error
		rts     
T_E01A2A:      move.b  #$88,D1
		move.w  D1,2(A1)
		move.b  #$8A,D1
		lea     $B5E,A2
		lsl.b   #5,D0
		or.b    D0,(A2)
		subq.w  #2,D2
T_E01A42:      swap    D1
		move.b  (A2)+,D1
		swap    D1
		move.l  D1,(A1)
		bsr     T_E01914
		bmi.s   T_E01A6C
		dbra    D2,T_E01A42
		move.w  D1,2(A1)
		move.b  #0,D1
		swap    D1
		move.b  (A2),D1
		swap    D1
		move.l  D1,(A1)
		move.b  #$8A,D1
		bsr     T_E01940
T_E01A6C:      rts     
T_E01A6E:      move.l  A0,-(SP)
		move.b  3(SP),$FFFF860D.w ;dmalow
		move.b  2(SP),$FFFF860B.w ;dmamid
		move.b  1(SP),$FFFF8609.w ;dmahigh
		addq.l  #4,SP
		rts     
T_E01A86:      move.w  #$FF,(A1)
		rts     
T_E01A8C:      tst.b   $FFFFFA01.w     ;gpip
		tst.b   $FFFFFA01.w     ;gpip
		tst.b   $FFFFFA01.w     ;gpip
		tst.b   $FFFFFA01.w     ;gpip
		rts     
T_E01A9E:      st      $43E.w          ;flock
		andi.w  #7,D0
		movem.l D1/D2/A0,-(SP)
		bsr     T_E01B86
		movem.l (SP)+,D1/D2/A0
		tst.w   D0
		bmi.s   T_E01B0A
		move.w  #$89,$FFFF8606.w ;fifo
		move.w  #0,$FFFF8604.w  ;diskctl
		move.w  #$8B,$FFFF8606.w ;fifo
		move.w  #1,$FFFF8604.w  ;diskctl
		move.w  #$8F,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		movea.l A0,A1
T_E01ADA:      bsr     T_E01D74
		bsr     T_E01D16
		bmi.s   T_E01B0A
		move.w  #$8D,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		btst    #3,D0
		beq.s   T_E01B06
		move.w  #$88,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		move.b  D0,(A1)+
		bsr     T_E01D32
		bra.s   T_E01ADA
T_E01B06:      bsr     T_E01CC0
T_E01B0A:      move.w  #$8F,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D1  ;diskctl
		bra     T_E01974
T_E01B18:      st      $43E.w          ;flock
		andi.w  #7,D0
		movem.l D1/D2/A0,-(SP)
		bsr.s   T_E01B86
		movem.l (SP)+,D1/D2/A0
		tst.w   D0
		bmi.s   T_E01B78
		move.w  #$8B,$FFFF8606.w ;fifo
		move.w  #0,$FFFF8604.w  ;diskctl
		move.w  #$8F,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		movea.l A0,A1
T_E01B46:      bsr     T_E01D74
		bsr     T_E01D16
		bmi.s   T_E01B78
		move.w  #$8D,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		btst    #3,D0
		beq.s   T_E01B74
		moveq   #0,D0
		move.b  (A1)+,D0
		move.w  #$88,$FFFF8606.w ;fifo
		move.w  D0,$FFFF8604.w  ;diskctl
		bsr     T_E01D32
		bra.s   T_E01B46
T_E01B74:      bsr     T_E01CC0
T_E01B78:      move.w  #$8F,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D1  ;diskctl
		bra     T_E01974
T_E01B86:      movem.l D1/D2/A0,-(SP)
		move.w  D0,-(SP)
		bsr.s   T_E01BCE
		addq.l  #2,SP
		movem.l (SP)+,D1/D2/A0
		tst.w   D0
		bmi.s   T_E01BCC
		move.w  #$8B,$FFFF8606.w ;fifo
		move.w  #2,$FFFF8604.w  ;diskctl
		move.w  #$89,$FFFF8606.w ;fifo
		move.w  #1,$FFFF8604.w  ;diskctl
		bsr     T_E01D7E
		lea     $B5E,A1
		subq.w  #1,D2
T_E01BBC:      move.b  (A1)+,D0
		bsr     T_E01D5C
		tst.w   D0
		bmi.s   T_E01BCC
		dbra    D2,T_E01BBC
		moveq   #0,D0
T_E01BCC:      rts     
T_E01BCE:      bsr     T_E01D74
T_E01BD2:      move.w  #$8C,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		btst    #6,D0
		beq.s   T_E01BEA
		cmp.l   (A0),D1
		bhi.s   T_E01BD2
		bra     T_E01C78
T_E01BEA:      move.w  #$8B,$FFFF8606.w ;fifo
		move.w  #0,$FFFF8604.w  ;diskctl
		move.w  #$8C,$FFFF8606.w ;fifo
		move.w  #0,$FFFF8604.w  ;diskctl
		move.w  #$89,$FFFF8606.w ;fifo
		move.w  #12,$FFFF8604.w ;diskctl
		clr.w   D0
		move.w  4(SP),D1
		bset    D1,D0
		move.w  #$88,$FFFF8606.w ;fifo
		move.w  D0,$FFFF8604.w  ;diskctl
		move.w  #$89,$FFFF8606.w ;fifo
		move.w  #5,$FFFF8604.w  ;diskctl
		move.w  #$8A,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		andi.b  #$FE,D0
		move.w  #$8A,$FFFF8606.w ;fifo
		move.w  D0,$FFFF8604.w  ;diskctl
		move.w  #$89,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		andi.b  #$F7,D0
		move.w  #$89,$FFFF8606.w ;fifo
		move.w  D0,$FFFF8604.w  ;diskctl
		nop     
		nop     
		bsr     T_E01D74
T_E01C64:      move.w  #$8C,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		btst    #6,D0
		bne.s   T_E01C7C
		cmp.l   (A0),D1
		bhi.s   T_E01C64
T_E01C78:      moveq   #$FF,D0
		bra.s   T_E01C7E
T_E01C7C:      clr.w   D0

T_E01C7E:	
		move.w  #$89,$FFFF8606.w ;fifo
		move.w  #0,$FFFF8604.w  ;diskctl
		rts     

*---------------------------------------------------------------------------*		
		
		*----------------*
		* Reset SCSI
T_E01C8C
		move.w  #$89,$FFFF8606.w ;fifo: ICR
		move.w  #$80,$FFFF8604.w ;diskctl: Reset SCSI
		bsr     T_E01D74
T_E01C9C:      
		cmp.l   (A0),D1	;attente: 255ms
		bhi.s   T_E01C9C
		
		move.w  #$89,$FFFF8606.w ;fifo: ICR
		move.w  #0,$FFFF8604.w  ;diskctl: enlve le Reset
		bsr     T_E01D7E
T_E01CB0:      
		cmp.l   (A0),D1	;attente: 1.505s
		bhi.s   T_E01CB0
		move.w  #$8F,$FFFF8606.w ;fifo: reg 7
		move.w  $FFFF8604.w,D0  ;diskctl: efface le bit d'int
		rts     

		*----------------*

*---------------------------------------------------------------------------*		

T_E01CC0:      
		bsr     T_E01D74
		move.w  #$8B,$FFFF8606.w ;fifo
		move.w  #3,$FFFF8604.w  ;diskctl
		move.w  #$8F,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		bsr.s   T_E01D16
		bmi.s   T_E01D14
		move.w  #$88,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		andi.w  #$FF,D0
		move.l  D0,-(SP)
		bsr     T_E01D74
		bsr.s   T_E01D32
		tst.w   D0
		beq.s   T_E01CFC
T_E01CF8:      addq.l  #4,SP
		bra.s   T_E01D14
T_E01CFC:      bsr.s   T_E01D74
		bsr.s   T_E01D16
		bmi.s   T_E01CF8
		move.w  #$88,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		bsr.s   T_E01D32
		tst.w   D0
		bmi.s   T_E01CF8
		move.l  (SP)+,D0
T_E01D14:      rts     
T_E01D16:      move.w  #$8C,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		btst    #5,D0
		bne.s   T_E01D2E
		cmp.l   (A0),D1
		bhi.s   T_E01D16
		moveq   #$FF,D0
		bra.s   T_E01D30
T_E01D2E:      moveq   #0,D0
T_E01D30:      rts     
T_E01D32:      move.w  #$89,$FFFF8606.w ;fifo
		move.w  $FFFF8604.w,D0  ;diskctl
		ori.b   #$11,D0
		move.w  #$89,$FFFF8606.w ;fifo
		move.w  D0,$FFFF8604.w  ;diskctl
		andi.b  #$EF,D0
		move.w  #$89,$FFFF8606.w ;fifo
		move.w  D0,$FFFF8604.w  ;diskctl
		moveq   #0,D0
		rts     
T_E01D5C:      move.w  D0,-(SP)
		bsr.s   T_E01D16
		bmi.s   T_E01D70
		move.w  (SP),D0
		move.w  #$88,$FFFF8606.w ;fifo
		move.w  D0,$FFFF8604.w  ;diskctl
		bsr.s   T_E01D32
T_E01D70:      addq.l  #2,SP
		rts     

*---------------------------------------------------------------------------*		

		*----------------*
		* initialise une pause de 51*5ms=255ms
T_E01D74:      
		movea.w #$4BA,A0
		moveq   #$33,D1
		add.l   (A0),D1
		rts     

		*----------------*

*---------------------------------------------------------------------------*		

		*----------------*
		* initialise une pause de 301*5ms=1.505s
T_E01D7E:      
		movea.w #$4BA,A0
		move.l  #$12D,D1
		add.l   (A0),D1
		rts     

		*----------------*

*---------------------------------------------------------------------------*		

T_E01D8C:      
		move.l  #$7D0,D0
		add.l   $4BA.w,D0       ;_hz_200
T_E01D96:      
		btst    #5,$FFFFFA01.w  ;gpip
		beq.s   T_E01DA8
		cmp.l   $4BA.w,D0       ;_hz_200
		bhi.s   T_E01D96
		moveq   #$FF,D0
		bra.s   T_E01DC6
T_E01DA8:      
		moveq   #0,D0
		move.b  $FFF0001D,D0
		btst    #0,D0
		bne.s   T_E01DC0
		btst    #3,D0
		bne.s   T_E01DC6
		moveq   #0,D0
		bra.s   T_E01DC6
T_E01DC0:      
		move.b  $FFF00005,D0
T_E01DC6:      
		rts     
T_E01DC8:      
		bsr     T_E01E4E
		movea.l 14(SP),A0
		move.b  13(SP),$FFF00009
		move.w  12(SP),D1
		subq.w  #1,D1
		move.b  #0,$FFF00039
		move.b  #$20,$FFF0001D
T_E01DEE:      bsr.s   T_E01D8C
		tst.w   D0
		bmi.s   T_E01E04
		btst    #3,D0
		beq.s   T_E01E04
		bsr     T_E01EC6
		dbra    D1,T_E01DEE
		moveq   #0,D0
T_E01E04:      rts     
T_E01E06:      bsr.s   T_E01E4E
		movea.l 14(SP),A0
		move.b  13(SP),$FFF00009
		move.w  12(SP),D1
		subq.w  #1,D1
		move.b  #0,$FFF00039
		move.b  #$30,$FFF0001D
T_E01E2A:      btst    #3,$FFF00039
		beq.s   T_E01E2A
T_E01E34:      bsr     T_E01EE4
		bsr     T_E01D8C
		tst.w   D0
		bmi.s   T_E01E4C
		btst    #3,D0
		beq.s   T_E01E4C
		dbra    D1,T_E01E34
		moveq   #0,D0
T_E01E4C:      rts     
T_E01E4E:      move.l  12(SP),D1
		move.w  8(SP),D2
		move.w  10(SP),D0
		mulu    D0,D2
		divu    D2,D1
		move.b  D1,$FFF00011
		lsr.l   #8,D1
		move.b  D1,$FFF00015
		lsr.l   #8,D1
		divu    D0,D1
		move.w  $16(SP),D0
		andi.b  #7,D0
		lsl.b   #4,D0
		or.b    D0,D1
		move.b  D1,$FFF00019
		swap    D1
		addq.w  #1,D1
		move.b  D1,$FFF0000D
		rts     
T_E01E8E:      move.w  4(SP),D0
		andi.b  #7,D0
		lsl.b   #4,D0
		move.b  D0,$FFF00019
		movea.l 6(SP),A0
		move.b  #0,$FFF00039
		move.b  #$EC,$FFF0001D
		bsr     T_E01D8C
		tst.w   D0
		bmi.s   T_E01EC4
		btst    #3,D0
		beq.s   T_E01EC4
		bsr.s   T_E01EC6
		moveq   #0,D0
T_E01EC4:      rts     
T_E01EC6:      moveq   #$1F,D0
		lea     $FFF00000,A1
T_E01ECE:      move.w  (A1),(A0)+
		move.w  (A1),(A0)+
		move.w  (A1),(A0)+
		move.w  (A1),(A0)+
		move.w  (A1),(A0)+
		move.w  (A1),(A0)+
		move.w  (A1),(A0)+
		move.w  (A1),(A0)+
		dbra    D0,T_E01ECE
		rts     
T_E01EE4:      moveq   #$1F,D0
		lea     $FFF00000,A1
T_E01EEC:      move.w  (A0)+,(A1)
		move.w  (A0)+,(A1)
		move.w  (A0)+,(A1)
		move.w  (A0)+,(A1)
		move.w  (A0)+,(A1)
		move.w  (A0)+,(A1)
		move.w  (A0)+,(A1)
		move.w  (A0)+,(A1)
		dbra    D0,T_E01EEC
		rts     
T_E01F02:      andi.b  #7,D0
		lsl.b   #4,D0
		move.b  D0,$FFF00019
		move.b  #$50,D1
		move.l  #$3E8,D0
		add.l   $4BA.w,D0       ;_hz_200
T_E01F1C:      cmp.b   $FFF00039,D1
		beq.s   T_E01F2E
		cmp.l   $4BA.w,D0       ;_hz_200
		bcc.s   T_E01F1C
		moveq   #0,D0
		rts     
T_E01F2E:      moveq   #1,D0
		rts     
T_E01F32:      movea.l 4(SP),A0
		adda.w  #$50,A0
		move.l  A0,-(SP)
		pea     $E01F78
		move.w  #6,-(SP)
		bsr.s   T_E01F80
		adda.w  #10,SP
		tst.w   D0
		bne.s   T_E01F5E
		move.w  #$267,D0
		move.w  #4,D1
		move.w  #$11,D2
		bra.s   T_E01F6E
T_E01F5E:      movea.l 4(SP),A0
		move.w  2(A0),D0
		move.w  6(A0),D1
		move.w  12(A0),D2
T_E01F6E:      rts     
		dc.w    $436F           ;Co
		bgt.s   T_E01FE2
		bcs.s   T_E01FE8
		dc.w    $0000           ;  
		dc.w    $4350           ;CP
		move.w  $34(A0,D3.w*2),D1
		dc.w    $0000           ;  
T_E01F80:      movem.l D1/A0/A1,-(SP)
		move.w  $10(SP),D1
		subq.w  #1,D1
		movea.l $12(SP),A0
		movea.l $16(SP),A1
		moveq   #1,D0
T_E01F94:      cmpm.b  (A0)+,(A1)+
		bne.s   T_E01F9E
		dbra    D1,T_E01F94
		moveq   #0,D0
T_E01F9E:      movem.l (SP)+,D1/A0/A1
		rts     
		
		bsr     A_E02112
		bcs.s   T_E01FD2
		move.b  #13,$FFFF8961.w ;rtc_rnr
		move.b  $FFFF8963.w,D0  ;rtc_data
		btst    #7,D0
		bne.s   T_E01FC6
		move.l  #$12C80000,-(SP)
		bsr     A_E0207A
		addq.w  #4,SP
T_E01FC6:      
		bsr.s   T_E01FD4
		cmp.l   #-1,D0
		beq.s   T_E01FD2
		moveq   #0,D0
T_E01FD2:      
		rts     
T_E01FD4:      
		bsr     A_E02112
		bcs.s   T_E01FD2
		move.b  #13,$FFFF8961.w ;rtc_rnr
		dc.w    $0838           ; 8
T_E01FE2:      
		dc.w    $0007           ;  
		or.w    D4,-(A3)
		dc.w    $6700           ;g 
T_E01FE8:      
		dc.w    $008E           ; 
		move    sr,D2
		move.w  D2,D0
		or.w    #$700,D0
T_E01FF2:      
		move.b  #10,$FFFF8961.w ;rtc_rnr
		btst    #7,$FFFF8963.w  ;rtc_data
		bne.s   T_E01FF2
		END
