*----------------------------------------------------------------------------*
*		crit la nvram (NVM.DAT)
*----------------------------------------------------------------------------*

		OPT	C-
		opt	O+
		OPT	OW-

		OPT	X-
		
		COMMENT	HEAD=7

		include	FLASH.RS

		OUTPUT	D:\EXECS\PUT_NVM.PRG

*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*

		*-------------*

		include	GEM.EQU
		include	BIOS.EQU
		include	XBIOS.EQU

		include	DOLMEN.RS
		include	BORIS.RS

		*-------------*

*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*

		*-------------*
begin
		move.l	4(sp),cent_base
		lea	cent_stack,sp

		move.l	cent_base,a0
		move.l	12(a0),a1
		add.l	20(a0),a1
		add.l	28(a0),a1

		pea	256(a1)
		pea	(a0)
		clr	-(sp)
		GEM	MSHRINK
		
		clr	-(sp)
		pea	name_dat(pc)
		GEM	Fopen
		move	d0,d7
		
		pea	nvm_buffer(pc)
		pea	50.w
		move	d7,-(sp)
		GEM	Fread
		
		move	d7,-(sp)
		GEM	Fclose

		pea	write_nvm
		XBIOS	Supexec

		
		
		GEM	Pterm0

		*-------------*


*-------------------------------------------------------------------------*

		*/------------/*
		* Lit la nvram
		cnop	0,16
write_nvm
		lea	nvm_buffer(pc),a0

		moveq	#nvm_sum-nvm_vars,d0
		moveq	#nvm_vars,d1
.copie
		stnvm	(a0)+,d1
		addq	#1,d1
		dbra	d0,.copie

		*/------------/*

		rts

		*/------------/*

*----------------------------------------------------------------------------*
		DATA
*----------------------------------------------------------------------------*

name_dat		dc.b	"NVM.DAT",0
		even

*----------------------------------------------------------------------------*
		BSS
*----------------------------------------------------------------------------*

		*-------------*

cent_base		ds.l	1

nvm_buffer	ds.b	50

stack		ds.l	1000	
cent_stack	ds.l	1

		*-------------*

*----------------------------------------------------------------------------*
