*-------------------------------------------------------------------------*		
*		TOS 4.02
*-------------------------------------------------------------------------*		
		TEXT
*-------------------------------------------------------------------------*		

		dc.l	setup
		dc.l	first_time
				
		*-------------------*
		* Le Setup...
Setup
		move    #$2700,sr
		
		;btst	#7,$f6000000
		;bne.s	.turbo
		
		;move.b	#%00100101,$ffff8007.w
		;jmp	$e00030
;.turbo
	* reset combel (et init chip-ram?)
		move.w  $FFFF8006.w,D0
		reset   
		move.w  $FFFF8006.w,D0
		
	* coupe les GPIOs
		move.w  #7,$FFFF8940.w

	* teste cartouche diagnostique
		cmpi.l  #$FA52235F,$FA0000
		bne.s   T_5A
		lea     T_5A(PC),A6
		jmp     $FA0004
	* init
T_5A:          
	* le processeur
		move.l  #$808,D0
		movec.l D0,CACR
		moveq   #0,D0
		movec.l D0,VBR
	* pmmu
		dc.l	$f0394000
		dc.l	$e493D0		;0
		dc.l	$f0390800
		dc.l	$e493D0		;0
		dc.l	$f0390c00
		dc.l	$e493D0		;0
		
		;pmove   $E493D0,tc
		;pmove   $E493D0,tt0
		;pmove   $E493D0,tt1
		
	* vido
		move.w  #$20,$FFFF828C.w
		move.w  #$10,$FFFF8282.w
		ori.b   #$25,$FFFF8007.w
		
	* on arrive ici au premier dmarrage car ce qui prcde
	* ne sert qu'aprs!
first_time
	* dmarrage  froid?
		btst    #6,$FFFF8007.w
		
		beq.s   T_C8	;non...
		
		lea     T_A4(PC),A6
		jmp     T_BDE	
T_A4:          
		bne.s   T_C8
		move.b  $424.w,$FFFF8001.w ;memconf
T_AC:          
		cmpi.l  #$31415926,$426.w ;resvalid
		bne.s   T_C8
		move.l  $42A.w,D0       ;resvector
		btst    #0,D0
		bne.s   T_C8
		movea.l D0,A0
		lea     T_AC(PC),A6
		jmp     (A0)	;=>reset_vector

	* init yamaha
T_C8:          
		lea     $FFFF8800.w,A0  ;giselect
		move.b  #7,(A0)	;reg 7: mixer control
		move.b  #$C0,2(A0)	;port A et B out
		move.b  #14,(A0)	;reg 14: port A
		move.b  #7,2(A0)	;select drive a et b et face 2?
	
	* palette ST
		lea     $FFFF8240.w,A1  ;color0
		moveq   #15,D0
		lea     $E00BFC,A0
T_EA:          
		move.w  (A0)+,(A1)+
		dbra    D0,T_EA
	
	* palette Falcon
		move.b  #0,$FFFF8266.w
		lea     $FFFF9800.w,A1
		moveq   #15,D0
T_FC:          
		move.l  (A0)+,(A1)+
		dbra    D0,T_FC
		
	* vido pipo: ST BASSE en $10000
		move.b  #0,$FFFF8260.w  ;shiftmd
		move.b  #1,$FFFF8201.w  ;dbaseh
		clr.b   $FFFF8203.w     ;dbasel

	* reset  froid, encore!
		bset    #6,$FFFF8007.w
		beq.s   T_13A
		cmpi.l  #$752019F3,$420.w ;memvalid
		bne.s   T_13A
		cmpi.l  #$237698AA,$43A.w ;memval2
		bne.s   T_13A
		cmpi.l  #$5555AAAA,$51A.w ;memval3
		beq     T_1DA
T_13A:         
	* rinitialise la machine: reset  froid

	* Chip-Ram
		move.b	$ffff8006.w,d0
		lsr.b	#3,d0
		and	#%110,d0	;bits de config
		
		move.l	#1*1024*1024,d5
		lsl.l	d0,d5
		subq	#%100,d0
		blo.s	.chip_ok
		move.l	#14*1024*1024,d5	;cas 14Mo
		
.chip_ok
	* efface la RAM  partir de $300-> la fin -$100
		move.l  D0,D5
		lea     $400.w,A4       ;etv_timer
		move.l  D5,D4
		sub.l   A4,D4
		lsr.l   #8,D4	;/256
		subq.l  #1,D4	;-1
		
		lea     $200.w,A5	;incrment

		moveq   #0,D0	;effaceurs...
		movea.l D0,A0
		moveq   #0,D1
		movea.l D1,A1
		moveq   #0,D2
		movea.l D2,A2
		moveq   #0,D3
		movea.l D3,A3
		
		lea     $100(A4),A4	;init  $500.w
T_18A:         
		movem.l D0-D3/A0-A3,-(A4)	;32 octets
		movem.l D0-D3/A0-A3,-(A4)
		movem.l D0-D3/A0-A3,-(A4)
		movem.l D0-D3/A0-A3,-(A4)
		movem.l D0-D3/A0-A3,-(A4)
		movem.l D0-D3/A0-A3,-(A4)
		movem.l D0-D3/A0-A3,-(A4)
		movem.l D0-D3/A0-A3,-(A4)	;256 en tout
		adda.l  A5,A4		;+256
		dbra    D4,T_18A
		
		move.l  D5,$42E.w       ;phystop
		
		move.l  #$752019F3,$420.w ;memvalid
		move.l  #$237698AA,$43A.w ;memval2
		move.l  #$5555AAAA,$51A.w ;memval3
		;clr.l   $5A4            ;ramtop
		;move.l  #$1357BD13,$5A8.w ;ramvalid

	* Fast-Ram
		move.l	#$12345678,d0
		lea	$2000000,a0	;fin de la fast
		move.l	d0,-4(a0)
		cmp.l	-4(a0),d0
		bne.s	.no_fast		;???
		
		move.l	d0,(a0)
		cmp.l	(a0),d0
		bne.s	.ok_fast
		add.l	#$1000000,a0	;fin plus loin
		bra.s	.ok_fast
.no_fast
		sub.l	a0,a0
.ok_fast
		move.l 	#$1357BD13,$5A8.w ;ramvalid
		move.l	a0,$5a4.w
		beq.s	.quit_fast
		
		move.l	a0,d0
	
		sub.l	#$1100000,d0	;FastRam commence
		lsr.l	#5,d0		;en $1100000
.clr_fast
		rept	8
		clr.l	-(a0)
		endr
		subq.l	#1,d0
		bne.s	.clr_fast
.quit_fast
	* Si reset  chaud...
T_1DA:         
		movea.l #$8870,SP	;pile super
		
		lea     $E00D14,A3	;"RTE"
		lea     $E00BC6,A4	;"RTS"
		lea     $E03932,A1	;reset violent
		
		lea     $8.w,A0         ;bus_error
		move.w  #$3F,D0
T_1F6:         
		move.l  A1,(A0)+	;tout les vecteurs
		dbra    D0,T_1F6
		
		move.l  A3,$14.w        ;divbyzero
		
	* initialise les autovecteurs
		move.l  A3,$7C.w        ;autov_int7
		moveq   #6,D0
		lea     $64.w,A1        ;autov_int1
T_20A:         
		move.l  #$E00D14,(A1)+	;=>"RTE"
		dbra    D0,T_20A
	* VBL
		move.l  #$E00C72,$70.w  ;autov_int4
	* HBL
		move.l  #$E00C5C,$68.w  ;autov_int2
	* AES/VDI
		move.l  A3,$88.w        ;trp2vec
	* BIOS
		move.l  #$E00D3E,$B4.w  ;trp13vec
	* XBIOS
		move.l  #$E00D38,$B8.w  ;trp14vec
	* LINEA
		move.l  #$E0948A,$28.w  ;linea_vec
	* ETV_TIMER
		move.l  A4,$400.w       ;etv_timer
	* ETV_CRITIC
		move.l  #$E00D34,$404.w ;etv_critic
	* ETV_TERM
		move.l  A4,$408.w       ;etv_term
		
	* VBL queue
		lea     $4CE.w,A0       ;_vbl_list
		move.l  A0,$456.w       ;_vblqueue
		move.w  #7,D0
T_25C:         
		clr.l   (A0)+
		dbra    D0,T_25C
		lea     $E00E18,A0
		
		movea.w #$51E,A1
		moveq   #$1F,D0
T_26E:         
		move.l  (A0)+,(A1)+
		dbra    D0,T_26E
		
	* test du bus error ?!
		movea.l $8.w,A0         ;bus_error
		movea.l SP,A1
		move.l  #.retour,$8.w   ;bus_error
.retour
		move.l  A0,$8.w         ;bus_error
		movea.l A1,SP
		
	* init vido
		move.b  $FFFF8006.w,D0
		move.b  D0,D1
		lsl.b   #6,D1
		and.b   #$80,D1
		lsr.b   #6,D0
		or.b    D0,D1
		move.w  D1,$FFFF82C0.w
		st      $A86
		sf      $A87
		
		movea.l #$F99C,A1	;carrment
		movea.l #$A88,A0	;la fin de l'os
		moveq   #0,D0	;dans le code
T_2B6:         
		move.w  D0,(A0)+
		cmpa.l  A0,A1
		bne.s   T_2B6

	* arbre PMMU
		jsr     $E01492
		
	* installe un cran de 32ko
		movea.l $42E.w,A0       ;phystop
		suba.l  #$8000,A0
		move.w  #$7FF,D1
		
		move.l  A0,$44E.w       ;_v_bas_ad
		
		move.b  $44F.w,$FFFF8201.w ;dbaseh
		move.b  $450.w,$FFFF8203.w ;dbasel
		moveq   #0,D0
T_2E0:         
		move.l  D0,(A0)+
		move.l  D0,(A0)+
		move.l  D0,(A0)+
		move.l  D0,(A0)+
		dbra    D1,T_2E0	;efface l'cran
		
		movea.l $E00014,A0
		cmpi.l  #$87654321,(A0)
		beq.s   T_2FE
		lea     $E00008,A0
T_2FE:         
		move.l  4(A0),$4FA.w    ;end_os
		move.l  8(A0),$4FE.w    ;exec_os
		
		move.l  #$E04738,$46A.w ;hdv_init
		move.l  #$E04C02,$476.w ;hdv_rw
		move.l  #$E047B2,$472.w ;hdv_bpb
		move.l  #$E04A12,$47E.w ;hdv_mediach
		move.l  #$E04EFA,$47A.w ;hdv_boot
		move.l  #$E02438,$506.w ;prv_lsto
		move.l  #$E02392,$50A.w ;prv_lst
		move.l  #$E024AA,$50E.w ;prv_auxo
		move.l  #$E024C2,$512.w ;prv_aux
		move.l  #$E011EA,$502.w ;scr_dump
		
		move.l  $44E.w,$436.w   ;_memtop
		
		* insre le _FRB entre la fin du systme
		* et le dbut de la zone utilisateur
		
		move.l  $4FA.w,d0
		add.l	#64*1024,d0	;buffer _FRB
		move.l	d0,$432.w   ;_membot
		
		move.w  #8,$454.w       ;nvbls
		st      $444.w          ;_fverify
		move.w  #3,$440.w       ;seekrate
		move.l  #$1CC6,$4C6.w   ;_dskbufp
		move.w  #-$1,$4EE.w     ;_prt_cnt
		
		move.l  #$E00000,$4F2.w ;_sysbase
		
		move.l  #$93A,$4A2.w    ;savptr
		move.l  #$E00BC6,$46E.w ;swv_vec
		
		clr.l   $4C2.w          ;_drvbits
		
		move.l  #$E03CF0,$5AC.w ;bell_hook
		move.l  #$E038B0,$5B0.w ;kcl_hook
		
		jsr     $E01354	;init vars systme
				;recopie de end_os
		
	* installe les cookies
		lea     $980,A0
		move.l  A0,$5A0.w       ;_p_cookies

		move.l	#"CT2a",(a0)+
		move.l	#$13021998,(a0)+
		
	* _CPU
		move.l  #$5F435055,(A0)+
		moveq   #0,D1
		movea.w #$10,A2	;illegal
		movea.l (A2),A3	;ancien vecteur
		movea.l SP,A1
		move.l  #$T_3F8,(A2)
		move	ccr,d0	; >=68010?
		;dc.w    $42C0           ;B
		
		moveq   #10,D1
		extb.l	d0	; >=68020?
		;dc.w    $49C0           ;I
		
		moveq   #$14,D1
		movec.l CACR,D0
		bset    #9,D0	; >=68030?
		movec.l D0,CACR
		movec.l CACR,D0
		bclr    #9,D0
		beq.s   T_3F8
		
		moveq   #$1E,D1	;=>68030
		movec.l D0,CACR
T_3F8:         			;<= retour illegal
		movea.l A1,SP
		move.l  A3,(A2)
		move.l  D1,(A0)+
		sne     $59F.w	;stack_frame
		
	* _VDO
		move.l  #$5F56444F,(A0)+
		move.l  #$30000,(A0)+

	* _MCH
		move.l  #$5F4D4348,(A0)+
		move.l  #$30000,(A0)+
	* _SWI
		move.b  #$7F,D0
		tst.b   $A87
		bne.s   T_436

		move.l  #$5F535749,(A0)+
		moveq   #0,D0
		move.w  $FFFF9200.w,D0
		lsr.w   #8,D0
		move.l  D0,(A0)+
	* _SND
T_436:         
		moveq   #$1F,D1
		move.l  #$5F534E44,(A0)+
		btst    #7,D0
		bne.s   T_448
		bclr    #1,D1
	* _FDC
T_448:         
		move.l  D1,(A0)+
		
		btst    #6,D0
		bne.s   T_464
		move.b  #8,$16D4
		move.l  #$5F464443,(A0)+
		move.l  #$1415443,(A0)+
	* _FPU
T_464:         
		move.l  #$5F465055,(A0)+
		moveq   #0,D7
		movem.l $2C.w,A3        ;linef_vec
		movea.l $34.w,A4	;protocole
		
		move.l  #.E004AE(pc),$2C.w  ;linef_vec
		move.l  #.E004AE(pc),$34.w	;linef
		
		movea.w #$C0,A2
		movem.l (A2),D0-D6
		movea.l #.E004A8,A5
		
		move.l  A5,(A2)+
		move.l  A5,(A2)+
		move.l  A5,(A2)+
		move.l  A5,(A2)+
		move.l  A5,(A2)+
		move.l  A5,(A2)+
		move.l  A5,(A2)+
		clr.l   -(SP)
		movea.l SP,A2
		frestore (SP)

	* retour vecteur copro
.e004a8
		move.l  #$20000,D7
.e004ae
		movea.l A2,SP
		addq.w  #4,SP
		move.l  A3,$2C.w        ;linef_vec
		move.l  A4,$34.w
		movem.l D0-D6,$C0.w
		move.l  D7,(A0)+
		
	* _FRB
		move.l	#"_FRB",(a0)+
		move.l	$4fa.w,(a0)+

	* NVRAM
		link    A6,#-$14
		movea.l SP,A5
		move.l  A0,(A5)
		pea     4(A5)
		move.w  #$10,-(SP)
		clr.l   -(SP)
		
		jsr     $E0212E
		
		movea.l (A5)+,A0
		tst.w   D0
		beq.s   T_4E6
		lea     $E49B22,A5
		moveq   #0,D0
T_4E6:         
		move.w  (A5),$A80.w
		addq.w  #6,A5	

	* _AKP		
		move.l  #$5F414B50,(A0)+
		move.w  D0,(A0)+
		move.w  (A5)+,(A0)+

	* _IDT
		move.l  #$5F494454,(A0)+
		move.w  D0,(A0)+
		move.w  (A5)+,(A0)+
		
		move.l  (A5)+,$A82.w
		moveq   #$50,D0
		cmp.b   $A82.w,D0
		bcc.s   T_510
		move.b  D0,$A82.w

	* mode vido
T_510:      
		bfextu	($ffff8006.w,za0){0:2},d1
		
		move.w  (A5),D0
		bne.s	.ya_mode
		;move.w  #$82,D0
			 ;FSOPV8NNN
		move.w	#%000101010,d0 ;par dfaut / PAL
		btst	#0,d1
		bne	T_E00518
		or	#%000010000,d0	;VGA
		bra	T_E00518
.ya_mode
		tst	d1
		bne.s	.pas_sm124
			 ;FSOPV8NNN
		and	#%010111000,d0
		bra	T_E00518
.pas_sm124
		btst	#0,d1
		bne.s	.tv
.vga
		and	#%110111111,d0
		or	#%000010000,d0	;VGA
		move	d0,d1
		and	#%111,d1
		bne.s	.vga_col
		or	#%000001000,d0
		bra.s	.vga_st
.vga_col
		cmp	#%100,d1
		bne.s	.vga_st
		and	#%110010111,d0
.vga_st
		btst	#7,d0
		beq.s	T_E00518
		tst	d1
		beq.s	.vga_haute
		cmp	#1,d1
		beq.s	.vga_moy
.vga_basse
		move	#%110010010,d0
		bra.s	T_E00518
.vga_moy
		move	#%110011001,d0
		bra.s	T_E00518
.vga_haute
		move	#%010011000,d0
		bra.s	T_E00518
.tv
		move	d0,d2
		and	#%000100000,d2	;PAL
		and	#%110101111,d0
		move	d0,d1
		and	#%111,d1
		bne.s	.tv_col
		or	#%000001000,d0
.tv_col
		btst	#7,d0
		beq.s	T_E00518
		tst	d1
		beq.s	.tv_haute
		cmp	#1,d1
		beq.s	.tv_moy
.tv_basse
		move	#%110010010,d0
		or	d2,d0
		bra.s	T_E00518
.tv_moy
		move	#%110011001,d0
		or	d2,d0
		bra.s	T_E00518
.tv_haute
		move	#%010011000,d0
		or	d2,d0
		bra.s	T_E00518
T_E00518:      
		move.w  D0,$184C.w	;mode vido de dpart...
		unlk    A6

	* fin cookies
		clr.l   (A0)+
		move.l  #$20,(A0)+
	
	* Clavier, timer C et timer D
		jsr     $E02582

	* init timer a =>50 pr-div compteur nul : 49152 Hz
		move.w  #$400,D0
		
		jsr     $E013E4	;init timera
		
		move.l  #$E0084E,-(SP)
		move.w  #1,-(SP)
		jsr     $E02522	;=> clavier
		addq.l  #6,SP
		
	* init timer a =>200 pr-div compteur nul : 12288 Hz
		move.w  #$700,D0
		move.w  #14,D1
T_54C:         
		jsr     $E013E4	;15 fois!!!
		
		dbra    D1,T_54C
		
	* test cartouche
		moveq   #2,D0
		jsr     $E00B94	;=>cartouche
		
		moveq   #3,D1
		move.w  $184C.w,D2
		bne.s   T_566
		move.w  #$82,D2
T_566:         
		move.w  D2,$184C.w
		
	* vecteur pour les changements de rsolution
		move.l  #$E00030,$46E.w ;swv_vec
		
	* met en route la vbl systme
		move.w  #1,$452.w       ;vblsem
		
	* test cartouche
		clr.w   D0
		jsr     $E00B94	;=>cartouche
		
	* Lache les interruptions: vrrrooooummmmmmm!!!!!!
		
		move    #$2300,sr
		
		moveq   #1,D0
		jsr     $E00B94
		
		move.l  #$E00868,$20.w  ;priv_err
		move.l  $42E.w,$436.w   ;_memtop
		
	* init GEMDOS, VDI, ...
		jsr     $E1DE24

	* dclare Fast-Ram
		lea	$1100000,a0	;dbut de la Fastram
		move.l	$5a4.w,d0
		sub.l	a0,d0
		move.l	d0,-(sp)
		pea	(a0)
		move	#$14,-(sp)	;Maddalt
		trap	#1
		lea	10(sp),sp
		
	* change de rsolution
		move.w  $184C.w,-(SP)
		move.w  #3,-(SP)
		clr.l   -(SP)
		clr.l   -(SP)
		jsr     $E08B20
		lea     12(SP),SP

	* on retourne au tos 4.04
		jmp	$e005b2

	* dsp
		jsr     $E05624

	* sdma !!!!!!!!!!!!!!!!!!!!!!!!!
		moveq   #8,D0
		move.l  D0,-(SP)
		clr.l   -(SP)
		move.w  #1,-(SP)
		jsr     $E064AA
		addq.w  #6,SP
		
		clr.w   (SP)
		jsr     $E0639E
		
		move.l  #$20080,(SP)
		jsr     $E061B2
		
		move.w  #3,(SP)
		jsr     $E061B2
		
		move.l  #$60003,(SP)
		jsr     $E061B2
		
		move.w  #4,(SP)
		jsr     $E061B2
		
		move.w  #5,(SP)
		jsr     $E061B2
		addq.w  #4,SP
		
	* nvram: lit l'heure
		move.w  $E0001E,$6CFE
		jsr     $E01F66
		beq.s   T_624
		
		jsr     $E02246
		swap    D0
		tst.b   D0
		beq.s   T_624
		move.w  D0,$6CFE
		swap    D0
		move.w  D0,$6CFC
T_624:         
	* coupe le timer A
		clr.b   $FFFFFA19.w     ;tacr
		bclr    #5,$FFFFFA07.w  ;iera
	* init le cache
		move.l  #$3111,D0
		movec.l D0,CACR
		
	* params...
		lea     $ACE.w,A0
		move.l  #$10001,(A0)+
		clr.w   (A0)
		lea     $E497EA,A0
		lea     $AD4.w,A1
		move.l  (A0)+,(A1)+
		move.l  (A0)+,(A1)+
		move.l  (A0)+,(A1)+
		move.l  (A0),(A1)
		
		pea     $E497DC
		jsr     $E01044	;init linea derrire
		addq.w  #4,SP
		
		moveq   #$27,D7
		tst.b   $44C.w          ;sshiftmd
		bne.s   T_66C
		moveq   #$2C,D7
T_66C:         
		move.l  #$30002,D6
		move.w  #$1B,-(SP)	;ESC
		move.l  D6,-(SP)
		trap    #13             ;bios 3
		move.w  #$59,4(SP)	;"Y"
		move.l  D6,(SP)
		trap    #13             ;bios 3
		move.w  D7,4(SP)	;Y: 32+7(ST)/12(autre)
		move.l  D6,(SP)
		trap    #13	;bios 3
		move.w  #$20,4(SP)	;x: 32+0
		move.l  D6,(SP)
		trap    #13             ;bios 3
		addq.w  #6,SP
		
		;cmpi.l  #$3E80,$4BA     ;_hz_200
		;bcc     T_73C	;pause avant le lancement...
		
		;move.l  #$7FFFE,D7
		;move.w  #0,D6
		;movea.l #$E00000,A5
;T_6B6:         move.w  #1,-(SP)
		;move.l  D7,-(SP)
		;move.l  A5,-(SP)
		;bsr     A_14CA
		;adda.w  #10,SP
		;movea.l A5,A0
		;adda.l  D7,A0
		;move.b  (A0),D1
		;lsl.w   #8,D1
		;move.b  1(A0),D1
		;cmp.w   D1,D0
		;bne.s   T_700
		;addq.l  #1,A5
		;dbra    D6,T_6B6
		;bra.s   T_73C
		;dc.w    $5741           ;WA
		;dc.w    $524E           ;RN
		;dc.w    $494E           ;IN
		;dc.w    $473A           ;G:
		;dc.w    $2042           ; B
		;dc.w    $4144           ;AD
		;dc.w    $2052           ; R
		;dc.w    $4F4D           ;OM
		;dc.w    $2043           ; C
		;dc.w    $5243           ;RC
		;dc.w    $2049           ; I
		;dc.w    $4E20           ;N 
		;dc.w    $4348           ;CH
		;dc.w    $4950           ;IP
		;dc.w    $2000           ;  
		;dc.w    $2E0D           ;. 
		;dc.w    $0A00           ;  
;T_700:         move.l  A5,D5
		;pea     $E006DE
		;move.w  #9,-(SP)
		;trap    #1              ;Cconws
		;move.b  #$45,D0
		;btst    #0,D5
		;beq.s   T_71C
		;move.b  #$4F,D0
;T_71C:         move.w  D0,2(SP)
		;move.w  #2,(SP)
		;trap    #1              ;Cconout
		;move.l  #$E006FC,2(SP)
		;move.w  #9,(SP)
		;trap    #1              ;Cconws
		;addq.w  #6,SP
		;addq.l  #1,A5
		;dbra    D6,T_6B6
T_73C:         
		move.l  #$BFFFF,-(SP)
		trap    #13             ;Kbshift
		addq.w  #4,SP
		btst    #3,D0	;ALT
		beq.s   T_756
		
		move.l  #$808,D0
		movec.l D0,CACR
T_756:         
		jsr     $E01C4E	;disk?!
		
		clr.l   D1
		lea     $e00F78,A0
		adda.l  D1,A0
		adda.l  D1,A0
		
		lea     $8.w,A1         ;bus_error
		move.w  #$3F,D0
		move.l  #$E03932,D2
T_774:         
		cmp.l   (A1)+,D2
		bne.s   T_77C
		move.l  A0,-$4(A1)
T_77C:         
		adda.l  D1,A0	;+2
		dbra    D0,T_774	;+4
		
	* boot cartouche+boot disquette+init disquette
		bsr     T_964	;+4=>786

	* teste ram...+pause et attente de touche 
	* (ALT+CTRL+UNDO=>reset nvm)
	* puis lance le test des boots des disques durs
		bsr     T_97C

	* ???????
		bsr     A_12E2

	* dbut de l'os
		tst.w   $482            ;_cmdload
		beq.s   T_7B4
		bsr     A_10C4
		move.l  #$E00000,$4F2   ;_sysbase
		pea     T_84B(PC)
		pea     T_84B(PC)
		pea     T_838(PC)
		clr.w   -(SP)
		bra.s   T_81C
T_7B4:         
		bsr     A_10C4
		move.l  #$E00000,$4F2   ;_sysbase
		lea     T_82C(PC),A0
		movea.l #$840,A1
T_7CC:         
		cmpi.b  #$23,(A0)
		bne.s   T_7D4
		movea.l A1,A2
T_7D4:         
		move.b  (A0)+,(A1)+
		bpl.s   T_7CC
		move.b  $446,D0         ;_bootdev
		add.b   #$41,D0
		move.b  D0,(A2)
		pea     $840
		pea     $E0084B
		pea     T_84B(PC)
		move.w  #5,-(SP)
		move.w  #$4B,-(SP)
		trap    #1              ;Pexec
		adda.w  #14,SP
		movea.l D0,A0
		move.l  $4FE,8(A0)      ;exec_os
		pea     $840
		move.l  A0,-(SP)
		pea     T_84B(PC)
		move.w  #4,-(SP)
T_81C:         
		move.w  #$4B,-(SP)
		trap    #1              ;Pexec
		adda.w  #14,SP
		jmp     $E00030
T_82C:         
		dc.w    $5041           ;PA
		dc.w    $5448           ;TH
		dc.w    $3D00           ;= 
		dc.w    $233A,$5C00     ;#:\ 
		dc.w    $00FF           ; 
T_838:         dc.w    $434F           ;CO
		dc.w    $4D4D           ;MM
		dc.w    $414E           ;AN
		dc.w    $442E,$5052     ;D.PR
		dc.w    $4700           ;G 
		dc.w    $4745           ;GE
		dc.w    $4D2E           ;M.
		dc.w    $5052           ;PR
		dc.w    $4700           ;G 
		dc.w    $0000           ;  
		dc.w    $8001           ; 
T_850:         move    sr,-(SP)
		ori     #$700,sr
		movec.l CACR,D0
		or.l    #$808,D0
		movec.l D0,CACR
		move    (SP)+,sr
		rts     
		movem.l D0-D2,-(SP)
		move.l  A1,-(SP)
		move.l  A0,-(SP)
		movea.l $16(SP),A0
		move.w  (A0),D0
		move.w  D0,D1
		and.w   #-$40,D0
		cmp.w   #$40C0,D0
		bne     T_956
		move.l  #$30004E71,$A88.w
		move.l  #$4E714E75,$A8C.w
		move.w  D1,D0
		and.w   #7,D0
		lsl.w   #8,D0
		lsl.w   #1,D0
		or.w    D0,$A88.w
		move.w  D1,D0
		and.w   #$38,D0
		lsl.w   #3,D0
		or.w    D0,$A88.w
		moveq   #2,D2
		cmp.w   #$180,D0
		beq     T_956
		tst.w   D0
		beq.s   T_916
		cmp.w   #$140,D0
		beq.s   T_8E0
		cmp.w   #$1C0,D0
		bne.s   T_8E8
		and.w   #7,D1
		beq.s   T_8D6
		addq.w  #2,D2
		move.w  4(A0),$A8C.w
T_8D6:         addq.w  #2,D2
		move.w  2(A0),$A8A.w
		bra.s   T_93C
T_8E0:         addq.w  #2,D2
		move.w  2(A0),$A8A.w
T_8E8:         and.w   #7,D1
		cmp.w   #7,D1
		bne.s   T_93C
		move    usp,A1
		andi.w  #-$C01,$A88.w
		add.l   D2,$16(SP)
		bsr     T_850
		move.w  $14(SP),D0
		jsr     $A88.w
		move    A1,usp
		movea.l (SP)+,A0
		movea.l (SP)+,A1
		movem.l (SP)+,D0-D2
		rte     
T_916:         add.l   D2,$16(SP)
		ori.w   #$10,$A88.w
		bsr     T_850
		lea     $14(SP),A0
		movem.l 8(SP),D0-D2
		jsr     $A88.w
		movea.l (SP)+,A0
		movea.l (SP)+,A1
		adda.w  #12,SP
		rte     
T_93C:         add.l   D2,$16(SP)
		bsr     T_850
		movea.l (SP)+,A0
		movea.l (SP)+,A1
		move.w  12(SP),D0
		jsr     $A88.w
		movem.l (SP)+,D0-D2
		rte     
T_956:         movea.l (SP)+,A0
		movea.l (SP)+,A1
		movem.l (SP)+,D0-D2
		jmp     $E00F78

	**********************************
	* saute dans la cartouche
	* initialise la prsence du lecteur de disquette
	* excute le boot d'une disquette
T_964:         
		moveq   #3,D0
		bsr     T_B94	;Cartouche disque
		
		movea.l $47A.w,A0       ;hdv_boot (1seul fois)
		jsr     (A0)	;repre le(s) lecteur(s) de disquettes
				;d0=0: boot disquette charg et
				;excutable
				:d0=1: pas de disquette
				:d0=4: disquette mais pas bootable
		tst.w   D0
		bne.s   T_97A
		
		movea.l $4C6.w,A0       ;_dskbufp
		jsr     (A0)	;=>saute dans le boot de la disquette
T_97A:         
		rts     

	***********************************
T_97C:         
		move.l  #$C8,D5
		moveq   #0,D4
		move.b  $A82.w,D4
		move.l  D4,D7
		muls    D5,D7
		cmp.l   $4BA,D7         ;_hz_200
		bcs     T_AE4
		movea.w #0,A5
T_99A:         cmpa.w  #0,A5
		bne     T_A46
		bsr     A_78DC
		movea.w D0,A5
		beq     T_A7A
		move.w  #$1B,-(SP)
		move.l  #$30002,-(SP)
		trap    #13             ;Bconout
		move.w  #$70,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		move.w  #$1B,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		move.w  #$77,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		btst    #3,$184D.w
		bne.s   T_9EE
		lsl.l   #1,D5
		lsr.l   #1,D4
T_9EE:         subq.w  #1,D4
		move.l  D5,D6
		move.l  D4,D3
T_9F4:         move.w  #$20,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		dbra    D4,T_9F4
		move.w  #13,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		subq.l  #1,D3
T_A16:         move.w  #$20,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		dbra    D3,T_A16
		move.w  #$1B,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		move.w  #$71,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		addq.l  #6,SP
T_A46:         cmp.l   $4BA,D6         ;_hz_200
		bhi.s   T_A7A
		move.w  #$1B,-(SP)
		move.l  #$30002,-(SP)
		trap    #13             ;Bconout
		move.w  #$4B,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		move.w  #8,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		addq.w  #6,SP
		add.l   D5,D6
T_A7A:         cmpa.w  #0,A5
		beq.s   T_A88
		cmp.l   $4BA,D7         ;_hz_200
		bls.s   T_AB4
T_A88:         move.l  #$10002,-(SP)
		trap    #13             ;Bconstat
		addq.l  #4,SP
		tst.l   D0
		beq     T_99A
		move.l  #$20002,-(SP)
		trap    #13             ;Bconin
		addq.l  #4,SP
		cmpa.w  #0,A5
		bne.s   T_AB4
		bsr     A_7B2A
		move.l  D7,$4BA         ;_hz_200
		bra.s   T_AE4
T_AB4:         move.l  D7,$4BA         ;_hz_200
		move.w  #13,-(SP)
		move.l  #$30002,-(SP)
		trap    #13             ;Bconout
		move.w  #$1B,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		move.w  #$4B,4(SP)
		move.l  #$30002,(SP)
		trap    #13             ;Bconout
		addq.l  #6,SP
T_AE4:         clr.w   $840
		pea     $A80.w
		move.w  #2,-(SP)
		clr.l   -(SP)
		jsr     A_212E(PC)
		adda.w  #10,SP
		tst.w   D0
		beq.s   T_B04
		clr.w   $A80.w
T_B04:         move.w  #1,D1
T_B08:         move.w  D1,-(SP)
		move.w  $840,D4
		move.b  T_B66(PC,D4.w),D4
		move.w  D4,-(SP)
		move.l  $4C6.w,-(SP)    ;_dskbufp
		move.w  #1,-(SP)
		clr.l   -(SP)
		
		jsr     $E01790
		
		adda.w  #12,SP
		move.w  (SP)+,D1
		tst.l   D0
		beq.s   T_B38
		addq.l  #1,D0
		dbeq    D1,T_B08
		bra.s   T_B4E
T_B38:         movea.l $4C6.w,A0       ;_dskbufp
		move.w  #$FF,D0
		moveq   #0,D1
T_B42:         add.w   (A0)+,D1
		dbra    D0,T_B42
		cmp.w   #$1234,D1
		beq.s   T_B70
T_B4E:         move.w  $840,D4
		addq.w  #1,D4
		move.w  D4,$840
		dc.w    $0C3B           ; ;
		dc.w    $00FF           ; 
		dc.w    $4008           ;@ 
		bne.s   T_B04
		rts     
T_B66:         dc.w    $1008           ;  
		dc.w    $090A,$0B0C     ;    
		dc.w    $0D0E,$0FFF     ;   
T_B70:         movea.l $4C6.w,A0       ;_dskbufp
		move.l  #$444D4172,D3
		move.w  D4,D7
		asl.w   #5,D7
		move.w  $A80.w,D5
		move.l  $476,-(SP)      ;hdv_rw
		jsr     (A0)
		move.l  (SP)+,D0
		cmp.l   $476.w,D0       ;hdv_rw
		beq.s   T_B4E
		rts     
	
	***********************************
	* CARTOUCHE: Version disque
T_B94:         
		lea     $FA0000,A0
		cmpi.l  #-$543210BE,(A0)+
		bne.s   T_BC4
T_BA2:         
		btst    D0,4(A0)
		beq.s   T_BBE
		movem.l D0-A6,-(SP)
		move.l  4(A0),D0
		and.l   #$FFFFFF,D0
		movea.l D0,A0
		jsr     (A0)
		movem.l (SP)+,D0-A6
T_BBE:         
		tst.l   (A0)
		movea.l (A0),A0
		bne.s   T_BA2
T_BC4:         
		rts     
	
	***********************************
T_BC6:    
		rts     
		adda.l  D1,A0
		clr.w   D0
		lea     $1F8(A0),A1
T_BD0:         cmp.w   (A0)+,D0
		bne.s   T_BDC
		add.w   #-$5AC,D0
		cmpa.l  A0,A1
		bne.s   T_BD0
T_BDC:         jmp     (A4)

	************************************
	* premier test reset froid
	* A6 pointe en T_E000A4
T_BDE:         
		cmpi.l  #$752019F3,$420.w ;memvalid
		bne.s   T_BFA
		cmpi.l  #$237698AA,$43A.w ;memval2
		bne.s   T_BFA
		cmpi.l  #$5555AAAA,$51A.w ;memval3
T_BFA:         
		jmp     (A6)

	************************************
T_BFC:         
		dc.w    $0FFF           ; 
		btst    D7,D0
		dc.w    $00F0           ; 
		bset    D7,15(A0,D0.w)
		movep.w $FF(SP),D7
		bchg    D2,(A5)
		btst    D1,([$3F30FF3,A3,D0.l*8],$33F0F3F)
		dc.w    $03FF           ; 
		dc.w    $0000           ;  
		dc.w    $FFFF           ;
		dc.w    $00FF           ; 
		dc.w    $FF00           ; 
		ori.b   #$FF,D0
		dc.w    $0000           ;  
		dc.w    $FFFF           ;
		ori.b   #0,D0
		dc.w    $00FF           ; 
		dc.w    $FF00           ; 
		dc.w    $00FF           ; 
		dc.w    $00FF           ; 
		dc.w    $00FF           ; 
		dc.w    $AAAA           ;
		ori.l   #$55550055,-$AB(A2)
		ori.w   #$55FF,(A5)
		ori.w   #-$1,(A5)
		ori.w   #$5555,(A5)
		dc.w    $00FF           ; 
		frestore (A5)
		dc.w    $00FF           ; 
		dc.w    $55FF           ;U
		dc.w    $00FF           ; 
		ori.b   #0,D0
		move.w  D0,-(SP)
		move.w  2(SP),D0
		and.w   #$700,D0
		bne.s   T_C6E
		ori.w   #$300,2(SP)
T_C6E:         move.w  (SP)+,D0
		rte     
		addq.l  #1,$466         ;_frclock
		subq.w  #1,$452         ;vblsem
		bmi     T_D0E
		movem.l D0-A6,-(SP)
		addq.l  #1,$462         ;_vbclock
		move.l  $45A.w,D0       ;colorptr
		beq.s   T_CB4
		bclr    #0,D0
		beq.s   T_CA2
		move.w  $18C4.w,D1
		lea     $FFFF9800.w,A1
		bra.s   T_CA8
T_CA2:         moveq   #7,D1
		lea     $FFFF8240.w,A1  ;color0
T_CA8:         movea.l D0,A0
T_CAA:         move.l  (A0)+,(A1)+
		dbra    D1,T_CAA
		clr.l   $45A.w          ;colorptr
T_CB4:         move.w  $454,D7         ;nvbls
		beq.s   T_D00
		subq.l  #1,D7
		movea.l $456.w,A0       ;_vblqueue
T_CC2:         movea.l (A0)+,A1
		cmpa.w  #0,A1
		beq.s   T_CD4
		movem.l D7/A0,-(SP)
		jsr     (A1)
		movem.l (SP)+,D7/A0
T_CD4:         dbra    D7,T_CC2
		jsr     $E09092
		tst.l   $45E.w          ;screenpt
		beq.s   T_CFC
		move.l  $45E.w,$44E.w   ;_v_bas_ad
		move.b  $450.w,$FFFF8203.w ;dbasel
		move.b  $44F.w,$FFFF8201.w ;dbaseh
		move.b  $451.w,$FFFF820D.w ;vbaselo
T_CFC:         bsr     A_4240
T_D00:         tst.w   $4EE.w          ;_prt_cnt
		bne.s   T_D0A
		bsr     A_11D8
T_D0A:         movem.l (SP)+,D0-A6
T_D0E:         addq.w  #1,$452         ;vblsem
T_D14:         rte     
		move    sr,-(SP)
		andi    #-$401,sr
		move.l  $466,D0         ;_frclock
T_D22:         cmp.l   $466,D0         ;_frclock
		beq.s   T_D22
		move    (SP)+,sr
		rts     
		move.l  $404,-(SP)      ;etv_critic
		moveq   #$FF,D0
		rts     
		lea     A_152E(PC),A0
		bra.s   T_D42
		lea     A_14FC(PC),A0
T_D42:         movea.l $4A2,A1         ;savptr
		move.w  (SP)+,D0
		move.w  D0,-(A1)
		move.l  (SP)+,-(A1)
		tst.w   $59E.w          ;_longframe
		beq.s   T_D56
		tst.w   (SP)+
T_D56:         movem.l D3-D7/A3-A7,-(A1)
		move.l  A1,$4A2         ;savptr
		btst    #13,D0
		bne.s   T_D68
		move    usp,SP
T_D68:         move.w  (SP)+,D0
		cmp.w   (A0)+,D0
		bge.s   T_D84
		move.w  D0,D1
		lsl.w   #2,D1
		move.l  0(A0,D1.w),D1
		bclr    #0,D1
		movea.l D1,A0
		beq.s   T_D80
		movea.l (A0),A0
T_D80:         suba.l  A5,A5
		jsr     (A0)
T_D84:         movea.l $4A2,A1         ;savptr
		movem.l (A1)+,D3-D7/A3-A7
		tst.w   $59E.w          ;_longframe
		beq.s   T_D96
		clr.w   -(SP)
T_D96:         move.l  (A1)+,-(SP)
		move.w  (A1)+,-(SP)
		move.l  A1,$4A2         ;savptr
		rte     
		btst    #0,1(SP)
		bne.s   T_DB0
		move.l  #$E00DB6,(SP)
T_DB0:         movea.l $476.w,A0       ;hdv_rw
		jmp     (A0)
		move.l  D0,-(SP)
		bsr     T_850
		move.l  (SP)+,D0
		jmp     $E00D84
		movea.l 4(SP),A0
		jmp     (A0)
		lea     $51E.w,A0       ;xconstat
		moveq   #0,D1
		bra.s   T_DE8
		lea     $53E.w,A0       ;xconin
		moveq   #4,D1
		bra.s   T_DE8
		lea     $55E.w,A0       ;xcostat
		moveq   #8,D1
		bra.s   T_DE8
		lea     $57E.w,A0       ;xconout
		moveq   #12,D1
T_DE8:         move.w  4(SP),D0
		cmp.w   #5,D0
		bls.s   T_E10
		subq.l  #6,D0
		cmp.w   $11CA.w,D0
		bcc.s   T_E0C
		movea.l $11C6.w,A0
		asl.w   #3,D0
		adda.w  D0,A0
		add.w   D0,D0
		adda.w  D0,A0
		movea.l 0(A0,D1.w),A0
		jmp     (A0)
T_E0C:         moveq   #0,D0
		rts     
T_E10:         lsl.w   #2,D0
		movea.l 0(A0,D0.w),A0
		jmp     (A0)
		dc.w    $00E0           ; 
		bset    D5,D6
		dc.w    $00E0           ; 
		movea.l A0,A2
		dc.w    $00E0           ; 
		move.l  $E0(A4,D0.w),-(A2)
		move.l  D2,$E0(A1)
		bset    D5,D6
		dc.w    $00E0           ; 
		bset    D5,D6
		dc.w    $00E0           ; 
		bset    D5,D6
		dc.w    $00E0           ; 
		bset    D5,D6
		dc.w    $00E0           ; 
		move.l  (A6),D2
		dc.w    $00E0           ; 
		movea.l (A6)+,A2
		dc.w    $00E0           ; 
		move.l  A2,$E0(A2)
		move.l  (A4)+,$E0(A1)
		bset    D5,D6
		dc.w    $00E0           ; 
		bset    D5,D6
		dc.w    $00E0           ; 
		bset    D5,D6
		dc.w    $00E0           ; 
		bset    D5,D6
		dc.w    $00E0           ; 
		move.l  $E0.w,D2
		move.l  $E0(A2),(A2)
		dc.w    $257E           ;%~
		dc.w    $00E0           ; 
		move.l  $E0(A2),(A2)+
		move.l  A0,-(A1)
		dc.w    $00E0           ; 
		bset    D5,D6
		dc.w    $00E0           ; 
		bset    D5,D6
		dc.w    $00E0           ; 
		bset    D5,D6
		dc.w    $00E0           ; 
		move.l  (A2),$E0(A1,D0.w)
		move.l  D2,(A2)+
		dc.w    $00E0           ; 
		divu    $E0(A4),D6
		move.l  (A0)+,-(A1)
		dc.w    $00E0           ; 
		move.l  T_F6C(PC),(A2)+
		divu    -(A0),D6
		dc.w    $00E0           ; 
		bset    D5,D6
		dc.w    $00E0           ; 
		bset    D5,D6
		move.l  $4C2.w,D0       ;_drvbits
		rts     
		moveq   #0,D0
		move.b  $1187.w,D0
		move.w  4(SP),D1
		bmi.s   T_EAE
		move.b  D1,$1187.w
T_EAE:         rts     
		movea.l 4(SP),A0
		lea     $48E.w,A1       ;themd
		move.l  A1,(A0)
		clr.l   4(A0)
		clr.l   8(A0)
		clr.l   (A1)
		move.l  $432.w,4(A1)    ;_membot
		move.l  $436.w,D0       ;_memtop
		sub.l   $432.w,D0       ;_membot
		move.l  D0,8(A1)
		clr.l   12(A1)
		rts     
		move.w  4(SP),D0
		lsl.w   #2,D0
		suba.l  A0,A0
		lea     0(A0,D0.w),A0
		move.l  (A0),D0
		move.l  6(SP),D1
		bmi.s   T_EF2
		move.l  D1,(A0)
T_EF2:         rts     
		moveq   #0,D0
		move.w  $442.w,D0       ;_timr_ms
		rts     
		moveq   #0,D0
		move.b  $FFFF8201.w,D0  ;dbaseh
		lsl.w   #8,D0
		move.b  $FFFF8203.w,D0  ;dbasel
		lsl.l   #8,D0
		tst.b   $A87
		bne.s   T_F16
		move.b  $FFFF820D.w,D0  ;vbaselo
T_F16:         rts     
		move.l  $44E.w,D0       ;_v_bas_ad
		rts     
		jmp     $E10804
		move.l  4(SP),$45A.w    ;colorptr
		rts     
		move.w  4(SP),D1
		add.w   D1,D1
		and.w   #$1F,D1
		lea     $FFFF8240.w,A0  ;color0
		move.w  0(A0,D1.w),D0
		tst.b   $A87
		beq.s   T_F4C
		and.w   #$777,D0
		bra.s   T_F50
T_F4C:         and.w   #$FFF,D0
T_F50:         tst.w   6(SP)
		bmi.s   T_F5C
		move.w  6(SP),0(A0,D1.w)
T_F5C:         rts     
		movea.l T_30-$1C(PC),A0
		cmpi.l  #-$789ABCDF,(A0)
		bne.s   T_F76
		dc.w    $B1F8           ;
T_F6C:         dc.w    $042E           ; .
		bge.s   T_F76
		clr.l   (A0)
		bra     T_30
T_F76:         rts     
T_F78:         movem.l D0-A7,$384.w    ;proc_dregs
		move.l  2(SP),$3C4.w    ;proc_enum
		move.w  6(SP),D0
		and.w   #$FFF,D0
		asr.w   #2,D0
		move.b  D0,$3C4.w       ;proc_enum
		move    usp,A0
		move.l  A0,$3C8.w       ;proc_usp
		moveq   #15,D0
		lea     $3CC.w,A0       ;proc_stk
		movea.l SP,A1
T_FA0:         move.w  (A1)+,(A0)+
		dbra    D0,T_FA0
		move.l  #$12345678,$380.w ;proc_lives
		moveq   #0,D1
		move.b  $3C4.w,D1       ;proc_enum
		subq.w  #1,D1
		bsr.s   T_FCE
		move.l  #$93A,$4A2.w    ;savptr
		move.w  #-$1,-(SP)
		move.w  #$4C,-(SP)
		trap    #1              ;Pterm
		bra     T_30
T_FCE:         lea     $ACE.w,A0
		move.l  #$10001,(A0)+
		clr.w   (A0)
		lea     $AD4.w,A0
		moveq   #15,D6
		clr.l   (A0)+
		move.w  D6,(A0)+
		move.w  D6,(A0)+
		clr.w   (A0)+
		move.l  A0,-(SP)
		dc.w    $A000           ;init
		move.w  -$4(A0),D7
		movea.l (SP)+,A0
		lsr.w   #1,D7
		subq.w  #8,D7
		move.w  D7,(A0)+
		move.w  D6,(A0)+
		add.w   D6,D7
		move.w  D7,(A0)
		addq.w  #1,D6
		END
