*----------------------------------------------------------------------------*
*		AUTO MANAGER
*
*		Install dans le dossier DOLMEN.SYS
*----------------------------------------------------------------------------*

		*------------*

		OPT	nocase
		opt	O+
		opt	nowarn
		opt	noeven
		opt	odl
		OPT	X-
		opt	p=68030
		opt	p=68881
		
		COMMENT	HEAD=FastLoad
		
		OUTPUT	F:\DOLMEN.SYS\TSR_MGR.PRG

		*------------*

ver_tsr		equ	$102
		
		*------------*

		include	D:\DOLMEN\SOURCES\XLIB\GEM.EQU
		include	D:\DOLMEN\SOURCES\XLIB\BIOS.EQU
		include	D:\DOLMEN\SOURCES\XLIB\XBIOS.EQU
		include	D:\DOLMEN\SOURCES\FLASH.CT2\FLASH.RS

		*------------*

*-------------------------------------------------------------------------*

		*------------*
AUTO_MGR
		move.l	4(sp),a0
		move.l	a0,cent_base
		lea	cent_stack(pc),sp

		move.l	12(a0),a1
		add.l	20(a0),a1
		add.l	28(a0),a1

		pea	256(a1)
		pea	(a0)
		clr	-(sp)
		GEM	MSHRINK

		tst	d0
		beq.s	.ok

	*--------------*
	* quitte violement en retournant l'erreur qui l'a dclenche
	* repasse aussi en utilisateur (pile ssp restaure)
.error
		cmp	#EFILNF,d0
		bne.s	.fin_error
		moveq	#0,d0
.fin_error
		move	d0,-(sp)
		GEM	Pterm
.ok
	*--------------*
	* Recopie de la chane d'environement
		move.l	p_env(a5),a0
		lea	auto_env(pc),a1
.copy1
		move.b	(a0)+,(a1)+
		bne.s	.copy1
		tst.b	(a0)
		bne.s	.copy1
		
		lea	auto_env_val(pc),a0
.copy2
		move.b	(a0)+,(a1)+
		bne.s	.copy2
		
		clr.b	(a1)

	*--------------*
	* contrle du droulement
		move	#-1,-(sp)
		BIOS	Kbshift
		btst	#2,d0	;control
		sne	d7
		bne.s	.no_redirect
		
		clr	-(sp)
		pea	bootlog(pc)
		GEM	Fcreate
		move	d0,d6
		
		move	d6,-(sp)
		move	#1,-(sp)
		GEM	Fforce
.no_redirect
	*--------------*
	* prsentation
		pea	coucou(pc)
		GEM	Cconws

	*--------------*
	* installe LA DTA du Dossier AUTO:
	* le bureau installe la sienne?
		pea	dta(pc)
		GEM	FsetDTA

	*--------------*
	* Premier fichier *.PRG du dossier AUTO
		;move	#%111,-(sp)	;accs normal+protg en criture
					;+cach
		clr	-(sp)
		pea	TSR_PATH(pc)
		GEM	FsFirst
		tst	d0
		bmi	.error
.next
	* chemin+nom
		lea	TSR_PATH(pc),a0
		lea	TSR_MASK(pc),a2
		lea	TSR_FOUND(pc),a1
.copie_path
		move.b	(a0)+,(a1)+	;chemin
		cmp.l	a0,a2
		bne.s	.copie_path

		lea	dta+30(pc),a0	;nom en dta
.copie_name
		move.b	(a0)+,(a1)+	;nom
		bne.s	.copie_name

	*--------------*
	* contrleur
		tst.b	d7
		beq	.run
		
		pea	auto_name(pc)
		GEM	Cconws
		
		pea	dta+30(pc)
		GEM	Cconws
		
		pea	auto_cont(pc)
		GEM	Cconws
.scan
		move	#con_dev,-(sp)
		BIOS	Bconin
		
		cmp	#" ",d0
		bne.s	.pas_space
		
		moveq	#0,d7
		pea	auto_run_all(pc)
		GEM	Cconws
		
		bra.s	.run
.pas_space
		cmp	#13,d0
		bne.s	.not_enter
		
		pea	auto_run(pc)
		GEM	Cconws
		
		bra.s	.run
.not_enter
		cmp	#27,d0
		bne.s	.pas_esc
		
		pea	auto_quit(pc)
		GEM	Cconws
		
		bra.s	.quit
.pas_esc
		tst	d0
		bne.s	.scan
		swap	d0
		cmp.b	#$61,d0
		bne.s	.scan
		
		pea	auto_skip(pc)
		GEM	Cconws
		
		bra.s	.skip

	*--------------*
	* lance le programme trouv
.run
		clr.l	-(sp)		;envp prcdente
		pea	string_null(pc)
		pea	TSR_FOUND(pc)
		clr	-(sp)		;mode normal
		GEM	Pexec

	* programme suivant
.skip
		GEM	FsNext
		tst	d0
		beq	.next
	* fini
		tst.b	d7
		beq.s	.quit
		
		pea	auto_fin(pc)
		GEM	Cconws
		
		move	#con_dev,-(sp)
		BIOS	Bconin
		bra.s	.fin_control
.quit
	* ferme le fichier de sortie
		move	d6,-(sp)
		GEM	Fclose
.fin_control
	*--------------*
	* on quitte en gardant rsidente la BasePage
	* sinon plus de prg rsidant en auto

		clr	-(sp)
		pea	$200.w
		GEM	Ptermres

		*------------*

*-------------------------------------------------------------------------*
		DATA
*-------------------------------------------------------------------------*

		*------------*
		
bootlog		dc.b	"BOOTLOG.TSR",0
		even
		
console		dc.b	"CON:",0
		even
		*------------*

string_null	dc.b	0
		even

		*------------*

;TSR_PATH		dc.b	"\DOLMEN.SYS\TSR\"
TSR_PATH		dc.b	"\AUTO\"
TSR_MASK		dc.b	"*.PRG",0
		even

		*------------*

	IFEQ	langue
auto_name		dc.b	13,10,27,"J"," ",27,"p"," GESTIONNAIRE DES TSR >>> ",27,"q"," ",0
		even

auto_cont		dc.b	" ",27,"p"," <<< ",27,"q",13,10
		dc.b	"   [ENTER ]  Lance celui-ci",13,10
		dc.b	"   [UNDO  ]  Passe celui-l",13,10
		dc.b	"   [ESPACE]  Lance tout les programmes",13,10
		dc.b	"   [ESC   ]  Quitter le GESTIONNAIRE DES TSR",13,10,10,0
		even
auto_run		dc.b	" Choix: Lanc ...",13,10,10,0
		even
auto_skip		dc.b	" Choix: PASS !",13,10,10,0
		even
auto_run_all	dc.b	" Choix: Lance tout ...",13,10,10,0
		even
auto_quit		dc.b	" Choix: quitte !?",13,10,10,0
		even

auto_fin		dc.b	13,10,27,"J"," ",27,"p"," GESTIONNAIRE DES TSR FINI ",27,"q",13,10
		dc.b	10
		dc.b	"   Frappez une touche...",0
		even

auto_error	dc.b	13,10,27,"J"," ",27,"p"," ERREUR DANS LE GESTIONNAIRE DES TSR ",27,"q",13,10
		dc.b	10
		dc.b	"   Frappez une touche...",0
		even

go_os		dc.b	27,"E"
		dc.b	" ",27,"p"," LANCEMENT DE Rne... ",27,"q"
		dc.b	13,10,10,0
		even

	ENDC
	IFEQ	langue-1
auto_name		dc.b	13,10,27,"J"," ",27,"p"," TSR MANAGER >>> ",27,"q"," ",0
		even

auto_cont		dc.b	" ",27,"p"," <<< ",27,"q",13,10
		dc.b	"   [ENTER]  Run this one",13,10
		dc.b	"   [UNDO ]  Skip this one",13,10
		dc.b	"   [SPACE]  Run all programs",13,10
		dc.b	"   [ESC  ]  Quit TSR MANAGER",13,10,10,0
		even
auto_run		dc.b	" Choice: Run ...",13,10,10,0
		even
auto_skip		dc.b	" Choice: SKIP !",13,10,10,0
		even
auto_run_all	dc.b	" Choice: Run all ...",13,10,10,0
		even
auto_quit		dc.b	" Choice: quit !?",13,10,10,0
		even

auto_fin		dc.b	13,10,27,"J"," ",27,"p"," END OF TSR MANAGER ",27,"q",13,10
		dc.b	10
		dc.b	"   Hit a key...",0
		even

go_os		dc.b	27,"E"
		dc.b	" ",27,"p"," LAUNCHING Rne... ",27,"q"
		dc.b	13,10,10,0
		even
	ENDC
	IFEQ	langue-2
auto_name		dc.b	13,10,27,"J"," ",27,"p"," TSR-MANAGER >>> ",27,"q"," ",0
		even

auto_cont		dc.b	" ",27,"p"," <<< ",27,"q",13,10
		dc.b	"   [ENTER]  Dieses Programm starten",13,10
		dc.b	"   [UNDO ]  Dieses Programm berspringen",13,10
		dc.b	"   [SPACE]  Alle Programme starten",13,10
		dc.b	"   [ESC  ]  TSR-Manager beenden",13,10,10,0
		even
auto_run		dc.b	" Wahl: Starten ...",13,10,10,0
		even
auto_skip		dc.b	" Wahl: berspringen !",13,10,10,0
		even
auto_run_all	dc.b	" Wahl: Alle starten ...",13,10,10,0
		even
auto_quit		dc.b	" Wahl: Beenden !?",13,10,10,0
		even

auto_fin		dc.b	13,10,27,"J"," ",27,"p"," END OF TSR MANAGER ",27,"q",13,10
		dc.b	10
		dc.b	"   Hit a key...",0
		even

go_os		dc.b	27,"E"
		dc.b	" ",27,"p"," Starte Rne... ",27,"q"
		dc.b	13,10,10,0
		even
	ENDC
		*------------*

		cnop	0,16
coucou		dc.b	27,"E"
		dc.b	" ***************************",13,10
		dc.b	" *                         *",13,10
		dc.b	" *         DOLMEN         *",13,10
		dc.b	" *       TSR MANAGER       *",13,10
		dc.b	" *        rev: "
		dc.b	((ver_tsr>>8)&$f)+'0','.'
		dc.b	((ver_tsr>>4)&$f)+'0','.'
		dc.b	((ver_tsr>>0)&$f)+'0',"       *",13,10
		dc.b	" *                         *",13,10
		dc.b	" ***************************",13,10
		dc.b	13,10
		dc.b	0
		even
		
		*------------*
		* Variable d'environement pour l'environement

auto_env_val	dc.b	"AUTO",0
		even

		*------------*

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*

		*------------*

tsr_found		ds.b	64
		
auto_env		ds.b	64	;chane d'environement
				;pour le dossier AUTO
		*------------*

dta		ds.b	44

		*------------*

cent_base		ds.l	1

stack		ds.l	1000
cent_stack	ds.l	1

		*------------*
		
*-------------------------------------------------------------------------*
