*-------------------------------------------------------------------------*	
*		BOOT DE DOLMEN
*-------------------------------------------------------------------------*
		TEXT
*-------------------------------------------------------------------------*


		OPT	nocase
		opt	O+
		opt	nowarn
		opt	noeven
		opt	odl
		OPT	X-
		opt	p=68030
		opt	p=68881

		include	..\FLASH.RS

	Ifne	no_distrib
	  IFEQ	langue
		OUTPUT	D:\BIN\DOLPUBF.BIN
	  ENDC
	  IFEQ	langue-1
		OUTPUT	D:\BIN\DOLPUBE.BIN
	  ENDC
	  IFEQ	langue-2
		OUTPUT	D:\BIN\DOLPUBD.BIN
	  ENDC
	
	else
	  IFEQ	langue
		OUTPUT	D:\BIN\DOLBOOTF.BIN
	  ENDC
	  
	  IFEQ	langue-1
		OUTPUT	D:\BIN\DOLBOOTE.BIN
	  ENDC
	  
	  IFEQ	langue-2
		OUTPUT	D:\BIN\DOLBOOTD.BIN
	  ENDC
	endc

*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*

		*-------------*

		include	D:\DOLMEN\SOURCES\XLIB\GEM.EQU
		include	D:\DOLMEN\SOURCES\XLIB\BIOS.EQU
		include	D:\DOLMEN\SOURCES\XLIB\XBIOS.EQU

		include	D:\DOLMEN\SOURCES\DOLMEN.RS
		include	D:\DOLMEN\SOURCES\BORIS\BORIS.RS
		include	D:\DOLMEN\SOURCES\BORIS\VIDEL\VIDEL.RS
		
		include	D:\DOLMEN\SOURCES\BORIS\CECILE.BRS\SYS\SYSHEAD.RS

		*-------------*

	ifne	no_distrib

*-------------------------------------------------------------------------*
	
START_BOOT
		lea	Fast_dol_start+dol_vars,a6	
		
		lea	no_dolmen(pc),a0
		jsr	([TextOut,a6])
		
		jsr	([Conin.w,a6])
		st	open_setup(a6)
		
		*-------------*
		
		jmp	Romtos_addr+rom_jmp
		
		*-------------*

	IFEQ	langue
no_dolmen		dc.b	27,"c"
dolmen_fond	dc.b	32+bleu_f,27,"E"
		dc.b	27,"Y",32+4,32+39-3,27,"b",32+rouge
		dc.b	"ENTEK"

		dc.b	27,"Y",32+5,32+39-12,27,"b",32+violet
		dc.b	"Crateur de Performances"
		
		dc.b	27,"Y",32+8,32+39-17,27,"b",32+jaune
		dc.b	"Dmarrage du systme d'exploitation",13,10
		dc.b	27,"Y",32+9,32+39-5
		dc.b	"DOLMEN "
		dc.b	((dolmen_version>>8)&$f)+'0','.'
		dc.b	((dolmen_version>>4)&$f)+'0'
		dc.b	((dolmen_version>>0)&$f)+'0'

		dc.b	27,"Y",32+15,32+39-15,27,"b",32+rouge
		dc.b	"Dolmen n'est disponible que pour",13,10
		dc.b	27,"Y",32+16,32+39-17,27,"b",32+rouge
		dc.b	"les dveloppeurs Phnix enregistrs.",13,10
		dc.b	27,"Y",32+20,32+39-29,27,"b",32+rouge
		dc.b	"~~~~~~ Appuyez sur une touche pour revenir au Setup ~~~~~~",13,10
		dc.b	0
		even
	ENDC
	
	IFEQ	langue-1
no_dolmen		dc.b	27,"c"
dolmen_fond	dc.b	32+bleu_f,27,"E"
		dc.b	27,"Y",32+4,32+39-3,27,"b",32+rouge
		dc.b	"ENTEK"

		dc.b	27,"Y",32+5,32+39-11,27,"b",32+violet
		dc.b	"Creator Of Performances"
		
		dc.b	27,"Y",32+8,32+39-12,27,"b",32+jaune
		dc.b	"Starting Operating System",13,10
		dc.b	27,"Y",32+9,32+39-5
		dc.b	"DOLMEN "
		dc.b	((dolmen_version>>8)&$f)+'0','.'
		dc.b	((dolmen_version>>4)&$f)+'0'
		dc.b	((dolmen_version>>0)&$f)+'0'

		dc.b	27,"Y",32+15,32+39-14,27,"b",32+rouge
		dc.b	"Dolmen is only available for",13,10
		dc.b	27,"Y",32+16,32+39-14,27,"b",32+rouge
		dc.b	"registered Phnix developper.",13,10
		dc.b	27,"Y",32+20,32+39-24,27,"b",32+rouge
		dc.b	"~~~~~~ Press a key to return to the Setup ~~~~~~",13,10
		dc.b	0
		even
	ENDC
	
	IFEQ	langue-2
no_dolmen		dc.b	27,"c"
dolmen_fond	dc.b	32+bleu_f,27,"E"
		dc.b	27,"Y",32+4,32+39-3,27,"b",32+rouge
		dc.b	"ENTEK"

		dc.b	27,"Y",32+5,32+39-11,27,"b",32+violet
		dc.b	"Creator Of Performances"
		
		dc.b	27,"Y",32+8,32+39-10,27,"b",32+jaune
		dc.b	"Starte Betriebssystem",13,10
		dc.b	27,"Y",32+9,32+39-5
		dc.b	"DOLMEN "
		dc.b	((dolmen_version>>8)&$f)+'0','.'
		dc.b	((dolmen_version>>4)&$f)+'0'
		dc.b	((dolmen_version>>0)&$f)+'0'

		dc.b	27,"Y",32+15,32+39-14,27,"b",32+rouge
		dc.b	"Dolmen is only available for",13,10
		dc.b	27,"Y",32+16,32+39-14,27,"b",32+rouge
		dc.b	"registred Phnix developper.",13,10
		dc.b	27,"Y",32+20,32+39-33,27,"b",32+rouge
		dc.b	"~~~~~~ Drcken Sie eine Taste, um zum Setup zurckzukehren. ~~~~~~",13,10
		dc.b	0
		even
	ENDC
		

*-------------------------------------------------------------------------*
	else	* no distrib
	

vec_err		equ	1	;0->-488

		*-------------*

*-------------------------------------------------------------------------*
* une pile est dj en place
* pendant le boot:
* A5: pointe sur les vars pour le TOS
* A6: pointe sur les sysvars
* A7: pointe sur la pile du setup
*-------------------------------------------------------------------------*

*--------------*

START_BOOT
	* Variables systme
		lea	fast_dol_start+dol_vars,a6	
		sf	system_run(a6)

	* vido initialisation
		bsr	VIDEO_PUT
		
	* vecteur reset
		bsr	RES_VECTOR

	* Efface la RAM et met  jour les variables lis  la RAM
		bsr	CLR_RAM
		
*--------------*

INIT_DOLMEN

	* initialisation de base (pour les .SYS)
	* ! C'est pas encore Boris ! (sort en IPL 3)
		bsr	INIT_BORIS

	* introduction
		cmp.b	#"A",ct2_ok(a6)
		beq.s	.rev_a
		move.b	#32+cyan_f,dolmen_fond
.rev_a
		lea	intro(pc),a0
		jsr	([TextOut,a6])
		
		jsr	([PutPal,a6])	;la palette

	* test ram+pause: l'appui sur une touche coupe tout!
Check
		btst	#2,flags_boot(a6)
		beq.s	.no_ramtest
		bsr	test_ram
.no_ramtest
		btst	#1,flags_boot(a6)
		beq.s	.no_wait
		bsr	wait
.no_wait
	* go setup ? dernier test avant le lancement de l'OS
		bsr	Go_setup
	
*--------------*

LAUNCH_DOLMEN
	* initialisation du GEMDOS (bientt ccile y sera intgr ainsi que
	* la disquette)
		bsr	INIT_GEMDOS
	

	* Doit-on booter sur le lecteur de disquette en premier?
	* Seulement si le lecteur existe.
		btst	#6,flags_boot(a6)
		bne.s	.PAS_BOOT_FLOPPY	;non!

		bsr	BootFloppy
.PAS_BOOT_FLOPPY
	* Initialisation de Ccile
		bsr	INIT_CECILE

	* revalide le Floppy au cas ou Ccile est remis par erreur le A&B :-)
		bsr	ValidFloppy

	* validation du chemin (variable d'environement)
		move.l	dolmen_basepage(pc),a1
		
		move.l	#PATH_DOL,p_env(a1)
		move	_bootdev.w,d0         
		moveq	#"A",d1
		add.b	d0,d1
		move.b	d1,PATH_DOL_LET
		move.b	d1,PATH_DOLSYS_LET
	
	* chargement des modules systmes externes
	* BORIS.SYS, MENHIR.SYS et *.SYS (???)
	* met en place une basepage pour les .SYS
		bsr	OPEN_SYS
		
	* systme lanc, enfin!
		st	system_run(a6)
	
*--------------*
* TSR
		bsr	AUTO_FOLDER

*--------------*
* GEM
		bsr	GEM_LAUNCH

*--------------*
* systme fini... on reset la machine
*   je pourrai mettre une zoli fin si je voulais
		
		jmp	romtos_addr+rom_jmp	;reset...

		*-------------*

*-------------------------------------------------------------------------*
		
		*-------------*
		* lancement de l'os (GEM) en rom
		cnop	0,16
GEM_LAUNCH
	*--------------*
	* recherche le GEM externe
	* on pourrait lancer auparavant un shell qui lancerait, lui
	* le bureau.
		clr	-(sp)
		pea	GEM_EXT(pc)
		GEM	Fopen
		tst	d0
		bmi.s	.no_external
		
		move	d0,-(sp)
		GEM	Fclose
		
	* ...et le lance
		;move.l	#fast_dol_start,_sysbase.w
		move.l	#romtos_addr,_sysbase.w
		
		lea	string_null(pc),a0
		pea	(a0)
		pea	(a0)
		pea	GEM_EXT(pc)
		clr	-(sp)		;mode normal
		GEM	Pexec
		
	* Lancera le GEM standard si on arrive l....
		pea	gem_end(pc)
		GEM	Cconws
		
		GEM	Crawcin
.no_external
	* lancememt du GEM interne
		lea	fast_dol_start+dol_vars,a6	
		pea	Go_os(pc)
		gem	Cconws

		move.l	#romtos_addr,_sysbase.w	
		
		move	_bootdev.w,d0         
		moveq	#"A",d1
		add.b	d0,d1

	* partition de boot pour les ACC...
		move.l	tos_vars_off(pc),a5
		lea	romtos_copy,a4
		move.l	#$4e714e71,d2		;2 nops
	* ACC
		move.l	a4,a0
		add.l	patch_acc(a5),a0
		move	d0,(a0)
	
	* NEWDESK
		move.l	a4,a0
		add.l	patch_new1(a5),a0
		move	d0,(a0)
		move.l	a4,a0
		add.l	patch_new2(a5),a0
		move.b	d1,(a0)
		move.l	a4,a0
		add.l	patch_new3(a5),a0
		move	d2,(a0)

	* DESKICON
		move.l	a4,a0
		add.l	patch_desk1(a5),a0
		move.b	d1,(a0)
		move.l	a4,a0
		add.l	patch_desk2(a5),a0
		move.l	d2,(a0)

	* cre une BasePage pour l'os
		clr.l	-(sp)
		pea	string_null(pc)	;null
		pea	FastLoad+FastPrg+FastMem.w		
					;PrgFlags
		move	#7,-(sp)		;cr une BasePage
		GEM	Pexec
		move.l	d0,a0		;pointeur sur la BasePage

	* pointeur sur l'os
		move.l	exec_os.w,8(a0)	;->ptr_text_segment

	* lancement de l'os
		clr.l	-(sp)
		move.l	a0,-(sp)		;adresse de la BasePage
		clr.l	-(sp)
		move	#4,-(sp)		;excute la "BasePage"
		GEM	Pexec

		*-------------*
		
		rts
		
		*-------------*

*-------------------------------------------------------------------------*
*		sous-programmes
*-------------------------------------------------------------------------*

		*-------------*

		include	DOL_SUB.S
		include	DOL_BRS.S
		include	DOL_SYS.S
		include	DOL_GEM.S
		
		*-------------*

*-------------------------------------------------------------------------*
		DATA
*-------------------------------------------------------------------------*

		*------------*

		cnop	0,16
	IFEQ	langue
intro		dc.b	27,"c"
dolmen_fond	dc.b	32+bleu_f,27,"E"
		dc.b	27,"Y",32+4,32+39-3,27,"b",32+rouge
		dc.b	"ENTEK"

		dc.b	27,"Y",32+5,32+39-10,27,"b",32+violet
		dc.b	"Crateur de Performances"
		
		dc.b	27,"Y",32+8,32+39-17,27,"b",32+jaune
		dc.b	"Dmarrage du systme d'exploitation",13,10
		dc.b	27,"Y",32+9,32+39-5
		dc.b	"DOLMEN "
		dc.b	((dolmen_version>>8)&$f)+'0','.'
		dc.b	((dolmen_version>>4)&$f)+'0'
		dc.b	((dolmen_version>>0)&$f)+'0'

		dc.b	27,"Y",32+20,32+2,27,"b",32+gris
		dc.b	"Appuyez sur HELP pour entrer dans le menu de configuration...",13,10
		dc.b	0
		even
	ENDC

	IFEQ	langue-1
intro		dc.b	27,"c"
dolmen_fond	dc.b	32+bleu_f,27,"E"
		dc.b	27,"Y",32+4,32+39-3,27,"b",32+rouge
		dc.b	"ENTEK"

		dc.b	27,"Y",32+5,32+39-11,27,"b",32+violet
		dc.b	"Creator Of Performances"
		
		dc.b	27,"Y",32+8,32+39-12,27,"b",32+jaune
		dc.b	"Starting Operating System",13,10
		dc.b	27,"Y",32+9,32+39-5
		dc.b	"DOLMEN "
		dc.b	((dolmen_version>>8)&$f)+'0','.'
		dc.b	((dolmen_version>>4)&$f)+'0'
		dc.b	((dolmen_version>>0)&$f)+'0'

		dc.b	27,"Y",32+20,32+2,27,"b",32+gris
		dc.b	"Press HELP to enter in the Setup...",13,10
		dc.b	0
		even
	ENDC
	IFEQ	langue-2
intro		dc.b	27,"c"
dolmen_fond	dc.b	32+bleu_f,27,"E"
		dc.b	27,"Y",32+4,32+39-3,27,"b",32+rouge
		dc.b	"ENTEK"

		dc.b	27,"Y",32+5,32+39-11,27,"b",32+violet
		dc.b	"Creator Of Performances"
		
		dc.b	27,"Y",32+8,32+39-10,27,"b",32+jaune
		dc.b	"Starte Betriebssystem",13,10
		dc.b	27,"Y",32+9,32+39-5
		dc.b	"DOLMEN "
		dc.b	((dolmen_version>>8)&$f)+'0','.'
		dc.b	((dolmen_version>>4)&$f)+'0'
		dc.b	((dolmen_version>>0)&$f)+'0'

		dc.b	27,"Y",32+20,32+2,27,"b",32+gris
		dc.b	"Drcken Sie HELP, um das Setup aufzurufen....",13,10
		dc.b	0
		even
	ENDC

		*------------*

string_null	dc.b	0
		even

		*------------*

		* Variables d'environment de base
PATH_DOL		dc.b	"PATH=",0		;1 var
PATH_DOL_LET	dc.b	"#:\,"		;1er param
PATH_DOLSYS_LET	dc.b	"#:\DOLMEN.SYS",0	;2eme param
		dc.b	0		;chane finie
		even

		* GEM externe incluant le lancement du SHELL (Bureau)
GEM_EXT		dc.b	"DOLMEN.SYS\GEM.PRG",0
		even

		*------------*

	IFEQ	langue
go_os		dc.b	27,"E"
		dc.b	" ",27,"p"," LANCEMENT DU GEM INTERNE... ",27,"q"
		dc.b	13,10,10,0
		even

gem_end		dc.b	27,"E"
		dc.b	" ",27,"p"," GEM FINI... ",27,"q",13,10
		dc.b	10
		dc.b	"   Frappez une touche pour lancer le GEM interne...",0
		even

	ENDC
	IFEQ	langue-1
go_os		dc.b	27,"E"
		dc.b	" ",27,"p"," LAUNCHING INTERNAL GEM... ",27,"q"
		dc.b	13,10,10,0
		even

gem_end		dc.b	27,"E"
		dc.b	" ",27,"p"," GEM END... ",27,"q",13,10
		dc.b	10
		dc.b	"   Hit a key to launch internal GEM...",0
		even
	ENDC
	IFEQ	langue-2
go_os		dc.b	27,"E"
		dc.b	" ",27,"p"," STARTE INTERNAL GEM... ",27,"q"
		dc.b	13,10,10,0
		even

gem_end		dc.b	27,"E"
		dc.b	" ",27,"p"," GEM END... ",27,"q",13,10
		dc.b	10
		dc.b	"   Hit a key to launch internal GEM...",0
		even
	ENDC
		*-------------*

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*

		*-------------*

		*-------------*

*-------------------------------------------------------------------------*
	endc	* no_distrib