*----------------------------------------------------------------------------*
*		Base de Boris pour la Flash
*
* INIT_BORIS:
* - Il se charge de finir l'initialisation de la machine
* - vectorise tout les vecteurs du CPU et quelques variables systmes
* - Installe les cookies (32 MAX)
*
* NEW_BIOS:
* - bios lger qui saute  celui du TOS si la fonction n'est pas gre.
* - fonctions bios implantes:
*   Bconstat
*   Bconin
*   Bconout
*   Bcostat
*   Setexec
*   Elles utilisent les fonctions internes du setup.
*
* NEW_XBIOS:
* - xbios lger qui ne gre que les fonctions suivantes:
*   Gettime
*   Supexec
*
*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*

boot_cookies	equ	32

*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
INIT_BORIS
		movem.l	d1-7/a1-5,-(sp)

	*--------------*
	* TOS: version du TOS
		moveq	#$f,d0
		and	romtos_addr+rom_version,d0
		move	d0,tos_ver
		
		move.l	(tos_vars-1*4,pc,d0*4),a5
		move.l	a5,tos_vars_off

	*--------------*
	* TOS: patch d'une variable systme: end_os
		move.l	romtos_addr+rom_gem_magic,a0
		lea	(pmmu_end-romtos_len-pmmu_len-romtos_addr.l,a0),a0
		lea	chip_dol_end,a1
		move.l	a1,4(a0)

	* TOS: efface la fin de vars systmes non documentes
		tst.b	ram_clr(a6)
		bne	.dj

		move.l	a1,d0
		sub.l	#chip_dol_sclear,d0
		lsr.l	#4,d0
		subq	#1,d0
		moveq	#0,d1
.clr_sysvars
		rept	4
		move.l	d1,-(a1)
		endr
		dbra	d0,.clr_sysvars
.dj
	*--------------*
	* vecteurs
		lea	rte_adr(pc),a3
		lea	rts_adr(pc),a4
		lea	ErrorVec(pc),a1

	*--------------*
	* vecteur par dfaut => traitement de l'erreur (comme les bombes !)
		lea	BusError.w,a0		;bus_error
		move	#(CentBusy-BusError)/4-1,d0
.init_vec
		move.l	a1,(a0)+		;tout les vecteurs
		dbra	d0,.init_vec

	*--------------*
	* division par 0
		move.l	a3,Div0.w		;divbyzero

	*--------------*
	* TOS: violation de privilge
		move.l	t_prviol(a5),PrViol.w

	*--------------*
	* initialise les autovecteurs
		moveq	#7-1,d0		;7 autovecteurs
		lea	AVec1.w,a1	;autov_int1
.init_autovec
		move.l	a3,(a1)+		;=>"RTE"
		dbra	d0,.init_autovec
	* HBL
		move.l	a3,HBLvec.w
		
	* VBL
		move.l	a3,VBLvec.w

	*--------------*
	* LINEA
		move.l	t_linea(a5),LineA.w
	
	*--------------*
	* AES/VDI
		move.l	a3,Trap2.w        ;trp2vec ("RTE")

	*-------------*
	* installe le BIOS
		move.l	t_trap13(a5),old_trap13	;TOS
		move.l	#new_bios,Trap13.w
		
	*-------------*
	* installe le XBIOS
		move.l	#new_xbios,Trap14.w

	*--------------*
	* init nvram
		stnvm	#%00100000,#time_update
		
		moveq	#%00000100,d0	;format binaire/pas d'ints/
					;heure d'hivers?!
		btst	#4,idt(a6)
		beq.s	.ampm
		or	#%10,d0		;format 24h
.ampm
		stnvm	d0,#nvm_conf
		stnvm	#0,#nvm_int

	*--------------*
	* met en place les vars systme d'un autre monde, le TOS !
	
	* ETV_TIMER
		move.l	a4,etv_timer.w	;gem etv
	
	* TOS: ETV_CRITIC
		move.l	t_etvcritic(a5),etv_critic.w
	
	* ETV_TERM
		move.l	a4,etv_term.w

	* chip-ram et gemdos
		move.l	phystop.w,_memtop.w		
		move.l	phystop.w,_v_bas_ad.w	;pour le GEMDOS du TOS

	* TOS:
		move.l	romtos_addr+rom_gem_magic,a0
		move.l	4(a0),end_os.w
		move.l	8(a0),exec_os.w

	* insre le _FRB entre la fin du systme
	* et le dbut de la zone utilisateur
		move.l	end_os.w,d0

		tst.l	ramtop.w
		beq.s	.no_fast
		add.l	#64*1024,d0	;buffer _FRB
.no_fast
		move.l	d0,_membot.w

	* floppy	
		clr	_flock.w
		move	#3,seekrate.w
		st	_fverify.w

	* disquette en vbl coupe
		st	_fverify.w

	* TOS: changement de rsolution ????
		move.l	a4,$46e.w		;rts
	
	* TOS: vecteurs disques
		move.l	t_hdvinit(a5),hdv_init.w
		move.l	t_hdvrw(a5),hdv_rw.w
		move.l	t_hdvbpb(a5),hdv_bpb.w
		move.l	t_hdvmediach(a5),hdv_mediach.w
		move.l	t_hdvboot(a5),hdv_boot.w
		
	* TOS: pour le BIOS et le XBIOS
		move.l	#$93a,$4A2.w	;savptr

	* plus de lecteurs...
		clr.l	_drvbits.w

	* TOS: buffer disque
		move.l	#$1cc6,_dskbufp.w
	
	* TOS: recopie du header du TOS plus quelques modification
	* => pointeur sur la zone recopie  en _sysbase ($4f2)

		jsr	([t_initvars,a5])	;init vars systme
					;recopie de end_os
	* vectorisations
		
		move.l	a4,etv_timer.w	;gem etv

	*-------------*
	* Installe les cookies

		lea	cookies_jar(pc),a0
		move.l	a0,_p_cookies.w
	* Dolmen
		move.l	#"_DOL",(a0)+
		move.l	#dolmen_version,(a0)+

	* CT2 a&b
		move.l	#"_CT2",(a0)+
		move.l	ct2_val(a6),(a0)+
		
	* _CPU
		move.l	#"_CPU",(A0)+	;_CPU
		move.l	#$1e,(a0)+
		st	$59f.w		;stack_frame

	* PMMU
		move.l	#"PMMU",(a0)+
		;move.l	#dolmen_version,(a0)+
		move.l	#rts_adr,(a0)+
		
	* _VDO
		move.l	#"_VDO",(a0)+	;_VDO
		move.l	#$30000,(a0)+	;VIDEL

	* _MCH
		move.l	#"_MCH",(a0)+
		move.l	#$30000,(a0)+	;Falcon
	* _SWI
		move.l	#"_SWI",(a0)+
		moveq	#0,d0
		move	$ffff9200.w,d0
		lsr	#8,d0
		move.l	d0,(a0)+
	* _SND
		moveq	#$1f,d1
		move.l	#"_SND",(a0)+
		btst	#7,d0		;pas de dma?
		bne.s	.no_dma
		bclr	#1,d1
.no_dma
		move.l	d1,(a0)+
	* _FDC
		btst	#6,d0
		bne.s	.pas_floppy
		move.b	#8,$16d4.w
		move.l	#"_FDC",(a0)+
		move.l	#$1415443,(a0)+	;HD+"ATC"
.pas_floppy
	* _FPU
		move.l	#"_FPU",(a0)+

		moveq	#0,D7		;pas de copro?
		move.l	LineF.w,a3
		move.l	CoproProt.w,a4

		lea	.no_copro(pc),a2	;come back
		move.l	a2,LineF.w  
		move.l	a2,CoproProt.w

		lea	CoproVec.w,a2
		movem.l	(a2),d0-d6	;mega-sauvegarde
		lea	.copro(pc),a5	;come back copro

		rept	7
		move.l	a5,(a2)+
		endr
		clr.l	-(sp)
		move.l	sp,a2
		frestore	(sp)		;reset le copro
.copro
		move.l	#$60000,d7	;68882
.no_copro
		move.l	a2,sp
		addq.l	#4,sp
		move.l	a3,LineF.w
		move.l	a4,CoproProt.w
		movem.l	d0-d6,CoproVec.w	;mega-restauration
		move.l	d7,(a0)+
	* _FRB
		move.l	fast_bot(a6),d1
		move.l	fast_top(a6),d0
		beq.s	.no_fast2

		sub.l	d1,d0
		beq.s	.no_fast2
		move.l	#"_FRB",(a0)+
		move.l	end_os.w,(a0)+
.no_fast2
	* _AKP
		move.l	#"_AKP",(a0)+
		clr.l	d0
		move	akp(a6),d0
		move.l	d0,(a0)+
	* _IDT
		move.l	#"_IDT",(a0)+
		move	idt(a6),d0
		move.l	d0,(a0)+
	
	* _TSR
		move.l	#"_TSR",(a0)+
		clr.l	(a0)+		;pas dans le TSR
		
	* fin cookies
		clr.l	(a0)+
		move.l	#max_cookies,(a0)
		
		*-------------*
		
		movem.l	(sp)+,d1-7/a1-5
		rts
		
		*-------------*

*----------------------------------------------------------------------------*
*		Trap BIOS
*----------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
new_bios:
		move.l	usp,a0
		btst.b	#5,(sp)
		beq.s	.ok_sp
		lea	8(sp),a0
.ok_sp
		move	(a0)+,d0

		cmp	#1,d0
		beq.s	Bcon_stat
		cmp	#2,d0
		beq.s	Bcon_in
		cmp	#3,d0
		beq.s	Bcon_out
		cmp	#8,d0
		beq	Bco_stat
		cmp	#5,d0
		beq	Set_exec
		
		* pour Getmpb(Gemdos), Rwabs, Getbpb, Mediach et Drvmap
		* mme aprs Ccile ?!
		jmp	([old_trap13,pc])
		
*-------------------------------------------------------------------------*

		*-------------------*
		cnop	0,16
Bcon_stat
		moveq	#0,d0
		
		cmp	#2,(a0)
		bne.s	.fin
		
		lea	fast_dol_start+dol_vars,a0
		jsr	([ConStat.w,a0])
.fin
		rte
		
		*-------------------*

*-------------------------------------------------------------------------*

		*-------------------*
		cnop	0,16
Bcon_in
		moveq	#0,d0
		
		cmp	#2,(a0)
		bne.s	.fin
		
		lea	fast_dol_start+dol_vars,a0
		jsr	([Conin.w,a0])
.fin
		rte
		
		*-------------------*

*-------------------------------------------------------------------------*

		*-------------------*
		cnop	0,16
Bcon_out
		moveq	#0,d0
		
		cmp	#2,(a0)
		beq.s	.out
		cmp	#5,(a0)
		bne.s	.fin
		
		lea	fast_dol_start+dol_vars,a0
		jsr	([RawOut.w,a0])
		bra.s	.fin
.out
		lea	fast_dol_start+dol_vars,a0
		jsr	([ConOut.w,a0])
.fin
		rte
		
		*-------------------*

*-------------------------------------------------------------------------*

		*-------------------*
		cnop	0,16
Bco_stat
		moveq	#0,d0
		rte
		
		*-------------------*

*-------------------------------------------------------------------------*

		*-------------------*
		cnop	0,16
Set_exec
		move.l	d1,-(sp)
		
		move	(a0)+,d0
		move.l	(a0),d1
		lea	(za0,d0*4),a0
		move.l	(a0),d0
		cmp.l	#-1,d1
		beq.s	.inquire
		
		move.l	d1,(a0)
.inquire
		move.l	(sp)+,d1
		rte
		
		*-------------------*

*----------------------------------------------------------------------------*
*		Trap XBIOS
*----------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
new_xbios:
		move.l	usp,a0
		btst.b	#5,(sp)
		beq.s	.ok_sp
		lea	8(sp),a0
.ok_sp
		move	(a0)+,d0

		cmp	#$26,d0
		beq.s	Sup_exec
		cmp	#$17,d0
		beq.s	Get_Time
		
		rte
		
*-------------------------------------------------------------------------*

		*-------------------*
		* Ccile...
		
		cnop	0,16
Sup_exec
		movem.l	d1-d7/a1-6,-(sp)
		
		jsr	([a0])
		
		movem.l	(sp)+,d1-d7/a1-6
		
		rte
		
		*-------------------*

*-------------------------------------------------------------------------*

		*-------------------*
		* GEMDOS...
		
		cnop	0,16
Get_time
.wait
		ldnvm	#time_update,d0
		bmi	.wait
		
		move.l	d1,-(sp)
		
	* anne
		ldnvm	#cur_year,d1
		sub.b	#80-68,d1		;dcalage nvm/tos
		and	#%1111111,d1
		
		move	d1,d0
		
	* mois
		ldnvm	#cur_month,d1
		and	#%1111,d1
		
		lsl.l	#4,d0
		or	d1,d0
		
	* jour
		ldnvm	#cur_mday,d1
		and	#%11111,d1
		
		lsl.l	#5,d0
		or	d1,d0
		
	* heure
		ldnvm	#cur_hour,d1
		and	#%11111,d1
		lsl.l	#5,d0
		or	d1,d0
		
	* minute
		ldnvm	#cur_min,d1
		and	#%111111,d1
		lsl.l	#6,d0
		
		or	d1,d0
		
	* seconde
		ldnvm	#cur_sec,d1
		lsr.b	#1,d1
		and	#%11111,d1
		lsl.l	#5,d0
	
		or	d1,d0

		move.l	(sp)+,d1
		rte
		
		*-------------------*

*-------------------------------------------------------------------------*
		DATA
*-------------------------------------------------------------------------*

		*-------------*
		
		*-------------*

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*
		
		*-------------*
		* Ancien pointeur sur le BIOS

old_trap13	ds.l	1

		*-------------*
		* cookie's jar
		
cookies_jar	ds.l	2*boot_cookies
cookies_jar_end

		*-------------*

*-------------------------------------------------------------------------*
