*----------------------------------------------------------------------------*
*		GEMDOS pour la Flash
*
* INIT_GEMDOS:
* - installe le GEMDOS du TOS  dfaut du GEMDOS de David
* - installe (dclare) la Fast-RAM
* - cre le premier process en Fast-Ram
* - fixe la dta
*
* INIT_CECILE:
* - lance le ccile interne
* - recherche le ccile sur la partition de dmarrage et en prends les paramtres
*   supplmentaires pour la configuration.
* - doit vectoriser le GEMDOS pour viter le Cconws sur des routines BIOS qui
*   ne sont pas encore l (il est enlev  la fin)
*
* BOOTFLOPPY
* - valide le lecteur de disquette
* - execute le boot de la disquette
*
* SCANFLOPPY
* - valide le lecteur de disquette
*
*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
INIT_GEMDOS
		movem.l	d1-7/a1-6,-(sp)
		move	sr,-(sp)
		
		move.l	sp,gemdos_pile
	
	*--------------*
	* variables du TOS
		move.l	tos_vars_off(pc),a5

	*--------------*
	* init GEMDOS, VDI, ...
		move.b	([DeadKeys.w,a6]),d0
		btst	#3,d0
		bne.s	.dolgem
	
		jsr	([t_initgem,a5])
		
		bra.s	.tosgem
	
	* copie et reloge dolgem
.dolgem
		move.l	dolgem_ptr(a6),a0
		move.l	fast_bot(a6),a1
		move.l	a1,d0
		jsr	([reloc_ptr.w,a6])
		add.l	a1,d0
		moveq	#15,d1
		add.l	d1,d0
		not.l	d1
		and.l	d1,d0
		move.l	d0,fast_bot(a6)
		
	* init dolgem
		jsr	(a1)
.tosgem
	* dclare Fast-Ram
		move.l	fast_bot(a6),a0
		move.l	fast_top(a6),d0
		beq.s	.no_fast

		sub.l	a0,d0
		beq.s	.no_fast
		
		move.l	d0,-(sp)
		pea	(a0)
		GEM	Maddalt
.no_fast
	*--------------*
	* NON<=cre un process en fast-ram
	* Je remet un process de base en Chip car je vais faire
	* des mxalloc
		lea	string_null(pc),a0	;pointeur sur
					;chane nulle
		pea	(a0)
		pea	(a0)
		pea	FastLoad+FastPrg+FastMem.w		
					;prgflags
		move	#7,-(sp)		;cre une basepage
		GEM	Pexec
		move.l	d0,a0		;adresse de la basepage
		move.l	a0,dolmen_basepage

	* il lance le premier excutable (qui peut se terminer)
		lea	.fast_process(pc),a1
		move.l	a1,8(a0)

		clr.l	-(sp)		;inutilis
		pea	(a0)
		clr.l	-(sp)		;inutilis
		move	#6,-(sp)		;lance la "BasePage"
		GEM	Pexec

		illegal

	*--------------*
	* premier programme
.fast_process
	* change de pointeur de pile (user)
		move.l	4(sp),a5
		lea	$200(a5),sp	;nouveau pointeur de
					;pile
	* Libre le trop plein de RAM
		pea	$200.w
		pea	(a5)
		clr	-(sp)
		GEM	Mshrink

	* fixe la dta
		pea	dta(pc)
		GEM	Fsetdta

	* Passe en super, car aprs un Pexec, on se
	* retrouve en utilisateur
		clr.l	-(sp)
		GEM	Super
		
		move.l	gemdos_pile(pc),sp
		move	(sp)+,sr

		*-------------*

		movem.l	(sp)+,d1-7/a1-6
		rts
		
		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		* installation de CECILE.SYS
		* le Gemdos est dj disponible !
		cnop	0,16
INIT_CECILE
		movem.l	d1-d7/a1-a6,-(sp)
		
	*--------------*
	* prends toute la chip-ram
		clr	-(sp)
		pea	-1.w
		GEM	Mxalloc
		
		clr	-(sp)
		move.l	d0,-(sp)
		GEM	Mxalloc
		move.l	d0,a3
		move.l	d0,a4
		
	* copie ccile en chip
		move.l	d0,a0
		move.l	cecile_ptr(a6),a1
		move.l	cecile_len(a6),d0
		lsr.l	#4,d0
.copie_cci
		rept	4
		move.l	(a1)+,(a0)+
		endr
		dbra	d0,.copie_cci
		
	*--------------*
	* mise  jour de ccile

	* ogem: folder,dat,fat
		move.l	a4,a0
		add	_sys_ogem(a4),a0
		
		move	cci_folder(a6),_sys_gfold(a0)
		move	cci_data(a6),_sys_gdat(a0)
		move	cci_fat(a6),_sys_gfat(a0)
		moveq	#0,d0
		move.b	boot_nvm(a6),d0
		move	d0,_sys_gstart(a0)
		
	* ormv: unites amovibles
		move.l	a4,a0
		add	_sys_ormv(a4),a0
		
		move.l	cci_rmunits(a6),(a0)+	;scsi0-3
		move.l	cci_rmunits+4(a6),(a0)+	;scsi4-7
		move	cci_rmunits2(a6),(a0)	;ide0-1

	* osleep: extinction par dfaut: plus de place dans la NVRAM
		move.l	a4,a0
		add	_sys_osleep(a4),a0
		
		moveq	#-1,d0
		moveq	#10-1,d1
.def_sleep
		move	d0,(a0)+
		dbra	d1,.def_sleep
		
	* oscan: ordre de scan
		move.l	a4,a0
		add	_sys_oscan(a4),a0
		
		lea	BootOrder(a6),a1
		
		moveq	#0,d0
		moveq	#-1,d1
.nxt_bootorder
		move.b	(a1)+,d0
		cmp.b	d1,d0
		beq.s	.end_bootorder
		tst.b	d0
		bmi.s	.nxt_bootorder
		move	d0,(a0)+
		bra	.nxt_bootorder
.end_bootorder
		move	#-1,(a0)
		
	* ospec: paramtre ide
		move.l	a4,a0
		add	_sys_ospec(a4),a0
		
			; CMMEDISS
		moveq	#%01100000,d0	;Master mode
		and.b	flags_boot2(a6),d0
		lsr	#5,d0
		move.b	d0,_ata_adr_mode(a0)
		
		moveq	#%00000011,d0	;Slave mode
		and.b	flags_boot2(a6),d0
		move.b	d0,_ata_adr_mode+1(a0)
		
	*-------------*
	* Installe un patch pour le GEMDOS
		move.l	Trap1.w,old_gemdos
		move.l	#GEMDOS_DAVID,Trap1.w

	*--------------*
	* lance ccile.sys
		move.l	#"boot",d7
		jsr	(a3)
		
	*--------------*
	* Enlve le patch de David
		move.l	old_gemdos(pc),trap1.w
		
	*--------------*
	* partition choisie
		moveq	#0,d0
		move.b	boot_nvm(a6),d0
		
		move.l	_drvbits.w,d2
		btst	d0,d2
		bne.s	.ok_part
		moveq	#0,d0
		btst	#2,d2	;=>A par dfaut
		beq.s	.ok_part
		moveq	#2,d0	;=>C par dfaut
.ok_part		
		move	d0,_bootdev.w
		
		moveq	#"A",d1
		add.b	d0,d1
		move.b	d1,boot_letter
		
		move	d0,-(sp)
		GEM	Dsetdrv
		
		lea	boot_done(pc),a0
		jsr	([TextOut,a6])
		
	* recherche d'un Ccile.sys pour la mise  jour du _sys_sleep
		clr	-(sp)
		pea	cci_name(pc)
		GEM	Fopen
		move	d0,d1
		bpl.s	.cecile_found
		
		lea	no_cecile(pc),a0	;pas de ccile.sys
		jsr	([TextOut,a6])
		bra	.dfaut
.cecile_found
	* version compatible
		clr	-(sp)
		move	d1,-(sp)
		moveq	#_sys_ver,d2
		move.l	d2,-(sp)
		GEM	Fseek
		
		lea	-2(sp),sp		;pour lire le numro de
					;version
		pea	(sp)		;pointeur sur le buffer
		pea	2.w		;1 word  lire
		move	d1,-(sp)
		GEM	Fread
		move	(sp)+,d0		;version=>d0
		cmp	#ceci_valid,d0	;version minimum
		bhs.s	.ok_version
		
		lea	bad_version(pc),a0	;mauvaise version
		jsr	([TextOut,a6])
		bra	.close
.ok_version
		lea	good_version(pc),a0	;tout va bien
		jsr	([TextOut,a6])

	* osleep
		clr	-(sp)
		move	d1,-(sp)
		moveq	#_sys_osleep,d2
					;pour pointer sur l'offset
					;et effacer le poids fort du
					;long
		move.l	d2,-(sp)
		GEM	Fseek
		
		lea	-2(sp),sp		;pour lire l'offset
					;d'osleep
		pea	(sp)		;pointeur sur le buffer
		pea	2.w		;1 word  lire
		move	d1,-(sp)
		GEM	Fread
		move	(sp)+,d2		;l'offset=>d2
		
		clr	-(sp)
		move	d1,-(sp)
		move.l	d2,-(sp)		;on y va
		GEM	Fseek

		move.l	a4,a0
		add	_sys_osleep(a4),a0
		pea	(a0)
		pea	10*2.w		;8 SCSI + 2 IDE
		move	d1,-(sp)
		GEM	Fread

	* ospec: protocole IDE
		clr	-(sp)
		move	d1,-(sp)
		moveq	#_sys_ospec,d2
					;pour pointer sur l'offset
					;et effacer le poids fort du
					;long
		move.l	d2,-(sp)
		GEM	Fseek
		
		lea	-2(sp),sp		;pour lire l'offset
					;d'ospec
		pea	(sp)		;pointeur sur le buffer
		pea	2.w		;1 word  lire
		move	d1,-(sp)
		GEM	Fread
		move	(sp)+,d2		;l'offset=>d2
		
		clr	-(sp)
		move	d1,-(sp)
		move.l	d2,-(sp)		;on y va
		GEM	Fseek
	
		move.l	a4,a0
		add	_sys_ospec(a4),a0
		pea	(a0)
		pea	_ata_length.w		
		move	d1,-(sp)
		GEM	Fread
		
	* fini avec Ccile.sys
.close
		move	d1,-(sp)
		GEM	Fclose
		
		*------------*
.dfaut
		moveq	#0,d0		;boot ok
		
		movem.l	(sp)+,d1-d7/a1-a6
		rts

		*-------------*
		* dtourne la sortie texte de CECILE.SYS
		
old_gemdos	dc.l	0
		dc.b	"GEMDOS pour David"
		cnop	0,16
GEMDOS_DAVID
		move.l	usp,a0
		btst.b	#5,(sp)
		beq.s	.ok_sp
		lea	8(sp),a0
.ok_sp
		move	(a0)+,d0
		cmp	#9,d0
		bne.s	.old
		
		move.l	a6,-(sp)
		
		move.l	(a0),a0
		lea	fast_dol_start+dol_vars,a6
		jsr	([TextOut.w,a6])
		
		move.l	(sp)+,a6
		rte
.old
		jmp	([old_gemdos.w,pc])
		
		*-------------*

*-------------------------------------------------------------------------*

		*------------*
		* On y vient si le lecteur est dclar.
		* excute le boot d'une disquette si on est devant le dur.
		cnop	0,16
BootFloppy
		movem.l	d1-d7/a1-a6,-(sp)
		
		*------------*

		btst	#0,flags_boot(a6)
		bne.s	.ok_floppy
	
	* recherche d'un boot	
		lea	floppy_clr(pc),a0
		bsr	aff_txt
		lea	floppy_txt(pc),a0
		bsr	aff_txt

		move.l	hdv_boot.w,a0	;hdv_boot (1seul fois)
		jsr	(a0)	;repre le(s) lecteur(s) de disquettes
				;d0=0: boot disquette charg et
				;excutable
				;d0=1: pas de disquette
				;d0=4: disquette mais pas bootable
		tst	d0
		bne.s	.no_boot

	* boot trouv et excutable
		lea	bootfloppy_txt(pc),a0
		bsr	aff_txt

		move.l	_dskbufp.w,a0       ;le boot a t charg l
		jsr	(a0)	;=>saute dans le boot de la disquette
.fin
		movem.l	(sp)+,d1-d7/a1-a6
		rts
	* pas boot trouv		
.no_boot
		cmp	#1,d0
		beq.s	.bad_floppy

	* mais le lecteur existe physiquement
		lea	noboot_txt(pc),a0
		bsr	aff_txt
.ok_floppy
		move	#1,_nflops.w
		moveq	#~%11,d0
		and	_drvbits+2.w,d0
		or	#%01,d0
		move	d0,_drvbits+2.w
		bra.s	.fin

	* le lecteur est absent
.bad_floppy
		clr	_nflops.w
		and	#~%11,_drvbits+2.w
		
		lea	nofloppy_txt(pc),a0
		bsr	aff_txt

		move	#con_dev,-(sp)
		BIOS	Bconin

		bset	#6,flags_boot(a6)	;=>dsactive le lecteur pour
					;les boot  chaud suivant	
		bra.s	.fin

		*------------*

*-------------------------------------------------------------------------*

		*------------*
		* Valide les variables du floppy
		cnop	0,16
ValidFloppy
		btst	#6,flags_boot(a6)
		bne.s	.bad_floppy

	* y a un lecteur
.ok_floppy
		move	#1,_nflops.w
		moveq	#~%11,d0
		and	_drvbits+2.w,d0
		or	#%01,d0
		move	d0,_drvbits+2.w
		bra.s	.fin

	* le lecteur est absent
.bad_floppy
		clr	_nflops.w
		and	#~%11,_drvbits+2.w
		
		*------------*
.fin
		rts
		
		*------------*

*-------------------------------------------------------------------------*
		DATA
*-------------------------------------------------------------------------*

		*-------------*
		* nom du driver sur la partition de boot

cci_name		dc.b	"CECILE.SYS",0
		even

		*------------*
	IFEQ	langue
good_version	dc.b	13,10,"  Informations dans CECILE.SYS trouves...",13,10,0
		even
bad_version	dc.b	13,10,"  Version ancienne de CECILE.SYS !!!",13,10,0
		even
no_cecile		dc.b	13,10,"  CECILE.SYS n'a pas t trouv !",13,10,0
		even

boot_done		dc.b	13,10,"  => Dmarrage sur le lecteur "
boot_letter	dc.b	"x",13,10,10,0
		even
	ENDC

	IFEQ	langue-1
good_version	dc.b	13,10,"  Informations in CECILE.SYS found...",13,10,0
		even
bad_version	dc.b	13,10,"  Old version of CECILE.SYS !!!",13,10,0
		even
no_cecile		dc.b	13,10,"  CECILE.SYS not found !",13,10,0
		even

boot_done		dc.b	13,10,"  => Boot on drive "
boot_letter	dc.b	"x",13,10,10,0
		even
	ENDC

	IFEQ	langue-2
good_version	dc.b	13,10,"  Informationen in CECILE.SYS gefunden...",13,10,0
		even
bad_version	dc.b	13,10,"  Veraltete Version der Datei CECILE.SYS!",13,10,0
		even
no_cecile		dc.b	13,10,"  CECILE.SYS nicht gefunden!",13,10,0
		even

boot_done		dc.b	13,10,"  => Boot von drive "
boot_letter	dc.b	"x",13,10,10,0
		even
	ENDC
		*------------*

floppy_clr	dc.b	27,'E',0
		even

	IFEQ	langue
floppy_txt	dc.b	" ",27,"p"," Recherche d'un boot sur une disquette... ",27,"q",13,10,0
		even

noboot_txt	dc.b	13,10," Pas de Boot trouv!",13,10,10,0
		even

nofloppy_txt	dc.b	13,10," Pas de lecteur ?! Dsactivez le dans le setup...",13,10
		dc.b	10
		dc.b	"   Frappez une touche...",0
		even

bootfloppy_txt	dc.b	13,10," Boot trouv...",13,10,10,0
		even
	ENDC
	IFEQ	langue-1
floppy_txt	dc.b	" ",27,"p"," Search bootable on floppy... ",27,"q",13,10,0
		even

noboot_txt	dc.b	13,10," No boot found!",13,10,10,0
		even

nofloppy_txt	dc.b	13,10," No Floppy found ?! Deselect it in the setup...",13,10
		dc.b	10
		dc.b	"   Hit a key...",0
		even

bootfloppy_txt	dc.b	13,10," Boot found...",13,10,10,0
		even
	ENDC
	IFEQ	langue-2
floppy_txt	dc.b	" ",27,"p"," Search bootable on floppy... ",27,"q",13,10,0
		even

noboot_txt	dc.b	13,10," Keine boot gefunden!",13,10,10,0
		even

nofloppy_txt	dc.b	13,10," Keine Diskette gefunden?! Deselect it in the setup...",13,10
		dc.b	10
		dc.b	"   Hit a key...",0
		even

bootfloppy_txt	dc.b	13,10," Boot found...",13,10,10,0
		even
	ENDC

		*-------------*

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*

		*-------------*
		* Basepage de Dolmen

dolmen_basepage	ds.l	1

		*-------------*
		* variables temporaires
		
gemdos_pile	ds.l	1	;pointeur de pile aprs le pexec
				;qui cr le premier process...
		
		*-------------*

*-------------------------------------------------------------------------*

