*-------------------------------------------------------------------------*
*		SOUS-FONCTIONS
*-------------------------------------------------------------------------*
* RTE_ADR
* - ...
*
* RTS_ADR
* - ...
*
* RESET_HARD
* - vecteur par dfaut pour relancer le boot
*
* RES_VECTOR
* - gre le resvector aprs un boot  chaud
*
* VIDEO_PUT
* - met en place la palette bleu

* CLR_RAM
* - efface la chip et fast ram en fonction des mots magiques
*
* ERROR_VEC
* - gre les execptions non utilise par le systme (remplace les bombes)
*
* TEST_RAM
* - test et affiche la ram
*
* WAIT
* - gre la pause de dmarrage
*
* AFF_TXT
* - affiche une chane de texte en utisant le bios ou  la fonction interne
*   suivant que le systme soit lanc.
*
* AFF_NB_HEX
* - convertie un nombre en ascii dans le format hexa (max $ffffffff)
*
* AFF_NB_DEC
* - convertie un nombre en ascii dans le format dcimal (max 65535*10)
* 
* GO_SETUP
* - saute au setup si help a t appuy (on y arrive si une touche a t
*   vu dans le test ram ou wait)
* 
* AUTO_FOLDER
* - met en place la basepage pour excuter l'automanager
*
* AUTO_MANAGER

ver_tsr		equ	$102

* - se charge du dossier auto et des lancements des *.PRG s'y trouvant.
* - la prise de contrle permet de valider ou les *.PRG .
*
*-------------------------------------------------------------------------*

		*-------------*
		cnop	0,16

rte_adr		rte

		*------------*
		cnop	0,16

rts_adr		rts

		*------------*
		cnop	0,16
reset_hard
		move	#$2700,sr

	* fera que la RAM sera efface
		clr.l	memvalid.w
		clr.l	memval2.w
		clr.l	memval3.w
		clr.l	ramvalid.w

		jmp	romtos_addr+rom_jmp

		*------------*

*-------------------------------------------------------------------------*

		*-------------*
		* saute dans le vecteur reset si boot  chaud
		cnop	0,16
RES_VECTOR
		btst	#6,$ffff8007.w
		beq.s	.pas_resvec

		cmp.l	#magic_mval,memvalid.w
		bne.s	.pas_resvec

		clr.b	$ffff8001.w	;un vestige du ST!
.ResVec_return
		cmp.l	#magic_resval,resvalid.w
		bne.s	.pas_resvec
		move.l	resvector.w,d0
		btst	#0,D0		;pas d'adresse impaire?!
		bne.s	.pas_resvec
		movea.l	d0,a0
		lea	.ResVec_return(pc),a6

		jmp	(a0)		;=>reset_vector
.pas_resvec
		*-------------*
		
		rts
		
		*-------------*
		
*-------------------------------------------------------------------------*

		*-------------*
		* cran bleu
		cnop	0,16
VIDEO_PUT
		move.l	d1,-(sp)
	* palette
		move	([VideoVars,a6],scrn_p),d1
		cmp	#1,d1
		beq.s	.fin_video
		
		lea	$ffff9800.w,a0
		moveq	#16-1,d0
		cmp.b	#"A",ct2_ok(a6)
		bne.s	.pas_col_a
		move.l	#$000000a4,d1	;bleu_f (rev a)
		bra.s	.clr_pal
.pas_col_a
		move.l	#$00600060,d1	;cian_f (rev b)
.clr_pal
		move.l	d1,(a0)+
		dbra	d0,.clr_pal
.fin_video
		
		*-------------*

		move.l	(sp)+,d1
		rts
		
		*-------------*

*-------------------------------------------------------------------------*

		*-------------*
		* Efface la RAM li  son mot magique valide
		* Effacement par paquets de 256 octets minors
		cnop	0,16
CLR_RAM
		movem.l	d1-7/a1,-(sp)
		
		*-------------*
		
		sf	ram_clr(a6)

		bset	#6,$ffff8007.w
		seq	ram_clr(a6)

	* rinitialise la ram: reset  froid
cold_start
		moveq	#0,d1
		move.l	d1,d2
		move.l	d1,d3
		move.l	d1,d4
		move.l	d1,d5
		move.l	d1,d6
		move.l	d1,d7
		move.l	d1,a1

	* efface la fast-ram
.fast_clr
		cmp.l	#magic_rval,ramvalid.w
		beq.s	.no_fast

		move.l	fast_top(a6),d0
		beq.s	.no_fast
		move.l	d0,a0
		sub.l	fast_bot(a6),d0	;a commence en fast_bot
		bmi.s	.no_fast
		lsr.l	#8,d0		;par paquets de 256 octets
.clr_fast
		rept	8
		movem.l	d1-7/a1,-(a0)
		endr
		subq.l	#1,d0
		bne.s	.clr_fast
.no_fast
	* efface la chip-ram
		
		cmpi.l	#magic_mval,memvalid.w
		bne.s	.chip_clr

		tst.b	ram_clr(a6)
		beq.s	.clr_chip_end
.chip_clr
		st	ram_clr(a6)	;CHIP-RAM effac

		move.l	chip_top(a6),a0
		move.l	a0,d0
		sub.l	#$300,d0		;du haut jusqu' $300
					;(comme le TOS!)
		lsr.l	#8,d0	;par paquets de 256 octets
.clr_chip
		rept	8
		movem.l	d1-7/a1,-(a0)
		endr
		subq.l	#1,d0
		bne.s	.clr_chip
.clr_chip_end
		*-------------*
		* variables systmes
.update_sysvars
		move.l	chip_top(a6),phystop.w
		move.l	#magic_mval,memvalid.w
		move.l	#magic_mval2,memval2.w
		move.l	#magic_mval3,memval3.w

		move.l	fast_top(a6),ramtop.w
		move.l	#magic_rval,ramvalid.w

		*-------------*
		
		movem.l	(sp)+,d1-7/a1
		rts
		
		*-------------*

*-------------------------------------------------------------------------*

		*------------*
		cnop	0,16
ErrorVec
		move	#$2700,sr		;pour tre peinard

		*------------*

		movem.l	d0-a7,$384.w	;proc_dregs.w
		move.l	2(sp),$3c4.w	;proc_enum.w (pc.24bits)

		move	6(sp),d7
		and	#$fff,d7
		lsr	#2,d7
		move.b	d7,$3c4.w		;(num vecteur
					;8bits poids fort)
		move.l	usp,a0
		move.l	a0,$3c8.w

		moveq	#16-1,d0
		lea	$3cc.w,a0       ;16 mots de la pile
		movea.l	sp,a1		;on se demande  quoi
					;a sert ?!
.copie_pile
		move	(a1)+,(a0)+
		dbra	d0,.copie_pile

		move.l	#$12345678,$380.w	;valide la
					;page de crash.
	* Texte en rouge sur fond noir
		tst.b	$ffff8260.w
		beq.s	.falc_pal
		
		* Palette ST 4 couleurs: je m'occupe pas de la ST-Basse
		move	$ffff8240.w,d5
		clr	$ffff8240.w		;noir
		move	$ffff8240+3*2.w,d6
		move	#$f00,$ffff8240+3*2.w	;rouge

		bra.s	.st_pal		
		* Palette Falcon: on gre le mono,16 et 256 couleurs
		* on fait rien en TC.
.falc_pal
		move	$ffff8266.w,d0
		btst	#10,d0
		beq.s	.pas_mono
		lea	$ffff9804.w,a5
		bra.s	.falc_pal2
.pas_mono
		btst	#8,d0
		bne.s	.st_pal		;pas en TC
		btst	#4,d0
		beq.s	.pas_256
		lea	$ffff9800+255*4.w,a5
		bra.s	.falc_pal2
.pas_256
		lea	$ffff9800+15*4.w,a5
.falc_pal2
		move.l	$ffff9800.w,d5
		clr.l	$ffff9800.w	;noir
		move.l	(a5),d6
		move.l	#$ff000000,(a5)	;rouge
.st_pal
	* message vers l'utilisateur
		lea	mess_err_val(pc),a0
		move	d7,d0
		moveq	#2-1,d1	;2 chiffres

		bsr	aff_nb_hex
		
		lea	fast_dol_start+dol_vars,a6

		lea	mess_err(pc),a0
		bsr	aff_txt
		
	ifne	vec_err
		cmp	#$2,d7
		blo.s	.bad
		cmp	#$18,d7
		bhi.s	.bad

		move.l	(table_cpu-2*4.w,pc,d7*4),a0
		bsr	aff_txt
.bad
	endc
		lea	mess_err_end(pc),a0
		bsr	aff_txt

	* attente pour qu'il est temps de lire le message

		lea	$fffffc00.w,a0
.wait_down
		move.b	(a0),d0
		btst	#7,d0	;int acia
		beq.s	.wait_down
		btst	#0,d0	;car reu?
		beq.s	.wait_down

		move.b	2(a0),d0	;on vide le buffer
		bmi.s	.wait_down	;touche qui remonte

		move.b	d0,d1
		
		cmp.b	#1,d0
		beq.s	.wait_up
		
		cmp.b	#$62,d0
		beq.s	.wait_up
		
		cmp.b	#$39,d0
		bne.s	.wait_down		;pas espace donc on
						;attends une autre
						;touche
		* on attends la remonte de la touche
.wait_up
		move.b	(a0),d0
		btst	#7,d0	;int acia
		beq.s	.wait_up
		btst	#0,d0	;car reu?
		beq.s	.wait_up

		move.b	2(a0),d0	;touche remonte
		bpl.s	.wait_up	;non!
		
		and.b	#$7f,d0
		cmp.b	d0,d1	;bonne touche remonte
		bne.s	.wait_down	;non
		
		cmp.b	#1,d0
		beq.s	.reset
		
		cmp.b	#$62,d0
		beq.s	.setup
		
		cmp.b	#$39,d0
		bne.s	.wait_down		;pas espace donc on
						;attends une autre
						;touche
	* On quitte le programme courant en restaurant les couleurs
		tst.b	$ffff8260.w
		beq.s	.falc_pal3
		
		* Palette ST 4 couleurs: je m'occupe pas de la ST-Basse
		move	d5,$ffff8240.w
		move	d6,$ffff8240+3*2.w

		bra.s	.st_pal2
		* Palette Falcon: on gre le mono,16 et 256 couleurs
		* on fait rien en TC.
.falc_pal3
		move.l	d5,$ffff9800.w
		move.l	d6,(a5)
.st_pal2
		* on quitte le programme en cours et
		* on rinitialise la zone de sauvegarde du bios
.fin
		tst.b	System_run(a6)
		beq.s	.reset
		
		move.l	#$93a,$4a2.w
		move	#-1,-(sp)		;erreur gnrale
		GEM	Pterm
	
		bra.s	.reset
.setup
		st	open_setup(a6)
.reset
		jmp	romtos_addr+rom_jmp

		*------------*

*-------------------------------------------------------------------------*

		*------------*
		cnop	0,16
test_ram
		movem.l	d0-a5,-(sp)
		
		*------------*
		* CHIP
		
		lea	Chip_txt(pc),a0
		jsr	([TextOut,a6])
				
		tst.b	ram_clr(a6)
		beq.s	.chip_clr
		
		lea	BusError.w,a5	;le dbut
		move.l	phystop.w,d5	;la fin
		move.l	#$aaaaaaaa,d6	;masque
		move.l	#$55555555,d2	;masque2
		moveq	#0,d4
		move.l	d4,d3
		
		bsr	.ram_test
.chip_clr		
		move.l	phystop.w,d0
		
		bsr	.ram_available

		*------------*
		* FAST
		
		lea	Fast_txt(pc),a0
		jsr	([TextOut,a6])

		tst.b	ram_clr(a6)
		beq.s	.fast_clr
		
		move.l	fast_bot(a6),a5	;le dbut
		move.l	ramtop.w,d5	;la fin
		move.l	#$aaaaaaaa,d6	;masque
		move.l	#$55555555,d2	;masque2
		moveq	#0,d4
		move.l	#fast_dol_start,d3	;pour afficher la ram dispo
					;et non l'adresse
		bsr	.ram_test
.fast_clr
		move.l	ramtop.w,d0	;la fin
		sub.l	#fast_dol_start,d0
		
		bsr	.ram_available

		*------------*
		
		movem.l	(sp)+,d0-a5
		rts
	
		*------------*
		cnop	0,16
.ram_test
		move.l	a5,d0
		sub.l	d3,d0
		
		moveq	#8+6,d1
		lsr.l	d1,d0	;/16 Ko
		cmp.l	d0,d4
		beq.s	.pas_aff

	* affiche tout les Ko
		move.l	d0,d4
		lsl.l	#4,d0	;*16 = affichage en Ko
		moveq	#5-1,d1
		lea	addr_nb(pc),a0
		bsr	aff_nb_dec
		
		lea	addr_txt(pc),a0
		jsr	([TextOut,a6])
		
		jsr	([Constat,a6])
		tst	d0
		bne.s	.fin
.pas_aff
		move.l	(a5),d7
		move.l	d6,(a5)
		cmp.l	(a5),d6
		bne.s	.error
		
		move.l	d2,(a5)
		cmp.l	(a5),d2
		beq.s	.ok
	
	* message d'erreur et on saute une ligne
.error
		move.l	a5,d0
		moveq	#8-1,d1
		lea	ram_adr(pc),a0
		bsr	aff_nb_hex
		
		lea	error_ram(pc),a0
		jsr	([TextOut,a6])
.ok
		move.l	d7,(a5)+
		cmp.l	a5,d5
		bne.s	.ram_test

		*------------*
.fin		
		rts
		
		*------------*

	* affiche la ram dispo
.ram_available
		moveq	#8+2,d1
		lsr.l	d1,d0	;/1Ko
		moveq	#5-1,d1
		lea	addr_nb(pc),a0
		bsr	aff_nb_dec
		
		lea	addr_txt(pc),a0
		jsr	([TextOut,a6])
		
		lea	ram_done(pc),a0
		jsr	([TextOut,a6])
		
		*------------*

		rts
				
		*------------*

*-------------------------------------------------------------------------*

		*------------*
		* pause au dmarrage de 0  79s
		*  partir de l'affichage du test
		cnop	0,16
wait
		movem.l	d0-a5,-(sp)
		
		*------------*
		
		lea	wait_txt(pc),a0
		jsr	([TextOut,a6])

		*------------*
		
		move.l	_hz_200.w,d7

		tst.b	ram_clr(a6)
		beq.s	.go
		
		moveq	#0,d6
		move.b	pause(a6),d6
		mulu	#200,d6
		
		add.l	d6,d7
.go
		add.l	#100,d7	;0.5s mini
.decompte
		move.l	_hz_200.w,d6

		cmp.l	d6,d7
		bls.s	.fin

		move.l	d7,d0
		sub.l	d6,d0
		divu.l	#200,d0
		moveq	#2-1,d1
		lea	time_nb(pc),a0
		bsr	aff_nb_dec

		lea	time(pc),a0
		jsr	([TextOut,a6])

		add.l	#200,d6	;prochaine seconde
.wait
		jsr	([Constat,a6])
		tst	d0
		bne.s	.fin

		cmp.l	_hz_200.w,d6
		bhi.s	.wait

		bra	.decompte

		*------------*
.fin
		movem.l	(sp)+,d0-a5
		rts

		*------------*

*-------------------------------------------------------------------------*

		*-------------*
		* A0: pointe sur la chaine
		* routine d'affichage du text
		* d0 et a0 modifi (BIOS...)
		cnop	0,16
aff_txt
		movem.l	d1-2/a1-2/a6,-(sp)
		
		lea	fast_dol_start+dol_vars,a6
		tst.b	system_run(a6)
		bne.s	.bios
.no_bios
		jsr	([TextOut.w,a6])
		bra.s	.fin
.bios
		move.l	a0,a6
.aff
		moveq	#0,d0
		move.b	(a6)+,d0
		beq	.fin

		move	d0,-(sp)
		move	#2,-(sp)
		BIOS	Bconout

		bra	.aff
.fin
		movem.l	(sp)+,d1-2/a1-2/a6
		rts

		*-------------*

*-------------------------------------------------------------------------*

		*------------*
		* A0: pointe  la fin de la chane
		* D0.L: valeurs  convertir en hexa
		* D1.W: nombre de chiffres
		* d0 et a0 modifis
		cnop	0,16
aff_nb_hex
		movem.l	d1-2,-(sp)
		
		move.l	d0,d2
.nxt_car
		move.l	d2,d0
		and	#$f,d0
		cmp.b	#$a,d0
		bhs.s	.hex
		add.b	#"0",d0
		bra.s	.wr
.hex
		add.b	#"A"-10,d0
.wr
		move.b	d0,-(a0)
		lsr.l	#4,d2
		dbra	d1,.nxt_car
.mess
		movem.l	(sp)+,d1-2
		rts

		*------------*

*-------------------------------------------------------------------------*

		*------------*
		* A0: pointe  la fin de la chane
		* D0.L: valeurs  convertir en dec (MAX:65535*10)
		* D1.W: nombre de chiffres-1
		* d0 et a0 modifis
		cnop	0,16
aff_nb_dec
		movem.l	d1-2,-(sp)
		
		moveq	#10,d2
.nxt
		divu	d2,d0
		swap	d0

		add.b	#"0",d0
		move.b	d0,-(a0)
		clr	d0
		swap	d0
		dbra	d1,.nxt

		movem.l	(sp)+,d1-2
		rts

		*------------*

*-------------------------------------------------------------------------*

		*--------------*
		* Veut-on rentrer dans le setup
		* recherche pendant 0.5s
		cnop	0,16
Go_setup
		moveq	#100,d7
		add.l	_hz_200.w,d7
.encore
		jsr	([Constat.w,a6])
		tst	d0
		bne.s	.oui
		cmp.l	_hz_200.w,d7
		bhi	.encore
		bra.s	.non
.oui
		jsr	([Conin.w,a6])
		
		cmp.b	#$62,d0
		bne.s	.non

		st	open_setup(a6)
		jmp	romtos_addr+rom_jmp
.non
		*--------------*

		rts

		*--------------*

*-------------------------------------------------------------------------*

		*------------*
		*  Lance l'AUTO MANAGER
		cnop	0,16
AUTO_FOLDER
		movem.l	d1-7/a0-6,-(sp)
	
	*--------------*
	* valide le flag dans le cookie "_TSR"
		move.l	#-1,-(sp)
		move.l	#"_TSR",-(sp)
		XBIOS	PutCookie

	*--------------*
	* contrle du droulement
	* d7=1 : prise de contrle
	* d7=0 : redirection
	* d7=-1 : reprise du droulement sans contrle et
	*         sans redirection. S'arrte  la fin quand mme!
		moveq	#1,d7
		move	#-1,-(sp)
		BIOS	Kbshift
		btst	#2,d0	;control
		bne.s	.no_redirect
		
		moveq	#0,d7
		clr	-(sp)
		pea	bootlog(pc)
		GEM	Fcreate
		move	d0,d6
		
		move	#1,-(sp)
		GEM	Fdup
		move	d0,d5
		
		move	d6,-(sp)
		move	#1,-(sp)
		GEM	Fforce
.no_redirect
	*--------------*
	* prsentation
		pea	coucou(pc)
		GEM	Cconws

		;lea	auto_txt(pc),a0
		;bsr	aff_txt

	*--------------*
	* Premier fichier *.PRG du dossier AUTO
		;move	#%111,-(sp)	;accs normal+protg en criture
					;+cach
		clr	-(sp)
		pea	TSR_PATH(pc)
		GEM	FsFirst
		tst	d0
		bmi	.error
.next
	* chemin+nom
		lea	TSR_PATH(pc),a0
		lea	TSR_MASK(pc),a2
		lea	tsr_found(pc),a1
.copie_path
		move.b	(a0)+,(a1)+	;chemin
		cmp.l	a0,a2
		bne.s	.copie_path

		lea	dta+30(pc),a0	;nom en dta
.copie_name
		move.b	(a0)+,(a1)+	;nom
		bne.s	.copie_name

	*--------------*
	* contrleur
		tst.b	d7
		ble.s	.run
		
		lea	auto_name(pc),a0
		bsr	aff_txt
		
		lea	dta+30(pc),a0
		bsr	aff_txt
		
		lea	auto_cont(pc),a0
		bsr	aff_txt
.scan
		move	#con_dev,-(sp)
		BIOS	Bconin
		
		cmp	#" ",d0
		bne.s	.pas_space
		
		moveq	#-1,d7
		lea	auto_run_all(pc),a0
		bsr	aff_txt
		
		bra.s	.run
.pas_space
		cmp	#13,d0
		bne.s	.not_enter
		
		lea	auto_run(pc),a0
		bsr	aff_txt
		
		bra.s	.run
.not_enter
		cmp	#27,d0
		bne.s	.pas_esc
		
		lea	auto_quit(pc),a0
		bsr	aff_txt
		
		bra.s	.fin_control
.pas_esc
		tst	d0
		bne.s	.scan
		swap	d0
		cmp.b	#$61,d0
		bne.s	.scan
		
		lea	auto_skip(pc),a0
		bsr	aff_txt
		
		bra.s	.skip

	*--------------*
	* lance le programme trouv
.run
		pea	auto_env(pc)
		pea	string_null(pc)
		pea	tsr_found(pc)
		clr	-(sp)		;mode normal
		GEM	Pexec

	* programme suivant
.skip
		GEM	FsNext
		tst	d0
		beq	.next
	* fini
		tst.b	d7
		beq.s	.quit
		
		pea	auto_fin(pc)
		GEM	Cconws
		
		move	#con_dev,-(sp)
		BIOS	Bconin
		bra.s	.fin_control
.quit
	* ferme le fichier de sortie
		move	d5,-(sp)
		move	#1,-(sp)
		GEM	Fforce

		move	d6,-(sp)
		GEM	Fclose
.fin_control
	*--------------*
	* on retourne au droulement du boot
		moveq	#0,d0
.fin
	*--------------*
	* dvalide le flag dans le cookie "_TSR"
		clr.l	-(sp)
		move.l	#"_TSR",-(sp)
		XBIOS	PutCookie

		*------------*
		
		movem.l	(sp)+,d1-7/a0-6
		rts     			

		*------------*
.error
		pea	auto_error(pc)
		GEM	Cconws
		GEM	Crawcin
		
		bra	.fin
		
		*------------*

*-------------------------------------------------------------------------*
		DATA
*-------------------------------------------------------------------------*
		
		*------------*

	IFEQ	langue
		cnop	0,16
mess_err		dc.b	27,"H",27
		dc.b	" Panique!!! Dfaillance du programme!",27,"K",13,10
		dc.b	"  Exception n$00"
mess_err_val	dC.b	0
		even

		;insertion du message en clair

mess_err_end	dc.b	" s'est produite.",27,"K",13,10
		dc.b	27,"K",13,10
		dc.b	"  [ESC  ]  Rinitialiser le systme!",27,"K",13,10
		dc.b	"  [HELP ]  Rinitialiser le systme et entrer dans le menu",27,"K",13,10
		dc.b	"  [SPACE]  Finir le programme en cours...",27,"K",13,10
		dc.b	27,"K",0
		even
	ENDC

	IFEQ	langue-1
mess_err		dc.b	27,"H"
		dc.b	" Panic!!! Program Failure!",27,"K",13,10
		dc.b	"  Exception #$00"
mess_err_val	dc.b	0
		even

		;insertion du message en clair

mess_err_end	dc.b	" has occured.",27,"K",13,10
		dc.b	27,"K",13,10
		dc.b	"  [ESC  ]  Reset system!",27,"K",13,10
		dc.b	"  [HELP ]  Reset system and enter Setup",27,"K",13,10
		dc.b	"  [SPACE]  Terminate the current program...",27,"K",13,10
		dc.b	27,"K",0
		even
	ENDC
	IFEQ	langue-2
mess_err		dc.b	27,"H"
		dc.b	" Panik!!! Programmabsturz!",27,"K",13,10
		dc.b	"  Exception #$00"
mess_err_val	dc.b	0
		even

		;insertion du message en clair

mess_err_end	dc.b	" wurde ausgelst.",27,"K",13,10
		dc.b	27,"K",13,10
		dc.b	"  [ESC  ]  Systemreset!",27,"K",13,10
		dc.b	"  [HELP ]  Systemreset und Setup aufrufen.",27,"K",13,10
		dc.b	"  [SPACE]  Programm terminieren...",27,"K",13,10
		dc.b	27,"K",0
		even
	ENDC

	IFNE	vec_err
table_cpu
		dc.l	txt_buserr	;exception n2!!
		dc.l	txt_odd		;3
		dc.l	txt_illegal	;4
		dc.l	txt_zero		;5
		dc.l	txt_chk		;6
		dc.l	txt_trapcc	;7
		dc.l	txt_priv		;8
		dc.l	txt_trace		;9
		dc.l	txt_dummy		;$a
		dc.l	txt_linef		;$b
		dc.l	txt_dummy		;$c
		dc.l	txt_copro		;$d
		dc.l	txt_format	;$e
		dc.l	txt_unitialized	;$f

		rept	8
		dc.l	txt_dummy		;$10  $17
		endr

		dc.l	txt_spurious	;$18

	
	  IFEQ	langue
txt_dummy		dc.b	" (Cas trange ?!?) ",0
		even

txt_buserr	dc.b	" (Erreur de Bus)",0
		even
txt_odd		dc.b	" (Erreur d'adresse)",0
		even
txt_illegal	dc.b	" (Instruction ILLEGALE)",0
		even
txt_zero		dc.b	" (Division par zro)",0
		even
txt_chk		dc.b	" (Instructions CHK ou CHK2)",0
		even
txt_trapcc	dc.b	" (Instructions cpTRAPcc, TRAPcc ou TRAPv)",0
		even
txt_priv		dc.b	" (Violation de privilge)",0
		even
txt_trace		dc.b	" (Trace)",0
		even
txt_linef		dc.b	" (Emulateur LineF)",0
		even
txt_copro		dc.b	" (Violation de protocole coprocesseur)",0
		even
txt_format	dc.b	" (Erreur de format)",0
		even
txt_unitialized	dc.b	" (Interruption non-initialise)",0
		even
txt_spurious	dc.b	" (Interruption parasite)",0
		even

	  ENDC
	  IFEQ	langue-1
txt_dummy		dc.b	" (Strange case ?!?) ",0
		even

txt_buserr	dc.b	" (Bus error)",0
		even
txt_odd		dc.b	" (Address error)",0
		even
txt_illegal	dc.b	" (ILLEGAL instruction)",0
		even
txt_zero		dc.b	" (Zero divide)",0
		even
txt_chk		dc.b	" (CHK, CHK2 instructions)",0
		even
txt_trapcc	dc.b	" (cpTRAPcc, TRAPcc, TRAPv instructions)",0
		even
txt_priv		dc.b	" (Privilege violation)",0
		even
txt_trace		dc.b	" (Trace)",0
		even
txt_linef		dc.b	" (LineF emulator)",0
		even
txt_copro		dc.b	" (Coprocessor protocol violation)",0
		even
txt_format	dc.b	" (Format error)",0
		even
txt_unitialized	dc.b	" (Unitialized Interrupt)",0
		even
txt_spurious	dc.b	" (Spurious interrupt)",0
		even
	  ENDC
	  IFEQ	langue-2
txt_dummy		dc.b	" (Seltener Fall!) ",0
		even

txt_buserr	dc.b	" (Bus error)",0
		even
txt_odd		dc.b	" (Address error)",0
		even
txt_illegal	dc.b	" (ILLEGAL instruction)",0
		even
txt_zero		dc.b	" (Zero divide)",0
		even
txt_chk		dc.b	" (CHK, CHK2 instructions)",0
		even
txt_trapcc	dc.b	" (cpTRAPcc, TRAPcc, TRAPv instructions)",0
		even
txt_priv		dc.b	" (Privilege violation)",0
		even
txt_trace		dc.b	" (Trace)",0
		even
txt_linef		dc.b	" (LineF emulator)",0
		even
txt_copro		dc.b	" (Coprocessor protocol violation)",0
		even
txt_format	dc.b	" (Format error)",0
		even
txt_unitialized	dc.b	" (Unitialized Interrupt)",0
		even
txt_spurious	dc.b	" (Spurious interrupt)",0
		even
	  ENDC
	ENDC

		*------------*

	IFEQ	langue
chip_txt		dc.b	13,10," "
		dc.b	27,"p"," Teste la Chip-RAM : ",27,"q"
		dc.b	13,10,0
		even

fast_txt		dc.b	13,10," "
		dc.b	27,"p"," Teste la Fast-RAM : ",27,"q"
		dc.b	13,10,0
		even

addr_txt		dc.b	13," 32768"
addr_nb		dc.b	" Ko",0
		even

ram_done		dc.b	" Disponible",13,10,0
		even

error_ram		dc.b	13," ERREUR: $12345678"
ram_adr		dc.b	13,10,0
		even
	ENDC
	IFEQ	langue-1
chip_txt		dc.b	13,10," "
		dc.b	27,"p"," Chip-RAM test : ",27,"q"
		dc.b	13,10,0
		even

fast_txt		dc.b	13,10," "
		dc.b	27,"p"," Fast-RAM test : ",27,"q"
		dc.b	13,10,0
		even

addr_txt		dc.b	13," 32768"
addr_nb		dc.b	" KB",0
		even

ram_done		dc.b	" Available",13,10,0
		even

error_ram		dc.b	13," ERROR: $12345678"
ram_adr		dc.b	13,10,0
		even
	ENDC
	IFEQ	langue-2
chip_txt		dc.b	13,10," "
		dc.b	27,"p"," Chip-RAM test : ",27,"q"
		dc.b	13,10,0
		even

fast_txt		dc.b	13,10," "
		dc.b	27,"p"," Fast-RAM test : ",27,"q"
		dc.b	13,10,0
		even

addr_txt		dc.b	13," 32768"
addr_nb		dc.b	" KB",0
		even

ram_done		dc.b	" verfgbar",13,10,0
		even

error_ram		dc.b	13," ERROR: $12345678"
ram_adr		dc.b	13,10,0
		even
	ENDC

		*------------*

	IFEQ	langue
wait_txt		dc.b	13,10," "
		dc.b	27,"p"," Le systme va dmarrer dans: ",27,"q"
		dc.b	13,10,0
		even

Time		dc.b	13,"  12"
time_nb		dc.b	"s",0
		even

	ENDC
	IFEQ	langue-1
wait_txt		dc.b	13,10," "
		dc.b	27,"p"," System start in: ",27,"q"
		dc.b	13,10,0
		even

Time		dc.b	13,"  12"
time_nb		dc.b	"s",0
		even
	ENDC
	IFEQ	langue-2
wait_txt		dc.b	13,10," "
		dc.b	27,"p"," Systemstart in: ",27,"q"
		dc.b	13,10,0
		even

Time		dc.b	13,"  12"
time_nb		dc.b	"s",0
		even
	ENDC

		*------------*
		cnop	0,16
tos_ver		dc.w	0
tos_vars_off	dc.l	0
tos_vars		dc.l	tos_401
		dc.l	tos_402
		dc.l	0
		dc.l	tos_404

		*------------*

		cnop	0,16
tos_401		dc.l	$e00c72	;VBL
		dc.l	$e00c5c	;HBL
		dc.l	$e00d3e	;trap13
		dc.l	$e00d38	;trap14
		dc.l	$e09480	;LineA

		dc.l	$e00d34	;etvcritic
		dc.l	$e00e18	;ios

		dc.l	$e04738	;hdvinit
		dc.l	$e04c02	;hdvrw
		dc.l	$e047b2	;hdvbpb
		dc.l	$e04a12	;hdvmediach
		dc.l	$e04efa	;hdvboot

		dc.l	$e02438	;prvlsto
		dc.l	$e02392	;prvlst
		dc.l	$e024aa	;prvauxo
		dc.l	$e024c2	;prvaux

		dc.l	$e011ea	;scrdump

		dc.l	$e03cf0	;bellhook
		dc.l	$e038b0	;kclhook

		dc.l	$e01354	;initvars

		dc.l	$e02582	;inithard
		dc.l	$e013e4	;inittimera
		dc.l	$e02522	;writeikbd
		dc.l	$e00868	;prviol
		dc.l	$e1c88e	;initgemdos

		dc.l	$e08b20	;setmode

		dc.l	$e05624	;initdsp

		dc.l	$e064aa	;devconnect
		dc.l	$e0639e	;sdma1
		dc.l	$e061b2	;sdma2

		dc.l	$e01f66	;tstnvram
		dc.l	$e02246	;readtimdat

		dc.l	$e01790	;dmaread

		dc.l	$1f670+2	;acc
		dc.l	$2392c+2	;new1
		dc.l	$4d442	;new2
		dc.l	$39582	;new3
		dc.l	$4d452	;desk1
		dc.l	$41c50	;desk2

		*------------*

tos_402		dc.l	$e00c72	;VBL
		dc.l	$e00c5c	;HBL
		dc.l	$e00d3e	;trap13
		dc.l	$e00d38	;trap14
		dc.l	$e0948a	;LineA

		dc.l	$e00d34	;etvcritic
		dc.l	$e00e18	;ios

		dc.l	$e04738	;hdvinit
		dc.l	$e04c02	;hdvrw
		dc.l	$e047b2	;hdvbpb
		dc.l	$e04a12	;hdvmediach
		dc.l	$e04efa	;hdvboot

		dc.l	$e02438	;prvlsto
		dc.l	$e02392	;prvlst
		dc.l	$e024aa	;prvauxo
		dc.l	$e024c2	;prvaux

		dc.l	$e011ea	;scrdump

		dc.l	$e03cf0	;bellhook
		dc.l	$e038b0	;kclhook

		dc.l	$e01354	;initvars

		dc.l	$e02582	;inithard
		dc.l	$e013e4	;inittimera
		dc.l	$e02522	;writeikbd
		dc.l	$e00868	;prviol
		dc.l	$e1de24	;initgemdos

		dc.l	$e08b20	;setmode

		dc.l	$e05624	;initdsp

		dc.l	$e064aa	;devconnect
		dc.l	$e0639e	;sdma1
		dc.l	$e061b2	;sdma2

		dc.l	$e01f66	;tstnvram
		dc.l	$e02246	;readtimdat

		dc.l	$e01790	;dmaread

		dc.l	$20e96+2	;acc
		dc.l	$25194+2	;new1
		dc.l	$515fa	;new2
		dc.l	$3b366	;new3
		dc.l	$5160a	;desk1
		dc.l	$43a90	;desk2

		*------------*

tos_404		dc.l	$e00cb0	;VBL
		dc.l	$e00c9a	;HBL
		dc.l	$e00d7c	;trap13
		dc.l	$e00d76	;trap14
		dc.l	$e094ea	;LineA

		dc.l	$e00d72	;etvcritic
		dc.l	$e00e56	;ios

		dc.l	$e04792	;hdvinit
		dc.l	$e04c5c	;hdvrw
		dc.l	$e0480c	;hdvbpb
		dc.l	$e04a6c	;hdvmediach
		dc.l	$e04f54	;hdvboot

		dc.l	$e02492	;prvlsto
		dc.l	$e023ec	;prvlst
		dc.l	$e02504	;prvauxo
		dc.l	$e0251c	;prvaux

		dc.l	$e01228	;scrdump

		dc.l	$e03d4a	;bellhook
		dc.l	$e0390a	;kclhook

		dc.l	$e01392	;initvars

		dc.l	$e025dc	;inithard
		dc.l	$e01422	;inittimera
		dc.l	$e0257c	;writeikbd
		dc.l	$e00872	;prviol
		dc.l	$e1de84	;initgemdos

		dc.l	$e08b5c	;setmode

		dc.l	$e0567e	;initdsp

		dc.l	$e06504	;devconnect
		dc.l	$e063f8	;sdma1
		dc.l	$e0620c	;sdma2

		dc.l	$e01fa4	;tstnvram
		dc.l	$e022a0	;readtimdat

		dc.l	$e017ce	;dmaread

		dc.l	$20ef6+2	;acc
		dc.l	$251f4+2	;new1
		dc.l	$5165a	;new2
		dc.l	$3b3c6	;new3
		dc.l	$5166a	;desk1
		dc.l	$43af0	;desk2

		*------------*

TSR_MGR		dc.b	"\DOLMEN.SYS\TSR_MGR.PRG",0
		even
		
;TSR_PATH		dc.b	"\DOLMEN.SYS\TSR\"
TSR_PATH		dc.b	"\AUTO\"
TSR_MASK		dc.b	"*.PRG",0
		even

		*------------*

	IFEQ	langue
;auto_txt		dc.b	" ",27,"p"," LANCEMENT DU GESTIONNAIRE DES TSR... ",27,"q"
;		dc.b	13,10,10,0
;		even

auto_name		dc.b	13,10,27,"J"," ",27,"p"," GESTIONNAIRE DES TSR >>> ",27,"q"," ",0
		even

auto_cont		dc.b	" ",27,"p"," <<< ",27,"q",13,10
		dc.b	"   [ENTER ]  Lance celui-ci",13,10
		dc.b	"   [UNDO  ]  Passe celui-l",13,10
		dc.b	"   [ESPACE]  Lance tout les programmes",13,10
		dc.b	"   [ESC   ]  Quitter le GESTIONNAIRE DES TSR",13,10,10,0
		even
auto_run		dc.b	" Choix: Lanc ...",13,10,10,0
		even
auto_skip		dc.b	" Choix: PASS !",13,10,10,0
		even
auto_run_all	dc.b	" Choix: Lance tout ...",13,10,10,0
		even
auto_quit		dc.b	" Choix: quitte !?",13,10,10,0
		even

auto_fin		dc.b	13,10,27,"J"," ",27,"p"," GESTIONNAIRE DES TSR FINI ",27,"q",13,10
		dc.b	10
		dc.b	"   Frappez une touche...",0
		even

auto_error	dc.b	13,10,27,"J"," ",27,"p"," ATTENTION: LE DOSSIER AUTO EST VIDE OU N'EXISTE PAS ",27,"q",13,10
		dc.b	10
		dc.b	"   Frappez une touche...",0
		even

	ENDC
	IFEQ	langue-1
;auto_txt		dc.b	27,"E"," ",27,"p"," LAUNCHING TSR MANAGER... ",27,"q"
;		dc.b	13,10,10,0
;		even

auto_name		dc.b	13,10,27,"J"," ",27,"p"," TSR MANAGER >>> ",27,"q"," ",0
		even

auto_cont		dc.b	" ",27,"p"," <<< ",27,"q",13,10
		dc.b	"   [ENTER]  Run this one",13,10
		dc.b	"   [UNDO ]  Skip this one",13,10
		dc.b	"   [SPACE]  Run all programs",13,10
		dc.b	"   [ESC  ]  Quit TSR MANAGER",13,10,10,0
		even
auto_run		dc.b	" Choice: Run ...",13,10,10,0
		even
auto_skip		dc.b	" Choice: SKIP !",13,10,10,0
		even
auto_run_all	dc.b	" Choice: Run all ...",13,10,10,0
		even
auto_quit		dc.b	" Choice: quit !?",13,10,10,0
		even

auto_fin		dc.b	13,10,27,"J"," ",27,"p"," END OF TSR MANAGER ",27,"q",13,10
		dc.b	10
		dc.b	"   Hit a key...",0
		even

auto_error	dc.b	13,10,27,"J"," ",27,"p"," WARNING: THE AUTO FOLDER IS EMPTY OR DOESN'T EXIST ",27,"q",13,10
		dc.b	10
		dc.b	"   Hit a key...",0
		even

	ENDC
	IFEQ	langue-2
;auto_txt		dc.b	27,"E"," ",27,"p"," STARTE TSR-MANAGER... ",27,"q"
;		dc.b	13,10,10,0
;		even

auto_name		dc.b	13,10,27,"J"," ",27,"p"," TSR-MANAGER >>> ",27,"q"," ",0
		even

auto_cont		dc.b	" ",27,"p"," <<< ",27,"q",13,10
		dc.b	"   [ENTER]  Dieses Programm starten",13,10
		dc.b	"   [UNDO ]  Dieses Programm berspringen",13,10
		dc.b	"   [SPACE]  Alle Programme starten",13,10
		dc.b	"   [ESC  ]  TSR-Manager beenden",13,10,10,0
		even
auto_run		dc.b	" Wahl: Starten ...",13,10,10,0
		even
auto_skip		dc.b	" Wahl: berspringen !",13,10,10,0
		even
auto_run_all	dc.b	" Wahl: Alle starten ...",13,10,10,0
		even
auto_quit		dc.b	" Wahl: Beenden !?",13,10,10,0
		even

auto_fin		dc.b	13,10,27,"J"," ",27,"p"," END OF TSR MANAGER ",27,"q",13,10
		dc.b	10
		dc.b	"   Hit a key...",0
		even

auto_error	dc.b	13,10,27,"J"," ",27,"p"," WARNING: THE AUTO FOLDER IS EMPTY OR DOESN'T EXIST ",27,"q",13,10
		dc.b	10
		dc.b	"   Hit a key...",0
		even
	ENDC
		*------------*

		* Variable d'environement pour l'environement
auto_env_val	dc.b	"AUTO",0
		even

		* fichier pour toute les sorties textes pendant le boot
bootlog		dc.b	"BOOTLOG.TSR",0
		even
		
		* prsentation du manager
		cnop	0,16
coucou		dc.b	27,"E"
		dc.b	" ***************************",13,10
		dc.b	" *                         *",13,10
		dc.b	" *         DOLMEN         *",13,10
		dc.b	" *       TSR MANAGER       *",13,10
		dc.b	" *        rev: "
		dc.b	((ver_tsr>>8)&$f)+'0','.'
		dc.b	((ver_tsr>>4)&$f)+'0','.'
		dc.b	((ver_tsr>>0)&$f)+'0',"       *",13,10
		dc.b	" *                         *",13,10
		dc.b	" ***************************",13,10
		dc.b	13,10
		dc.b	0
		even

		*------------*

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*

		*------------*

tsr_pile		ds.l	1

auto_env		ds.b	64	;chane d'environement
				;pour le dossier AUTO

tsr_found		ds.b	64

		*------------*
		
*-------------------------------------------------------------------------*
