*----------------------------------------------------------------------------*
*		Modules systme pour la Flash
*
* OPEN_SYS
* - Charge les SYS externes et les lancent.
* - le chemin courant de Dolmen est mis en place
* - le BORIS.SYS est charg en premier
*
* GoPath
* - Installe le chemin courant de Dolmen.
*
* BackPath
* - Restore le chemin courant
*
* load_module
* - charge le fichier donn.
* - alloue un bloc et reloge le programme  1 adresse multiple de 16.
*
*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
OPEN_SYS
		movem.l	d0/a0-1,-(sp)

	* met en place le chemin pour les BSR et SYS
		bsr	GoPath
	
	* chargement de BORIS.SYS
		lea	boris_name(pc),a0
		jsr	load_module
		tst.l	a1
		bpl.s	.ok_boris
		
		lea	no_boris_txt(pc),a0	;ae!!!!!!!
		jsr	([TextOut,a6])
		
		jsr	([Conin.w,a6])
		
		st	open_setup(a6)
		jmp	romtos_addr+rom_jmp	;=>GO SETUP
.ok_boris
		move.l	#install,-(sp)
		jsr	(a0)
		addq.l	#4,sp
			
	* premier driver local
		clr	-(sp)
		pea	SysName(pc)
		GEM	Fsfirst
		tst	d0
		bmi.s	.ya_pas

	* chargement des modules systmes
.ya_encore
		lea	dta+30(pc),a0	;"????????.SYS"
		lea	boris_name(pc),a1
.fin_name
		tst.b	(a1)
		beq.s	.nxt_sys
		cmp.b	(a0)+,(a1)+	;="BORIS.SYS"
		beq.s	.fin_name

		lea	dta+30(pc),a0	;NON
		
		jsr	load_module
		tst.l	a1
		bmi.s	.nxt_sys
		
		move.l	#install,-(sp)
		jsr	(a0)
		addq.l	#4,sp
		
		tst.l	d0		
		bpl.s	.nxt_sys
		pea	(a1)		;erreur sur le module
		GEM	Mfree		;
.nxt_sys
	* suivant
		GEM	Fsnext
		tst	d0
		beq	.ya_encore
.ya_pas
	* restaure le chemin courant
		bsr	BackPath
		
		*-------------*

		movem.l	(sp)+,d0/a0-1
		rts

		*-------------*

*-------------------------------------------------------------------------*
	
		*-------------*
		cnop	0,16
GoPath
		movem.l	d1/a1,-(sp)
		
	*-------------*
	* installe le chemin du systme
		lea	path(pc),a1

	* lecteur de boot
		GEM	Dgetdrv

		move	d0,d1
		add	#"A",d1

		move.b	d1,(a1)+
		move.b	#":",(a1)+

		add	#1,d0
		move	d0,-(sp)
		move.l	a1,-(sp)

	* chemin de boot (normalement la racine)
		GEM	Dgetpath
.suite
		tst.b	(a1)+
		bne	.suite

		move.b	#"\",-1(a1)
		clr.b	(a1)

		move.l	a1,path_fin	;pour le remettre
	
	* dossier systme
		lea	syspath(pc),a0
.copie_sys
		move.b	(a0)+,(a1)+
		bne.s	.copie_sys
				
	* mise en place
		pea	path(pc)
		GEM	Dsetpath
		
		tst	d0
		beq.s	.fin
		
		lea	bad_path_txt(pc),a0
		jsr	([TextOut.w,a6])
		
		jsr	([Conin.w,a6])
		
		st	open_setup(a6)
		jmp	romtos_addr+rom_jmp
		
		*------------*
.fin
		movem.l	(sp)+,d1/a1
		rts
		
		*------------*

*-------------------------------------------------------------------------*
	
		*-------------*
		cnop	0,16
BackPath
	* coupe le chemin du dossier systme
		move.l	path_fin(pc),a0
		clr.b	(a0)
	
	* chemin courant
		pea	path(pc)
		GEM	Dsetpath
		
		*------------*
		
		rts
		
		*------------*

*----------------------------------------------------------------------------*

		*-------------*
		* A0.l: pointeur sur nom du fichier programme ,
		* -> A0.l: contient en retour l'adresse du code executable
		* -> A1.l: contient en retour l'adresse du bloc allou (pour le Mfree)
		*  ( -1 = erreur ! )
		cnop	0,16
load_module
		link	a6,#-clib_local
		movem.l	d0-5,-(sp)

		*-------------*

		clr	-(sp)
		move.l	a0,-(sp)
		GEM	Fopen
		move	d0,clib_handle(a6)
		bmi	.error

		move	#2,-(sp)
		move	clib_handle(a6),-(sp)
		clr.l	-(sp)
		GEM	Fseek
		move.l	d0,clib_flen(a6)

		cmpi.l	#$20,clib_flen(a6)
		blt	.error

		clr	-(sp)
		move	clib_handle(a6),-(sp)
		clr.l	-(sp)
		GEM	Fseek

		pea	clib_header(a6)
		move.l	#28,-(sp)
		move	clib_handle(a6),-(sp)
		GEM	Fread

		cmp	#$601a,clib_header(a6)
		bne	.error

		move.l	clib_text(a6),d0
		add.l	clib_data(a6),d0
		add.l	clib_bss(a6),d0
		add.l	#16,d0
		move.l	d0,clib_blocsize(a6)

		move.l	clib_flen(a6),d1
		cmp.l	d0,d1
		blt	.ok_size
		exg.l	d0,d1
.ok_size		
		move	#3,-(sp)
		move.l	d0,-(sp)
		GEM	Mxalloc
		move.l	d0,clib_bloc(a6)
		moveq	#15,d1
		add.l	d1,d0
		not.l	d1
		and.l	d1,d0
		move.l	d0,clib_exe(a6)
		beq	.error

		move.l	clib_exe(a6),-(sp)
		move.l	#-1,-(sp)
		move	clib_handle(a6),-(sp)
		GEM	Fread

		move	clib_handle(a6),-(sp)
		GEM	Fclose

		*-------------*

		move.l	clib_exe(a6),a0
		move.l	a0,d0
		move.l	a0,a1
		add.l	clib_text(a6),a1
		add.l	clib_data(a6),a1
		move.l	a1,d2
		add.l	clib_symbol(a6),a1
		
		moveq	#0,d1

		add.l	(a1)+,a0
		add.l	d0,(a0)
.again		
		move.b	(a1)+,d1
		beq.s	.makebss
		cmpi	#1,d1
		bne.s	.normal
		lea	254(a0),a0
		bra.s	.again
.normal		
		lea	(a0,d1.w),a0
		add.l	d0,(a0)
		bra.s	.again
.makebss		
		move.l	clib_bss(a6),d0
		beq.s	.bss_end
		move.l	d2,a1
		add.l	d0,a1	; la fin
		moveq	#$3f,d1
		and.l	d0,d1
		lsr.l	#4+2,d0	;/64 octets
		beq.s	.pas_64
		
		moveq	#0,d2
		move.l	d2,d3
		move.l	d2,d4
		move.l	d2,d5
.clr_bss64
		rept	4
		movem.l	d2-5,-(a1)
		endr
		subq.l	#1,d0
		bne.s	.clr_bss64
.pas_64
		moveq	#$f,d0
		and	d1,d0
		lsr	#4,d1
		beq.s	.pas_16
.clr_bss16
		movem.l	d2-5,-(a1)
		subq	#1,d1
		bne.s	.clr_bss16
.pas_16
		tst	d0
		beq.s	.bss_end
.clr_bss1
		move.b	d2,-(a1)
		subq	#1,d0
		bne.s	.clr_bss1
.bss_end
		move.l	clib_blocsize(a6),-(sp)
		move.l	clib_bloc(a6),-(sp)
		clr	-(sp)
		GEM	Mshrink
		
		*-------------*
		
		move.l	clib_exe(a6),a0
		move.l	clib_bloc(a6),a1
		
		*-------------*
.end
		movem.l	(sp)+,d0-5
		unlk	a6
		rts

		*-------------*
.error		
		move	clib_handle(a6),d0
		bmi.s	.no_fclose
		
		move	d0,-(sp)
		GEM	Fclose
.no_fclose
		lea	-1.w,a1
		bra	.end

		*-------------*

*-------------------------------------------------------------------------*
		DATA
*-------------------------------------------------------------------------*

		*-------------*

syspath		dc.b	"DOLMEN.SYS\",0
		even
		
Boris_name	dc.b	"BORIS.SYS",0
		even
		
SysName		dc.b	"*.SYS",0
		even

install		dc.l	Dol_Install

		*-------------*
	IFNE	langue

bad_path_txt	dc.b	13,10," ",27,"p"," SYSTEM LOADING...",27,"q",13,10
		dc.b	13,10," No DOLMEN.SYS folder on this drive !",13,10
		dc.b	13,10," Press a key to return to the Setup",13,10
		dc.b	" and select a new boot partition...",0
		even
		
	ELSE

bad_path_txt	dc.b	13,10," ",27,"p"," CHARGEMENT DU SYSTEME...",27,"q",13,10
		dc.b	13,10," Pas de dossier DOLMEN.SYS sur ce lecteur !",13,10
		dc.b	13,10," Appuyez sur une touche pour revenir au menu",13,10
		dc.b	" et slectionner une nouvelle partition de dmarrage...",0
		even

	ENDC
		*-------------*
	IFNE	langue

no_boris_txt	dc.b	13,10," No BORIS.SYS found on this drive !!!",13,10
		dc.b	13,10," Press a key to return to the Setup",13,10
		dc.b	" and select a new boot partition...",0
		even
		
	ELSE
	
no_boris_txt	dc.b	13,10," Pas de BORIS.SYS trouv sur ce lecteur !!!",27,"q",13,10
		dc.b	13,10," Appuyez sur une touche pour revenir au menu",13,10
		dc.b	" et slectionner une nouvelle partition de dmarrage...",0
		even

	ENDC
		*-------------*

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*

		*-------------*
		* chemin par dfaut

path_fin		ds.l	1	;pointeur sur la fin du chemin

path		ds.b	64	;chemin avec le lecteur

		*-------------*
		
dta		ds.b	44
		
		*-------------*

*-------------------------------------------------------------------------*
