*------------------------------------------------------------------------------*
*		Structures et variables pour la flash
*------------------------------------------------------------------------------*		
		TEXT
*------------------------------------------------------------------------------*		

		*-------------------*
		* options de compilation
		
	ifnd	no_distrib
no_distrib	equ	0	;0=>Dolmen
				;1=>pas Dolmen
	endc

	ifnd	Langue
langue		equ	0	;0: franais
				;1: anglais
				;2: allemand
	endc
		
blit_100		equ	1	;blitter  100% de sa vitesse

		*-------------------*
		* variables globales
		
	* organisation de l'arbre pmmu
		
		RSRESET
pmmu_levela	rs.l	2*2048	;long format early termination*2048-2
				;pointeurs vers 2 tables:
pmmu_levelb1	rs.l	128	;pour la rom (page $e)
pmmu_levelb2	rs.l	128	;dernier mega de la fast en short-format

pmmu_len		equ	24*1024	;taille de l'arbre (18Ko->24Ko)
				;!!! multiple de 8 Ko !!!
pmmu_end		equ	$80000000	;la fin de la map

	* Rom
romtos_addr	equ	$00e00000	;l'adresse de la Rom

romtos_true	equ	$00e80000	;shadow toujours active

romtos_len	equ	$00080000	;taille de la rom

romtos_copy	equ	$80000000-romtos_len-pmmu_len
				;zone o est copi la ROM
				; la fin de la zone se trouve
				;l'arbre pmmu et avant la ROM

	* Chip-Ram
chip_hard_start	equ	$00000000	;dbut de la chip-ram

chip_hard_end	equ	$00e00000	;fin maxi de la Fast Ram (14Mo)
				;$00400000 pour 4Mo

chip_log		equ	$00000000

chip_dol_start	equ	$00000000
chip_dol_fclear	equ	$00000300	;dbut de l'effacement jusqu' la fin
				;de la chip
chip_dol_sclear	equ	$00000600	;dbut des variables  effacer  chaque
				;dmarrage (chaud & froid)
chip_dol_end	equ	$00010000	;fin de la partie rserv  Dolmen
				;le _FRB est derrire si besoin est

	* Fast-Ram
fast_hard_start	equ	$04000000	;adresse hard o se trouve le
				;dbut de la RAM
fast_hard_end	equ	$08000000	;adresse o la FAST-RAM
				;s'arrte

fast_log_start	equ	$01000000	;adresse o se trouvera le
				;dbut de la fast (partie
				;rserv incluse)
	* Dolmen
fast_dol_start	equ	$01000000	;page o se trouve le boot
				;=>criture possible
	* Flash			
flash_addr	equ	$f4000000	;adresse de la Flash
flash_shadow	equ	$f5000000	;il y a une shadows jusqu'en
				;$F6000000 sur CT2a et
				;$F5000000 sur CT2b
				;(buserr aprs)
flash_size	equ	64*1024	;flash de 64 ko
	*Registres CT2
ct2_reg		equ	$f6000000	;adresse du registre de config
				;de la CT2 A&B : y crire 1
				;byte avec les donnes dans
				;les bit 16  23 comme suit
					
f30_boot		equ	$00800000	;bit 23:Valide la sortie sur
				;       le Falcon
dsp_ws		equ	$00400000	;bit 22:met 12  24 cycles de
				;       ws pour l'accs au DSP
ide_ws		equ	$00200000	;bit 21:mode 3/5 pour l'ide
clk_off		equ	$00100000	;bit 20:coupe la clock externe
clk_32		equ	$00080000	;bit 19:valide le 32MHz
				;       externe  la place du
				;       36MHz (REV A)
flh_write		equ	$00040000	;bit 18:valide l'criture sur
				;       la flash (1)
				;bit 8  17: rserv (0)
				
				;bit 0  7: version de la CT2
				;       (pas d'effet sur le
				;       registre mais c'est
				;       stock dans le cookie)

ct2_reg2		equ	$f7000000	;deuxime registre de la ct2b
m64_flag		equ	$00000001 ;bit 0: 1 pour les 64Mo strange
					
*------------------------------------------------------------------------------*		

		*-------------------*
		* structure du header de la Flash
		* compatible avec le header de la Rom
		* il fait normalement 48 octets ($30)

		RSRESET
flsh_hissp	rs.w	1	;Mot de poids fort du pointeur de
				;pile SSP ($000f normalement)
flsh_version	rs.w	1	;numro de version de la flash (et poids
				;faible du pointeur SSP)
flsh_reset	rs.l	1	;pointeur sur le dbut du
				;code de la Flash
flsh_os_start	rs.l	1	;pointeur sur le dbut de la
				;flash
flsh_os_end	rs.l	1	;pointeur sur la fin des
				;datas dans la flash
flsh_shell	rs.l	1	;rserv (pointeur sur un
				;shell ex:
				;"PATH=",0,"C:\",0,0
flsh_magic	rs.l	1	;$CAFEFADE
flsh_date		rs.l	1	;date de la Flash
flsh_pal		rs.w	1	;mise  jour pendant l'install
flsh_sys_date	rs.w	1	;date au format GEMDOS
		
flsh_curhour	rs.l	1	;heure de gravage
flsh_curdate	rs.l	1	;date de gravage
flsh_number	rs.l	1	;nombre de gravage

flsh_sysvars	rs.l	1	;offset sur les variables
				;systmes (Dolmen)
flsh_header	rs.l	0	;offset du header de la Flash

		*-------------------*

*------------------------------------------------------------------------------*		

		*-------------------*
		* structure du header de la Rom (enfin la page $exxxxx)
		* il fait normalement 48 octets ($30)

		RSRESET

rom_hissp		rs.w	1	;branchement vers le dbut du
				;code de la flash
rom_version	rs.w	1	;numro de version
				;$70x: pour TOS 4.0x
				;$71x et +: pour Dolmen
rom_reset		rs.l	1	;pointeur sur le dbut du
				;code de la Rom
rom_os_start	rs.l	1	;pointeur sur le dbut de la
				;rom
rom_os_end	rs.l	1	;pointeur sur la fin des datas
				;dans la CHIP-RAM
rom_shell		rs.l	1	;pointe sur le dbut du code de
				;la Rom
rom_gem_magic	rs.l	1	;pointeur sur une valeur magic
				;$87654321 pour dmarrer le GEM
				;dans la ROM?!
rom_date		rs.l	1	;date de la Rom
rom_pal		rs.w	1	;flag pal
rom_sys_date	rs.w	1	;date au format GEMDOS
	
rom_root		rs.l	1	;TOS	
rom_kbshift	rs.l	1	;TOS
rom_run		rs.l	1	;TOS
rom_ct2reg	rs.l	1	;copie du registre de la ct2
				;aprs le passage dans le setup
rom_header	rs.l	0	;offset du header de la Rom

rom_movesr	rs.l	1	;"move #$2700,sr"
rom_jmp		rs.w	1	;ultra-saut
rom_jmp_val	rs.l	1	;pointeur o l'on saute (setup)

		*-------------------*

*------------------------------------------------------------------------------*		

		*-------------------*
		* structure du header de Dolmen
		* Situ en dol_log

		RSRESET

dol_hissp		rs.w	1	;poids fort de la pile
dol_version	rs.w	1	;numro de version de Dolmen
				;&poids faible de la pile
dol_reset		rs.l	1	;pointeur sur le dbut du
				;code du boot (setup)
dol_os_start	rs.l	1	;pointeur sur le dbut du
				;systme Dolmen
dol_os_end	rs.l	1	;pointeur sur la fin des vars
				;de Dolmen (avant la TPA)
dol_shell		rs.l	1	;rserv....
dol_gem_magic	rs.l	1	;valeur magique $CAFEFADE
dol_date		rs.l	1	;date du systme Dolmen
dol_pal		rs.w	1	;flag langue
dol_sys_date	rs.w	1	;date au format GEMDOS
	
dol_root		rs.l	1	;rserv	
dol_kbshift	rs.l	1	;rserv
dol_run		rs.l	1	;rserv
dol_sysvars	rs.l	1	;offset aux variables DOLMEN
dol_header	rs.l	0	;offset du header

dol_movesr	rs.l	1	;"move #$2700,sr"
dol_bra		rs.w	1	;branchement vers le setup
dol_bra_val	rs.w	1	;offset

		rs.b	16-4-4	;arrondie pour alignement sur 16

dol_vars		rs.l	0	;dbut de la zone des vars systme

		*-------------------*

*------------------------------------------------------------------------------*		

		*-------------------*
		* structure des variables lies  la Flash
		* offset dans le header (dol_sysvars)

		RSRESET
flh_checksum	rs.l	1	;checksum du binaire
				;la valeur doit tre align sur un long
				;sinon on ne peut pas recaculer la checksum
				;32-bit.
flh_checksum_cal	rs.l	1	;checksum calcule par le setup

ct2_val		rs.l	1	;configuration de la CT2=> cookie "_CT2"

flh_version	rs.w	1	;version de la Flash
flh_date		rs.l	1	;date de la Flash
flh_dol_ver	rs.w	1	;version de Dolmen
flh_dol_date	rs.l	1	;date de Dolmen
flh_cecile_ver	rs.w	1	;version du Ccile interne
				;par dfaut version mini.

open_setup	rs.b	1	;commande l'ouverture du setup
ct2_ok		rs.b	1	;on est bien sur une CT2
ram_clr		rs.b	1	;Ram efface aprs un reset?
system_run	rs.b	1	;indique si le systme est lanc

first_boot	rs.b	1	;on vient de booter ou pas	
dolmen_on		rs.b	1	;Dolmen est install

		* configuration RAM
chip_end		rs.l	1	;fin relle de la Chip
chip_top		rs.l	1	;fin systme

fast_start	rs.l	1	;adresse hard sans PMMU
fast_end		rs.l	1	;adresse hard sans PMMU

fast_sys		rs.l	1	;adresse logique o commence la fast
fast_sysend	rs.l	1	;adresse de fin de la Fast-Ram
fast_bot		rs.l	1	;adresse logique o commence la ram
				;systme
fast_top		rs.l	1	;et sa fin

sysvars_len	rs.l	1	;taille des sysvars

		* programmes externes
reloc_ptr		rs.l	1	;sous programme de relocation

		* SETUP
setup_ptr		rs.l	1	;code du setup et du boot initial
setup_len		rs.l	1	;taille du code+data+bss

		* VIDEO
VideoVars		rs.l	1	;pointeur sur params vido
PutPal		rs.l	1	;met en place la palette systme

		* IKBD
Wikbd		rs.l	1	;crit dans le clavier
				;a0: pointeur sur la chaine
				;d0: nb de car-1
				;a0 et d0 modifi
ResetBuf		rs.l	1	;reset le buffer clavier
				;a0 et d0 modifi

		* CONSOLE
Constat		rs.l	1	;caractre en entr dispo?
				;0=>non
				;-1=>oui
				;a0 et d0 modifi

Conin		rs.l	1	;va chercher un caractre
				;=>d0 contient le caractre
				;  + scan et touches mortes
				;a0 et d0 modifi

Conout		rs.l	1	;sort un caractre norme vt52
				;d0: caractre  afficher (ou code)
				;a0 et d0 modifi

Rawout		rs.l	1	;sort un caractre en brute
				;d0: caractre  afficher
				;a0 et d0 modifi

deadkeys		rs.l	1	;pointeur sur les touches mortes

		* SOUS-PROGRAMMES
TextOut		rs.l	1	;affiche une chane de texte en vt52
				;a0: pointe sur la chane termine par 0
				;a0 et d0 modifi
					
ConvHex		rs.l	1	;convertie un nombre en texte hexa
				;d0: valeur sur 32 bits
				;d1: nombre de cars  crer
				;a0: pointeur aprs le dernier car
ConvDec		rs.l	1	;convertie un nombre en texte dec
				;d0: valeur sur 16 bits
				;d1: nombre de cars  crer
				;a0: pointeur aprs le dernier car
		* BOOT DE DOLMEN
dolboot_ptr	rs.l	1	;code du boot de Dolmen
dolboot_len	rs.l	1	;taille du code+data+bss

		* GEMDOS DE DOLMEN
dolgem_ptr	rs.l	1	;binaire du gemdos
dolgem_len	rs.l	1	;taille du binaire

		* CECILE.SYS
cecile_ptr	rs.l	1	;binaire de ccile
cecile_len	rs.l	1	;taille du binaire

		* BOOT DU TOS
tos_ptr		rs.l	1	;code du boot sous TOS
tos_len		rs.l	1	;taille du code+data+bss

		* configuration PMMU
tt0_pmmu		rs.l	1	;pmmu ultime :-)
tt1_pmmu		rs.l	1

tc_pmmu_stop	rs.l	1	;coupe l'arbre PMMU
tc_pmmu_run	rs.l	1	;active l'arbre PMMU

RegCRP		rs.l	1
user_tree		rs.l	1	;arbre user

		* NVRAM
		
		* partie TOS/DOLMEN
nvram_buffer	rs.w	1	;type de boot
		
nvram_valid	rs.b	4	;"_DOL"
		
akp		rs.w	1	;langue/clavier
idt		rs.w	1	;heure&date/sparateur "/"

pause		rs.b	1	;pause
		rs.b	1	;rserv (0)
		rs.w	1	;rserv (0)

nvm_video		rs.w	1	;mode video (Mono VGA/PAL)
arbid		rs.b	1	;arb+id
		rs.b	1	;rserv (0)

		* partie DOLMEN
cci_rmunits2	rs.b	2	

flags_boot	rs.b	1	;xFSDBRWF
				;7,x: rserv (0)
				;6,F: Lecteur de disquette prsent(1)
				;5,S: Enter Setup (0) ou skip (1)
				;4,D: boot sur TOS (0) ou Dolmen (1)
				;3,B: boot TOS 4.0x si boot TOS choisi
				;2,R: test ram ok (1) (0 pas de test)
				;1,W: pause ok (1) ou pas de pause (0)
				;0,F: boot HD avant Floppy (1) ou
				;     floppy avant hd(0)
				
flags_boot2	rs.b	1	;CMMEDISS
				;7,C: Boot comme le TOS(0)ou avec
				;     ccile(1).
				;     Uniquement pour le Boot TOS !
				;6.5, MM: Master IDE mode
				;	0=AUTO
				;	1=CHS
				;	2=LBA
				;	3=rserv
				;4,E: coupe la clock externe
				;3,D: 12/24 WS sur DSP
				;2,I: 3/5 cycle sur l'IDE
				;1.0, SS: Slave IDE mode
				;	0=AUTO
				;	1=CHS
				;	2=LBA
				;	3=rserv

boot_nvm		rs.b	1	;numro de la partition de boot

BootOrder      	rs.b	9+1+1

cci_folder	rs.w	1
cci_data		rs.w	1
cci_fat		rs.w	1
cci_rmunits	rs.b	8

notsum		rs.b	1
sum		rs.b	1

		*-------------------*

*------------------------------------------------------------------------------*

		*-------------*
		* params vido

		RSRESET
scrn_addr		rs.l	1	;adresse physique
scrn_w		rs.w	1	;largeur phys
scrn_h		rs.w	1	;hauteur phys
scrn_p		rs.w	1	;nb de plan

scrn_type		rs.w	1	;moniteur connect
scrn_pal		rs.w	1	;mode pal

*------------------------------------------------------------------------------*		

		*-------------------*
		* structure des variables du TOS

		RSRESET
t_vbl		rs.l	1
t_hbl		rs.l	1
t_trap13		rs.l	1
t_trap14		rs.l	1
t_linea		rs.l	1

t_etvcritic	rs.l	1
t_ios		rs.l	1

t_hdvinit		rs.l	1
t_hdvrw		rs.l	1
t_hdvbpb		rs.l	1
t_hdvmediach	rs.l	1
t_hdvboot		rs.l	1

t_prvlsto		rs.l	1
t_prvlst		rs.l	1
t_prvauxo		rs.l	1
t_prvaux		rs.l	1

t_scrdump		rs.l	1

t_bellhook	rs.l	1
t_kclhook		rs.l	1

t_initvars	rs.l	1

t_inithard	rs.l	1
t_inittimera	rs.l	1
t_writeikbd	rs.l	1
t_prviol		rs.l	1
t_initgem		rs.l	1

t_setscreen	rs.l	1

t_initdsp		rs.l	1

t_devconnect	rs.l	1
t_sdma1		rs.l	1
t_sdma2		rs.l	1

t_tstnvram	rs.l	1
t_readdattim	rs.l	1

t_dmaread		rs.l	1

		* Patch du TOS pour le bureau
		
patch_acc		rs.l	1
patch_new1	rs.l	1
patch_new2	rs.l	1
patch_new3	rs.l	1
patch_desk1	rs.l	1
patch_desk2	rs.l	1
		
		*-------------------*

*------------------------------------------------------------------------------*		

		*-------------*
		* data des modes vidos

		RSRESET
v_x		rs.w	1	;rsolution x relle
v_y		rs.w	1	;rsolution y relle
v_p		rs.w	1	;nombre de plan

		* registres VIDEL
		*  ordre imperatif pour SPSHIFT,SHIFT et VMODE
v_videl		rs.l	0
v_SPSHIFT		rs.w	1	;...
v_shift_write	rs.b	1	;valide l'criture dans SHIFT
v_SHIFT		rs.b	1	;uniquement en 2 plans(4 couleurs)!!!!
				; et ST Basse
v_VCO		rs.w	1	;...
v_VMODE		rs.w	1	;...
v_Hxx		rs.w	8	;...
v_Vxx		rs.w	6	;...

v_len		rs.l	0

*------------------------------------------------------------------------------*		

		*-------------*
		* code de couleur de la palette du setup

blanc		equ	0
rouge		equ	1
vert		equ	2
jaune		equ	3
bleu		equ	4
violet		equ	5
cyan		equ	6
gris		equ	7
gris_f		equ	8
rouge_f		equ	9
vert_f		equ	10
jaune_f		equ	11
bleu_f		equ	12
violet_f		equ	13
cyan_f		equ	14
noir		equ	15

*------------------------------------------------------------------------------*		
