*----------------------------------------------------------------------------*
*		DOLMEN install CT1&CT2 version
*----------------------------------------------------------------------------*

		OPT	nocase
		opt	O+
		opt	nowarn
		opt	noeven
		opt	odl
		OPT	X-
		opt	p=68030
		opt	p=68881
		
		COMMENT	HEAD=FastLoad

		include	FLASH.RS

	IFEQ	langue
	  IFEQ	no_distrib
	    IFEQ	blit_100
		OUTPUT	F:\TOOLS.DOL\PUTFLASH.DEV\FLASH_FB.BIN
	    ELSE
		OUTPUT	F:\TOOLS.DOL\PUTFLASH.DEV\FLASH_F.BIN
	    ENDC
	  ELSE
	    IFEQ	blit_100
		OUTPUT	D:\BIN\FLASH_FB.BIN
	    ELSE
		OUTPUT	F:\CT2B.FR\TOOLS.CTK\PUTFLASH\FLASH.BIN
	    ENDC
	  ENDC
	ENDC
	  
	IFEQ	langue-1
	  IFEQ	no_distrib
	    IFEQ	blit_100
		OUTPUT	F:\TOOLS.DOL\PUTFLASH.DEV\FLASH_EB.BIN
	    ELSE
		OUTPUT	F:\TOOLS.DOL\PUTFLASH.DEV\FLASH_E.BIN
	    ENDC
	  ELSE
	    IFEQ	blit_100
		OUTPUT	D:\BIN\FLASH_EB.BIN
	    ELSE
		OUTPUT	F:\CT2B.US\TOOLS.CTK\PUTFLASH\FLASH.BIN
	    ENDC
	  ENDC
	ENDC
	
	IFEQ	langue-2
	  IFEQ	no_distrib
	    IFEQ	blit_100
		OUTPUT	F:\TOOLS.DOL\PUTFLASH.DEV\FLASH_DB.BIN
	    ELSE
		OUTPUT	F:\TOOLS.DOL\PUTFLASH.DEV\FLASH_D.BIN
	    ENDC
	  ELSE
	    IFEQ	blit_100
		OUTPUT	D:\BIN\FLASH_DB.BIN
	    ELSE
		OUTPUT	F:\CT2B.US\TOOLS.CTK\PUTFLASH\FLASH_D.BIN
	    ENDC
	  ENDC
	ENDC

*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*

		*-------------*

		include	D:\DOLMEN\SOURCES\XLIB\GEM.EQU
		include	D:\DOLMEN\SOURCES\XLIB\BIOS.EQU
		include	D:\DOLMEN\SOURCES\XLIB\XBIOS.EQU

		include	D:\DOLMEN\SOURCES\DOLMEN.RS
		include	D:\DOLMEN\SOURCES\BORIS\BORIS.RS
		include	D:\DOLMEN\SOURCES\BORIS\VIDEL\VIDEL.RS
		include	D:\DOLMEN\SOURCES\BORIS\CECILE.BRS\SYS\SYSHEAD.RS

		*-------------*

*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*

* date de cration
ver		equ	$133

* date de cration
jour_hex		equ	$04
mois_hex		equ	$04
annee_hex		equ	$1999
jour_dec		equ	04
mois_dec		equ	04
annee_dec		equ	1999

		*/------------/*
_FLASH_START
		dc.w	$000f
		dc.w	ver		;pile ssp en $000f0000+ver
		dc.l	_FLASH_RUN	;reset
		dc.l	_FLASH_START	;flash
		dc.l	_FLASH_INIT	;fin vars
		dc.l	0
		dc.l	$CAFEFADE		;magique
		dc.l	mois_hex<<24+jour_hex<<16+annee_hex	;date M/J/A

	IFEQ	LANGUE
		dc.w	2				;langue
	ELSE
		dc.w	0				;langue
	ENDC
		dc.w	(annee_dec-1980)<<9+mois_dec<<5+jour_dec
						;date gemdos
		dcb.l	3,0			;mis  jour  l'install
		dc.l	flash_vars-_FLASH_START	;offset vers vars systmes
_FLASH_RUN
		move	#$2700,sr
		bra	_FLASH_INIT		;une fois recopi
						;en ram, ce sera
						;le branchement sur
						;le setup
*----------------------------------------------------------------------------*
*		VARIABLES SYSTEMES
*----------------------------------------------------------------------------*

	*-------------------*
	* boot vars
		cnop	0,16
flash_vars
.flh_checksum	dc.l	0	;checksum du binaire
				;la valeur doit tre align sur un long
				;sinon on ne peut pas recaculer la checksum
				;32-bit.
.flh_checksum_cal	dc.l	0	;checksum calcule par le setup

.ct2_val		dc.l	ct2_reg+f30_boot	;configuration de la CT2

.flh_version	dc.w	ver		;version de la Flash
.flh_date		dc.l	mois_hex<<24+jour_hex<<16+annee_hex
					;date de la Flash
.flh_dol_ver	dc.w	dolmen_version	;version de Dolmen
.flh_dol_date	dc.l	dolmen_date	;date de Dolmen
.flh_cecile_ver	dc.w	0		;version du Ccile interne
					;lu dans le bin de la flash


.open_setup	dc.b	0	;commande l'ouverture du setup
.ct2_ok		dc.b	0	;on est bien sur une CT2
.ram_clr		dc.b	0	;Ram efface aprs un reset?
.system_run	dc.b	0	;indique si le systme est lanc

.first_boot	dc.b	0	;on vient ou pas de booter
.dolmen_on	dc.b	0	;dolmen est install
		
	*-------------------*
	* configuration RAM
.chip_end		dc.l	0	;fin physique
.chip_top		dc.l	0	;fin systme

.fast_start	dc.l	fast_hard_start	;adresse hard sans PMMU
.fast_end		dc.l	0	;adresse hard sans PMMU

.fast_sys		dc.l	fast_log_start	;adresse logique o commence la fast
.fast_sysend	dc.l	0	;adresse logique de la fin de la fast

.fast_bot		dc.l	0	;adresse logique o commence la ram systme
				;disponible
.fast_top		dc.l	0	;et sa fin

.sysvars_len	dc.l	_FLASH_INIT-flash_vars	;taille des vars

	*-------------------*
	* routines

		*-------------------*
		* RELOC
.reloc_ptr	dc.l	fast_dol_start+reloc_it-_FLASH_START	;relocateur

		*-------------------*
		* SETUP
.setup_ptr	dc.l	0			;adresse code relog
.setup_len	dc.l	0			;taille du code+data+bss
		* VIDEO
.VideoVars	dc.l	0		;pointeur sur params vido
.PutPal		dc.l	0		;met en place la palette systme
		* IKBD
.Wikbd		dc.l	0		;crit dans le clavier
.ResetBuf		dc.l	0		;reset le buffer clavier
		* CONSOLE
.Constat		dc.l	0		;caractre en entr dispo?
.Conin		dc.l	0		;va chercher un caractre
.Conout		dc.l	0		;sort un caractre norme vt52
.Rawout		dc.l	0		;sort un caractre en brute
.DeadKeys		dc.l	0		;pointeur sur les touches mortes (1.b)
		* SOUS-PROGRAMMES
.TextOut		dc.l	0		;affiche une chane de texte en vt52
.ConvHex		dc.l	0		;convertie un nombre en texte hexa
.ConvDec		dc.l	0		;convertie un nombre en texte dec

		*-------------------*
		* BOOT DE DOLMEN
.dolboot_ptr	dc.l	0			;adresse code relog
.dolboot_len	dc.l	0			;taille du code+data+bss

		*-------------------*
		* GEMDOS DE DOLMEN
	ifeq	no_distrib
.dolgem_bin	dc.l	dolgem_bin		;dolgem binarie
.dolgem_len	dc.l	dolgem_end-dolgem_bin	;taille du binaire
	else
		dc.l	0
		dc.l	0
	endc
		*-------------------*
		* CECILE.SYS
.cecile_bin	dc.l	cecile_bin		;cecile binarie
.cecile_len	dc.l	cecile_end-cecile_bin	;taille du binaire

		*-------------------*
		* BOOT DU TOS
.tos_ptr		dc.l	0			;adresse code relog
.tos_len		dc.l	0			;taille du code+data+bss

	*-------------------*
	* configuration PMMU
.tt0_pmmu		dc.l	$807f8507		;pmmu ultime :-)
.tt1_pmmu		dc.l	0

.tc_pmmu_stop	dc.l	$00d1b700		;coupe l'arbre PMMU
.tc_pmmu_run	dc.l	$80d1b700		;active l'arbre PMMU

.RegCRP		dc.l	$07ff0003
.user_tree	dc.l	0		;arbre user

	*-------------------*
	* NVRAM (50 octets)

		*-------------------*
		* partie TOS/DOLMEN
.nvram_buffer
.hd_boot		dc.w	$0080	;type de boot TOS

.nvm_valid	dc.l	"_DOL"
		
.akp		dc.w	$202	;langue/clavier
.idt		dc.w	$112f	;heure&date/sparateur "/"
.pause		dc.b	15	;pause
		dc.b	$0	;rserv (0)
		dc.w	$0	;rserv (0)
.mode_video	dc.w	$38	;mode par dfaut (Mono VGA/PAL)
.arbid		dc.b	$87	;arb+id
		dc.b	0	;rserv (0)

		*-------------------*
		* partie Dolmen

		* nb d'unit par id ide (pour les amovibles en atapi)
.cci_rmunits2	dc.b	2	;ide 0
		dc.b	2	;ide 1

			;xFSDBRWF
.flags_boot	dc.b	%00000100	;7,x: rserv (0)
				;6,x: Floppy prsent (0) absent (1)
				;5,S: Enter Setup (0) ou skip (1)
				;4,D: boot sur TOS (0) ou Dolmen (1)
				;3,B: boot TOS 4.0x si boot TOS choisi
				;2,R: test ram ok (1) (0 pas de test)
				;1,W: pause ok (1) ou pas de pause (0)
				;0,F: boot HD avant Floppy (1) ou
				;     floppy avant hd(0)
			;CMMEDISS
.flags_boot2	dc.b	%10000100	;7,C: Boot comme le TOS(0)ou avec ccile(1)
				;     Uniquement pour le Boot TOS !
				;6.5, MM: Master IDE mode
				;	0=AUTO
				;	1=CHS
				;	2=LBA
				;	3=rserv
				;4,E: coupe la clock externe
				;3,D: 12/24 WS sur DSP
				;2,I: 3/5 cycle sur l'IDE
				;1.0, SS: Slave IDE mode
				;	0=AUTO
				;	1=CHS
				;	2=LBA
				;	3=rserv

.boot_nvm		dc.b	"C"-"A"	;numro de la partition de boot
.BootOrder      
		dc.b	$10	;ide  0
		dc.b	$11	;ide  1
		dc.b	$8	;scsi 0
		dc.b	$9	;scsi 1
		dc.b	$a	;scsi 2
		dc.b	$b	;scsi 3
		dc.b	$c	;scsi 4
		dc.b	$d	;scsi 5
		dc.b	$e	;scsi 6
		dc.b	$f	;scsi 7

		dc.b	$ff	;fin de la liste


.cci_folder	dc.w	300
.cci_data	dc.w	8
.cci_fat		dc.w	8

.cci_rmunits	dc.b	2	;scsi 0
		dc.b	2
		dc.b	2
		dc.b	2
		dc.b	2
		dc.b	2	;(zip 5)
		dc.b	2	;(jazz 6)
		dc.b	2	;scsi 7
		
		dc.b	0	;notsum
		dc.b	0	;sum

		*-------------------*

*-------------------------------------------------------------------------*

		*-------------*
		* A0: adresse programme source+header type GEM
		* A1: destination du code (o il sera copi) sans header
		* D0: adresse de relogement (o il sera excut)
		* (Si d0=a1 pas de recopie: normal)
		* => D0: taille du programme relog
		cnop	0,16
reloc_it
		movem.l	d1-7/a0-6,-(sp)

		*-------------*

		move.l	a0,a6		;excutable
		move.l	a1,a5		;destination

		lea	$1c(a0),a0	;pointeur sur le code  reloger
					;(et  recopier?)

		* calcul taille code+data+symbol
		move.l	a0,a1
		move.l	prg_text(a6),d1
		add.l	prg_data(a6),d1
		add.l	d1,a1
		add.l	prg_symbol(a6),a1
		move.l	d1,d7

		* recopie du code proprement dit en A5
		
		lea	(a5,d1.l),a3
		
		cmp.l	a5,a0
		beq.s	.no_copie

		move.l	a5,a2
		lsr.l	#4,d1
.copie_code
		rept	4
		move.l	(a0)+,(a2)+
		endr
		subq.l	#1,d1
		bhs.s	.copie_code	;bhs pour l'arrondie
.no_copie
		* relogement
		move.l	a5,a0
		moveq	#0,d1

		tst.l	(a1)
		beq.s	.makebss

		add.l	(a1)+,a0
		add.l	d0,(a0)

.again		move.b	(a1)+,d1
		beq.s	.makebss
		cmpi	#1,d1
		bne.s	.normal
		lea	254(a0),a0
		bra.s	.again

.normal		lea	(a0,d1.w),a0
		add.l	d0,(a0)
		bra.s	.again

		* bss...
.makebss		move.l	prg_bss(a6),d0
		add.l	d0,d7

		tst.l	d0
		beq.s	.bss_end
		add.l	d0,a3	; la fin
		moveq	#$3f,d1
		and.l	d0,d1
		lsr.l	#4+2,d0	;/64 octets
		beq.s	.pas_64
		
		moveq	#0,d2
		move.l	d2,d3
		move.l	d2,d4
		move.l	d2,d5
.clr_bss64
		rept	4
		movem.l	d2-5,-(a3)
		endr
		subq.l	#1,d0
		bne.s	.clr_bss64
.pas_64
		moveq	#$f,d0
		and	d1,d0
		lsr	#4,d1
		beq.s	.pas_16
.clr_bss16
		movem.l	d2-5,-(a3)
		subq	#1,d1
		bne.s	.clr_bss16
.pas_16
		tst	d0
		beq.s	.bss_end
.clr_bss1
		clr.b	-(a3)
		subq	#1,d0
		bne.s	.clr_bss1
.bss_end
		* taille du code relog
		move.l	d7,d0

		*-------------*

		movem.l	(sp)+,d1-7/a0-6
		rts
		
		*-------------------*
		
*-------------------------------------------------------------------------*

		*-------------------*
		* Installation du systme (flash start)
		cnop	0,16		
_FLASH_INIT
	* coupe le dcodage de la flash en $00xxxxxx
		clr.b	ct2_reg+f30_boot	;on sort sur le Falcon

	* reset combel (et init chip-ram?)
.RESET_COMBEL
		move	$ffff8006.w,d0
		reset   
		clr.b	ct2_reg+f30_boot	;on resort sur le Falcon
		move	$ffff8006.w,d0

	* coupe les GPIOs
.DSP_SHUT
		move.w	#7,$ffff8940.w

	* teste cartouche diagnostique
.DIAGF030
		cmp.l	#$fa52235f,$fa0000
		bne.s	.pas_diag
		lea	.pas_diag(pc),a6
		jmp	$fa0004
.pas_diag

	* caches&Vbr
.MC680xx_INIT
		move.l	#$808+$3111,D0	;active et vide les caches
		movec.l	d0,CACR
		moveq	#0,D0
		movec.l	D0,VBR

	* pmmu initialisation
		lea	flash_vars(pc),a6
		pflusha			; prcaution
		pmove.l	tc_pmmu_stop(a6),TC
		pflusha			; prcaution
		pmove.l	tt0_pmmu(a6),TT0
		pmove.l	tt1_pmmu(a6),TT1

	* configuration du combel
.COMBEL_INIT
		moveq	#$25,d1
		
		
		or.b	$ffff8007.w,d1	;bus pleine vitesse
					;compatibilit ste
					;blitter pleine-vitesse
		
		move.b	d1,$ffff8007.w

	* Sur quel revision est-on
		move.l	a7,a0
		move.l	#.revb_ok,BusError.w
		tst.l	Flash_shadow
		moveq	#"A",d7
		bra.s	.reva_ok
.revb_ok
		move.l	a0,a7
		moveq	#"B",d7
.reva_ok
	* vido initialisation
.VIDEO_PUT
	* type de moniteur connect, en vrai!
		bfextu	$ffff8006.w{0:2},d1

	* mode pal ou ntsc pour les modes
		ldnvm	#nvm_videolo,d2
		and	#_pal,d2

	* cherche le mode video; par dfaut la clock ext est active (cf clk_off  0)
		moveq	#0,d0		;sm124
		moveq	#1,d3		;clock_ext 32
		clr.b	ct2_reg+f30_boot+clk_32	;sur revb,c 'est toujours 32
		tst	d1
		beq.s	.ok	;=>SM124
		
		btst	#0,d1
		bne.s	.tv
		moveq	#0,d3		;clock_int par dfaut
		moveq	#3,d0		;vga
		bra.s	.ok
.tv
		moveq	#1,d0		;tv ntsc
		tst	d2
		beq.s	.ok
		moveq	#2,d0		;tv pal
.ok
		move.l	(video_list.w,pc,d0*4),a2
		lea	v_videl(a2),a0

	* PAF LE VIDEL!
		clr.b	_HSR.w
		clr.b	_SHIFT.w

		* synchro ext et pal
		tst	d2
		beq.s	.pas_pal
		or	#%10,d3
.pas_pal
		move.b	d3,_SYNC.w

		* SpShift	(1)
		move	(a0)+,_SPSHIFT.w

		* Shift (2)
		move	(a0)+,d0
		beq.s	.pas_shift
		move.b	d0,_SHIFT.w
.pas_shift
		* VCO (3)
		move	(a0)+,_VCO.w

		* Vmode (4)
		move	(a0)+,_VMODE.w

		* Hxx
		lea	_HHT+8*2.w,a1	; tapons le gars VIDEL !
		movem.l	(a0)+,d0-d3
		movem.l	d0-d3,-(a1)

		* Vxx
		lea	_VFT+6*2.w,a1
		movem.l	(a0)+,d0-d2
		movem.l	d0-d2,-(a1)

	* offset
		move	v_x(a2),d0
		move	v_p(a2),d1
		mulu	d1,d0
		lsr	#4,d0

		move	d0,_VWRAP.w
		clr	_OFFSET.w

	* palette
		cmp	#1,d1
		beq.s	.fin_video
		
		lea	$ffff9800.w,a0
		moveq	#16-1,d0
		cmp.b	#"A",d7
		bne.s	.pas_col_a
		move.l	#$000000a4,d1	;bleu_f (rev a)
		bra.s	.clr_pal
.pas_col_a
		move.l	#$00600060,d1	;cian_f (rev b)
.clr_pal
		move.l	d1,(a0)+
		dbra	d0,.clr_pal
.fin_video
	* check Chip-Ram => d5=chipram dispo
		move.b	$ffff8006.w,d0
		lsr.b	#3,d0
		moveq	#%110,d1
		and	d1,d0	;bits de config

		cmp	d1,d0
		bne.s	.ok_chipram
		move.l	#$ff000000,$ffff9800.w
.infini		stop	#$2700

.ok_chipram
		move.l	#1*1024*1024,d1
		lsl.l	d0,d1
		subq	#%100,d0
		blo.s	.chip_ok
		move.l	#14*1024*1024,d1	;cas 14Mo
.chip_ok
		move.l	d1,a5

	* y-a-t'il une CT2 et donc de la FAST-RAM
.CT2_TEST
		lea	fast_hard_start,a6

		cmp.b	#"A",d7
		bne.s	.revb_ram
		
	* initialise contrleur rev A
		move.l	a7,a0
		moveq	#-1,d6
		move.l	#.gros,BusError.w
		move.l	d6,$f730c788	;init contrleur

		* on attend que le contrleur soit initialis
.gros
		move.l	a0,a7
		moveq	#-1,d0
.wait_chip
		REPT	25		
		nop			;25*2 +6 cycles
		ENDR
		dbra	d0,.wait_chip	;*65536=73.4 ms
		
	* Suite rev B (pas d'init du contrleur de la rev A)
.revb_ram
	* coupe le cache pour les tests de prsence
		move.l	#$808,d0
		movec.l	d0,CACR
		
		move.l	#.fast_end,BusError.w
		move.l	a7,a0
		sf	d6		;a-t'on activ le mode 64Mo

	* cas 16/32/64/128 Mo rev A&B
.revab_ram
		move.l	a6,a1		;pour le test des shadows
		move.l	a1,d1
.ramab_loop
		move.l	a6,d0
		move.l	d0,(a6)
		cmp.l	(a6),d0
		bne.s	.fast_end
		cmp.l	(a1),d1		;premire page toujours OK !
		bne.s	.fast_end
		
		lea	(16*1024*1024.l,a6),a6
		bra.s	.ramab_loop
		
	* remet le cache (tests finis)
.fast_end
		move.l	a0,a7		;restaure pile
		
	* vrification que c'est pas une 64Mo mode strange
		tst.b	d6
		bne.s	.64Mo_end
		st	d6
		cmp.b	#"A",d7
		beq.s	.64Mo_end
		
		cmp.l	#fast_hard_start+16*1024*1024,a6
		bne.s	.64Mo_end		;donc plus de 16Mo
		
		move.l	#.test_64,BusError.w
		lea	(16*1024*1024.l,a6),a2
		move.l	a2,(a2)
		cmp.l	(a2),a2
		bne.s	.64Mo_end		;pas de ram donc pas 64Mo
		
		clr.b	ct2_reg2+m64_flag	;passe en mode 64Mo
		
		bra.s	.ramab_loop
.test_64
		move.l	a0,a7
.64Mo_end
		move.l	#$808+$3111,d0	;active et vide les caches
		movec.l	d0,CACR

	*-----------------*
	* o met-on la Fast et le systme donc
		cmp.l	#fast_hard_start,a6
		bhi.s	.en_fast
.en_chip
		move.l	a5,a1
		cmp.l	#$400000,a1
		bhi.s	.14mo
		sub.l	#$200000,a1	;2 Mo en dessous
		bra.s	.ok_site
.14mo
		;sub.l	#$a00000,a1	;10 Mo en dessous
		sub.l	#$800000,a1	;8 Mo en dessous
		
		bra.s	.ok_site
.en_fast
		lea	fast_hard_start,a1	

		move.l	a6,d0
		sub.l	a1,d0

	* copie le header et les vars
.ok_site
		lea	_FLASH_START(pc),a0
		move.l	a1,a2
		move	#(_FLASH_INIT-_FLASH_START)/16-1,d0
						;Max 1Mo (quel Flash!)
						;copie d'une taille multiple
						;de 16 octets!!!
.copie_flash
		rept	4
		move.l	(a0)+,(a2)+
		endr
		dbra	d0,.copie_flash
.fin_copie
	* mise  jour du header de la nouvelle page
		lea	fast_dol_start,a2
		lea	dol_header(a2),a3
		move.l	a3,rom_reset(a1)
		move.l	a2,rom_os_start(a1)
		lea	_FLASH_INIT-_FLASH_START(a2),a3
		move.l	a3,rom_os_end(a1)
		
		lea	dol_vars(a1),a2
		lea	_FLASH_INIT-_FLASH_START(a1),a3

	* A1: pointe sur le dbut de la fast
	* A2: pointe sur sysvars dans cette fast
	* A3: pointe sur la dbut de la ram libre
	* A5: pointeur sur la fin de la chip physique
	* A6: pointeur sur la fin de la fast physique

	* mise  jour sys_vars
		move.l	#ct2_reg+f30_boot,d6
		bfextu	$ffff8006.w{0:2},d1
		cmp	#%10,d1
		beq.s	.vga
		or.l	#clk_32,d6
.vga
		cmp.b	#"A",d7
		bne.s	.revb
		or	#"a",d6
		bra.s	.ct2_w
.revb
		or	#"b",d6
.ct2_w
		move.l	d6,ct2_val(a2)	;pour le cookie
		move.b	d7,ct2_ok(a2)

		move.l	a5,chip_end(a2)
		cmp.l	a1,a5
		blo.s	.chip_intact

	* pas de fast, donc fausse page de 1Mo en fast contenant la page spcial
		move.l	a1,chip_top(a2)
		move.l	a1,fast_start(a2)
		move.l	a5,fast_end(a2)
		lea	fast_log_start,a0
		move.l	a0,fast_sys(a2)
		move.l	a5,d0
		sub.l	a1,d0
		add.l	d0,a0
		move.l	a0,fast_sysend(a2)

		bra.s	.no_fast
.chip_intact
		move.l	a5,chip_top(a2)
		
		move.l	a6,fast_end(a2)
		lea	(fast_log_start-fast_hard_start.l,a6),a0
		move.l	a0,fast_sysend(a2)	
.no_fast
	* install la pmmu
		move.l	#pmmu_len,d1
		sub.l	d1,a0
		move.l	a0,fast_top(a2)
		
		move.l	fast_end(a2),a0
		sub.l	d1,a0
		move.l	a0,user_tree(a2)

		* construction du niveau A !
		* page $000  $00d => chipRam
		lea	pmmu_levela(a0),a4

		move.l	#$00100000,d7	;incrment 1Mo
		move.l	#$007ffc00,d3	;page non valide
		move.l	#$007ffc01,d4	;page valide

		* pages $000  $00d:
		* buserr sur les pages inutilises en cours...
		moveq	#0,d0
		moveq	#14-1,d2
.chip_map
		cmp.l	a1,d0
		blo.s	.chip_norm
		move.l	d3,(a4)+		;invalide la page
					;o se trouve la copie de la Rom
		bra.s	.chip_sup
.chip_norm
		move.l	d4,(a4)+
.chip_sup
		move.l	d0,(a4)+
		add.l	d7,d0	; page d'1 Mo

		dbra	d2,.chip_map

		* page $00e ROM => Ram (criture interdite)
		* d0 pointe sur la page de la Rom (1 Mo) en $e00000

		move.l	#$007ffc02,(a4)+
		lea	pmmu_levelb1(a0),a6
		move.l	a6,(a4)+
		
		add.l	d7,d0		;$00f00000

		* et enfin les i/o (superviseur + cache inhib)
		* page $00f

		move.l	#$007ffd41,(a4)+	;spcial
		move.l	d0,(a4)+
		add.l	d7,d0		;$01000000 (16Mo)

		* enfin on valide les pages suivantes en Fast-Ram
		* d0=$1000000

		move.l	fast_sysend(a2),a6	;fin logique 
		move.l	fast_start(a2),d6	;dbut physique
		sub.l	d7,a6		;pour s'arrter avant la fin

		* la partie principale de la fast
.fast_map
		move.l	d4,(a4)+
		move.l	d6,(a4)+
		add.l	d7,d0	; page d'1 Mo (pour la suite)
		add.l	d7,d6	; page d'1 Mo (dplacement...)
		cmp.l	d0,a6	; on pourrait comparer d6 et fast_end, aussi
		bne	.fast_map
		
		* dernier mga de la fast
		move.l	#$007ffc02,(a4)+
		lea	pmmu_levelb2(a0),a6
		move.l	a6,(a4)+
		add.l	d7,d0	;+1Mo

		* on termine l'arbre

		move.l	#$80000000-$00100000,d2	;-1 Mo

		move.l	#fast_hard_start,d5
		move.l	#fast_hard_end,d6
.maptrou
		move.l	d3,(a4)+	
.fast_av
		move.l	d0,(a4)+
		add.l	d7,d0		; page d'1 Mo
		cmp.l	d0,d2
		bne	.maptrou

		* dernier mega: page contenant la copie de la Rom et l'arbre pmmu
		move.l	d4,(a4)+
		move.l	fast_end(a2),d0
		sub.l	d7,d0
		move.l	d0,(a4)+
		
		* construction du niveau b
		move.l	#$2000,d1		;taille d'une page (8Ko)
		
		* page de la rom (page $e)
		lea	pmmu_levelb1(a0),a4
		moveq	#5,d6
		or.l	fast_start(a2),d6
		move	#64-1,d0		;64 premires pages
.map_rom
		move.l	d6,(a4)+
		add.l	d1,d6
		dbra	d0,.map_rom
		
		* garde la shadow
		move.l	#Romtos_true+5,d6
		move	#64-1,d0		;64 dernires pages
.map_rom2
		move.l	d6,(a4)+
		add.l	d1,d6
		dbra	d0,.map_rom2

		* page du dernier mega
		lea	pmmu_levelb2(a0),a4
		moveq	#1,d6
		or.l	fast_end(a2),d6
		sub.l	d7,d6
		move	#128-pmmu_len/8192-1,d0	
					;128 pages - l'arbre  la fin
.map_lastmega
		move.l	d6,(a4)+
		add.l	d1,d6
		dbra	d0,.map_lastmega
		
		move	#pmmu_len/8192-1,d0
		and	#~1,d6		;=>invalide
.cache_pmmu
		move.l	d6,(a4)+
		add.l	d1,d6
		dbra	d0,.cache_pmmu
		
		* ...et voila l'arbre est fini :-))
		* Et on efface le reste: c'est plus propre
		move.l	fast_end(a2),d0
		sub.l	a4,d0
		lsr.l	#4,d0
		moveq	#0,d1
.clr_pmmu
		rept	4
		move.l	d1,(a4)+
		endr
		subq.l	#1,d0
		bne.s	.clr_pmmu

	* comme la pmmu n'est pas encore installe, il faut travailler
	* avec des pointeurs dans la map relle et d'autres qui pointent
	* sur la future map.
	* 
	* d3: pointeur map future
	* a1: pointeur map relle
	* 
	* 
	* on reloge et installe le setup...
		moveq	#$f,d1		;arrondie 16 octets
		moveq	#$fffffff0,d2

		lea	setup_bin(pc),a0
		move.l	a3,a1
		move.l	#fast_dol_start+_FLASH_INIT-_FLASH_START,d3
		move.l	d3,setup_ptr(a2)	;adresse aprs remap
		move.l	d3,a3		;pour le saut
		move.l	d3,d0
		
		bsr	reloc_it
		move.l	d0,setup_len(a2)	;taille du code relog

		add.l	d0,d3		;pour le suivant
		add.l	d1,d3
		and.l	d2,d3
		
		add.l	a1,d0
		add.l	d1,d0
		and.l	d2,d0
		move.l	d0,a1

	* ...puis le boot du TOS...
		lea	tos_bin(pc),a0
		move.l	d3,tos_ptr(a2)
		move.l	d3,d0
		
		bsr	reloc_it
		move.l	d0,tos_len(a2)	;taille du code relog

		add.l	d0,d3
		add.l	d1,d3
		and.l	d2,d3
	
		add.l	a1,d0
		add.l	d1,d0
		and.l	d2,d0		;multiple de 16
		move.l	d0,a1
		
	* ...puis le boot de Dolmen.
		lea	dol_bin(pc),a0
		move.l	d3,dolboot_ptr(a2)
		move.l	d3,d0
		
		bsr	reloc_it
		move.l	d0,dolboot_len(a2)	;taille du code relog
		
		add.l	d0,d3
		add.l	d1,d3
		and.l	d2,d3

		add.l	a1,d0
		add.l	d1,d0
		and.l	d2,d0		;multiple de 16
		move.l	d0,a1
		
	* la version de ccile dans le header
		move.l	cecile_ptr(a2),a0
		move	_sys_ver(a0),flh_cecile_ver(a2)

	* et recopie du binaire en cas de bug dans la Flash par la suite
		move.l	d3,cecile_ptr(a2)	;pointe plus sur la Flash
		move.l	a1,a4
		move.l	cecile_len(a2),d0
		lsr.l	#4,d0		;par paquet de 16 octets
.copie_ccile
		REPT	4
		move.l	(a0)+,(a4)+
		ENDR
		subq.l	#1,d0
		bhs.s	.copie_ccile
		
		move.l	cecile_len(a2),d0
		add.l	d0,d3
		add.l	d1,d3
		and.l	d2,d3
		
		add.l	a1,d0
		add.l	d1,d0
		and.l	d2,d0		;multiple de 16
		move.l	d0,a1

	* recopie du gemdos si prsent
	IFEQ	no_distrib
		move.l	dolgem_ptr(a2),a0
		move.l	d3,dolgem_ptr(a2)	;pointe plus sur la flash
		
		move.l	a1,a4
		move.l	dolgem_len(a2),d0
		lsr.l	#4,d0
.copie_gemdos
		REPT	4
		move.l	(a0)+,(a4)+
		ENDR
		subq.l	#1,d0
		bhs.s	.copie_gemdos
	
		move.l	dolgem_len(a2),d0
		add.l	d0,d3
		add.l	d1,d3
		and.l	d2,d3
		
		add.l	a1,d0
		add.l	d1,d0
		and.l	d2,d0		;multiple de 16
		move.l	d0,a1
	ENDC

	* la fin...
		move.l	d3,fast_bot(a2)	;libre  partir de l
					;(multiple de 16)
	* on crit les registres au dernier moment !
		pmove.d	RegCRP(a2),CRP	; attention registre 64 bits !
		pmove.l	tc_pmmu_run(a2),TC		; et pan !

	* Saute dans le setup
		move.l	#_FLASH_RUN,BusError.w	;=>IPL7
		jmp	(a3)

		*-------------------*

*-------------------------------------------------------------------------*

		*-------------------*
		cnop	0,16
video_list	dc.l	video_bin+v_len*0
		dc.l	video_bin+v_len*1
		dc.l	video_bin+v_len*2
		dc.l	video_bin+v_len*3
		
		cnop	0,16
video_bin		INCBIN	D:\DOLMEN\SOURCES\FLASH.CT2\SETUP\SVIDEO.BIN
		
		*-------------------*

*----------------------------------------------------------------------------*

		*-------------------*
		* fichier qui seront relog au lancement de la
		* flash

	* Franais
	IFEQ	langue

setup_bin		incbin	D:\BIN\SETUPF.BIN

tos_bin		incbin	D:\BIN\TOSBOOTF.BIN

	ifne	no_distrib
dol_bin		incbin	D:\BIN\DOLPUBF.BIN
	else
dol_bin		incbin	D:\BIN\DOLBOOTF.BIN
dolgem_bin	incbin	D:\BIN\FLASHDOS.BIN
dolgem_end
	endc

cecile_bin	incbin	F:\CT2B.FR\TOOLS.CTK\CECILE\DRIVER\CECILE.SYS
cecile_end


	ENDC
	
	* Anglais
	IFEQ	langue-1


setup_bin		incbin	D:\BIN\SETUPE.BIN

tos_bin		incbin	D:\BIN\TOSBOOTE.BIN

	ifne	no_distrib
dol_bin		incbin	D:\BIN\DOLPUBE.BIN
	else
dol_bin		incbin	D:\BIN\DOLBOOTE.BIN
dolgem_bin	incbin	D:\BIN\FLASHDOS.BIN
dolgem_end
	endc

cecile_bin	incbin	F:\CT2B.US\TOOLS.CTK\CECILE\DRIVER\CECILE.SYS
cecile_end

	ENDC

	* Allemand
	IFEQ	langue-2



setup_bin		incbin	D:\BIN\SETUPD.BIN

tos_bin		incbin	D:\BIN\TOSBOOTD.BIN

	ifne	no_distrib
dol_bin		incbin	D:\BIN\DOLPUBD.BIN
	else
dol_bin		incbin	D:\BIN\DOLBOOTD.BIN
dolgem_bin	incbin	D:\BIN\FLASHDOS.BIN
dolgem_end
	endc

cecile_bin	incbin	F:\CT2B.US\TOOLS.CTK\CECILE\DRIVER\CECILE.SYS
cecile_end

	ENDC


		*-------------------*

*----------------------------------------------------------------------------*
		DATA
*----------------------------------------------------------------------------*

		*-------------*

		*-------------*

*----------------------------------------------------------------------------*
		BSS
*----------------------------------------------------------------------------*

		*-------------*
		
		*-------------*

*----------------------------------------------------------------------------*