*----------------------------------------------------------------------------*
*	Le driver console ne fait que lire le buffer
*	texte alimente par le driver clavier et
*	sortir le texte  l'cran.
*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*
		*-------------*
		* Initialisation des variables graphiques
		*-------------*

		cnop	0,16
init_console
		movem.l	d0-3/a0-1,-(sp)

		*-------------*
		
		sf	esc_on
		sf	esc_long
		
	* adresse cran
		move.l	phys_adr(pc),a0
		move.l	a0,cur_adr0
		move.l	a0,cur_adr
	* init vido
.vido
		move	phys_w(pc),d0
		move	phys_h(pc),d1
		move	n_planes(pc),d2
	* start...
		clr.l	curx
		clr.l	save_cur
		move	d2,cur_plane
		move.l	#$00ff00ff,cur_mask

	* fonte
		move.l	#fonte,cur_data
		moveq	#16,d3
		move.l	d3,cur_size

	* maximum
		lsr	#3,d0
		move	d0,cur_w

		ext.l	d1
		divu	d3,d1
		move	d1,cur_h
	* offsets
		mulu	d2,d0
		move.l	d0,cur_bwidth
		mulu	d3,d0
		move.l	d0,cur_lwidth

	* routines...
		move.l	(cur_routs-1*4,pc,d2*4),cur_rout
		move.l	(cols_xxtab-1*4,pc,d2*4),cur_colxx
		move.l	(cur_lclrs-1*4,pc,d2*4),cur_lclr
		move.l	(cur_bclrs-1*4,pc,d2*4),cur_bclr

		movem.l	(sp)+,d0-d3/a0-1

	* init masques de couleur
		movem.l	d1-6,-(sp)

		sf	cur_inv
		move	cur_fcol_init(pc),d0
		move	d0,cur_fcol
		move	cur_bcol_init(pc),d1
		move	d1,cur_bcol
		jmp	([cur_colxx.w,pc])

		*-------------*

*-------------------------------------------------------------------------*
*		Gestion CONIN
*-------------------------------------------------------------------------*

		*-------------*
		* A0: Modifi
		* d0: 0 pas de caractre
		*     -1 un caractre au moins
		*-------------*
		dc.b	"Bconstat CON"
		cnop	0,16
con_stat
		moveq	#0,d0
		
		lea	buf_conin(pc),a0
		move	ibuftl(a0),d0
		sub	ibufhd(a0),d0	;la tte a rejoins la queue
		bne.s	.yes
		rts
.yes
		bpl.s	.car_pos
		add	ibufsize(a0),d0
.car_pos
		lsr	#1,d0
		rts

		*-------------*

*-------------------------------------------------------------------------*

		*-------------*
		* =>A0: Modifi
		* =>D0: le caractre demand
		*-------------*
		dc.b	"Bconin CON"
		cnop	0,16
con_in
		move.l	d1,-(sp)
		
		lea	buf_conin(pc),a0
.wait
		move	ibufhd(a0),d0
		cmp	ibuftl(a0),d0	;la tte a rejoins la queue
		beq.s	.wait
		
		move	d0,d1
		addq	#2,d1
		cmp	ibufsize(a0),d1
		bne.s	.around
		moveq	#0,d1
.around
		move	([ibuf,a0],d0),d0	;l'actuel=>
		move	d1,ibufhd(a0)	;=>prochaine lecture
		
		move.l	(sp)+,d1
		rts

		*-------------*

*----------------------------------------------------------------------------*


		*-------------*
		* d0: caractre
		* =>A0: modifi
		* =>D0=0 pas d'erreur 
		*-------------*
		dc.b	"Bconout RAW"
		cnop	0,16
raw_out
		and	#$ff,d0

		movem.l	d1-3/a1-3,-(sp)

		movem.l	cur_size(pc),d1/a0-3	;cur_data+cur_adr+cur_bwidth
					;+cur_rout

		jsr	(a3)

		move	curx(pc),d1
		add	#1,d1
		cmp	cur_w(pc),d1
		blt.s	.in
		tst.b	cur_over(pc)
		bne	over
		bra.s	.out
.in
		move	d1,curx
		add.l	d0,cur_adr

		move.l	cur_mask(pc),d0
		ror.l	#8,d0
		move.l	d0,cur_mask
.out

		movem.l	(sp)+,d1-3/a1-3
		moveq	#0,d0
		rts

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		* d0: caractre
		* =>A0: modifi
		* =>D0=0 pas d'erreur 
		*-------------*
		dc.b	"Bconout CON"
		cnop	0,16

con_out
		and	#$ff,d0

		lea	esc_on(pc),a0
		tst.b	(a0)
		bne.s	.escape

		tst.b	esc_long(pc)
		bne.s	.escape_long

		cmp	#32,d0
	ifne	cmp_routs
		bhs	.normal
		cmp	#8,d0
		beq	code_bs
		cmp	#10,d0
		beq	code_lf
		cmp	#13,d0
		beq	code_cr
		cmp	#27,d0
		beq	code_esc
		
		bra.s	.normal
	else
		bhs.s	.normal
		jmp	([.routs.w,pc,d0*4])
	endc
.escape
		sf	(a0)
	ifeq	cmp_esc
		sub	#"A",d0
		bmi	.dummy_esc
		and	#$3f,d0
	endc
		move	d0,esc_code
	ifne	cmp_esc
		cmp	#"E",d0
		beq	esc_e
		cmp	#"J",d0
		beq	esc_j
		cmp	#"K",d0
		beq	esc_k
		cmp	#"Y",d0
		beq	esc_y
		cmp	#"b",d0
		beq	esc_bb
		cmp	#"c",d0
		beq	esc_cc
		cmp	#"p",d0
		beq	esc_pp
		cmp	#"q",d0
		beq	esc_qq
		
		sf	esc_long
		rts
	else
		jmp	([.routs_esc.w,pc,d0*4])
	endc
.escape_long
		move	d0,esc_data
		move	esc_code(pc),d0

	ifne	cmp_esc
		cmp	#"Y",d0
		beq	esc_y
		cmp	#"b",d0
		beq	esc_bb
		cmp	#"c",d0
		beq	esc_cc
		
		rts
	else
		
		jmp	([.routs_esc.w,pc,d0*4])
	endc
		*-------------*
.normal
		movem.l	d1-3/a1-3,-(sp)

		movem.l	cur_size(pc),d1/a0-3	;cur_data+cur_adr+cur_bwidth
					;+cur_rout

		jsr	(a3)

		move	curx(pc),d1
		add	#1,d1
		cmp	cur_w(pc),d1
		blt.s	.in
		tst.b	cur_over(pc)
		bne	over
		bra.s	.out
.in
		move	d1,curx
		add.l	d0,cur_adr

		move.l	cur_mask(pc),d0
		ror.l	#8,d0
		move.l	d0,cur_mask
.out

		movem.l	(sp)+,d1-3/a1-3
		moveq	#0,d0
		rts

	ifeq	cmp_routs
		*-------------*
		cnop	0,16
.routs
		dc.l	normal	;0
		dc.l	normal
		dc.l	normal
		dc.l	normal
		dc.l	normal
		dc.l	normal	;5
		dc.l	normal
		dc.l	code_bel
		dc.l	code_BS
		dc.l	code_TAB
		dc.l	code_LF	;10
		dc.l	code_VT
		dc.l	code_FF
		dc.l	code_CR
		dc.l	normal
		dc.l	normal	;15
		dc.l	normal
		dc.l	normal
		dc.l	normal
		dc.l	normal
		dc.l	normal	;20
		dc.l	normal
		dc.l	normal
		dc.l	normal
		dc.l	normal
		dc.l	normal	;25
		dc.l	normal
		dc.l	code_esc
		dc.l	normal
		dc.l	normal
		dc.l	normal	;30
		dc.l	normal
	endc

	ifeq	cmp_esc
		*-------------*
		cnop	0,16
.routs_esc
		*MAJUSCULE
	
	ifeq	esc_lite
		dc.l	esc_A	65-65=0
		dc.l	esc_B
		dc.l	esc_C
		dc.l	esc_D
	else
		dc.l	.dummy_esc	;A
		dc.l	.dummy_esc	;B
		dc.l	.dummy_esc	;C
		dc.l	.dummy_esc	;D
	endc
		dc.l	esc_E
		dc.l	.dummy_esc	;F
		dc.l	.dummy_esc	;G
	
	ifeq	esc_lite
		dc.l	esc_H
		dc.l	esc_I
	else
		dc.l	.dummy_esc	;H
		dc.l	.dummy_esc	;I
	endc
		dc.l	esc_J
		dc.l	esc_K
		
	ifeq	esc_lite
		dc.l	esc_L
		dc.l	esc_M
	else
		dc.l	.dummy_esc	;L
		dc.l	.dummy_esc	;M
	endc
		dc.l	.dummy_esc	;N
		dc.l	.dummy_esc	;O
		dc.l	.dummy_esc	;P
		dc.l	.dummy_esc	;Q
		dc.l	.dummy_esc	;R
		dc.l	.dummy_esc	;S
		dc.l	.dummy_esc	;T
		dc.l	.dummy_esc	;U
		dc.l	.dummy_esc	;V
		dc.l	.dummy_esc	;W
		dc.l	.dummy_esc	;X
		dc.l	esc_Y
		dc.l	.dummy_esc	;Z
		* trou...
		dc.l	.dummy_esc	;[
		dc.l	.dummy_esc	;\
		dc.l	.dummy_esc	;]
		dc.l	.dummy_esc	;^
		dc.l	.dummy_esc	;_
		dc.l	.dummy_esc	;`
		* minuscule
		dc.l	.dummy_esc	;a
		dc.l	esc_bb
		dc.l	esc_cc
		
	ifeq	esc_lite
		dc.l	esc_dd
	else
		dc.l	.dummy_esc	;d
	endc
		dc.l	.dummy_esc	;e
		dc.l	.dummy_esc	;f
		dc.l	.dummy_esc	;g
		dc.l	.dummy_esc	;h
		dc.l	.dummy_esc	;i
	ifeq	esc_lite
		dc.l	esc_jj
		dc.l	esc_kk
		dc.l	esc_ll
	else
		dc.l	.dummy_esc	;j
		dc.l	.dummy_esc	;k
		dc.l	.dummy_esc	;l
	endc
		dc.l	.dummy_esc	;m
		dc.l	.dummy_esc	;n
	ifeq	esc_lite
		dc.l	esc_oo
	else
		dc.l	.dummy_esc	;o
	endc
		dc.l	esc_pp
		dc.l	esc_qq
		dc.l	.dummy_esc	;r
		dc.l	.dummy_esc	;s
		dc.l	.dummy_esc	;t
		dc.l	.dummy_esc	;u
	ifeq	esc_lite
		dc.l	esc_vv
		dc.l	esc_ww
	else
		dc.l	.dummy_esc	;v
		dc.l	.dummy_esc	;w
	endc
		dc.l	.dummy_esc	;x
		dc.l	.dummy_esc	;y
		dc.l	.dummy_esc	;z
		* trou...
		dc.l	.dummy_esc	;{
		dc.l	.dummy_esc	;|
		dc.l	.dummy_esc	;}
		dc.l	.dummy_esc	;~
		dc.l	.dummy_esc	;
		dc.l	.dummy_esc	;: 127-65=62=>63 ($3f)
	endc

	ifeq	cmp_esc
		*-------------*

		cnop	0,16
.dummy_esc
		moveq	#0,d0
		rts
	endc
		*-------------*
		cnop	0,16
over
		move	cury(pc),d0
		add	#1,d0
		cmp	cur_h(pc),d0
		beq.s	.out
.end_over
		move	d0,cury
		move.l	cur_lwidth(pc),d1
		mulu	d0,d1
		add.l	cur_adr0(pc),d1
		move.l	d1,cur_adr

		clr	curx
		move.l	#$00ff00ff,cur_mask


		movem.l	(sp)+,d1-3/a1-3
		moveq	#0,d0
		rts
.out
		move	d0,d1
		sub	#1,d1
		moveq	#1,d0
		moveq	#0,d2
		bsr	cur_scroll

		moveq	#0,d0
		move	cury(pc),d1
		move	cur_w(pc),d2
		sub	#1,d2
		move	d1,d3

		bsr	cur_clear

		move	d1,d0
		bra	.end_over

	ifeq	cmp_routs
		*-------------*
		cnop	0,16
code_bel
		rts
	endc
		*-------------*
		cnop	0,16
code_bs
		move	curx(pc),d0
		beq	.fin


		move.l	d1,-(sp)

		move.l	#$00ff00ff,d1

		sub	#1,d0
		move	d0,curx
		move.l	cur_adr0(pc),a0
		lsr	#1,d0
		bcc.s	.pas_plus
		addq	#1,a0
		ror.l	#8,d1
.pas_plus
		move.l	d1,cur_mask

		mulu	cur_plane(pc),d0
		add.l	d0,a0
		add.l	d0,a0
		move.l	cur_lwidth(pc),d0
		mulu	cury(pc),d0
		add.l	d0,a0
		move.l	a0,cur_adr

		move.l	(sp)+,d1

.fin
		moveq	#0,d0
		rts

	ifeq	cmp_routs
		*-------------*
		cnop	0,16
code_tab

		move	curx(pc),d0
		add	curtab(pc),d0
		and	curtabcut(pc),d0
		cmp	cur_w(pc),d0
		blo.s	.in
		move	cur_w(pc),d0
		sub	#1,d0
.in
		move	d0,curx
		move.l	cur_adr0(pc),a0
		lsr	#1,d0
		bcc.s	.pas_plus
		addq	#1,a0
		move.l	#$ff00ff00,cur_mask
		bra.s	.plus
.pas_plus
		move.l	#$00ff00ff,cur_mask
.plus
		mulu	cur_plane(pc),d0
		add.l	d0,a0
		add.l	d0,a0
		move.l	cur_lwidth(pc),d0
		mulu	cury(pc),d0
		add.l	d0,a0
		move.l	a0,cur_adr


		moveq	#0,d0
		rts
	endc
		*-------------*
		cnop	0,16
code_lf
code_vt
code_ff
		move	cury(pc),d0
		add	#1,d0
		cmp	cur_h(pc),d0
		beq.s	.out
		move	d0,cury
		move.l	cur_lwidth(pc),d0
		add.l	d0,cur_adr


		moveq	#0,d0
		rts
.out
		movem.l	d1-3,-(sp)

		move	d0,d1
		sub	#1,d1
		moveq	#1,d0
		moveq	#0,d2
		bsr	cur_scroll

		moveq	#0,d0
		move	cury(pc),d1
		move	cur_w(pc),d2
		sub	#1,d2
		move	d1,d3

		bsr	cur_clear


		movem.l	(sp)+,d1-3
		moveq	#0,d0

		rts

		*-------------*
		cnop	0,16
code_cr
		clr	curx
		move.l	cur_lwidth(pc),d0
		mulu	cury(pc),d0
		add.l	cur_adr0(pc),d0
		move.l	d0,cur_adr
		move.l	#$00ff00ff,cur_mask


		moveq	#0,d0
		rts

		*-------------*
		cnop	0,16
code_esc
		st	esc_on
		moveq	#0,d0
		rts

		*-------------*
	ifeq	esc_lite
		cnop	0,16
esc_A
		move	cury(pc),d0
		beq.s	.fin


		sub	#1,d0
		move	d0,cury
		move.l	cur_lwidth(pc),d0
		sub.l	d0,cur_adr

.fin
		moveq	#0,d0
		rts

		*-------------*
		cnop	0,16
esc_B
		move	cury(pc),d0
		add	#1,d0
		cmp	cur_h(pc),d0
		bge.s	.fin


		move	d0,cury
		move.l	cur_lwidth(pc),d0
		add.l	d0,cur_adr

.fin
		moveq	#0,d0
		rts

		*-------------*
		cnop	0,16
esc_C
		move	curx(pc),d0
		add	#1,d0
		cmp	cur_w(pc),d0
		bge	.fin


		move.l	d1,-(sp)
		move.l	#$00ff00ff,d1

		move	d0,curx
		move.l	cur_adr0(pc),a0
		lsr	#1,d0
		bcc.s	.pas_plus
		addq	#1,a0
		ror.l	#8,d1
.pas_plus
		move.l	d1,cur_mask
		mulu	cur_plane(pc),d0
		add.l	d0,a0
		add.l	d0,a0
		move.l	cur_lwidth(pc),d0
		mulu	cury(pc),d0
		add.l	d0,a0
		move.l	a0,cur_adr

		move.l	(sp)+,d1

.fin
		moveq	#0,d0
		rts
		*-------------*
		cnop	0,16
esc_D
		move	curx(pc),d0
		beq	.fin


		move.l	d1,-(sp)

		move.l	#$00ff00ff,d1

		sub	#1,d0
		move	d0,curx
		move.l	cur_adr0(pc),a0
		lsr	#1,d0
		bcc.s	.pas_plus
		addq	#1,a0
		ror.l	#8,d1
.pas_plus
		move.l	d1,cur_mask

		mulu	cur_plane(pc),d0
		add.l	d0,a0
		add.l	d0,a0
		move.l	cur_lwidth(pc),d0
		mulu	cury(pc),d0
		add.l	d0,a0
		move.l	a0,cur_adr

		move.l	(sp)+,d1
.fin
		moveq	#0,d0
		rts
	endc

		*-------------*
		cnop	0,16
esc_E
		movem.l	d1-3,-(sp)
		moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d2
		move	cur_w(pc),d2
		sub	#1,d2
		move	cur_h(pc),d3
		sub	#1,d3


		bsr	cur_clear

		clr.l	curx
		move.l	cur_adr0(pc),cur_adr
		move.l	#$00ff00ff,cur_mask


		movem.l	(sp)+,d1-3
		moveq	#0,d0
		rts

		*-------------*
	ifeq	esc_lite
		cnop	0,16
esc_H
		clr.l	curx
		move.l	cur_adr0(pc),cur_adr
		move.l	#$00ff00ff,cur_mask


		moveq	#0,d0
		rts

		*-------------*
		cnop	0,16
esc_I
		move	cury(pc),d0
		bne.s	.pas_scroll

		movem.l	d1-3,-(sp)

		moveq	#0,d0
		move	cur_h(pc),d1
		sub	#2,d1
		moveq	#-1,d2

		bsr	cur_scroll

		moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d2
		move	cur_w(pc),d2
		sub	#1,d2
		moveq	#0,d3

		bsr	cur_clear


		movem.l	(sp)+,d1-3
		moveq	#0,d0
		rts
.pas_scroll
		sub	#1,d0
		move	d0,cury
		move.l	cur_lwidth(pc),d0
		sub.l	d0,cur_adr


		moveq	#0,d0
		rts
	endc
		*-------------*
		cnop	0,16
esc_J

		movem.l	d1-3,-(sp)

		move	curx(pc),d0
		move	cury(pc),d1
		moveq	#0,d2
		move	cur_w(pc),d2
		sub	#1,d2
		move	cur_h(pc),d3
		sub	#1,d3

		bsr	cur_clear


		movem.l	(sp)+,d1-3
		moveq	#0,d0
		rts

		*-------------*
		cnop	0,16
esc_K

		movem.l	d1-3,-(sp)

		move	curx(pc),d0
		move	cury(pc),d1
		moveq	#0,d2
		move	cur_w(pc),d2
		sub	#1,d2
		move	d1,d3

		bsr	cur_clear


		movem.l	(sp)+,d1-3
		moveq	#0,d0
		rts

		*-------------*
	ifeq	esc_lite
		cnop	0,16
esc_L
		movem.l	d1-3,-(sp)

		move	cury(pc),d0
		move	cur_h(pc),d1
		sub	#1,d1
		cmp	d1,d0
		beq.s	.pas_scroll

		sub	#1,d1
		moveq	#-1,d2
		bsr	cur_scroll
.pas_scroll
		moveq	#0,d0
		move	d0,curx
		move	cury(pc),d1
		moveq	#0,d2
		move	cur_w(pc),d2
		sub	#1,d2
		move	d1,d3

		bsr	cur_clear

		move.l	cur_adr0(pc),a0
		move.l	cur_lwidth(pc),d0
		mulu	cury(pc),d0
		add.l	d0,a0
		move.l	a0,cur_adr

		move.l	#$00ff00ff,cur_mask


		movem.l	(sp)+,d1-3
		moveq	#0,d0

		rts

		*-------------*
		cnop	0,16
esc_M
		movem.l	d1-3,-(sp)

		move	cury(pc),d0
		move	cur_h(pc),d1
		sub	#1,d1
		cmp	d1,d0
		beq.s	.pas_scroll

		add	#1,d0
		moveq	#0,d2

		bsr	cur_scroll
.pas_scroll
		moveq	#0,d0
		move	d0,curx
		move	cur_h(pc),d1
		sub	#1,d1
		moveq	#0,d2
		move	cur_w(pc),d2
		sub	#1,d2
		move	d1,d3

		bsr	cur_clear

		move.l	cur_adr0(pc),a0
		move.l	cur_lwidth(pc),d0
		mulu	cury(pc),d0
		add.l	d0,a0
		move.l	a0,cur_adr

		move.l	#$00ff00ff,cur_mask


		movem.l	(sp)+,d1-3
		moveq	#0,d0

		rts
	endc
		*-------------*
		cnop	0,16
esc_Y
		lea	esc_long(pc),a0
		tst.b	(a0)
		bne.s	.xy
		st	(a0)
		rts
.xy
		move.l	d1,-(sp)
		
		move	esc_data(pc),d0

		tst.b	.x_ok
		bne.s	.x
		st	.x_ok
.y

		sub	#" ",d0
		bpl.s	.oky
		moveq	#0,d0
.oky
		cmp	cur_h(pc),d0
		blt.s	.oky2
		move	cur_h(pc),d0
		sub	#1,d0
.oky2
		move	d0,cury

		move.l	cur_adr0(pc),a0
		move.l	cur_lwidth(pc),d1
		mulu	d0,d1
		add.l	d1,a0
		move.l	a0,cur_adr

		move.l	(sp)+,d1
		moveq	#0,d0
		rts
.x
		sf	(a0)
		sf	.x_ok

		sub	#" ",d0
		bpl.s	.okx
		moveq	#0,d0
.okx
		cmp	cur_w(pc),d0
		blt.s	.okx2
		move	cur_w(pc),d0
		sub	#1,d0
.okx2
		move	d0,curx

		move.l	#$00ff00ff,d1

		move.l	cur_adr(pc),a0
		lsr	#1,d0
		bcc.s	.pas_plus
		addq	#1,a0
		ror.l	#8,d1
.pas_plus
		move.l	d1,cur_mask

		mulu	cur_plane(pc),d0
		add.l	d0,a0
		add.l	d0,a0
		move.l	a0,cur_adr


		move.l	(sp)+,d1
		moveq	#0,d0
		rts

.x_ok		dc.b	0
		even

		*-------------*
		cnop	0,16
esc_bb
		lea	esc_long(pc),a0
		tst.b	(a0)
		seq	(a0)
		bne.s	.fcol
		moveq	#0,d0
		rts
.fcol
		movem.l	d1-6,-(sp)
		move	esc_data(pc),d0
		and	#$f,d0
		move	d0,cur_fcol

		move	cur_bcol(pc),d1
		jmp	([cur_colxx.w,pc])

		*-------------*
		cnop	0,16
esc_cc
		lea	esc_long(pc),a0
		tst.b	(a0)
		seq	(a0)
		bne.s	.bcol
		moveq	#0,d0
		rts
.bcol
		movem.l	d1-6,-(sp)
		move	esc_data(pc),d1
		and	#$f,d1
		move	d1,cur_bcol
		move	cur_fcol(pc),d0

		jmp	([cur_colxx.w,pc])

		*-------------*
	ifeq	esc_lite
		cnop	0,16
esc_dd
		movem.l	d1-3,-(sp)

		moveq	#0,d2
		move	curx(pc),d2
		move	cury(pc),d3
		sub	#1,d2
		bpl.s	.xin
		move	cur_w(pc),d2
		sub	#1,d2
		subq	#1,d3
		bmi.s	.fin
.xin
		moveq	#0,d0
		moveq	#0,d1
		move.l	#$00ff00ff,cur_mask

		bsr	cur_clear
.fin
		movem.l	(sp)+,d1-3
		moveq	#0,d0
		rts

		*-------------*
		cnop	0,16
esc_jj
		move.l	curx(pc),save_cur
		move.l	cur_adr(pc),save_cur_adr
		move.l	cur_mask(pc),save_cur_mask
		moveq	#0,d0
		rts

		*-------------*
		cnop	0,16
esc_kk
		move.l	save_cur(pc),curx
		move.l	save_cur_adr(pc),cur_adr
		move.l	save_cur_mask(pc),cur_mask


		moveq	#0,d0
		rts

		*-------------*
		cnop	0,16
esc_ll

		movem.l	d1-3,-(sp)

		move.l	cur_adr0(pc),a0
		move.l	cur_lwidth(pc),d0
		move	cury(pc),d1
		mulu	d1,d0
		add.l	d0,a0
		move.l	a0,cur_adr

		moveq	#0,d0
		move	d0,curx
		moveq	#0,d2
		move	cur_w(pc),d2
		sub	#1,d2
		move	d1,d3

		bsr	cur_clear
.fin
		move.l	#$00ff00ff,cur_mask


		movem.l	(sp)+,d1-3
		moveq	#0,d0
		rts

		*-------------*
		cnop	0,16
esc_oo
		movem.l	d1-3,-(sp)

		moveq	#0,d2
		move	curx(pc),d2
		beq.s	.fin


		moveq	#0,d0
		move	cury(pc),d1
		sub	#1,d2
		move	d1,d3

		bsr	cur_clear

.fin
		movem.l	(sp)+,d1-3
		moveq	#0,d0
		rts

	endc
		*-------------*
		cnop	0,16
esc_pp
		st	cur_inv

		moveq	#0,d0
		rts

		*-------------*
		cnop	0,16
esc_qq
		sf	cur_inv

		moveq	#0,d0
		rts

	ifeq	esc_lite
		*-------------*
		cnop	0,16
esc_vv
		st	cur_over
		moveq	#0,d0
		rts

		*-------------*
		cnop	0,16
esc_ww
		sf	cur_over
		moveq	#0,d0
		rts
	endc

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		* Effacement de caractres
		*-------------*
		* D0&D1: position du premier caractre  effacer
		* D2&D3: position du dernier caractre  effacer
		cnop	0,16
cur_clear
		cmp	d1,d3
		bne.s	.sup1

		jsr	([cur_lclr.w,pc])	;d0=x1,d1=y,d2=x2

		rts

	* au moins 2 lignes
.sup1
		tst	d0
		beq.s	.blocsup

	* 1er ligne non complete
		jsr	([cur_lclr.w,pc])
		add	#1,d1
	* bloc de lignes  vider
.do_bloc
		jsr	([cur_bclr.w,pc])	;d1=y1,d3=y2

		rts

	* premire ligne  vider entirement
.blocsup
		move	cur_w(pc),d0
		subq	#1,d0
		cmp	d2,d0
		beq.s	.do_bloc

		sub	#1,d3
	* blocs de lignes entire moins la dernire
		jsr	([cur_bclr.w,pc])	;d1=y1,d3=y2

	* dernire ligne non complte
		add	#1,d3
		move	d3,d1
		moveq	#0,d0
		jsr	([cur_lclr.w,pc])

		rts

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		* Scroll de l'cran texte
		*-------------*
		* D0: ligne ou dbute le scroll
		* D1: ligne ou fini le scroll
		* D2: sens du scroll
		*	 0: vers le haut
		*	-1: vers le bas
		cnop	0,16
cur_scroll
		movem.l	d0-2/a0-1,-(sp)

		tst	d2
		bmi.s	.bas

		tst	d0
		bne.s	.ok
		tst	d1
		beq.s	.haut_fond
.ok
		sub	#1,d0
		sub	d0,d1

		move.l	cur_adr0(pc),a0
		move.l	cur_lwidth(pc),d2
		mulu	d2,d0
		add.l	d0,a0

		move.l	a0,a1
		add.l	d2,a1

		mulu	d2,d1
		lsr.l	#4,d1
		subq	#1,d1
.copie_haut
		move.l	(a1)+,(a0)+
		move.l	(a1)+,(a0)+
		move.l	(a1)+,(a0)+
		move.l	(a1)+,(a0)+
		subq.l	#1,d1
		bpl.s	.copie_haut
.haut_fond
		movem.l	(sp)+,d0-2/a0-1
		rts
.bas
		move	cur_h(pc),d2
		sub	#1,d2
		cmp	d0,d2
		beq.s	.bas_fond
		cmp	d1,d2
		bne.s	.ok2
		sub	#1,d1
.ok2
		move	d1,d2
		sub	d0,d1
		add	#1,d1
		move.l	cur_lwidth(pc),d0
		mulu	d0,d1
		lsr.l	#4,d1
		subq	#1,d1

		move.l	cur_adr0(pc),a1
		move.l	d0,a0
		add	#1,d2
		mulu	d2,d0
		add.l	d0,a1

		add.l	a1,a0
.copie_bas
		move.l	-(a1),-(a0)
		move.l	-(a1),-(a0)
		move.l	-(a1),-(a0)
		move.l	-(a1),-(a0)
		subq.l	#1,d1
		bpl.s	.copie_bas

.bas_fond
		movem.l	(sp)+,d0-2/a0-1
		rts

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		* Routines de trac d'un caractres
		*-------------*
		* A0: data de la fonte
		* A1: destination
		* A2: offset de ligne
		* D0: caractre
		* D1: hauteur du caractre
		* D2,D3 et A3 libre

		cnop	0,16
cur_routs
		dc.l	cur_1
		dc.l	0
		dc.l	0
		dc.l	cur_4

		*-------------*
		cnop	0,16
cur_1
		lsl	#3,d0
		add	d0,a0
		cmp	#8,d1
		beq.s	.8

		add	d0,a0
.8
		sub	#1,d1

		tst.b	cur_noir(pc)
		beq.s	.cols

		tst.b	cur_inv(pc)
		bne.s	.blanc
.noir
		move.b	(a0)+,(a1)
		add.l	a2,a1
		dbra	d1,.noir

		moveq	#1,d0
		rts
.blanc
		move.b	(a0)+,d0
		not.b	d0
		move.b	d0,(a1)
		add.l	a2,a1
		dbra	d1,.blanc

		moveq	#1,d0
		rts
.cols
		tst	cur_mcols+2*4(pc)
		beq.s	.pas_car
		tst	cur_inv(pc)
		beq.s	.blanc
		bra.s	.noir
.pas_car
		move	cur_mcols+3*4(pc),d0
		tst.b	cur_inv(pc)
		beq.s	.ok_d0
		not	d0
.ok_d0
.plein
		move.b	d0,(a1)
		add.l	a2,a1
		dbra	d1,.plein

		moveq	#1,d0
		rts

		*-------------*
		cnop	0,16
cur_4
		lsl	#3,d0
		add	d0,a0
		cmp	#8,d1
		beq.s	.8

		add	d0,a0
.8
		sub	#1,d1

		tst.b	cur_noir(pc)
		beq.s	.cols

		tst.b	cur_inv(pc)
		bne.s	.blanc
.noir
		move.b	(a0)+,d0
		move.b	d0,(a1)
		move.b	d0,2(a1)
		move.b	d0,4(a1)
		move.b	d0,6(a1)

		add.l	a2,a1
		dbra	d1,.noir
		move.l	a1,d0
		btst	#0,d0
		bne	.nxt_plane

		moveq	#1,d0
		rts
.blanc
		move.b	(a0)+,d0
		not.b	d0
		move.b	d0,(a1)
		move.b	d0,2(a1)
		move.b	d0,4(a1)
		move.b	d0,6(a1)

		add.l	a2,a1
		dbra	d1,.blanc
		move.l	a1,d0
		btst	#0,d0
		bne	.nxt_plane

		moveq	#1,d0
		rts
.cols
		movem.l	d2-7/a4,-(sp)
		movem.l	cur_mcols(pc),d4-d7/a4
		bclr	#31,d1
		move.l	a1,d0
		btst	#0,d0
		beq.s	.paire
		and	#$fffe,d0
		move.l	d0,a1
		sub	#1,a0
		bset	#31,d1
.paire
		move.l	a4,d0
		not.l	d0
		and.l	d0,d4
		and.l	d0,d5
		and.l	d0,d6
		and.l	d0,d7

		tst.b	cur_inv(pc)
		bne.s	.nxt_line2
.nxt_line
		move	(a0),d2
		swap	d2
		move	(a0),d2
		move.l	d2,d3
		add	#1,a0

		and.l	d4,d2
		eor.l	d6,d2
		and.l	d5,d3
		eor.l	d7,d3

		move.l	a4,d0
		and.l	(a1),d0
		or.l	d2,d0
		move.l	d0,(a1)

		move.l	a4,d0
		and.l	4(a1),d0
		or.l	d3,d0
		move.l	d0,4(a1)

		add.l	a2,a1

		dbra	d1,.nxt_line

		movem.l	(sp)+,d2-7/a4

		btst	#31,d1
		bne.s	.nxt_plane
		moveq	#1,d0
		rts
.nxt_line2
		move	(a0),d2
		swap	d2
		move	(a0),d2
		not.l	d2
		move.l	d2,d3
		add	#1,a0

		and.l	d4,d2
		eor.l	d6,d2
		and.l	d5,d3
		eor.l	d7,d3

		move.l	a4,d0
		and.l	(a1),d0
		or.l	d2,d0
		move.l	d0,(a1)

		move.l	a4,d0
		and.l	4(a1),d0
		or.l	d3,d0
		move.l	d0,4(a1)

		add.l	a2,a1

		dbra	d1,.nxt_line2

		movem.l	(sp)+,d2-7/a4

		btst	#31,d1
		bne.s	.nxt_plane
		moveq	#1,d0
		rts
.nxt_plane
		moveq	#7,d0
		rts

		*-------------*

*-------------------------------------------------------------------------*

		*-------------*
		* Routine calculant le masque pour les couleurs
		*-------------*
		* d0=couleur de texte
		* d1=couleur de fond
		*  il faut avoir sauvegard d1-6
		cnop	0,16
cols_xxtab
		dc.l	cols_1	;a commence  1
		dc.l	0
		dc.l	0
		dc.l	cols_4

		*-------------*
		cnop	0,16
cols_1
		movem.l	(sp)+,d1-6
		moveq	#0,d0
		rts

		*-------------*
		cnop	0,16
cols_4
		sf	cur_noir

		and	#$f,d0
		and	#$f,d1

		cmp	#$f,d0
		bne.s	.cont
		tst	d1
		bne.s	.cont
		st	cur_noir
.cont
		lsr	d0
		subx.l	d2,d2
		lsr	d1
		subx.l	d4,d4

		lsr	d0
		subx	d2,d2
		lsr	d1
		subx	d4,d4
		eor.l	d4,d2

		lsr	d0
		subx.l	d3,d3
		lsr	d1
		subx.l	d5,d5

		lsr	d0
		subx	d3,d3
		lsr	d1
		subx	d5,d5
		eor.l	d5,d3

		movem.l	d2-5,cur_mcols	;masque de couleur
.fin
		movem.l	(sp)+,d1-6
		moveq	#0,d0
		rts

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		* Routines d'effacement d'une ligne non complte
		*-------------*
		* D0: x1
		* D1: y
		* D2: x2

		cnop	0,16
cur_lclrs
		dc.l	lclr_1
		dc.l	0
		dc.l	0
		dc.l	lclr_4

		*-------------*
		cnop	0,16
lclr_1
		movem.l	d0-3/a0-2,-(sp)

		move	cur_mcols+3*4(pc),d3
		sub	d0,d2
		add	#1,d2

		move.l	cur_adr0(pc),a1
		lsr	#1,d0
		bcc.s	.pas_plus
		addq	#1,a1
.pas_plus
		add	d0,a1
		add	d0,a1
		move.l	cur_lwidth(pc),d0
		mulu	d1,d0
		add.l	d0,a1

		move.l	cur_bwidth(pc),a2

		move.l	a1,d0
		btst	#0,d0
		beq.s	.gros

		move	cur_size+2(pc),d0
		subq	#1,d0
		move.l	a1,a0
.clr1
		move.b	d3,(a0)
		add.l	a2,a0
		dbra	d0,.clr1

		addq.l	#1,a1
		sub	#1,d2
		beq.s	.fin
.gros
		ror.l	#1,d2
		sub	#1,d2
		move	cur_size+2(pc),d1
		subq	#1,d1
.gros_clr
		move	d2,d0
		move.l	a1,a0
.clr2
		move	d3,(a0)+
		dbra	d0,.clr2
		add.l	a2,a1
		dbra	d1,.gros_clr

		rol.l	#1,d2
		bcc.s	.fin

		move	cur_size+2(pc),d0
		subq	#1,d0
.clr3
		move.b	d3,(a0)
		sub.l	a2,a0
		dbra	d0,.clr3
.fin
		movem.l	(sp)+,d0-3/a0-2
		rts

		*-------------*
		cnop	0,16
lclr_4
		movem.l	d0-4/a0-2,-(sp)

		move.l	cur_mcols+2*4(pc),d3
		move.l	cur_mcols+3*4(pc),d4
		sub	d0,d2
		add	#1,d2

		move.l	cur_adr0(pc),a1
		lsr	#1,d0
		bcc.s	.pas_plus
		addq	#1,a1
.pas_plus
		lsl	#3,d0
		add	d0,a1

		move.l	cur_lwidth(pc),d0
		mulu	d1,d0
		add.l	d0,a1

		move.l	cur_bwidth(pc),a2

		move.l	a1,d0
		btst	#0,d0
		beq.s	.gros

		move	cur_size+2(pc),d0
		subq	#1,d0
		move.l	a1,a0
.clr1
		swap	d3
		move.b	d3,(a0)
		swap	d3
		move.b	d3,2(a0)
		swap	d4
		move.b	d4,4(a0)
		swap	d4
		move.b	d4,6(a0)

		add.l	a2,a0
		dbra	d0,.clr1

		addq.l	#7,a1
		sub	#1,d2
		beq.s	.fin
.gros
		ror.l	#1,d2
		sub	#1,d2
		move	cur_size+2(pc),d1
		subq	#1,d1
.gros_clr
		move	d2,d0
		move.l	a1,a0
.clr2
		move.l	d3,(a0)+
		move.l	d4,(a0)+
		dbra	d0,.clr2
		add.l	a2,a1
		dbra	d1,.gros_clr

		rol.l	#1,d2
		bcc.s	.fin

		move	cur_size+2(pc),d0
		subq	#1,d0
.clr3
		swap	d3
		move.b	d3,(a0)
		swap	d3
		move.b	d3,2(a0)

		swap	d4
		move.b	d4,4(a0)
		swap	d4
		move.b	d4,6(a0)

		sub.l	a2,a0
		dbra	d0,.clr3
.fin
		movem.l	(sp)+,d0-4/a0-2
		rts

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		* Routines d'effacement de lignes
		*-------------*
		* D1: y1
		* D3: y2

		cnop	0,16
cur_bclrs
		dc.l	bclr_1
		dc.l	bclr_2
		dc.l	0
		dc.l	bclr_4

		*-------------*
		cnop	0,16
bclr_1
bclr_2
		movem.l	d0/d3/a0,-(sp)

		tst.b	cur_noir(pc)
		beq.s	.col

		move.l	cur_adr0(pc),a0
		move.l	cur_lwidth(pc),d0
		add	#1,d3
		mulu	d3,d0
		add.l	d0,a0

		sub	d1,d3

		move.l	cur_lwidth(pc),d0
		mulu	d3,d0
		lsr.l	#4,d0
		subq	#1,d0
.clr0
		clr.l	-(a0)
		clr.l	-(a0)
		clr.l	-(a0)
		clr.l	-(a0)
		subq.l	#1,d0
		bpl.s	.clr0

		movem.l	(sp)+,d0/d3/a0
		rts
.col
		move.l	cur_adr0(pc),a0
		move.l	cur_lwidth(pc),d0
		mulu	d1,d0
		add.l	d0,a0

		sub	d1,d3
		add	#1,d3

		move.l	cur_lwidth(pc),d0
		mulu	d3,d0
		lsr.l	#4,d0
		subq	#1,d0

		move.l	cur_mcols+3*4(pc),d3
.clr
		move.l	d3,(a0)+
		move.l	d3,(a0)+
		move.l	d3,(a0)+
		move.l	d3,(a0)+
		subq.l	#1,d0
		bpl.s	.clr

		movem.l	(sp)+,d0/d3/a0
		rts

		*-------------*
		cnop	0,16
bclr_4
		movem.l	d0/d3-4/a0,-(sp)

		tst.b	cur_noir(pc)
		beq.s	.col

		move.l	cur_adr0(pc),a0
		move.l	cur_lwidth(pc),d0
		add	#1,d3
		mulu	d3,d0
		add.l	d0,a0

		sub	d1,d3

		move.l	cur_lwidth(pc),d0
		mulu	d3,d0
		lsr.l	#4,d0
		subq	#1,d0
.clr0
		clr.l	-(a0)
		clr.l	-(a0)
		clr.l	-(a0)
		clr.l	-(a0)
		subq.l	#1,d0
		bpl.s	.clr0

		movem.l	(sp)+,d0/d3-4/a0
		rts
.col
		move.l	cur_adr0(pc),a0
		move.l	cur_lwidth(pc),d0
		mulu	d1,d0
		add.l	d0,a0

		sub	d1,d3
		add	#1,d3

		move.l	cur_lwidth(pc),d0
		mulu	d3,d0
		lsr.l	#4,d0
		subq	#1,d0

		move.l	cur_mcols+2*4(pc),d3
		move.l	cur_mcols+3*4(pc),d4
.clr
		move.l	d3,(a0)+
		move.l	d4,(a0)+
		move.l	d3,(a0)+
		move.l	d4,(a0)+
		subq.l	#1,d0
		bpl.s	.clr

		movem.l	(sp)+,d0/d3-4/a0
		rts

		*-------------*

*-------------------------------------------------------------------------*
*		DATA
*-------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
esc_on		dc.b	0
esc_long		dc.b	0
esc_code		dc.w	0
esc_data		dc.w	0

		*-------------*
		cnop	0,16
vars_gfx

cur_adr0		dc.l	0

cur_size		dc.l	0
cur_data		dc.l	0
cur_adr		dc.l	0
cur_bwidth	dc.l	0
cur_rout		dc.l	0
cur_lclr		dc.l	0
cur_bclr		dc.l	0
cur_draw		dc.l	0
cur_colxx		dc.l	0
cur_mcols		;dcb.l	4,0
		dcb.l	2,0
		dc.l	$fffffff
		dc.l	0
cur_mask		dc.l	0

cur_lwidth	dc.l	0

cur_w		dc.w	0
cur_h		dc.w	0
cur_plane		dc.w	0

cur_fcol_init	dc.w	blanc
cur_bcol_init	dc.w	noir
cur_fcol		dc.w	0
cur_bcol		dc.w	0

curx		dc.w	0
cury		dc.w	0

save_cur		dc.l	0
save_cur_adr	dc.l	0
save_cur_mask	dc.l	0

curtab		dc.w	8
curtabcut		dc.w	$fff8

cur_over		dc.b	0
cur_inv		dc.b	0
cur_noir		dc.b	0
		even

		*-------------*
		* bitmap de la fonte
		cnop	0,16
fonte
		incbin	FAB_8X16.DAT

		*-------------*

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*

		*-------------*

		*-------------*

*-------------------------------------------------------------------------*
