*----------------------------------------------------------------------------*
*		BOOT DE DOLMEN + MENU DE LA CENTURBO II
*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*


		OPT	nocase
		opt	O+
		opt	nowarn
		opt	noeven
		opt	odl
		OPT	X-
		opt	p=68030
		opt	p=68881

		include	..\FLASH.RS

	IFEQ	langue
		OUTPUT	D:\BIN\SETUPF.BIN
	ENDC
	IFEQ	langue-1
		OUTPUT	D:\BIN\SETUPE.BIN
	ENDC
	IFEQ	langue-2
		OUTPUT	D:\BIN\SETUPD.BIN
	ENDC


*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*

		*-------------*

		include	D:\DOLMEN\SOURCES\DOLMEN.RS
		
		*-------------*
		
		include	D:\DOLMEN\SOURCES\BORIS\BORIS.RS

		include	D:\DOLMEN\SOURCES\BORIS\CONSOLE\CONSOLE.RS
		include	D:\DOLMEN\SOURCES\BORIS\IKBD\IKBD.RS
		include	D:\DOLMEN\SOURCES\BORIS\VIDEL\VIDEL.RS
		include	D:\DOLMEN\SOURCES\BORIS\CECILE.BRS\SYS\SYSHEAD.RS
		
		*-------------*

		include	D:\DOLMEN\SOURCES\FLASH.CT2\SETUP\SETUP.RS
		
		*-------------*

size_conin	equ	32	* nb car*2

esc_lite		equ	1	;-849
cmp_esc		equ	1	;-256

cmp_routs		equ	1	;-343

*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*

		*-------------*
dolmen_boot
		move	#$2700,sr
		
	* init pointeur
		lea	pile(pc),a7	;je prends ma pile
		lea	fast_dol_start+dol_vars,a6	;rcupre le pointeur sur la zone mappe
					;les variables systmes
	* caches&Vbr
MC680xx_INIT
		move.l	#$808+$3111,d0	;vide les caches et les ractive
		movec.l	d0,CACR
		moveq	#0,d0
		movec.l	d0,VBR
		
		pmove.d	RegCRP(a6),CRP	; attention registre 64 bits !
		pmove.l	tc_pmmu_run(a6),TC		; et pan !

		pflusha
		
	* INITIALISATION HARD
		bsr	hard_init

	* INITIALISATION DU SOFT
		bsr	soft_init
		move.l	d0,d1		;erreur?

	* lance tout...
		move	#$2500,sr

		*-------------*
MENU_SETUP
		cmp.b	#"A",ct2_ok(a6)
		bne.s	.pas_a
		lea	fond_bleu(pc),a0
		bra.s	.pas_b
.pas_a
		lea	fond_cyan(pc),a0
.pas_b
		bsr	aff_txt
		
		* la flash a t change?
		tst.l	d1
		beq.s	.no_error
		
		lea	centek(pc),a0
		bsr	aff_txt
		
		lea	flash_change(pc),a0
		bsr	aff_txt
.boucle
		BSR	con_in
		
		cmp.b	#$39,d0
		beq.s	.no_error		;vraiment?
		cmp	#$0801,d0		;alt+esc
		bne.s	.boucle
		
		move.l	flash_addr,a7		;pile super
		jmp	flash_addr+flsh_header	;et hop gros reset
		
.no_error
		* Flash normal
		
		btst	#3,flags_boot(a6)	;on entre dans le setup en mode F3
		bne.s	.go
		
		tst.b	open_setup(a6)
		bne.s	.go

		btst	#5,flags_boot(a6)
		bne.s	.pas_setup
.go
		bsr	menu
		
		sf	open_setup(a6)	;on y reviendra pas
.pas_setup
		*-------------*
Init_postsetup
		bsr	hard_plus		;surtout en cas de modifs
		
		*-------------*
WHAT_BOOT
		lea	first_boot(a6),a0
		tst.b	(a0)
		bne.s	.allready
		st	(a0)
		
		btst	#4,flags_boot(a6)
		bne.s	.install_dolmen
.install_tos
		sf	dolmen_on(a6)
		btst	#3,flags_boot(a6)
		bne.s	.go_tos4
		
		bsr	install_tos
		bra.s	.go_tos7
.install_dolmen
		bsr	install_dolmen
		st	dolmen_on(a6)
		bra.s	.go_dolmen
.allready
		tst.b	dolmen_on(a6)
		beq.s	.tos_installed
.dolmen_installed
		btst	#4,flags_boot(a6)
		bne.s	.go_dolmen

		bra	.install_tos
.tos_installed
		btst	#4,flags_boot(a6)
		bne.s	.install_dolmen
		btst	#3,flags_boot(a6)
		bne.s	.go_tos4

		*-------------*
		* Tos patch (donc avec Fast-Ram)
.go_tos7
		jmp	([tos_ptr.w,a6])

		*-------------*
		* TOS brute de pomme sans rien et gauffre au reset !
		* (et pas de Fast-Ram)
.go_tos4
		move	#$2700,sr
		lea	.crash(pc),a0
		lea	BusError.w,a1
		moveq	#(.fin_crash-.crash)/4,d0
.copie_crash
		move.l	(a0)+,(a1)+
		dbra	d0,.copie_crash
		
		jmp	BusError.w
.crash		
		pmove.l   .pmmu_clr,tc
		pmove.l   .pmmu_clr,tt0
		pmove.l   .pmmu_clr,tt1

	* clr les Rams  chaque changement de systme
		clr.l	memvalid.w
		clr.l	memval2.w
		clr.l	memval3.w
		clr.l	ramvalid.w
		
		jmp	Romtos_addr+$3e	;aprs le reset
.pmmu_clr		dc.l	0

.fin_crash
		*-------------*
		* Le systme du futur (c'est peu de le dire :-) )
.go_dolmen
		jmp	([dolboot_ptr.w,a6])
		
		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
hard_init
	* configuration du combel
		bsr	read_nvm		;test et affecte les vars
					;sauf erreur
	* ym2149
		move.b	#port_mixer,ym_reg.w
		move.b	#port_a_dir+port_b_dir,ym_wd.w
		move.b	#port_a,ym_reg.w
		move.b	#speaker+strobe+drive_b+drive_a+drive_sel,ym_wd.w
		;move.b	#drive_b+drive_a+drive_sel,ym_wd.w

	* DMA sound system reset
		move	#$8,$ffff8936.w
		clr	$ffff8936.w

	* coupe les GPIOs
		move.w	#7,$ffff8940.w

	* ZILOG
		;wscca	#%11000000,9	;hard reset
		;wscca	#0,1		;coupe tout
		;wscca	#0,3
		;wscca	#0,5
		;wscca	#0,11
		;wscca	#$ff,12
		;wscca	#$ff,13
		;wscca	#0,14
		;wscca	#0,15

		;wsccb	#%11000000,9	;hard reset
				
		;wsccb	#0,1		;coupe tout
		;wsccb	#0,3
		;wsccb	#0,5
		;wsccb	#0,11
		;wsccb	#$ff,12
		;wsccb	#$ff,13
		;wsccb	#0,14
		;wsccb	#0,15
	
	* DSP
		clr.b	$ffffa200.w
	* ACIAS
		move.b	#%11,$fffffc00.w	;reset IKBD
		move.b	#%11,$fffffc04.w	;reset MIDI
	* MFP
		clr.b	MFP_BASE+AER.w
		clr.b	MFP_BASE+DDR.w
		clr.b	MFP_BASE+IERA.w
		clr.b	MFP_BASE+IERB.w
		clr.b	MFP_BASE+ISRA.w
		clr.b	MFP_BASE+ISRB.w
		clr.b	MFP_BASE+IMRA.w
		clr.b	MFP_BASE+IMRB.w
		move.b	#$48,MFP_BASE+VR.w
		clr.b	MFP_BASE+TACR.w
		clr.b	MFP_BASE+TBCR.w
		clr.b	MFP_BASE+TCDCR.w
		clr.b	MFP_BASE+TADR.w
		clr.b	MFP_BASE+TBDR.w
		clr.b	MFP_BASE+TCDR.w
		clr.b	MFP_BASE+TDDR.w

	* test prsence coprocesseur pour le menu
		sf	d0
		move.l	LineF.w,a1
		move.l	CoproProt.w,a2
		lea	.copro_err(pc),a0
		move.l	a0,LineF.w
		move.l	a0,CoproProt.w
		move.l	sp,a0

		fnop
		st	d0
.copro_err
		move.l	a0,sp
		move.l	a1,LineF.w
		move.l	a2,CoproProt.w
		move.b	d0,copro_ok

		*-------------*

		rts

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		* Initialise le combel(ste+blitter+cpu)
		* adaptateur vga, ws yamaha
		cnop	0,16
Hard_plus
		moveq	#~$25,d0
		and.b	$ffff8007.w,d0
		
	ifne	blit_100
		or.b	#$05,d0
	else
		or.b	#$01,d0		;ca c'est pour blitter demi-vitesse.... pour tests de ronan
	endc
		move.b	d0,$ffff8007.w

		move.l	ct2_val(a6),d0
		
	* coupe la clock externe
		btst	#4,flags_boot2(a6)
		beq.s	.keep_clock
		or.l	#clk_off,d0
		bra.s	.kill_clock
.keep_clock
		and.l	#~clk_off,d0
.kill_clock
	* ide
		btst	#2,flags_boot2(a6)
		beq.s	.no_idews
		or.l	#ide_ws,d0
		bra.s	.idews
.no_idews
		and.l	#~ide_ws,d0
.idews
	* dsp
		btst	#3,flags_boot2(a6)
		beq.s	.no_dspws
		or.l	#dsp_ws,d0
		bra.s	.dspws
.no_dspws
		and.l	#~dsp_ws,d0
.dspws
	* on crit?
		tst.b	d0
		beq.s	.no_wr
		
		clr.b	(d0.l)
.no_wr
		move.l	d0,ct2_val(a6)
		move.l	d0,romtos_copy+rom_ct2reg	;pour Magic...

		*-------------*
		
		rts
		
		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		* initialise les routines softs
		cnop	0,16
soft_init
		lea	MFP_BASE.w,a0
	* TIMERC
		or.b	#timerc,MFP_BASE+IERB.w
		or.b	#timerc,MFP_BASE+IMRB.w
		move.b	#$50,MFP_BASE+TCDCR.w	;div par 64=>38400Hz
		move.b	#$c0,MFP_BASE+TCDR.w	;compteur=2457600/64/200
					;compteur s'arrte  1
					;0=>interruption

		move	#20,_timer_ms.w	;20ms
		clr.l	_hz_200.w		;init

		move.l	#TIMER_C,TimerCint.w

		move.l	#dummy_rts,etv_timer.w	;gem etv

	* VIDEO
		bsr	INIT_VIDEO	;passe la bonne rsolution
					;et la palette
		bsr	put_pal
	* CLAVIER
		bsr	INIT_KBD

	* CONSOLE
		bsr	INIT_CONSOLE

	* MISE A JOUR DES VARIABLES EXTERNES
		lea	ext_vars(pc),a0
		lea	videovars(a6),a1
		moveq	#(ConvDec-VideoVars)/4,d0
.copie_vars
		move.l	(a0)+,(a1)+
		dbra	d0,.copie_vars


	* calcul de la Checksum => d0 vaut 0 si tout est ok
		lea	flash_addr,a0
		moveq	#0,d0
		move.l	#flash_size/4,d2
.checksum
		add.l	(a0)+,d0
		subq.l	#1,d2
		bne.s	.checksum
		
		move.l	flh_checksum(a6),d1
		move.l	d0,flh_checksum_cal(a6)
		sub.l	d1,d0	;doit tre gale  d1 si ok
		sub.l	d1,d0	;0 si c'est bon
		
		*-------------*
		
		rts

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		dc.b	"Dummy rts"
		cnop	0,16
dummy_rts
		RTS

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		dc.b	"TIMERC"
		cnop	0,16
TIMER_C
		move	#$2700,sr

		addq.l	#1,_hz_200.w
		rol	.div4		;division par 4
		bcc.s	.end

	* Timer  50Hz
		movem.l	d0-a6,-(sp)

	* GEM ETV
		move	_timer_ms.w,-(sp)
		jsr	([etv_timer.w])
		addq.l	#2,sp

		movem.l	(sp)+,d0-a6
	* revalide la reprise des ints
.end
		move.b	#~timerc,MFP_BASE+ISRB.w
		rte     

		*-------------*

.div4		dc.w	$1111

*-------------------------------------------------------------------------*

		*/------------/*
		* vrifie que la nvram systme est correcte
		cnop	0,16
check_nvm
		movem.l	d0-3/a0,-(sp)

	* cherche le mot magique '_DOL'
		ldnvm	#nvm_valid,d0
		lsl.l	#8,d0
		ldnvm	#nvm_valid+1,d0
		lsl.l	#8,d0
		ldnvm	#nvm_valid+2,d0
		lsl.l	#8,d0
		ldnvm	#nvm_valid+3,d0
		cmp.l	#"_DOL",d0
		bne.s	.reset

	* vrifie que la checksum est bonne
		moveq	#nvm_notsum-nvm_vars-1,d0
		moveq	#nvm_vars,d1
		moveq	#0,d3
.checksum
		ldnvm	d1,d2
		add.b	d2,d3
		addq	#1,d1
		dbra	d0,.checksum

		ldnvm	#nvm_sum,d2
		cmp.b	d2,d3
		beq.s	.ok_1
	* reset en cas de mauvaise checksum ou pas de '_DOL'
.reset
		lea	nvram_buffer(a6),a0
		moveq	#nvm_notsum-nvm_vars-1,d0
		moveq	#nvm_vars,d1
		clr	d2
.copie
		stnvm	(a0),d1
		add.b	(a0)+,d2
		addq	#1,d1
		dbra	d0,.copie

		stnvm	d2,#nvm_sum
		not.b	d2
		stnvm	d2,#nvm_notsum
		bra.s	.ok_1b
.ok_1
	* vrifie que l'arbitration est bien mise

		move.b	arbid(a6),d0
		bmi.s	.ok_1b

		or.b	#$80,d0		;arbitration
		stnvm	d0,#nvm_arbid

		moveq	#nvm_notsum-nvm_vars-1,d0
		moveq	#nvm_vars,d1
		clr	d2
		clr	d3
.sum
		ldnvm	d1,d2
		add.b	d2,d3
		addq	#1,d1
		dbra	d0,.sum

		stnvm	d3,#nvm_sum
		not.b	d3
		stnvm	d3,#nvm_notsum
.ok_1b
		*/------------/*

		movem.l	(sp)+,d0-3/a0
		rts

		*/------------/*

*-------------------------------------------------------------------------*

		*/------------/*
		* Lit la nvram et la reconfigure le cas chant
		* en cas de bug(s!)
		* lit les valeurs de la nvram dans les variables
		* si c'est OK
		cnop	0,16
read_nvm
		movem.l	d0-1/a0,-(sp)

		bsr	check_nvm

		* nvram systme

		lea	nvram_buffer(a6),a0

		moveq	#nvm_notsum-nvm_vars-1,d0
		moveq	#nvm_vars,d1
.copie
		ldnvm	d1,(a0)+
		addq	#1,d1
		dbra	d0,.copie

		*/------------/*

		movem.l	(sp)+,d0-1/a0
		rts

		*/------------/*

*-------------------------------------------------------------------------*

		*-------------*
		* rcupre le code de l'install du tos
		cnop	0,16
install_tos
		move	#$2700,sr		;pas d'int
		
	* recopie la Rom devant l'arbre pmmu
		lea	romtos_copy,a0
		move.l	a0,a2
		lea	romtos_true,a1
		move.l	a1,a3
		
		move	#romtos_len/16-1,d0
.copie_tos
		rept	4
		move.l	(a3)+,(a2)+
		endr
		dbra	d0,.copie_tos

	* vars systme
		move.l	fast_sysend(a6),d0
		sub.l	#romtos_len+pmmu_len,d0
		move.l	d0,fast_top(a6)

	* header du TOS<-vire tos 7
		moveq	#$f,d0
		and	rom_version(a1),d0
		;move	d0,d1
		;or	#$700,d1
		;move	d1,rom_version(a0)
		
		;move	rom_version(a1),rom_version(a0)
		lea	fast_dol_start,a2
		move.l	dol_date(a2),rom_date(a0)
		move	dol_sys_date(a2),dol_sys_date(a0)
	
	* met en place le saut pour le setup
		move	#$4ef9,rom_jmp(a0)		;"JMP"
		move.l	setup_ptr(a6),rom_jmp_val(a0)
	
	* patch la rom
		move.l	(patch_tos-1*4.w,pc,d0*4),a2
		
		move.l	#$4e714e71,d0	;2 NOPs
		
		* enlve le test de $ffff8e09 (GPR)
		move.l	a0,a1
		add.l	patch_gpr(a2),a1
		moveq	#7-1,d1
.clr_gpr
		move.l	d0,(a1)+
		dbra	d1,.clr_gpr
		
		* enlve la destruction de la pmmu dans le reset clavier
		move.l	a0,a1
		add.l	patch_pmmu(a2),a1
		moveq	#4*3/2-1,d1
.clr_pmmu
		move.l	d0,(a1)+
		dbra	d1,.clr_pmmu

	* valide une meilleur rsolution par dfaut pour le GEM
	* anciennement c'tait du 320*200 en st compatible=> 640*480*16 en vga
	* 640*200*16 en tv
		move.l	a0,a1
		add.l	patch_video(a2),a1
		btst	#0,monitor+1
		bne.s	.tv
		move	#$1a,(a1)
		bra.s	.vga
.tv
		move	#$a,(a1)
.vga
	* dvalide le blitter tout le temps
		move.l	a0,a1
		move.l	patch_blitter(a2),d0
		beq.s	.no_blit
		
		add.l	d0,a1
		clr	(a1)
.no_blit
	* modifie la pmmu
		lea	romtos_copy+romtos_len,a0

	* o est la Rom?
		lea	pmmu_levelb1(a0),a1
		
		move.l	fast_sysend(a6),d6
		sub.l	#fast_log_start-5+romtos_len+pmmu_len,d6
		add.l	fast_start(a6),d6
		move.l	#$2000,d7		;page de 8Ko

		move	#64-1,d0		;64 premires pages
.map_rom
		move.l	d6,(a1)+
		add.l	d7,d6
		dbra	d0,.map_rom

	* on cache sa location en fast
		lea	pmmu_levelb2(a0),a1
		move.l	fast_end(a6),d6
		sub.l	#$00100000-1,d6
		
		move	#128-romtos_len/8192-pmmu_len/8192-1,d0
					;128 pages - l'arbre  la fin
					; - la rom de 512Ko
.map_lastmega
		move.l	d6,(a1)+
		add.l	d7,d6
		dbra	d0,.map_lastmega
		
		move	#romtos_len/8192+pmmu_len/8192-1,d0
		and	#~1,d6		;=>invalide
.cache_fin
		move.l	d6,(a1)+
		add.l	d7,d6
		dbra	d0,.cache_fin
	
		pflusha			; prcaution

	* clr les Rams  chaque changement de systme
		clr.l	memvalid.w
		clr.l	memval2.w
		clr.l	memval3.w
		clr.l	ramvalid.w

		*-------------*
		
		move	#$2500,sr
		rts

		*-------------*

*-------------------------------------------------------------------------*

		*-------------*
		* rcupre le code de l'install de Dolmen
		cnop	0,16
install_dolmen
		move	#$2700,sr		;pas d'int
		
	* recopie la Rom devant l'arbre pmmu
		lea	romtos_copy,a0
		move.l	a0,a2
		lea	romtos_true,a1
		move.l	a1,a3
		
		move	#romtos_len/16-1,d0
.copie_tos
		rept	4
		move.l	(a3)+,(a2)+
		endr
		dbra	d0,.copie_tos

	* vars systme
		move.l	fast_sysend(a6),d0
		sub.l	#romtos_len+pmmu_len,d0
		move.l	d0,fast_top(a6)

	* header du TOS&DOLMEN
		moveq	#$f,d0
		and	rom_version(a1),d0
		move	d0,d1
		or	#$710,d1
		move	d1,rom_version(a0)
		lea	fast_dol_start,a1
		move.l	rom_root(a0),dol_root(a1)
		move.l	rom_kbshift(a0),dol_kbshift(a1)
		move.l	rom_run(a0),dol_run(a1)
	
	* met en place le saut pour le setup dans la "ROM"
		move	#$4ef9,rom_jmp(a0)		;"JMP"
		move.l	setup_ptr(a6),rom_jmp_val(a0)
	
	* patch la rom
		move.l	(patch_tos-1*4.w,pc,d0*4),a2
		
		;move.l	#$4e714e71,d0	;2 NOPs
		
		* enlve le test de $ffff8e09 (GPR)
		;move.l	a0,a1
		;add.l	patch_gpr(a2),a1
		;moveq	#7-1,d1
.clr_gpr
		;move.l	d0,(a1)+
		;dbra	d1,.clr_gpr
		
		* enlve la destruction de la pmmu dans le reset clavier
		;move.l	a0,a1
		;add.l	patch_pmmu(a2),a1
		;moveq	#4*3/2-1,d1
.clr_pmmu
		;move.l	d0,(a1)+
		;dbra	d1,.clr_pmmu

	* valide une meilleur rsolution par dfaut pour le GEM
	* anciennement c'tait du 320*200 en st compatible=> 640*480*16 en vga
	* 640*200*16 en tv
		move.l	a0,a1
		add.l	patch_video(a2),a1
		move	#$a,(a1)
		
	* dvalide le blitter tout le temps
		;move.l	a0,a1
		;move.l	patch_blitter(a2),d0
		;beq.s	.no_blit
		
		;add.l	d0,a1
		;clr	(a1)
.no_blit
	* modifie la pmmu
		lea	romtos_copy+romtos_len,a0

	* o est la Rom?
		lea	pmmu_levelb1(a0),a1
		
		move.l	fast_top(a6),d6
		sub.l	#fast_log_start-5,d6
		add.l	fast_start(a6),d6
		move.l	#$2000,d7		;page de 8Ko
		move	#64-1,d0		;64 premires pages
.map_rom
		move.l	d6,(a1)+
		add.l	d7,d6
		dbra	d0,.map_rom

	* on cache sa location en fast
		lea	pmmu_levelb2(a0),a1
		move.l	fast_end(a6),d6
		sub.l	#$100000-1,d6
		
		move	#128-romtos_len/8192-pmmu_len/8192-1,d0
					;128 pages - l'arbre  la fin
					; - la rom de 512Ko
.map_lastmega
		move.l	d6,(a1)+
		add.l	d7,d6
		dbra	d0,.map_lastmega
		
		move	#romtos_len/8192+pmmu_len/8192-1,d0
		and	#~1,d6		;=>invalide
.cache_fin
		move.l	d6,(a1)+
		add.l	d7,d6
		dbra	d0,.cache_fin
	
		pflusha			; prcaution

	* clr les Rams  chaque changement de systme
		clr.l	memvalid.w
		clr.l	memval2.w
		clr.l	memval3.w
		clr.l	ramvalid.w

		*-------------*
		
		move	#$2500,sr
		rts
		
		*-------------*

*-------------------------------------------------------------------------*
*		Sous-programmes
*-------------------------------------------------------------------------*

		INCLUDE	SVIDEO.S
		INCLUDE	SIKBD.S
		INCLUDE	SCONS.S
		INCLUDE	SMENU.S

*-------------------------------------------------------------------------*
		DATA
*-------------------------------------------------------------------------*

		*-------------*

Fond_bleu		dc.b	27,"c",32+bleu_f,27,"E",0
		even

Fond_cyan		dc.b	27,"c",32+cyan_f,27,"E",0
		even
		
	IFEQ	langue
		
flash_change	
		dc.b	27,"Y",32+15,32+39-18,27,"b",32+rouge
		dc.b	"Le contenu de la Flash a t chang !",13,10
		dc.b	27,"Y",32+18,32+39-31,27,"b",32+gris
		dc.b	"Redmarrer sur la nouvelle Flash: appuyez sur ALTERNATE+ESCAPE",13,10
		dc.b	27,"Y",32+20,32+39-31
		dc.b	"Ne pas tenir compte du changement: appuyez sur ESPACE",13,10
		dc.b	0
		even

	ENDC

	IFNE	langue
		
flash_change
		dc.b	27,"Y",32+15,32+39-16,27,"b",32+rouge
		dc.b	"The Flash contents was changing !",13,10
		dc.b	27,"Y",32+18,32+39-23,27,"b",32+gris
		dc.b	"Reboot on the new Flash: press ALTERNATE+ESCAPE",13,10
		dc.b	27,"Y",32+20,32+39-23
		dc.b	"Don't care about change: press SPACE",13,10
		dc.b	0
		even
	ENDC


		*-------------*
ext_vars
		* VIDEO
video_ptr		dc.l	phys_adr		;pointeur sur params vido
put_pal_ptr	dc.l	put_pal		;met en place la palette systme

		* IKBD
write_ikbd_ptr	dc.l	write_ikbd	;crit dans le clavier
					;a0: pointeur sur la chaine
					;d0: nb de car-1
					;a0 et d0 modifi
reset_buf_ptr	dc.l	reset_buf		;reset le buffer clavier
					;a0 et d0 modifi

		* CONSOLE
constat_ptr	dc.l	con_stat		;caractre en entr dispo?
					;0=>non
					;-1=>oui
					;a0 et d0 modifi

conin_ptr		dc.l	con_in		;va chercher un caractre
					;=>d0 contient le caractre
					;  + scan et touches mortes
					;a0 et d0 modifi

conout_ptr	dc.l	con_out		;sort un caractre norme vt52
					;d0: caractre  afficher (ou code)
					;a0 et d0 modifi

rawout_ptr	dc.l	raw_out		;sort un caractre en brute
					;d0: caractre  afficher
					;a0 et d0 modifi
deadkeys_ptr	dc.l	touches_mortes	;pointeur sur les touches mortes (1.b)

		* SOUS-PROGRAMMES
aff_txt_ptr	dc.l	aff_txt		;affiche une chane de texte en vt52
					;a0: pointe sur la chane termine par 0
					;a0 et d0 modifi
					
aff_nb_hex_ptr	dc.l	aff_nb_hex	;convertie un nombre en texte hexa
					;d0: valeur sur 32 bits
					;d1: nombre de cars  crer
					;a0: pointeur aprs le dernier car
aff_nb_dec_ptr	dc.l	aff_nb_dec	;convertie un nombre en texte dec
					;d0: valeur sur 16 bits
					;d1: nombre de cars  crer
					;a0: pointeur aprs le dernier car
		*-------------*
		* offsets vers les zones du tos  patcher

patch_tos		dc.l	p401
		dc.l	p402
		dc.l	p402	;pout le TOS 4.03 !?
		dc.l	p404

p401		dc.l	$2c76
		dc.l	$3946
		dc.l	$1dba4
		dc.l	0

p402		dc.l	$2c76
		dc.l	$3946
		dc.l	$1f3ca
		dc.l	$1090a		;#1->#0 : no blitter

p404		dc.l	$2cd0		;GPR=>14 nops
		dc.l	$39a0		;pmmu=>12 nops
		dc.l	$1f42a		;mode vido=>#$a.w->
		dc.l	0

		*-------------*

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*

		*-------------*

copro_ok		ds.b	1	;copro prsent
		ds.b	3

		*-------------*
		
		ds.l	1000	;4000 pour tout le monde durant le boot
pile		ds.l	1

		*-------------*

*----------------------------------------------------------------------------*
