*----------------------------------------------------------------------------*
*		Menu du SETUP DE LA CENTURBO II
*----------------------------------------------------------------------------*
		TEXT

*----------------------------------------------------------------------------*

		*-------------*

ypos_order	equ	16
ypos_amo		equ	18

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		* menu
		cnop	0,16
menu
	* rvision de la carte
		move.b	ct2_ok(a6),d0
		bne.s	.ct2_w
		moveq	#"?",d0
.ct2_w
		move.b	d0,ct2_rev

	* version de la flash
		lea	flash_ver(pc),a0
		moveq	#0,d0
		move	flh_version(a6),d0
		moveq	#3+1-1,d1
		bsr	aff_nb_hex
		move.b	1(a0),(a0)+
		move.b	#".",(a0)

	* version de Ccile
		lea	cec_ver_txt(pc),a0
		moveq	#0,d0
		move	flh_cecile_ver(a6),d0
		moveq	#3+1-1,d1
		bsr	aff_nb_hex
		move.b	1(a0),(a0)+
		move.b	#".",(a0)

	* prsentation
		sf	update		;on arrive avec les paramtres
					;sauvs
		
		lea	centek(pc),a0
		bsr	aff_txt
.present
	* et la date, en cas de reset de la nvram
		lea	flash_date(pc),a0
		move.l	flh_date(a6),d0
		moveq	#8+2-1,d1
		bsr	aff_nb_hex

		move.b	idt+1(a6),d1
		bne.s	.datcar_ok
		moveq	#"/",d1		;scurit!
.datcar_ok
		lea	2(a0),a1
		move	(a1)+,d2
		move	(a1)+,d3
		move.l	(a1),d4
		
		moveq	#$3,d0
		and.b	idt(a6),d0
		jmp	([.date.w,pc,d0*4])
.date		
		dc.l	.mmddyy
		dc.l	.ddmmyy
		dc.l	.yymmdd
		dc.l	.yyddmm
.mmddyy		
		move	d2,(a0)+
		move.b	d1,(a0)+
		move	d3,(a0)+
		move.b	d1,(a0)+
		move.l	d4,(a0)+
		
		bra.s	.fin_date
.ddmmyy		
		move	d3,(a0)+
		move.b	d1,(a0)+
		move	d2,(a0)+
		move.b	d1,(a0)+
		move.l	d4,(a0)+
		
		bra.s	.fin_date
.yymmdd		
		move.l	d4,(a0)+
		move.b	d1,(a0)+
		move	d2,(a0)+
		move.b	d1,(a0)+
		move	d3,(a0)+
		
		bra.s	.fin_date
.yyddmm		
		move.l	d4,(a0)+
		move.b	d1,(a0)+
		move	d3,(a0)+
		move.b	d1,(a0)+
		move	d2,(a0)+
.fin_date
	* suite du menu
		bsr	aff_f1f2f3

		lea	f4_txt(pc),a0
		bsr	aff_txt

		bsr	aff_skip

		lea	f5_txt(pc),a0
		bsr	aff_txt

		lea	esc_txt(pc),a0
		bsr	aff_txt

		lea	video_pres(pc),a0
		bsr	aff_txt

		lea	hard_pres(pc),a0
		bsr	aff_txt

		lea	test_pres(pc),a0
		bsr	aff_txt

		lea	hd_pres(pc),a0
		bsr	aff_txt
		
		lea	dol_pres(pc),a0
		bsr	aff_txt

		lea	help_pres(pc),a0
		bsr	aff_txt

		lea	help_1(pc),a0
		bsr	aff_txt

		moveq	#1,d7	;premire page de Help affiche

		*-------------*
		* D7 est utilis en permanence par le menu:
		* NE PAS MODIFIER !
		* Conin ne marche qu'en touches mortes(8 bits)+code scan(8bits)
.scan
		bsr	aff_sauv
		
		BSR	con_in

		cmp.b	#$01,d0
		bne.s	.no_esc
		
		rts
.no_esc
		cmp.b	#$3b,d0
		beq	.F1
		cmp.b	#$3c,d0
		beq	.F2
		cmp.b	#$3d,d0
		beq	.F3
		cmp.b	#$3e,d0
		beq	.F4
		cmp.b	#$3f,d0	;F5
		beq	.F5

		cmp.b	#$40,d0
		beq	.F6
		cmp.b	#$41,d0
		beq	.F7
		cmp.b	#$42,d0
		beq	.F8
		cmp.b	#$43,d0
		beq	.F9
		cmp.b	#$44,d0
		beq	.F10

		cmp.b	#$61,d0
		beq	.reset
		
		cmp.b	#$62,d0
		beq	.help

	* un menu est en cours ...
.menu_ready
		move	d0,d1	;pour ne pas l'craser
		cmp.b	#$40,d7
		bne.s	.pas_video

		lea	video_col(pc),a0
		bsr	aff_txt

		bsr	menu_video
		bra	.scan
.pas_video
		cmp.b	#$41,d7
		bne.s	.pas_hard

		lea	hard_col(pc),a0
		bsr	aff_txt

		bsr	menu_hard
		bra	.scan
.pas_hard
		cmp.b	#$42,d7
		bne.s	.pas_test

		lea	test_col(pc),a0
		bsr	aff_txt

		bsr	menu_test
		bra	.scan
.pas_test
		cmp.b	#$43,d7
		bne.s	.pas_hd

		lea	hd_col(pc),a0
		bsr	aff_txt

		bsr	menu_hd
		
		bra	.scan
.pas_hd
		cmp.b	#$44,d7
		bne.s	.pas_dolmen
		
		lea	dol_col(pc),a0
		bsr	aff_txt
		
		bsr	menu_dolmen
.pas_dolmen
		bra	.scan

		*-------------*
		cnop	0,16
.F1
		st	update
		and.b	#~$08,flags_boot(a6)
		or.b	#$10,flags_boot(a6)
		bsr	aff_f1f2f3

		bra	.scan

		*-------------*
		cnop	0,16
.F2
		st	update
		and.b	#~$18,flags_boot(a6)
		bsr	aff_f1f2f3

		bra	.scan

		*-------------*
		cnop	0,16
.F3
		st	update
		and.b	#~$18,flags_boot(a6)
		or.b	#$08,flags_boot(a6)
		bsr	aff_f1f2f3

		bra	.scan

		*-------------*
		cnop	0,16
.F4
		st	update
		eor.b	#$20,flags_boot(a6)
		bsr	aff_skip

		bra	.scan

		*-------------*
		cnop	0,16
.F5
		moveq	#%11,d0
		and.b	touches_mortes(pc),d0
		beq.s	.no_shift
		
		sf	update
	* sauvegarde et checksum de la nvram systme
		lea	nvram_buffer(a6),a0
		moveq	#nvm_notsum-nvm_vars-1,d0
		moveq	#nvm_vars,d1
		clr	d2
.copie_tos
		stnvm	(a0),d1
		add.b	(a0)+,d2
		addq	#1,d1
		dbra	d0,.copie_tos

		stnvm	d2,#nvm_sum
		not.b	d2
		stnvm	d2,#nvm_notsum
.no_shift
		bra	.scan

		*-------------*
		cnop	0,16
.F6
		move	d0,d7

		lea	video_pres(pc),a0
		bsr	aff_txt

		lea	video_page(pc),a0
		bsr	aff_txt

		move	nvm_video(a6),d0
		bsr	V_modevalid
		move	d0,nvm_video(a6)

		move	video_pos(pc),d5

		bsr	aff_x
		bsr	aff_y
		bsr	aff_p
		bsr	aff_vga
		bsr	aff_pal
		bsr	aff_st

		bra	.scan

		*-------------*
		cnop	0,16
.F7
		move	d0,d7

		lea	hard_pres(pc),a0
		
		bsr	aff_txt
		lea	hard_page(pc),a0
		bsr	aff_txt

		move	hard_pos(pc),d5

		bsr	aff_wside
		bsr	aff_wsdsp
		bsr	aff_ext
		
		bsr	aff_chip		
		bsr	aff_fast
		bsr	aff_copro

		bra	.scan

		*-------------*
		cnop	0,16
.F8
		move	d0,d7
		lea	test_pres(pc),a0
		bsr	aff_txt

		lea	test_page(pc),a0
		bsr	aff_txt

		move	test_pos(pc),d5

		bsr	aff_ram
		bsr	aff_wait
		bsr	aff_pause

		bra	.scan

		*-------------*
		cnop	0,16
.F9
		move	d0,d7
		lea	hd_pres(pc),a0
		bsr	aff_txt

		lea	hd_page(pc),a0
		bsr	aff_txt

		move	hd_pos(pc),d5

		bsr	aff_prio
		bsr	aff_id
		bsr	aff_cci
		bsr	aff_floppy
		bsr	aff_order

		bra	.scan

		*-------------*
		cnop	0,16
.F10
		move	d0,d7
		lea	dol_pres(pc),a0
		bsr	aff_txt

		lea	dol_page(pc),a0
		bsr	aff_txt
		
		move	dol_pos(pc),d5

		bsr	aff_data
		bsr	aff_fat
		bsr	aff_folder
		bsr	aff_part
		bsr	aff_mide
		bsr	aff_side

		bsr	aff_irm0
		bsr	aff_irm1
		bsr	aff_rmx

		bra	.scan

		*-------------*
		cnop	0,16
.help
		lea	help_pres(pc),a0
		bsr	aff_txt

		tst	d7
		bne.s	.help2
.help1
		moveq	#1,d7
		lea	help_1(pc),a0
		bra.s	.aff
.help2
		cmp	#1,d7
		bne.S	.help3
		
		moveq	#2,d7
		lea	help_2(pc),a0
		bra.s	.aff
.help3
		cmp	#2,d7
		bne.s	.help1	;utile quand on revient d'un menu
		
		moveq	#0,d7
		lea	help_3(pc),a0
.aff
		bsr	aff_txt

		bra	.scan

		*-------------*
		cnop	0,16
.reset
		and	#%11<<8,d0
		beq	.scan
		
		st	update
		lea	nvram_buffer(a6),a0
		lea	nvram_defaut(pc),a1
		
		moveq	#nvm_notsum-nvm_vars-1,d0
.reset_nvm
		move.b	(a1)+,(a0)+
		dbra	d0,.reset_nvm
		
		clr.b	sel_order
		bra	.present

		*-------------*
		* change la slection du boot
		cnop	0,16
aff_f1f2f3
		btst	#4,flags_boot(a6)
		bne.s	.dolmen

		moveq	#" ",d0
		moveq	#" ",d1
		
		btst	#3,flags_boot(a6)
		bne.s	.tos4
		
		move.b	#"",d2
		move.b	#"",d3
		moveq	#" ",d4
		moveq	#" ",d5
		
		bra.s	.chg_f1f2
.tos4
		moveq	#" ",d2
		moveq	#" ",d3
		move.b	#"",d4
		move.b	#"",d5
		
		bra.s	.chg_f1f2
.dolmen
		move.b	#"",d0
		move.b	#"",d1
		moveq	#" ",d2
		moveq	#" ",d3
		moveq	#" ",d4
		moveq	#" ",d5
.chg_f1f2
		move.b	d0,f1_sel1
		move.b	d1,f1_sel2

		move.b	d2,f2_sel1
		move.b	d3,f2_sel2

		move.b	d4,f3_sel1
		move.b	d5,f3_sel2

		lea	f1f2f3_txt(pc),a0
		bsr	aff_txt

		rts

		*-------------*
		* affiche le statut du setup
		cnop	0,16
aff_skip
		btst	#5,flags_boot(a6)
		bne.s	.skip1
		lea	f4_noskip(pc),a0
		bra.s	.noskip1
.skip1
		lea	f4_skip(pc),a0
.noskip1
		bsr	aff_txt

		rts

		*-------------*
		* affiche l'tat des variables
		cnop	0,16
aff_sauv
		tst.b	update(pc)
		bne.s	.sauv
		lea	sauv(pc),a0
		bra.s	.pas_sauv
.sauv
		lea	pas_sauv(pc),a0
.pas_sauv
		bsr	aff_txt
		
		rts
		
		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
menu_video
		lea	video_pos(pc),a5
		move	(a5),d5

	* change de champ
		cmp.b	#$0f,d1
		beq.s	.tab
		cmp.b	#$4d,d1
		bne.s	.pas_tab
.tab
		* TAB (ou )
		add	#1,d5
		cmp	#6,d5
		bne.s	.move_end
		clr	d5
		bra.s	.move_end
.pas_tab
		* 
		cmp.b	#$4b,d1
		bne.s	.move_end
		
		tst	d5
		bne.s	.gauche
		moveq	#6,d5
.gauche
		sub	#1,d5
.move_end
		move	d5,(a5)

	* gestion x
		tst	d5
		bne.s	.pas_x

		cmp.b	#$48,d1
		beq.s	.chgx
		cmp.b	#$50,d1
		bne.s	.pas_chgx
.chgx
		st	update
		eor	#_80c,nvm_video(a6)
.pas_chgx
		bsr	aff_st
		bsr	aff_x
		bsr	aff_y

		rts
.pas_x
	* gestion y
		cmp	#1,d5
		bne.s	.pas_y

		cmp.b	#$48,d1
		beq.s	.chgy
		cmp.b	#$50,d1
		bne.s	.pas_chgy
.chgy
		st	update
		eor	#_vert,nvm_video(a6)
.pas_chgy
		bsr	aff_x
		bsr	aff_y
		bsr	aff_p
		rts
.pas_y
	* gestion	plan
		cmp	#2,d5
		bne.s	.pas_p

		move	nvm_video(a6),d6

		cmp.b	#$48,d1
		bne.s	.pas_plus
.plus
		move	d6,d0
		and	#_cols,d0

		cmp	#%100,d0
		beq.s	.pas_chg

		add	#1,d0
		bra.s	.chg
.pas_plus
		cmp.b	#$50,d1
		bne.s	.pas_chg

		move	d6,d0
		and	#_cols,d0
		beq.s	.pas_chg
		sub	#1,d0
.chg
		st	update
		and	#~_cols,d6
		or	d0,d6
		move	d6,nvm_video(a6)
.pas_chg
		bsr	aff_y
		bsr	aff_p
		bsr	aff_vga

		rts
.pas_p
	* gestion moniteur
		cmp	#3,d5
		bne.s	.pas_mon

		cmp.b	#$48,d1
		beq.s	.chgm
		cmp.b	#$50,d1
		bne.s	.pas_chgm
.chgm
		st	update
		eor	#_vert+_vga,nvm_video(a6)
.pas_chgm
		bsr	aff_y	;mise  jour spciale
		bsr	aff_p
		bsr	aff_vga
		bsr	aff_pal
		rts
.pas_mon
	*gestion pal
		cmp	#4,d5
		bne.s	.pas_mode

		cmp.b	#$48,d1
		beq.s	.chgp
		cmp.b	#$50,d1
		bne.s	.pas_chgp
.chgp
		st	update
		eor	#_pal,nvm_video(a6)
.pas_chgp
		bsr	aff_vga
		bsr	aff_pal
		bsr	aff_st
		rts
.pas_mode
	* gestion st
		cmp	#5,d5
		bne.s	.pas_st

		cmp.b	#$48,d1
		beq.s	.chgst
		cmp.b	#$50,d1
		bne.s	.pas_chgst
.chgst
		st	update
		eor	#_st,nvm_video(a6)
.pas_chgst
		bsr	aff_pal
		bsr	aff_st
		bsr	aff_x
.pas_st
		rts

		*-------------*
		* affiche x
		cnop	0,16
aff_x
		tst	d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		clr.l	d0
		move	#320,d0

		btst	#flag_80c,nvm_video+1(a6)
		beq.s	.320
		add	d0,d0
.320
		lea	val_x(pc),a0
		moveq	#3-1,d1
		bsr	aff_nb_dec

		lea	text_x(pc),a0
		bsr	aff_txt

		tst	d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche y
		cnop	0,16
aff_y
		cmp	#1,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		move	nvm_video(a6),d6

		clr.l	d0
		btst	#flag_vga,d6
		beq.s	.tv

		move	#240,d0
		btst	#flag_vert,d6
		bne.s	.y_ok
		add	d0,d0
		bra.s	.y_ok
.tv
		move	#200,d0
		btst	#flag_vert,d6
		beq.s	.y_ok
		add	d0,d0
.y_ok
		lea	val_y(pc),a0
		moveq	#3-1,d1
		bsr	aff_nb_dec

		lea	text_y(pc),a0
		bsr	aff_txt

		cmp	#1,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche plan
		cnop	0,16
aff_p
		cmp	#2,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		moveq	#_cols,d0
		and	nvm_video(a6),d0
		moveq	#1,d1
		lsl	d0,d1
		moveq	#1,d0
		lsl	d1,d0
		bcc.s	.pas_tc

		lea	val_cols(pc),a0
		move.b	#"C",-(a0)
		move.b	#"T",-(a0)
		move.b	#"N",-(a0)
		bra.s	.aff
.pas_tc
		lea	val_cols(pc),a0
		moveq	#3-1,d1
		bsr	aff_nb_dec
.aff
		lea	text_cols(pc),a0
		bsr	aff_txt

		cmp	#2,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche moniteur
		cnop	0,16
aff_vga
		cmp	#3,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		btst	#flag_vga,nvm_video+1(a6)
		bne.s	.vga
		lea	text_tv(pc),a0

		bra.s	.tv
.vga
		lea	text_vga(pc),a0
.tv
		bsr	aff_txt

		cmp	#3,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche mode pal/ntsc
		cnop	0,16
aff_pal
		cmp	#4,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		btst	#flag_pal,nvm_video+1(a6)
		bne.s	.pal
		lea	text_ntsc(pc),a0

		bra.s	.ntsc
.pal
		lea	text_pal(pc),a0
.ntsc
		bsr	aff_txt

		cmp	#4,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche st/compatible
		cnop	0,16
aff_st
		cmp	#5,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		btst	#flag_st,nvm_video+1(a6)
		bne.s	.yes
		lea	text_vno(pc),a0

		bra.s	.no
.yes
		lea	text_vyes(pc),a0
.no
		bsr	aff_txt

		cmp	#5,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
menu_hard
		lea	hard_pos(pc),a5
		move	(a5),d5

	* change de champ
		cmp.b	#$0f,d1
		beq.s	.tab
		cmp.b	#$4d,d1
		bne.s	.pas_tab
.tab
		* TAB (ou )
		add	#1,d5
		cmp	#3,d5
		bne.s	.move_end
		clr	d5
		bra.s	.move_end
.pas_tab
		* 
		cmp.b	#$4b,d1
		bne.s	.move_end
		
		tst	d5
		bne.s	.gauche
		moveq	#3,d5
.gauche
		sub	#1,d5
.move_end
		move	d5,(a5)

	* gestion ws ide
		tst	d5
		bne.s	.pas_yam

		cmp.b	#$48,d1
		beq.s	.chgide
		cmp.b	#$50,d1
		bne.s	.pas_chgide
.chgide
		st	update
		eor.b	#$04,flags_boot2(a6)
.pas_chgide
		bsr	aff_ext
		bsr	aff_wside
		bsr	aff_wsdsp

		rts
.pas_yam
	* gestion ws dsp
		cmp	#1,d5
		bne.s	.pas_dsp

		cmp.b	#$48,d1
		beq.s	.chgdsp
		cmp.b	#$50,d1
		bne.s	.pas_chgdsp
.chgdsp
		st	update
		eor.b	#$08,flags_boot2(a6)
.pas_chgdsp
		bsr	aff_wside
		bsr	aff_wsdsp
		bsr	aff_ext

		rts
.pas_dsp
	* gestion clock externe
		cmp	#2,d5
		bne.s	.pas_ext

		cmp.b	#$48,d1
		beq.s	.chgext
		cmp.b	#$50,d1
		bne.s	.pas_chgext
.chgext
		st	update
		eor.b	#$10,flags_boot2(a6)
.pas_chgext
		bsr	aff_wsdsp
		bsr	aff_ext
		bsr	aff_wside
.pas_ext
		rts

		*-------------*
		* affiche wait states ide
		cnop	0,16
aff_wside
		tst	d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		btst	#2,flags_boot2(a6)
		bne.s	.yes
		lea	text_idewsno(pc),a0
		bra.s	.ok_s
.yes
		lea	text_idewsyes(pc),a0
.ok_s
		bsr	aff_txt

		tst	d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts
		
		*-------------*
		* affiche wait states dsp
		cnop	0,16
aff_wsdsp
		cmp	#1,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		btst	#3,flags_boot2(a6)
		bne.s	.yes
		lea	text_dspwsno(pc),a0
		bra.s	.ok_s
.yes
		lea	text_dspwsyes(pc),a0
.ok_s
		bsr	aff_txt

		cmp	#1,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche clock externe
		cnop	0,16
aff_ext
		cmp	#2,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		btst	#4,flags_boot2(a6)
		bne.s	.yes
		lea	text_extno(pc),a0
		bra.s	.ok_s
.yes
		lea	text_extyes(pc),a0
.ok_s
		bsr	aff_txt

		cmp	#2,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts
		
		*-------------*
		* affiche chip
		cnop	0,16
aff_chip
		moveq	#0,d0
		move	chip_end(a6),d0	;/64Ko
		lsr	#4,d0
		moveq	#2-1,d1
		lea	chip_val(pc),a0
		bsr	aff_nb_dec
		
		lea	chip_txt(pc),a0
		bsr	aff_txt
		
		rts

		*-------------*
		* affiche fast
		cnop	0,16
aff_fast
		moveq	#0,d0
		move.l	fast_end(a6),d0
		cmp.l	chip_end(a6),d0
		bhi.s	.ok_fast
		moveq	#0,d0
		bra.s	.bad
.ok_fast
		sub.l	fast_start(a6),d0
		clr	d0
		swap	d0	;/64Ko
		lsr	#4,d0
.bad
		moveq	#3-1,d1
		lea	fast_val(pc),a0
		bsr	aff_nb_dec
		
		lea	fast_txt(pc),a0
		bsr	aff_txt
		
		rts

		*-------------*
		* affiche copro
		cnop	0,16
aff_copro
		tst.b	copro_ok(pc)
		bne.s	.yes
		lea	copro_no(pc),a0
		bra.s	.ok_s
.yes
		lea	copro_yes(pc),a0
.ok_s
		bsr	aff_txt

		rts
		
		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
menu_test
		lea	test_pos(pc),a5
		move	(a5),d5

	* change de champ
		cmp.b	#$0f,d1
		beq.s	.tab
		cmp.b	#$4d,d1
		bne.s	.pas_tab
.tab
		* TAB (ou )
		add	#1,d5
		cmp	#3,d5
		bne.s	.move_end
		clr	d5
		bra.s	.move_end
.pas_tab
		* 
		cmp.b	#$4b,d1
		bne.s	.move_end
		
		tst	d5
		bne.s	.gauche
		moveq	#3,d5
.gauche
		sub	#1,d5
.move_end
		move	d5,(a5)

	* gestion ram
		tst	d5
		bne.s	.pas_ram

		cmp.b	#$48,d1
		beq.s	.chgr
		cmp.b	#$50,d1
		bne.s	.aff_ram
.chgr
		st	update
		eor.b	#$04,flags_boot(a6)
.aff_ram
		bsr	aff_pause
		bsr	aff_ram
		bsr	aff_wait

		rts
.pas_ram
	* gestion wait
		cmp	#1,d5
		bne.s	.pas_wait

		cmp.b	#$48,d1
		beq.s	.chgw
		cmp.b	#$50,d1
		bne.s	.aff_wait
.chgw
		st	update
		eor.b	#$02,flags_boot(a6)
.aff_wait
		bsr	aff_ram
		bsr	aff_wait
		bsr	aff_pause

		rts
.pas_wait
	* gestion pause
		cmp	#2,d5
		bne.s	.pas_pause

		clr	d0
		move.b	pause(a6),d0

		cmp.b	#$48,d1
		bne.s	.pas_plus
.plus
		cmp	#79,d0
		beq.s	.pas_chg
		add	#1,d0
		bra.s	.chg
.pas_plus
		cmp.b	#$50,d1
		bne.s	.pas_chg

		tst	d0
		beq.s	.pas_chg
		sub	#1,d0
.chg
		st	update
		move.b	d0,pause(a6)
.pas_chg
		bsr	aff_wait
		bsr	aff_pause
		bsr	aff_ram
.pas_pause
		rts

		*-------------*
		* affiche	ram
		cnop	0,16
aff_ram
		tst	d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		btst	#2,flags_boot(a6)
		bne.s	.yes
		lea	text_rno(pc),a0
		bra.s	.no
.yes
		lea	text_ryes(pc),a0
.no
		bsr	aff_txt

		tst	d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche	wait
		cnop	0,16
aff_wait
		cmp	#1,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		btst	#1,flags_boot(a6)
		bne.s	.yes
		lea	text_wno(pc),a0
		bra.s	.no
.yes
		lea	text_wyes(pc),a0
.no
		bsr	aff_txt

		cmp	#1,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche	PAUSE
		cnop	0,16
aff_pause
		cmp	#2,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		clr.l	d0
		move.b	pause(a6),d0
		moveq	#2-1,d1
		lea	wait_val(pc),a0
		bsr	aff_nb_dec

		lea	text_wait(pc),a0
		bsr	aff_txt

		cmp	#2,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
menu_hd
		lea	hd_pos(pc),a5
		move	(a5),d5

	* change de champ
		cmp.b	#$0f,d1
		beq.s	.tab
		cmp.b	#$4d,d1
		bne.s	.pas_tab
.tab
		* TAB (ou )
		add	#1,d5
		cmp	#5,d5
		bne.s	.move_end
		clr	d5
		bra.s	.move_end
.pas_tab
		* 
		cmp.b	#$4b,d1
		bne.s	.move_end
		
		tst	d5
		bne.s	.gauche
		moveq	#5,d5
.gauche
		sub	#1,d5
.move_end
		move	d5,(a5)

	* gestion ccile
		tst	d5
		bne.s	.pas_cci

		cmp.b	#$48,d1
		beq.s	.chgcci
		cmp.b	#$50,d1
		bne.s	.pas_chgcci
.chgcci
		st	update
		eor.b	#$80,flags_boot2(a6)
.pas_chgcci
		bsr	aff_order
		bsr	aff_cci
		bsr	aff_id

		rts
.pas_cci
	* gestion	id: remet l'arbitration!
		cmp	#1,d5
		bne.s	.pas_id

		cmp.b	#$48,d1
		bne.s	.pas_plus
.plus
		move.b	arbid(a6),d0
		and.b	#7,d0
		cmp.b	#7,d0
		beq.s	.pas_chg
		add.b	#1,d0
		bra.s	.chg
.pas_plus
		cmp.b	#$50,d1
		bne.s	.pas_chg

		move.b	arbid(a6),d0
		and.b	#7,d0
		beq.s	.pas_chg

		sub.b	#1,d0
.chg
		st	update
		or.b	#$80,d0
		move.b	d0,arbid(a6)
.pas_chg
		bsr	aff_cci
		bsr	aff_id
		bsr	aff_prio

		rts
.pas_id
	* gestion priorit
		cmp	#2,d5
		bne.s	.pas_prio

		cmp.b	#$48,d1
		beq.s	.chgprio
		cmp.b	#$50,d1
		bne.s	.pas_chgprio
.chgprio
		st	update
		eor.b	#$01,flags_boot(a6)
.pas_chgprio
		bsr	aff_id
		bsr	aff_prio
		bsr	aff_floppy

		rts
.pas_prio
	* gestion floppy
		cmp	#3,d5
		bne.s	.pas_floppy

		cmp.b	#$48,d1
		beq.s	.chgfloppy
		cmp.b	#$50,d1
		bne.s	.pas_chgfloppy
.chgfloppy
		st	update
		eor.b	#$40,flags_boot(a6)
.pas_chgfloppy
		bsr	aff_prio
		bsr	aff_floppy
		bsr	aff_order

		rts
.pas_floppy
	* gestion boot order
		cmp	#4,d5
		bne.s	.pas_order

		lea	boot_pos(pc),a0
		move	(a0),d0
		lea	BootOrder(a6),a2

		move	d0,d2	;sauvegarde de l'ancien id
		cmp.b	#$50,d1
		bne.s	.pas_descent
		cmp	#9,d0
		beq.s	.aff_order
		add	#1,d0
		bra.s	.dpl
.pas_descent
		cmp.b	#$48,d1
		bne.s	.pas_monte

		tst	d0
		beq.s	.aff_order
		sub	#1,d0
.dpl
		move	d0,(a0)

		tst.b	sel_order(pc)
		beq.s	.aff_order

		move.b	(a2,d0),d1
		move.b	(a2,d2),(a2,d0)
		move.b	d1,(a2,d2)

		bra.s	.aff_order
.pas_monte
		cmp.b	#$1c,d1
		beq.s	.sel
		cmp.b	#$72,d1
		bne.s	.pas_sel
.sel
		st	update
		lea	sel_order(pc),a0
		not.b	(a0)
		
		bra.s	.aff_order
.pas_sel
		cmp.b	#$52,d1
		bne.s	.aff_order
		bchg	#7,(a2,d0)
		st	update
.aff_order
		bsr	aff_floppy
		bsr	aff_order
		bsr	aff_cci
.pas_order
		rts

		*-------------*
		* affiche	ccile
		cnop	0,16
aff_cci
		tst	d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		btst	#7,flags_boot2(a6)
		bne.s	.yes
		lea	text_ccino(pc),a0
		bra.s	.ok_cci
.yes
		lea	text_cciyes(pc),a0
.ok_cci
		bsr	aff_txt

		tst	d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche id
		cnop	0,16
aff_id
		cmp	#1,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		move.b	arbid(a6),d0
		and	#7,d0
		add.b	#"0",d0
		lea	val_id(pc),a0
		move.b	d0,(a0)

		lea	text_id(pc),a0
		bsr	aff_txt

		cmp	#1,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche	priority
		cnop	0,16
aff_prio
		cmp	#2,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		btst	#0,flags_boot(a6)
		bne.s	.c
		lea	text_ac(pc),a0
		bra.s	.ok_prio
.c
		lea	text_ca(pc),a0
.ok_prio
		bsr	aff_txt

		cmp	#2,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche	floppy
		cnop	0,16
aff_floppy
		cmp	#3,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		btst	#6,flags_boot(a6)
		beq.s	.yes
		lea	text_floppyno(pc),a0
		bra.s	.ok_cci
.yes
		lea	text_floppyyes(pc),a0
.ok_cci
		bsr	aff_txt

		cmp	#3,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche boot order
		cnop	0,16
aff_order
		lea	BootOrder(a6),a2
		lea	pos_order(pc),a0
		move.b	#32+ypos_order-1,(a0)
		moveq	#0,d2		;position de hd boot
.nxt_id
		lea	pos_order(pc),a0
		add.b	#1,(a0)
		lea	txt_order(pc),a0
		bsr	aff_txt

		moveq	#0,d1
		move.b	(a2,d2),d1
		cmp.b	#-1,d1
		beq.s	.fin
		move.b	d1,d3
		and.b	#$7f,d1
		
		subq	#8,d1
		bmi.s	.fin

		tst.b	d3
		bpl.s	.able
		lea	txt_disable(pc),a0
		bra.s	.disable
.able
		lea	txt_able(pc),a0
.disable
		bsr	aff_txt
		
		cmp	#4,d5
		bne.s	.pas_inv

		cmp	boot_pos(pc),d2
		bne.s	.pas_inv

		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		lea	list_order(pc),a0
		move	(list_order,pc,d1*2),d0
		add	d0,a0

		bsr	aff_txt

		cmp	#4,d5
		bne.s	.pas_inv2

		cmp	boot_pos(pc),d2
		bne.s	.pas_inv2

		tst.b	sel_order(pc)
		beq.s	.no_sel
		lea	txt_sel(pc),a0
		bsr	aff_txt
.no_sel
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		addq	#1,d2
		bra	.nxt_id
.fin
		rts

		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
menu_dolmen
		lea	dol_pos(pc),a5
		move	(a5),d5

	* touches mortes: control est prioritaire sur shift(s)
		move.b	touches_mortes(pc),d3
		moveq	#1,d2
		
		btst	#2,d3
		beq.s	.s_add	;=>pas control
		moveq	#100,d2
		bra.s	.fin_add
.s_add
		moveq	#%11,d4
		and	d3,d4
		beq.s	.fin_add	;=>pas shift
		moveq	#10,d2
.fin_add
	* change de champ
		cmp.b	#$0f,d1
		beq.s	.tab
		cmp.b	#$4d,d1
		bne.s	.pas_tab
.tab
		* TAB (ou )
		add	#1,d5
		cmp	#16,d5
		bne.s	.move_end
		clr	d5
		bra.s	.move_end
.pas_tab
		* 
		cmp.b	#$4b,d1
		bne.s	.move_end
		
		tst	d5
		bne.s	.gauche
		moveq	#16,d5
.gauche
		sub	#1,d5
.move_end
		move	d5,(a5)

	* gestion folder
		tst	d5
		bne.s	.pas_folder

		cmp.b	#$48,d1
		bne.s	.pas_plus
.plus
		move	cci_folder(a6),d0
		add	d2,d0
		cmp	#32768,d0
		bls.s	.chg
		move	#32768,d0
		bra.s	.chg
.pas_plus
		cmp.b	#$50,d1
		bne.s	.pas_chg

		move	cci_folder(a6),d0

		sub	d2,d0
		cmp	#10,d0
		bge.s	.chg
		moveq	#10,d0
.chg
		st	update
		move	d0,cci_folder(a6)
.pas_chg
		bsr	aff_rmx	;avant
		bsr	aff_folder
		bsr	aff_data	;aprs

		rts
.pas_folder
	* gestion data
		cmp	#1,d5
		bne.s	.pas_data

		cmp.b	#$48,d1
		bne.s	.pas_plus1
.plus1
		move	cci_data(a6),d0
		add	d2,d0
		cmp	#32768,d0
		bls.s	.chg1
		move	#32768,d0
		bra.s	.chg1
.pas_plus1
		cmp.b	#$50,d1
		bne.s	.pas_chg1

		move	cci_data(a6),d0
		sub	d2,d0
		cmp	#2,d0
		bge.s	.chg1
		moveq	#2,d0
.chg1
		st	update
		move	d0,cci_data(a6)
.pas_chg1
		bsr	aff_folder
		bsr	aff_data	;l
		bsr	aff_fat	;aprs

		rts
.pas_data
	* gestion fat
		cmp	#2,d5
		bne.s	.pas_fat

		cmp.b	#$48,d1
		bne.s	.pas_plus2
.plus2
		move	cci_fat(a6),d0
		add	d2,d0
		cmp	#32768,d0
		bls.s	.chg2
		move	#32768,d0
		bra.s	.chg2
.pas_plus2
		cmp.b	#$50,d1
		bne.s	.pas_chg2

		move	cci_fat(a6),d0

		sub	d2,d0
		cmp	#2,d0
		bge.s	.chg2
		moveq	#2,d0
.chg2
		st	update
		move	d0,cci_fat(a6)
.pas_chg2
		bsr	aff_data
		bsr	aff_fat
		bsr	aff_mide

		rts
.pas_fat
	* gestion master ide
		cmp	#3,d5
		bne.s	.pas_mide

		cmp.b	#$48,d1
		bne.s	.pas_mide_plus
.mide_plus
			; CMMEDISS
		moveq	#%01100000,d0	;Master mode
		and.b	flags_boot2(a6),d0
		lsr	#5,d0

		cmp.b	#2,d0
		beq.s	.pas_mide_plus
		add.b	#1,d0
		bra.s	.mide
.pas_mide_plus
		cmp.b	#$50,d1
		bne.s	.fin_mide

			; CMMEDISS
		moveq	#%01100000,d0	;Master mode
		and.b	flags_boot2(a6),d0
		lsr	#5,d0
		beq.s	.fin_mide

		sub.b	#1,d0
.mide
		st	update
		move.b	d0,cci_rmunits2+0(a6)
			;  CMMEDISS
		moveq	#~%01100000,d1	;Master mode
		and.b	flags_boot2(a6),d1
		lsl	#5,d0
		or.b	d0,d1
		move.b	d1,flags_boot2(a6)
.fin_mide
		bsr	aff_fat
		bsr	aff_mide
		bsr	aff_side

		rts
.pas_mide
	* gestion slave ide
		cmp	#4,d5
		bne.s	.pas_side

		cmp.b	#$48,d1
		bne.s	.pas_side_plus
.side_plus
			; CMMEDISS
		moveq	#%00000011,d0	;Master mode
		and.b	flags_boot2(a6),d0

		cmp.b	#2,d0
		beq.s	.pas_side_plus
		add.b	#1,d0
		bra.s	.side
.pas_side_plus
		cmp.b	#$50,d1
		bne.s	.fin_side

			; CMMEDISS
		moveq	#%00000011,d0	;Master mode
		and.b	flags_boot2(a6),d0
		beq.s	.fin_side

		sub.b	#1,d0
.side
		st	update
		move.b	d0,cci_rmunits2+0(a6)
			;  CMMEDISS
		moveq	#~%00000011,d1	;Master mode
		and.b	flags_boot2(a6),d1
		or.b	d0,d1
		move.b	d1,flags_boot2(a6)
.fin_side
		bsr	aff_mide
		bsr	aff_side
		bsr	aff_part

		rts
.pas_side
	* gestion	partition
		cmp	#5,d5
		bne.s	.pas_part

		move.b	boot_nvm(a6),d3
		
		cmp.b	#$48,d1
		bne.s	.pas_pplus
.pplus
		cmp.b	#"Z"-"A",d3
		beq.s	.pas_pchg
		add.b	#1,d3
		bra.s	.pchg
.pas_pplus
		cmp.b	#$50,d1
		bne.s	.pas_pchg

		tst.b	d3
		beq.s	.pas_pchg
		sub.b	#1,d3
.pchg
		st	update
		move.b	d3,boot_nvm(a6)
.pas_pchg
		bsr	aff_side
		bsr	aff_part
		bsr	aff_irm0

		rts
.pas_part
	* gestion irm0
		cmp	#6,d5
		bne.s	.pas_irm0

		cmp.b	#$48,d1
		bne.s	.pas_iplus3
.iplus3
		move.b	cci_rmunits2+0(a6),d0
		cmp.b	#9,d0
		beq.s	.pas_ichg3
		add.b	#1,d0
		bra.s	.ichg3
.pas_iplus3
		cmp.b	#$50,d1
		bne.s	.pas_ichg3

		move.b	cci_rmunits2+0(a6),d0
		beq.s	.pas_ichg3

		sub.b	#1,d0
.ichg3
		st	update
		move.b	d0,cci_rmunits2+0(a6)
.pas_ichg3
		bsr	aff_part
		bsr	aff_irm0
		bsr	aff_irm1

		rts
.pas_irm0
	* gestion irm1
		cmp	#7,d5
		bne.s	.pas_irm1

		cmp.b	#$48,d1
		bne.s	.pas_iplus4
.iplus4
		move.b	cci_rmunits2+1(a6),d0
		cmp.b	#9,d0
		beq.s	.pas_ichg4
		add.b	#1,d0
		bra.s	.ichg4
.pas_iplus4
		cmp.b	#$50,d1
		bne.s	.pas_ichg4

		move.b	cci_rmunits2+1(a6),d0
		beq.s	.pas_ichg4

		sub.b	#1,d0
.ichg4
		st	update
		move.b	d0,cci_rmunits2+1(a6)
.pas_ichg4
		bsr	aff_irm0
		bsr	aff_irm1
		bsr	aff_rmx

		rts
.pas_irm1
	* gestion rmx
		move	d5,d3
		subq	#8,d3
		cmp	#13-6,d3
		bhi.s	.pas_rmx
		
		cmp.b	#$48,d1
		bne.s	.pas_plusx
.plusx
		move.b	(cci_rmunits,a6,d3),d0
		cmp.b	#9,d0
		beq.s	.pas_chgx
		add.b	#1,d0
		bra.s	.chgx
.pas_plusx
		cmp.b	#$50,d1
		bne.s	.pas_chgx

		move.b	(cci_rmunits,a6,d3),d0
		beq.s	.pas_chgx

		sub.b	#1,d0
.chgx
		st	update
		move.b	d0,(cci_rmunits,a6,d3)
.pas_chgx
		bsr	aff_irm1
		bsr	aff_rmx
		bsr	aff_folder
.pas_rmx
		rts
		
		*-------------*
		* affiche folder
		cnop	0,16
aff_folder
		tst	d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		moveq	#0,d0
		move	cci_folder(a6),d0
		moveq	#5-1,d1
		lea	val_folder(pc),a0
		bsr	aff_nb_dec

		lea	text_folder(pc),a0
		bsr	aff_txt

		tst	d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts
		
		*-------------*
		* affiche data
		cnop	0,16
aff_data
		cmp	#1,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		moveq	#0,d0
		move	cci_data(a6),d0
		moveq	#5-1,d1
		lea	val_data(pc),a0
		bsr	aff_nb_dec

		lea	text_data(pc),a0
		bsr	aff_txt

		cmp	#1,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche fat
		cnop	0,16
aff_fat
		cmp	#2,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		moveq	#0,d0
		move	cci_fat(a6),d0
		moveq	#5-1,d1
		lea	val_fat(pc),a0
		bsr	aff_nb_dec

		lea	text_fat(pc),a0
		bsr	aff_txt

		cmp	#2,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche mode ide matre
		cnop	0,16
aff_mide
		cmp	#3,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
			; CMMEDISS
		moveq	#%01100000,d0	;Master mode
		and.b	flags_boot2(a6),d0
		lsr	#5,d0
		
		bne.s	.pas_mauto
		lea	txt_mideauto(pc),a0
		bra.s	.mide
.pas_mauto
		subq	#1,d0
		bne.s	.pas_mchs
		lea	txt_midechs(pc),a0
		bra.s	.mide
.pas_mchs
		lea	txt_midelba(pc),a0
.mide
		bsr	aff_txt

		cmp	#3,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche mode ide slave
		cnop	0,16
aff_side
		cmp	#4,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
			; CMMEDISS
		moveq	#%00000011,d0	;Master mode
		and.b	flags_boot2(a6),d0
		
		bne.s	.pas_sauto
		lea	txt_sideauto(pc),a0
		bra.s	.side
.pas_sauto
		subq	#1,d0
		bne.s	.pas_schs
		lea	txt_sidechs(pc),a0
		bra.s	.side
.pas_schs
		lea	txt_sidelba(pc),a0
.side
		bsr	aff_txt

		cmp	#4,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche partition
		cnop	0,16
aff_part
		cmp	#5,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		move.b	boot_nvm(a6),d0
		add.b	#"A",d0
		lea	part_val(pc),a0
		move.b	d0,(a0)

		lea	txt_part(pc),a0
		bsr	aff_txt

		cmp	#5,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche	irm0
		cnop	0,16
aff_irm0
		cmp	#6,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		move.b	cci_rmunits2+0(a6),d0
		add.b	#"0",d0
		lea	val_irm0(pc),a0
		move.b	d0,(a0)

		lea	text_irm0(pc),a0
		bsr	aff_txt

		cmp	#6,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts

		*-------------*
		* affiche	irm1
		cnop	0,16
aff_irm1
		cmp	#7,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		move.b	cci_rmunits2+1(a6),d0
		add.b	#"0",d0
		lea	val_irm1(pc),a0
		move.b	d0,(a0)

		lea	text_irm1(pc),a0
		bsr	aff_txt

		cmp	#7,d5
		bne	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		rts
	
		*-------------*
		* affiche rmx
		* d1,d2,a1,a2,d5 modifis
		cnop	0,16
aff_rmx
		movem.l	d1-2/d5/a1-2,-(sp)
		
		moveq	#0,d1
		moveq	#8,d2		;max id+1
		lea	text_rmx(pc),a1
		lea	val_rmx(pc),a2
		move.b	#32+ypos_amo,2(a1)
		subq	#8,d5
.nxt_id
		cmp	d1,d5
		bne.s	.pas_inv
		lea	text_p(pc),a0
		bsr	aff_txt
.pas_inv
		moveq	#"0",d0
		add.b	(cci_rmunits,a6,d1),d0
		move.b	d0,(a2)
		
		move.l	a1,a0
		bsr	aff_txt
		
		cmp	d1,d5
		bne.s	.pas_inv2
		lea	text_q(pc),a0
		bsr	aff_txt
.pas_inv2
		addq.b	#1,2(a1)
		addq	#1,d1
		cmp	d1,d2
		bne.s	.nxt_id
		
		movem.l	(sp)+,d1-2/d5/a1-2
		rts

*-------------------------------------------------------------------------*

		*-------------*
		* A0: pointe sur la chaine
		* routine d'affichage du text
		* d0 et a0 modifi (BIOS...)
		cnop	0,16
aff_txt
		move.l	a1,-(sp)
		move.l	a0,a1
.aff
		clr	d0
		move.b	(a1)+,d0
		beq	.0

		bsr	con_out

		bra	.aff
.0
		move.l	(sp)+,a1
		rts

		*-------------*

*-------------------------------------------------------------------------*

		*/------------/*
		* A0: pointe  la fin de la chane
		* D0.L: valeurs  convertir en hexa
		* D1.W: nombre de chiffres
		* d0 modifi
		* =>A0 pointe sur le dbut de la chane
		cnop	0,16
aff_nb_hex
		movem.l	d1-2,-(sp)
		
		move.l	d0,d2
.nxt_car
		move.l	d2,d0
		and	#$f,d0
		cmp.b	#$a,d0
		bhs.s	.hex
		add.b	#"0",d0
		bra.s	.wr
.hex
		add.b	#"A"-10,d0
.wr
		move.b	d0,-(a0)
		lsr.l	#4,d2
		dbra	d1,.nxt_car
.mess
		movem.l	(sp)+,d1-2
		rts

		*/------------/*

*-------------------------------------------------------------------------*

		*/------------/*
		* A0: pointe  la fin de la chane
		* D0.L: valeurs  convertir en dec (MAX:65535*10)
		* D1.W: nombre de chiffres-1
		* d0 modifi
		* =>A0 pointe sur le dbut de la chane
		cnop	0,16
aff_nb_dec
		movem.l	d1-2,-(sp)
		
		moveq	#10,d2
.nxt
		divu	d2,d0
		swap	d0

		add.b	#"0",d0
		move.b	d0,-(a0)
		clr	d0
		swap	d0
		dbra	d1,.nxt

		movem.l	(sp)+,d1-2
		rts

		*/------------/*

*-------------------------------------------------------------------------*
		DATA
*-------------------------------------------------------------------------*
		*-------------*
	
	*----------------------------------*
	IFEQ	langue
		
centek		dc.b	27,"c",32+bleu_f,27,"E"
		dc.b	27,"Y",32+2,32+39-3,27,"b",32+rouge
		dc.b	"ENTEK"

		dc.b	27,"Y",32+3,32+39-12,27,"b",32+violet_f
		dc.b	"Crateur de Performances"

		dc.b	0
		even
	ENDC

	IFNE	langue
		
centek		dc.b	27,"c",32+bleu_f,27,"E"
		dc.b	27,"Y",32+2,32+39-3,27,"b",32+rouge
		dc.b	"ENTEK"

		dc.b	27,"Y",32+3,32+39-11,27,"b",32+violet_f
		dc.b	"Creator Of Performances"

		dc.b	0
		even
	ENDC

	*----------------------------------*
	
f1f2f3_txt	dc.b	27,"Y",32+7,32+14,27,"b",32+blanc,27,"c",27+cyan_f
		dc.b	" "
f1_sel1		dc.b	"x F1 "
f1_sel2		dc.b	"x    DOLMEN   "

		dc.b	27,"Y",32+8,32+14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	" "
f2_sel1		dc.b	"x F2 " 
f2_sel2		dc.b	"x    T.OS 7.0x  "

		dc.b	27,"Y",32+9,32+14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	" "
f3_sel1		dc.b	"x F3 " 
f3_sel2		dc.b	"x    T.OS 4.0x  ",0
		even

	*----------------------------------*

	IFEQ	langue-0
f4_txt		dc.b	27,"Y",32+7,32+80-22-14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	"   F4  MENU  ",0
		even
	ENDC

	IFNE	langue
f4_txt		dc.b	27,"Y",32+7,32+80-22-14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	"   F4  SETUP ",0
		even
	ENDC

	*----------------------------------*

	IFEQ	langue
f4_skip		dc.b	27,"Y",32+7,32+80-8-14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	" PASSER ",0
		even

f4_noskip		dc.b	27,"Y",32+7,32+80-8-14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	" ENTRER ",0
		even
	ENDC

	IFNE	langue
f4_skip		dc.b	27,"Y",32+7,32+80-8-14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	" SKIP   ",0
		even


f4_noskip		dc.b	27,"Y",32+7,32+80-8-14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	" ENTER  ",0
		even
	
	ENDC

	*----------------------------------*

	IFEQ	langue
f5_txt		dc.b	27,"Y",32+8,32+80-22-14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	"  F5      SAUVER     ",0
		even
	ENDC
	
	IFEQ	langue-1
f5_txt		dc.b	27,"Y",32+8,32+80-22-14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	"  F5       SAVE      ",0
		even
	ENDC

	IFEQ	langue-2
f5_txt		dc.b	27,"Y",32+8,32+80-22-14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	"  F5     SPEICHERN   ",0
		even
	ENDC

	*----------------------------------*

	IFEQ	langue
esc_txt		dc.b	27,"Y",32+9,32+80-22-14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	"  ESC     QUITTER     ",0
		even
	ENDC
	IFEQ	langue-1
esc_txt		dc.b	27,"Y",32+9,32+80-22-14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	"  ESC       QUIT      ",0
		even
	ENDC

	IFEQ	langue-2
esc_txt		dc.b	27,"Y",32+9,32+80-22-14,27,"b",32+blanc,27,"c",32+rouge_f
		dc.b	"  ESC     BEENDEN     ",0
		even
	ENDC
	
	*----------------------------------*

video_pres	dc.b	27,"Y",32+13,32+0,27,"b",32+gris,27,"c",32+cyan_f
		dc.b	" F6 VIDEO     ",0
		even
	
	*----------------------------------*

	IFEQ	langue
hard_pres		dc.b	27,"Y",32+13,32+14,27,"b",32+noir,27,"c",32+gris
		dc.b	" F7 MATERIEL  ",0
		even
	ENDC

	IFNE	langue
hard_pres		dc.b	27,"Y",32+13,32+14,27,"b",32+noir,27,"c",32+gris
		dc.b	" F7 HARDWARE  ",0
		even
	ENDC
	
	*----------------------------------*

test_pres		dc.b	27,"Y",32+13,32+28,27,"b",32+noir,27,"c",32+vert_f
		dc.b	" F8 TESTS     ",0
		even
	
	*----------------------------------*

	IFEQ	langue
hd_pres		dc.b	27,"Y",32+13,32+42,27,"b",32+noir,27,"c",32+jaune_f
		dc.b	" F9 DISQUES   ",0
		even

	ENDC
	IFNE	langue
hd_pres		dc.b	27,"Y",32+13,32+42,27,"b",32+noir,27,"c",32+jaune_f
		dc.b	" F9 DISKS     ",0
		even
	ENDC

	*----------------------------------*

dol_pres		dc.b	27,"Y",32+13,32+56,27,"b",32+noir,27,"c",32+violet_f
		dc.b	" F10 CECILE   ",0
		even

	*----------------------------------*

	IFEQ	langue

help_pres		dc.b	27,"Y",32+13,32+70,27,"b",32+noir,27,"c",32+gris_f
		dc.b	" HELP/AIDE",0
		even
	ENDC
	IFNE	langue
help_pres		dc.b	27,"Y",32+13,32+70,27,"b",32+noir,27,"c",32+gris_f
		dc.b	" HELP     ",0
		even
	ENDC

	*----------------------------------*

		*-------------*

text_p		dc.b	27,"p",0
		EVEN

text_q		dc.b	27,"q",0
		EVEN

		*-------------*
		* menu help

help_pos		dc.w	0

	*----------------------------------*

	IFEQ	langue
help_1		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-7,27,"b",32+bleu_f
		dc.b	27,"p","AIDE GENERALE 1/3",27,"q",13,10
		dc.b	13,10
		dc.b	"    Ce menu de configuration regroupe tous les paramtres utiles pour votre",13,10
		dc.b	"  ENTURBO II. Le but principal de ce menu est de slectionner votre systme",13,10
		dc.b	"  d'exploitation parmi 2 choix :  Dolmen ou T.OS.",13,10
		dc.b	13,10
		dc.b	"    Le dmarrage du systme se fait toujours sous Dolmen qui lance ensuite le",13,10
		dc.b	"  systme d'exploitation choisi.",13,10
		dc.b	13,10
		dc.b	"     - Slection du systme grce  F1 pour Dolmen ou F2/F3 pour T.OS.",13,10
		dc.b	"     - Passer le menu au dmarrage ou y entrer tout le temps avec F4.",13,10
		dc.b	"       Appuyer sur HELP pour entrer dans ce menu durant le dmarrage.",13,10
		dc.b	"     - Sauver les modifications avec SHIFT+F5.",13,10
		dc.b	"     - ESC pour quitter sans sauver les modifications.",13,10
		dc.b	"                                                   HELP pour la page suivante..."
		dc.b	0
		EVEN
	ENDC

	IFEQ	langue-1
help_1		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-7,27,"b",32+bleu_f
		dc.b	27,"p","GENERAL HELP 1/3",27,"q",13,10
		dc.b	13,10
		dc.b	"    This SetUp regroups all the parameters usefull for your ENTurbo II.",13,10
		dc.b	"    The main goal of this SetUp is to select between 2 OS:",13,10
		dc.b	"                      Dolmen or T.OS.",13,10
		dc.b	13,10
		dc.b	"    The startup of the system is done by Dolmen which launches the",13,10
		dc.b	"  selected OS.",13,10
		dc.b	13,10
		dc.b	"    - The selection is done by pressing F1 for Dolmen or F2/F3 for T.OS.",13,10
		dc.b	"    - Skip the setup or always enter it by pressing F4.",13,10
		dc.b	"      Press HELP to enter the Setup during boot sequence.",13,10
		dc.b	"    - Save the modifications by pressing SHIFT+F5.",13,10
		dc.b	"    - ESC quits the setup without saving the modifications.",13,10
		dc.b	"                                                       HELP for the next page..."
		dc.b	0
		EVEN
	ENDC

	IFEQ	langue-2
help_1		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-9,27,"b",32+bleu_f
		dc.b	27,"p","ALLGEMEINE HILFE 1/3",27,"q",13,10
		dc.b	13,10
		dc.b	"    Dieses Setup enthlt alle Parameter, die fr die Konfiguration Ihrer",13,10
		dc.b	"    CENTurbo II notwendig sind. Grundlegend kann mit diesem Setup aus zwei",13,10
		dc.b	"    verschiedenen Betriebssystemen gewhlt werden: Dolmen oder TOS.",13,10
		dc.b	"    Das Initialisieren des Systems wird von Dolmen bernommen, welches dann",13,10
		dc.b	"    das gewhlte Betriebssystem hochfhrt.",13,10
		dc.b	13,10    
		dc.b	"        -Die Auswahl wird mit F1 fr Dolmen oder F2/F3 fr TOS gewhlt.",13,10
		dc.b	"        -Das Setup kann mit F4 ein- oder ausgeschaltet werden. Auch das",13,10
		dc.b	"         ausgeschaltete Setup kann whrend des Bootvorgangs mit HELP",13,10
		dc.b	"         aufgerufen werden.",13,10
		dc.b	"        -F5 speichert die genderten Einstellungen.",13,10
		dc.b	"        -Escape Beendet das Setup ohne die Einstellungen zu speichern.",13,10
		dc.b	"                                                     HELP: zur nchsten Seite..."
		dc.b	0
		EVEN
	ENDC

	*----------------------------------*

	IFEQ	langue
help_2		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-7,27,"b",32+bleu_f
		dc.b	27,"p","AIDE GENERALE 2/3",27,"q",13,10
		dc.b	13,10
		dc.b	"    Possibilits sous le menu de configuration:",13,10
		dc.b	"     - F6: slection de la rsolution pour l'AUTO MANAGER.",13,10
		dc.b	"     - F7: configuration des dlais pour le DSP et le Yamaha.",13,10
		dc.b	"     - F7: configuration de l'horloge externe.",13,10
		dc.b	"     - F8: configurer sparment le test mmoire et la pause de dmarrage.",13,10
		dc.b	"     - F9: slectionner l'ordre de recherche du disque amorable sous T.OS",13,10
		dc.b	"           et l'assignation des partitions pour Ccile.",13,10
		dc.b	"     - F10: slectionner la partition de dmarrage pour Dolmen.",13,10
		dc.b	"     - F10: configurer les paramtres de Ccile.",13,10
		dc.b	"     - SHIFT+UNDO: rinitialise tous les paramtres.",13,10
		dc.b	"     - , et TAB changent de champ.  et  changent la valeur.",13,10
		dc.b	13,10
		dc.b	"                                                   HELP pour la page suivante..."
		dc.b	0
		EVEN
	ENDC

	IFEQ	langue-1
help_2		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-7,27,"b",32+bleu_f
		dc.b	27,"p","GENERAL HELP 2/3",27,"q",13,10
		dc.b	13,10
		dc.b	"    Features under the Setup:",13,10
		dc.b	"     - F6: video configuration for the AUTO MANAGER",13,10
		dc.b	"     - F7: hardware setup for DSP and Yamaha wait states",13,10
		dc.b	"     - F7: hardware setup for external clock",13,10
		dc.b	"     - F8: setup the RAM test",13,10
		dc.b	"     - F9: select the order to scan HDD & partitions",13,10
		dc.b	"     - F10: set Ccile's features and BOOT partition for Dolmen.",13,10
		dc.b	"     - SHIFT+UNDO: reset all parameters",13,10
		dc.b	"     - use , and TAB to select a field,  and  to change its Value",13,10
		dc.b	13,10
		dc.b	13,10
		dc.b	13,10
		dc.b	"                                                       HELP for the next page..."
		dc.b	0
		EVEN
	ENDC

	IFEQ	langue-2
help_2		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-9,27,"b",32+bleu_f
		dc.b	27,"p","ALLGEMEINE HILFE 2/3",27,"q",13,10
		dc.b	13,10
		dc.b	"    Features des Setup-Programms:",13,10
		dc.b	"        -F6: Konfiguration des Videomodus beim Booten",13,10
		dc.b	"        -F7: Hardwareeinstellungen fr DSP und YM-Waitstates",13,10
		dc.b	"        -F7: Hardwareeinstellungen fr externen Videotakt",13,10
		dc.b	"        -F8: Konfiguration des RAM-Tests",13,10
		dc.b	"        -F9: Auswahl von Festplatten-Bootreihenfolge und Bootpartition",13,10
		dc.b	"        -F10: Konfiguration von Ccile und Auswahl der Dolmen-Bootpartition",13,10
		dc.b	"        -SHIFT+UNDO: Zurcksetzen aller Parameter",13,10
		dc.b	"        -Benutzen Sie , und TAB um Felder auszuwhlen,  und  um die",13,10
		dc.b	"         Einstellung zu ndern.",13,10
		dc.b	13,10
		dc.b	13,10
		dc.b	"                                                     HELP: zur nchsten Seite..."
		dc.b	0
		EVEN
	ENDC

	*----------------------------------*

	IFEQ	langue
help_3		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-7,27,"b",32+bleu_f
		dc.b	27,"p","AIDE GENERALE 3/3",27,"q",13,10
		dc.b	13,10
		dc.b	"   Possibilits pendant la squence de dmarrage:",13,10
		dc.b	"     - Rentrer dans le menu de configuration avec [HELP].",13,10
		dc.b	"     - Couper le test de la mmoire et l'attente par une touche.",13,10
		dc.b	"     - Interdire l'installation du pilote de disque dur avec [ALTERNATE]:",13,10
		dc.b	"        uniquement sous TOS.",13,10
		dc.b	"     - Prendre le contrle de l'AUTO MANAGER avec [CONTROL] :",13,10
		dc.b	"         [ENTER]  lance le programme.",13,10
		dc.b	"         [UNDO ]  passe le programme.",13,10
		dc.b	"         [SPACE]  lance tous les programmes (aprs a, plus de contrle!).",13,10
		dc.b	"         [ESC  ]  quitte l'AUTO MANAGER.",13,10
		dc.b	"       ! Attention ! Maintenir [CONTROL] jusqu'au lancement du GEM, empchera",13,10
		dc.b	"       le chargement du NEWDESK.INF, des ACCs et du DESKICON.RSC sous TOS.",13,10
		dc.b	"                                                     HELP pour la premire page."
		dc.b	0
		EVEN
	ENDC

	IFEQ	langue-1
help_3		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-7,27,"b",32+bleu_f
		dc.b	27,"p","GENERAL HELP 3/3",27,"q",13,10
		dc.b	13,10
		dc.b	"   Features during boot sequence:",13,10
		dc.b	"     - Enter the setup with [HELP].",13,10
		dc.b	"     - Skip the memory test and the waiting sequence by a hitting a key.",13,10
		dc.b	"     - Skip the hard-disk recognition with [ALTERNATE]: only in TOS mode.",13,10
		dc.b	"     - Enter the AUTO MANAGER with [CONTROL] :",13,10
		dc.b	"         [ENTER]  Run the program.",13,10
		dc.b	"         [UNDO ]  Skip the program.",13,10
		dc.b	"         [SPACE]  Run all the following programs.",13,10
		dc.b	"         [ESC  ]  Quit the AUTO MANAGER",13,10
		dc.b	13,10
		dc.b	13,10
		dc.b	13,10
		dc.b	"                                                        HELP for the first page."
		dc.b	0
		EVEN
	ENDC

	IFEQ	langue-2
help_3		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-9,27,"b",32+bleu_f
		dc.b	27,"p","ALLGEMEINE HILFE 3/3",27,"q",13,10
		dc.b	13,10
		dc.b	"   Mglickeiten whrend des Bootvorgangs:",13,10
		dc.b	"       - HELP ruft das Setup-Programm auf",13,10
		dc.b	"       - Der Speichertest kann durch einen Tastendruck bersprungen werden",13,10
		dc.b	"       - Die Festplattenerkennung kann durch Festhalten von ALTERNATE",13,10
		dc.b	"         bersprungen werden: only in TOS mode.",13,10
		dc.b	"       - Der Auto-Manager kann durch Drcken von CONTROL aufgerufen werden:",13,10
		dc.b	"           [ENTER]  Programm starten",13,10
		dc.b	"           [UNDO ]  Programm berspringrn",13,10
		dc.b	"           [SPACE]  Alle folgenden Programme ausfhren",13,10
		dc.b	"           [ESC  ]  Auto-Manager beenden",13,10
		dc.b	13,10
		dc.b	13,10
		dc.b	"                                                    HELP: zur ersten Hilfeseite."
		dc.b	0
		EVEN
	ENDC
	
	*----------------------------------*

		*-------------*

update		dc.b	0
		even

	IFEQ	langue
pas_sauv		dc.b	27,"Y",32+0,32+80-11
		dc.b	27,"b",32+rouge,27,"c",32+bleu_f
		dc.b	"Pas sauv !"
		dc.b	0
		even

sauv		dc.b	27,"Y",32+0,32+80-11
		dc.b	27,"b",32+vert_f,27,"c",32+bleu_f
		dc.b	"    Sauv !"
		dc.b	0
		even
	ENDC

	IFEQ	langue-1
pas_sauv		dc.b	27,"Y",32+0,32+80-11
		dc.b	27,"b",32+rouge,27,"c",32+bleu_f
		dc.b	"Not saved !"
		dc.b	0
		even

sauv		dc.b	27,"Y",32+0,32+80-11
		dc.b	27,"b",32+vert_f,27,"c",32+bleu_f
		dc.b	"    Saved !"
		dc.b	0
		even
	ENDC

	IFEQ	langue-2
pas_sauv		dc.b	27,"Y",32+0,32+80-11
		dc.b	27,"b",32+rouge,27,"c",32+bleu_f
		dc.b	"Not saved !"
		dc.b	0
		even

sauv		dc.b	27,"Y",32+0,32+80-11
		dc.b	27,"b",32+vert_f,27,"c",32+bleu_f
		dc.b	"    Saved !"
		dc.b	0
		even
	ENDC
	
		*-------------*
		* mode vido

video_pos		dc.w	0	;sur x au dbut

video_col		dc.b	27,"b",32+gris,27,"c",32+cyan_f,0
		EVEN


	IFEQ	langue
video_page	dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-12
		dc.b	27,"p","CONFIGURATION DU MODE VIDEO",27,"q"
		dc.b	27,"Y",32+17,32+8
		dc.b	"Largeur Hauteur Couleurs"
		dc.b	27,"Y",32+17,32+40
		dc.b	"Moniteur"
		dc.b	27,"Y",32+17,32+50
		dc.b	"Mode TV"
		dc.b	27,"Y",32+17,32+60
		dc.b	"Mode ST"
		dc.b	27,"Y",32+28,32
		dc.b	"  NOTE: - Ce mode vido sert  la squence de dmarrage, i.e AUTO MANAGER.",13,10
		dc.b	"   - Ce mode vido sera correctement sauv dans la NVRAM."
		dc.b	0
		EVEN
	ENDC
	IFEQ	langue-1
video_page	dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-11
		dc.b	27,"p","VIDEO MODE CONFIGURATION",27,"q"
		dc.b	27,"Y",32+17,32+10
		dc.b	"Width  Height Colors"
		dc.b	27,"Y",32+17,32+40
		dc.b	"Monitor"
		dc.b	27,"Y",32+17,32+50
		dc.b	"TV Mode"
		dc.b	27,"Y",32+17,32+60
		dc.b	"ST Mode"
		dc.b	27,"Y",32+28,32
		dc.b	"  NOTE: - This is the video mode used during Boot sequence.",13,10
		dc.b	"   - It will be saved in the NVRAM."
		dc.b	0
		EVEN
	ENDC
	IFEQ	langue-2
video_page	dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-9
		dc.b	27,"p","VIDEO-KONFIGURATION",27,"q"
		dc.b	27,"Y",32+17,32+10
		dc.b	"Breite  Hhe Farben"
		dc.b	27,"Y",32+17,32+40
		dc.b	"Monitor"
		dc.b	27,"Y",32+17,32+50
		dc.b	"TV Mode"
		dc.b	27,"Y",32+17,32+60
		dc.b	"ST Modus"
		dc.b	27,"Y",32+28,32
		dc.b	"ANMERKUNG: - Dieser Videomodus wird beim Bootvorgang verwendet. Die",13,10
		dc.b	"   Einstellung wird im NVRAM gespeichert."
		dc.b	0
		EVEN
	ENDC


text_x		dc.b	27,"Y",32+18,32+11,"640"
val_x		dc.b	0
		EVEN

text_y		dc.b	27,"Y",32+18,32+18,"480"
val_y		dc.b	0
		EVEN

text_cols		dc.b	27,"Y",32+18,32+25,"016"
val_cols		dc.b	0
		EVEN

text_tv		dc.b	27,"Y",32+18,32+42
		dc.b	"TV ",0
		EVEN

text_vga		dc.b	27,"Y",32+18,32+42
		dc.b	"VGA",0
		EVEN

text_ntsc		dc.b	27,"Y",32+18,32+52
		dc.b	"NTSC",0
		EVEN

text_pal		dc.b	27,"Y",32+18,32+52
		dc.b	"PAL ",0
		EVEN

	IFEQ	langue
text_vyes		dc.b	27,"Y",32+18,32+62
		dc.b	"Oui",0
		EVEN

text_vno		dc.b	27,"Y",32+18,32+62
		dc.b	"Non",0
		EVEN
	ENDC

	IFEQ	langue-1
text_vyes		dc.b	27,"Y",32+18,32+62
		dc.b	"Yes",0
		EVEN

text_vno		dc.b	27,"Y",32+18,32+62
		dc.b	"No ",0
		EVEN
	ENDC
	
	IFEQ	langue-2
text_vyes		dc.b	27,"Y",32+18,32+62
		dc.b	" Ja ",0
		EVEN

text_vno		dc.b	27,"Y",32+18,32+62
		dc.b	"Nein",0
		EVEN
	ENDC

		*-------------*
		* hardware

hard_pos		dc.w	0	;sur blitter

hard_col		dc.b	27,"b",32+noir,27,"c",32+gris,0
		EVEN

	IFEQ	langue
hard_page		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-10
		dc.b	27,"p","CONFIGURATION MATRIEL",27,"q"

		dc.b	27,"Y",32+17,32+10
		dc.b	"ENTurbo II Rev "
ct2_rev		dc.b	"A"
		
		dc.b	27,"Y",32+17,32+50
		dc.b	"Flash 1.00"
flash_ver		dc.b	" (12/34/5678"
flash_date	dc.b	")"

		dc.b	27,"Y",32+20,32+6
		dc.b	"Dlai sur l'IDE"
		dc.b	27,"Y",32+20,32+32
		dc.b	"Dlai sur le DSP"
		dc.b	27,"Y",32+20,32+58
		dc.b	"Horloge Externe"
		
		dc.b	27,"Y",32+24,32+6
		dc.b	"CHIP-Ram:"
		dc.b	27,"Y",32+24,32+32
		dc.b	"FAST-Ram:"
		dc.b	27,"Y",32+24,32+57
		dc.b	"Coprocesseur:"

		dc.b	27,"Y",32+28,32+0
		dc.b	"  NOTE: - Mettre des dlais sur le DSP ou l'IDE en cas de disfonctionnement.",13,10
		dc.b	"   - Couper l'horloge externe si une autre horloge entre sur le Videl."
		dc.b	0
		EVEN
	ENDC
	
	IFEQ	langue-1
hard_page		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-10
		dc.b	27,"p","HARDWARE CONFIGURATION",27,"q"

		dc.b	27,"Y",32+17,32+10
		dc.b	"ENTurbo II Rev "
ct2_rev		dc.b	"A"
		
		dc.b	27,"Y",32+17,32+50
		dc.b	"Flash 1.00"
flash_ver		dc.b	" (12/34/5678"
flash_date	dc.b	")"
		
		dc.b	27,"Y",32+20,32+6
		dc.b	"IDE Wait States"
		dc.b	27,"Y",32+20,32+32
		dc.b	"DSP Wait States"
		dc.b	27,"Y",32+20,32+58
		dc.b	"External Clock"
		
		dc.b	27,"Y",32+24,32+6
		dc.b	"CHIP-Ram:"
		dc.b	27,"Y",32+24,32+32
		dc.b	"FAST-Ram:"
		dc.b	27,"Y",32+24,32+58
		dc.b	"Coprocessor:"
		
		dc.b	27,"Y",32+28,32+0
		dc.b	"  NOTE: - Put Wait States on DSP or IDE in case of bad working.",13,10
		dc.b	"   - Turn off the external clock if another clock enters Videl."
		dc.b	0
		EVEN

	ENDC
	IFEQ	langue-2
hard_page		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-9
		dc.b	27,"p","HARDWAREKONFIGURATION",27,"q"

		dc.b	27,"Y",32+17,32+10
		dc.b	"ENTurbo II Rev "
ct2_rev		dc.b	"A"
		
		dc.b	27,"Y",32+17,32+50
		dc.b	"Flash 1.00"
flash_ver		dc.b	" (12/34/5678"
flash_date	dc.b	")"
		
		dc.b	27,"Y",32+20,32+6
		dc.b	"IDE Wait States"
		dc.b	27,"Y",32+20,32+32
		dc.b	"DSP Wait States"
		dc.b	27,"Y",32+20,32+60
		dc.b	"Extern Takt"
		
		dc.b	27,"Y",32+24,32+6
		dc.b	"CHIP-Ram:"
		dc.b	27,"Y",32+24,32+32
		dc.b	"FAST-Ram:"
		dc.b	27,"Y",32+24,32+58
		dc.b	"Coprozessor:"
		
		dc.b	27,"Y",32+26,32+0
		dc.b	"ANMERKUNG: - Schalten Sie die DSP oder IDE-Waitstates an, falls Festplatte",13,10
		dc.b	"   oder DSP Probleme machen.",13,10
		dc.b	"           - Schalten Sie den externen Videotakt ab, falls ein weiterer Takt am",13,10
		dc.b	"             Videochip anliegt."
		dc.b	0
		EVEN

	ENDC

	IFEQ	langue
text_idewsyes	dc.b	27,"Y",32+21,32+12
		dc.b	"Oui",0
		EVEN

text_idewsno	dc.b	27,"Y",32+21,32+12
		dc.b	"Non",0
		EVEN
	ENDC

	IFEQ	langue-1
text_idewsyes	dc.b	27,"Y",32+21,32+12
		dc.b	"Yes",0
		EVEN

text_idewsno	dc.b	27,"Y",32+21,32+12
		dc.b	"No ",0
		EVEN
	ENDC
	IFEQ	langue-2
text_idewsyes	dc.b	27,"Y",32+21,32+12
		dc.b	" Ja ",0
		EVEN

text_idewsno	dc.b	27,"Y",32+21,32+12
		dc.b	"Nein",0
		EVEN
	ENDC

	IFEQ	langue
text_dspwsyes	dc.b	27,"Y",32+21,32+38
		dc.b	"Oui",0
		EVEN

text_dspwsno	dc.b	27,"Y",32+21,32+38
		dc.b	"Non",0
		EVEN
	ENDC
	IFEQ	langue-1
text_dspwsyes	dc.b	27,"Y",32+21,32+38
		dc.b	"Yes",0
		EVEN

text_dspwsno	dc.b	27,"Y",32+21,32+38
		dc.b	"No ",0
		EVEN
	ENDC
	IFEQ	langue-2
text_dspwsyes	dc.b	27,"Y",32+21,32+38
		dc.b	" Ja ",0
		EVEN

text_dspwsno	dc.b	27,"Y",32+21,32+38
		dc.b	"Nein",0
		EVEN
	ENDC
	IFEQ	langue
text_extyes	dc.b	27,"Y",32+21,32+59
		dc.b	"Non Connecte",0
		EVEN

text_extno	dc.b	27,"Y",32+21,32+59
		dc.b	"    Connecte",0
		EVEN
	ENDC
	IFEQ	langue-1
text_extyes	dc.b	27,"Y",32+21,32+59
		dc.b	"Not Connected",0
		EVEN

text_extno	dc.b	27,"Y",32+21,32+59
		dc.b	"    Connected",0
		EVEN
	ENDC

	IFEQ	langue-2
text_extyes	dc.b	27,"Y",32+21,32+56
		dc.b	"Nicht angeschlossen",0
		EVEN

text_extno	dc.b	27,"Y",32+21,32+56
		dc.b	"      angeschlossen",0
		EVEN
	ENDC


	IFNE	langue
chip_txt		dc.b	27,"Y",32+24,32+16
		dc.b	"14"
chip_val		dc.b	" MB",0
		EVEN

fast_txt		dc.b	27,"Y",32+24,32+42
		dc.b	"096"
fast_val		dc.b	" MB",0
		EVEN

	ELSE
chip_txt		dc.b	27,"Y",32+24,32+16
		dc.b	"14"
chip_val		dc.b	" Mo",0
		EVEN

fast_txt		dc.b	27,"Y",32+24,32+42
		dc.b	"096"
fast_val		dc.b	" Mo",0
		EVEN
	ENDC

	IFEQ	langue
copro_no		dc.b	27,"Y",32+24,32+71,"Non",0
		even

copro_yes		dc.b	27,"Y",32+24,32+71,"Oui",0
		even
	ENDC
	IFEQ	langue-1
copro_no		dc.b	27,"Y",32+24,32+71,"No",0
		even

copro_yes		dc.b	27,"Y",32+24,32+71,"Yes",0
		even
	ENDC

	IFEQ	langue-2
copro_no		dc.b	27,"Y",32+24,32+71,"Nein",0
		even

copro_yes		dc.b	27,"Y",32+24,32+71," Ja ",0
		even
	ENDC


		*-------------*
		* tests

test_pos		dc.w	0	;sur test ram

test_col		dc.b	27,"b",32+noir,27,"c",32+vert_f,0
		EVEN

	IFEQ	langue
test_page		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-10
		dc.b	27,"p","CONFIGURATION DES TESTS",27,"q"
		dc.b	27,"Y",32+17,32+20
		dc.b	"Tester Ram"
		dc.b	27,"Y",32+17,32+50
		dc.b	"Pause"
		dc.b	27,"Y",32+28,32+0
		dc.b	"  NOTE: - La pause est dcompte  partir du test.",13,10
		dc.b	"   - Les tests sont lancs seulement aprs un Reset  Froid."
		dc.b	0
		EVEN
	ENDC

	IFEQ	langue-1
test_page		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-10
		dc.b	27,"p","TESTING CONFIGURATION",27,"q"
		dc.b	27,"Y",32+17,32+20
		dc.b	"Testing Ram"
		dc.b	27,"Y",32+17,32+50
		dc.b	"Pause"
		dc.b	27,"Y",32+28,32+0
		dc.b	"  NOTE: - The waiting sequence is a countdown from the test.",13,10
		dc.b	"   - The tests are launched only after a Cold Reset."
		dc.b	0
		EVEN
	ENDC

	IFEQ	langue-2
test_page		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-9
		dc.b	27,"p","TESTE KONFIGURATION",27,"q"
		dc.b	27,"Y",32+17,32+21
		dc.b	"Teste Ram"
		dc.b	27,"Y",32+17,32+50
		dc.b	"Pause"
		dc.b	27,"Y",32+28,32+0
		dc.b	"ANMERKUNG: - Die Wartezeit wird nach den Tests heruntergezhlt. Die Tests",13,10
		dc.b	"   werden nur nach einem Kaltstart ausgefhrt."
		dc.b	0
		EVEN
	ENDC

	IFEQ	langue
text_ryes		dc.b	27,"Y",32+18,32+24
		dc.b	"Oui",0
		EVEN

text_rno		dc.b	27,"Y",32+18,32+24
		dc.b	"Non",0
		EVEN
	ENDC
	IFEQ	langue-1
text_ryes		dc.b	27,"Y",32+18,32+24
		dc.b	"Yes",0
		EVEN

text_rno		dc.b	27,"Y",32+18,32+24
		dc.b	"No ",0
		EVEN
	ENDC
	IFEQ	langue-2
text_ryes		dc.b	27,"Y",32+18,32+24
		dc.b	" Ja ",0
		EVEN

text_rno		dc.b	27,"Y",32+18,32+24
		dc.b	"Nein",0
		EVEN
	ENDC

	IFEQ	langue
text_wyes	dc.b	27,"Y",32+18,32+48
		dc.b	"Oui ",0
		EVEN

text_wno	dc.b	27,"Y",32+18,32+48
		dc.b	"Non |",0
		EVEN
	ENDC

	IFEQ	langue-1
text_wyes	dc.b	27,"Y",32+18,32+48
		dc.b	"Yes ",0
		EVEN

text_wno	dc.b	27,"Y",32+18,32+48
		dc.b	"No  |",0
		EVEN
	ENDC

	IFEQ	langue-2
text_wyes	dc.b	27,"Y",32+18,32+48
		dc.b	" Ja ",0
		EVEN

text_wno	dc.b	27,"Y",32+18,32+48
		dc.b	"Nein|",0
		EVEN
	ENDC

text_wait		dc.b	27,"Y",32+18,32+54,"00"
wait_val		dc.b	" s",0
		EVEN

		*-------------*
		* BOOT COMMUN

hd_pos		dc.w	0	;sur boot hd avant floppy
boot_pos		dc.w	0	;sur le boot 0
sel_order		dc.b	0
		even

hd_col		dc.b	27,"b",32+noir,27,"c",32+jaune_f,0
		even

	IFEQ	langue
hd_page		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-12
		dc.b	27,"p","CONFIGURATION DE DEMARRAGE",27,"q"
		
		dc.b	27,"Y",32+17,32+5
		dc.b	"Pilote de Disque dur"
		dc.b	27,"Y",32+20,32+6
		dc.b	"Id SCSI du Falcon"
		dc.b	27,"Y",32+23,32+4
		dc.b	"Priorit de dmarrage"

		dc.b	27,"Y",32+18,32+36
		dc.b	"Ordre de"
		dc.b	27,"Y",32+19,32+36
		dc.b	"recherche   =>"
		dc.b	27,"Y",32+20,32+36
		dc.b	"IDE/SCSI"

		dc.b	27,"Y",32+ypos_order,32+59
		dc.b	"Premier -"
		dc.b	27,"Y",32+ypos_order+1,32+59
		dc.b	"   .    -"
		dc.b	27,"Y",32+ypos_order+2,32+59
		dc.b	"   .    -"
		dc.b	27,"Y",32+ypos_order+3,32+59
		dc.b	"   .    -"
		dc.b	27,"Y",32+ypos_order+4,32+59
		dc.b	"   .    -"
		dc.b	27,"Y",32+ypos_order+5,32+59
		dc.b	"   .    -"
		dc.b	27,"Y",32+ypos_order+6,32+59
		dc.b	"   .    -"
		dc.b	27,"Y",32+ypos_order+7,32+59
		dc.b	"   .    -"
		dc.b	27,"Y",32+ypos_order+8,32+59
		dc.b	"   .    -"
		dc.b	27,"Y",32+ypos_order+9,32+59
		dc.b	"Dernier -"

		dc.b	27,"Y",32+23,32+30
		dc.b	"Lecteur de disquettes"

		dc.b	27,"Y",32+27,32+0
		dc.b	"  NOTE: - [Return] passe dans le mode dplacement d'un id dans la liste.",13,10
		dc.b	"     Un autre [Return] en sort. [Insert] active/dsactive un disque:",13,10
		dc.b	"                        disque actif     disque dsactiv."
		dc.b	0
		EVEN
	ENDC
	IFEQ	langue-1
hd_page		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-9
		dc.b	27,"p","BOOT CONFIGURATION",27,"q"
		dc.b	27,"Y",32+17,32+6
		dc.b	"Hard disk Driver"
		dc.b	27,"Y",32+20,32+7
		dc.b	"Falcon SCSI id"
		dc.b	27,"Y",32+23,32+7
		dc.b	"Boot priority"

		dc.b	27,"Y",32+18,32+37
		dc.b	"IDE/SCSI"
		dc.b	27,"Y",32+19,32+48
		dc.b	"=>"
		dc.b	27,"Y",32+20,32+36
		dc.b	"scan order"

		dc.b	27,"Y",32+ypos_order,32+61
		dc.b	"First -"
		dc.b	27,"Y",32+ypos_order+1,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+2,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+3,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+4,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+5,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+6,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+7,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+8,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+9,32+61
		dc.b	"Last  -"

		dc.b	27,"Y",32+23,32+30
		dc.b	"Floppy disk drive"

		dc.b	27,"Y",32+27,32+0
		dc.b	"  NOTE: - Select an id with [RETURN] move it with the arrows",13,10
		dc.b	"     accept the changes with [RETURN]. [Insert] enable/disable a drive:",13,10
		dc.b	"                         enable drive     disable drive."
		dc.b	0
		EVEN
	ENDC
	IFEQ	langue-2
hd_page		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-8
		dc.b	27,"p","BOOTKONFIGURATION",27,"q"
		dc.b	27,"Y",32+17,32+5
		dc.b	"Festplattentreiber"
		dc.b	27,"Y",32+20,32+7
		dc.b	"Falcon SCSI id"
		dc.b	27,"Y",32+23,32+7
		dc.b	"Boot-Prioritt"

		dc.b	27,"Y",32+18,32+37
		dc.b	"IDE/SCSI"
		dc.b	27,"Y",32+19,32+48
		dc.b	"=>"
		dc.b	27,"Y",32+20,32+32
		dc.b	"Abfragereihenfolge"

		dc.b	27,"Y",32+ypos_order,32+61
		dc.b	"First -"
		dc.b	27,"Y",32+ypos_order+1,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+2,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+3,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+4,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+5,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+6,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+7,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+8,32+61
		dc.b	"  .   -"
		dc.b	27,"Y",32+ypos_order+9,32+61
		dc.b	"Last  -"

		dc.b	27,"Y",32+23,32+30
		dc.b	"Floppy disk drive"

		dc.b	27,"Y",32+26,32+0
		dc.b	"ANMERKUNG: - Whlen Sie eine ID mit RETURN und bewegen Sie sie an eine",13,10
		dc.b	"   andere Stelle. Die nderung kann durch erneutes Drcken von",13,10
		dc.b	"             [RETURN] bernommen werden. [Insert] enable/disable a drive:",13,10
		dc.b	"                         enable drive     disable drive."
		dc.b	0
		EVEN
	ENDC

	IFEQ	langue
text_cciyes	dc.b	27,"Y",32+18,32+10
		dc.b	"Ccile ",0
		EVEN

text_ccino	dc.b	27,"Y",32+18,32+10
		dc.b	"Externe",0
		EVEN
	ENDC
	IFEQ	langue-1
text_cciyes	dc.b	27,"Y",32+18,32+09
		dc.b	" Ccile ",0
		EVEN

text_ccino	dc.b	27,"Y",32+18,32+09
		dc.b	"External",0
		EVEN
	ENDC
	IFEQ	langue-2
text_cciyes	dc.b	27,"Y",32+18,32+10
		dc.b	"Ccile",0
		EVEN

text_ccino	dc.b	27,"Y",32+18,32+10
		dc.b	"Extern",0
		EVEN
	ENDC

text_id		dc.b	27,"Y",32+21,32+13
val_id		dc.b	"0",0
		EVEN
		
	IFEQ	langue
text_ac		dc.b	27,"Y",32+24,32+6
		dc.b	"Disquette puis HDD",0
		EVEN

text_ca		dc.b	27,"Y",32+24,32+6
		dc.b	"HDD puis Disquette",0
		EVEN
	ENDC
	IFEQ	langue-1
text_ac		dc.b	27,"Y",32+24,32+6
		dc.b	"Floppy then HDD",0
		EVEN

text_ca		dc.b	27,"Y",32+24,32+6
		dc.b	"HDD then Floppy",0
		EVEN
	ENDC
	IFEQ	langue-2
text_ac		dc.b	27,"Y",32+24,32+4
		dc.b	"Floppy, dann Harddisk",0
		EVEN

text_ca		dc.b	27,"Y",32+24,32+4
		dc.b	"Harddisk, dann Floppy",0
		EVEN
	ENDC


txt_order		dc.b	27,"Y"
pos_order		dc.b	32+ypos_order,32+71,0
		EVEN

list_order	dc.w	txt_id8-list_order
		dc.w	txt_id9-list_order
		dc.w	txt_id10-list_order
		dc.w	txt_id11-list_order
		dc.w	txt_id12-list_order
		dc.w	txt_id13-list_order
		dc.w	txt_id14-list_order
		dc.w	txt_id15-list_order
		dc.w	txt_id16-list_order
		dc.w	txt_id17-list_order

txt_id8		dc.b	"SCSI 0 ",0
		EVEN
txt_id9		dc.b	"SCSI 1 ",0
		EVEN
txt_id10		dc.b	"SCSI 2 ",0
		EVEN
txt_id11		dc.b	"SCSI 3 ",0
		EVEN
txt_id12		dc.b	"SCSI 4 ",0
		EVEN
txt_id13		dc.b	"SCSI 5 ",0
		EVEN
txt_id14		dc.b	"SCSI 6 ",0
		EVEN
txt_id15		dc.b	"SCSI 7 ",0
		EVEN
txt_id16		dc.b	"IDE  0 ",0
		EVEN
txt_id17		dc.b	"IDE  1 ",0
		EVEN

txt_able		dc.b	8,"",0
		even

txt_disable	dc.b	8,"",0
		even
		
txt_sel		dc.b	8,"",0
		even

	IFEQ	langue
text_floppyyes	dc.b	27,"Y",32+24,32+36
		dc.b	"Prsent",0
		EVEN

text_floppyno	dc.b	27,"Y",32+24,32+36
		dc.b	"Absent ",0
		EVEN
	ENDC
	IFEQ	langue-1
text_floppyyes	dc.b	27,"Y",32+24,32+36
		dc.b	"Present",0
		EVEN

text_floppyno	dc.b	27,"Y",32+24,32+36
		dc.b	" Away  ",0
		EVEN
	ENDC
	IFEQ	langue-2
text_floppyyes	dc.b	27,"Y",32+24,32+36
		dc.b	"Present",0
		EVEN

text_floppyno	dc.b	27,"Y",32+24,32+36
		dc.b	" Away  ",0
		EVEN
	ENDC

		*-------------*
		* Ccile

dol_pos		dc.w	0	;sur boot hd avant floppy

dol_col		dc.b	27,"b",32+noir,27,"c",32+violet_f,0
		even

	IFEQ	langue
dol_page		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-13
		dc.b	27,"p","CONFIGURATION DE CECILE 1.74"
cec_ver_txt	dc.b	27,"q"
		
		dc.b	27,"Y",32+17,32+4
		dc.b	"Nombre de Dossiers"
		dc.b	27,"Y",32+20,32+2
		dc.b	"Tampon pour les donnes"
		dc.b	27,"Y",32+23,32+4
		dc.b	"Tampon pour les FAT"
		
		dc.b	27,"Y",32+23,32+29
		dc.b	"Partition de dmarrage"
		
		dc.b	27,"Y",32+17,32+31
		dc.b	"Mode IDE matre"
		dc.b	27,"Y",32+20,32+31
		dc.b	"Mode IDE esclave"
		dc.b	27,"Y",32+ypos_amo-2,32+56
		
		dc.b	"Nombre d'unites par"
		dc.b	27,"Y",32+ypos_amo-1,32+58
		dc.b	"support amovible"
		
		dc.b	27,"Y",32+ypos_amo,32+56
		dc.b	"IDE 0:"
		dc.b	27,"Y",32+ypos_amo+1,32+56
		dc.b	"IDE 1:"
		
		dc.b	27,"Y",32+ypos_amo,32+67
		dc.b	"SCSI 0:"
		dc.b	27,"Y",32+ypos_amo+1,32+67
		dc.b	"SCSI 1:"
		dc.b	27,"Y",32+ypos_amo+2,32+67
		dc.b	"SCSI 2:"
		dc.b	27,"Y",32+ypos_amo+3,32+67
		dc.b	"SCSI 3:"		
		dc.b	27,"Y",32+ypos_amo+4,32+67
		dc.b	"SCSI 4:"
		dc.b	27,"Y",32+ypos_amo+5,32+67
		dc.b	"SCSI 5:"
		dc.b	27,"Y",32+ypos_amo+6,32+67
		dc.b	"SCSI 6:"
		dc.b	27,"Y",32+ypos_amo+7,32+67
		dc.b	"SCSI 7:"

		dc.b	27,"Y",32+27,32+0
		dc.b	"  NOTE: - , et TAB change de champ.  et  changent la valeur de 1.",13,10
		dc.b	"                         Shift+flches changent la valeur de 10.",13,10
		dc.b	"                           Control+flches changent la valeur de 100."
		dc.b	0
		EVEN
	ENDC
	IFEQ	langue-1
dol_page		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-10
		dc.b	27,"p","CECILE CONFIGURATION 1.84"
cec_ver_txt	dc.b	27,"q"

		dc.b	27,"Y",32+17,32+6
		dc.b	"Number of Folders"
		dc.b	27,"Y",32+20,32+6
		dc.b	"Buffer for data"
		dc.b	27,"Y",32+23,32+6
		dc.b	"Buffer for FAT"
		
		dc.b	27,"Y",32+17,32+31
		dc.b	"Master IDE mode"
		dc.b	27,"Y",32+20,32+32
		dc.b	"Slave IDE mode"
		dc.b	27,"Y",32+ypos_amo-2,32+56
		
		dc.b	27,"Y",32+23,32+32
		dc.b	"Boot partition"

		dc.b	27,"Y",32+ypos_amo-2,32+57
		dc.b	"Number of units per"
		dc.b	27,"Y",32+ypos_amo-1,32+58
		dc.b	"removable support"

		dc.b	27,"Y",32+ypos_amo,32+56
		dc.b	"IDE 0:"
		dc.b	27,"Y",32+ypos_amo+1,32+56
		dc.b	"IDE 1:"
		
		dc.b	27,"Y",32+ypos_amo,32+67
		dc.b	"SCSI 0:"
		dc.b	27,"Y",32+ypos_amo+1,32+67
		dc.b	"SCSI 1:"
		dc.b	27,"Y",32+ypos_amo+2,32+67
		dc.b	"SCSI 2:"
		dc.b	27,"Y",32+ypos_amo+3,32+67
		dc.b	"SCSI 3:"
		dc.b	27,"Y",32+ypos_amo+4,32+67
		dc.b	"SCSI 4:"
		dc.b	27,"Y",32+ypos_amo+5,32+67
		dc.b	"SCSI 5:"
		dc.b	27,"Y",32+ypos_amo+6,32+67
		dc.b	"SCSI 6:"
		dc.b	27,"Y",32+ypos_amo+7,32+67
		dc.b	"SCSI 7:"

		dc.b	27,"Y",32+27,32+0                             
		dc.b	"  NOTE: - use , and TAB to select a field.  and  change value by step of 1.",13,10
		dc.b	"                                  Shift+arrows change value by step of 10.",13,10
		dc.b	"                                     Control+arrows change value by step of100."
		dc.b	0
		EVEN
	ENDC

	IFEQ	langue-2
dol_page		dc.b	27,"Y",32+14,32,27,"J"
		dc.b	27,"Y",32+15,32+39-12
		dc.b	27,"p","KONFIGURATION VON CECILE 1.84"
cec_ver_txt	dc.b	27,"q"

		dc.b	27,"Y",32+17,32+3
		dc.b	"Anzahl an Unterordnern"
		dc.b	27,"Y",32+20,32+6
		dc.b	"Cache fr Daten"
		dc.b	27,"Y",32+23,32+7
		dc.b	"Cache fr FAT"
		
		dc.b	27,"Y",32+17,32+31
		dc.b	"Master IDE mode"
		dc.b	27,"Y",32+20,32+32
		dc.b	"Slave IDE mode"
		dc.b	27,"Y",32+ypos_amo-2,32+56
		
		dc.b	27,"Y",32+23,32+33
		dc.b	"Bootpartition"

		dc.b	27,"Y",32+ypos_amo-2,32+61
		dc.b	"Anzahl an"
		dc.b	27,"Y",32+ypos_amo-1,32+55
		dc.b	"Wechselmedien-Laufwerken"

		dc.b	27,"Y",32+ypos_amo,32+56
		dc.b	"IDE 0:"
		dc.b	27,"Y",32+ypos_amo+1,32+56
		dc.b	"IDE 1:"
		
		dc.b	27,"Y",32+ypos_amo,32+67
		dc.b	"SCSI 0:"
		dc.b	27,"Y",32+ypos_amo+1,32+67
		dc.b	"SCSI 1:"
		dc.b	27,"Y",32+ypos_amo+2,32+67
		dc.b	"SCSI 2:"
		dc.b	27,"Y",32+ypos_amo+3,32+67
		dc.b	"SCSI 3:"
		dc.b	27,"Y",32+ypos_amo+4,32+67
		dc.b	"SCSI 4:"
		dc.b	27,"Y",32+ypos_amo+5,32+67
		dc.b	"SCSI 5:"
		dc.b	27,"Y",32+ypos_amo+6,32+67
		dc.b	"SCSI 6:"
		dc.b	27,"Y",32+ypos_amo+7,32+67
		dc.b	"SCSI 7:"

		dc.b	27,"Y",32+26,32+0
		dc.b	"ANMERKUNG: - Whlen Sie ein Feld mit , und TAB.",13,10
		dc.b	"                                    and  change value by step of 1.",13,10
		dc.b	"                                       Shift+arrows change value by step of 10.",13,10
		dc.b	"                                    Control+arrows change value by step of 100."
		dc.b	0
		EVEN
	ENDC
text_folder	dc.b	27,"Y",32+18,32+11,"00000"
val_folder	dc.b	0
		EVEN

text_data		dc.b	27,"Y",32+21,32+11,"00000"
val_data		dc.b	0
		EVEN

text_fat		dc.b	27,"Y",32+24,32+11,"00000"
val_fat		dc.b	0
		EVEN

txt_mideauto	dc.b	27,"Y",32+18,32+37
		dc.b	"AUTO",0
		EVEN
txt_midechs	dc.b	27,"Y",32+18,32+37
		dc.b	" CHS",0
		EVEN
txt_midelba	dc.b	27,"Y",32+18,32+37
		dc.b	" LBA",0
		EVEN

txt_sideauto	dc.b	27,"Y",32+21,32+37
		dc.b	"AUTO",0
		EVEN
txt_sidechs	dc.b	27,"Y",32+21,32+37
		dc.b	" CHS",0
		EVEN
txt_sidelba	dc.b	27,"Y",32+21,32+37
		dc.b	" LBA",0
		EVEN

txt_part		dc.b	27,"Y",32+24,32+38
part_val		dc.b	"A:\",0
		EVEN

text_irm0		dc.b	27,"Y",32+ypos_amo,32+63
val_irm0		dc.b	"0",0
		EVEN

text_irm1		dc.b	27,"Y",32+ypos_amo+1,32+63
val_irm1		dc.b	"0",0

text_rmx		dc.b	27,"Y",0,32+75
val_rmx		dc.b	"x",0
		EVEN

		*-------------*

nvram_defaut
.hd_boot		dc.w	$0080	;type de boot TOS

.nvm_valid	dc.l	"_DOL"	;super flag !!!

.akp		dc.w	$202	;langue/clavier
.idt		dc.w	$112f	;heure&date/sparateur "/"
.pause		dc.b	15	;pause
		dc.b	$0	;rserv (0)
		dc.b	$0	;rserv (0)
		dc.b	$0	;rserv (0)

.nvm_video	dc.w	$38	;mode par dfaut (Mono VGA/PAL)
.arbid		dc.b	$87	;arb+id
		dc.b	0	;rserv (0)

		*-------------------*
		* partie Dolmen

		* nb d'unit par id ide (pour les amovibles en atapi)
.cci_rmunits2	dc.b	2	;ide 0
		dc.b	2	;ide 1


			;xFSDBRWF
.flags_boot	dc.b	%00000100	;7,x: rserv (0)
				;6,x: Floppy prsent (0) absent (1)
				;5,S: Enter Setup (0) ou skip (1)
				;4,D: boot sur TOS (0) ou Dolmen (1)
				;3,B: boot TOS 4.0x si boot TOS choisi
				;2,R: test ram ok (1) (0 pas de test)
				;1,W: pause ok (1) ou pas de pause (0)
				;0,F: boot HD avant Floppy (1) ou
				;     floppy avant hd(0)
			;CxxEDIxx
.flags_boot2	dc.b	%10000100	;7,C: Boot comme le TOS(0)ou avec ccile(1)
				;     Uniquement pour le Boot TOS !
				;6,x: rserv (0)
				;5,x: rserv (0)
				;4,E: coupe la clock externe
				;3,D: 12/24 WS sur DSP
				;2,I: 3/5 cycle sur l'IDE
				;1,x: rserv (0)
				;0,x: rserv (0)

.boot_nvm		dc.b	"C"-"A"	;numro de la partition de boot
.BootOrder      
		dc.b	$10	;ide  0
		dc.b	$11	;ide  1
		dc.b	$8	;scsi 0
		dc.b	$9	;scsi 1
		dc.b	$a	;scsi 2
		dc.b	$b	;scsi 3
		dc.b	$c	;scsi 4
		dc.b	$d	;scsi 5
		dc.b	$e	;scsi 6
		dc.b	$f	;scsi 7

		dc.b	$ff	;fin de la liste

.cci_folder	dc.w	300
.cci_data	dc.w	8
.cci_fat		dc.w	8

.cci_rmunits	dc.b	2	;scsi 0
		dc.b	2
		dc.b	2
		dc.b	2
		dc.b	2
		dc.b	2	;(zip 5)
		dc.b	2	;(jazz 6)
		dc.b	2	;scsi 7
		
		dc.b	0	;notsum
		dc.b	0	;sum

		*-------------*

*----------------------------------------------------------------------------*
		BSS
*----------------------------------------------------------------------------*

		*-------------*

*----------------------------------------------------------------------------*
