*-------------------------------------------------------------------------*	
*		copie de la rom TOS 4.04+modifs de la rom
*-------------------------------------------------------------------------*
		TEXT
*-------------------------------------------------------------------------*


		OPT	nocase
		opt	O+
		opt	nowarn
		opt	noeven
		opt	odl
		OPT	X-
		opt	p=68030
		opt	p=68881
		
		include	..\FLASH.RS

	IFEQ	langue
		OUTPUT	D:\BIN\TOSBOOTF.BIN
	ENDC
	IFEQ	langue-1
		OUTPUT	D:\BIN\TOSBOOTE.BIN
	ENDC
	IFEQ	langue-2
		OUTPUT	D:\BIN\TOSBOOTD.BIN
	ENDC

*----------------------------------------------------------------------------*
		TEXT
*----------------------------------------------------------------------------*

		*-------------*

		include	D:\DOLMEN\SOURCES\XLIB\GEM.EQU
		include	D:\DOLMEN\SOURCES\XLIB\BIOS.EQU
		include	D:\DOLMEN\SOURCES\XLIB\XBIOS.EQU

		include	D:\DOLMEN\SOURCES\DOLMEN.RS
		include	D:\DOLMEN\SOURCES\BORIS\BORIS.RS
		include	D:\DOLMEN\SOURCES\BORIS\VIDEL\VIDEL.RS
		
		include	D:\DOLMEN\SOURCES\BORIS\CECILE.BRS\SYS\SYSHEAD.RS
		include	D:\DOLMEN\SOURCES\BORIS\CECILE.BRS\HAL\IDE.EQU
		include	D:\DOLMEN\SOURCES\BORIS\CECILE.BRS\HAL\SCSI.EQU

		*-------------*

DEBUG		MACRO
		bra.s	.SUITE\@
		dc.l	'CNTL'
.MES\@		dc.b	\1
		even
		dc.w	*-.MES\@
		dc.l	'CNTL'
.SUITE\@
		illegal
		ENDM
	
		*-------------*

vec_err		equ	1

		; structure root sector
		rsset	$1c2
hd_siz		rs.l	1
p0_flg		rs.b	1
p0_id		rs.b	3
p0_st		rs.l	1
p0_siz		rs.l	1
p1_flg		rs.b	1
p1_id		rs.b	3
p1_st		rs.l	1
p1_siz		rs.l	1
p2_flg		rs.b	1
p2_id		rs.b	3
p2_st		rs.l	1
p2_siz		rs.l	1
p3_flg		rs.b	1
p3_id		rs.b	3
p3_st		rs.l	1
p3_siz		rs.l	1
bsl_st		rs.l	1
bsl_cnt		rs.l	1

*-------------------------------------------------------------------------*
* une pile est dj en place
* pendant le boot:
* A6: pointe sur les sysvars
* A5: pointe sur les vars pour le TOS
* A7: pointe sur la pile du setup
*-------------------------------------------------------------------------*

		*-------------------*
Start_boot
	* coupe les GPIOs
DSP_SHUT
		move.w	#7,$ffff8940.w

	* teste cartouche diagnostique
DIAGF030
		cmp.l	#$fa52235f,$fa0000
		bne.s	.pas_diag
		lea	.pas_diag(pc),a6
		jmp	$fa0004
.pas_diag
	* caches&Vbr
MC680xx_INIT
		move.l	#$808+$3111,d0	;vide les caches et les ractive
		movec.l	d0,CACR
		moveq	#0,D0
		movec.l	D0,VBR

	* Recherche variables systme en NVRAM
INIT1
		lea	fast_dol_start+dol_vars,a6
		sf	system_run(a6)

	* vido initialisation
.VIDEO_PUT
	* palette
		move	([VideoVars,a6],scrn_p),d1
		cmp	#1,d1
		beq.s	.fin_video
		
		lea	$ffff9800.w,a0
		moveq	#16-1,d0
		cmp.b	#"A",ct2_ok(a6)
		bne.s	.pas_col_a
		move.l	#$000000a4,d1	;bleu_f (rev a)
		bra.s	.clr_pal
.pas_col_a
		move.l	#$00600060,d1	;cian_f (rev b)
.clr_pal
		move.l	d1,(a0)+
		dbra	d0,.clr_pal
.fin_video
	
	* version du TOS
		moveq	#$f,d0
		and	romtos_addr+rom_version,d0
		
		move	d0,tos_ver
		
		move.l	(tos_vars-1*4.w,pc,d0*4),a5
		move.l	a5,tos_vars_off
		
		add.b	#"0",d0
		move.b	d0,intro_ver

	* dmarrage  froid?
RES_VECTOR
		btst	#6,$ffff8007.w
		beq.s	.pas_resvec

		cmp.l	#magic_mval,memvalid.w
		bne.s	.pas_resvec

		cmp.l	#magic_mval2,memval2.w
		bne.s	.pas_resvec

		cmp.l	#magic_mval3,memval3.w
		bne.s	.pas_resvec

		cmp.l	#magic_rval,ramvalid.w
		bne.s	.pas_resvec

		clr.b	$ffff8001.w	;un vestige du ST!
.ResVec_return
		cmp.l	#magic_resval,resvalid.w
		bne.s	.pas_resvec
		move.l	resvector.w,d0
		btst	#0,D0		;pas d'adresse impaire?!
		bne.s	.pas_resvec
		movea.l	d0,a0
		lea	.ResVec_return(pc),a6

		jmp	(a0)		;=>reset_vector
.pas_resvec
	* reset  froid, encore!
WHAT_START
		sf	ram_clr(a6)

		bset	#6,$ffff8007.w
		seq	ram_clr(a6)

	* rinitialise la ram: reset  froid
cold_start
		moveq	#0,d1
		move.l	d1,d2
		move.l	d1,d3
		move.l	d1,d4
		move.l	d1,d5
		move.l	d1,d6
		move.l	d1,d7
		move.l	d1,a1

	* efface la fast-ram
.fast_clr
		cmp.l	#magic_rval,ramvalid.w
		beq.s	.no_fast

		move.l	fast_top(a6),d0
		beq.s	.no_fast
		move.l	d0,a0
		sub.l	fast_bot(a6),d0	;a commence en fast_bot
		beq.s	.no_fast
		lsr.l	#8,d0		;par paquets de 256 octets
.clr_fast
		rept	8
		movem.l	d1-7/a1,-(a0)
		endr
		subq.l	#1,d0
		bne.s	.clr_fast
.no_fast

	* efface la chip-ram
		
		cmpi.l	#magic_mval,memvalid.w
		bne.s	.chip_clr
		cmpi.l	#magic_mval2,memval2.w
		bne.s	.chip_clr
		cmpi.l	#magic_mval3,memval3.w
		bne.s	.chip_clr

		tst.b	ram_clr(a6)
		beq.s	.clr_chip_end
.chip_clr
		st	ram_clr(a6)	;CHIP-RAM effac

		move.l	chip_top(a6),a0
		move.l	a0,d0
		sub.l	#$300,d0		;du haut jusqu' $300
					;(comme le TOS!)
		lsr.l	#8,d0	;par paquets de 256 octets
.clr_chip
		rept	8
		movem.l	d1-7/a1,-(a0)
		endr
		subq.l	#1,d0
		bne.s	.clr_chip
.clr_chip_end

	* variables systmes
.update_sysvars
		move.l	chip_top(a6),phystop.w
		move.l	#magic_mval,memvalid.w
		move.l	#magic_mval2,memval2.w
		move.l	#magic_mval3,memval3.w

		move.l	fast_top(a6),ramtop.w
		move.l	#magic_rval,ramvalid.w

	* Si reset  chaud...
warm_start
		lea	rte_adr(pc),a3
		lea	rts_adr(pc),a4
		lea	reset_hard(pc),a1

		lea	BusError.w,a0		;bus_error
		move	#(CentBusy-BusError)/4-1,d0
.init_vec
		move.l	a1,(a0)+		;tout les vecteurs
		dbra	d0,.init_vec

		move.l	a3,Div0.w		;divbyzero

	* initialise les autovecteurs
		move.l	a3,AVec7.w	;autov_int7
		moveq	#7-1,d0		;7 autovecteurs
		lea	AVec1.w,a1	;autov_int1
.init_autovec
		move.l	a3,(a1)+		;=>"RTE"
		dbra	d0,.init_autovec
	* VBL
		move.l	t_vbl(a5),VBLvec.w
	* HBL
		move.l	t_hbl(a5),HBLvec.w
	* AES/VDI
		move.l	a3,Trap2.w        ;trp2vec ("RTE")
	* BIOS
		move.l	t_trap13(a5),Trap13.w
	* XBIOS
		move.l	t_trap14(a5),Trap14.w
	* LINEA
		move.l	t_linea(a5),LineA.w
	* ETV_TIMER
		move.l	a4,etv_timer.w       

	* ETV_CRITIC
		move.l	t_etvcritic(a5),etv_critic.w
	* ETV_TERM
		move.l	a4,etv_term.w

	* VBL queue
		lea	$4ce.w,a0       ;_vbl_list
		move.l	a0,_vblqueue.w
		move	#8-1,D0
.clr_vbl
		clr.l	(a0)+
		dbra	d0,.clr_vbl

	* init routines I/Os
		move.l	t_ios(a5),a0

		lea	xconstat.w,a1		;xconstat
		moveq	#$20-1,d0		;4*8 vecteurs
.copie_ios
		move.l	(a0)+,(a1)+
		dbra	d0,.copie_ios

	* installation vars systmes
Inst_sysvars
		move.l	romtos_addr+rom_gem_magic,a0
		cmp.l	#$87654321,(a0)
		beq.s	.pas_magic
		lea	romtos_addr+rom_os_start,a0	;on y va jamais
.pas_magic
	* efface la fin de vars systmes non documentes
		tst.b	ram_clr(a6)
		bne	.dj

		move.l	4(a0),d0
		move.l	d0,a1
		sub.l	#$a88,d0
		lsr.l	#2,d0
		subq	#1,d0
.clr_sysvars
		clr.l	-(a1)
		dbra	d0,.clr_sysvars
.dj
	* met en place les vars
		move.l	4(a0),end_os.w
		move.l	8(a0),exec_os.w

		move.l	t_hdvinit(a5),hdv_init.w
		move.l	t_hdvrw(a5),hdv_rw.w
		move.l	t_hdvbpb(a5),hdv_bpb.w
		move.l	t_hdvmediach(a5),hdv_mediach.w
		move.l	t_hdvboot(a5),hdv_boot.w

		move.l	t_prvlsto(a5),$506.w	;prv_lsto
		move.l	t_prvlst(a5),$50A.w		;prv_lst
		move.l	t_prvauxo(a5),$50E.w	;prv_auxo
		move.l	t_prvaux(a5),$512.w		;prv_aux

		move.l	t_scrdump(a5),scr_dump.w

		move.l	phystop.w,_memtop.w
		move.l	phystop.w,_v_bas_ad.w		

		* insre le _FRB entre la fin du systme
		* et le dbut de la zone utilisateur

		move.l	end_os.w,d0

		tst.l	ramtop.w
		beq.s	.no_fast
		add.l	#64*1024,d0	;buffer _FRB
.no_fast
		move.l	d0,_membot.w

		move	#8,nvbls.w
		st	_fverify.w
		move	#3,seekrate.w
		move.l	#$1cc6,_dskbufp.w
		move	#-$1,_dumpflg.w

		move.l	#$e00000,_sysbase.w

		move.l	#$93a,$4A2.w	;savptr
		lea	rts_adr(pc),a0
		move.l	a0,$46e.w

		clr.l	_drvbits.w

		move.l	t_bellhook(a5),$5AC.w	;bell_hook
		move.l	t_kclhook(a5),$5B0.w	;kcl_hook

		jsr	([t_initvars,a5])	;init vars systme
					;recopie de end_os
		*------------*

*-------------------------------------------------------------------------*

		*------------*

	* installe les cookies
COOKIE_JAR
		lea	$980,a0
		move.l	a0,_p_cookies.w
	* TOS
		move.l	#"_TOS",(a0)+
		move.l	#$700,d0
		add.b	tos_ver+1(pc),d0
		move.l	d0,(a0)+
	* CT2 a&b
		move.l	#"_CT2",(a0)+
		move.l	ct2_val(a6),(a0)+
	* _CPU
		move.l	#"_CPU",(A0)+	;_CPU
		move.l	#$1e,(a0)+
		st	$59f.w		;stack_frame
	* PMMU
		move.l	#"PMMU",(a0)+
		;move.l	#dolmen_version,(a0)+
		move.l	#rts_adr,(a0)+
	* _VDO
		move.l	#"_VDO",(a0)+	;_VDO
		move.l	#$30000,(a0)+	;VIDEL

	* _MCH
		move.l	#"_MCH",(a0)+
		move.l	#$30000,(a0)+	;Falcon
	* _SWI
		move.l	#"_SWI",(a0)+
		moveq	#0,d0
		move	$ffff9200.w,d0
		lsr	#8,d0
		move.l	d0,(a0)+
	* _SND
		moveq	#$1f,d1
		move.l	#"_SND",(a0)+
		btst	#7,d0		;pas de dma?
		bne.s	.no_dma
		bclr	#1,d1
.no_dma
		move.l	d1,(a0)+
	* _FDC
		btst	#6,d0
		bne.s	.pas_floppy
		move.b	#8,$16d4.w
		move.l	#"_FDC",(a0)+
		move.l	#$1415443,(a0)+	;HD+"ATC"
.pas_floppy
	* _FPU
		move.l	#"_FPU",(a0)+

		moveq	#0,D7		;pas de copro?
		move.l	LineF.w,a3
		move.l	CoproProt.w,a4

		lea	.E004AE(pc),a2	;come back
		move.l	a2,LineF.w  
		move.l	a2,CoproProt.w

		lea	CoproVec.w,a2
		movem.l	(a2),d0-d6	;mega-sauvegarde
		lea	.E004A8(pc),a5	;come back copro

		rept	7
		move.l	a5,(a2)+
		endr
		clr.l	-(sp)
		move.l	sp,a2
		frestore	(sp)
.e004a8
		move.l	#$60000,d7	;68882
.e004ae
		move.l	a2,sp
		addq.l	#4,sp
		move.l	a3,LineF.w
		move.l	a4,CoproProt.w
		movem.l	d0-d6,CoproVec.w	;mega-restauration
		move.l	d7,(a0)+
	* _FRB
		move.l	fast_bot(a6),d1
		move.l	fast_top(a6),d0
		beq.s	.no_fast

		sub.l	d1,d0
		beq.s	.no_fast
		move.l	#"_FRB",(a0)+
		move.l	end_os.w,(a0)+
.no_fast
	* NVRAM...
		move	nvram_buffer(a6),$a80.w	;type de boot
		addq.l	#6,a5
	* _AKP
		move.l	#"_AKP",(a0)+
		clr.l	d0
		move	akp(a6),d0
		move.l	d0,(a0)+
	* _IDT
		move.l	#"_IDT",(a0)+
		move	idt(a6),d0
		move.l	d0,(a0)+
	* _TSR
		move.l	#"_TSR",(a0)+
		clr.l	(a0)+		;pas dans le TSR
		
	* pause
		move.l	pause(a6),$a82.w

	* init mode vido
		move	nvm_video(a6),$184C.w
				;mode vido de dpart...
	* fin cookies
		clr.l	(a0)+
		move.l	#$20,(a0)
		
		*------------*

*-------------------------------------------------------------------------*
		
		*------------*
INIT_HARD
		;move	#$2700,sr		;passe en I7 le temps de tout rgler
		
		move.l	tos_vars_off(pc),a5	;pointeur sur vars TOS

	* Clavier, timer c et timer d
		jsr	([t_inithard,a5])

	* init timer a =>50 pr-div compteur nul : 49152 Hz
		move	#$400,D0

		jsr	([t_inittimera,a5])

		pea	reset_ikbd(pc)
		move.w	#2-1,-(sp)
		jsr	([t_writeikbd,a5])
		addq.l	#6,sp

	* init timer a =>200 pr-div compteur nul : 12288 Hz
		move	#$700,d0
		moveq	#14,d1
.timera
		jsr	([t_inittimera,a5])

		dbra	d1,.timera

	* test cartouche
		moveq 	#2,d0
		bsr	test_cartouche

	* vecteur pour les changements de rsolution
		move.l	#romtos_addr+rom_header,$46e.w	;swv_vec

	* met en route la vbl systme
		move	#1,vblsem.w

	* test cartouche
		clr	d0
		bsr	test_cartouche

	* Lache les interruptions: vrrrooooummmmmmm!!!!!!
		move	#$2300,sr		;VBL, TIMERC et Clavier en route

		moveq	#1,d0
		bsr	test_cartouche

		move.l	t_prviol(a5),PrViol.w

		move.l	phystop.w,_memtop.w	;phystop->_memtop

	* init GEMDOS, VDI, ...
		bsr	INIT_GEMDOS
		st	system_run(a6)	;utile dans le "bomber"
		
	* change de rsolution
		moveq	#_80c+_VGA+%000,d0
		bfextu	($ffff8006.w,za0){0:2},d1
		moveq	#~$1,d7
		and.b	$ffff820a.w,d7	;coupe la clock ext
		move.b	d7,$ffff820a.w	;pour le tos
		btst	#0,d1
		beq.s	.vga
		or.b	#%1,d7		;remet la clock ext ?!
		eor	#_vert,d0
.vga
		move	d0,-(sp)
		move	#3,-(sp)
		clr.l	-(sp)
		clr.l	-(sp)
		jsr	([t_setscreen,a5])
		lea	12(sp),sp
		move.b	d7,$ffff820a.w	;remet en place la clock
	
	* fond bleu_f et texte gris
		clr.l	colorptr.w	;fait chi :-(((
		lea	$ffff9800.w,a0
		cmp.b	#"A",ct2_ok(a6)
		bne.s	.col_b
		move.l	#$000000a4,d0	;bleu_f (rev a)
		bra.s	.col_a
.col_b
		move.l	#$00600060,d0	;cian_f (rev b)
.col_a
		move.l	d0,(a0)+
		move.l	#$cccc00cc,(a0)

	* init DSP
DSP_INIT
		jsr	([t_initdsp,a5])

	* init sdma
SDMA_INIT
		move	#1,-(sp)
		move	#0,-(sp)
		move	#0,-(sp)
		move	#8,-(sp)
		move	#0,-(sp)
		jsr	([t_devconnect,a5])
		addq.l	#6,sp	;manque 4

		clr	(sp)
		jsr	([t_sdma1,a5])

		move.l	#$20080,(sp)
		jsr	([t_sdma2,a5])

		move	#3,(SP)
		jsr	([t_sdma2,a5])

		move.l	#$60003,(sp)
		jsr	([t_sdma2,a5])

		move	#4,(sp)
		jsr	([t_sdma2,a5])

		move	#5,(sp)
		jsr	([t_sdma2,a5])
		addq.w  #4,SP	;correction final

	* NVRAM: lit l'heure et la date
TIMDAT
		move	romtos_addr+rom_sys_date,$6cfe	;$1a68 par dfaut
					;date: 8 mars 1993 (tos 4.04)
					;=>remplac par date de la
					;  version de ce boot!
		jsr	([t_tstnvram,a5])
		beq.s	.nvram_fin

		jsr	([t_readdattim,a5])
		swap	d0
		tst.b	d0
		beq.s	.nvram_fin
		move.l	d0,$6cfc.w	;heure&date
.nvram_fin
	* coupe le timer A
		clr.b	MFP_BASE+TACR.w     ;tacr
		bclr	#5,MFP_BASE+IERA.w  ;iera
		
		*------------*

*-------------------------------------------------------------------------*

		*------------*
		* prsentation
		*------------*

	* premire prsentation
		lea	intro(pc),a0
		bsr	aff_txt

	* Reset SCSI obligatoire en cas de reset pendant des oprations
	* disques. Pour Dolmen a n'a pas lieu d'tre car le driver est
	* interne et le reset aussi du coup.
		btst	#7,flags_boot2(a6)
		bne.s	.no_reset			;pas utile vu que l'on va
						;booter avec Ccile
		bsr	_ScsiReset		;from Ccile
		move.b	#%11100000,IdeDriveHead	;reset Ide version
		clr.b	IdeDeviceCtrl		;courte
.no_reset
	* remplace les resets violent par une routine propre
Change_buserr
		lea	BusError.w,a0
		lea	reset_hard(pc),a1
		lea	ErrorVec(pc),a2
		move	#(CentBusy-BusError)/4-1,d0
.nxt_vec
		cmp.l	(a0)+,a1
		bne.s	.suite
		move.l	a2,-4(a0)
.suite
		dbra	d0,.nxt_vec

	* test ram+pause (pipo): l'appui sur une touche coupe tout!
Check
		btst	#2,flags_boot(a6)
		beq.s	.no_ramtest
		bsr	test_ram
.no_ramtest
		btst	#1,flags_boot(a6)
		beq.s	.no_wait
		bsr	wait
.no_wait
	* go setup ?
Setup_test
		bsr	Go_setup

	* Et c'est parti...

	* change de rsolution
		bfextu	($ffff8006.w,za0){0:2},d1
		moveq	#~$1,d7
		and.b	$ffff820a.w,d7	;coupe la clock ext
		move.b	d7,$ffff820a.w	;pour le tos
		btst	#0,d1
		beq.s	.vga
		or.b	#%1,d7		;remet la clock ext ?!
.vga
		move	nvm_video(a6),-(sp)
		move	#3,-(sp)
		clr.l	-(sp)
		clr.l	-(sp)
		jsr	([t_setscreen,a5])
		lea	12(sp),sp
		move.b	d7,$ffff820a.w	;pour garder la clock externe

	* fond bleu et texte jaune
		clr.l	colorptr.w	;fait chi :-(((
		lea	$ffff9800.w,a0
		move.l	#$000000ff,(a0)
		moveq	#%111,d0
		and	nvm_video(a6),d0
		move	(cols.w,pc,d0*2),d0
		bmi.s	.pas_cool
		move.l	#$ffff0000,(-1*4.w,a0,d0*4)
.pas_cool
	* presentation
		lea	boot_go(pc),a0
		bsr	aff_txt
		
	* cartouche disque prioritaire
		moveq	#3,d0
		bsr	test_cartouche	;Cartouche disque
		
	* boot sur floppy
		btst	#6,flags_boot(a6)
		bne.s	.PAS_BOOT_FLOPPY	;non!

		bsr	BootFloppy
.PAS_BOOT_FLOPPY

	* disque dur
		bsr	BootHd

	* revalide le Floppy au cas ou le driver (Ccile&ext) est
	* remis par erreur le A&B
		bsr	ValidFloppy
		
	* type du boot sous TOS
BOOT_TOS
	* validation du chemin (variable d'environement)
		move.l	tos_basepage(pc),a1
		
		move.l	#PATH_TOS,p_env(a1)
		move	_bootdev.w,d0         
		moveq	#"A",d1
		add.b	d0,d1
		move.b	d1,PATH_TOS_LET

	* dossier AUTO
		bsr	AUTO_FOLDER

	* ...et le GEM
		tst	$482.w	;_cmdload
		beq.s	.boot_rom	;T_E007BE

	* lancement de COMMAND.PRG
.boot_ext
		lea	go_command(pc),a0
		bsr	aff_txt

		move.l	#$e00000,$4f2.w	;_sysbase
					;si on le laisse
					;cela empche les modifications
					;de ces variables
		clr.l	-(sp)
		pea	string_null(pc)
		pea	string_command(pc)
		clr	-(sp)	;charge+excute
		bra	.pexec

	* boot de l'os en rom
.boot_rom
		lea	fast_dol_start+dol_vars,a6
		lea	Go_os(pc),a0
		bsr	aff_txt

		move.l	#$e00000,_sysbase.w
					;si on le laisse
					;cela empche les modifications
					;de ces variables
		move	_bootdev.w,d0         
		moveq	#"A",d1
		add.b	d0,d1
		
	* partition de boot pour les ACC...
		lea	fast_dol_start+dol_vars,a6
		move.l	tos_vars_off(pc),a5
		lea	romtos_copy,a4
		move.l	#$4e714e71,d2		;2 nops
	* ACC
		move.l	a4,a0
		add.l	patch_acc(a5),a0
		move	d0,(a0)
	
	* NEWDESK
		move.l	a4,a0
		add.l	patch_new1(a5),a0
		move	d0,(a0)
		move.l	a4,a0
		add.l	patch_new2(a5),a0
		move.b	d1,(a0)
		move.l	a4,a0
		add.l	patch_new3(a5),a0
		move	d2,(a0)
	* DESKICON
		move.l	a4,a0
		add.l	patch_desk1(a5),a0
		move.b	d1,(a0)
		move.l	a4,a0
		add.l	patch_desk2(a5),a0
		move.l	d2,(a0)

	* cre une BasePage pour l'os
		clr.l	-(sp)
		pea	string_null(pc)	;null
		pea	FastLoad+FastPrg+FastMem.w		
		move	#7,-(sp)		;cr une BasePage
		GEM	Pexec
		move.l	d0,a0		;pointeur sur la BasePage

	* pointeur sur l'os
		move.l	exec_os.w,8(a0)	;exec_os->ptr_text_segment

	* lancement de l'os
		clr.l	-(sp)
		move.l	a0,-(sp)		;adresse de la BasePage
		clr.l	-(sp)
		move	#6,-(sp)		;excute la "BasePage"
.pexec
		GEM	Pexec

	* systme fini... on reset la machine
	*   je pourrai mettre une zoli fin si je voulais
		jmp	rom_header+rom_jmp	;reset...
		
		*-------------*

*----------------------------------------------------------------------------*

		*-------------*
		cnop	0,16
INIT_GEMDOS
		movem.l	d1-7/a1-6,-(sp)
		move	sr,-(sp)
		move.l	sp,pile_return
	
	*--------------*
	* variables du TOS
		move.l	tos_vars_off(pc),a5

	*--------------*
	* init GEMDOS, VDI, ...
		jsr	([t_initgem,a5])

	* dclare Fast-Ram
		move.l	fast_bot(a6),a0
		move.l	fast_top(a6),d0
		beq.s	.no_fast

		sub.l	a0,d0
		beq.s	.no_fast
		
		move.l	d0,-(sp)
		pea	(a0)
		GEM	Maddalt
.no_fast
	*--------------*
	* Cre un process en chip-ram=>ccile...
		lea	string_null(pc),a0	;pointeur sur
					;chane nulle
		pea	(a0)
		pea	(a0)
		;clr.l	-(sp)
		pea	FastLoad+FastPrg+FastMem.w		
					;prgflags
		move	#7,-(sp)		;cre une basepage
		GEM	Pexec
		move.l	d0,a0		;adresse de la basepage
		move.l	a0,tos_basepage

	* il lance le premier excutable (qui peut se terminer)
		lea	.fast_process(pc),a1
		move.l	a1,8(a0)

		clr.l	-(sp)		;inutilis
		pea	(a0)
		clr.l	-(sp)		;inutilis
		move	#6,-(sp)		;lance la "BasePage"
		GEM	Pexec

		illegal			;on doit pas arriver l

	*--------------*
	* premier programme
.fast_process
	* change de pointeur de pile (user)
		move.l	4(sp),a5
		lea	$200(a5),sp	;nouveau pointeur de
					;pile
	* Libre le trop plein de RAM
		pea	$200.w
		pea	(a5)
		clr	-(sp)
		GEM	Mshrink

	* fixe la dta
		pea	dta(pc)
		GEM	Fsetdta

	* Passe en super, car aprs un Pexec, on se
	* retrouve en utilisateur
		clr.l	-(sp)
		GEM	Super
		move.l	pile_return(pc),sp
		move	(sp)+,sr
		
		*-------------*

		movem.l	(sp)+,d1-7/a1-6
		rts
		
		*-------------*

*-------------------------------------------------------------------------*
*		sous-programmes
*-------------------------------------------------------------------------*

		*-------------*

		include	TOS_SUB.S
		include	D:\DOLMEN\SOURCES\BORIS\CECILE.BRS\HAL\SC_RESET.S

		*-------------*

*-------------------------------------------------------------------------*
		DATA
*-------------------------------------------------------------------------*

		*-------------*

		include	TOS_DATA.S

		*-------------*

cci_name		dc.b	"CECILE.SYS",0
		even

		*-------------*

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*

		*-------------*
		* Basepage de Dolmen

tos_basepage	ds.l	1
dta		ds.b	44

		*-------------*
		* variables temporaires
		
pile_return	ds.l	1
		
		*-------------*

*-------------------------------------------------------------------------*
