*-------------------------------------------------------------------------*
*		SOUS-FONCTIONS
*-------------------------------------------------------------------------*

		*-------------*
		cnop	0,16

rte_adr		rte

		*------------*
		cnop	0,16

rts_adr		rts

		*------------*
		cnop	0,16
reset_hard
		move	#$2700,sr

	* fera que la RAM sera efface
		clr.l	memvalid.w
		clr.l	memval2.w
		clr.l	memval3.w
		clr.l	ramvalid.w

		bra	start_boot

		*------------*

*-------------------------------------------------------------------------*

		*------------*
		cnop	0,16
ErrorVec
		move	#$2700,sr		;pour tre peinard

		*------------*

		movem.l	d0-a7,$384.w	;proc_dregs.w
		move.l	2(sp),$3c4.w	;proc_enum.w (pc.24bits)

		move	6(sp),d7
		and	#$fff,d7
		lsr	#2,d7
		move.b	d7,$3c4.w		;(num vecteur
					;8bits poids fort)
		move.l	usp,a0
		move.l	a0,$3c8.w

		moveq	#16-1,d0
		lea	$3cc.w,a0       ;16 mots de la pile
		movea.l	sp,a1		;on se demande  quoi
					;a sert ?!
.copie_pile
		move	(a1)+,(a0)+
		dbra	d0,.copie_pile

		move.l	#$12345678,$380.w	;valide la
					;page de crash.
	* Texte en rouge sur fond noir
		tst.b	$ffff8260.w
		beq.s	.falc_pal
		
		* Palette ST 4 couleurs: je m'occupe pas de la ST-Basse
		move	$ffff8240.w,d5
		clr	$ffff8240.w		;noir
		move	$ffff8240+3*2.w,d6
		move	#$f00,$ffff8240+3*2.w	;rouge

		bra.s	.st_pal		
		* Palette Falcon: on gre le mono,16 et 256 couleurs
		* on fait rien en TC.
.falc_pal
		move	$ffff8266.w,d0
		btst	#10,d0
		beq.s	.pas_mono
		lea	$ffff9804.w,a5
		bra.s	.falc_pal2
.pas_mono
		btst	#8,d0
		bne.s	.st_pal		;pas en TC
		btst	#4,d0
		beq.s	.pas_256
		lea	$ffff9800+255*4.w,a5
		bra.s	.falc_pal2
.pas_256
		lea	$ffff9800+15*4.w,a5
.falc_pal2
		move.l	$ffff9800.w,d5
		clr.l	$ffff9800.w	;noir
		move.l	(a5),d6
		move.l	#$ff000000,(a5)	;rouge
.st_pal
	* message vers l'utilisateur
		lea	mess_err_val(pc),a0
		move	d7,d0
		moveq	#2-1,d1	;2 chiffres

		bsr	aff_nb_hex
		
		lea	fast_dol_start+dol_vars,a6

		lea	mess_err(pc),a0
		bsr	aff_txt

	ifne	vec_err
		cmp	#$2,d7
		blo.s	.bad
		cmp	#$18,d7
		bhi.s	.bad

		move.l	(table_cpu-2*4.w,pc,d7*4),a0
		bsr	aff_txt
.bad
	endc
		lea	mess_err_end(pc),a0
		bsr	aff_txt

	* attente pour qu'il est temps de lire le message

		lea	$fffffc00.w,a0
.wait_down
		move.b	(a0),d0
		btst	#7,d0	;int acia
		beq.s	.wait_down
		btst	#0,d0	;car reu?
		beq.s	.wait_down

		move.b	2(a0),d0	;on vide le buffer
		bmi.s	.wait_down	;touche qui remonte

		move.b	d0,d1
		
		cmp.b	#1,d0
		beq.s	.wait_up
		
		cmp.b	#$62,d0
		beq.s	.wait_up
		
		cmp.b	#$39,d0
		bne.s	.wait_down		;pas espace donc on
						;attends une autre
						;touche
		* on attends la remonte de la touche
.wait_up
		move.b	(a0),d0
		btst	#7,d0	;int acia
		beq.s	.wait_up
		btst	#0,d0	;car reu?
		beq.s	.wait_up

		move.b	2(a0),d0	;touche remonte
		bpl.s	.wait_up	;non!
		
		and.b	#$7f,d0
		cmp.b	d0,d1	;bonne touche remonte
		bne.s	.wait_down	;non
		
		cmp.b	#1,d0
		beq.s	.reset
		
		cmp.b	#$62,d0
		beq.s	.setup
		
		cmp.b	#$39,d0
		bne.s	.wait_down		;pas espace donc on
						;attends une autre
						;touche
	* On quitte le programme courant en restaurant les couleurs
		tst.b	$ffff8260.w
		beq.s	.falc_pal3
		
		* Palette ST 4 couleurs: je m'occupe pas de la ST-Basse
		move	d5,$ffff8240.w
		move	d6,$ffff8240+3*2.w

		bra.s	.st_pal2
		* Palette Falcon: on gre le mono,16 et 256 couleurs
		* on fait rien en TC.
.falc_pal3
		move.l	d5,$ffff9800.w
		move.l	d6,(a5)
.st_pal2
		* on quitte le programme en cours et
		* on rinitialise la zone de sauvegarde du bios
.fin
		tst.b	System_run(a6)
		beq.s	.reset
		
		move.l	#$93a,$4a2.w
		move	#-1,-(sp)		;erreur gnrale
		GEM	Pterm
	
		bra.s	.reset
.setup
		st	open_setup(a6)
.reset
		jmp	romtos_addr+rom_jmp

		*------------*

*-------------------------------------------------------------------------*

		*------------*
		cnop	0,16
Test_cartouche
		lea	$fa0000,a0
		cmp.l	#$ABCDEF42,(a0)+
		bne.s	.fin
.scan
		btst	d0,4(a0)
		beq.s	.next

		movem.l	d0-a6,-(sp)
		move.l	4(a0),d0
		and.l	#$ffffff,d0
		move.l	d0,a0
		jsr	(a0)
		movem.l	(sp)+,d0-a6
.next
		tst.l	(a0)
		move.l	(a0),a0
		bne.s	.scan
.fin
		rts     

		*------------*

*-------------------------------------------------------------------------*

		*------------*
		* On y vient si le lecteur est dclar.
		* excute le boot d'une disquette si on est devant le dur.
		cnop	0,16
BootFloppy
		movem.l	d1-d7/a1-a6,-(sp)
		
		*------------*

		btst	#0,flags_boot(a6)
		bne.s	.ok_floppy
	
	* recherche d'un boot	
		lea	floppy_clr(pc),a0
		bsr	aff_txt
		lea	floppy_txt(pc),a0
		bsr	aff_txt

		move.l	hdv_boot.w,a0	;hdv_boot (1seul fois)
		jsr	(a0)	;repre le(s) lecteur(s) de disquettes
				;d0=0: boot disquette charg et
				;excutable
				;d0=1: pas de disquette
				;d0=4: disquette mais pas bootable
		tst	d0
		bne.s	.no_boot

	* boot trouv et excutable
		lea	bootfloppy_txt(pc),a0
		bsr	aff_txt

		move.l	_dskbufp.w,a0       ;le boot a t charg l
		jsr	(a0)	;=>saute dans le boot de la disquette
.fin
		movem.l	(sp)+,d1-d7/a1-a6
		rts
	* pas boot trouv		
.no_boot
		cmp	#1,d0
		beq.s	.bad_floppy

	* mais le lecteur existe physiquement
		lea	noboot_txt(pc),a0
		bsr	aff_txt
.ok_floppy
		move	#1,_nflops.w
		moveq	#~%11,d0
		and	_drvbits+2.w,d0
		or	#%01,d0
		move	d0,_drvbits+2.w
		bra.s	.fin

	* le lecteur est absent
.bad_floppy
		clr	_nflops.w
		and	#~%01,_drvbits+2.w
		
		lea	nofloppy_txt(pc),a0
		bsr	aff_txt

		move	#con_dev,-(sp)
		BIOS	Bconin
		
		bset	#6,flags_boot(a6)	;=>dsactive le lecteur pour
					;les boot  chaud suivant	
		
		bra.s	.fin

		*------------*

*-------------------------------------------------------------------------*

		*------------*
		* Valide les variables du floppy
		cnop	0,16
ValidFloppy
		btst	#6,flags_boot(a6)
		bne.s	.bad_floppy

	* y a un lecteur
.ok_floppy
		move	#1,_nflops.w
		moveq	#~%11,d0
		and	_drvbits+2.w,d0
		or	#%01,d0
		move	d0,_drvbits+2.w
		bra.s	.fin

	* le lecteur est absent
.bad_floppy
		clr	_nflops.w
		and	#~%11,_drvbits+2.w
		
		*------------*
.fin
		rts
		
		*------------*

*-------------------------------------------------------------------------*

		*------------*
		cnop	0,16
BootHd
		movem.l	d1-d7/a1-a6,-(sp)
		
		*------------*
		
		btst	#7,flags_boot2(a6)
		beq	BootHd_TOS

	*--------------*
	* Boot utilisant directement Ccile
BootHd_CECILE
		move.l	([$4f2.w],$24.w),a0
		moveq	#%1000,d0
		and.b	(a0),d0
		beq.s	.no_alt
		
		movem.l	(sp)+,d1-d7/a1-a6
		moveq	#-1,d0
		rts
.no_alt
	*--------------*
	* prends toute la chip-ram
		clr	-(sp)
		pea	-1.w
		GEM	Mxalloc
		
		clr	-(sp)
		move.l	d0,-(sp)
		GEM	Mxalloc
		move.l	d0,a4	;pour ccile
		move.l	d0,a5
		
	* copie ccile en chip
		move.l	d0,a0
		move.l	cecile_ptr(a6),a1
		move.l	cecile_len(a6),d0
		lsr.l	#4,d0
.copie_cci
		rept	4
		move.l	(a1)+,(a0)+
		endr
		dbra	d0,.copie_cci
		
	*--------------*
	* mise  jour de ccile

	* ogem: folder,dat,fat
		move.l	a5,a0
		add	_sys_ogem(a5),a0
		
		move	cci_folder(a6),_sys_gfold(a0)
		move	cci_data(a6),_sys_gdat(a0)
		move	cci_fat(a6),_sys_gfat(a0)
		moveq	#0,d0
		move.b	boot_nvm(a6),d0
		move	d0,_sys_gstart(a0)
		
	
	* ormv: unites amovibles
		move.l	a5,a0
		add	_sys_ormv(a5),a0
		
		move.l	cci_rmunits(a6),(a0)+	;scsi0-3
		move.l	cci_rmunits+4(a6),(a0)+	;scsi4-7
		move	cci_rmunits2(a6),(a0)	;ide0-1

	* osleep: extinction par dfaut: plus de place dans la NVRAM
		move.l	a5,a0
		add	_sys_osleep(a5),a0
		
		moveq	#-1,d0
		moveq	#10-1,d1
.def_sleep
		move	d0,(a0)+
		dbra	d1,.def_sleep
		
	* oscan: ordre de scan
		move.l	a5,a0
		add	_sys_oscan(a5),a0
		
		lea	BootOrder(a6),a1
		
		moveq	#0,d0
.nxt_bootorder
		move.b	(a1)+,d0
		cmp.b	d1,d0
		beq.s	.end_bootorder
		tst.b	d0
		bmi.s	.nxt_bootorder
		move	d0,(a0)+
		bra	.nxt_bootorder
.end_bootorder
		move	#-1,(a0)
		
	* ospec: paramtre ide
		move.l	a4,a0
		add	_sys_ospec(a4),a0
		
			; CMMEDISS
		moveq	#%01100000,d0	;Master mode
		and.b	flags_boot2(a6),d0
		lsr	#5,d0
		move.b	d0,_ata_adr_mode(a0)
		
		moveq	#%00000011,d0	;Slave mode
		and.b	flags_boot2(a6),d0
		move.b	d0,_ata_adr_mode+1(a0)

	*--------------*
	* lance ccile.sys (a4 pointe sur le dbut du bloc mmoire)
		move.l	#"boot",d7
		jsr	(a5)
		
	*--------------*
	* recherche d'une partition bootable grce  pun_ptr
		move.l	pun_ptr.w,a3
		lea	2(a3),a3		;liste des partitions montes
		lea	16(a3),a4		;et du premier secteur
		moveq	#"P"-"A",d3	;nombre de partition maxi
		moveq	#0,d4
.nxt_pun
		move.b	(a3)+,d4
		bpl.s	.good_id
.dec_pun
		lea	4(a4),a4
		dbra	d3,.nxt_pun
.default
	* partition choisie par dfaut pour la recherche de Ccile.sys
		moveq	#0,d0
		move.b	boot_nvm(a6),d0

	* on valide la partition de boot par dfaut
		move.l	_drvbits.w,d2
		btst	d0,d2
		bne.s	.ok_part
		moveq	#0,d0
		btst	#2,d2	;=>A par dfaut
		beq.s	.ok_part
		moveq	#2,d0	;=>C par dfaut
.ok_part
		bra.s	.boot_found
	* id trouv
.good_id
	* lecture du boot de la partition monte
		move.l	(a4),-(sp)	;secteur de boot
		move	d4,d0
		addq	#2,d0
		move	d0,-(sp)	;id + 2
		move	#-1,-(sp)	;secteur long
		move	#1,-(sp)	;1 secteur
		move.l	_dskbufp.w,-(sp)    ;buffer
		move	#%1000,-(sp)	;en physique
		BIOS	LRwabs

		tst.l	d0
		bne.s	.dec_pun

	* calcul de la checksum du boot: doit tre gale  $1234
	* pour tre excutable
		move.l	_dskbufp.w,a0       ;_dskbufp
		move	#512/2-1,d0
		moveq	#0,d1
.checksum
		add	(a0)+,d1
		dbra	d0,.checksum

		cmp	#$1234,d1	;checksum
		bne	.dec_pun

		moveq	#"P"-"A",d0
		sub	d3,d0	;numro de partition

	* partition de boot trouve
.boot_found
		move	d0,_bootdev.w
		
		move	d0,-(sp)
		GEM	Dsetdrv
		
	* recherche d'un Ccile.sys
		clr	-(sp)
		pea	cci_name(pc)
		GEM	Fopen
		move	d0,d1
		bpl.s	.cecile_found
		
		pea	no_cecile(pc)	;pas de ccile.sys
		GEM	Cconws
		
		bra	.dfaut
.cecile_found
	* version compatible
		clr	-(sp)
		move	d1,-(sp)
		moveq	#_sys_ver,d2
		move.l	d2,-(sp)
		GEM	Fseek
		
		lea	-2(sp),sp		;pour lire le numro de
					;version
		pea	(sp)		;pointeur sur le buffer
		pea	2.w		;1 word  lire
		move	d1,-(sp)
		GEM	Fread
		move	(sp)+,d0		;version=>d0
		cmp	#ceci_valid,d0	;version minimum
		bhs.s	.ok_version
		
		pea	bad_version(pc)	;mauvaise version
		GEM	Cconws
		bra	.bad_version
.ok_version
		pea	good_version(pc)	;tout va bien
		GEM	Cconws

	* osleep
		clr	-(sp)
		move	d1,-(sp)
		moveq	#_sys_osleep,d2
					;pour pointer sur l'offset
					;et effacer le poids fort du
					;long
		move.l	d2,-(sp)
		GEM	Fseek
		
		lea	-2(sp),sp		;pour lire l'offset
					;d'osleep
		pea	(sp)		;pointeur sur le buffer
		pea	2.w		;1 word  lire
		move	d1,-(sp)
		GEM	Fread
		move	(sp)+,d2		;l'offset=>d2
		
		clr	-(sp)
		move	d1,-(sp)
		move.l	d2,-(sp)		;on y va
		GEM	Fseek

		move.l	a5,a0
		add	_sys_osleep(a5),a0
		pea	(a0)
		pea	10*2.w		;8 SCSI + 2 IDE
		move	d1,-(sp)
		GEM	Fread

	* ospec: protocole IDE
		clr	-(sp)
		move	d1,-(sp)
		moveq	#_sys_ospec,d2
					;pour pointer sur l'offset
					;et effacer le poids fort du
					;long
		move.l	d2,-(sp)
		GEM	Fseek
		
		lea	-2(sp),sp		;pour lire l'offset
					;d'ospec
		pea	(sp)		;pointeur sur le buffer
		pea	2.w		;1 word  lire
		move	d1,-(sp)
		GEM	Fread
		move	(sp)+,d2		;l'offset=>d2
		
		clr	-(sp)
		move	d1,-(sp)
		move.l	d2,-(sp)		;on y va
		GEM	Fseek

		move.l	a5,a0
		add	_sys_ospec(a5),a0
		pea	(a0)
		pea	_ata_length.w
		move	d1,-(sp)
		GEM	Fread

	* gstart		
		clr	-(sp)
		move	d1,-(sp)
		moveq	#_sys_ogem,d2
					;pour pointer sur l'offset
					;et effacer le poids fort du
					;long
		move.l	d2,-(sp)
		GEM	Fseek
		
		lea	-2(sp),sp		;pour lire l'offset
					;d'ogem
		pea	(sp)		;pointeur sur le buffer
		pea	2.w		;1 word  lire
		move	d1,-(sp)
		GEM	Fread
		move	(sp),d2		;l'offset=>d2
		add	#_sys_gstart,d2	;sur la valeur
		
		clr	-(sp)
		move	d1,-(sp)
		move.l	d2,-(sp)		;on y va
		GEM	Fseek

		pea	(sp)		;pointeur sur le buffer
		pea	2.w		;1 word  lire
		move	d1,-(sp)
		GEM	Fread
		move	(sp)+,_bootdev.w		;la partition de boot

	* ferme le fichier
.bad_version
		move	d1,-(sp)
		GEM	Fclose

	* affiche le boot trouv
.dfaut
		move	_bootdev.w,d0
		move.l	_drvbits.w,d2
		btst	d0,d2
		bne.s	.ok_part2
		moveq	#0,d0
		btst	#2,d2	;=>A par dfaut
		beq.s	.ok_part2
		moveq	#2,d0	;=>C par dfaut
.ok_part2
		move	d0,_bootdev.w
		
		moveq	#"A",d1
		add.b	d0,d1
		move.b	d1,boot_letter
		
		move	d0,-(sp)
		GEM	Dsetdrv
		
		pea	boot_done(pc)
		GEM	Cconws
		
		*------------*
		
		movem.l	(sp)+,d1-d7/a1-a6
		moveq	#0,d0
		rts

	*------------*
	* Boot mthode TOS (cad avec DMA read)
		cnop	0,16
BootHd_TOS
		lea	cherche_boot(pc),a0
		bsr	aff_txt

		lea	BootOrder(a6),a4
.check_id
		moveq	#1,d7	;retry

		clr	d4
		move.b	(a4)+,d4
		cmp.b	#-1,d4
		beq	.fin
		tst.b	d4
		bmi.s	.check_id

		move	d4,d0
		cmp	#$10,d0
		blo.s	.pas_ide
		add.b	#"0"-$10,d0
		move.b	d0,ide_id
		lea	ide_txt(pc),a0
		bra.s	.ide
.pas_ide
		add.b	#"0"-8,d0
		move.b	d0,scsi_id
		lea	scsi_txt(pc),a0
.ide
		bsr	aff_txt
		bra.s	.scan
.retry      
		lea	retry(pc),a0
		bsr	aff_txt
.scan
		moveq	#$7,d0
		and.b	arbid(a6),d0
		add.b	#8,d0
		cmp.b	d0,d4
		beq.s	.falcon
		
		move	d4,-(sp)	;id
		move.l	_dskbufp.w,-(sp)    ;buffer
		move	#1,-(sp)	;count
		clr.l	-(sp)	;sector
		jsr	([t_dmaread,a5])
		lea	12(sp),sp

		tst.l	d0
		beq.s	.id_ok

		addq.l	#1,d0
		dbeq	d7,.retry

		lea	not_connected(pc),a0
		bsr	aff_txt

		bra.s	.check_id
.falcon
		lea	falcon(pc),a0
		bsr	aff_txt
		
		bra	.check_id
.fin
		movem.l	(sp)+,d1-d7/a1-a6
		moveq	#-1,d0
		rts
.id_ok
	* calcul de la checksum du boot: doit tre gale  $1234
	* pour tre excutable
		move.l	$4C6.w,a0       ;_dskbufp
		move	#512/2-1,d0
		clr.l	d1
.checksum
		add	(a0)+,d1
		dbra	d0,.checksum

		cmp	#$1234,d1	;checksum
		beq.s	.ok_boot

		lea	no_boot(pc),a0
		bsr	aff_txt

		bra	.check_id

	* boot ok
	* on saute dans le boot avec:
	* A0: pointe sur le boot (inutilis)
	* D3="DMAr"
	* D4= id du boot
	* D5= type de boot de disque dur
	* D7= D4*32 (??)
		cnop	0,16
		debug	"ok_boot"
.ok_boot
		lea	ok_boot(pc),a0
		bsr	aff_txt

		move.l	$4c6.w,a0       ;_dskbufp
		move.l	#"DMAr",d3
		move	d4,d7
		asl	#5,d7
		move	$A80.w,d5		;type de boot

		move.l	a4,-(sp)
		move.l	a5,-(sp)	;pour le dmaread
		move.l	a6,-(sp)	;on le sauvegarde car a merde
				;aprs le passage dans scsitools
		move.l	$476,-(sp)      ;hdv_rw
		jsr	(a0)
		move.l	(sp)+,d0

		move.l	(sp)+,a6
		move.l	(sp)+,a5
		move.l	(sp)+,a4

		cmp.l	$476.w,d0       ;hdv_rw
		beq	.check_id

	* partition choisie
		move	_bootdev.w,d0	;des fois, il est crit en .b

		add.b	#"A",d0
		move.b	d0,boot_letter

		lea	boot_done(pc),a0
		bsr	aff_txt
.not_found
		movem.l	(sp)+,d1-d7/a1-a6
		moveq	#0,d0
		rts     

		*------------*

*-------------------------------------------------------------------------*

		*------------*
		*  Lance l'AUTO MANAGER
		cnop	0,16
AUTO_FOLDER
		movem.l	d1-7/a0-6,-(sp)

	*--------------*
	* valide le flag dans le cookie "_TSR"
		move.l	#"_TSR",d0
		move.l	_p_cookies.w,a0
.search
		tst.l	(a0)
		beq.s	.not_found
		cmp.l	(a0),d0
		beq.s	.found
		lea	8(a0),a0
		bra.s	.search
.found
		not.l	4(a0)
.not_found

	*--------------*
	* contrle du droulement
		moveq	#0,d7
		move	#-1,-(sp)
		BIOS	Kbshift
		btst	#2,d0	;control
		sne	d7

	*--------------*
	* prsentation
		pea	auto_txt(pc)
		GEM	Cconws

	*--------------*
	* Premier fichier *.PRG du dossier AUTO
		;move	#%111,-(sp)	;accs normal+protg en criture
					;+cach
		clr	-(sp)
		pea	TSR_PATH(pc)
		GEM	FsFirst
		tst	d0
		bmi	.error
.next
	* chemin+nom
		lea	TSR_PATH(pc),a0
		lea	TSR_MASK(pc),a2
		lea	TSR_FOUND(pc),a1
.copie_path
		move.b	(a0)+,(a1)+	;chemin
		cmp.l	a0,a2
		bne.s	.copie_path

		lea	dta+30(pc),a0	;nom en dta
.copie_name
		move.b	(a0)+,(a1)+	;nom
		bne.s	.copie_name

	*--------------*
	* contrleur
		tst	d7
		ble.s	.run
		
		lea	auto_name(pc),a0
		bsr	aff_txt
		
		lea	dta+30(pc),a0
		bsr	aff_txt
		
		lea	auto_cont(pc),a0
		bsr	aff_txt
.scan
		move	#con_dev,-(sp)
		BIOS	Bconin
		
		cmp	#" ",d0
		bne.s	.pas_space
		
		moveq	#-1,d7
		lea	auto_run_all(pc),a0
		bsr	aff_txt
		
		bra.s	.run
.pas_space
		cmp	#13,d0
		bne.s	.not_enter
		
		lea	auto_run(pc),a0
		bsr	aff_txt
		
		bra.s	.run
.not_enter
		cmp	#27,d0
		bne.s	.pas_esc
		
		lea	auto_quit(pc),a0
		bsr	aff_txt
		
		bra.s	.fin_auto
.pas_esc
		tst	d0
		bne.s	.scan
		swap	d0
		cmp.b	#$61,d0
		bne.s	.scan
		
		lea	auto_skip(pc),a0
		bsr	aff_txt
		
		bra.s	.skip

	*--------------*
	* lance le programme trouv
.run
		pea	auto_env(pc)
		pea	string_null(pc)
		pea	TSR_FOUND(pc)
		clr	-(sp)		;mode normal
		GEM	Pexec

	* programme suivant
.skip
		GEM	FsNext
		tst	d0
		beq	.next
	* fini
.fin_auto
		tst	d7
		beq.s	.quit
		
		pea	auto_fin(pc)
		GEM	Cconws
		
		move	#con_dev,-(sp)
		BIOS	Bconin
.quit
	*--------------*
	* on retourne au droulement du boot
		moveq	#0,d0
.fin
	*--------------*
	* dvalide le flag dans le cookie "_TSR"
		move.l	#"_TSR",d0
		move.l	_p_cookies.w,a0
.search2
		tst.l	(a0)
		beq.s	.not_found2
		cmp.l	(a0),d0
		beq.s	.found2
		lea	8(a0),a0
		bra.s	.search2
.found2
		not.l	4(a0)
.not_found2
		*------------*
		
		movem.l	(sp)+,d1-7/a0-6
		rts     			

		*------------*
.error
		pea	auto_error(pc)
		GEM	Cconws
		GEM	Crawcin
		
		bra	.fin
		
		*------------*

*-------------------------------------------------------------------------*

		*------------*
		cnop	0,16
test_ram
		movem.l	d0-a6,-(sp)
		
		*------------*
		* CHIP
		
		lea	Chip_txt(pc),a0
		bsr	aff_txt
		
		tst.b	ram_clr(a6)
		beq.s	.chip_clr
		
		lea	BusError.w,a5	;le dbut
		move.l	phystop.w,d5	;la fin
		move.l	#$aaaaaaaa,d6	;masque
		move.l	#$55555555,d2	;masque2
		moveq	#0,d4
		move.l	d4,d3
		
		bsr	.ram_test
.chip_clr		
		move.l	phystop.w,d0
		
		bsr	.ram_available

		*------------*
		* FAST
		
		lea	Fast_txt(pc),a0
		bsr	aff_txt

		tst.b	ram_clr(a6)
		beq.s	.fast_clr
		
		move.l	fast_bot(a6),a5	;le dbut
		move.l	ramtop.w,d5	;la fin
		cmp.l	a5,d5
		bhi.s	.ok_fast
		clr.l	d0
		bra.s	.no_fast
.ok_fast
		move.l	#$aaaaaaaa,d6	;masque
		move.l	#$55555555,d2	;masque2
		moveq	#0,d4
		move.l	#fast_dol_start,d3	;pour afficher la ram dispo
					;et non l'adresse

		bsr	.ram_test
.fast_clr
		move.l	ramtop.w,d0	;la fin
		sub.l	#fast_dol_start,d0
.no_fast
		bsr	.ram_available

		*------------*
		
		movem.l	(sp)+,d0-a6
		rts
	
		*------------*
		cnop	0,16
.ram_test
		move.l	a5,d0
		sub.l	d3,d0
		
		moveq	#8+6,d1
		lsr.l	d1,d0	;/16 Ko
		cmp.l	d0,d4
		beq.s	.pas_aff

	* affiche tout les Ko
		move.l	d0,d4
		lsl.l	#4,d0	;*16 = affichage en Ko
		moveq	#5-1,d1
		lea	addr_nb(pc),a0
		bsr	aff_nb_dec
		
		lea	addr_txt(pc),a0
		bsr	aff_txt
		
		move	#con_dev,-(sp)
		BIOS	Bconstat
		tst	d0
		bne.s	.fin
.pas_aff
		move.l	(a5),d7
		move.l	d6,(a5)
		cmp.l	(a5),d6
		bne.s	.error
		
		move.l	d2,(a5)
		cmp.l	(a5),d2
		beq.s	.ok
	
	* message d'erreur et on saute une ligne
.error
		move.l	a5,d0
		moveq	#8-1,d1
		lea	ram_adr(pc),a0
		bsr	aff_nb_hex
		
		lea	error_ram(pc),a0
		bsr	aff_txt
.ok
		move.l	d7,(a5)+
		cmp.l	a5,d5
		bne.s	.ram_test

		*------------*
.fin		
		rts
		
		*------------*

	* affiche la ram dispo
.ram_available
		moveq	#8+2,d1
		lsr.l	d1,d0	;/1Ko
		moveq	#5-1,d1
		lea	addr_nb(pc),a0
		bsr	aff_nb_dec
		
		lea	addr_txt(pc),a0
		bsr	aff_txt
		
		lea	ram_done(pc),a0
		bsr	aff_txt
		
		*------------*

		rts
				
		*------------*

*-------------------------------------------------------------------------*

		*------------*
		* pause au dmarrage de 0  80s
		cnop	0,16
wait
		movem.l	d0-a6,-(sp)
		
		*------------*
		
		lea	wait_txt(pc),a0
		bsr	aff_txt

		*------------*

		move.l	_hz_200.w,d7

		tst.b	ram_clr(a6)
		beq.s	.go
		
		moveq	#0,d6
		move.b	pause(a6),d6
		mulu	#200,d6
		
		add.l	d6,d7
.go
		add.l	#100,d7	;0.5s mini
.decompte
		move.l	_hz_200.w,d6

		cmp.l	d6,d7
		bls.s	.fin

		move.l	d7,d0
		sub.l	d6,d0
		divu.l	#200,d0
		moveq	#2-1,d1
		lea	time_nb(pc),a0
		bsr	aff_nb_dec

		lea	time(pc),a0
		bsr	aff_txt

		add.l	#200,d6	;prochaine seconde
.wait
		move	#con_dev,-(sp)
		BIOS	Bconstat
		tst	d0
		bne.s	.fin

		cmp.l	_hz_200.w,d6
		bhi.s	.wait

		bra	.decompte

		*------------*
.fin
		movem.l	(sp)+,d0-a6
		rts

		*------------*

*-------------------------------------------------------------------------*

		*-------------*
		* A0: pointe sur la chaine
		* routine d'affichage du text
		* d0 et a0 modifi (BIOS...)
		cnop	0,16
aff_txt
		movem.l	d1-2/a1-2/a6,-(sp)
		
		lea	fast_dol_start+dol_vars,a6
		tst.b	system_run(a6)
		bne.s	.bios
.no_bios
		jsr	([TextOut.w,a6])
		bra.s	.fin
.bios
		move.l	a0,a6
.aff
		moveq	#0,d0
		move.b	(a6)+,d0
		beq	.fin

		move	d0,-(sp)
		move	#2,-(sp)
		BIOS	Bconout

		bra	.aff
.fin
		movem.l	(sp)+,d1-2/a1-2/a6
		rts

		*-------------*

*-------------------------------------------------------------------------*

		*------------*
		* A0: pointe  la fin de la chane
		* D0.L: valeurs  convertir en hexa
		* D1.W: nombre de chiffres
		* D2.L: modifi
		* tout les registres entrant sont modifi
		cnop	0,16
aff_nb_hex
		move.l	d0,d2
.nxt_car
		move.l	d2,d0
		and	#$f,d0
		cmp.b	#$a,d0
		bhs.s	.hex
		add.b	#"0",d0
		bra.s	.wr
.hex
		add.b	#"A"-10,d0
.wr
		move.b	d0,-(a0)
		lsr.l	#4,d2
		dbra	d1,.nxt_car
.mess
		rts

		*------------*

*-------------------------------------------------------------------------*

		*------------*
		* A0: pointe  la fin de la chane
		* D0.L: valeurs  convertir en dec (MAX:65535*10)
		* D1.W: nombre de chiffres-1
		* D2.L: modifi
		* tout les registres entrant sont modifi
		cnop	0,16
aff_nb_dec
		moveq	#10,d2
.nxt
		divu	d2,d0
		swap	d0

		add.b	#"0",d0
		move.b	d0,-(a0)
		clr	d0
		swap	d0
		dbra	d1,.nxt

		rts

		*------------*

*-------------------------------------------------------------------------*

		*------------*
		* vrifie que la valeur magique est dans la nvm
		* dans la partie de Dolmen
		* ET que la nvram systme est correcte
		cnop	0,16
check_nvm
		movem.l	d0-3,-(sp)

		*------------*

		ldnvm	#nvm_notsum,d1
		not.b	d1
		ldnvm	#nvm_sum,d2
		cmp.b	d1,d2
		beq.s	.ok_1

		lea	nvram_buffer(a6),a0
		move	#nvm_notsum-nvm_vars,d0
		move	#nvm_vars,d1
		clr	d2
.copie_tos
		stnvm	(a0),d1
		add.b	(a0)+,d2
		addq	#1,d1
		dbra	d0,.copie_tos

		stnvm	d2,#nvm_sum
		not.b	d2
		stnvm	d2,#nvm_notsum
		bra.s	.ok_1b
.ok_1
		; vrifie que l'arbitration est bien mise

		move.b	arbid(a6),d0
		bmi.s	.ok_1b

		or.b	#$80,d0		;arbitration
		stnvm	d0,#nvm_arbid

		move	#nvm_notsum-nvm_vars,d0
		move	#nvm_vars,d1
		clr	d2
		clr	d3
.sum
		ldnvm	d1,d2
		add.b	d2,d3
		addq	#1,d1
		dbra	d0,.sum

		stnvm	d3,#nvm_sum
		not.b	d3
		stnvm	d3,#nvm_notsum
.ok_1b
		*------------*

		movem.l	(sp)+,d0-3
		rts

		*------------*

*-------------------------------------------------------------------------*

		*------------*
		* Lit la nvram et la reconfigure le cas chant
		* en cas de bug(s!)
		* lit les valeurs de la nvram dans les variables
		* si c'est OK
		cnop	0,16
read_nvm
		movem.l	d0-1/a0,-(sp)

		bsr	check_nvm

		* nvram systme

		lea	nvram_buffer(a6),a0

		move	#nvm_notsum-nvm_vars,d0
		move	#nvm_vars,d1
.copie_tos
		ldnvm	d1,(a0)+
		addq	#1,d1
		dbra	d0,.copie_tos

		*------------*

		movem.l	(sp)+,d0-1/a0
		rts
	
		*------------*

*-------------------------------------------------------------------------*

		*--------------*
		* Veut-on rentrer dans le setup
		* recherche pendant 0.5s
		cnop	0,16
Go_setup
		moveq	#100,d7
		add.l	_hz_200.w,d7
.encore
		move	#con_dev,-(sp)
		BIOS	Bconstat
		tst	d0
		bne.s	.oui
		cmp.l	_hz_200.w,d7
		bhi	.encore
		bra.s	.non
.oui
		move	#con_dev,-(sp)
		BIOS	Bconin
		swap	d0
		cmp.b	#$62,d0
		bne.s	.non

		st	open_setup(a6)
		jmp	romtos_addr+rom_jmp
.non
		*--------------*

		rts

		*--------------*

*-------------------------------------------------------------------------*
		BSS
*-------------------------------------------------------------------------*

		*--------------*

auto_env		ds.b	64	;chane d'environement
				;pour le dossier AUTO
tsr_found		ds.b	64

		*--------------*

*-------------------------------------------------------------------------*
