;----------------------------------------------------------------------------
;File name:	CHMELEON.S			Revision date:	1996.02.14
;Revised by:	Ulf Ronald Andersson		Revision start:	1996.02.14
;Created by:	Karsten Isakovic
;----------------------------------------------------------------------------
; QED-ASMPAR 4 0006  $DSDR:Z:1390,M:4
;Desert	Drain V1.52   680x0er Disassembler  14.02.1996 05:11:32
;DATEI:	CHMELEON.ACC   5369 Bytes
;TEXT:	 5166	$0142E
;BSS:	  256  $000100
;----------------------------------------------------------------------------
;
	include	URAn_GEM.S
	include	URAn_DOS.S
	include URAn_LA.S
	include	URAn_XB.S
;
;----------------------------------------------------------------------------
;
	SECTION	TEXT
;
;----------------------------------------------------------------------------
;
bp		= *-$100
ACC_fname_s	= bp+$080
ACC_path_s	= bp+$08E
ACC_pname_s	= bp+$0C0
mesag_buf	= bp+$0FC
global		= bp+$10C
kbdvbase_p	= bp+$12E
loc_la_func_p	= bp+$132
la_user_tim_p	= bp+$136
kbshift_p	= bp+$13A
Main_ACC_id	= bp+$13E
start:
	bra.s	start_1
;
;----------------------------------------------------------------------------
;
	dc.l	'Cham'
;
;----------------------------------------------------------------------------
;
start_1:
	lea	bp(PC),A5		;a5 -> basepage
	move.l	A5,basepage_p
	movea.l	bp_textlen(A5),A0
	adda.l	bp_datalen(A5),A0
	adda.l	bp_bss_len(A5),A0
	adda	#$100,A0
	move.l	A5,D0
	add.l	A0,D0			;d0 -> basepage + program_size
	and.b	#-4,D0			;d0 = rounded down to long
	subq.l	#8,D0			;d0 -= 8
	movea.l	D0,sp			;new USP = d0
	gemdos	Mshrink|_ind,!,a5,a0	;return unneeded RAM to system
	bra	start_2			;goto start_2
;
;----------------------------------------------------------------------------
;
vector_mask	= bp+$140
frame_size	= bp+$144
sys_base_p	= bp+$146
sys_end_p	= bp+$150
appl_id	= bp+$154
T_56	= bp+$156
T_58	= bp+$158
ACC_active_f	= bp+$15C
T_5D	= bp+$15D
T_5E	= bp+$15E
T_5F	= bp+$15F
intin	= bp+$160
intout	= bp+$164
T_6A	= bp+$16A
T_6B	= bp+$16B
addrin_ptsin	= bp+$16E	;2 L
addrout_ptsout	= bp+$176
T_7C	= bp+$17C
T_80	= bp+$180
clrblk_1_beg	= T_80
ACC_RAM_base_t	= bp+$184
T_E8	= bp+$1E8
ACC_RAM_size_t	= bp+$1F0
;
init_sysdata_supx:
;
	move	sr,D2			;d2 = entry SR
	movea.l	sp,A2			;a2 = entry SSP
;
	moveq	#6,D0			;d0 = framesize for 68000
	move.l	#$FFFFFF,vector_mask
	movea.l	(ev_buserr).w,a0	;a0 -> entry ev_buserr routine
	move.l	(ev_illegal).w,a1	;a1 -> entry ev_illegal routine
;
	lea	.test_illegal(PC),A3
	move.l	a3,(ev_illegal).w	;patch ev_illegal vector for test
	dc.w	$42C0			;68020+ 'move CCR,d0' => illegal on 68000
	moveq	#8,D0			;d0 = framesize for 68020+
	st	new_cpu_f		;set flag new_cpu_f
.test_illegal:
;
	lea	.test_buserr(PC),A3
	move.l	A3,(ev_buserr).w	;patch ev_buserr vector for test
	move	$FFFF8400.w,D1		;TT palette access
	st	vector_mask		;set top byte of vector_mask
.test_buserr:
;
	move.l	A0,(ev_buserr).w
	move.l	A1,(ev_illegal).w
	move	D0,frame_size			;store tested framesize
;
	movea.l	A2,sp			;restore entry SSP
	move	D2,sr			;restore entry SR
;
	movea.l	basepage_p(PC),A5
	move.l	#$602C,loc_currbp_p_p
	move.l	#$E1B,kbshift_p-bp(A5)
	movea.l	(_sysbase).w,A0		 ;_sysbase
	movea.l	os_selfbeg_p(A0),A0
	move.l	A0,D0
	move.l	D0,sys_base_p
	add.l	#$2F000,D0
	move.l	D0,sys_end_p
	cmpi	#$102,os_version(A0)
	blt.s	.got_TOS
	move.l	os_kbshift_p(A0),kbshift_p-bp(A5)
	movea.l	os_currbp_p_p(A0),A1
	move.l	A1,loc_currbp_p_p
	cmpi	#$104,os_version(A0)
	blt.s	.got_TOS
	move.b	#fsel_exinput&$FF,fsel_func_byte
	move.b	#3,fsel_contrl_byte
.got_TOS:
;
	clr.l	ACC_active_f
	lea	nu_xgemdos+xb_next(PC),A0
	move.l	(ev_xgemdos).w,(A0)+		 ;trp2vec
	move.l	A0,(ev_xgemdos).w		 ;trp2vec
	lea	nu_gemdos+xb_next(PC),A0
	move.l	(ev_gemdos).w,(A0)+		 ;trp1vec
	move.l	A0,(ev_gemdos).w		 ;trp1vec
	lea	nu_bios+xb_next(PC),A0
	move.l	(ev_bios).w,(A0)+		 ;trp13vec
	move.l	A0,(ev_bios).w			 ;trp13vec
	rts
;
;----------------------------------------------------------------------------
;
fix_path_drive:
	cmpi.b	#'A',(A1)
	bne.s	T_12C
	cmpi.b	#':',1(A1)
	bne.s	T_12C
	add.b	D0,(A1)
T_12C:
	rts
;
;----------------------------------------------------------------------------
T_152	= bp+$252
T_164	= bp+$264
T_172	= bp+$272
T_184	= bp+$284
T_186	= bp+$286
T_190	= bp+$290
T_191	= bp+$291
T_194	= bp+$294
T_198	= bp+$298
clrblk_1_end	= T_198
T_19C	= bp+$29C
T_1A2	= bp+$2A2
T_1BA	= bp+$2BA
T_1C0	= bp+$2C0
T_1C4	= bp+$2C4
T_1CC	= bp+$2CC
T_1D4	= bp+$2D4
T_1D6	= bp+$2D6
T_1DC	= bp+$2DC
T_1E0	= bp+$2E0
T_1F2	= bp+$2F2
T_1F8	= bp+$2F8
T_1FE	= bp+$2FE
T_1FF	= bp+$2FF
T_204:	= bp+$304
;
start_2:
	lea	global-bp(A5),A0
	move.l	A0,aespb+4
	lea	init_sysdata_supx(PC),A0
	bsr	supexec_ia0
	xbios	Kbdvbase
	move.l	D0,kbdvbase_p-bp(a5)
;
	_a_init
;
	move.l	A2,loc_la_func_p-bp(a5)
	sub.l	#$42,D0
	move.l	D0,la_user_tim_p-bp(a5)
;
	lea	ACC_path_s-bp(a5),A0
	lea	iz_ACC_path_s(PC),A1
	bsr	strcpy_ia0p_ia1p
;
	xbios	Iorec,!
	move.l	D0,T_58
;
	gemdos	Dgetdrv
	lea	ACC_path_s-bp(a5),A1
	bsr.s	fix_path_drive
;
	lea	iz_ACC_pname_s(PC),A1
	bsr.s	fix_path_drive
	clr.b	ACC_fname_s-bp(a5)
	lea	ACC_pname_s-bp(a5),A0
	bsr	strcpy_ia0p_ia1p
;
	bsr	test_loadable
	bne.s	T_1B4
Next_ACC_id:
	bsr	erase_ACC_info
	bsr	load_ACC_sub
	move.l	a4,D0			;ACC loaded ?
	beq.s	T_1B4
	bsr.s	T_1B8
	bsr	T_5D2
	bra	start_4
;
T_1B4:
	bsr.s	T_1B8
	bra.s	start_3
;
T_1B8:
	moveq	#10,D0		;appl_init
	move.l	#$10000,D1
	bsr	aes_sub
	move	intout(PC),intin
	move	intout(PC),appl_id
;
	moveq	#$23,D0		;menu_register
	move.l	#$1010100,D1
	lea	ACC_title_s(PC),A0
	bsr	aes_sub
	move	intout(PC),D0
	move	D0,Main_ACC_id-bp(a5)
	move	D0,Next_ACC_id
;
	clr	T_19C
	clr	T_1C0
	clr	T_56
	clr.b	iz_ACC_pname_s
	rts
;
;----------------------------------------------------------------------------
;
start_3:
	bsr	erase_ACC_info
	tst	T_1C0
	bne.s	T_266
	lea	mesag_buf-bp(A5),A0
;
	moveq	#$17,D0		;evnt_mesag
	move.l	#$10100,D1
	bsr.s	aes_sub
	move	mesag_buf-bp(A5),D0
;
	cmpi	#AC_OPEN,d0	;AC_OPEN ?
	bne.s	T_23E
	tst	T_56
	beq.s	T_266
	clr	T_56
T_23E:
	cmpi	#$4711,D0
	bne.s	start_3
	move	#1,T_1C0
	bsr	T_31E
	tst.b	ACC_pname_s-bp(a5)
	beq.s	T_266
	bsr	test_loadable
	beq.s	T_266
	bgt.s	start_3
	bsr.s	ACC_not_loaded_al_sub
	clr	T_1C0
T_266:
	bsr	T_39A
	beq.s	start_3
start_4:
	bsr	enter_ACC_sub
	bsr	post_ACC_sub
	bra.s	start_3
;
;----------------------------------------------------------------------------
;
vdi_sub:
	lea	contrl(PC),A0
	move	D1,(A0)
	movep.l	D0,3(A0)
	move	D6,12(A0)
	move.l	#vdipb,D1
	moveq	#$73,D0
	trap	#2			 ;vdi
	rts
;
;----------------------------------------------------------------------------
;
aes_sub:
	move.l	A0,addrin_ptsin
	lea	contrl(PC),A0
	move	D0,(A0)
	movep.l	D1,3(A0)
	move.l	#aespb,D1
	move	#$C8,D0
	trap	#2			 ;aes
	rts
;
;----------------------------------------------------------------------------
;
ACC_not_loaded_al_sub:
	lea	ACC_not_loaded_al_s(PC),A0
form_alert_sub:
	move	#1,intin
	moveq	#$34,D0		;form_alert
	move.l	#$1010100,D1
	bra.s	aes_sub
;
;----------------------------------------------------------------------------
;
wind_update_0_sub:
	clr	D0
wind_update_sub:
	move	D0,intin
	moveq	#$6B,D0		;wind_update
	move.l	#$1010000,D1
	bra.s	aes_sub
;
;----------------------------------------------------------------------------
;
graf_mouse_sub:
	move	D0,intin
	moveq	#$4E,D0		;graf_mouse
	move.l	#$1010100,D1
	bra.s	aes_sub
;
;----------------------------------------------------------------------------
;
erase_ACC_info:
	clr.l	ACC_active_f
	clr.l	app_name_s
	move	Main_ACC_id-bp(a5),Next_ACC_id
	clr.b	$140(A5)
	lea	clrblk_1_beg(pc),a0
	moveq	#((clrblk_1_end-clrblk_1_beg)/4)-1,d0
T_304:
	clr.l	(A0)+
	dbra	D0,T_304
	st	T_198
	lea	iz_ACC_title_s(PC),A1
T_314:
	lea	ACC_title_s(PC),A0
strcpy_ia0p_ia1p:
	move.b	(A1)+,(A0)+
	bne.s	strcpy_ia0p_ia1p
T_31C:	rts
;
;----------------------------------------------------------------------------
;
T_31E:	lea	ACC_pname_s-bp(a5),A0
	clr.l	(A0)
	move.l	$102(A5),D0
	beq.s	T_31C
	movea.l	D0,A1
T_32C:	move.b	(A1)+,D1
	beq.s	T_33A
	cmpi.b	#$20,D1
	bne.s	T_32C
	tst.b	(A1)
	bne.s	T_31C
T_33A:	movea.l	D0,A1
	bra.s	strcpy_ia0p_ia1p
;
;----------------------------------------------------------------------------
;
appl_write_sub:
	move	Main_ACC_id-bp(a5),D1
	swap	D1
	move	Main_ACC_id-bp(a5),D1
	lea	intin(PC),A0
	move	$110(A5),(A0)
	move	#16,2(A0)
	lea	mesag_buf-bp(A5),A0
	move	D0,(A0)
	move.l	D1,6(A0)
	moveq	#appl_write&$FF,D0
	move.l	#$2010100,D1
	bra	aes_sub
;
;----------------------------------------------------------------------------
;
T_36C:	movea.l	kbshift_p-bp(A5),A0
	move.b	(A0),D2
	cmp.b	T_12F9(PC),D2
	beq.s	T_386
	move	#AC_OPEN,D0
	bsr.s	appl_write_sub
	move	#1,T_56
T_386:	rts
;
;----------------------------------------------------------------------------
;
kick_wind_8:
	moveq	#7,D4
.T_38A:
	moveq	#1,D0
	bsr	wind_update_sub
	bsr	wind_update_0_sub
	dbra	D4,.T_38A
	rts
;
;----------------------------------------------------------------------------
;
T_39A:
	suba.l	A4,A4
	moveq	#1,D0
	bsr	wind_update_sub
	move	#AC_CLOSE,D0
	bsr.s	appl_write_sub
	dc.w	$13FC			 ; 
	dc.w	$FFFF			 ;
	dc.l	T_1C4
	tst	T_1C0
	beq.s	T_3C8
	bsr.s	T_36C
	clr	T_1C0
	tst.b	ACC_pname_s-bp(a5)
	beq.s	T_43E
	bra.s	T_426
;
T_3C8:
	lea	ACC_path_s-bp(a5),A0
	lea	ACC_fname_s-bp(a5),A1
	move.l	A1,addrin_ptsin+4
	lea	T_13BC(PC),A1
	move.l	A1,addrout_ptsout
	moveq	#$5A,D0			;fsel_input, patched fsel_exinput for TOS > 1.04
fsel_func_byte	= *-1
	move.l	#$00020200,D1		;contrl values, patched 00020300 for TOS > 1.04
fsel_contrl_byte= *-2
	bsr	aes_sub
	move	intout+2(PC),D0
	beq.s	T_43E
	lea	ACC_fname_s-bp(a5),A1
	tst.b	(A1)
	beq.s	T_43E
	bsr	T_36C
	lea	ACC_path_s-bp(a5),A0
	lea	ACC_fname_s-bp(a5),A1
	lea	ACC_pname_s-bp(a5),A2
	movea.l	A2,A3
T_40C:
	move.b	(A0)+,(A2)+
	bne.s	T_40C
T_410:
	cmpa.l	A3,A2
	bcs.s	T_43A
	cmpi.b	#$5C,-(A2)
	bne.s	T_410
	addq.l	#1,A2
T_41C:
	move.b	(A1)+,(A2)+
	bne.s	T_41C
	bsr.s	test_loadable
	bgt.s	T_43E
	blt.s	T_43A
T_426:
	moveq	#2,D0
	bsr	graf_mouse_sub
	bsr	load_ACC_sub
	clr	D0
	bsr	graf_mouse_sub
	move.l	A4,D0
	bne.s	T_43E
T_43A:
	bsr	ACC_not_loaded_al_sub
T_43E:
	bsr	wind_update_0_sub
	move.l	A4,D0
	beq.s	T_44E
	bsr	kick_wind_8
	bsr	T_5D2
T_44E:
	move.l	A4,D0
	rts
;
;----------------------------------------------------------------------------
;
test_loadable:
	tst.b	ACC_pname_s-bp(a5)
	beq	.T_4E8
	lea	ACC_pname_s-bp(a5),A0
	move.b	(A0)+,D0
	cmpi.b	#'$',D0
	bne.s	.T_482
	moveq	#3,D1
.T_468:
	asl.l	#8,D0
	move.b	(A0)+,D0
	dbra	D1,.T_468
	cmpi.l	#'KILL',D0
	bne.s	.T_482
	clr	T_1C0
	moveq	#1,D0
	rts
;
;------------------------------------
;
.T_482:
	gemdos	Fopen,ACC_pname_s-bp(a5),!
	tst.l	D0
	bmi.s	.T_4E8
	move	D0,D4
	gemdos	Fread,d4,#14,intin(pc)
	gemdos	Fclose,d4
	lea	intin(PC),A0
	cmpi	#$601A,(A0)
	bne.s	.T_4E8
	move.l	2(A0),D4
	add.l	6(A0),D4
	add.l	10(A0),D4
	add.l	#$7530,D4
	gemdos	Malloc,#-1
	cmp.l	D4,D0
	ble.s	.T_4E8
	clr.l	D0
	rts
;
;------------------------------------
;
.T_4E8:	moveq	#-1,D0
	rts
;
;----------------------------------------------------------------------------
;
load_ACC_sub:
	suba.l	A4,A4
	move.l	basepage_p(PC),new_currbp_p
	bsr	patch_system			;enter_system
	gemdos	Pexec|_ind,#3,ACC_pname_s-bp(a5),T_186(pc),!
	tst.l	D0
	bmi	.T_5C6
	movea.l	D0,A4
	movea.l	12(A4),A0
	adda.l	$14(A4),A0
	adda.l	$1C(A4),A0
	adda	#$100,A0
	move.l	A4,ACC_RAM_base_t
	move.l	A0,ACC_RAM_size_t
	gemdos	Mfree|_ind,bp_environ_p(a4)
	cmpi	#$6004,$100(A4)
	bne.s	.T_562
	cmpi.l	#'Cham',$102(A4)	;is the ACC another chameleon ?
	bne.s	.T_562			;if not, go keep it
	gemdos	Mfree|_ind,a4
	suba.l	A4,A4
	bra.s	.T_5C6
;
.T_562:
	gemdos	Mshrink|_ind,#0,a4,ACC_RAM_size_t(pc)
	move.l	bp_environ_p(A5),bp_environ_p(A4)
	clr.l	bp_parent_p(A4)
	movea.l	T_58(PC),A0
	lea	T_164(PC),A1
	bsr	move_14_ia0p_to_ia1p
	tst.b	iz_ACC_pname_s
	bne.s	.T_5C0
	tst.b	T_12BF
	beq.s	.T_5C0
	clr	D0
	move.b	T_12BF(PC),D0
	gemdos	Fseek,!,d0,#1
	tst	D0
	bge.s	.T_5C0
	move.b	T_12BF(PC),$31(A5)
	bra.s	.T_5C6
;
.T_5C0:	move.b	#-1,$31(A5)
.T_5C6:	move.l	old_currbp_p(PC),new_currbp_p
	bra	patch_system			;exit_system
;
;----------------------------------------------------------------------------
;
T_5D2:	lea	ACC_pname_s-bp(a5),A0
	movea.l	A0,A1
T_5D8:	tst.b	(A1)+
	bne.s	T_5D8
T_5DC:	cmpi.b	#'\',-(A1)
	beq.s	T_5E6
	cmpa.l	A0,A1
	bge.s	T_5DC
T_5E6:	addq.l	#1,A1
	moveq	#7,D0
	lea	app_name_s(PC),A2
T_5EE:	move.b	(A1)+,(A2)+
	beq.s	T_5FE
	cmpi.b	#'.',(A1)
	beq.s	T_5FE
	dbra	D0,T_5EE
	bra.s	T_606
;
T_5FE:	move.b	#$20,(A2)+
	dbra	D0,T_5FE
T_606:	clr.b	-(A2)
	lea	T_13D8(PC),A1
	bsr	T_314
	lea	ACC_path_s-bp(a5),A1
	lea	mesag_buf-bp(A5),A0
T_618:	cmpi.b	#'\',-(A0)
	beq.s	T_622
	cmpa.l	A1,A0
	bgt.s	T_618
T_622:	clr.b	(A0)
	move.l	A0,$12A(A5)
	rts
;
;----------------------------------------------------------------------------
;
enter_ACC_sub:
	movem.l	D0-D7/A0-A6,-(sp)
	move.l	sp,T_1DC
	move.b	#1,ACC_active_f
	clr	T_56
	movea.l	A4,A0
	adda	#$100,A4
	jmp	(A4)
;
;----------------------------------------------------------------------------
;
exit_ACC_rout:
	movea.l	T_1DC(PC),sp
	movem.l	(sp)+,D0-D7/A0-A6
	rts
;
;----------------------------------------------------------------------------
;
post_ACC_sub:
	clr.b	ACC_active_f
	moveq	#1,D0
	bsr	wind_update_sub
	clr.l	D6
	moveq	#7,D7
	lea	T_152(PC),A3
T_668:
	move	(A3)+,D0
	beq.s	T_694
	move	D6,intin
	move	#$66,D0		;wind_close
	move.l	#$1010000,D1
	bsr	aes_sub
	move	D6,intin
	move	#$67,D0		;wind_delete
	move.l	#$1010000,D1
	bsr	aes_sub
T_694:
	addq.l	#1,D6
	dbra	D7,T_668
T_69A:
	tst	T_184
	ble.s	T_6AE
	bsr	wind_update_0_sub
	subq.w	#1,T_184
	bra.s	T_69A
;
T_6AE:
	tst.b	T_190
	ble.s	T_6C6
	move	#$101,D0
	bsr	graf_mouse_sub
	subq.b	#1,T_190
	bra.s	T_6AE
;
T_6C6:
	tst.b	T_191
	ble.s	T_6E6
	move	#$7A,D1		;v_show_c
	move.l	#$100,D0
	moveq	#1,D6
	bsr	vdi_sub
	subq.b	#1,T_191
	bra.s	T_6C6
;
T_6E6:	moveq	#7,D7
	lea	T_186(PC),A3
	clr	D6
T_6EE:	move.b	(A3)+,D6
	beq.s	T_706
	clr	intin
	move	#$78,D1		;vst_unload_fonts
	move.l	#$100,D0
	bsr	vdi_sub
T_706:	dbra	D7,T_6EE
	moveq	#7,D7
	lea	T_172(PC),A3
T_710:	moveq	#$65,D1		;v_clsvwk
	lea	contrl(PC),A0
	move	(A3)+,D6
	beq.s	T_726
	bpl.s	T_720
	moveq	#2,D1		;v_clswk
	neg	D6
T_720:	clr.l	D0
	bsr	vdi_sub
T_726:	dbra	D7,T_710
	bsr.s	T_734
	bsr	wind_update_0_sub
	clr	D0
	rts
;
;----------------------------------------------------------------------------
;
T_734:
	moveq	#25-1,D7
	lea	ACC_RAM_base_t(PC),A3
T_73A:
	move.l	(A3)+,D0
	beq.s	T_748
	gemdos	Mfree|_ind,d0
T_748:
	dbra	D7,T_73A
	rts
;
;----------------------------------------------------------------------------
;
T_74E:
	move.b	#1,ACC_active_f
	movea.l	basepage_p(PC),A5
	clr	T_194
	bsr.s	T_7A0
	move.b	ACC_active_f,D0
	cmpi.b	#1,D0
	blt.s	T_79E
	move	#1,T_194
	bsr.s	T_7A0
	movea.l	T_58(PC),A2
	clr.l	D2
	bsr	T_822
	tst	ACC_active_f
	bne.s	T_79E
	lea	T_164(PC),A0
	movea.l	T_58(PC),A1
	bsr	move_14_ia0p_to_ia1p
	move.b	#1,ACC_active_f
T_79E:
	rts
;
;----------------------------------------------------------------------------
;
T_7A0:	movea.w	#8,A2
	moveq	#$3D,D2
	bsr.s	T_822
	st	T_1F2
	movea.w	#$100,A2
	moveq	#7,D2
	move.b	$FFFFFA09.w,D7		 ;ierb
	bsr.s	T_822
	movea.w	#$120,A2
	moveq	#7,D2
	move.b	$FFFFFA07.w,D7		 ;iera
	bsr.s	T_822
	clr.b	T_1F2
	movea.w	#$400,A2
	moveq	#7,D2
	bsr.s	T_822
	movea.w	#$42A,A2
	moveq	#1,D2
	bsr.s	T_822
	movea.w	#$46E,A2
	moveq	#4,D2
	bsr.s	T_822
	movea.w	#$502,A2
	moveq	#4,D2
	bsr.s	T_822
	movea.w	#$51E,A2
	moveq	#$1F,D2
	bsr.s	T_822
	movea.l	kbdvbase_p-bp(a5),A2
	moveq	#8,D2
	bsr.s	T_822
	movea.l	loc_la_func_p-bp(a5),A2
	moveq	#15,D2
	bsr.s	T_822
	movea.l	la_user_tim_p-bp(a5),A2
	moveq	#4,D2
	bsr.s	T_822
	tst	T_194
	beq.s	T_820
	movea.l	$456.w,A2		 ;_vblqueue
	move	$454.w,D2		 ;nvbls
	subq.w	#1,D2
	bsr.s	T_822
T_820:	rts
;
;----------------------------------------------------------------------------
;
T_822:	tst.b	ACC_active_f
	beq	T_8C2
	bsr	T_11B2
	movea.l	A2,A4
	addq.l	#4,A4
	move.l	(A2)+,D0
	tst.b	T_1F2
	beq.s	T_842
	asr.w	#1,D7
	bcc.s	T_8BE
T_842:	bsr	T_8D4
	beq.s	T_8BE
T_848:	move.l	0(A0,D1.w),D3
	beq.s	T_89C
	cmp.l	D3,D0
	blt.s	T_89C
	add.l	0(A1,D1.w),D3
	subq.l	#1,D3
	cmp.l	D3,D0
	bgt.s	T_89C
	movea.l	D0,A3
	subi.l	#12,D0
	bsr.s	T_8D4
	beq.s	T_886
	cmpi.l	#'XBRA',-$C(A3)
	bne.s	T_886
	addq.b	#1,ACC_active_f
	move	T_194(PC),D1
	beq.s	T_8A4
	move.l	-$4(A3),-$4(A4)
	bra.s	T_8A4
;
T_886:	tst	T_194
	bne.s	T_896
	clr.b	ACC_active_f
	rts
;
;----------------------------------------------------------------------------
;
T_896:	clr.l	-$4(A4)
	rts
;
;----------------------------------------------------------------------------
;
T_89C:	addq	#4,D1
	cmpi	#$64,D1
	blt.s	T_848
T_8A4:	movea.l	D0,A4
	cmpi.l	#$58425241,-$C(A4)
	bne.s	T_8BE
	cmp.l	-$4(A4),D0
	beq.s	T_8BE
	move.l	-$4(A4),D0
	clr.l	D1
	bra.s	T_842
;
T_8BE:	dbra	D2,T_822
T_8C2:	rts
;
;----------------------------------------------------------------------------
;
T_8C4:	bsr	T_988
	bne	T_74E
	lea	T_74E(PC),A0
	bra	supexec_ia0
;
T_8D4:	clr.l	D3
	btst	#0,D0
	bne.s	T_92E
	and.l	vector_mask,D0
	beq.s	T_92E
	cmpi.l	#$FF8000,D0
	blt.s	T_904
	cmpi.l	#$FFFFFF,D0
	blt.s	T_8BE
	cmpi.l	#-$8000,D0
	blt.s	T_904
	cmpi.l	#-1,D0
	blt.s	T_92E
T_904:	movem.l	D0-D2/A0/A1,-(sp)
	move.l	(ev_buserr).w,-(sp)
	move	sr,D1
	ori	#$700,sr
	move.l	sp,D2
	lea	T_922(PC),A1
	move.l	A1,(ev_buserr).w
	movea.l	D0,A0
	move.l	(A0),D3
	moveq	#1,D3
T_922:	move	D1,sr
	movea.l	D2,sp
	move.l	(sp)+,(ev_buserr).w
	movem.l	(sp)+,D0-D2/A0/A1
T_92E:	tst.l	D3
	rts
;
;----------------------------------------------------------------------------
;
T_932:
	movea.l	loc_currbp_p_p(PC),A0	;a0 -> system currbp_p -> current basepage
	movea.l	new_currbp_p(PC),A1
	movea.l	(A0),A2			;a2 -> current basepage
	move.l	A2,old_currbp_p
	move.l	bp_dta_p(A2),bp_dta_p(A1)
	move.l	$40(A2),$40(A1)
	move.l	$44(A2),$44(A1)
	move.l	$48(A2),$48(A1)
	move.l	$4C(A2),$4C(A1)
	move.l	A1,(A0)			;force system currbp_p = new_currbp_p
	rts
;
;----------------------------------------------------------------------------
;
patch_system:
	movem.l	D0-D3/A0-A2,-(sp)
	bsr.s	T_988
	bne.s	.T_978
	lea	T_932(PC),A0
	bsr.s	supexec_ia0
.T_972:
	movem.l	(sp)+,D0-D3/A0-A2
	rts
;
.T_978:
	bsr.s	T_932
	bra.s	.T_972
;
;----------------------------------------------------------------------------
;
supexec_ia0:
	move.l	A0,-(sp)
	move	#$26,-(sp)
	trap	#14			 ;Supexec
	addq.l	#6,sp
	rts
;
;----------------------------------------------------------------------------
;
T_988:
	tst.b	new_cpu_f
	bne.s	.T_998
	move	sr,D0
	btst	#13,D0
	rts
;
.T_998:
	move.b	ACC_active_f(PC),D3
	clr.b	ACC_active_f
	move.l	#1,-(sp)
	move	#$20,-(sp)
	trap	#1			 ;Super
	addq.l	#6,sp
	move.b	D3,ACC_active_f
	tst.l	D0
	rts
;
;----------------------------------------------------------------------------
;
exit_system:
	tst	T_19C
	beq.s	.T_9D2
	move.l	old_currbp_p(PC),new_currbp_p
	bsr.s	patch_system
	clr	T_19C
.T_9D2:
	rts
;
;----------------------------------------------------------------------------
;
enter_system:
	tst	T_19C
	bne.s	.T_9F0
	move	#1,T_19C
	move.l	basepage_p(PC),new_currbp_p
	bsr	patch_system
.T_9F0:
	rts
;
;----------------------------------------------------------------------------
;
move_14_ia0p_to_ia1p:
	moveq	#(14/2)-1,D0
.loop:
	move	(A0)+,(A1)+
	dbra	D0,.loop
	rts
;
;----------------------------------------------------------------------------
;
	XB_define	nu_xgemdos,'Cham'
	cmpi	#$73,D0				;VDI ?
	bne.s	non_vdi_xgemdos
	tst.b	ACC_active_f
	bne.s	nu_VDI
	movea.l	nu_xgemdos+xb_next(PC),A0
	jmp	(A0)
;
;----------------------------------------------------------------------------
;
nu_VDI:
	movea.l	D1,A0
	movea.l	(A0),A0
	cmpi	#v_opnwk&$FF,(A0)
	beq	nu_v_opnwk
	cmpi	#v_opnvwk&$FF,(A0)
	beq	nu_v_opnvwk
	cmpi	#v_clswk&$FF,(A0)
	beq	nu_v_clsxwk
	cmpi	#v_clsvwk&$FF,(A0)
	beq	nu_v_clsxwk
	cmpi	#vst_load_fonts&$FF,(A0)
	beq	nu_vst_load_fonts
	cmpi	#vst_unload_fonts&$FF,(A0)
	beq	nu_vst_unload_fonts
	cmpi	#v_show_c&$FF,(A0)
	beq	nu_v_show_c
	cmpi	#v_hide_c&$FF,(A0)
	beq	nu_v_hide_c
	bra	use_old_xgemdos
;
non_vdi_xgemdos:
	cmpi	#$C8,D0
	bne	non_vdi_aes_xgemdos
nu_AES:
	move.l	(ev_xgemdos).w,T_1BA		 ;trp2vec
	movea.l	D1,A0
	movea.l	(A0),A0
	cmpi	#appl_find&$FF,(A0)
	bne.s	T_A92
nu_appl_find:
	move.l	2(sp),T_1F8
	lea	post_appl_find(PC),A0
	move.l	A0,2(sp)
	nop
	nop
T_A92:
	tst.b	ACC_active_f
	beq	use_old_xgemdos
	bsr	exit_system
	clr.b	ACC_active_f
	move.l	2(sp),T_1CC
	lea	post_nu_AES(PC),A0
	move.l	A0,2(sp)
	movea.l	D1,A0
	movea.l	(A0),A0
	cmpi	#menu_register&$FF,(A0)
	beq	nu_menu_register
	cmpi	#rsrc_load&$FF,(A0)
	beq	nu_rsrc_load
	cmpi	#evnt_mesag&$FF,(A0)
	beq	nu_evnt_mesag
	cmpi	#evnt_timer&$FF,(A0)
	beq	nu_evnt_timer
	cmpi	#evnt_multi&$FF,(A0)
	beq	nu_evnt_multi
	cmpi	#graf_mouse&$FF,(A0)
	beq	nu_graf_mouse
	cmpi	#wind_open&$FF,(A0)
	beq	nu_wind_open_close_delete
	cmpi	#wind_close&$FF,(A0)
	beq	nu_wind_open_close_delete
	cmpi	#wind_delete&$FF,(A0)
	beq	nu_wind_open_close_delete
	cmpi	#wind_update&$FF,(A0)
	beq	nu_wind_update
	bra.s	use_old_xgemdos
;
non_vdi_aes_xgemdos:
	cmpi	#$C9,D0
	bne.s	use_old_xgemdos
	tst.b	ACC_active_f
	beq.s	use_old_xgemdos
	bsr	exit_system
	clr.b	ACC_active_f
	move.l	2(sp),T_1CC
	lea	T_B3A(PC),A0
	move.l	A0,2(sp)
use_old_xgemdos:
	movea.l	nu_xgemdos+xb_next(PC),A0
	jmp	(A0)
;
;----------------------------------------------------------------------------
;
T_B3A:	move.b	#1,ACC_active_f
	movea.l	T_1CC(PC),A0
	jmp	(A0)
;
;----------------------------------------------------------------------------
;
post_nu_AES:
	movem.l	D2,-(sp)
	movea.l	D1,A0
	movea.l	(A0),A0
	move	(A0),D2
	cmpi	#evnt_mesag&$FF,D2
	beq.s	post_evnt_mesag
	cmpi	#evnt_multi&$FF,D2
	beq.s	post_evnt_multi
	cmpi	#wind_open&$FF,D2
	beq	post_wind_open
	cmpi	#wind_close&$FF,D2
	beq	post_wind_close_delete
	cmpi	#wind_delete&$FF,D2
	beq	post_wind_close_delete
	cmpi	#rsrc_load&$FF,(A0)
	beq	post_rsrc_load
	bra	T_C78
;
;----------------------------------------------------------------------------
;
post_evnt_multi:
	move	T_1E0(PC),D2
	andi.w	#$10,D2
	beq	T_C78
	movea.l	D1,A0
	movea.l	12(A0),A0
	move	(A0),D2
	andi.w	#$10,D2
	beq	T_C78
post_evnt_mesag:
	move.b	T_1C4,D2
	bgt.s	T_BA8
	addq.b	#1,D2
T_BA8:	move.b	D2,T_1C4
	movea.l	D1,A0
	movea.l	$10(A0),A0
	movea.l	(A0),A0
	cmpi	#$29,(A0)
	beq	T_C88
	cmpi	#$28,(A0)
	beq.s	T_BD4
	cmpi	#$4711,(A0)
	bne	T_C78
	move	#1,T_1C0
T_BD4:	movem.l	D0-D7/A0-A6,-(sp)
	movea.l	basepage_p(PC),A5
	move.l	6(A0),$102(A5)
	tst	T_1C0
	bne.s	T_BFC
	movea.l	kbshift_p-bp(A5),A1
	move.b	(A1),D2
	andi.b	#15,D2
	cmp.b	T_12F8(PC),D2
	bne.s	T_C50
	bra.s	T_C0E
;
T_BFC:	bsr	T_31E
	bsr	test_loadable
	bge.s	T_C0E
	clr	T_1C0
	bra.s	T_C74
;
T_C0E:	bsr	T_8C4
	tst.b	ACC_active_f
	beq.s	T_C46
	move	#$4F,D0		;graf_mkstate
	move.l	#$50000,D1
	bsr	aes_sub
	move.b	T_6B(PC),D0
	cmpi.b	#2,D0
	bne	exit_ACC_rout
	bsr	T_36C
	clr	T_56
	bsr	kick_wind_8
	bra	exit_ACC_rout
;
T_C46:	lea	cannot_unload_ACC_al_s(PC),A0
	bsr	form_alert_sub
	bra.s	T_C74
;
T_C50:	andi.b	#3,D2
	beq.s	T_C74
	move.b	T_5F(PC),D1
	cmpi.b	#1,D1
	beq.s	T_C74
	addq	#1,8(A0)
	cmpi.b	#2,D1
	beq.s	T_C74
	btst	#0,D2
	beq.s	T_C74
	addq	#1,8(A0)
T_C74:	movem.l	(sp)+,D0-D7/A0-A6
T_C78:	move.b	#1,ACC_active_f
	move.l	(sp)+,D2
	movea.l	T_1CC(PC),A0
	jmp	(A0)
;
;----------------------------------------------------------------------------
;
T_C88:	tst.b	T_1C4
	bne.s	T_CAA
	move.l	A2,-(sp)
	lea	T_152(PC),A2
	move.l	(A2)+,D2
	add.l	(A2)+,D2
	add.l	(A2)+,D2
	add.l	(A2),D2
	movea.l	(sp)+,A2
	tst.l	D2
	beq.s	T_CAA
	move	#$4242,(A0)
	bra.s	T_C78
;
T_CAA:	lea	T_152(PC),A0
	clr.l	(A0)+
	clr.l	(A0)+
	clr.l	(A0)+
	clr.l	(A0)
	bra.s	T_C78
;
;----------------------------------------------------------------------------
;
post_appl_find:
	move.l	D2,-(sp)
	movea.l	D1,A0
	movea.l	12(A0),A0	;a0 -> intout
	move	(A0),D2		;d2 =  intout[0]
	bpl.s	.exit		;exit if application found
	movea.l	D1,A0
	movea.l	16(A0),A0
	movea.l	(A0),A1		;a1 = addrin[0]
	lea	app_name_s(PC),A0	;a0 -> app_name_s
	moveq	#7,D2
.loop:
	cmpm.b	(A0)+,(A1)+
	bne.s	.exit		;exit if loaded application doesn't match
	dbra	D2,.loop
	movea.l	D1,A0
	movea.l	12(A0),A0	;a0 -> intout
	move	appl_id,(A0)	;intout[0] = appl_id
.exit:
	move.l	(sp)+,D2
	movea.l	T_1F8(PC),A0
	jmp	(A0)
;
;----------------------------------------------------------------------------
;
nu_menu_register:
	movea.l	D1,A0
	movea.l	$10(A0),A0
	movea.l	(A0),A1
	movea.l	D1,A0
	movea.l	8(A0),A0
	tst	(A0)
	bmi.s	T_D70
	tst.b	T_5F
	bne.s	T_D16
	bsr	T_314
	move.b	#3,ACC_title_s
	bra.s	T_D4E
;
T_D16:	move.b	T_5F(PC),D0
	cmpi.b	#1,D0
	bgt.s	T_D38
	lea	T_1305(PC),A0
	bsr	strcpy_ia0p_ia1p
	move.b	#3,T_1305
	clr.b	T_130F
	bra.s	T_D4E
;
T_D38:	lea	T_130A(PC),A0
	bsr	strcpy_ia0p_ia1p
	move.b	#3,T_130A
	clr.b	T_130F
T_D4E:	movea.l	D1,A0		;a0 -> aespb
	movea.l	12(A0),A0	;a0 -> intout
	move	Next_ACC_id,(A0)
	addq.b	#1,T_5F
	addq	#1,Next_ACC_id
T_D66:	move.b	#1,ACC_active_f
	rte
;
;------------------------------------
;
T_D70:	lea	app_name_s(PC),A0
	bsr	strcpy_ia0p_ia1p
	bra.s	T_D66
;
;----------------------------------------------------------------------------
;
nu_wind_update:
	movea.l	D1,A0
	movea.l	8(A0),A0
	tst	(A0)
	beq.s	T_D96
	cmpi	#1,(A0)
	bne	use_old_xgemdos
	addq	#1,T_184
	bra	use_old_xgemdos
;
T_D96:	subq.w	#1,T_184
	bra	use_old_xgemdos
;
;----------------------------------------------------------------------------
;
nu_graf_mouse:
	movea.l	D1,A0
	movea.l	8(A0),A0
	cmpi	#$100,(A0)
	beq.s	T_DBE
	cmpi	#$101,(A0)
	bne	use_old_xgemdos
	subq.b	#1,T_190
	bra	use_old_xgemdos
;
T_DBE:	addq.b	#1,T_190
	bra	use_old_xgemdos
;
;----------------------------------------------------------------------------
;
nu_v_show_c:
	movea.l	D1,A0
	movea.l	4(A0),A0
	tst	(A0)
	bne.s	T_DDC
	clr.b	T_191
	bra	use_old_xgemdos
;
T_DDC:	addq.b	#1,T_191
	bra	use_old_xgemdos
;
;----------------------------------------------------------------------------
;
nu_v_hide_c:
	subq.b	#1,T_191
	bra	use_old_xgemdos
;
;----------------------------------------------------------------------------
;
nu_rsrc_load:
	move.b	#1,T_5E
	movem.l	A1/A2/A5,-(sp)
	movea.l	D1,A0
	movea.l	$10(A0),A2
	bsr	T_122A
	movem.l	(sp)+,A1/A2/A5
	bra	use_old_xgemdos
;
;----------------------------------------------------------------------------
;
post_rsrc_load:
	clr.b	T_5E
	movea.l	D1,A0
	movea.l	12(A0),A0
	tst	(A0)
	bne	T_C78
	movem.l	D0-D7/A0-A6,-(sp)
	movea.l	basepage_p(PC),A5
	lea	cannot_load_RSC_al_s(PC),A0
	bsr	form_alert_sub
	bra	T_C0E
;
;----------------------------------------------------------------------------
;
nu_evnt_multi:
	movea.l	D1,A0
	movea.l	8(A0),A0
	move	(A0),T_1E0
nu_evnt_mesag:
	clr.b	T_198
	bra	use_old_xgemdos
;
;----------------------------------------------------------------------------
;
nu_evnt_timer:
	tst.b	T_198
	beq	use_old_xgemdos
	movea.l	D1,A0
	movea.l	(A0),A0		;a0 -> contrl
	move	#$19,(A0)+	;force opcode = evnt_multi
	move	#16,(A0)+
	move	#7,(A0)+
	move	#1,(A0)+
	clr	(A0)
	movea.l	D1,A0
	movea.l	8(A0),A0	;a0 -> intin
	move	(A0),$1C(A0)	;intin[14] = intin[0]
	move	2(A0),$1E(A0)	;intin[15] = intin[1]
	move	#$30,(A0)	;intin[0] = mu_mesag|mu_timer
	move	#$30,T_1E0
	move.l	A1,-(sp)
	movea.l	basepage_p(PC),A1
	lea	mesag_buf-bp(A1),A1
	movea.l	D1,A0
	movea.l	16(A0),A0	;a0 -> addrin
	move.l	A1,(A0)		;addrin[0] = &(mesag_buf[0])
	movea.l	(sp)+,A1
	bra	use_old_xgemdos
;
;----------------------------------------------------------------------------
;
nu_wind_open_close_delete:
	movea.l	D1,A0
	movea.l	8(A0),A0
	move	(A0),T_204
	bra	use_old_xgemdos
;
;----------------------------------------------------------------------------
;
post_wind_open:
	lea	T_152(PC),A0
	move	T_204(PC),D2
	asl	#1,D2
	move	#1,0(A0,D2.w)
	bra	T_C78
;
;----------------------------------------------------------------------------
;
post_wind_close_delete:
	lea	T_152(PC),A0
	move	T_204(PC),D2
	asl	#1,D2
	clr	0(A0,D2.w)
	bra	T_C78
;
;----------------------------------------------------------------------------
;
nu_v_opnwk:
	move.l	2(sp),T_1CC
	lea	T_F2C(PC),A0
	move.l	A0,2(sp)
	move.b	#1,T_5D
	bra	use_old_xgemdos
;
;----------------------------------------------------------------------------
;
nu_v_opnvwk:
	move.l	2(sp),T_1CC
	lea	T_F48(PC),A0
	move.l	A0,2(sp)
	move.b	#1,T_5D
	bra	use_old_xgemdos
;
;----------------------------------------------------------------------------
;
nu_v_clsxwk:
	movem.l	D2/D3,-(sp)
	move	12(A0),D2
	moveq	#7,D3
	lea	T_172(PC),A1
T_F1A:	cmp	(A1)+,D2
	bne.s	T_F20
	clr	-(A1)
T_F20:	dbra	D3,T_F1A
	movem.l	(sp)+,D2/D3
	bra	use_old_xgemdos
;
T_F2C:	move.l	A1,-(sp)
	lea	T_172(PC),A1
T_F32:	tst	(A1)+
	bne.s	T_F32
	movea.l	D1,A0
	movea.l	(A0),A0
	tst	12(A0)
	bmi.s	T_F60
	move	12(A0),-(A1)
	neg	(A1)
	bra.s	T_F60
;
T_F48:	move.l	A1,-(sp)
	lea	T_172(PC),A1
T_F4E:	tst	(A1)+
	bne.s	T_F4E
	movea.l	D1,A0
	movea.l	(A0),A0
	tst	12(A0)
	bmi.s	T_F60
	move	12(A0),-(A1)
T_F60:	clr.b	T_5D
	movea.l	(sp)+,A1
	movea.l	T_1CC(PC),A0
	jmp	(A0)
;
;----------------------------------------------------------------------------
;
nu_vst_load_fonts:
	move	12(A0),T_1FE
	move.l	2(sp),T_1CC
	lea	T_F92(PC),A0
	move.l	A0,2(sp)
	move.b	#1,T_5D
	bra	use_old_xgemdos
;
T_F92:	tst	intout
	beq.s	T_FB8
	movem.l	D2/A2,-(sp)
	lea	T_186(PC),A2
	moveq	#7,D2
T_FA4:	tst.b	(A2)+
	bne.s	T_FB0
	move.b	T_1FF(PC),-$1(A2)
	bra.s	T_FB4
;
T_FB0:	dbra	D2,T_FA4
T_FB4:	movem.l	(sp)+,D2/A2
T_FB8:	clr.b	T_5D
	movea.l	T_1CC(PC),A0
	jmp	(A0)
;
;----------------------------------------------------------------------------
;
nu_vst_unload_fonts:
	movem.l	D2/D3/A2,-(sp)
	move	12(A0),D2
	lea	T_186(PC),A2
	moveq	#7,D3
T_FD2:	cmp.b	(A2)+,D2
	bne.s	T_FDA
	clr.b	-$1(A2)
T_FDA:	dbra	D3,T_FD2
	movem.l	(sp)+,D2/D3/A2
	bra	use_old_xgemdos
;
;----------------------------------------------------------------------------
;
	XB_define	nu_gemdos,'Cham'
	move	(sp),D0
	btst	#13,D0
	bne.s	T_FFE
	move	usp,A0
	bra.s	T_1004
;
T_FFE:
	movea.l	sp,A0
	adda	frame_size(PC),A0
T_1004:
	cmpi	#Mfree&$FF,(A0)
	bne.s	T_103C
nu_mfree_1:
	move.l	2(A0),D0
	cmp.l	basepage_p(PC),D0	;someone removing chameleon ?
	bne.s	T_103C
	movem.l	D0-D7/A0-A6,-(sp)
	bsr	T_74E
	bsr	T_734			;remove loaded ACC and its RAM blocks
	move.l	A5,ACC_RAM_base_t
	move.l	$18(A5),D0
	sub.l	A5,D0
	move.l	D0,ACC_RAM_size_t
	bsr	T_74E
	movem.l	(sp)+,D0-D7/A0-A6
	bra.s	use_old_gemdos
;
T_103C:
	tst.b	T_5E
	beq.s	T_1046
	bra.s	T_104E
;
T_1046:	tst.b	ACC_active_f
	beq.s	use_old_gemdos
T_104E:	move	(A0),D0
	move	D0,T_1D4
	cmpi	#14,D0
	beq.s	T_10A6
	cmpi	#Dgetdrv&$FF,D0
	beq.s	T_10A6
	cmpi	#Fsetdta&$FF,D0
	beq.s	T_10A6
	cmpi	#Fgetdta&$FF,D0
	beq.s	T_10A6
	cmpi	#Dfree&$FF,D0
	blt.s	use_old_gemdos
	cmpi	#Dsetpath&$FF,D0
	beq	nu_dsetpath
	cmpi	#Fcreate&$FF,D0
	beq	nu_Fcreate_Fopen
	cmpi	#Fopen&$FF,D0
	beq	nu_Fcreate_Fopen
	cmpi	#Malloc&$FF,D0
	beq.s	nu_Malloc
	cmpi	#Mfree&$FF,D0
	beq.s	nu_Mfree_2
	cmpi	#Mshrink&$FF,D0
	beq.s	nu_Mshrink
	cmpi	#Pexec&$FF,D0
	beq	nu_Pexec
T_10A6:
	bsr	enter_system
T_10AA:
	lea	post_nu_gemdos(PC),A0
	move.l	2(sp),T_1D6
	move.l	A0,2(sp)
use_old_gemdos:
	movea.l	nu_gemdos+xb_next(PC),A0
	jmp	(A0)
;
;------------------------------------
;
post_nu_gemdos:
	move.l	D1,-(sp)
	bsr	exit_system
	tst.b	T_5D
	bne.s	T_10EE
	move	T_1D4(PC),D1
	cmpi	#Malloc&$FF,D1
	beq.s	post_Malloc
	cmpi	#Mfree&$FF,D1
	beq	post_Mfree
	cmpi	#Mshrink&$FF,D1
	beq.s	post_Mshrink
	cmpi	#Pexec&$FF,D1
	beq	post_Pexec
T_10EE:
	move.l	(sp)+,D1
	movea.l	T_1D6(PC),A0
	jmp	(A0)
;
;----------------------------------------------------------------------------
;
nu_Malloc:
	move.l	2(A0),T_E8	;T_E8 = requested size
	bra.s	T_10A6
;
;----------------------------------------------------------------------------
;
nu_Mfree_2:
	move.l	2(A0),T_E8	;T_E8 -> area to release
	move.l	2(A0),T_80	;T_80 -> area to release
	bra.s	T_10AA
;
;----------------------------------------------------------------------------
;
nu_Mshrink:
	move.l	4(A0),T_80	;T_80 -> area to shrink
	move.l	8(A0),T_E8	;T_E8 =  shrunk size
	bra.s	T_10AA
;
;----------------------------------------------------------------------------
;
post_Malloc:
	tst.l	T_E8
	bmi.s	T_10EE
	tst.l	D0
	bmi.s	T_10EE
	movem.l	D0/D1/A0/A1,-(sp)
	bsr.s	T_113C
	movem.l	(sp)+,D0/D1/A0/A1
	bra.s	T_10EE
;
T_113C:
	bsr.s	T_11B2
T_113E:
	tst.l	(A0,D1)
	beq.s	T_114E
	addq	#4,D1
	cmpi	#$64,D1
	blt.s	T_113E
	bra.s	T_1158
;
T_114E:
	move.l	D0,(A0,D1)
	move.l	T_E8(PC),(A1,D1)
T_1158:
	rts
;
;----------------------------------------------------------------------------
;
post_Mshrink:
	tst.l	D0
	bmi.s	T_10EE
	movem.l	D0/D1/A0/A1,-(sp)
	bsr.s	T_11B2
	move.l	T_80(PC),D0
T_1168:	cmp.l	(A0,D1),D0
	beq.s	T_1176
	addq	#4,D1
	cmpi	#$64,D1
	blt.s	T_1168
T_1176:	move.l	D0,(A0,D1)
	move.l	T_E8(PC),(A1,D1)
T_1180:	movem.l	(sp)+,D0/D1/A0/A1
	bra	T_10EE
;
;----------------------------------------------------------------------------
;
post_Mfree:
	tst.l	D0
	bmi	T_10EE
	movem.l	D0/D1/A0/A1,-(sp)
	bsr.s	T_11B2
	move.l	T_80(PC),D0
T_1198:	cmp.l	(A0,D1),D0
	beq.s	T_11A8
	addq	#4,D1
	cmpi	#$64,D1
	blt.s	T_1198
	bra.s	T_1180
;
T_11A8:	clr.l	(A0,D1)
	clr.l	(A1,D1)
	bra.s	T_1180
;
T_11B2:
	lea	ACC_RAM_base_t(PC),A0
	lea	ACC_RAM_size_t(PC),A1
	clr	D1
	rts
;
;----------------------------------------------------------------------------
;
nu_Pexec:
	cmpi	#3,2(A0)
	beq	T_10A6
	bra	use_old_gemdos
;
post_Pexec:
	tst.l	D0
	bmi	T_10EE
	movem.l	D0/D1/A0/A1,-(sp)
	movea.l	D0,A0
	movea.l	12(A0),A1
	adda.l	$14(A0),A1
	adda.l	$1C(A0),A1
	adda	#$100,A1
	move.l	A1,T_E8
	bsr	T_113C
	movea.l	D0,A0
	move.l	$2C(A0),D0
	suba.l	D0,A0
	move.l	A0,T_E8
	bsr	T_113C
	movem.l	(sp)+,D0/D1/A0/A1
	bra	T_10EE
;
;----------------------------------------------------------------------------
;
nu_Fcreate_Fopen:
	movem.l	A1/A2/A5,-(sp)
	lea	2(A0),A2
	bsr.s	T_122A
	movem.l	(sp)+,A1/A2/A5
	bra	T_10A6
;
;----------------------------------------------------------------------------
;
nu_dsetpath:
	movea.l	basepage_p(PC),A0
	st	$140(A0)
	bra	T_10A6
;
T_122A:	movea.l	basepage_p(PC),A5
	tst.b	$140(A5)
	bne.s	T_1256
	movea.l	$12A(A5),A0
	movea.l	(A2),A1
	cmpi.b	#$5C,(A1)
	beq.s	T_124C
	cmpi.b	#$3A,1(A1)
	beq.s	T_1256
	move.b	#$5C,(A0)+
T_124C:	bsr	strcpy_ia0p_ia1p
	lea	ACC_pname_s-bp(a5),A1
	move.l	A1,(A2)
T_1256:	rts
;
;----------------------------------------------------------------------------
;
	XB_define	nu_bios,'Cham'
	move	(sp),D0
	btst	#13,D0			;Super caller ?
	beq.s	use_old_bios
	movea.l	sp,A0
	adda	frame_size(PC),A0
	cmpi	#Setexc&$FF,(A0)	;Setexc(?,?) ?
	bne.s	use_old_bios
	cmpi	#etvn_critic,2(A0)	;Setexc(etvn_critic,?) ?
	bne.s	use_old_bios
	movea.l	4(A0),A0
	cmpa.l	sys_base_p,A0		;new etv_critic < (sys_base_p) ?
	blt.s	use_old_bios
	cmpa.l	sys_end_p,A0		;new etv_critic > (sys_end_p) ?
	bgt.s	use_old_bios
	lea	post_setexc(PC),A0
	move.l	2(sp),T_1A2
	move.l	A0,2(sp)
use_old_bios:
	movea.l	nu_bios+xb_next(PC),A0
	jmp	(A0)
;
;------------------------------------
;
post_setexc:
	move.l	T_1BA,(ev_xgemdos).w
	movea.l	T_1A2(PC),A0
	jmp	(A0)
;
;----------------------------------------------------------------------------
;
basepage_p:	dc.l	0
new_cpu_f:	dc.b	$0,$0,'^'
T_12BF:	dc.b	'J^'
iz_ACC_path_s:
	dc.b	'A:\*.AC?',$0,'             ^'
iz_ACC_pname_s:
	dc.b	'A:\CONTROL.ACX',$0,'                ^'
T_12F8:	dc.b	$A
T_12F9:	dc.b	$0,'^'
ACC_title_s:
	dc.b	'V1.19 K.I'
T_1305:	dc.b	'sakov'
T_130A:	dc.b	'ic',$0,'Be'
T_130F:	dc.b	'rlin 09.10.90',$0
iz_ACC_title_s:
	dc.b	'  The Chameleon',$0
;
cannot_unload_ACC_al_s:
	dc.b	"[0][ The Chameleon can't   |   unload the ACC ! ][ K.Isakovic]",NUL
ACC_not_loaded_al_s:
	dc.b	"[0][ ACC not loaded ][ K.Isakovic]",NUL
cannot_load_RSC_al_s:
	dc.b	"[0][ Can't load RSC-File ][ K.Isakovic]",$0
;
T_13BC:	dc.b	'Chameleon 1.19  K.Isakovic',$0
T_13D8:	dc.b	$3,$3,'  '
app_name_s:
	dc.b	'        ',$0,$0
;
aespb:
	dc.l	contrl
	dc.l	0
	dc.l	intin
	dc.l	intout
	dc.l	addrin_ptsin
	dc.l	addrout_ptsout
;
vdipb:
	dc.l	contrl
	dc.l	intin
	dc.l	addrin_ptsin
	dc.l	intout
	dc.l	addrout_ptsout
;
contrl:
	dc.b	$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
	dc.b	$0
;
loc_currbp_p_p:
	dc.l	0
old_currbp_p:
	dc.l	0
new_currbp_p:
	dc.l	0
;
;----------------------------------------------------------------------------
;
	SECTION	BSS
;
;----------------------------------------------------------------------------
;
	ds.l	64			 ;=256
;
;----------------------------------------------------------------------------
;
	END
;
;----------------------------------------------------------------------------
;End of file:	CHMELEON.S
;----------------------------------------------------------------------------
