; File name:	FOLDRnnn.S	Revised:	1999.06.10
; Disassembler:	U.R.Andersson	Disassembled:	1991.05.28
; Purpose:	Fix folder limit bug in TOS 1.0 & 1.2
;
;
	include	RA_SYS.I
	include	RA_TOS.I
;
;
	text
;
L0:
	move.l	4(sp),a4	;a4->basepage
	move.l	4(a4),d6	;d6->selfend
	sub.l	a4,d6		;d6 = selfsize
	lea	$82(a4),a4	;a4->2'nd arg char
	lea	4(a4),a0	;a0->6'th arg char
	lea	copy_base(pc),a1
	moveq	#(copy_limit-copy_base)-1,d0
copy_loop:	;Copies 28 bytes code to basepage+$86
	move.b	(a1)+,(a0)+
	dbra	d0,copy_loop
	gemdos	Super,!		;enter Supervisor mode
	move.l	d0,-(sp)
	move	#$20,-(sp)
	bsr	TOS_adapt	;flags EQ=modify  NE=abstain
	trap	#1
	addq	#6,sp
	bne.b	do_hitkeyexit
	bsr	calc_nnn
	move	nnn_word,d7
	mulu	#66,d7
	add.l	#$80,d7
	cmp.l	d7,d6
	ble.b	L6A
	clr	-(sp)
	move.l	d7,-(sp)
	move	#$31,-(sp)	;gemdos Ptermres(size,0) for future call
	move.l	a4,a0
	move	nnn_word,d0
	subq	#1,d0
	lea	16(a5),a5
	jmp	4(a4)		;goto the code copied into basepage
;
L6A:
	gemdos	Cconws,s_nomem(PC)
do_hitkeyexit:
	move.l	#s_hitkeyexit,a0
	move.l	a0,-(sp)
	gemdos	Cconws,()
	bios	Bconin,#2
	gemdos	Pterm,#1
;
	dc.w	$4AFC
;
s_nomem:
	dc.b	'Not enough memory to add folders.',CR,LF,NUL
	even
;
TOS_adapt:
	move.l	(_sysbase).w,a3	;a3->OS base
	move.l	32(a3),a5	;a5->start of OS pool (but only for late TOS)
	cmpi	#$E4A,30(a3)	;Check OS date (gemdos format)
	bge.b	LE4		;Use pool ptr if beyond a certain date (TOS 1.4 ?)
	lea	OS_table(pc),a0
LD6:
	move.l	(a0)+,d1	;d1= TOS date (bcd format)
	beq	sub_not_to_TOS	;refuse to modify unknown TOS at end of list
	move.l	(a0)+,a5	;a5->start of OS pool for early TOS
	cmp.l	24(a3),d1	;but is it the right TOS ?
	bne.b	LD6		;if not, loop to check whole table
LE4:	;here a5->start of OS pool
	moveq	#0,d0
	rts
;
;
OS_table:
	dc.l	$11201985,$56FA	;TOS 1.0
	dc.l	$02061986,$56FA
	dc.l	$04241986,$56FA
	dc.l	$06011986,$7E0A
;
	dcb.l	7,0
;
;
sub_not_to_TOS:
	gemdos	Cconws,s_not_to_TOS(pc)
	moveq	#1,d0
	rts
;
s_not_to_TOS:
	dc.b	"Can't add folders to this version of TOS",CR,LF,NUL
	even
;
;
calc_nnn:
	gemdos	Fsetdta!_IND,#localdta
	gemdos	Fsfirst!_IND,#s_selfname,#0
	tst	d0
	bmi	exit_notfound
	moveq	#0,d7
	moveq	#0,d0
	lea	localdta+35,a0	;a0->6'th char of filename
.calcloop:
	move.b	(a0)+,d0
	beq.b	.calc_end
	cmp.b	#'.',d0
	beq.b	.calc_end
	sub.b	#'0',d0
	bmi.b	exit_notfound
	cmp.b	#10,d0
	bge.b	exit_notfound
	mulu	#10,d7
	add	d0,d7
	bra.b	.calcloop
;
.calc_end:
	move	d7,nnn_word
	beq.b	exit_badnumber
	add	d7,nnn_word
	clr.l	d0
	move	d7,d0
	move.l	d0,-(sp)
	bsr	shownumber
	addq	#4,sp
	move.l	#s_extrafold,a0
	move.l	a0,-(sp)
	gemdos	Cconws,()
	mulu	#$84,d7
	move.l	d7,-(sp)
	bsr	shownumber
	addq	#4,sp
	move.l	#s_bytes,a0
	move.l	a0,-(sp)
	gemdos	Cconws,()
	rts
;
;
exit_badnumber:
	gemdos	Cconws!_IND,#s_badnumber
	bra	do_hitkeyexit
;
;
exit_notfound:
	gemdos	Cconws!_IND,#s_notfound
	bra	do_hitkeyexit
;
;
s_selfname:
	dc.b	'\AUTO\FOLDR*.PRG',NUL
s_notfound:
	dc.b	'Cannot find \AUTO\FOLDRnnn.PRG',LF,NUL
s_badnumber:
	dc.b	'Bad number of folders specified.',LF,NUL
	even
;
;
copy_base:	;This code is copied into basepage+$86
; at entry:	;a0= a4->bp+$82
	lea	66(a0),a1
	move.l	a1,(a0)
	move	#$4,-2(a0)
	move.l	a1,a0
	dbra	d0,copy_base
	move.l	(a5),-66(a0)
	move.l	a4,(a5)
	trap	#1	;Calls gemdos Ptermres, with stack prepared previously
	dc.w	$4AFC
copy_limit:
;
;
shownumber:
	lea	numbuf_1,a0
	move.l	4(sp),d0
L294:
	divu	#10,d0
	swap	d0
	add.b	#'0',d0
	move.b	d0,(a0)+
	swap	d0
	and.l	#$FFFF,d0
	bne.b	L294
	lea	numbuf_2,a1
L2B0:
	move.b	-(a0),(a1)+
	cmp.l	#numbuf_1,a0
	bne.b	L2B0
	clr.b	(a1)+
	gemdos	Cconws!_IND,#numbuf_2
	rts
;
;
	data
;
;
s_hitkeyexit:
	dc.b	$D,$A
	dc.b	'Hit any key to exit...'
	dc.b	$D,$A,0
s_extrafold:
	dc.b	' extra folders in '
	dc.b	$0
s_bytes:
	dc.b	' bytes'
	dc.b	$D,$A,0,0
;
;
	bss	;$304:
;
;
localdta:	ds.b	44
nnn_word:	ds.w	1
numbuf_1:	ds.b	10
numbuf_2:	ds.b	12
;
	end	;of file:	FOLDRnnn.S

