;----------------------------------------------------------------------------
;File name:	DUETMIDI.S			Revision date:	1997.03.25
;Revised by:	Ulf Ronald Andersson		Disassembled:	1997.03.25
;----------------------------------------------------------------------------
; QED-ASMPAR 4 0006  $DSDR:Z:1159,M:4
;Desert	Drain V1.52   680x0er Disassembler  25.03.1997 06:33:06
;DATEI:	DUETMIDI.ORG   4818 Bytes
;TEXT:	 4320	$010E0
;DATA:	  354	$00162
;BSS:	18584  $004898
;----------------------------------------------------------------------------
;
	include	URAn_DOS.S
	include	URAn_XB.S
	include	URAn_JAR.S
;
;----------------------------------------------------------------------------
;
MAX_BUFF	=	4096
SAFE_MARGIN	=	128
MAX_DRIVE	=	'P'-'A'
;
;----------------------------------------------------------------------------
;
	SECTION	TEXT
;
;----------------------------------------------------------------------------
;
start:
	lea	initial_stk_top,SP
	gemdos	Cconws,prog_title_s(pc)
	bsr.s	main_init
	moveq	#0,D0
	tst.w	init_error
	bne.s	no_creation
	gemdos	Ptermres,#bss_end-start+$100,!
;
;------------------------------------
;
no_creation:
	gemdos	Cconws,no_creation_s(pc)
	gemdos	Crawcin
	gemdos	Pterm,init_error(pc)
;
;----------------------------------------------------------------------------
;
main_init:
	clr.w	B_3280
	clr.w	B_4296
	clr.w	B_1250
	clr.w	B_226A
	xbios	Supexec,init_1_supx(PC)
	tst.w	init_error
	bne.s	.exit
	xbios	Kbdvbase
	movea.l	D0,A0
	lea	kv_midi_vec(A0),A1
	lea	nu_midi_vec+xb_next(PC),A2
	bsr.s	linkup_XBRA
.exit:
	rts
;
;----------------------------------------------------------------------------
;
linkup_XBRA:	move.l	(A1),(A2)+
	move.l	A2,(A1)
	rts
;
;----------------------------------------------------------------------------
;
init_1_supx:
	moveq	#6,D0
	tst.w	$59E.w			 ;_longframe
	beq.s	T_AC
	moveq	#8,D0
T_AC:
	move.w	D0,framesize
;
	make_cookie	#'DUET',#duet_cookie_t
	bpl.s		T_106		;goto T_106 if new cookie created
	move	d0,init_error
	rts
;
T_106:
	lea	(hdv_bpb).w,A1		 ;hdv_bpb
	lea	nu_hdv_bpb+xb_next(PC),A2
	bsr.s	linkup_XBRA
;
	lea	(hdv_mediach).w,A1	 ;hdv_mediach
	lea	nu_hdv_mediach+xb_next(PC),A2
	bsr.s	linkup_XBRA
;
	lea	(hdv_rw).w,A1		 ;hdv_rw
	lea	nu_hdv_rw+xb_next(PC),A2
	bsr	linkup_XBRA
;
	lea	(ev_bios).w,A1		 ;trp13vec
	lea	nu_ev_bios+xb_next(PC),A2
	bsr	linkup_XBRA
;
	clr	init_error
	rts
;
;----------------------------------------------------------------------------
;
	XB_define	nu_ev_bios,'DUET'
	movea.l	SP,A0
	btst	#5,(SP)
	bne.s	T_164
	move	usp,A0
	bra.s	T_168
;
T_164:
	adda.w	framesize(PC),A0
T_168:
	move	(a0),d0
	cmpi	#Mediach&$FF,d0
	bhi.s	go_old_bios
	beq.s	nu_bios_mediach
	move	biosfunc_bits(pc),d1
	btst	d0,d1
	beq.s	go_old_bios
	bra.s	try_pretreat_bios
;
biosfunc_bits:
	dc.w	$019E	;pretreat:  Bcostat,Getbpb,Rwabs,Bconout,Bconin,Bconstat
;			;but not:   Kbshift,Drvmap,Tickcal,Setexc,Getmpb
;
nu_bios_mediach:
	move	2(a0),d0		;d0 = drive#
	cmpi	#MAX_DRIVE,d0
	bhi.s	go_old_bios
	lea	drive_flag_2_t(PC),A0
	tst.b	0(A0,D0.w)		;written to disk ?
	beq.s	pretreat_bios
	sf	0(A0,D0.w)
	moveq	#2,D0
	rte
;
;------------------------------------
;
go_old_bios:
	move.l	nu_ev_bios+xb_next(PC),-(SP)
	rts

;
;------------------------------------
;
try_pretreat_bios:
	cmpi	#Getbpb&$FF,d0
	bne.s	not_bios_getbpb
nu_bios_getbpb:
	move	2(a0),d0		;d0 = drive#
	cmpi	#MAX_DRIVE,d0
	bhi.s	go_old_bios
	bra.s	pretreat_bios
;
not_bios_getbpb:
	cmpi	#Rwabs&$FF,d0
	bne.s	pretreat_bios
nu_bios_rwabs:
	move	2(a0),d0		;d0 = drive#
	cmpi	#MAX_DRIVE,d0
	bhi.s	go_old_bios
pretreat_bios:
	move.l	nu_ev_bios+xb_next(PC),-(SP)
T_18C:
	tst.w	B_3280
	bne	T_238
	move.b	bios_fence_2_f(PC),D0
	bne.s	T_1D0
	lea	RX_state_time(PC),A0
	move.l	(A0),D1
	beq.s	T_1D0
	move.l	(_hz_200).w,D0		 ;_hz_200
	sub.l	D1,D0
	subq.l	#5,D0
	blt.s	T_1D0
	clr.l	(A0)
	lea	B_226C(PC),A1
	move.l	#$00628694,(A1)+	;store long prefix code at (a1)+
	moveq	#1,D0			;d0 = function code 1 ???
	move.w	D0,(A1)+
	not.w	D0
	move.w	D0,(A1)+
	clr.l	(A1)+
	move.w	#1,(A1)+
	lea	B_226C(PC),A0
	bsr	T_7A0
T_1D0:
	move.b	bios_fence_3_f(PC),D0
	bne.s	T_236
	move.w	B_52AC,D0
	beq.s	T_236
	tst.b	bios_fence_1_f
	beq.s	T_1FC
	moveq	#-$14,D0
	add.l	(_hz_200).w,D0		 ;_hz_200
	sub.l	D_10F6(PC),D0
	blt.s	T_236
	st	bios_fence_3_f
	bsr	T_F84
	bra.s	T_230
;
;------------------------------------
;
T_1FC:
	st	bios_fence_3_f
	bios	Bcostat,!
	tst.l	D0
	beq.s	T_230
;
	lea	B_52AE,A0
	moveq	#0,D0
	move.w	-2(A0),D0
	gemdos	Fwrite,#3,d0,(a0)
;
	clr.w	B_52AC
T_230:
	clr.b	bios_fence_3_f
T_236:
	rts
;
;------------------------------------
;
T_238:
	tas.b	bios_fence_2_f
	bne.s	T_236
	move.l	SP,B_56D6
	lea	internal_stk_top,SP
	movem.l	D0-D7/A0-A6,-(SP)
	move.l	(etv_critic).w,-(SP)		 ;etv_critic
	move.l	#nu_etv_critic_code,(etv_critic).w		 ;etv_critic
	lea	B_3282(PC),A2
	move.w	-$2(A2),D0
	clr.w	-$2(A2)
	cmpi.b	#2,D_1196
	beq	T_3F2
	subq.w	#4,D0
	lea	4(A2),A0
	bsr	calc_crc
	cmp.l	(A2)+,D0
	beq.s	T_29C
	lea	B_226C(PC),A1
	move.l	#$00628694,(A1)+	;store long prefix code
	moveq	#1,D0
	move.w	D0,(A1)+
	not.w	D0
	move.w	D0,(A1)+
	clr.l	(A1)+
	move.w	#1,(A1)+
	bra	T_3EA
;
;------------------------------------
;
T_29C:
	cmpi.w	#2,(A2)
	beq.s	T_2C4
	cmpi.w	#4,(A2)
	beq.s	T_324
	cmpi.w	#6,(A2)
	beq	T_38E
	cmpi.w	#8,(A2)
	beq	T_406
	cmpi.w	#10,(A2)
	beq	T_448
	bra	T_3F2
;
;------------------------------------
;
T_2C4:
	lea	B_226C(PC),A1
	move.l	#$00628694,(A1)+	;store long prefix code
	move.w	#$15,(A1)+
	move.w	#-$16,(A1)+
	clr.l	(A1)+
	move.w	#3,(A1)+
	move.b	3(A2),(A1)+
	st	(A1)
	move.w	2(A2),D0
	move.w	D0,D_114E
	move.w	D0,-(SP)
	movea.l	(hdv_bpb).w,A0		 ;hdv_bpb
	jsr	(A0)
	addq.l	#2,SP
	tst.l	D0
	beq.s	T_320
	lea	B_227B(PC),A1
	sf	(A1)+
	movea.l	D0,A2
	lea	D_1150(PC),A0
	move.w	D_114E(PC),D1
	add.w	D1,D1
	move.w	(A2),0(A0,D1.w)
	moveq	#3,D0
T_312:
	move.b	(A2)+,(A1)+
	move.b	(A2)+,(A1)+
	move.b	(A2)+,(A1)+
	move.b	(A2)+,(A1)+
	move.b	(A2)+,(A1)+
	dbra	D0,T_312
T_320:
	bra	T_3EA
;
;------------------------------------
;
T_324:
	lea	B_226C(PC),A1
	move.l	#$00628694,(A1)+	;store long prefix code
	move.w	#7,(A1)+
	move.w	#-$8,(A1)+
	clr.l	(A1)+
	move.w	#5,(A1)+
	move.b	3(A2),(A1)+
	move.b	#-13,(A1)+
	move.w	4(A2),(A1)+
	move.w	6(A2),(A1)+
	cmpi.b	#0,D_1196
	beq	T_3EA
	move.w	2(A2),-(SP)
	move.w	4(A2),-(SP)
	move.w	#1,-(SP)
	pea	8(A2)
	move.w	#1,-(SP)
	movea.l	(hdv_rw).w,A0		;hdv_rw
	jsr	(A0)
	lea	12(SP),SP
	move.b	D0,B_227B
	lea	drive_flag_2_t(PC),A0
	move.w	2(A2),D0		;d0 = drive#
	cmpi.w	#MAX_DRIVE,D0
	bhi.s	T_3EA
	st	0(A0,D0.w)		;flag media change on drive
	bra.s	T_3EA
;
;------------------------------------
;
T_38E:
	move.w	2(A2),-(SP)
	move.w	(SP),D_114E
	move.w	4(A2),D0
	move.w	D0,B_227C
	move.w	D0,-(SP)
	move.w	#1,-(SP)
	pea	B_2280(PC)
	clr.w	-(SP)
	movea.l	(hdv_rw).w,A0		 ;hdv_rw
	jsr	(A0)
	lea	12(SP),SP
	lea	B_226C(PC),A1
	move.l	#$00628694,(A1)+
	lea	D_1150(PC),A0
	move.w	D_114E(PC),D1
	add.w	D1,D1
	move.w	0(A0,D1.w),D1
	addq.w	#7,D1
	move.w	D1,(A1)+
	not.w	D1
	move.w	D1,(A1)+
	clr.l	(A1)+
	move.w	#7,(A1)+
	move.b	D_114F(PC),(A1)+
	move.b	D0,(A1)+
	addq.w	#2,A1
	move.w	#1,(A1)+
T_3EA:
	lea	B_226C(PC),A0
	bsr	T_7A0
T_3F2:
	move.l	(SP)+,(etv_critic).w		 ;etv_critic
	movem.l	(SP)+,D0-D7/A0-A6
	movea.l	B_56D6,SP
	clr.b	bios_fence_2_f
	rts
;
;------------------------------------
;
T_406:
	move.w	2(A2),D0
	lea	B_52AC,A0
	move.w	(A0)+,D1
	beq.s	T_416
	moveq	#-1,D0
	bra.s	T_42C
;
;------------------------------------
;
T_416:
	lea	4(A2),A1
	subq.w	#1,D0
T_41C:
	move.b	(A1)+,(A0)+
	dbra	D0,T_41C
	move.w	2(A2),B_52AC
	moveq	#0,D0
T_42C:
	lea	B_226C(PC),A1
	move.l	#$00628694,(A1)+
	move.w	#3,(A1)+
	move.w	#-$4,(A1)+
	clr.l	(A1)+
	move.w	#9,(A1)+
	move.w	D0,(A1)+
	bra.s	T_3EA
;
;------------------------------------
;
T_448:
	st	bios_fence_3_f
	bios	Bcostat,!
	clr.b	bios_fence_3_f
	lea	B_226C(PC),A1
	move.l	#$00628694,(A1)+
	move.w	#$03,(A1)+
	move.w	#$FC,(A1)+
	clr.l	(A1)+
	move.w	#11,(A1)+
	move.w	D0,(A1)+
	bra	T_3EA
;
;----------------------------------------------------------------------------
;
	XB_define	nu_hdv_mediach,'DUET'
	move.w	4(SP),D0
	cmpi.w	#MAX_DRIVE,D0
	bhi.s	T_4A2
	move.w	D0,D_110A
	lea	drive_flag_1_t(PC),A0
	move.b	0(A0,D0.w),D0
	bpl.s	T_4A8
T_4A2:
	move.l	nu_hdv_mediach+xb_next(PC),-(SP)
	rts
;
;------------------------------------
;
T_4A8:
	moveq	#0,D0
	tst.b	D_1106
	beq.s	T_4B4
	moveq	#2,D0
T_4B4:
	rts
;
;----------------------------------------------------------------------------
;
	XB_define	nu_hdv_bpb,'DUET'
	move.w	4(SP),D0
	cmpi.w	#MAX_DRIVE,D0
	bhi.s	T_4DC
	move.w	D0,D_110A
	lea	drive_flag_1_t(PC),A0
	move.b	0(A0,D0.w),D0
	bpl.s	T_4E2
T_4DC:
	move.l	nu_hdv_bpb+xb_next(PC),-(SP)
	rts
;
;------------------------------------
;
T_4E2:
	move.b	D0,D_1109
T_4E8:
	sf	D_1106
	lea	B_1252(PC),A0
	move.l	#$00628694,(A0)+
	moveq	#2,D0
	move.w	D0,(A0)+
	not.w	D0
	move.w	D0,(A0)+
	clr.l	(A0)+
	move.w	#2,(A0)+
	move.w	D_1108(PC),(A0)+
	lea	B_1252(PC),A0
	bsr	T_7D4
	beq.s	T_55E
	move.b	D_1109(PC),D0
	cmp.b	2(A0),D0
	bne.s	T_4E8
	tst.b	3(A0)
	bne.s	T_55E
	addq.l	#4,A0
	move.b	(A0),D0
	lsl.w	#8,D0
	move.b	1(A0),D0
	move.w	D_1108(PC),D1
	add.w	D1,D1
	lea	D_112E(PC),A1
	move.w	D0,0(A1,D1.w)
	move.w	D0,D_112C
	lea	B_56AE,A1
	moveq	#3,D0
.T_548:
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	dbra	D0,.T_548
	move.l	#B_56AE,D0
	rts
;
;------------------------------------
;
T_55E:	moveq	#-2,D0
	bsr	T_A80
	beq.s	T_4E8
	moveq	#0,D0
	rts
;
;----------------------------------------------------------------------------
;
	XB_define	nu_hdv_rw,'DUET'
	move.w	14(SP),D0
	cmpi.w	#MAX_DRIVE,D0
	bhi.s	.go_old_hdv_rw
	move.w	D0,D_110A
	lea	drive_flag_1_t(PC),A0
	move.b	0(A0,D0.w),D0
	bpl.s	.T_596
.go_old_hdv_rw:
	move.l	nu_hdv_rw+xb_next(PC),-(SP)
	rts
;
;------------------------------------
;
.T_596:
	move.b	D0,D_1109
	moveq	#-14,D0
	tst.b	D_1106
	beq.s	.T_5A8
	rts
;
;------------------------------------
;
.T_5A8:
	move.w	D_1108(PC),D0
	add.w	D0,D0
	lea	D_112E(PC),A0
	move.w	0(A0,D0.w),D0
	move.w	D0,D_112C
	move.w	4(SP),D0
	move.l	6(SP),B_56CE
	move.w	10(SP),B_56D2
	move.w	12(SP),B_56D4
	btst	#0,D0
	beq	.T_6C2
.T_5E0:
	lea	B_1252(PC),A0
	move.l	#$00628694,(A0)+
	move.w	D_112C(PC),D0
	addq.w	#6,D0
	move.w	D0,(A0)+
	not.w	D0
	move.w	D0,(A0)+
	clr.l	(A0)+
	move.w	#4,(A0)+
	move.w	D_1108(PC),(A0)+
	move.w	B_56D4,(A0)+
	move.w	#1,(A0)+
	movea.l	B_56CE,A1
	move.l	A1,D0
	btst	#0,D0
	bne.s	.T_642
	move.w	D_112C(PC),D0
	asr.w	#6,D0
	subq.w	#1,D0
.T_61C:
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	move.l	(A1)+,(A0)+
	dbra	D0,.T_61C
	bra.s	.T_66E
;
;------------------------------------
;
.T_642:
	move.w	D_112C(PC),D0
	asr.w	#4,D0
	subq.w	#1,D0
.T_64A:
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	move.b	(A1)+,(A0)+
	dbra	D0,.T_64A
.T_66E:
	lea	B_1252(PC),A0
	bsr	T_7D4
	beq.s	.T_696
	move.b	D_1109(PC),D0
	cmp.b	2(A0),D0
	bne	.T_5E0
	move.w	B_56D4,D0
	cmp.w	4(A0),D0
	bne	.T_5E0
	move.b	3(A0),D0
	beq.s	.T_6A2
.T_696:
	bsr	T_A80
	beq	.T_5E0
	bra	T_79C
;
;------------------------------------
;
.T_6A2:
	moveq	#0,D0
	move.w	D_112C(PC),D0
	add.l	D0,B_56CE
	addq.w	#1,B_56D4
	subq.w	#1,B_56D2
	bne	.T_5E0
	bra	.T_798
;
.T_6C2:
	lea	B_1252(PC),A0
	move.l	#$00628694,(A0)+
	move.w	#6,(A0)+
	move.w	#-$7,(A0)+
	clr.l	(A0)+
	move.w	#6,(A0)+
	move.w	D_1108(PC),(A0)+
	move.w	B_56D4,(A0)+
	move.w	#1,(A0)+
	lea	B_1252(PC),A0
	bsr	T_7D4
	beq.s	.T_70A
	move.b	D_1109(PC),D0
	cmp.b	2(A0),D0
	bne.s	.T_6C2
	move.w	B_56D4,D0
	cmp.w	4(A0),D0
	bne.s	.T_6C2
	move.b	3(A0),D0
	beq.s	.T_714
.T_70A:
	bsr	T_A80
	beq.s	.T_6C2
	bra	T_79C
;
.T_714:
	addq.l	#8,A0
	movea.l	B_56CE,A1
	move.l	A1,D0
	btst	#0,D0
	bne.s	.T_750
	move.w	D_112C(PC),D0
	asr.w	#6,D0
	subq.w	#1,D0
.T_72A:
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	move.l	(A0)+,(A1)+
	dbra	D0,.T_72A
	bra.s	.T_77C
;
;------------------------------------
;
.T_750:
	move.w	D_112C(PC),D0
	asr.w	#4,D0
	subq.w	#1,D0
.T_758:
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	move.b	(A0)+,(A1)+
	dbra	D0,.T_758
.T_77C:
	moveq	#0,D0
	move.w	D_112C(PC),D0
	add.l	D0,B_56CE
	addq.w	#1,B_56D4
	subq.w	#1,B_56D2
	bne	.T_6C2
.T_798:
	moveq	#0,D0
	rts
;
;------------------------------------
;
T_79C:
	ext.l	D0
	rts
;
;----------------------------------------------------------------------------
;
T_7A0:
	move.l	A2,-(SP)
	movea.l	A0,A2
	move.w	4(A2),D0
	bclr	#0,D0
	addq.w	#2,D0
	lea	12(A2),A0
	bsr	calc_crc
	move.l	D0,8(A2)
	moveq	#14,D0
	add.w	4(A2),D0
	bclr	#0,D0
	movea.l	A2,A0
	move.w	D0,-(A2)
	move.l	A0,-(A2)
	move.b	#-$4B,(hw_midicont).w	;enable interrupt
	movea.l	(SP)+,A2
	rts
;
;----------------------------------------------------------------------------
;
T_7D4:
	movem.l	D4-D7,-(SP)
	move.l	A0,D4
	move.w	12(A0),D7
	addq.w	#1,D7
T_7E0:
	clr.w	B_4296
	clr.l	RX_state_time
	clr.l	D_10EA
	movea.l	D4,A0
	bsr.s	T_7A0
	move.l	(_hz_200).w,D6		 ;_hz_200
	add.l	D_1198(PC),D6
T_7FE:
	move.l	(_hz_200).w,D0		 ;_hz_200
	cmp.l	D0,D6
	bls.s	T_83E
	move.l	RX_state_time(PC),D1
	beq.s	T_812
	sub.l	D1,D0
	subq.l	#5,D0
	bge.s	T_7E0
T_812:
	bsr	T_18C
	move.w	B_4296(PC),D5
	beq.s	T_7FE
	lea	B_429C(PC),A0
	cmp.w	(A0),D7
	bne.s	T_7E0
	move.w	D5,D0
	subq.w	#4,D0
	bsr	calc_crc
	cmp.l	B_4298(PC),D0
	bne.s	T_7E0
	lea	B_429C(PC),A0
	move.w	D5,D0
	movem.l	(SP)+,D4-D7
	rts
;
;------------------------------------
;
T_83E:
	moveq	#0,D0
	movem.l	(SP)+,D4-D7
	rts
;
;----------------------------------------------------------------------------
;
	XB_define	nu_midi_vec,'DUET'
	move.b	(hw_midistat).w,D0	;d0 = midi status reg
	bmi.s	.T_85A			;goto .T_85a on midi interrupt
	rts				;else exit
;
;------------------------------------
;
.T_85A:
	btst	#0,D0			;Rx register full ?
	bne.s	RX_midi			;goto RX_midi to RX midi data
	bra	try_TX_midi		;else goto try_TX_midi
;
;----------------------------------------------------------------------------
;
RX_midi:
	movem.l	D0/A0/A2,-(SP)
	lea	(hw_midistat).w,A2	;a2 -> midi status reg
	btst	#0,(A2)			;Rx register full ?
	beq	T_9EA
RX_midi_loop:
	move.l	(_hz_200).w,RX_state_time		 ;_hz_200
	move.b	(hw_mididata).w,D0		 ;midi
	movea.l	RX_state_routine_p(PC),A0
	jmp	(A0)
;
;------------------------------------
;
RXstate_waiting:
	lea	D_10EA(PC),A0
	tst.l	(A0)
	bne.s	.T_89E
	move.l	(_hz_200).w,(A0)		 ;_hz_200
.T_89E:
	tst.b	D0
	bne	reset_RX_state
;					;detected code[0] == 0x00
	move.l	#.T_8BA,RX_state_routine_p
	btst	#0,(A2)
	beq	T_9EA
	move.b	(hw_mididata).w,D0		 ;midi
.T_8BA:
	cmpi.b	#$62,D0
	bne	reset_RX_state
;					;detected code[1] == 0x62
	move.l	#.T_8D8,RX_state_routine_p
	btst	#0,(A2)
	beq	T_9EA
	move.b	(hw_mididata).w,D0		 ;midi
.T_8D8:
	cmpi.b	#$86,D0
	bne	reset_RX_state
;					;detected code[2] == 0x86
	move.l	#.T_8F6,RX_state_routine_p
	btst	#0,(A2)
	beq	T_9EA
	move.b	(hw_mididata).w,D0		 ;midi
.T_8F6:
	cmpi.b	#$94,D0
	bne	reset_RX_state
;					;detected code[3] == 0x94
	move.l	#.T_914,RX_state_routine_p
	btst	#0,(A2)
	beq	T_9EA
	move.b	(hw_mididata).w,D0		 ;midi
.T_914:
	move.b	D0,B_1242		;store arg[0]
	move.l	#.T_930,RX_state_routine_p
	btst	#0,(A2)
	beq	T_9EA
	move.b	(hw_mididata).w,D0		 ;midi
.T_930:
	move.b	D0,B_1243		;store arg[1]
	move.l	#.T_94C,RX_state_routine_p
	btst	#0,(A2)
	beq	T_9EA
	move.b	(hw_mididata).w,D0		 ;midi
.T_94C:
	not.b	D0			;test if arg[2] == ~arg[0]
	cmp.b	B_1242(PC),D0
	bne	reset_RX_state
	move.l	#.T_96C,RX_state_routine_p
	btst	#0,(A2)
	beq	T_9EA
	move.b	(hw_mididata).w,D0		 ;midi
.T_96C:
	not.b	D0			;test if arg[3] == ~arg[1]
	cmp.b	B_1243(PC),D0
	bne	reset_RX_state
	move.w	B_1242(PC),D0		;d0 = arg[0]<<8+arg[1]
	lea	B_3282(PC),A0
	bclr	#0,D0
	beq.s	.T_988
	lea	B_4298(PC),A0
.T_988:
	move.l	A0,B_56C4
	subq.l	#2,A0
	move.l	A0,B_56CA
	addq.w	#6,D0
	move.w	D0,B_56C8
	move.w	D0,B_56C2
	move.l	#.T_9B8,RX_state_routine_p
	btst	#0,(A2)
	beq.s	T_9EA
.T_9B4:
	move.b	(hw_mididata).w,D0		 ;midi
.T_9B8:
	movea.l	B_56C4,A0
	move.b	D0,(A0)+
	move.l	A0,B_56C4
	subq.w	#1,B_56C8
	beq.s	.T_9D4
	btst	#0,(A2)
	bne.s	.T_9B4
	bra.s	T_9EA
;
;------------------------------------
;
.T_9D4:
	clr.l	RX_state_time
	clr.l	D_10EA
	movea.l	B_56CA,A0
	move.w	B_56C2,(A0)
	bra.s	reset_RX_state
;
;------------------------------------
;
T_9EA:
	movem.l	(SP)+,D0/A0/A2
	rts
;
;------------------------------------
;
reset_RX_state:
	move.l	#RXstate_waiting,RX_state_routine_p
	btst	#0,(A2)
	bne	RX_midi_loop
	bra.s	T_9EA
;
;----------------------------------------------------------------------------
;
try_TX_midi:
	movem.l	D0/A0/A1,-(SP)
	btst	#1,(hw_midistat).w	;Tx reg empty ?
	beq.s	.exit			;no => exit
.TX_midi_loop:
	movea.l	D_10E6(PC),A1
.T_A2E:
	move.w	-(A1),D0
	beq.s	.T_A48
	subq.w	#1,D0
	move.w	D0,(A1)
	movea.l	-(A1),A0
	move.b	(A0)+,(hw_mididata).w	 ;midi
	move.l	A0,(A1)
	btst	#1,(hw_midistat).w		 ;midictl
	bne.s	.TX_midi_loop
	bra.s	.exit
;
.T_A48:
	addq.l	#2,A1
	cmpa.l	#B_1252,A1
	bne.s	.T_A58
	lea	B_226C(PC),A1
	bra.s	.T_A5C
;
.T_A58:
	lea	B_1252(PC),A1
.T_A5C:
	move.l	A1,D_10E6
	move.w	B_1250(PC),D0
	or.w	B_226A(PC),D0
	bne.s	.T_A2E
	move.b	#-$6B,(hw_midicont).w	 ;disable interrupt
.exit:
	movem.l	(SP)+,D0/A0/A1
	rts
;
;----------------------------------------------------------------------------
;
nu_etv_critic_code:
	moveq	#-1,D0
	move.w	4(SP),D0
	rts
;
;----------------------------------------------------------------------------
;
T_A80:
	move.w	D_110A(PC),-(SP)
	ext.w	D0
	bmi.s	.T_A8A
	moveq	#-12,D0
.T_A8A:
	move.w	D0,-(SP)
	moveq	#-1,D0
	movea.l	(etv_critic).w,A0
	jsr	(A0)
	move.l	D0,D1
	move.w	D0,(SP)+
	addq.l	#2,SP
	cmp.l	#$10000,D1
	bne.s	.T_AA4
	moveq	#0,D0
.T_AA4:
	tst.w	D0
	rts
;
;----------------------------------------------------------------------------
;
crc_calc_t:
	dc.b	$0,$0,$0,$0,$77,$7,$30,$96,$EE,$E,$61,$2C,$99
	dc.b	$9,$51,$BA,$7,$6D,$C4,$19,$70,$6A,$F4,$8F,$E9
	dc.b	$63,$A5,$35,$9E,$64,$95,$A3,$E,$DB,$88,$32,$79
	dc.b	$DC,$B8,$A4,$E0,$D5,$E9,$1E,$97,$D2,$D9,$88
	dc.b	$9,$B6,$4C,$2B,$7E,$B1,$7C,$BD,$E7,$B8,$2D,$7
	dc.b	$90,$BF,$1D,$91,$1D,$B7,$10,$64,$6A,$B0,$20
	dc.b	$F2,$F3,$B9,$71,$48,$84,$BE,$41,$DE,$1A,$DA
	dc.b	$D4,$7D,$6D,$DD,$E4,$EB,$F4,$D4,$B5,$51,$83
	dc.b	$D3,$85,$C7,$13,$6C,$98,$56,$64,$6B,$A8,$C0
	dc.b	$FD,$62,$F9,$7A,$8A,$65,$C9,$EC,$14,$1,$5C,$4F
	dc.b	$63,$6,$6C,$D9,$FA,$F,$3D,$63,$8D,$8,$D,$F5
	dc.b	$3B,$6E,$20,$C8,$4C,$69,$10,$5E,$D5,$60,$41
	dc.b	$E4,$A2,$67,$71,$72,$3C,$3,$E4,$D1,$4B,$4,$D4
	dc.b	$47,$D2,$D,$85,$FD,$A5,$A,$B5,$6B,$35,$B5,$A8
	dc.b	$FA,$42,$B2,$98,$6C,$DB,$BB,$C9,$D6,$AC,$BC
	dc.b	$F9,$40,$32,$D8,$6C,$E3,$45,$DF,$5C,$75,$DC
	dc.b	$D6,$D,$CF,$AB,$D1,$3D,$59,$26,$D9,$30,$AC,$51
	dc.b	$DE,$0,$3A,$C8,$D7,$51,$80,$BF,$D0,$61,$16,$21
	dc.b	$B4,$F4,$B5,$56,$B3,$C4,$23,$CF,$BA,$95,$99
	dc.b	$B8,$BD,$A5,$F,$28,$2,$B8,$9E,$5F,$5,$88,$8
	dc.b	$C6,$C,$D9,$B2,$B1,$B,$E9,$24,$2F,$6F,$7C,$87
	dc.b	$58,$68,$4C,$11,$C1,$61,$1D,$AB,$B6,$66,$2D
	dc.b	$3D,$76,$DC,$41,$90,$1,$DB,$71,$6,$98,$D2,$20
	dc.b	$BC,$EF,$D5,$10,$2A,$71,$B1,$85,$89,$6,$B6,$B5
	dc.b	$1F,$9F,$BF,$E4,$A5,$E8,$B8,$D4,$33,$78,$7,$C9
	dc.b	$A2,$F,$0,$F9,$34,$96,$9,$A8,$8E,$E1,$E,$98
	dc.b	$18,$7F,$6A,$D,$BB,$8,$6D,$3D,$2D,$91,$64,$6C
	dc.b	$97,$E6,$63,$5C,$1,$6B,$6B,$51,$F4,$1C,$6C,$61
	dc.b	$62,$85,$65,$30,$D8,$F2,$62,$0,$4E,$6C,$6,$95
	dc.b	$ED,$1B,$1,$A5,$7B,$82,$8,$F4,$C1,$F5,$F,$C4
	dc.b	$57,$65,$B0,$D9,$C6,$12,$B7,$E9,$50,$8B,$BE
	dc.b	$B8,$EA,$FC,$B9,$88,$7C,$62,$DD,$1D,$DF,$15
	dc.b	$DA,$2D,$49,$8C,$D3,$7C,$F3,$FB,$D4,$4C,$65
	dc.b	$4D,$B2,$61,$58,$3A,$B5,$51,$CE,$A3,$BC,$0,$74
	dc.b	$D4,$BB,$30,$E2,$4A,$DF,$A5,$41,$3D,$D8,$95
	dc.b	$D7,$A4,$D1,$C4,$6D,$D3,$D6,$F4,$FB,$43,$69
	dc.b	$E9,$6A,$34,$6E,$D9,$FC,$AD,$67,$88,$46,$DA
	dc.b	$60,$B8,$D0,$44,$4,$2D,$73,$33,$3,$1D,$E5,$AA
	dc.b	$A,$4C,$5F,$DD,$D,$7C,$C9,$50,$5,$71,$3C,$27
	dc.b	$2,$41,$AA,$BE,$B,$10,$10,$C9,$C,$20,$86,$57
	dc.b	$68,$B5,$25,$20,$6F,$85,$B3,$B9,$66,$D4,$9,$CE
	dc.b	$61,$E4,$9F,$5E,$DE,$F9,$E,$29,$D9,$C9,$98,$B0
	dc.b	$D0,$98,$22,$C7,$D7,$A8,$B4,$59,$B3,$3D,$17
	dc.b	$2E,$B4,$D,$81,$B7,$BD,$5C,$3B,$C0,$BA,$6C,$AD
	dc.b	$ED,$B8,$83,$20,$9A,$BF,$B3,$B6,$3,$B6,$E2,$C
	dc.b	$74,$B1,$D2,$9A,$EA,$D5,$47,$39,$9D,$D2,$77
	dc.b	$AF,$4,$DB,$26,$15,$73,$DC,$16,$83,$E3,$63,$B
	dc.b	$12,$94,$64,$3B,$84,$D,$6D,$6A,$3E,$7A,$6A,$5A
	dc.b	$A8,$E4,$E,$CF,$B,$93,$9,$FF,$9D,$A,$0,$AE,$27
	dc.b	$7D,$7,$9E,$B1,$F0,$F,$93,$44,$87,$8,$A3,$D2
	dc.b	$1E,$1,$F2,$68,$69,$6,$C2,$FE,$F7,$62,$57,$5D
	dc.b	$80,$65,$67,$CB,$19,$6C,$36,$71,$6E,$6B,$6,$E7
	dc.b	$FE,$D4,$1B,$76,$89,$D3,$2B,$E0,$10,$DA,$7A
	dc.b	$5A,$67,$DD,$4A,$CC,$F9,$B9,$DF,$6F,$8E,$BE
	dc.b	$EF,$F9,$17,$B7,$BE,$43,$60,$B0,$8E,$D5,$D6
	dc.b	$D6,$A3,$E8,$A1,$D1,$93,$7E,$38,$D8,$C2,$C4
	dc.b	$4F,$DF,$F2,$52,$D1,$BB,$67,$F1,$A6,$BC,$57
	dc.b	$67,$3F,$B5,$6,$DD,$48,$B2,$36,$4B,$D8,$D,$2B
	dc.b	$DA,$AF,$A,$1B,$4C,$36,$3,$4A,$F6,$41,$4,$7A
	dc.b	$60,$DF,$60,$EF,$C3,$A8,$67,$DF,$55,$31,$6E
	dc.b	$8E,$EF,$46,$69,$BE,$79,$CB,$61,$B3,$8C,$BC
	dc.b	$66,$83,$1A,$25,$6F,$D2,$A0,$52,$68,$E2,$36
	dc.b	$CC,$C,$77,$95,$BB,$B,$47,$3,$22,$2,$16,$B9
	dc.b	$55,$5,$26,$2F,$C5,$BA,$3B,$BE,$B2,$BD,$B,$28
	dc.b	$2B,$B4,$5A,$92,$5C,$B3,$6A,$4,$C2,$D7,$FF,$A7
	dc.b	$B5,$D0,$CF,$31,$2C,$D9,$9E,$8B,$5B,$DE,$AE
	dc.b	$1D,$9B,$64,$C2,$B0,$EC,$63,$F2,$26,$75,$6A
	dc.b	$A3,$9C,$2,$6D,$93,$A,$9C,$9,$6,$A9,$EB,$E,$36
	dc.b	$3F,$72,$7,$67,$85,$5,$0,$57,$13,$95,$BF,$4A
	dc.b	$82,$E2,$B8,$7A,$14,$7B,$B1,$2B,$AE,$C,$B6,$1B
	dc.b	$38,$92,$D2,$8E,$9B,$E5,$D5,$BE,$D,$7C,$DC,$EF
	dc.b	$B7,$B,$DB,$DF,$21,$86,$D3,$D2,$D4,$F1,$D4,$E2
	dc.b	$42,$68,$DD,$B3,$F8,$1F,$DA,$83,$6E,$81,$BE
	dc.b	$16,$CD,$F6,$B9,$26,$5B,$6F,$B0,$77,$E1,$18
	dc.b	$B7,$47,$77,$88,$8,$5A,$E6,$FF,$F,$6A,$70,$66
	dc.b	$6,$3B,$CA,$11,$1,$B,$5C,$8F,$65,$9E,$FF,$F8
	dc.b	$62,$AE,$69,$61,$6B,$FF,$D3,$16,$6C,$CF,$45
	dc.b	$A0,$A,$E2,$78,$D7,$D,$D2,$EE,$4E,$4,$83,$54
	dc.b	$39,$3,$B3,$C2,$A7,$67,$26,$61,$D0,$60,$16,$F7
	dc.b	$49,$69,$47,$4D,$3E,$6E,$77,$DB,$AE,$D1,$6A
	dc.b	$4A,$D9,$D6,$5A,$DC,$40,$DF,$B,$66,$37,$D8,$3B
	dc.b	$F0,$A9,$BC,$AE,$53,$DE,$BB,$9E,$C5,$47,$B2
	dc.b	$CF,$7F,$30,$B5,$FF,$E9,$BD,$BD,$F2,$1C,$CA
	dc.b	$BA,$C2,$8A,$53,$B3,$93,$30,$24,$B4,$A3,$A6
	dc.b	$BA,$D0,$36,$5,$CD,$D7,$6,$93,$54,$DE,$57,$29
	dc.b	$23,$D9,$67,$BF,$B3,$66,$7A,$2E,$C4,$61,$4A
	dc.b	$B8,$5D,$68,$1B,$2,$2A,$6F,$2B,$94,$B4,$B,$BE
	dc.b	$37,$C3,$C,$8E,$A1,$5A,$5,$DF,$1B,$2D,$2,$EF
	dc.b	$8D
;
;----------------------------------------------------------------------------
;
calc_crc:
	movem.l	D2/D3,-(SP)
	move.w	D0,D3
	moveq	#0,D0
	lea	crc_calc_t(PC),A1
	subq.w	#1,D3
.T_EB6:
	clr.w	D2
	move.b	D0,D2
	move.b	(A0)+,D1
	eor.b	D1,D2
	add.w	D2,D2
	add.w	D2,D2
	move.l	0(A1,D2.w),D1
	clr.b	D0
	ror.l	#8,D0
	eor.l	D1,D0
	dbra	D3,.T_EB6
	movem.l	(SP)+,D2/D3
	rts
;
;------------------------------------
;
;;;Bconmap_func:	;not used for MIDI
	moveq	#0,D0
	rts
;
;----------------------------------------------------------------------------
;
	XB_define	nu_xcostat,'DUET'
	moveq	#-1,D0
	move.w	B_52AC,D1
	cmpi.w	#$400,D1
	bne.s	T_EF6
	moveq	#0,D0
	bra.s	T_F40
;
T_EF6:
	moveq	#-$14,D1
	add.l	(_hz_200).w,D1		 ;_hz_200
	sub.l	D_10FA(PC),D1
	bgt.s	T_F08
	move.l	D_10FE(PC),D0
	bra.s	T_F40
;
T_F08:
	lea	B_1252(PC),A0
	move.l	#$00628694,(A0)+
	clr.w	(A0)+
	move.w	#-$1,(A0)+
	clr.l	(A0)+
	move.w	#10,(A0)+
	lea	B_1252(PC),A0
	bsr	T_7D4
	bne.s	T_F2C
	moveq	#0,D0
	bra.s	T_F32
;
T_F2C:
	move.w	2(A0),D0
	ext.l	D0
T_F32:
	move.l	D0,D_10FE
	move.l	(_hz_200).w,D_10FA		 ;_hz_200
T_F40:
	rts
;
;----------------------------------------------------------------------------
;
	XB_define	nu_xconout,'DUET'
	lea	B_52AE,A0
	move.w	-$2(A0),D0
	cmpi.w	#$400,D0
	bne.s	T_F70
	st	bios_fence_3_f
	bsr.s	T_F84
	clr.b	bios_fence_3_f
	lea	B_52AE,A0
	moveq	#0,D0
T_F70:
	move.b	7(SP),0(A0,D0.w)
	addq.w	#1,D0
	move.w	D0,-(A0)
	move.l	(_hz_200).w,D_10F6		 ;_hz_200
	rts
;
;----------------------------------------------------------------------------
;
T_F84:
	move.l	D7,-(SP)
	move.w	B_52AC,D7
	move.l	(_hz_200).w,D_10F2		 ;_hz_200
T_F92:
	lea	B_1252(PC),A0
	move.l	#$00628694,(A0)+
	move.w	D7,D0
	addq.w	#3,D0
	bclr	#0,D0
	move.w	D0,(A0)+
	not.w	D0
	move.w	D0,(A0)+
	clr.l	(A0)+
	move.w	#8,(A0)+
	move.w	D7,(A0)+
	lea	B_52AE,A1
	move.w	D7,D0
	subq.w	#1,D0
T_FBA:
	move.b	(A1)+,(A0)+
	dbra	D0,T_FBA
	lea	B_1252(PC),A0
	bsr	T_7D4
	beq.s	T_FE0
	tst.w	2(A0)
	beq.s	T_FE8
	move.l	(_hz_200).w,D0		 ;_hz_200
	sub.l	D_10F2(PC),D0
	subi.l	#$BB8,D0
	blt.s	T_F92
T_FE0:
	moveq	#-1,D0
	bsr	T_A80
	beq.s	T_F92
T_FE8:
	clr.w	B_52AC
	move.l	(SP)+,D7
	rts
;
;----------------------------------------------------------------------------
;
T_FF2:
	move.l	SP,B_1246
	xbios	Supexec,T_100A(PC)
	move.w	B_124A(PC),D0
	rts
;
;------------------------------------
;
T_100A:
	move.l	D2,-(SP)
	movea.l	B_1246(PC),A0
	lea	drive_flag_1_t(PC),A1
	move.w	4(A0),D0		;d0.w = arg[0]  drive_spec
	cmpi.w	#MAX_DRIVE,D0
	bhi.s	.error
	move.l	(_drvbits).w,D2		;_drvbits
	move.w	6(A0),D1		;d1.w = arg[1] command
	bmi.s	.T_102C
;					;positive commands
	bset	D0,D2			;set drive bit for bios
	bra.s	.T_103E
;
.T_102C:
;					;negative commands
	addq.w	#1,D1
	beq.s	.T_103C
	addq.w	#1,D1
	bne.s	.error
;					;command -2
	move.b	0(A1,D0.w),D0		;d0 = drive flag
	ext.w	D0
	bra.s	.exit
;
.T_103C:				;command -1
	bclr	D0,D2			;clr drive bit for bios
.T_103E:
	move.l	D2,(_drvbits).w		;store drive bits for bios
	move.b	D1,0(A1,D0.w)		;store drive flag -1 or positive value
	move.w	D1,D0			
	bra.s	.exit
;
.error:					;bad drive# or commands -3..-32768
	moveq	#-1,D0
.exit:
	move.w	D0,B_124A
	move.l	(SP)+,D2
	rts				;exit with d0 = drive_flag/error_code
;
;----------------------------------------------------------------------------
;
change_all_media:
	st	D_1106
	moveq	#MAX_DRIVE,D0
	lea	drive_flag_2_t(PC),A0
T_1062:
	st	(A0)+
	dbra	D0,T_1062
	rts
;
;----------------------------------------------------------------------------
;
T_106A:
	move.w	4(SP),D0
	cmpi.w	#2,D0
	bhi.s	T_107A
	move.b	D0,D_1196
T_107A:
	moveq	#0,D0
	move.b	D_1196(PC),D0
	rts
;
;----------------------------------------------------------------------------
;
T_1082:
	move.l	4(SP),D0
	bmi.s	T_108E
	move.l	D0,D_1198
T_108E:
	move.l	D_1198(PC),D0
	rts
;
;----------------------------------------------------------------------------
;
T_1094:
	move.l	SP,B_1246
	xbios	Supexec,.T_10A8(PC)
	rts
;
;------------------------------------
;
.T_10A8:
	rts
;
;----------------------------------------------------------------------------
;
T_10AA:
	rts
;
;----------------------------------------------------------------------------
;
T_10AC:
	clr.w	B_52AC
	st	bios_fence_1_f
	xbios	Supexec,.T_10C6(PC)
	rts
;
;------------------------------------
;
.T_10C6:
	lea	(xcostat).w,A1		 ;xcostat
	lea	nu_xcostat+xb_next(PC),A2
	bsr	linkup_XBRA
;
	lea	(xconout).w,A1		 ;xconout
	lea	nu_xconout+xb_next(PC),A2
	bsr	linkup_XBRA
	rts
;
;----------------------------------------------------------------------------
;
	make	JAR_links
;
;----------------------------------------------------------------------------
;
	SECTION	DATA
;
;----------------------------------------------------------------------------
;
framesize:	dc.w	6
RX_state_routine_p:	dc.l	RXstate_waiting
D_10E6:	dc.l	B_1252
D_10EA:	dc.b	$0,$0,$0,$0
RX_state_time:	dc.l	0
D_10F2:	dc.b	$0,$0,$0,$0
D_10F6:	dc.b	$0,$0,$0,$0
D_10FA:	dc.b	$0,$0,$0,$0
D_10FE:	dc.b	$0,$0,$0,$0
;
bios_fence_1_f:	dc.b	$0
bios_fence_2_f:	dc.b	$0
bios_fence_3_f:	dc.b	$0,$0
;
D_1106:	dc.b	$1,$0
D_1108:	dc.b	$0
D_1109:	dc.b	$2
D_110A:	dc.b	$0,$0
;
drive_flag_1_t:	dcb.b	MAX_DRIVE+1,-1
		EVEN
drive_flag_2_t:	dcb.b	MAX_DRIVE+1,0
		EVEN
;
D_112C:	dc.w	$200
D_112E:	dcb.w	MAX_DRIVE+1,$200
D_114E:	dc.b	$0
D_114F:	dc.b	$0
D_1150:	dcb.w	MAX_DRIVE+1,$200
;
duet_cookie_t:
	dc.l	'DUET'
	dc.w	$0100
	dc.w	$0002
	dc.w	$0500	;$0500 == MIDI
	dc.l	T_1094
	dc.l	T_FF2
	dc.l	change_all_media
	dc.l	T_106A
	dc.l	T_1082
	dc.l	T_10AA
	dc.l	T_10AC
;
D_1196:	dc.b	$0,$0
;
D_1198:	dc.b	$0,$0,$1,$90
;
;----------------------------------------------------------------------------
;
prog_title_s:
	dc.b	CR,LF
	dc.b	ESC,'p'
	dc.b	' Duet v1.00 (MIDI)          15.05.1994 ',ESC,'q',CR,LF
	dc.b	'  1994 by Andreas Alich',CR,LF
	dc.b	' Revised by URAn            1997.03.27 ',CR,LF
	dc.b	CR,LF,NUL
;
no_creation_s:
	dc.b	BEL,'Creation of DUET cookie failed.',CR,LF
	dc.b	BEL,CR,LF,NUL
;
	EVEN
;
;----------------------------------------------------------------------------
;
	SECTION	BSS
;
;----------------------------------------------------------------------------
;
B_1242:	ds.b	1			 ;=1
B_1243:	ds.b	1			 ;=1
init_error:	ds.w	1			 ;=2
B_1246:	ds.l	1			 ;=4
B_124A:	ds.w	3			 ;=6
B_1250:	ds.w	1			 ;=2
;
B_1252:	ds.l	6
	ds.b	MAX_BUFF		;Sector bufer
	ds.b	SAFE_MARGIN
;
B_226A:	ds.w	1			 ;=2
B_226C:	ds.b	15			 ;=15
B_227B:	ds.b	1			 ;=1
B_227C:	ds.l	1			 ;=4
;
B_2280:
	ds.b	MAX_BUFF		;Sector buffer
	ds.b	SAFE_MARGIN
;
B_3280:	ds.w	1			 ;=2
B_3282:	ds.l	5
	ds.b	MAX_BUFF		;Sector buffer
	ds.b	SAFE_MARGIN
B_4296:	ds.w	1			 ;=2
B_4298:	ds.l	1			 ;=4
;
B_429C:	ds.l	4
	ds.b	MAX_BUFF		;Sector buffer
	ds.b	SAFE_MARGIN
;
B_52AC:	ds.w	1			 ;=2
B_52AE:	ds.l	256			 ;Comms buffer ???
;
B_56AE:	ds.l	5			 ;=20
B_56C2:	ds.w	1			 ;=2
B_56C4:	ds.l	1			 ;=4
B_56C8:	ds.w	1			 ;=2
B_56CA:	ds.l	1			 ;=4
B_56CE:	ds.l	1			 ;=4
B_56D2:	ds.w	1			 ;=2
B_56D4:	ds.w	1			 ;=2
B_56D6:	ds.l	1
	ds.l	128			 ;=516
internal_stk_top:
	ds.l	128			 ;=512
initial_stk_top:
bss_end:
;
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	DUETMIDI.S
;----------------------------------------------------------------------------
