**************************************************************************
*	F030 FASTBoot! v1.0
*	Writes a new bootsector to drive a that bypasses memorytest and
*	the internal IDE-drive.
*	Written by Green Tommy

mshrink:
	move.l	sp,save_sp		;reserve memory
	move.l	4(sp),a0		;& set stack
	move.l	$c(a0),d0
	add.l	$14(a0),d0
	add.l	$1c(a0),d0
	add.l	#$100,d0
	add.l	#100,d0
	move.l	a0,d1
	add.l	d0,d1
	and.l	#-2,d1
	move.l	d1,sp
	move.l	d0,-(sp)
	move.l	a0,-(sp)
	move.w	#0,-(sp)
	move.w	#$4a,-(sp)
	trap	#1
	lea	12(sp),sp
start:
	pea	message
	move.w	#9,-(sp)
	trap	#1
	addq.l	#6,sp
wait:
	move.w	#7,-(sp)
	trap	#1
	addq.l	#2,sp
	cmp.b	#27,d0
	beq	exit
	cmp.b	#'0',d0
	beq	nosec
	cmp.b	#'1',d0
	beq	onesec
	cmp.b	#'2',d0
	beq	twosec
	cmp.b	#'3',d0
	beq	tresec
	cmp.b	#'4',d0
	beq	fyrsec
	cmp.b	#'5',d0
	beq	femsec
	cmp.b	#'6',d0
	beq	sexsec
	cmp.b	#'7',d0
	beq	sjusec
	cmp.b	#'8',d0
	beq	attsec
	cmp.b	#'9',d0
	beq	niosec
	cmp.b	#'*',d0
	beq	nosec
	bra	wait
nosec:
	move.l	#0,delay
	bra	write_boot
onesec:
	move.l	#100,delay
	bra	write_boot
twosec:
	move.l	#200,delay
	bra	write_boot
tresec:
	move.l	#300,delay
	bra	write_boot
fyrsec:
	move.l	#400,delay
	bra	write_boot
femsec:
	move.l	#500,delay
	bra	write_boot
sexsec:
	move.l	#600,delay
	bra	write_boot
sjusec:
	move.l	#700,delay
	bra	write_boot
attsec:
	move.l	#800,delay
	bra	write_boot
niosec:
	move.l	#900,delay
	bra	write_boot
write_boot:
	move.w	#1,-(sp)
	move.w	#0,-(sp)
	move.w	#0,-(sp)
	move.w	#1,-(sp)
	move.w	#0,-(sp)
	clr.l	-(sp)
	pea	buffer
	move.w	#8,-(sp)	;floprd
	trap	#14
	add.l	#20,sp
	tst	d0
	bne	error

	movea.l	#buffer,a0
	movea.l	#boot,a1
	adda.l	#2,a0
	adda.l	#2,a1
	move.l	#27,d5

savebpb:
	move.b	(a0)+,(a1)+
	dbra	d5,savebpb

	move.w	#1,-(sp)
	move.w	#-1,-(sp)
	move.l	#-1,-(sp)
	pea	boot
	move.w	#18,-(sp)	;protbt
	trap	#14
	add.l	#14,sp
 
	move.w	#1,-(sp)
	move.w	#0,-(sp)
	move.w	#0,-(sp)
	move.w	#1,-(sp)
	move.w	#0,-(sp)
	pea	0
	pea	boot
	move.w	#9,-(sp)	;flopwr
	trap	#14
	add.l	#20,sp
	tst	d0
	bne	error
	bra	succesful
exit:
	move.l	save_sp,sp	;restore sp
	clr.w	-(sp)
	trap	#1

error:
	pea	errormsg
	move.w	#9,-(sp)
	trap	#1
	addq.l	#6,sp
errshow:
	move.w	#7,-(sp)
	trap	#1
	addq.l	#2,sp
	cmp.b	#32,d0
	bne.s	errshow

	bra	start
succesful:
	pea	succ_message
	move.w	#9,-(sp)
	trap	#1
	addq.l	#6,sp
sucshow:
	move.w	#7,-(sp)
	trap	#1
	addq.l	#2,sp
	cmp.b	#32,d0
	bne.s	sucshow

	bra	start

errormsg:
	dc.b	27,'E',27,'pAn error has occured, please check the disk in drive A.',27,'q',10,13
	dc.b	'An error happens if your disk is writeprotected, unformatted or faulty.',10,13,10,13
	dc.b	'Press ',27,'p<space>',27,'q when done reading.',10,13
	dc.b	0

succ_message:
	dc.b	27,'E',10,13,10,13,10,13
	dc.b	'              Bootsector written without error.',10,13,10,13
	dc.b	'              Press ',27,'p<space>',27,'q to continue.',10,13
	dc.b	0
message:
	dc.b	27,'E'
	dc.b	'                          ',27,'p'
	dc.b	'Falcon 030 FASTBoot',27,'q  v1.0beta',10,13
	dc.b	'                           (C) Tommy Jonaeson 96-06-05',10,13,10,13
	dc.b	'  This program will place the FaSTBoot bootsector on the disk in drive A:.',10,13,10,13
	dc.b	'For more information regarding the function of the FaSTBoot bootsector,',10,13
	dc.b	'you are adviced to read the accompanying documentation.',10,13
	dc.b	'If the documentation is missing, ask your supplier for it!',10,13,10,13
	dc.b	'                      Press *,0-9 to write boot to drive A',10,13,10,13
	dc.b	'           Press 1-9 to write bootsector with 0.5-5.0 seconds delay.',10,13,10,13
	dc.b	'                          Press ',27,'p<esc>',27,'q to exit program',10,13,10,13
	dc.b	10,13,10,13,10,13,10,13
 	dc.b	'                     FaSTBoot is shareware! Please register!',10,13,10,13
	dc.b	0
	even
save_sp:
	dc.l	0
	even
boot:
	bra.s	starta
	dcb.b	28
starta:
	pea	text(pc)
	move.w	#9,-(sp)
	trap	#1
	addq.l	#6,sp

	movea.l	$5a0.w,a0
	cmpa.l	#0,a0
	beq.s	delaying
jar_test:
	tst.l	(a0)			; is there a Cookie?
	beq.s	delaying		; no? then End of Jar
	cmp.l	#'MagX',(a0)		; is it MAGIC-Cookie?
	beq	exitboot		; found MAGIC Cookie
	addq.l	#8,a0
	bra.s	jar_test		; and the next please ...
delaying:
	move.l	$4ba,d4
	add.l	delay(pc),d4
waitloop:
	cmp.l	$4ba,d4
	ble.s	continuefastboot
	
	move.w	#$ff,-(sp)
	move.w	#$6,-(sp)		;key pressed?
	trap	#1
	addq.l	#4,a7
	tst.l	d0
	beq	waitloop		;cont. countdown
	
continuefastboot:
	cmp.b	#$04,$e00002		;Not necessary
	bne.s	exitboot		;Not necessary
	move.w	#1,$840.w
tos404:
	cmp.w	#$0404,$e00002
	bne.s	tos402
	move.l	#$e00b28,(sp)
	move.l	#$e00794,4(sp)
tos402:
	cmp.w	#$0402,$e00002
	bne.s	tos401
	move.l	#$e00aea,(sp)
	move.l	#$e0078a,4(sp)
tos401:
	cmp.w	#$0401,$e00002
	bne.s	tos400
	move.l	#$e00aea,(sp)
	move.l	#$e0078a,4(sp)
tos400:
	cmp.w	#$0400,$e00002
	bne.s	not400
	move.l	#$e00acc,(sp)
	move.l	#$e0076a,4(sp)
not400:
	rts
exitboot:
	pea	nofastboot(pc)
	move.w	#9,-(sp)
	trap	#1
	addq.l	#6,sp
	rts
delay:
	dc.l	0
text:
	dc.b	27,'E   ',27,'pFalcon030 FASTBoot v1.0',27,'q',10,13
	dc.b	'Copyright 1996 Tommy Jonaeson',10,13
	dc.b	'Unregistered evaluation copy - Please Register!',10,13,10,13,0
nofastboot:
	dc.b	27,'pUnable to FASTBoot - Aborting!',27,'q',10,13,10,13,0
	section bss
	ds.b	300
buffer:
 	ds.b 512
