;File name:	MULTI_ST.S		Revision date:	1992.05.30
;Revised by:	Ulf Ronald Andersson	Disassembled:	1992.05.22
;
;
	include	TOS\URAn_SYS.S
	include TOS\URAn_DOS.S
	include	TOS\URAn_XB.S
;
;
	opt	o+
	opt	a+
;
;
	text
rz:
bp		= rz-$100
stack_size	= $400
;
start:	bra	main
;
kbd_iorec_p	dc.l	0
kbshift_p	dc.l	0
kbdvbase_p	dc.l	0
kbd_comd	dc.w	0
old_tail_ix	dc.w	0
SR_frame_fix	dc.w	0
ret_frame_fix	dc.w	2
arg_frame_fix	dc.w	6
rev_frame_fix	dc.w	2
;
main:
	move.l	4(sp),a0
	move.l	a0,self_bp_p
	move.l	bp_bss_beg_p(a0),d0
	add.l	bp_bss_len(a0),d0
	cmp.l	bp_selfend_p(a0),d0
	bcs.s	main_1
error_Pterm_1:
	gemdos	Pterm0
;
;
main_1:
	move.l	d0,sp
	move.l	d0,self_end_p
	sub.l	a0,d0
	move.l	d0,self_size
	gemdos	Super,!
	move.l	d0,-(sp)
	move.l	self_bp_p(pc),a0
	move.l	bp_selfend_p(a0),d0
	sub.l	self_end_p(pc),d0
	move.l	d0,total_room		;total_room = bp_selfend_p - self_end_p
	move.l	(phystop).w,org_phystop
	lea	task_size_tb(pc),a0
	lea	block_sum_tb(pc),a1
	move	#1,d0			;start loop with x = 1
main_loop_1:
	move.l	org_phystop(pc),d1
	subi.l	#$2000,d1	;d1-> phystop-$2000
	move	#$8000,d2
	mulu	d0,d2		;d2 = x*$8000
	sub.l	d2,d1		;d1-> phystop-$2000-x*$8000
	move	d0,d2
	subq	#1,d2		;d2 = x-1
	move.l	d1,d3
	swap	d3
	mulu	d2,d3		;d3 = (d1/65536)*(x-1)
	swap	d3
	clr	d3		;d3 = (x-1)*(d1 & -65536)
	mulu	d2,d1		;d1*= (x-1)*(d1 % 65536)
	add.l	d3,d1		;d1.L = (phystop-$2000-x*$8000)*(x-1)
	move.l	d1,d2		;d2=p=d1
	clr	d1		;d1=t= d2 & -65536
	swap	d1	;\
	divu	d0,d1	; >d1H=t/x  d1L=t%x
	swap	d1	;/
	move	d1,d3		;d3 = t%x
	swap	d3
	clr	d3		;d3 = (t%x)*65536
	divu	d0,d3		;d3 = (t%x)*65536/x
	move	d3,d1		;d1L = (t%x)*65536/x
;here d1.L = t/x = (p & -65536)/x
	andi.l	#$FFFF,d2
	divu	d0,d2
	andi	#$FFFF,d2	;d2 = (p & 65535)/x
	add.l	d2,d1
;here d1.l = p/x  == (phystop-$2000-x*$8000)*(x-1)/x
	addi.l	#$40,d1
	bclr	#0,d1
	move.l	d1,(a1)+
	move.l	total_room(pc),d2	;d2 = total_room
	sub.l	d1,d2			;d2 -= block_sum
	subi.l	#$2000,d2		;d2 -= $2000
	move	#$8000,d3
	mulu	d0,d3
	sub.l	d3,d2			;d2 -= x*$8000
	cmpi.l	#$10000,d2
	bge.s	LE2			;allow only tasks >= 64KByte
	clr.l	d2
LE2:
	move.l	d2,(a0)+
	addq	#1,d0			;increment x
	cmpi	#9,d0			;x == 9 ?  (too high)
	bne.s	main_loop_1		;loop back for all 8 calc's
	gemdos	Cconws,program_title_s(pc)
	tst.l	task_size_tb+4		;possible to multitask ?
	bne.s	main_2
	gemdos	Cconws,too_small_RAM_s(pc)
	gemdos	Crawcin
	bra	error_exit_2
;
main_2:
	bsr	check_vectors
	lea	XBRA_error_s(pc),a0
	bne	show_error_a0_exit
	lea	tasks_prompt_1_s(pc),a0
	bsr	Cconws_a0_sub
	move.l	task_size_tb(pc),d0
	lsr.l	#5,d0
	lsr.l	#5,d0			;d0 = size/task in KB
	bsr	show_dec_d0_word
	lea	sp_KB_s(pc),a0
	bsr	Cconws_a0_sub
	gemdos	Cconout,#')'
	lea	cr_lf_s(pc),a0
	bsr	Cconws_a0_sub
	move	#2,d0
	lea	task_size_tb+4(pc),a0
main_loop_2:
	move.l	(a0)+,d1
	beq.s	L19C
	movem.l	d0/a0,-(sp)
	move.l	d1,-(sp)
	lea	tasks_prompt_2_s(pc),a0
	bsr	Cconws_a0_sub
	move.l	4(sp),d0
	addi	#'0',d0
	gemdos	Cconout,d0
	lea	tasks_prompt_3_s(pc),a0
	bsr	Cconws_a0_sub
	move.l	(sp)+,d0
	lsr.l	#5,d0
	lsr.l	#5,d0
	bsr	show_dec_d0_word
	lea	sp_KB_s(pc),a0
	bsr	Cconws_a0_sub
	lea	cr_lf_s(pc),a0
	bsr	Cconws_a0_sub
	movem.l	(sp)+,d0/a0
L19C:
	addq	#1,d0
	cmpi	#9,d0
	bne.s	main_loop_2
	lea	tasks_query_s(pc),a0
	bsr	Cconws_a0_sub
main_loop_3:
	gemdos	Crawcin
	cmpi.b	#'1',d0
	bcs.s	main_loop_3
	cmpi	#'9',d0
	bcc.s	main_loop_3
	move.b	d0,d1
	subi.b	#'1',d1
	ext.w	d1
	asl.w	#2,d1
	lea	task_size_tb(pc),a0
	tst.l	0(a0,d1.w)		;legal task ?  (size != 0)
	beq.s	main_loop_3
	move	d0,-(sp)
	move	#$ff&Cconout,-(sp)
	trap	#1
	addq.l	#2,sp
	move	(sp)+,d0
	subi.b	#'1',d0
	ext.w	d0
	move	d0,tasks_used_m1
	tst	tasks_used_m1
	beq.s	single_task_exit
	lea	instructions_1_s(pc),a0
	bsr.s	Cconws_a0_sub
	move	tasks_used_m1(pc),-(sp)
	addi	#'1',(sp)
	gemdos	Cconout,()
	lea	instructions_2_s(pc),a0
	bsr.s	Cconws_a0_sub
	gemdos	Crawcin
	lea	hide_cur_CLS_s(pc),a0
	bsr.s	Cconws_a0_sub
	bra.s	main_3
;
error_exit_2:
single_task_exit:
	gemdos	Super,()
error_Pterm_2:
	gemdos	Pterm0
;
;
show_dec_d0_word:
	lea	dec_string_end(pc),a0
	clr.b	-(a0)
	tst	d0
	bne.s	L244
	move.b	#'0',-(a0)
	bra.s	L25C
;
L244:
	andi.l	#$FFFF,d0
	divu	#10,d0
	move.l	d0,d1
	swap	d1
	addi.b	#'0',d1
	move.b	d1,-(a0)
	tst	d0
	bne.s	L244
L25C:
	gemdos	Cconws,(a0)
	rts
;
;
Cconws_a0_sub:
	gemdos	Cconws,(a0)
	rts
;
;
main_3:	;here more than 1 task has been requested
	move	tasks_used_m1(pc),d0
	move	d0,d1
	asl	#2,d1
	lea	block_sum_tb(pc),a0
	move.l	0(a0,d1.w),d1		;d1 = summed size of tasks
	add.l	self_size(pc),d1	;d1 += selfsize
	addi.l	#$100,d1		;d1 += $100
	move	d0,d2
	addq	#1,d2
	move	#$8000,d3
	mulu	d2,d3
	add.l	d3,d1			;d1 += tasks_used * $8000
	addi.l	#$2000,d1		;d1 += $2000
	move.l	d1,resident_size	;resident_size = d1
	move.l	self_bp_p(pc),a0
	gemdos	Mshrink,!,(a0),d1
	tst.l	d0
	beq.s	main_4
	lea	RAM_error_s(pc),a0
show_error_a0_exit:
	bsr.s	Cconws_a0_sub
	lea	end_error_s(pc),a0
	bsr.s	Cconws_a0_sub
	gemdos	Crawcin
	gemdos	Super,()
error_Pterm_3:
	gemdos	Pterm0
;
main_4:
	move.l	self_end_p(pc),d0
	addi.l	#$100,d0
	andi.l	#$FFFFFF00,d0
	move.l	d0,screen_base_p
	move	tasks_used_m1(pc),d1
	addq	#1,d1
	move	#$8000,d2
	mulu	d1,d2
	add.l	d2,d0
	move.l	d0,LE4C
	lea	block_sum_tb(pc),a0
	move	tasks_used_m1(pc),d1
	asl.w	#2,d1
	add.l	0(a0,d1.w),d0
	move.l	d0,LE54
	move.l	d0,LEB2
	addi.l	#$20,d0
	move.l	d0,active_task_ftb_p
	addq.l	#8,d0
	move.l	d0,old_task_index_p
	addq.l	#2,d0
	move.l	d0,LEBE
	addq.l	#2,d0
	move.l	d0,LEC2
	addq.l	#2,d0
	move.l	d0,disp_task_index_p
	addq.l	#2,d0
	move.l	d0,back_task_index_p
	addq.l	#2,d0
	addi.l	#$80,d0
	move.l	d0,LECE
	move.l	d0,LEDA
	addq.l	#2,d0
	move.l	d0,cmd_alt_ctl_sh_p
	addq.l	#2,d0
	move.l	d0,cmd_key_1_10_p
	addq.l	#2,d0
	move.l	d0,new_task_index_p
	addq.l	#2,d0
	move.l	d0,LF14
	addq.l	#2,d0
	move.l	d0,cmd_delay_p
	addq.l	#2,d0
	move.l	d0,cmd_timer_p
	addq.l	#2,d0
	move.l	d0,back_off_flag_p
	addq.l	#2,d0
	move.l	d0,back_off_ftb_p
	addq.l	#8,d0
	move.l	d0,auto_on_flag_p
	addq.l	#2,d0
	move.l	org_phystop(pc),d0
	move	tasks_used_m1(pc),d1
	asl.w	#2,d1
	lea	block_sum_tb(pc),a0
	sub.l	0(a0,d1.w),d0
	subi.l	#$2000,d0
	subi.l	#8,d0
	move	tasks_used_m1(pc),d2
	addq	#1,d2
	move	#$8000,d3
	mulu	d2,d3
	sub.l	d3,d0
	move.l	d0,LEA6
	move.l	LE4C(pc),d0
	add.l	0(a0,d1.w),d0
	addi.l	#$2000,d0
	move.l	d0,LEAA
	move.l	#temp_stack_top,temp_stack_sp
	bsr	init_ikbd_vec
	bsr	init_vectors
	movem.l	d0-d7/a0-a7,sav_regs
	move	USP,a0
	move.l	a0,sav_USP
	move	SR,sav_SR
	move.l	#boot_reentry,swap_task_return_p
	lea	($ffffff&hw_pal).l,a0
	lea	task_pal(pc),a1
	move	#$F,d0
main_loop_4:
	move	(a0)+,(a1)+
	dbra	d0,main_loop_4
	move	($ffffff&hw_rez).l,task_rez
	move	SR,-(sp)
	or	#$700,SR
	move.l	#8,a0
	move.l	LE4C(pc),a1
	move.l	screen_base_p(pc),d0
	subi.l	#8,d0
	move.l	d0,d1
main_loop_5:
	move.b	(a0)+,(a1)+
	subq.l	#1,d0
	bne.s	main_loop_5
	move.l	LEAA(pc),a0
	move.l	LEA6(pc),d0
	sub.l	d1,d0
main_loop_6:
	move.b	(a0)+,(a1)+
	subq.l	#1,d0
	bne.s	main_loop_6
	move	tasks_used_m1(pc),d1
	move.l	LE4C(pc),a1
main_loop_7:
	subq	#1,d1
	beq.s	main_loop_7_exit
	move.l	LE4C(pc),a0
	move.l	LEA6(pc),d0
	adda.l	d0,a1
	movem.l	d0-d0/a0-a1,-(sp)
main_loop_8:
	move.b	(a0)+,(a1)+
	subq.l	#1,d0
	bne.s	main_loop_8
	movem.l	(sp)+,d0-d0/a0-a1
	bra.s	main_loop_7
;
main_loop_7_exit:
	move	(sp)+,SR
	move.l	LEB2(pc),a0
	clr.l	(a0)+
	move	#7,d0
	move.l	LE4C(pc),d2
	move	tasks_used_m1(pc),d1
main_loop_9:
	tst	d1
	beq.s	main_loop_10
	move.l	d2,(a0)+
	add.l	LEA6(pc),d2
	subq	#1,d1
	subq	#1,d0
	bra.s	main_loop_9
;
main_loop_10:
	tst	d0
	beq.s	main_loop_10_exit
	move.l	#-1,(a0)+
	subq	#1,d0
	bra.s	main_loop_10
;
main_loop_10_exit:
	move.l	active_task_ftb_p(pc),a0
	clr.l	(a0)
	clr.l	4(a0)
	move.l	old_task_index_p(pc),a0
	clr	(a0)
	move.l	disp_task_index_p(pc),a0
	clr	(a0)
	move.l	back_task_index_p(pc),a0
	clr	(a0)
	move.l	LEBE(pc),a0
	move	#$190,(a0)
	move.l	LEC2(pc),a0
	move	#$19,(a0)
	move.l	new_task_index_p(pc),a0
	move	#-1,(a0)
	move.l	LF14(pc),a0
	move	#1,(a0)
	move.l	cmd_delay_p(pc),a0
	clr	(a0)
	move.l	cmd_timer_p(pc),a0
	clr	(a0)
	move.l	back_off_flag_p(pc),a0
	clr	(a0)
	move.l	auto_on_flag_p(pc),a0
	clr	(a0)
boot_reentry:
	XB_install	nu_VBI,(ev_vbi).w
	move.l	(_v_bas_ad).w,a0
	move.l	old_task_index_p(pc),a1
	move	(a1),d0
	mulu	#$8000,d0
	add.l	screen_base_p(pc),d0
	move.l	d0,a1
	move.l	d0,(_v_bas_ad).w
	move	#$1F3F,d0
main_loop_11:
	move.l	(a0)+,(a1)+
	dbra	d0,main_loop_11
	move.l	old_task_index_p(pc),a0
	move.l	disp_task_index_p(pc),a1
	cmpm	(a0)+,(a1)+
	bne.s	L572
	move.b	(_v_bas_ad+1).w,($ffffff&hw_vbase2).l
	move.b	(_v_bas_ad+2).w,($ffffff&hw_vbase1).l
L572:
	move.b	(_v_bas_ad+1).w,task_vbase2
	move.b	(_v_bas_ad+2).w,task_vbase1
	gemdos	Super,()
	gemdos	Ptermres,resident_size(pc),!
;
;
	XB_define	nu_VBI,'MuST'
nu_VBI_code:
	move.l	a0,-(sp)
	move.l	cmd_timer_p(pc),a0
	tst	(a0)
	beq.s	.L5AA
	subq	#1,(a0)
	bne.s	.L5AA
	move.l	cmd_delay_p(pc),a0
	subq	#1,(a0)
.L5AA:
	move.l	cmd_delay_p(pc),a0
	tst	(a0)
	bne.s	.L5C8
	tst	kbd_comd
	beq.s	.L5C8
	movem.l	d0-d7/a1-a6,-(sp)
	bsr	execute_cmd
	movem.l	(sp)+,d0-d7/a1-a6
	bcs.s	.L5D8
.L5C8:
	move.l	LEBE(pc),a0
	subq	#1,(a0)
	bne.s	.exit
.L5D8:
	move.l	cmd_delay_p(pc),a0
	tst	(a0)
	beq.s	L5EA
	move.l	LEBE(pc),a0
	move	#1,(a0)
.exit:
	move.l	(sp)+,a0
nu_VBI_exit:
	XB_gonext_d	nu_VBI
;
L5EA:
	move.l	LEC2(pc),a0
	move	(a0),-(sp)
	move.l	LEBE(pc),a0
	move	(sp)+,(a0)
	move.l	(sp)+,a0
	movem.l	d0-d7/a0-a7,sav_regs
	move	USP,a0
	move.l	a0,sav_USP
	move	SR,sav_SR
	move.l	#nu_VBI_exit,swap_task_return_p
	or	#$700,SR
	move.l	old_task_index_p(pc),a0
	move.l	disp_task_index_p(pc),a1
	cmpm	(a0)+,(a1)+
	bne.s	keep_video_soft
	lea	($ffffff&hw_pal).l,a0
	lea	task_pal(pc),a1
	move	#16-1,d0
L636:
	move	(a0)+,(a1)+
	dbra	d0,L636
	move	($ffffff&hw_rez).l,task_rez
	move.b	($ffffff&hw_vbase2).l,task_vbase2
	move.b	($ffffff&hw_vbase1).l,task_vbase1
keep_video_soft:
	bsr	block_ikbd
	move.l	auto_on_flag_p(pc),a0
	tst	(a0)
	beq.s	skip_auto
	move.l	disp_task_index_p(pc),a0
	move	(a0),d0
	move	d0,d1
	move.l	active_task_ftb_p(pc),a1
L672:
	addq	#1,d0
	cmpi	#8,d0
	bne.s	L67C
	clr	d0
L67C:
	cmp	d1,d0
	beq.s	skip_auto
	tst.b	0(a1,d0.w)
	beq.s	L672
	bsr	block_ikbd_setindex_d0
skip_auto:
	move.l	old_task_index_p(pc),a0
	move	(a0),d0
	move.l	new_task_index_p(pc),a1
	move	(a1),d1
	bpl.s	skip_background
	move.l	disp_task_index_p(pc),a1
	cmpi	#-1,(a1)
	beq.s	try_background
	cmp	(a1),d0
	beq.s	try_background
	move	(a1),d1
	bra.s	skip_background
;
try_background:
	move.l	back_task_index_p(pc),a2
	move	(a2),d1
	move.l	active_task_ftb_p(pc),a1
	clr	d2
L6B6:
	addq	#1,d1
	cmpi	#8,d1
	bne.s	L6C0
	clr	d1
L6C0:
	cmp	d1,d0
	bne.s	L6CC
	tst	d2
	bne.s	skip_background
	not	d2
	bra.s	L6B6
;
L6CC:
	tst.b	0(a1,d1.w)
	beq.s	L6B6
	move	d1,(a2)
skip_background:
	cmp	d0,d1
	beq.s	keep_same_RAM
	move	d1,(a0)
	move.l	LEB2(pc),a2
	move	d0,d2
	move	d1,d3
	asl.w	#2,d2
	asl.w	#2,d3
	move.l	0(a2,d3.w),a1
	move.l	a1,0(a2,d2.w)
	clr.l	0(a2,d3.w)
	move.l	#8,a0
	move.l	LEA6(pc),d0
	move.l	sp,a2
	move.l	LECE(pc),sp
	move.l	a2,-(sp)
	movem.l	d0/a0-a1,-(sp)
	move.l	screen_base_p(pc),d0
	sub.l	a0,d0
	move.l	d0,-(sp)
	bsr.s	swap_RAM_sub
	move.l	(sp)+,d1
	movem.l	(sp)+,d0/a0-a1
	sub.l	d1,d0
	move.l	LEAA(pc),a0
	adda.l	d1,a1
	bsr.s	swap_RAM_sub
keep_same_RAM:
	move.l	new_task_index_p(pc),a0
	tst	(a0)
	bmi.s	keep_video_hard
	move.l	disp_task_index_p(pc),a1
	move	(a0),(a1)
	move	#-1,(a0)
	move.b	task_vbase2(pc),($ffffff&hw_vbase2).l
	move.b	task_vbase1(pc),($ffffff&hw_vbase1).l
	lea	($ffffff&hw_pal).l,a0
	lea	task_pal(pc),a1
	move	#$F,d0
L756:
	move	(a1)+,(a0)+
	dbra	d0,L756
	move	task_rez(pc),($ffffff&hw_rez).l
keep_video_hard:
	move.l	disp_task_index_p(pc),a0
	move	(a0),d0
	move.l	old_task_index_p(pc),a0
	cmp	(a0),d0
	bne.s	L776
	bsr	release_ikbd
L776:
	move.l	(sp)+,sp
	move.l	sav_USP(pc),a0
	move	a0,USP
	movem.l	sav_regs(pc),d0-d7/a0-a7
	move	sav_SR(pc),SR
	move.l	swap_task_return_p(pc),-(sp)
	rts
;
;
swap_RAM_sub:
	divu	#$180,d0
	beq	L8B2
	subq	#1,d0
L79E:
	movem.l	(a0),d1-d7/a2-a6
	rept	12
	move.l	(a1)+,(a0)+
	endr
	movem.l	d1-d7/a2-a6,-48(a1)
	movem.l	(a0),d1-d7/a2-a6
	rept	12
	move.l	(a1)+,(a0)+
	endr
	movem.l	d1-d7/a2-a6,-48(a1)
	movem.l	(a0),d1-d7/a2-a6
	rept	12
	move.l	(a1)+,(a0)+
	endr
	movem.l	d1-d7/a2-a6,-48(a1)
	movem.l	(a0),d1-d7/a2-a6
	rept	12
	move.l	(a1)+,(a0)+
	endr
	movem.l	d1-d7/a2-a6,-48(a1)
	movem.l	(a0),d1-d7/a2-a6
	rept	12
	move.l	(a1)+,(a0)+
	endr
	movem.l	d1-d7/a2-a6,-48(a1)
	movem.l	(a0),d1-d7/a2-a6
	rept	12
	move.l	(a1)+,(a0)+
	endr
	movem.l	d1-d7/a2-a6,-48(a1)
	movem.l	(a0),d1-d7/a2-a6
	rept	12
	move.l	(a1)+,(a0)+
	endr
	movem.l	d1-d7/a2-a6,-48(a1)
	movem.l	(a0),d1-d7/a2-a6
	rept	12
	move.l	(a1)+,(a0)+
	endr
	movem.l	d1-d7/a2-a6,-48(a1)
	dbra	d0,L79E
L8B2:
	swap	d0
	move	d0,d1
	lsr.w	#4,d1
	beq.s	L8D8
	subq	#1,d1
L8BC:
	move.l	(a0),d2
	move.l	(a1),(a0)+
	move.l	d2,(a1)+
	move.l	(a0),d2
	move.l	(a1),(a0)+
	move.l	d2,(a1)+
	move.l	(a0),d2
	move.l	(a1),(a0)+
	move.l	d2,(a1)+
	move.l	(a0),d2
	move.l	(a1),(a0)+
	move.l	d2,(a1)+
	dbra	d1,L8BC
L8D8:
	andi	#$F,d0
	beq.s	L8EA
	subq	#1,d0
L8E0:
	move.b	(a0),d1
	move.b	(a1),(a0)+
	move.b	d1,(a1)+
	dbra	d0,L8E0
L8EA:
	rts
;
;
init_ikbd_vec:
	xbios	Iorec,#1
	lea	kbd_iorec_p(pc),a0
	move.l	d0,(a0)
	move.l	d0,a0
	move	io_tail_ix(a0),old_tail_ix
	move.l	(_sysbase).w,a0
	move.l	os_selfbeg_p(a0),a0
	move.l	os_kbshift_p(a0),d0	;->kbshift variable in modern TOS >= 1.4
	cmp	#$0104,os_version(a0)	;check OS version
	bhs.s	insta_OS		;if modern TOS goto insta_OS
;					;else init kbshift_p, valid for TOS <= TOS 1.04
	xbios	Keytbl|_IND,?,?,?
	subq.l	#1,d0		;NB: this assumes Kbshift stored at Keytbl-1
;				;NB: So in all early TOS Kbshift data lies at Keytbl-1 !!!
insta_OS:
	move.l	d0,kbshift_p		; Store kbshift variable ptr
	xbios	Kbdvbase
	move.l	d0,kbdvbase_p
	move.l	d0,a0
	XB_install	nu_ikbd_vec,32(a0)
	rts
;
;
	XB_define	nu_ikbd_vec,'MuST'
nu_ikbd_vec_code:
	XB_donext_d	nu_ikbd_vec(pc)
MuSTcode:
	move	SR,-(sp)
	move.l	kbd_iorec_p(pc),a0
	move	io_tail_ix(a0),d1
	cmp	old_tail_ix(pc),d1
	beq	.return
	or	#$0700,SR
	move	io_tail_ix(a0),d1
	move	d1,old_tail_ix
	cmp	io_head_ix(a0),d1
	beq.s	.return
	move.l	kbshift_p(pc),a1
	move.b	(a1),d2			;New! get kbshifts (** TOS independent **)
	move.l	io_buffer_p(a0),a2	;get address of io-buffer
	move	(a2,d1),d0		;get 1'st word for this key = key code
	and	#$7F,d0			;mask key code
	cmp	#$44,d0
	bhi.s	.return			;no keys above F10 !
	sub	#$3B,d0
	blo.s	.return			;no keys below F1 !
	cmp	#8,d0
	bhs.s	.test_flags		;accept F9,F10 preliminary
	cmp	tasks_used_m1(pc),d0
	bhi.s	.return			;no keys for nonexistent tasks
.test_flags:
	move.b	d2,d3
	and	#1,d3
	lsr.b	#1,d2
	or	d3,d2
	and	#07,d2
	lsl	#3,d0
	or	d2,d0			;here d0=10*8 possible Fx-ALT-CTRL-SHIFT variants
	lea	command_flag_tb(pc),a1
	tst.b	(a1,d0)
	beq.s	.return
	move	d0,kbd_comd
	subq	#4,d1
	bge.s	.tail_shrunk
	move	io_size_ix(a0),d1
	subq	#4,d1
.tail_shrunk:
	move	d1,io_tail_ix(a0)
	move	d1,old_tail_ix
	move.l	cmd_timer_p(pc),a0
	tst	(a0)
	beq.s	.exit
	move	#1,(a0)
	bra.s	.exit
;
.return:
	move	#$8C,d1
	move.l	cmd_timer_p(pc),a0
	tst	(a0)
	bne.s	.LA80
	move.l	cmd_delay_p(pc),a1
	addq	#1,(a1)
.LA80:
	cmp	(a0),d1
	bls.s	.exit
	move	d1,(a0)
.exit:
	move	(sp)+,SR
	rts
;
;
command_flag_tb:
	dc.b	0,0,0,0,1,0,0,0		;F1
	dc.b	0,0,0,0,1,0,0,0		;F2
	dc.b	0,0,0,0,1,0,0,0		;F3
	dc.b	0,0,0,0,1,0,0,0		;F4
	dc.b	0,0,0,0,1,0,0,0		;F5
	dc.b	0,0,0,0,1,0,0,0		;F6
	dc.b	0,0,0,0,1,0,0,0		;F7
	dc.b	0,0,0,0,1,0,0,0		;F8
	dc.b	0,0,0,0,1,1,0,0		;F9
	dc.b	1,0,0,0,1,1,1,0		;F10
;
;
command_sub_tb:
	dc.l	cmd_0,cmd_0,cmd_0,cmd_0,F1_cmd_A,cmd_0,cmd_0,cmd_0			;F1
	dc.l	cmd_0,cmd_0,cmd_0,cmd_0,F2_cmd_A,cmd_0,cmd_0,cmd_0			;F2
	dc.l	cmd_0,cmd_0,cmd_0,cmd_0,F3_cmd_A,cmd_0,cmd_0,cmd_0			;F3
	dc.l	cmd_0,cmd_0,cmd_0,cmd_0,F4_cmd_A,cmd_0,cmd_0,cmd_0			;F4
	dc.l	cmd_0,cmd_0,cmd_0,cmd_0,F5_cmd_A,cmd_0,cmd_0,cmd_0			;F5
	dc.l	cmd_0,cmd_0,cmd_0,cmd_0,F6_cmd_A,cmd_0,cmd_0,cmd_0			;F6
	dc.l	cmd_0,cmd_0,cmd_0,cmd_0,F7_cmd_A,cmd_0,cmd_0,cmd_0			;F7
	dc.l	cmd_0,cmd_0,cmd_0,cmd_0,F8_cmd_A,cmd_0,cmd_0,cmd_0			;F8
	dc.l	cmd_0,cmd_0,cmd_0,cmd_0,F9_cmd_A,F9_cmd_AS,cmd_0,cmd_0			;F9
	dc.l	F10_cmd,cmd_0,cmd_0,cmd_0,F10_cmd_A,F10_cmd_AS,F10_cmd_AC,cmd_0		;F10
;
;
dumb_func:	
	cmp	#9*8,kbd_comd	;;;	cmp.b	#$A,(a1)
	blo	cmd_0		;;;	bne	cmd_0
F10_cmd_x:
	clr	(a0)
	clr	kbd_comd
	move.l	LEC2(pc),a0
	move	#25,(a0)
	move.l	LEBE(pc),a0
	move	#25,(a0)
	bra	cmd_0
;
execute_cmd:
	move.l	auto_on_flag_p(pc),a0
	tst	(a0)
	bne.s	dumb_func
	lea	command_sub_tb(pc),a0
	move	kbd_comd(pc),d0
	clr	kbd_comd
	lsl	#2,d0
	move.l	(a0,d0),-(sp)
	rts
;
F1_cmd_A:
	moveq	#0,d0
	bra.s	Flo_cmd_A
;	
F2_cmd_A:
	moveq	#1,d0
	bra.s	Flo_cmd_A
;	
F3_cmd_A:
	moveq	#2,d0
	bra.s	Flo_cmd_A
;	
F4_cmd_A:
	moveq	#3,d0
	bra.s	Flo_cmd_A
;	
F5_cmd_A:
	moveq	#4,d0
	bra.s	Flo_cmd_A
;	
F6_cmd_A:
	moveq	#5,d0
	bra.s	Flo_cmd_A
;	
F7_cmd_A:
	moveq	#6,d0
	bra.s	Flo_cmd_A
;	
F8_cmd_A:
	moveq	#7,d0
Flo_cmd_A:
	move.l	disp_task_index_p(pc),a0
	cmp	(a0),d0
	beq.s	cmd_0
	bsr.s	block_ikbd_setindex_d0
	move	#1,CCR
	rts
;
F9_cmd_A:
	move.l	disp_task_index_p(pc),a0
	move	(a0),d0
	move.l	active_task_ftb_p(pc),a0
	move.b	#1,0(a0,d0.w)
	move.l	back_off_flag_p(pc),a0
	clr	(a0)
	bra.s	cmd_0
;
F9_cmd_AS:
	move.l	disp_task_index_p(pc),a0
	move	(a0),d0
	move.l	active_task_ftb_p(pc),a0
	clr.b	0(a0,d0.w)
	bra.s	cmd_0
;
F10_cmd_A:
	move.l	back_off_flag_p(pc),a0
	tst	(a0)
	bne.s	cmd_0
	move	#1,(a0)
	move.l	active_task_ftb_p(pc),a0
	move.l	back_off_ftb_p(pc),a1
	move.l	(a0),(a1)
	move.l	4(a0),4(a1)
	clr.l	(a0)+
	clr.l	(a0)
	bra.s	cmd_0
;
F10_cmd_AS:
	move.l	back_off_flag_p(pc),a0
	tst	(a0)
	beq.s	cmd_0
	clr	(a0)
	move.l	back_off_ftb_p(pc),a0
	move.l	active_task_ftb_p(pc),a1
	move.l	(a0)+,(a1)+
	move.l	(a0),(a1)
	bra.s	cmd_0
;
F10_cmd_AC:
	move.l	auto_on_flag_p(pc),a0
	move	#1,(a0)
	move.l	LEC2(pc),a0
	move	#$2BC,(a0)
F10_cmd:
cmd_0:
	tst	d0	;clear carry
	rts
;
;
block_ikbd_setindex_d0:
	move	d0,-(sp)
	bsr.s	block_ikbd
	move	(sp)+,d0
	move.l	new_task_index_p(pc),a0
	move	d0,(a0)
	rts
;
;
block_ikbd:
	move.l	LF14(pc),a0
	tst	(a0)
	beq.s	LBDA
	clr	(a0)
LBBE:
	btst	#1,($ffffff&hw_kbstat).l
	beq.s	LBBE
	move.b	#19,($ffffff&hw_kbdata).l
LBD0:
	btst	#1,($ffffff&hw_kbstat).l
	beq.s	LBD0
LBDA:
	rts
;
;
release_ikbd:
	move.l	LF14(pc),a0
	tst	(a0)
	bne.s	LC04
	move	#1,(a0)
LBE8:
	btst	#1,($ffffff&hw_kbstat).l
	beq.s	LBE8
	move.b	#17,($ffffff&hw_kbdata).l
LBFA:
	btst	#1,($ffffff&hw_kbstat).l
	beq.s	LBFA
LC04:
	rts
;
;
check_vectors:
	XB_check	nu_VBI,(ev_VBI).w
	bne.s		.not_again
	XB_check	nu_bios,(ev_bios).w
	bne.s		.not_again
	XB_check	nu_xbios,(ev_xbios).w
	bne.s		.not_again
	XB_check	nu_gemdos,(ev_gemdos).w
.not_again:
	rts
;
;
init_vectors:
	tst	(_longframe).w
	sne	d0
	and	#2,d0
	move	d0,SR_frame_fix
	addq	#2,d0
	move	d0,ret_frame_fix
	addq	#4,d0
	move	d0,arg_frame_fix
	moveq	#2,d0
	sub	SR_frame_fix(pc),d0
	move	d0,rev_frame_fix
	XB_install	nu_gemdos,(ev_gemdos).w
	XB_install	nu_bios,(ev_bios).w
	XB_install	nu_xbios,(ev_xbios).w
	rts
;
;
	XB_define	nu_gemdos,'MuST'
nu_gemdos_code:
	sub	rev_frame_fix(pc),sp
	move	8(sp),d0
	btst	#5,2(sp)
	bne.s	.gotarg
	move	USP,a0
	move	(a0),d0
.gotarg:
	lea	gemdos_op_tb(pc),a0
	cmp	(a0)+,d0
	bhi.s	.exit
	tst.b	(a0,d0)
	beq.s	.exit
	move.l	cmd_delay_p(pc),a0
	addq	#1,(a0)
	move.l	temp_stack_sp(pc),a0
	move.l	4(sp),-(a0)
	move.l	a0,temp_stack_sp
	move.l	#post_fix_TOS_call,4(sp)
.exit:
	add	rev_frame_fix(pc),sp
	XB_gonext_d	nu_gemdos
;
;
	XB_define	nu_bios,'MuST'
nu_bios_code:
	sub	rev_frame_fix(pc),sp
	move	8(sp),d0
	btst	#5,2(sp)
	bne.s	.gotarg
	move	USP,a0
	move	(a0),d0
.gotarg:
	lea	bios_op_tb(pc),a0
	cmp	(a0)+,d0
	bhi.s	.exit
	tst.b	(a0,d0)
	beq.s	.exit
	move.l	cmd_delay_p(pc),a0
	addq	#1,(a0)
	move.l	temp_stack_sp(pc),a0
	move.l	4(sp),-(a0)
	move.l	a0,temp_stack_sp
	move.l	#post_fix_TOS_call,4(sp)
.exit:
	add	rev_frame_fix(pc),sp
	XB_gonext_d	nu_bios
;
;
	XB_define	nu_xbios,'MuST'
nu_xbios_code:
	sub	rev_frame_fix(pc),sp
	move	8(sp),d0
	btst	#5,2(sp)
	bne.s	.gotarg
	move	USP,a0
	move	(a0),d0
.gotarg:
	lea	xbios_op_tb(pc),a0
	cmp	(a0)+,d0
	bhi.s	.exit
	tst.b	(a0,d0)
	beq.s	.exit
	move.l	cmd_delay_p(pc),a0
	addq	#1,(a0)
	move.l	temp_stack_sp(pc),a0
	move.l	4(sp),-(a0)
	move.l	a0,temp_stack_sp
	move.l	#post_fix_TOS_call,4(sp)
.exit:
	add	rev_frame_fix(pc),sp
	XB_gonext_d	nu_xbios
;
;
post_fix_TOS_call:
	move.l	temp_stack_sp(pc),a0
	move.l	(a0)+,-(sp)
	move.l	a0,temp_stack_sp
	move.l	cmd_delay_p(pc),a0
	subq	#1,(a0)
	rts
;
;
	data	;NB: no code beyond this point
;
;
	dcb.b	256,0	;originally 60 bytes !
temp_stack_top:
;
gemdos_op_tb:
	dc.w	$57		;Fdatime is last in list
	dcb.b	$30,0				;ignore op's $00..$2F
	dc.b	0,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1	;use Dfree,Dcreate..Fread
	dc.b	1,1,1,1,0,0,0,1,0,0,0,0,0,0,1,1	;use Fwrite..Fattrib,Dgetpath,Fsfirst,Fsnext
	dc.b	0,0,0,0,0,0,1,1			;use Frename,Fdatime
	even
;
bios_op_tb:
	dc.w	$04		;Rwabs is last in list
	dc.b	0,0,0,0,1	;use Rwabs
	even
;
xbios_op_tb:
	dc.w	$19		;Ikbdws	is last in list
	dc.b	0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0	;use Floprd,Flopwr,Flopfmt
	dc.b	0,0,1,1,0,0,0,0,0,1		;use Protobt,Flopver,Ikbdws
	even
;
self_bp_p:
	dc.l	0
self_size:
	dc.l	0
total_room:
	dc.l	0
org_phystop:
	dc.l	0
task_size_tb:
	dcb.l	8,0
block_sum_tb:
	dcb.l	10,0
dec_string_end:
;
tasks_used_m1:
	dc.w	0
self_end_p:
	dc.l	0
LE4C:
	dc.l	0
screen_base_p:
	dc.l	0
LE54:
	dc.l	0
resident_size:
	dc.l	0
sav_regs:
	dcb.l	16,0
sav_SR:
	dc.w	0
sav_USP:
	dc.l	0
swap_task_return_p:
	dc.l	0
LEA6:
	dc.l	0
LEAA:
	dc.l	0
;;;old_vbi_code_p:
	dc.l	0
LEB2:
	dc.l	0
active_task_ftb_p:
	dc.l	0
old_task_index_p:
	dc.l	0
LEBE:
	dc.l	0
LEC2:
	dc.l	0
disp_task_index_p:	;->word
	dc.l	0
back_task_index_p:
	dc.l	0
LECE:
	dc.l	0
;;;ikbd_vec_ret_2_p:
	dc.l	0
;;;ikbd_vec_ret_1_p:
	dc.l	0
LEDA:			;->byte variable for orig ikbd_vec
	dc.l	0
cmd_alt_ctl_sh_p:	;->byte variable for orig ikbd_vec
	dc.l	0
cmd_key_1_10_p:		;->byte variable for orig ikbd_vec
	dc.l	0
task_pal:		;word [16]
	dcb.w	16,0
task_rez:		;word
	dc.w	0
new_task_index_p:	;->word: new task index during switch, or -1
	dc.l	0
	dc.b	0,0	;	dc.w	0
	dc.b	0,0	;	dc.w	0
	dc.b	0,0	;	dc.w	0
	dc.b	0,0	;	dc.w	0
LF14:			;->word tested by 'tst.w' to modify ikbd return in orig
	dc.l	0
task_vbase2:		;byte
	dc.b	0
task_vbase1:		;byte
	dc.b	0
cmd_delay_p:		;->word
	dc.l	0
;;;old_gemdos_p:
	dc.l	0
temp_stack_sp:
	dc.l	0
cmd_timer_p:		;->word
	dc.l	0
back_off_flag_p:	;->word
	dc.l	0
back_off_ftb_p:		;->byte [8]
	dc.l	0
auto_on_flag_p:
	dc.l	0
;;;old_bios_p:
	dc.l	0
;;;old_xbios_p:
	dc.l	0
;
;
;	only string data below this point
;
program_title_s:
	dc.b	ESC,'E',LF,ESC,'p'
	dc.b	ESC,'C',ESC,'C'
	dc.b	'           '
	dc.b	CR,LF,ESC,'C',ESC,'C'
	dc.b	' MULTI-ST! ',CR,LF
	dc.b	ESC,'C',ESC,'C'
	dc.b	'           ',ESC,'q',CR,LF,LF
	dc.b	'Von Thomas Gruber.',CR,LF,LF
	dc.b	NUL
too_small_RAM_s:
	dc.b	'Leider reicht der Speicher nicht.',CR,LF
	dc.b	'Bitte eine Taste drcken.',CR,LF
	dc.b	NUL
cr_lf_s:
	dc.b	CR,LF,NUL
tasks_prompt_1_s:
	dc.b	'Wie viele STs sollen es denn sein?',CR,LF
	dc.b	'   - 1 Computer ist genug. ('
	dc.b	NUL
tasks_prompt_2_s:
	dc.b	'   - ',NUL
tasks_prompt_3_s:
	dc.b	' Stck mit jeweils ',NUL
sp_KB_s:
	dc.b	' KB',NUL
tasks_query_s:
	dc.b	CR,LF,'Anzahl: ',NUL
RAM_error_s:
	dc.b	CR,LF
	dc.b	'Fehler bei Speicherbelegung!'
	dc.b	NUL
XBRA_error_s:
	dc.b	CR,LF
	dc.b	"XBRA-kennung 'MuST' schon gebraucht !"
	dc.b	NUL
end_error_s:
	dc.b	CR,LF
	dc.b	'Multi-ST kann leider nicht gestartet',CR,LF
	dc.b	'werden.',CR,LF
	dc.b	'Bitte eine Taste drcken.',CR,LF
	dc.b	NUL
instructions_1_s:
	dc.b	ESC,'E'
	dc.b	'Funktionstastenbelegung:',CR,LF,LF
	dc.b	'ALT-F1 bis ALT-F'
	dc.b	NUL
instructions_2_s:
	dc.b	':',CR,LF
	dc.b	'   Entsprechenden Computer anzeigen',CR,LF
	dc.b	'ALT-F9:',CR,LF
	dc.b	'   Angezeigten Computer aktivieren',CR,LF
	dc.b	'ALT-SHIFT-F9:',CR,LF
	dc.b	'   Angezeigten Computer deaktivieren',CR,LF
	dc.b	'ALT-F10:',CR,LF
	dc.b	'   Hintergrundprozesse stoppen',CR,LF
	dc.b	'ALT-SHIFT-F10',CR,LF
	dc.b	'   Hintergrundprozesse wieder starten',CR,LF
	dc.b	'ALT-CTRL-F10:',CR,LF
	dc.b	'   Automatische Prozeumschaltung zur',CR,LF
	dc.b	'   Effizienzerhhung',CR,LF
	dc.b	'   (wird mit F10 wieder abgeschaltet)',CR,LF,LF
	dc.b	'Bitte eine Taste drcken...'
	dc.b	NUL
hide_cur_CLS_s:
	dc.b	ESC,'f',ESC,'E',NUL
;
;
	bss
;
loc_stack:
	ds.l	stack_size/4
loc_st_top:
;
	end	;of file:	MULTI_ST.S
