;File name:	MULTI_ST.S		Revision date:	1992.06.02
;Revised by:	Ulf Ronald Andersson	Disassembled:	1992.05.22
;
;
	include	TOS\URAn_SYS.S
	include TOS\URAn_DOS.S
	include	TOS\URAn_XB.S
;
;
	opt	o+
	opt	a+
;
;
	text
rz:
bp		= rz-$100
stack_size	= $400
glob_size	= $2000
;
;
;------------------------------------------------
;	Start of program
;------------------------------------------------
;
start:	bra	main
;
;
;------------------------------------------------
;	Start of new local variables
;------------------------------------------------
;
lomem_size	dc.l	0
total_room	dc.l	0
himem_size	dc.l	0
task_size	dc.l	0
block_size	dc.l	0
lomem_p		dc.l	0
midmem_p	dc.l	0
himem_p		dc.l	0
sav_v_bas_ad	dc.l	0
kbd_iorec_p	dc.l	0
kbshift_p	dc.l	0
kbdvbase_p	dc.l	0
kbd_comd	dc.w	0
old_tail_ix	dc.w	0
SR_frame_fix	dc.w	0
ret_frame_fix	dc.w	2
arg_frame_fix	dc.w	6
rev_frame_fix	dc.w	2
;
;------------------------------------------------
;	End of new local variables
;------------------------------------------------
;
;
;------------------------------------------------
;	Start of vector-linked routines
;------------------------------------------------
;
;
;------------------------------------------------
;	Start of IKBD_VEC routine
;------------------------------------------------
;
	XB_define	nu_ikbd_vec,'MuST'
nu_ikbd_vec_code:
	XB_donext_d	nu_ikbd_vec(pc)
MuSTcode:
	move	SR,-(sp)
	move.l	kbd_iorec_p(pc),a0
	move	io_tail_ix(a0),d1
	cmp	old_tail_ix(pc),d1
	beq	.exit
	or	#$0700,SR
	move	io_tail_ix(a0),d1
	move	d1,old_tail_ix
	cmp	io_head_ix(a0),d1
	beq.s	.exit
	move.l	kbshift_p(pc),a1
	move.b	(a1),d2			;New! get kbshifts (** TOS independent **)
	move.l	io_buffer_p(a0),a2	;get address of io-buffer
	move	(a2,d1),d0		;get 1'st word for this key = key code
	and	#$7F,d0			;mask key code
	cmp	#$5D,d0
	bhi.s	.exit			;no keys above SHIFT-F10
	cmp	#$3B,d0
	blo.s	.exit			;no keys below F1
	cmp	#$44,d0
	blo.s	.use_Fx			;use F1..F10
	cmp	#$54,d0
	blo.s	.exit			;no keys between F10..SHIFT-F1
	sub	#$54-$3B,d0		;transform shifted Fx keys to unshifted
.use_Fx:
	sub	#$3B,d0			;transform key F1..F10 to value 1..10
	cmp	#8,d0
	bhs.s	.test_flags		;accept F9,F10 preliminary
	cmp	tasks_used_m1(pc),d0
	bhi.s	.exit			;no keys for nonexistent tasks
.test_flags:
	move.b	d2,d3
	and	#1,d3
	lsr.b	#1,d2
	or	d3,d2
	and	#07,d2
	lsl	#3,d0
	or	d2,d0			;here d0=10*8 possible Fx-ALT-CTRL-SHIFT variants
	lea	command_flag_tb(pc),a1
	tst.b	(a1,d0)
	beq.s	.exit
	move	d0,kbd_comd
	subq	#4,d1
	bge.s	.tail_shrunk
	move	io_size_ix(a0),d1
	subq	#4,d1
.tail_shrunk:
	move	d1,io_tail_ix(a0)
	move	d1,old_tail_ix
.exit:
	move	(sp)+,SR
	rts
;
;
command_flag_tb:
	dc.b	0,0,0,1,0,0,0,0		;F1
	dc.b	0,0,0,1,0,0,0,0		;F2
	dc.b	0,0,0,1,0,0,0,0		;F3
	dc.b	0,0,0,1,0,0,0,0		;F4
	dc.b	0,0,0,1,0,0,0,0		;F5
	dc.b	0,0,0,1,0,0,0,0		;F6
	dc.b	0,0,0,1,0,0,0,0		;F7
	dc.b	0,0,0,1,0,0,0,0		;F8
	dc.b	0,0,0,0,0,0,0,0		;F9
	dc.b	0,0,0,1,0,0,0,0		;F10
;
;------------------------------------------------
;	End of IKBD_VEC routine
;------------------------------------------------
;
;
;------------------------------------------------
;	Start of VBI interrupt routine
;------------------------------------------------
;
	XB_define	nu_VBI,'MuST'
nu_VBI_code:
	move.l	a0,-(sp)
	move.l	cmd_delay_gp(pc),a0
	tst	(a0)
	bne.s	.exit
	tst	kbd_comd
	beq.s	.exit
	movem.l	d0-d7/a1-a6,-(sp)
	bsr	execute_cmd
	movem.l	(sp)+,d0-d7/a1-a6
	bcs.s	nu_VBI_swap_task
.exit:
	move.l	(sp)+,a0
nu_VBI_exit:
	XB_gonext_d	nu_VBI
;
nu_VBI_swap_task:
	move.l	(sp)+,a0
	movem.l	d0-d7/a0-a7,sav_regs
	move	USP,a0
	move.l	a0,sav_USP
	move	SR,sav_SR
	move.l	#nu_VBI_exit,swap_task_return_p
	or	#$700,SR			;disable interrupts !
	bsr	block_ikbd			;disable ikbd traffic
	lea	(hw_pal).w,a0
	lea	task_pal(pc),a1
	move	#16-1,d0
.save_pal_lp:
	move	(a0)+,(a1)+
	dbra	d0,.save_pal_lp
	move.b	(hw_rez).w,d0
	and	#3,d0
	move.b	d0,task_rez
	move.b	(hw_syn).w,d0
	and	#3,d0
	move.b	d0,task_syn
	move.b	(hw_vbase2).w,task_vbase2
	move.b	(hw_vbase1).w,task_vbase1
	move.l	(_v_bas_ad).w,sav_v_bas_ad
	bsr	test_delay_supx
	move.l	autostep_f_gp(pc),a0
	tst	(a0)
	beq.s	.skip_auto
	clr	(a0)
	move.l	old_task_index_gp(pc),a0
	move	(a0),d0
	move	d0,d1
.step_task_lp_1:
	addq	#1,d0
	cmp	tasks_used_m1(pc),d0
	bls.s	.L67C
	clr	d0
.L67C:
	cmp	d1,d0
	beq.s	.skip_auto
	move.l	new_task_index_gp(pc),a0
	move	d0,(a0)
.skip_auto:
	move.l	old_task_index_gp(pc),a0
	move	(a0),d0
	move.l	new_task_index_gp(pc),a1
	move	(a1),d1
	move	d1,(a0)			;store new old_task_index
	move.l	task_base_p_tb_gp(pc),a2
	asl	#2,d0
	asl	#2,d1
	move.l	(a2,d1),a1		;a1 -> RAM restore area for new task
	move.l	a1,0(a2,d0)		;also use a1 as RAM save area for old task
	clr.l	(a2,d1)		;mark new task as restored
	move.l	sp,a2
	move.l	swap_stack_end_gp(pc),sp
	move.l	a2,-(sp)
	move.l	lomem_p(pc),a0
	move.l	lomem_size(pc),d0
	bsr	swap_RAM_sub
	move.l	midmem_p(pc),a0
	move.l	task_size(pc),d0
	bsr	swap_RAM_sub
	move.l	himem_p(pc),a0
	move.l	himem_size(pc),d0
	bsr	swap_RAM_sub
	move.l	new_task_index_gp(pc),a0
	move	#-1,(a0)		;mark new_task_index handling completed
	move.l	sav_v_bas_ad(pc),(_v_bas_ad).w
	move.b	task_vbase2(pc),(hw_vbase2).w
	move.b	task_vbase1(pc),(hw_vbase1).w
	lea	(hw_pal).w,a0
	lea	task_pal(pc),a1
	move	#16-1,d0
.rest_pal_lp:
	move	(a1)+,(a0)+
	dbra	d0,.rest_pal_lp
	move.b	task_rez(pc),(hw_rez).w
	move.b	task_syn(pc),(hw_syn).w
	bsr	sync_lace_supx
	bsr	release_ikbd
	move.l	(sp)+,sp
	move.l	sav_USP(pc),a0
	move	a0,USP
	movem.l	sav_regs(pc),d0-d7/a0-a7
	move	sav_SR(pc),SR
	move.l	swap_task_return_p(pc),-(sp)
	rts
;
;
boot_reentry:
	XB_install	nu_VBI,(ev_vbi).w
	bsr	release_ikbd
	move	(sp)+,SR
	gemdos	Super,()
	gemdos	Ptermres,resident_size(pc),!
;
;------------------------------------------------
;	End of VBI interrupt routine
;------------------------------------------------
;
;
;------------------------------------------------
;	Start of gemdos, bios, xbios routines
;------------------------------------------------
;
	XB_define	nu_gemdos,'MuST'
nu_gemdos_code:
	sub	rev_frame_fix(pc),sp
	move	8(sp),d0
	btst	#5,2(sp)
	bne.s	.gotarg
	move	USP,a0
	move	(a0),d0
.gotarg:
	lea	gemdos_op_tb(pc),a0
	cmp	(a0)+,d0
	bhi.s	.exit
	tst.b	(a0,d0)
	beq.s	.exit
	move.l	cmd_delay_gp(pc),a0
	addq	#1,(a0)
	move.l	temp_stack_sp(pc),a0
	move.l	4(sp),-(a0)
	move.l	a0,temp_stack_sp
	move.l	#post_fix_TOS_call,4(sp)
.exit:
	add	rev_frame_fix(pc),sp
	XB_gonext_d	nu_gemdos
;
;
;------------------------------------------------
;
;
	XB_define	nu_bios,'MuST'
nu_bios_code:
	sub	rev_frame_fix(pc),sp
	move	8(sp),d0
	btst	#5,2(sp)
	bne.s	.gotarg
	move	USP,a0
	move	(a0),d0
.gotarg:
	lea	bios_op_tb(pc),a0
	cmp	(a0)+,d0
	bhi.s	.exit
	tst.b	(a0,d0)
	beq.s	.exit
	move.l	cmd_delay_gp(pc),a0
	addq	#1,(a0)
	move.l	temp_stack_sp(pc),a0
	move.l	4(sp),-(a0)
	move.l	a0,temp_stack_sp
	move.l	#post_fix_TOS_call,4(sp)
.exit:
	add	rev_frame_fix(pc),sp
	XB_gonext_d	nu_bios
;
;
;------------------------------------------------
;
;
	XB_define	nu_xbios,'MuST'
nu_xbios_code:
	sub	rev_frame_fix(pc),sp
	move	8(sp),d0
	btst	#5,2(sp)
	bne.s	.gotarg
	move	USP,a0
	move	(a0),d0
.gotarg:
	lea	xbios_op_tb(pc),a0
	cmp	(a0)+,d0
	bhi.s	.exit
	tst.b	(a0,d0)
	beq.s	.exit
	move.l	cmd_delay_gp(pc),a0
	addq	#1,(a0)
	move.l	temp_stack_sp(pc),a0
	move.l	4(sp),-(a0)
	move.l	a0,temp_stack_sp
	move.l	#post_fix_TOS_call,4(sp)
.exit:
	add	rev_frame_fix(pc),sp
	XB_gonext_d	nu_xbios
;
;
post_fix_TOS_call:
	move.l	temp_stack_sp(pc),a0
	move.l	(a0)+,-(sp)
	move.l	a0,temp_stack_sp
	move.l	cmd_delay_gp(pc),a0
	subq	#1,(a0)
	rts
;
;------------------------------------------------
;	End of gemdos, bios, xbios routines
;------------------------------------------------
;
;
;------------------------------------------------
;	End of vector-linked routines
;------------------------------------------------
;
;
;------------------------------------------------
;	Start of general subroutines
;------------------------------------------------
;
command_sub_tb:
	dc.l	cmd_0,cmd_0,cmd_0,F1_cmd_SC,cmd_0,cmd_0,cmd_0,cmd_0		;F1
	dc.l	cmd_0,cmd_0,cmd_0,F2_cmd_SC,cmd_0,cmd_0,cmd_0,cmd_0		;F2
	dc.l	cmd_0,cmd_0,cmd_0,F3_cmd_SC,cmd_0,cmd_0,cmd_0,cmd_0		;F3
	dc.l	cmd_0,cmd_0,cmd_0,F4_cmd_SC,cmd_0,cmd_0,cmd_0,cmd_0		;F4
	dc.l	cmd_0,cmd_0,cmd_0,F5_cmd_SC,cmd_0,cmd_0,cmd_0,cmd_0		;F5
	dc.l	cmd_0,cmd_0,cmd_0,F6_cmd_SC,cmd_0,cmd_0,cmd_0,cmd_0		;F6
	dc.l	cmd_0,cmd_0,cmd_0,F7_cmd_SC,cmd_0,cmd_0,cmd_0,cmd_0		;F7
	dc.l	cmd_0,cmd_0,cmd_0,F8_cmd_SC,cmd_0,cmd_0,cmd_0,cmd_0		;F8
	dc.l	cmd_0,cmd_0,cmd_0,cmd_0,cmd_0,cmd_0,cmd_0,cmd_0			;F9
	dc.l	cmd_0,cmd_0,cmd_0,F10_cmd_SC,cmd_0,cmd_0,cmd_0,cmd_0		;F10
;
;
execute_cmd:
	lea	command_sub_tb(pc),a0
	move	kbd_comd(pc),d0
	clr	kbd_comd
	lsl	#2,d0
	move.l	(a0,d0),-(sp)
	rts
;
F1_cmd_SC:
	moveq	#0,d0
	bra.s	Flo_cmd_SC
;	
F2_cmd_SC:
	moveq	#1,d0
	bra.s	Flo_cmd_SC
;	
F3_cmd_SC:
	moveq	#2,d0
	bra.s	Flo_cmd_SC
;	
F4_cmd_SC:
	moveq	#3,d0
	bra.s	Flo_cmd_SC
;	
F5_cmd_SC:
	moveq	#4,d0
	bra.s	Flo_cmd_SC
;	
F6_cmd_SC:
	moveq	#5,d0
	bra.s	Flo_cmd_SC
;	
F7_cmd_SC:
	moveq	#6,d0
	bra.s	Flo_cmd_SC
;	
F8_cmd_SC:
	moveq	#7,d0
Flo_cmd_SC:
	move.l	old_task_index_gp(pc),a0
	cmp	(a0),d0
	beq.s	cmd_0
	move.l	new_task_index_gp(pc),a0
	move	d0,(a0)
	move	#1,CCR
	rts
;
F10_cmd_SC:
	move.l	autostep_f_gp(pc),a0
	move	#1,(a0)
	move	#1,CCR
	rts
;
cmd_0:
	tst	d0	;clear carry
	rts
;
;
swap_RAM_sub:
	divu	#$180,d0
	beq	.swap_less_384
	subq	#1,d0
.swap_384_loop:
	rept	8
	movem.l	(a0),d1-d7/a2-a6
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	movem.l	d1-d7/a2-a6,-48(a1)
	endr
	dbra	d0,.swap_384_loop
.swap_less_384:
	swap	d0
	move	d0,d1
	lsr	#4,d1
	beq.s	.swap_less_16
	subq	#1,d1
.swap_16_loop:
	move.l	(a0),d2
	move.l	(a1),(a0)+
	move.l	d2,(a1)+
	move.l	(a0),d2
	move.l	(a1),(a0)+
	move.l	d2,(a1)+
	move.l	(a0),d2
	move.l	(a1),(a0)+
	move.l	d2,(a1)+
	move.l	(a0),d2
	move.l	(a1),(a0)+
	move.l	d2,(a1)+
	dbra	d1,.swap_16_loop
.swap_less_16:
	and	#$0F,d0
	beq.s	.swap_exit
	subq	#1,d0
.swap_byte_loop:
	move.b	(a0),d1
	move.b	(a1),(a0)+
	move.b	d1,(a1)+
	dbra	d0,.swap_byte_loop
.swap_exit:
	rts
;
;------------------------------------------------
;	End of general subroutines
;------------------------------------------------
;
;
;------------------------------------------------
;	Start of hardware subroutines
;------------------------------------------------
;
block_ikbd:
	move.l	ikbd_status_gp(pc),a0
	tst	(a0)
	beq.s	.exit
	clr	(a0)
.wait_loop_1:
	btst	#1,(hw_kbstat).w
	beq.s	.wait_loop_1
	move.b	#19,(hw_kbdata).w
.wait_loop_2:
	btst	#1,(hw_kbstat).w
	beq.s	.wait_loop_2
.exit:
	rts
;
;
release_ikbd:
	move.l	ikbd_status_gp(pc),a0
	tst	(a0)
	bne.s	.exit
	move	#1,(a0)
.wait_loop_1:
	btst	#1,(hw_kbstat).w
	beq.s	.wait_loop_1
	move.b	#17,(hw_kbdata).w
.wait_loop_2:
	btst	#1,(hw_kbstat).w
	beq.s	.wait_loop_2
.exit:
	rts
;
;
sync_lace_supx:
	addq	#1,rez_lock_f
	bsr.s	small_lace_supx
	bsr	test_delay_supx
	move	d1,d0
	bsr	Vsync_supx
	bchg	#0,(hw_rez).w
	bsr	Vsync_supx
	bchg	#0,(hw_rez).w
	move	lacesave(pc),d0
	bsr.s	make_lace_supx
	bsr.s	test_video_supx
	subq	#1,rez_lock_f
	bpl.s	.exit
	clr	rez_lock_f
.exit:
	rts
;
rest_lace_supx:
	move	lacesave(pc),d0
	cmp	lacedata(pc),d0
	beq.s	make_lace_supx
	bsr.s	test_delay_supx
last_lace_supx:
	move	lacesave(pc),d0
make_lace_supx:
	clr.l	d1
	bra.s	hardlace_supx
;
loframe_lace_supx:
	moveq	#2,d0
	moveq	#-3,d1
	bra.s	hardlace_supx
;
hiframe_lace_supx:
	clr	d0
	moveq	#-3,d1
	bra.s	hardlace_supx
;
large_lace_supx:
	moveq	#1,d0
	moveq	#-2,d1
	bra.s	hardlace_supx
;
small_lace_supx:
	clr	d0
	moveq	#-2,d1
hardlace_supx:
	and	lacedata(pc),d1
	eor	d0,d1
	and	#$C03F,d1
	or	#$0040,d1
	move	(hw_rez).w,d0
	and	#$0300,d0
	or	d1,d0
	move	d0,(hw_rez).w
	move	lacedata(pc),d1
	move	d0,lacedata
	exg	d0,d1
	move	d0,lacesave
	rts
;
;
test_delay_supx:	;d0 = wide_flag   d1 = end_page_offs   none other affected
	bsr	test_video_supx
test_video_supx:	;d0 = wide_flag   d1 = end_page_num   none other affected
	movem.l	d2/a0,-(sp)
	move	SR,d2
	suba.l	a0,a0
	movep	hw_vbase2(a0),d1
	swap	d1
.Vsync_lp:
	bsr.s	sub_sync_supx
	bls.s	.Vsync_lp
	movep	hw_vbase2(a0),d0
	sub	d0,d1
	cmp	#(32000+1024)/256,d1
	shs	d0
	tst	rez_lock_f
	bne.s	.exit
	and	#1,d0
	and	#-2,lacedata
	or	d0,lacedata
	tst	d0
	sne	d0
.exit:
	ext.w	d0
	ext.l	d0
	movem.l	(sp)+,d2/a0
	rts	;returns d1 = possible new Vsync_offs
;
;
Vsync_supx:	;entry d0 = expected Vsync_offs
	movem.l	d1-d3/a0,-(sp)
	move	SR,d2
	suba.l	a0,a0
	move	d0,d3
	movep	hw_vbase2(a0),d1
	add	d1,d3
	swap	d1
.Vsync_lp:
	bsr.s	sub_sync_supx
	bhi.s	.got_new
	cmp	d3,d0
	blo.s	.Vsync_lp
	bra.s	.got_old
;
.got_new:
	move	d1,d0
.got_old:
	movep	hw_vbase2(a0),d1
	sub	d1,d0
	movem.l	(sp)+,d1-d3/a0
	rts	;returns d0 = possible new Vsync_offs
;
;
sub_sync_supx:	;entry d1==last_valid_read<<16
sub_sync_lp_1:
	or	#$0700,SR
sub_sync_lp_2:
	movep	hw_vpos2(a0),d0
	movep	hw_vpos2(a0),d1
	cmp	d0,d1
	bne.s	sub_sync_lp_2	;awaits valid read    (d0 == d1)
	move	d2,SR
	swap	d1
	cmp	d0,d1
	beq.s	sub_sync_lp_1	;awaits altered value (d0 != d1)
	rts	;flags HI after Vsync   d1 = (d0=last_valid_read)<<16 + prev_valid_read
;
;
lacedata	ds.w	1
lacesave	ds.w	1
rez_lock_f	ds.w	1
;
;
;
;------------------------------------------------
;	End of hardware subroutines
;------------------------------------------------
;
;
;------------------------------------------------
;	Start of initialization subroutines
;------------------------------------------------
;
init_ikbd_vec:
	xbios	Iorec,#1
	lea	kbd_iorec_p(pc),a0
	move.l	d0,(a0)
	move.l	d0,a0
	move	io_tail_ix(a0),old_tail_ix
	move.l	(_sysbase).w,a0
	move.l	os_selfbeg_p(a0),a0
	move.l	os_kbshift_p(a0),d0	;->kbshift variable in modern TOS >= 1.4
	cmp	#$0104,os_version(a0)	;check OS version
	bhs.s	insta_OS		;if modern TOS goto insta_OS
;					;else init kbshift_p, valid for TOS <= TOS 1.04
	xbios	Keytbl|_IND,?,?,?
	subq.l	#1,d0		;NB: this assumes Kbshift stored at Keytbl-1
;				;NB: So in all early TOS Kbshift data lies at Keytbl-1 !!!
insta_OS:
	move.l	d0,kbshift_p		; Store kbshift variable ptr
	xbios	Kbdvbase
	move.l	d0,kbdvbase_p
	move.l	d0,a0
	XB_install	nu_ikbd_vec,32(a0)
	rts
;
;
init_vectors:
	tst	(_longframe).w
	sne	d0
	and	#2,d0
	move	d0,SR_frame_fix
	addq	#2,d0
	move	d0,ret_frame_fix
	addq	#4,d0
	move	d0,arg_frame_fix
	moveq	#2,d0
	sub	SR_frame_fix(pc),d0
	move	d0,rev_frame_fix
	XB_install	nu_gemdos,(ev_gemdos).w
	XB_install	nu_bios,(ev_bios).w
	XB_install	nu_xbios,(ev_xbios).w
	rts
;
;------------------------------------------------
;	End of initialization subroutines
;------------------------------------------------
;
;
;------------------------------------------------
;	Start of 'main' initialization routine
;------------------------------------------------
;
main:
	move.l	4(sp),a0
	move.l	a0,self_bp_p
	move.l	bp_bss_beg_p(a0),d0
	add.l	bp_bss_len(a0),d0
	cmp.l	bp_selfend_p(a0),d0
	blo.s	main_1
error_Pterm_1:
	gemdos	Pterm0
;
;
main_1:
	move.l	d0,sp
	move.l	d0,self_end_p
	sub.l	a0,d0
	move.l	d0,self_size
	gemdos	Super,!
	move.l	d0,-(sp)
	move.l	self_bp_p(pc),a0
	move.l	#8,lomem_p
	move.l	bp_selfend_p(a0),d0
	move.l	d0,himem_p
	sub.l	self_end_p(pc),d0
	move.l	d0,total_room		;total_room = bp_selfend_p - self_end_p
	move.l	(phystop).w,d0
	move.l	d0,org_phystop
	sub.l	bp_selfend_p(a0),d0
	move.l	d0,himem_size
	move.l	self_end_p(pc),d0
	sub.l	lomem_p(pc),d0
	move.l	d0,lomem_size
	lea	task_size_tb(pc),a0
	lea	block_size_tb(pc),a1
	move	#1,d0			;start loop with x = 1
main_loop_1:
	move.l	org_phystop(pc),d1
	sub.l	lomem_p(pc),d1
	sub.l	#glob_size,d1		;d1 = phystop-lomem_p-glob_size
	move.l	d1,d2
	clr	d1
	swap	d1
	divu	d0,d1
	swap	d1
	swap	d2
	move	d1,d2
	swap	d2
	divu	d0,d2
	bclr	#0,d2
	move	d2,d1			;d1 = even((phystop-lomem_p-glob_size)/x)
	sub.l	lomem_size(pc),d1
	sub.l	himem_size(pc),d1	;d1 = free RAM per task
	cmp.l	#$10000,d1
	bge.s	.got_task_size
	clr.l	d1
.got_task_size:
	move.l	d1,(a0)+		;store task_size
	add.l	lomem_size(pc),d1
	add.l	himem_size(pc),d1	;d1 = total RAM per task
	move	d0,d2
	subq	#1,d2
	move	d1,d3
	mulu	d2,d3
	swap	d1
	mulu	d2,d1
	swap	d1
	clr	d1
	add.l	d3,d1			;d1 = total RAM for saved tasks
	add.l	#glob_size,d1		;d1 = total RAM in save area
	move.l	d1,(a1)+		;store block_size
	addq	#1,d0			;increment x
	cmp	#9,d0			;x == 9 ?  (too high)
	bne.s	main_loop_1		;loop back for all 8 calc's
	gemdos	Cconws,program_title_s(pc)
	tst.l	task_size_tb+4		;possible to multitask ?
	bne.s	main_2
	gemdos	Cconws,too_small_RAM_s(pc)
	gemdos	Crawcin
	bra	error_exit_2
;
main_2:
	lea	tasks_prompt_1_s(pc),a0
	bsr	Cconws_a0_sub
	move.l	task_size_tb(pc),d0
	add.l	lomem_size(pc),d0
	add.l	himem_size(pc),d0	;d0 = total RAM per task
	lsr.l	#5,d0
	lsr.l	#5,d0			;d0 = size/task in KB
	bsr	show_dec_d0_word
	lea	sp_KB_s(pc),a0
	bsr	Cconws_a0_sub
	gemdos	Cconout,#')'
	lea	cr_lf_s(pc),a0
	bsr	Cconws_a0_sub
	move	#2,d0
	lea	task_size_tb+4(pc),a0
main_loop_2:
	move.l	(a0)+,d1
	beq.s	L19C
	movem.l	d0/a0,-(sp)
	move.l	d1,-(sp)
	lea	tasks_prompt_2_s(pc),a0
	bsr	Cconws_a0_sub
	move.l	4(sp),d0
	add	#'0',d0
	gemdos	Cconout,d0
	lea	tasks_prompt_3_s(pc),a0
	bsr	Cconws_a0_sub
	move.l	(sp)+,d0
	add.l	lomem_size(pc),d0
	add.l	himem_size(pc),d0	;d0 = total RAM per task
	lsr.l	#5,d0
	lsr.l	#5,d0
	bsr	show_dec_d0_word
	lea	sp_KB_s(pc),a0
	bsr	Cconws_a0_sub
	lea	cr_lf_s(pc),a0
	bsr	Cconws_a0_sub
	movem.l	(sp)+,d0/a0
L19C:
	addq	#1,d0
	cmp	#9,d0
	bne.s	main_loop_2
	lea	tasks_query_s(pc),a0
	bsr	Cconws_a0_sub
main_loop_3:
	gemdos	Crawcin
	cmp.b	#'1',d0
	blo.s	main_loop_3
	cmp	#'8',d0
	bhi.s	main_loop_3
	move.b	d0,d1
	sub.b	#'1',d1
	ext.w	d1
	move	d1,tasks_used_m1
	asl	#2,d1
	lea	task_size_tb(pc),a0
	tst.l	(a0,d1)			;legal task ?  (size != 0)
	beq.s	main_loop_3
	gemdos	Cconout,d0
	tst	tasks_used_m1
	beq.s	single_task_exit
	lea	instructions_1_s(pc),a0
	bsr.s	Cconws_a0_sub
	move	tasks_used_m1(pc),-(sp)
	add	#'1',(sp)
	gemdos	Cconout,()
	lea	instructions_2_s(pc),a0
	bsr.s	Cconws_a0_sub
	gemdos	Crawcin
	lea	hide_cur_CLS_s(pc),a0
	bsr.s	Cconws_a0_sub
	bra.s	main_3
;
error_exit_2:
single_task_exit:
	gemdos	Super,()
error_Pterm_2:
	gemdos	Pterm0
;
;
show_dec_d0_word:
	lea	dec_string_end(pc),a0
	clr.b	-(a0)
	tst	d0
	bne.s	L244
	move.b	#'0',-(a0)
	bra.s	L25C
;
L244:
	and.l	#$FFFF,d0
	divu	#10,d0
	move.l	d0,d1
	swap	d1
	add.b	#'0',d1
	move.b	d1,-(a0)
	tst	d0
	bne.s	L244
L25C:
	gemdos	Cconws,(a0)
	rts
;
;
Cconws_a0_sub:
	gemdos	Cconws,(a0)
	rts
;
;
main_3:	;here more than 1 task has been requested
	move	tasks_used_m1(pc),d1
	asl	#2,d1
	lea	task_size_tb(pc),a0
	move.l	(a0,d1),task_size
	lea	block_size_tb(pc),a0
	move.l	(a0,d1),d1		;d1 = summed size of tasks
	move.l	d1,block_size
	add.l	self_size(pc),d1	;d1 += selfsize
	move.l	d1,resident_size	;resident_size = d1
	move.l	self_bp_p(pc),a0
	move.l	a0,d0
	add.l	d1,d0
	move.l	d0,midmem_p
	gemdos	Mshrink,!,(a0),d1
	tst.l	d0
	beq.s	main_4
	lea	RAM_error_s(pc),a0
show_error_a0_exit:
	bsr.s	Cconws_a0_sub
	lea	end_error_s(pc),a0
	bsr.s	Cconws_a0_sub
	gemdos	Crawcin
	gemdos	Super,()
error_Pterm_3:
	gemdos	Pterm0
;
main_4:		;here tasker init will definitely proceed to completion
	move	SR,-(sp)
	or	#$700,SR
	move.l	self_end_p(pc),save_area_p
	move.l	midmem_p(pc),a0
	sub	#glob_size,a0
	move.l	a0,globals_gp
	move.l	a0,task_base_p_tb_gp
	add	#8*4,a0
	move.l	a0,old_task_index_gp
	addq	#2,a0
	add	#$80,a0
	move.l	a0,swap_stack_end_gp
	move.l	a0,new_task_index_gp
	addq	#2,a0
	move.l	a0,ikbd_status_gp
	addq	#2,a0
	move.l	a0,cmd_delay_gp
	addq	#2,a0
	move.l	a0,autostep_f_gp
	addq	#2,a0
;further globals can be added here
;global init follows
	move.l	old_task_index_gp(pc),a0
	clr	(a0)
	move.l	new_task_index_gp(pc),a0
	move	#-1,(a0)
	move.l	ikbd_status_gp(pc),a0
	clr	(a0)
	move.l	cmd_delay_gp(pc),a0
	clr	(a0)
	move.l	autostep_f_gp(pc),a0
	clr	(a0)
	bsr	block_ikbd
	move.l	#temp_stack_top,temp_stack_sp
	movem.l	d0-d7/a0-a7,sav_regs
	move	USP,a0
	move.l	a0,sav_USP
	move	SR,sav_SR
	move.l	#boot_reentry,swap_task_return_p
	move.l	(_v_bas_ad).w,sav_v_bas_ad
	move.b	(hw_vbase2).w,task_vbase2
	move.b	(hw_vbase1).w,task_vbase1
	lea	(hw_pal).w,a0
	lea	task_pal(pc),a1
	moveq	#16-1,d0
main_loop_4:			;loop copies palette into local variables
	move	(a0)+,(a1)+
	dbra	d0,main_loop_4	;loop back for whole palette
	move.b	(hw_rez).w,task_rez
	and.b	#3,task_rez
	move.b	(hw_syn).w,task_syn
	and.b	#3,task_syn
	bsr	test_delay_supx
	bsr	init_ikbd_vec
	bsr	init_vectors
	move.l	save_area_p(pc),a1
	move.l	lomem_p(pc),a0
	move.l	lomem_size(pc),d0
main_loop_5:			;loop copies 'lomem' area into first task save area
	move.b	(a0)+,(a1)+
	subq.l	#1,d0
	bne.s	main_loop_5	;loop back for all of 'lomem'
	move.l	midmem_p(pc),a0
	move.l	task_size(pc),d0
main_loop_55:			;loop copies 'midmem' area into first task save area
	move.b	(a0)+,(a1)+
	subq.l	#1,d0
	bne.s	main_loop_55	;loop back for all of 'midmem'
	move.l	himem_p(pc),a0
	move.l	himem_size(pc),d0
main_loop_6:				;loop copies 'himem' area into first task save area
	move.b	(a0)+,(a1)+
	subq.l	#1,d0
	bne.s	main_loop_6		;loop back for all of 'himem'
	move.l	save_area_p(pc),a0	;a0-> base of save area
	move.l	lomem_size(pc),d0
	add.l	task_size(pc),d0
	add.l	himem_size(pc),d0	;d0 = total save size per task
	lea	(a0,d0.l),a1		;a1-> second task save area (third task)
	move	tasks_used_m1(pc),d1
main_loop_7:				;loop copies first task save area to all others
	subq	#1,d1
	beq.s	main_loop_7_exit
	move.l	d0,d2			;d2 = d0 = total save size per task
main_loop_8:				;loop copies last save area to next save area
	move.b	(a0)+,(a1)+
	subq.l	#1,d2
	bne.s	main_loop_8		;loop back for whole area
	bra.s	main_loop_7		;loop back for all areas needed
;
main_loop_7_exit:
	move.l	task_base_p_tb_gp(pc),a0
	clr.l	(a0)+
	move	#7,d0
	move.l	save_area_p(pc),d2
	move	tasks_used_m1(pc),d1
main_loop_9:			;loop inits task base pointer table
	move.l	d2,(a0)+
	add.l	lomem_size(pc),d2
	add.l	task_size(pc),d2
	add.l	himem_size(pc),d2
	subq	#1,d0
	subq	#1,d1
	bne.s	main_loop_9	;loop back for each pointer needed
	tst	d0
	beq.s	main_loop_10_exit
main_loop_10:			;loop inits unused task base pointers to -1
	move.l	#-1,(a0)+
	subq	#1,d0
	bne.s	main_loop_10	;loop back for each remaining pointer
;
main_loop_10_exit:
	bra	boot_reentry
;
;------------------------------------------------
;	End of 'main' initialization routine
;------------------------------------------------
;
;
;------------------------------------------------
;	End of program code
;------------------------------------------------
;
;
	data	;NB: no code beyond this point
;
;
;------------------------------------------------
;	Start of old local variables
;------------------------------------------------
;
	dcb.b	256,0	;originally 60 bytes !
temp_stack_top:
;
gemdos_op_tb:
	dc.w	$57		;Fdatime is last in list
	dcb.b	$30,0				;ignore op's $00..$2F
	dc.b	0,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1	;use Dfree,Dcreate..Fread
	dc.b	1,1,1,1,0,0,0,1,0,0,0,0,0,0,1,1	;use Fwrite..Fattrib,Dgetpath,Fsfirst,Fsnext
	dc.b	0,0,0,0,0,0,1,1			;use Frename,Fdatime
	even
;
bios_op_tb:
	dc.w	$04		;Rwabs is last in list
	dc.b	0,0,0,0,1	;use Rwabs
	even
;
xbios_op_tb:
	dc.w	$19		;Ikbdws	is last in list
	dc.b	0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0	;use Floprd,Flopwr,Flopfmt
	dc.b	0,0,1,1,0,0,0,0,0,1		;use Protobt,Flopver,Ikbdws
	even
;
self_bp_p:
	dc.l	0
self_size:
	dc.l	0
org_phystop:
	dc.l	0
task_size_tb:
	dcb.l	8,0
block_size_tb:
	dcb.l	8,0
;
	dcb.l	2,0
dec_string_end:
;
tasks_used_m1:
	dc.w	0
self_end_p:
	dc.l	0
save_area_p:
	dc.l	0
globals_gp:		;->global data space
	dc.l	0
resident_size:
	dc.l	0
sav_regs:
	dcb.l	16,0
sav_SR:
	dc.w	0
sav_USP:
	dc.l	0
swap_task_return_p:
	dc.l	0
task_base_p_tb_gp:	;->global long [8]
	dc.l	0
old_task_index_gp:	;->global word
	dc.l	0
swap_stack_end_gp:
	dc.l	0
task_pal:		;word [16]
	dcb.w	16,0
task_rez:		;byte
	dc.w	0
task_syn:		;byte
	dc.w	0
new_task_index_gp:	;->word: new task index during switch, or -1
	dc.l	0
	dc.b	0,0	;	dc.w	0
	dc.b	0,0	;	dc.w	0
	dc.b	0,0	;	dc.w	0
	dc.b	0,0	;	dc.w	0
ikbd_status_gp:		;->global word
	dc.l	0
task_vbase2:		;byte
	dc.b	0
task_vbase1:		;byte
	dc.b	0
cmd_delay_gp:		;->global word
	dc.l	0
temp_stack_sp:
	dc.l	0
autostep_f_gp:		;->global word
	dc.l	0
;
;------------------------------------------------
;	End of old local variables
;------------------------------------------------
;
;
;------------------------------------------------
;	Start of string area
;------------------------------------------------
;
program_title_s:
	dc.b	ESC,'E',LF,ESC,'p'
	dc.b	ESC,'C',ESC,'C'
	dc.b	'           '
	dc.b	CR,LF,ESC,'C',ESC,'C'
	dc.b	' MULTI-ST! ',CR,LF
	dc.b	ESC,'C',ESC,'C'
	dc.b	'           ',ESC,'q',CR,LF,LF
	dc.b	'Von Thomas Gruber.',CR,LF,LF
	dc.b	NUL
too_small_RAM_s:
	dc.b	'Leider reicht der Speicher nicht.',CR,LF
	dc.b	'Bitte eine Taste drcken.',CR,LF
	dc.b	NUL
cr_lf_s:
	dc.b	CR,LF,NUL
tasks_prompt_1_s:
	dc.b	'Wie viele STs sollen es denn sein?',CR,LF
	dc.b	'   - 1 Computer ist genug. ('
	dc.b	NUL
tasks_prompt_2_s:
	dc.b	'   - ',NUL
tasks_prompt_3_s:
	dc.b	' Stck mit jeweils ',NUL
sp_KB_s:
	dc.b	' KB',NUL
tasks_query_s:
	dc.b	CR,LF,'Anzahl: ',NUL
RAM_error_s:
	dc.b	CR,LF
	dc.b	'Fehler bei Speicherbelegung!'
	dc.b	NUL
end_error_s:
	dc.b	CR,LF
	dc.b	'Multi-ST kann leider nicht gestartet',CR,LF
	dc.b	'werden.',CR,LF
	dc.b	'Bitte eine Taste drcken.',CR,LF
	dc.b	NUL
instructions_1_s:
	dc.b	ESC,'E'
	dc.b	'Funktionstastenbelegung:',CR,LF,LF
	dc.b	'ALT-F1 bis ALT-F'
	dc.b	NUL
instructions_2_s:
	dc.b	':',CR,LF
	dc.b	'   Entsprechenden Computer anzeigen',CR,LF
	dc.b	'ALT-F9:',CR,LF
	dc.b	'   Angezeigten Computer aktivieren',CR,LF
	dc.b	'ALT-SHIFT-F9:',CR,LF
	dc.b	'   Angezeigten Computer deaktivieren',CR,LF
	dc.b	'ALT-F10:',CR,LF
	dc.b	'   Hintergrundprozesse stoppen',CR,LF
	dc.b	'ALT-SHIFT-F10',CR,LF
	dc.b	'   Hintergrundprozesse wieder starten',CR,LF
	dc.b	'ALT-CTRL-F10:',CR,LF
	dc.b	'   Automatische Prozeumschaltung zur',CR,LF
	dc.b	'   Effizienzerhhung',CR,LF
	dc.b	'   (wird mit F10 wieder abgeschaltet)',CR,LF,LF
	dc.b	'Bitte eine Taste drcken...'
	dc.b	NUL
hide_cur_CLS_s:
	dc.b	ESC,'f',ESC,'E',NUL
	even
;
;------------------------------------------------
;	End of string area
;------------------------------------------------
;
;
	bss
;
loc_stack:
	ds.l	stack_size/4
loc_st_top:
;
	end	;of file:	MULTI_ST.S
