;File name:	TESTIKBD.S		Revision date:	1992.05.31
;Revised by:	Ulf Ronald Andersson	Creation date:	1992.05.31
;
;
	include	TOS\URAn_SYS.S
	include TOS\URAn_DOS.S
	include	TOS\URAn_XB.S
;
;
	opt	o+
	opt	a+
;
;
	text
rz:
bp		= rz-$100
stack_size	= $400
;
;
main:
	gemdos	Super,!
	move.l	d0,-(sp)
	move	SR,entry_SR
	or	#$0700,SR
	bsr	test_delay_supx
	move	entry_SR,SR
.enable_irq:
	clr	d1
.setup_irq:
	or	entry_SR,d1
	move	d1,test_SR
.main_loop:
	gemdos	Cconws,prompt_s
.wait_loop:
	gemdos	Cconis
	tst.l	d0
	beq.s	.wait_loop
	bios	Kbshift,?
	move.b	d0,d7
	gemdos	Crawcin
	move.l	d0,d6
	and	#$DF,d0
	cmp	#'Q',d0
	beq	.exit
	cmp	#'E',d0
	beq.s	.enable_irq
	move	#$0700,d1
	cmp	#'D',d0
	beq.s	.setup_irq
	move	d7,d0
	bsr	fix_byte
	move	d0,kbshift_s
	move	d6,d0
	swap	d0
	bsr	fix_byte
	move	d0,key_s
	move	d6,d0
	bsr	fix_byte
	move	d0,char_s
	gemdos	Cconws,result_s
	move	test_SR,SR
	bsr	block_ikbd
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	sync_lace_supx
	bsr	release_ikbd
	move	entry_SR,SR
	bra	.main_loop
;
.exit:
	gemdos	Super,()
	gemdos	Pterm0
;
;
entry_SR	ds.w	1
test_SR		ds.w	1
prompt_s:
	dc.b	CR,LF,'Hit a key (Quit Enable Disable)  ',NUL
	even
result_s:
	dc.b	'Kbshift = '
kbshift_s:
	dc.b	'00  Key = '
key_s:
	dc.b	'00  ascii = '
char_s:
	dc.b	'00.',NUL
	even
;
;
fix_byte:
	ror	#4,d0
	and.b	#$0F,d0
	add.b	#'0',d0
	cmp.b	#'9',d0
	bls.s	.digit_1_ok
	addq.b	#'A'-':',d0
.digit_1_ok:
	rol	#8,d0
	lsr.b	#4,d0
	add.b	#'0',d0
	cmp.b	#'9',d0
	bls.s	.digit_2_ok
	addq.b	#'A'-':',d0
.digit_2_ok:
	rts
;
;
block_ikbd:
LBBE:
	btst	#1,($ffffff&hw_kbstat).l
	beq.s	LBBE
	move.b	#19,($ffffff&hw_kbdata).l
LBD0:
	btst	#1,($ffffff&hw_kbstat).l
	beq.s	LBD0
LBDA:
	rts
;
;
release_ikbd:
LBE8:
	btst	#1,($ffffff&hw_kbstat).l
	beq.s	LBE8
	move.b	#17,($ffffff&hw_kbdata).l
LBFA:
	btst	#1,($ffffff&hw_kbstat).l
	beq.s	LBFA
LC04:
	rts
;
;
sync_lace_supx:
	addq	#1,rez_lock_f
	bsr.s	small_lace_supx
	bsr	test_video_supx
	move	#32000/256,d0
	bsr	Vsync_supx
	bchg	#0,(hw_rez).w
	move	#32000/256,d0
	bsr	Vsync_supx
	bchg	#0,(hw_rez).w
	move	lacesave(pc),d0
	bsr.s	make_lace_supx
	bsr.s	test_delay_supx
	subq	#1,rez_lock_f
	bpl.s	.exit
	clr	rez_lock_f
.exit:
	rts
;
rest_lace_supx:
	move	lacesave(pc),d0
	cmp	lacedata(pc),d0
	beq.s	make_lace_supx
	bsr.s	test_delay_supx
last_lace_supx:
	move	lacesave(pc),d0
make_lace_supx:
	clr.l	d1
	bra.s	hardlace_supx
;
loframe_lace_supx:
	moveq	#2,d0
	moveq	#-3,d1
	bra.s	hardlace_supx
;
hiframe_lace_supx:
	clr	d0
	moveq	#-3,d1
	bra.s	hardlace_supx
;
large_lace_supx:
	moveq	#1,d0
	moveq	#-2,d1
	bra.s	hardlace_supx
;
small_lace_supx:
	clr	d0
	moveq	#-2,d1
hardlace_supx:
	and	lacedata(pc),d1
	eor	d0,d1
	and	#$C03F,d1
	or	#$0040,d1
	move	(hw_rez).w,d0
	and	#$0300,d0
	or	d1,d0
	move	d0,(hw_rez).w
	move	lacedata(pc),d1
	move	d0,lacedata
	exg	d0,d1
	move	d0,lacesave
	rts
;
;
test_delay_supx:	;d0 = wide_flag   d1 = end_page_offs   none other affected
	bsr	test_video_supx
test_video_supx:	;d0 = wide_flag   d1 = end_page_num   none other affected
	movem.l	d2/a0,-(sp)
	move	SR,d2
	suba.l	a0,a0
	movep	hw_vbase2(a0),d1
	swap	d1
.Vsync_lp:
	bsr.s	sub_sync_supx
	bls.s	.Vsync_lp
	movep	hw_vbase2(a0),d0
	sub	d0,d1
	clr.l	d0
	cmp	#(32000+1024)/256,d1
	blo.s	.exit_small
	or	#1,lacedata
	moveq	#-1,d0
	bra.s	.exit
;
.exit_small:
	and	#-2,lacedata
	tst.l	d0
.exit:
	movem.l	(sp)+,d2/a0
	rts	;returns d1 = possible new Vsync_offs
;
;
Vsync_supx:	;entry d0 = expected Vsync_offs
	movem.l	d1-d3/a0,-(sp)
	move	SR,d2
	suba.l	a0,a0
	move	d0,d3
	movep	hw_vbase2(a0),d1
	add	d1,d3
	swap	d1
.Vsync_lp:
	bsr.s	sub_sync_supx
	bhi.s	.got_new
	cmp	d3,d0
	blo.s	.Vsync_lp
	bra.s	.got_old
;
.got_new:
	move	d1,d0
.got_old:
	movep	hw_vbase2(a0),d1
	sub	d1,d0
	movem.l	(sp)+,d1-d3/a0
	rts	;returns d0 = possible new Vsync_offs
;
;
sub_sync_supx:	;entry d1==last_valid_read<<16
sub_sync_lp_1:
	or	#$0700,SR
sub_sync_lp_2:
	movep	hw_vpos2(a0),d0
	movep	hw_vpos2(a0),d1
	cmp	d0,d1
	bne.s	sub_sync_lp_2	;awaits valid read    (d0 == d1)
	move	d2,SR
	swap	d1
	cmp	d0,d1
	beq.s	sub_sync_lp_1	;awaits altered value (d0 != d1)
	rts	;flags HI after Vsync   d1 = (d0=last_valid_read)<<16 + prev_valid_read
;
;
	bss
;
lacedata	ds.w	1
lacesave	ds.w	1
rez_lock_f	ds.w	1
;
loc_stack:
	ds.l	stack_size/4
loc_st_top:
;
	end	;of file:	TESTIKBD.S
