;----------------------------------------------------------------------------
;File name:	STE.S				Revision date:	1997.11.19
;Revised by:	Ulf Ronald Andersson		Revision start:	1997.11.19
;----------------------------------------------------------------------------
;
;-----------------------------------------------------------------------;
; 	Replay STe							;
; 	by WizzCat the 21st of May 1991					;
;-----------------------------------------------------------------------;
; Uses no registers							;
;									;
; Replay is started by calling MUSON in supervisor mode. Returns with	;
; timer A running. Calling MUSOFF will stop music.			;
;									;
; This routine needs some workspace after the module to work properly.	;
; We've set it to 16k, some modules needs more, some need less. If the	;
; workspace is too small, initialization will hang on an ILLEGAL	;
; instruction. Adjust workspace size to fit the specific module.	;
;									;
; MVOL = Main volume	  (Unnecessary to adjust. $80 default)		;
; FREQ = replay frequency (See below)					;
;-----------------------------------------------------------------------;
;
MVOL	EQU $80
FREQ	EQU 2				; 0=6.259, 1=12.517, 2=25.036
;---------------------------------------; 3=50.072 (MegaSTe/TT)
;
	IFEQ FREQ
PARTS	EQU 5-1				; 6.259
LEN	EQU 25
INC	EQU $023BF313			; 3579546/6125*65536
	ELSEIF
	IFEQ FREQ-1
PARTS	EQU 5-1				; 12.517
LEN	EQU 50
INC	EQU $011DF989			; 3579546/12517*65536
	ELSEIF
	IFEQ FREQ-2
PARTS	EQU 5-1				; 25.035
LEN	EQU 100
INC	EQU $008EFB4E			; 3579546/25035*65536
	ELSEIF
	IFEQ FREQ-3
PARTS	EQU 5-1				; 50.072
LEN	EQU 200
INC	EQU $00477CEC			; 3579546/50072*65536
	ELSEIF
	FAIL
	END
	ENDC
	ENDC
	ENDC
	ENDC
;
;----------------------------------------------------------------------------
;
muson:
	bsr	vol			; Calculate volume tables
	bsr	incrcal			; Calculate tonetables
;
	jsr	init			; Initialize music
	jsr	prepare			; Prepare samples
;
	move	#$2700,sr
;
	bset	#5,$FFFFFA07.w
	bset	#5,$FFFFFA13.w
;
	clr.b	$FFFFFA19.w
	move.b	#1,$FFFFFA1F.w
	move.b	#8,$FFFFFA19.w
;
	move.l	$0134.w,oldtima
	move.l	#stereo,$0134.w
;
	move.b	#FREQ,$FFFF8921.w		; Frequency
;
	lea	$FFFF8907.w,a0
;
	move.l	#sample1,d0
	move.b	d0,(a0)
	lsr.w	#8,d0
	move.l	d0,-5(a0)
;
	move.l	#sample1+LEN*2,d0
	move.b	d0,12(a0)
	lsr.w	#8,d0
	move.l	d0,7(a0)
;
	move.b	#3,$FFFF8901.w		; Start DMA
;
	move	#$2300,sr
	rts
;
;----------------------------------------------------------------------------
;
musoff:
	move	#$2700,sr
;
	clr.b	$FFFFFA19.w		; Stop timers
;
	move.l	oldtima(pc),$0134.w	; Restore everything
;
	bclr	#5,$FFFFFA07.w
	bclr	#5,$FFFFFA13.w
;
	clr.b	$FFFF8901.w		; Stop DMA
;
	move	#$2300,sr
	rts
;
oldtima	DC.L 0
;
;----------------------------------------------------------------------------
;Create volume table
;
vol:
	moveq	#64,d0
	lea	vtabend(pc),a0
;
.ploop:
	move.w	#255,d1
.mloop:
	move.w	d1,d2
	ext.w	d2
	muls	d0,d2
	divs	#MVOL,d2		; <---- Master volume
	move.b	d2,-(a0)
	dbra	d1,.mloop
	dbra	d0,.ploop
	rts
;
;----------------------------------------------------------------------------
;
vtab:
	DS.B 65*256
vtabend:
;
;----------------------------------------------------------------------------
;Create increment tables
;
incrcal:
	lea	stab(pc),a0
	move.w	#$30,d1
	move.w	#$039F-$30,d0
	move.l	#INC,d2
;
recalc:
	swap	d2
	moveq	#0,d3
	move.w	d2,d3
	divu	d1,d3
	move.w	d3,d4
	swap	d4
;
	swap	d2
	move.w	d2,d3
	divu	d1,d3
	move.w	d3,d4
	move.l	d4,(a0)+
;
	addq.w	#1,d1
	dbra	d0,recalc
	rts
;
;----------------------------------------------------------------------------
;
itab	DS.L $30
stab	DS.L $03A0-$30
;
;----------------------------------------------------------------------------
;Sound DMA interrupt
;
stereo:
	move	#$2500,sr
	bclr	#5,$FFFFFA0F.w
	movem.l	d0-a6,-(sp)
;
	move.l	samp1(pc),d0
	move.l	samp2(pc),samp1
	move.l	d0,samp2
;
	lea	$FFFF8907.w,a0
;
	move.l	samp1(pc),d0
	move.b	d0,(a0)
	lsr.w	#8,d0
	move.l	d0,-5(a0)
;
	move.l	samp1(pc),d0
	add.l	#LEN*2,d0
	move.b	d0,12(a0)
	lsr.w	#8,d0
	move.l	d0,7(a0)
;
	subq.w	#1,count
	bpl.s	.nomus
;
	move.w	#PARTS,count
	bsr	music
;
.nomus	lea	itab(pc),a5
	lea	vtab(pc),a3
	moveq	#0,d0
	moveq	#0,d4
;
v1	movea.l	wiz2lc(pc),a0
;
	move.w	wiz2pos(pc),d0
	move.w	wiz2frc(pc),d1
;
	move.w	aud2per(pc),d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	0(a5,d7.w),d2
;
	movea.w	2(a5,d7.w),a4
;
	move.w	aud2vol(pc),d7
	asl.w	#8,d7
	lea	0(a3,d7.w),a2
;
	movea.l	wiz3lc(pc),a1
;
	move.w	wiz3pos(pc),d4
	move.w	wiz3frc(pc),d5
;
	move.w	aud3per(pc),d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	0(a5,d7.w),d6
	movea.w	2(a5,d7.w),a5
;
	move.w	aud3vol(pc),d7
	asl.w	#8,d7
	lea	0(a3,d7.w),a3
;
	movea.l	samp1(pc),a6
	moveq	#0,d3
;
	REPT LEN
	add.w	a4,d1
	addx.w	d2,d0
	add.w	a5,d5
	addx.w	d6,d4
	move.b	0(a0,d0.l),d3
	move.b	0(a2,d3.w),d7
	move.b	0(a1,d4.l),d3
	add.b	0(a3,d3.w),d7
	move.w	d7,(a6)+
	ENDR
;
	cmp.l	wiz2len(pc),d0
	blt.s	.ok2
	sub.w	wiz2rpt(pc),d0
;
.ok2:
	move.w	d0,wiz2pos
	move.w	d1,wiz2frc
;
	cmp.l	wiz3len(pc),d4
	blt.s	.ok3
	sub.w	wiz3rpt(pc),d4
;
.ok3:
	move.w	d4,wiz3pos
	move.w	d5,wiz3frc
;
	lea	itab(pc),a5
	lea	vtab(pc),a3
	moveq	#0,d0
	moveq	#0,d4
;
v2:
	movea.l	wiz1lc(pc),a0
;
	move.w	wiz1pos(pc),d0
	move.w	wiz1frc(pc),d1
;
	move.w	aud1per(pc),d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	0(a5,d7.w),d2
	movea.w	2(a5,d7.w),a4
;
	move.w	aud1vol(pc),d7
	asl.w	#8,d7
	lea	0(a3,d7.w),a2
;
	movea.l	wiz4lc(pc),a1
;
	move.w	wiz4pos(pc),d4
	move.w	wiz4frc(pc),d5
;
	move.w	aud4per(pc),d7
	add.w	d7,d7
	add.w	d7,d7
	move.w	0(a5,d7.w),d6
	movea.w	2(a5,d7.w),a5
;
	move.w	aud4vol(pc),d7
	asl.w	#8,d7
	lea	0(a3,d7.w),a3
;
	movea.l	samp1(pc),a6
	moveq	#0,d3
;
	REPT LEN
	add.w	a4,d1
	addx.w	d2,d0
	add.w	a5,d5
	addx.w	d6,d4
	move.b	0(a0,d0.l),d3
	move.b	0(a2,d3.w),d7
	move.b	0(a1,d4.l),d3
	add.b	0(a3,d3.w),d7
	move.b	d7,(a6)
	addq.w	#2,a6
	ENDR
;
	cmp.l	wiz1len(pc),d0
	blt.s	.ok1
	sub.w	wiz1rpt(pc),d0
;
.ok1	move.w	d0,wiz1pos
	move.w	d1,wiz1frc
;
	cmp.l	wiz4len(pc),d4
	blt.s	.ok4
	sub.w	wiz4rpt(pc),d4
;
.ok4	move.w	d4,wiz4pos
	move.w	d5,wiz4frc
;
	movem.l	(sp)+,d0-a6
	rte
;
;----------------------------------------------------------------------------
;	Low level data
;
count	DC.W PARTS
;
wiz1lc	DC.L sample1
wiz1len	DC.L 0
wiz1rpt	DC.W 0
wiz1pos	DC.W 0
wiz1frc	DC.W 0
;
wiz2lc	DC.L sample1
wiz2len	DC.L 0
wiz2rpt	DC.W 0
wiz2pos	DC.W 0
wiz2frc	DC.W 0
;
wiz3lc	DC.L sample1
wiz3len	DC.L 0
wiz3rpt	DC.W 0
wiz3pos	DC.W 0
wiz3frc	DC.W 0
;
wiz4lc	DC.L sample1
wiz4len	DC.L 0
wiz4rpt	DC.W 0
wiz4pos	DC.W 0
wiz4frc	DC.W 0
;
aud1lc	DC.L dummy
aud1len	DC.W 0
aud1per	DC.W 0
aud1vol	DC.W 0
	DS.W 3
;
aud2lc	DC.L dummy
aud2len	DC.W 0
aud2per	DC.W 0
aud2vol	DC.W 0
	DS.W 3
;
aud3lc	DC.L dummy
aud3len	DC.W 0
aud3per	DC.W 0
aud3vol	DC.W 0
	DS.W 3
;
aud4lc	DC.L dummy
aud4len	DC.W 0
aud4per	DC.W 0
aud4vol	DC.W 0
;
dmactrl	DC.W 0
;
dummy	DC.L 0
;
samp1	DC.L sample1
samp2	DC.L sample2
;
sample1	DS.W LEN
sample2	DS.W LEN
;
;----------------------------------------------------------------------------
;
prepare:
	lea	workspc,a6		;a6 -> end of workstack
	movea.l	samplestarts(pc),a0	;a0 -> sample start of first instrument
	movea.l	end_of_samples(pc),a1	;a1 -> end of sample data,  end of module
;
tostack:				;loop start
	move.w	-(a1),-(a6)		;push a long of sample data to workstack
	cmpa.l	a0,a1			;all done ?
	bgt.s	tostack			;loop for all samples of all instruments
;
;NB: the above should leave a6 -> sample data of 1st instrument in workstack
;
	lea	samplestarts(pc),a2	;a2 -> array of 31 instrument sample pointers
	lea	data(pc),a1		;a1 -> Module
	movea.l	(a2),a0			;a0 -> start of 1st sample
	movea.l	a0,a5			;a5 -> start of 1st sample
;
	moveq	#30,d7			;loop start for 31 instruments
roop:
	move.l	a0,(a2)+		; Sampleposition
;
	tst.w	20+22(a1)		;sample word count of instrument
	beq.s	samplok			; Len=0 -> no sample
;
	tst.w	20+26(a1)		; Test repstrt
	bne.s	repne			; Jump if not zero
;
repeq:
	move.w	20+22(a1),d0		;d0 = Length of sample
	move.w	d0,d4			;d4 = Length of sample
	subq.w	#1,d0			;d0 = adapted for dbra
;
	movea.l	a0,a4			;a4 -> sample source
fromstk:
	move.w	(a6)+,(a0)+		; Move all samples back from stack
	dbra	d0,fromstk
	bra.s	rep
;
repne:
	move.w	20+26(a1),d0		;d0 = Repeat_Start
	move.w	d0,d4			;d4 = Repeat_Start
	subq.w	#1,d0			;d0 = adapted for dbra
	movea.l	a6,a4			;a4 -> sample loop start in workstack
get1st:
	move.w	(a4)+,(a0)+		; Fetch first part
	dbra	d0,get1st
;
	adda.w	20+22(a1),a6		; Move a6 to next sample
	adda.w	20+22(a1),a6
;
rep:
	movea.l	a0,a5			;a5 -> destination sample loop start
	moveq	#0,d1			;d1 = 0 as loop copy counter
toosmal:
	movea.l	a4,a3			;a6 -> source sample loop start
	move.w	20+28(a1),d0		;d0 = Repeat_Length
	subq.w	#1,d0			;d0 = adjusted for dbra
moverep:
	move.w	(a3)+,(a0)+		; Repeatsample
	addq.w	#2,d1
	dbra	d0,moverep
	cmp.w	#320,d1			; Must be > 320
	blt.s	toosmal
;
	move.w	#320/2-1,d2
last320:
	move.w	(a5)+,(a0)+		; Safety 320 bytes
	dbra	d2,last320
;
done:
	add.w	d4,d4
	move.w	d4,$2A(a1)		;Length = preloop byte count
	move.w	d1,$30(a1)		;Replen = postloop word count
	clr.w	$2E(a1)
;
samplok:
	lea	$1E(a1),a1
	dbra	d7,roop
;
	cmp.l	#workspc,a0
	bgt.s	.nospac
	rts
;
.nospac	illegal
;
;----------------------------------------------------------------------------
;
end_of_samples:	DC.L 0
;
;----------------------------------------------------------------------------
;Initialize some pointers & variables for module
;
init:
	lea	data(pc),a0		;a0 -> module base
	lea	$03B8(a0),a1		;a1 -> pattern table
;
	moveq	#128-1,d0
	moveq	#0,d1			;d1 = 0
loop:				;loop start
	move.l	d1,d2			;d2 = d1,  update highest pattern code found
	subq.w	#1,d0			;d0 -= 1
	bmi.s	exit_lop2		;URAn: this line was missing !!!
lop2:				;loop start
	move.b	(a1)+,d1		;d1 = next pattern
	cmp.b	d2,d1			;new d1 pattern code > old d2 pattern code ?
	bgt.s	loop			;if so, loop back to update d2 pattern code
	dbra	d0,lop2			;else, loop back to try another code
.exit_lop2:
	addq.b	#1,d2			;d2 = number of defined patterns
;
	lea	samplestarts(pc),a1	;a1 -> instrument sample data pointers
	asl.l	#8,d2			;\/ d2 = total byte count for pattern data
	asl.l	#2,d2			;/\
	add.l	#$043C,d2		;d2 = byte offset (pattern_end - module_start)
	add.l	a0,d2			;d2 -> pattern_end  ==  sample_start
	movea.l	d2,a2			;a2 -> pattern_end  ==  sample_start
;
	moveq	#31-1,d0		;loop start for 31 instruments
lop3	clr.l	(a2)			;clear long in sample
	move.l	a2,(a1)+		;store an instrument sample data pointer
	moveq	#0,d1			;preclear top part of d1
	move.w	42(a0),d1		;d1 = instrument sample length  (word count)
	add.l	d1,d1			;d1 = instrument sample byte count
	adda.l	d1,a2			;a2 -> next instruments sample data
	adda.l	#30,a0			;a0 -> next instrument  (actually offset -20)
	dbra	d0,lop3			;loop back for all instruments
;
	move.l	a2,end_of_samples	;end_of_samples = a2  (should be = end of module)
	rts
;
;----------------------------------------------------------------------------
;
music:
	lea	data(pc),a0
	addq.w	#$01,counter
	move.w	counter(pc),d0
	cmp.w	speed(pc),d0
	blt.s	nonew
	clr.w	counter
	bra	getnew
;
nonew:
	lea	voice1(pc),a4
	lea	aud1lc(pc),a3
	bsr	checkcom
	lea	voice2(pc),a4
	lea	aud2lc(pc),a3
	bsr	checkcom
	lea	voice3(pc),a4
	lea	aud3lc(pc),a3
	bsr	checkcom
	lea	voice4(pc),a4
	lea	aud4lc(pc),a3
	bsr	checkcom
	bra	endr
;
arpeggio:
	moveq	#0,d0
	move.w	counter(pc),d0
	divs	#$03,d0
	swap	d0
	tst.w	d0
	beq.s	arp2
	cmp.w	#$02,d0
	beq.s	arp1
;
	moveq	#0,d0
	move.b	$03(a4),d0
	lsr.b	#4,d0
	bra.s	arp3
;
arp1:
	moveq	#0,d0
	move.b	$03(a4),d0
	and.b	#$0F,d0
	bra.s	arp3
;
arp2:
	move.w	$10(a4),d2
	bra.s	arp4
;
arp3:
	add.w	d0,d0
	moveq	#0,d1
	move.w	$10(a4),d1
	lea	periods(pc),a0
	moveq	#$24,d4
arploop:
	move.w	0(a0,d0.w),d2
	cmp.w	(a0),d1
	bge.s	arp4
	addq.l	#2,a0
	dbra	d4,arploop
	rts
;
arp4:
	move.w	d2,$06(a3)
	rts
;
getnew:
	lea	data+$043C(pc),a0
	lea	-$043C+$0C(a0),a2
	lea	-$043C+$03B8(a0),a1
;
	moveq	#0,d0
	move.l	d0,d1
	move.b	songpos(pc),d0
	move.b	0(a1,d0.w),d1
	asl.l	#8,d1
	asl.l	#2,d1
	add.w	pattpos(pc),d1
	clr.w	dmacon
;
	lea	aud1lc(pc),a3
	lea	voice1(pc),a4
	bsr.s	playvoice
	lea	aud2lc(pc),a3
	lea	voice2(pc),a4
	bsr.s	playvoice
	lea	aud3lc(pc),a3
	lea	voice3(pc),a4
	bsr.s	playvoice
	lea	aud4lc(pc),a3
	lea	voice4(pc),a4
	bsr.s	playvoice
	bra	setdma
;
;----------------------------------------------------------------------------
;
playvoice
	move.l	0(a0,d1.l),(a4)
	addq.l	#4,d1
	moveq	#0,d2
	move.b	$02(a4),d2
	and.b	#$F0,d2
	lsr.b	#4,d2
	move.b	(a4),d0
	and.b	#$F0,d0
	or.b	d0,d2
	tst.b	d2
	beq.s	setregs
	moveq	#0,d3
	lea	samplestarts(pc),a1
	move.l	d2,d4
	subq.l	#$01,d2
	asl.l	#2,d2
	mulu	#$1E,d4
	move.l	0(a1,d2.l),$04(a4)
	move.w	0(a2,d4.l),$08(a4)
	move.w	$02(a2,d4.l),$12(a4)
	move.w	$04(a2,d4.l),d3
	tst.w	d3
	beq.s	noloop
	move.l	$04(a4),d2
	add.w	d3,d3
	add.l	d3,d2
	move.l	d2,$0A(a4)
	move.w	$04(a2,d4.l),d0
	add.w	$06(a2,d4.l),d0
	move.w	d0,8(a4)
	move.w	$06(a2,d4.l),$0E(a4)
	move.w	$12(a4),$08(a3)
	bra.s	setregs
;
noloop	move.l	$04(a4),d2
	add.l	d3,d2
	move.l	d2,$0A(a4)
	move.w	$06(a2,d4.l),$0E(a4)
	move.w	$12(a4),$08(a3)
setregs	move.w	(a4),d0
	and.w	#$0FFF,d0
	beq	checkcom2
	move.b	$02(a4),d0
	and.b	#$0F,d0
	cmp.b	#$03,d0
	bne.s	setperiod
	bsr	setmyport
	bra	checkcom2
;
setperiod
	move.w	(a4),$10(a4)
	andi.w	#$0FFF,$10(a4)
	move.w	$14(a4),d0
	move.w	d0,dmactrl
	clr.b	$1B(a4)
;
	move.l	$04(a4),(a3)
	move.w	$08(a4),$04(a3)
	move.w	$10(a4),d0
	and.w	#$0FFF,d0
	move.w	d0,$06(a3)
	move.w	$14(a4),d0
	or.w	d0,dmacon
	bra	checkcom2
;
setdma	move.w	dmacon(pc),d0

	btst	#0,d0			;-------------------
	beq.s	wz_nch1			;
	move.l	aud1lc(pc),wiz1lc	;
	moveq	#0,d1			;
	moveq	#0,d2			;
	move.w	aud1len(pc),d1		;
	move.w	voice1+$0E(pc),d2	;
	add.l	d2,d1			;
	move.l	d1,wiz1len		;
	move.w	d2,wiz1rpt		;
	clr.w	wiz1pos			;

wz_nch1	btst	#1,d0			;
	beq.s	wz_nch2			;
	move.l	aud2lc(pc),wiz2lc	;
	moveq	#0,d1			;
	moveq	#0,d2			;
	move.w	aud2len(pc),d1		;
	move.w	voice2+$0E(pc),d2	;
	add.l	d2,d1			;
	move.l	d1,wiz2len		;
	move.w	d2,wiz2rpt		;
	clr.w	wiz2pos			;

wz_nch2	btst	#2,d0			;
	beq.s	wz_nch3			;
	move.l	aud3lc(pc),wiz3lc	;
	moveq	#0,d1			;
	moveq	#0,d2			;
	move.w	aud3len(pc),d1		;
	move.w	voice3+$0E(pc),d2	;
	add.l	d2,d1			;
	move.l	d1,wiz3len		;
	move.w	d2,wiz3rpt		;
	clr.w	wiz3pos			;

wz_nch3	btst	#3,d0			;
	beq.s	wz_nch4			;
	move.l	aud4lc(pc),wiz4lc	;
	moveq	#0,d1			;
	moveq	#0,d2			;
	move.w	aud4len(pc),d1		;
	move.w	voice4+$0E(pc),d2	;
	add.l	d2,d1			;
	move.l	d1,wiz4len		;
	move.w	d2,wiz4rpt		;
	clr.w	wiz4pos			;-------------------
;
wz_nch4	addi.w	#$10,pattpos
	cmpi.w	#$0400,pattpos
	bne.s	endr
nex	clr.w	pattpos
	clr.b	break
	addq.b	#1,songpos
	andi.b	#$7F,songpos
	move.b	songpos(pc),d1
	cmp.b	data+$03B6(pc),d1
	bne.s	endr
	move.b	data+$03B7(pc),songpos
endr:	tst.b	break
	bne.s	nex
	rts
;
;----------------------------------------------------------------------------
;
setmyport
	move.w	(a4),d2
	and.w	#$0FFF,d2
	move.w	d2,$18(a4)
	move.w	$10(a4),d0
	clr.b	$16(a4)
	cmp.w	d0,d2
	beq.s	clrport
	bge.s	rt
	move.b	#$01,$16(a4)
	rts
;
clrport	clr.w	$18(a4)
rt	rts
;
myport	move.b	$03(a4),d0
	beq.s	myslide
	move.b	d0,$17(a4)
	clr.b	$03(a4)
myslide	tst.w	$18(a4)
	beq.s	rt
	moveq	#0,d0
	move.b	$17(a4),d0
	tst.b	$16(a4)
	bne.s	mysub
	add.w	d0,$10(a4)
	move.w	$18(a4),d0
	cmp.w	$10(a4),d0
	bgt.s	myok
	move.w	$18(a4),$10(a4)
	clr.w	$18(a4)

myok	move.w	$10(a4),$06(a3)
	rts

mysub	sub.w	d0,$10(a4)
	move.w	$18(a4),d0
	cmp.w	$10(a4),d0
	blt.s	myok
	move.w	$18(a4),$10(a4)
	clr.w	$18(a4)
	move.w	$10(a4),$06(a3)
	rts

vib	move.b	$03(a4),d0
	beq.s	vi
	move.b	d0,$1A(a4)

vi	move.b	$1B(a4),d0
	lea	sin(pc),a1
	lsr.w	#$02,d0
	and.w	#$1F,d0
	moveq	#0,d2
	move.b	0(a1,d0.w),d2
	move.b	$1A(a4),d0
	and.w	#$0F,d0
	mulu	d0,d2
	lsr.w	#$06,d2
	move.w	$10(a4),d0
	tst.b	$1B(a4)
	bmi.s	vibmin
	add.w	d2,d0
	bra.s	vib2

vibmin	sub.w	d2,d0
vib2	move.w	d0,$06(a3)
	move.b	$1A(a4),d0
	lsr.w	#$02,d0
	and.w	#$3C,d0
	add.b	d0,$1B(a4)
	rts

nop:	move.w	$10(a4),$06(a3)
	rts
;
;----------------------------------------------------------------------------
;
checkcom:
	move.w	$02(a4),d0
	and.w	#$0FFF,d0
	beq.s	nop
	move.b	$02(a4),d0
	and.b	#$0F,d0
	tst.b	d0
	beq	arpeggio
	cmp.b	#$01,d0
	beq.s	portup
	cmp.b	#$02,d0
	beq	portdown
	cmp.b	#$03,d0
	beq	myport
	cmp.b	#$04,d0
	beq	vib
	cmp.b	#$05,d0
	beq	port_toneslide
	cmp.b	#$06,d0
	beq	vib_toneslide
	move.w	$10(a4),$06(a3)
	cmp.b	#$0A,d0
	beq.s	volslide
	rts

volslide
	moveq	#0,d0
	move.b	$03(a4),d0
	lsr.b	#4,d0
	tst.b	d0
	beq.s	voldown
	add.w	d0,$12(a4)
	cmpi.w	#$40,$12(a4)
	bmi.s	vol2
	move.w	#$40,$12(a4)
vol2	move.w	$12(a4),$08(a3)
	rts

voldown	moveq	#0,d0
	move.b	$03(a4),d0
	and.b	#$0F,d0
	sub.w	d0,$12(a4)
	bpl.s	vol3
	clr.w	$12(a4)
vol3	move.w	$12(a4),$08(a3)
	rts

portup	moveq	#0,d0
	move.b	$03(a4),d0
	sub.w	d0,$10(a4)
	move.w	$10(a4),d0
	and.w	#$0FFF,d0
	cmp.w	#$71,d0
	bpl.s	por2
	andi.w	#$F000,$10(a4)
	ori.w	#$71,$10(a4)
por2	move.w	$10(a4),d0
	and.w	#$0FFF,d0
	move.w	d0,$06(a3)
	rts

port_toneslide
	bsr	myslide
	bra.s	volslide

vib_toneslide
	bsr	vi
	bra.s	volslide

portdown
	clr.w	d0
	move.b	$03(a4),d0
	add.w	d0,$10(a4)
	move.w	$10(a4),d0
	and.w	#$0FFF,d0
	cmp.w	#$0358,d0
	bmi.s	por3
	andi.w	#$F000,$10(a4)
	ori.w	#$0358,$10(a4)
por3	move.w	$10(a4),d0
	and.w	#$0FFF,d0
	move.w	d0,$06(a3)
	rts

checkcom2
	move.b	$02(a4),d0
	and.b	#$0F,d0
	cmp.b	#$0D,d0
	beq.s	pattbreak
	cmp.b	#$0B,d0
	beq.s	posjmp
	cmp.b	#$0C,d0
	beq.s	setvol
	cmp.b	#$0F,d0
	beq.s	setspeed
	rts

pattbreak
	st	break
	rts

posjmp	move.b	$03(a4),d0
	subq.b	#$01,d0
	move.b	d0,songpos
	st	break
	rts

setvol	moveq	#0,d0
	move.b	$03(a4),d0
	cmp.w	#$40,d0
	ble.s	vol4
	move.b	#$40,$03(a4)
vol4	move.b	$03(a4),$09(a3)
	move.b	$03(a4),$13(a4)
	rts

setspeed
	cmpi.b	#$1F,$03(a4)
	ble.s	sets
	move.b	#$1F,$03(a4)
sets	move.b	$03(a4),d0
	beq.s	rts2
	move.w	d0,speed
	clr.w	counter
rts2	rts

sin	DC.B $00,$18,$31,$4A,$61,$78,$8D,$A1,$B4,$C5,$D4,$E0,$EB,$F4,$FA,$FD
	DC.B $FF,$FD,$FA,$F4,$EB,$E0,$D4,$C5,$B4,$A1,$8D,$78,$61,$4A,$31,$18

periods	DC.W $0358,$0328,$02FA,$02D0,$02A6,$0280,$025C,$023A,$021A,$01FC,$01E0
	DC.W $01C5,$01AC,$0194,$017D,$0168,$0153,$0140,$012E,$011D,$010D,$FE
	DC.W $F0,$E2,$D6,$CA,$BE,$B4,$AA,$A0,$97,$8F,$87
	DC.W $7F,$78,$71,$00,$00

speed	DC.W $06
counter	DC.W $00
songpos	DC.B $00
break	DC.B $00
pattpos	DC.W $00

dmacon		DC.W $00
samplestarts	DS.L $1F

voice1	DS.W 10
	DC.W $01
	DS.W 3
voice2	DS.W 10
	DC.W $02
	DS.W 3
voice3	DS.W 10
	DC.W $04
	DS.W 3
voice4	DS.W 10
	DC.W $08
	DS.W 3

data:	INCBIN E:\WAVE.MOD

	DS.B	16384			; Workspace
workspc	DS.W	1
;----------------------------------------------------------------------------
;End of file:	STE.S
;----------------------------------------------------------------------------
