; File name:     SNAP.S                Revised:  1991.02.02
; Revised by:    Ulf Ronald Andersson  Version:  2.0
; Created by:    Ulf Ronald Andersson  Created:  1991.02.02
; Inspired by:   SNAP v1 by M.Murray   Revision: 1990.02.22
; (c)1991 by:    Ulf Ronald Andersson  All rights reserved.
;                Released as SHAREWARE for free distribution
;
;
; **********************************************************
; *     Degas snapshot utility  - Save/Load screen if:     *
; *     Control + Alternate + some Shift key held down     *
; **********************************************************
;
;
  include "..\tos\u_DOS.s"
  include "..\tos\u_SYS.s"
;
;
; Diverse constants
;
;
DUMMYLONG = $77777777   ; Forces long abs address
PAL_MASK  = $07770777
;
;
; System macros
;

;
;
main:     bra    main01
;
snapflag  DC.B   $00         ;byte = flag for switching routine on/off
debounce  DC.B   $00         ;byte ensures key release between snaps
workname  DC.B   'SNAP_@.PI1',0   ; work always = SNAP_@
snapname  DC.B   'SNAP_@.PI1',0   ; snap varies = SNAP_A through SNAP_Z
          ALIGN.L
header    DS.W   17               ; Degas header...34 bytes
;
;
; VBI acts as guardian to reinstall other vectors if needed
;
new_vbi:
  add.b   #16,ev_vbi
  bcc.s   old_vbi
  movem.l d0/a0,-(sp)
  moveq   #0,d0
  lea     new_gemdos,a0
  cmp.l   ev_gemdos,a0
  bne.s   badvect
  moveq   #4,d0
  lea     new_bios,a0
  cmp.l   ev_bios,a0
  bne.s   badvect
  moveq   #8,d0
  lea     new_xbios,a0
  cmp.l   ev_xbios,a0
  beq.s   vects_ok
badvect:
  bsr.s   fixvect
vects_ok:
  movem.l (sp)+,d0/a0
old_vbi:
  jmp     dummylong
;
fixvect:
  rts
;
;
; All future BDOS TRAP #1 calls pass through here
;
new_GEMDOS:
  MOVE.B  snapflag,-2(sp)
  BNE.S   old_BDOS
  BSR.S   TRY_SNAP
old_BDOS:
  JMP     DUMMYLONG     ; JMP $xxxxxxxx - old vector address
;
;
; All future BIOS TRAP #13 calls pass through here
;
new_BIOS:
  MOVE.B  snapflag,-2(sp)
  BNE.S   old_BIOS
  BSR.S   TRY_SNAP
old_BIOS:
  JMP     DUMMYLONG     ; JMP $xxxxxxxx - old vector address
;
;
; All future XBIOS TRAP #14 calls pass through here
;
new_XBIOS:
  MOVE.B  snapflag,-2(sp)
  BNE.S   old_XBIOS
  BSR.S   TRY_SNAP
old_XBIOS:
  JMP     DUMMYLONG     ; JMP $xxxxxxxx - old vector address
;
;
; Subroutine to handle snapshots
;
TRY_SNAP:
  MOVEM.L D0-D3/A0-A3,-(sp)  ; Save registers
  LEA     main,A3            ; A0 -> main
  TAS     snapflag-main(A3)  ; routine off (avoids recursion)
  bmi     exit
  bios    Kbshift,#-1
  ANDI    #15,D0        ; bits 3/2/1/0 are key status ALT/CTL/LSH/RSH
  bne.s   nobounce
  sf      debounce-main(a3)  ;debounced!, ready for new snaps
  bra     quit
;
nobounce:
  tst.b   debounce-main(a3)
  bne     quit          ;refuse if not debounced
  move    d0,d3
  lea     workname,a2
  cmp     #13,d3        ;is d3 ALT/CTL/RSH (two hands = save work)
  blo     quit          ;refuse without ALT/CTL/xSH
  beq     worksnap
  cmp     #14,d3        ;is d3 ALT/CTL/LSH (one hand = load work)
  beq     worksnap
savesnap: ;here d3 is ALT/CTL/LSH/RSH (full hands = save new snap)
  lea     snapname,a2
worksnap:
  st      debounce-main(a3)  ; prep for future debounce
  xbios   Supexec,hardhead
  ADDI    #'1',D0       ; make rez into '1'/'2'/'3'
  MOVE.B  D0,9(A2)      ; put resolution in name...PI1-PI3
  cmp     #13,d3
  beq.s   use_name
  cmp     #14,d3
  beq     loadwork
;
  clr     d1
inc_name:
  LEA     5(a2),A0      ; A0 -> varying filename char
  ADDQ.B  #1,(A0)       ; increment letter in filename SNAP_?.PI?
  cmpi.b  #$5A,(a0)
  bls.s   try_name
  tas     d1
  bmi     quit
  move.b  #'A',(a0)
;
try_name:
  gemdos  Fopen,(a2),#0
  tst.w   d0
  bpl.s   inc_name      ;try another name if current already used
;
use_name:
  gemdos  Fcreate,(a2),#0
  MOVE    D0,D3         ; save file handle in D3
  bmi     quit
  gemdos  Fwrite,d3,#34,header
  xbios   Physbase
  move.l  d0,a0
  gemdos  Fwrite,d3,#32000,(a0)
  gemdos  Fclose,d3
quit:
  sf      snapflag-main(A3)  ; reset flag to turn routine back on
exit:
  movem.l (sp)+,d0-d3/a0-a3  ; Restore registers
  rts
;
loadwork:
  gemdos  Fopen,(a2),#0
  move    d0,d3         ; save file handle in D3
  bmi     quit
  gemdos  Fread,d3,#34,header
  xbios   Physbase
  move.l  d0,a0
  gemdos  Fread,d3,#32000,(a0)
  gemdos  Fclose,d3
  bra     quit
;
;
; Supersub to load degas header from hardware rez & pallette regs
;
hardhead:
  move.b  hw_rez,d0
  and     #$03,d0
  LEA     header,A0     ; A0 -> header
  MOVE    D0,(A0)+      ; put resolution in 1st word of header
  LEA     hw_pal,A1
  MOVE    #16/2-1,D0    ; prep to move 16 words (as 8 longs)
hardpal:
  MOVE.L  (A1)+,(A0)         ; copy palette into header
  ANDI.L  #PAL_MASK,(A0)+    ; mask off unwanted bits
  DBRA    D0,hardpal
  move    header,d0     ;exit with rez also in d0
  rts
;
;
; Code and data used only to initialize program start here
; Thus this area will be reused for other purposes
;
reclaim:
;
main01:
; Display start-up message
  gemdos  Cconws,message
  MOVE    #500,D0       ; delay loop
delay1    MOVE #1000,D1 ; waste time by doing sums!
delay2    MOVE #-1,D2
  MULU    D2,D2
  DBRA    D1,delay2
  DBRA    D0,delay1
;
  xbios   supexec,revect
;
  MOVE.L  #reclaim-main,d0   ; post_init program size
  ADD.L   #$100,d0           ; basepage size
;NB: neither DATA nor BSS are used, and so neither need be retained
  gemdos  Ptermres,d0,#0
;
;
; Supersub to revector TRAP's
;
revect:
  lea     main,a0
  move.l  ev_vbi,old_vbi-main+2(a0)
  move.l  ev_xbios,old_xbios-main+2(a0)
  move.l  ev_bios,old_bios-main+2(a0)
  move.l  ev_gemdos,old_bdos-main+2(a0)
  lea     new_xbios,a0
  move.l  a0,ev_xbios
  lea     new_bios,a0
  move.l  a0,ev_bios
  lea     new_gemdos,a0
  move.l  a0,ev_gemdos
  lea     new_vbi,a0
  move.l  a0,ev_vbi
  RTS
;
;
message:
  DC.B    13,10,' Snap v2.0 is now installing...'
  DC.B    13,10
  DC.B    13,10,' Press: Control + Alternate + some'
  DC.B    13,10,' Shift key to save/load the screen.'
  DC.B    13,10
  DC.B    13,10,' Left shift  => Load SNAP_@.PIx'
  DC.B    13,10,' Right shift => Save SNAP_@.PIx'
  DC.B    13,10,' Both shifts => Save SNAP_z.PIx'
  DC.B    13,10
  DC.B    13,10,' Where: x is the resolution (1..3)'
  DC.B    13,10,'  and:  z keeps files unique (A..Z)'
  DC.B    13,10
  DC.B    0
;
;
prog_end:
  END     ;of    SNAP.S
 