; COLOR Mega STE

	opt p=68000,w+

	output "COL_MSTE.PRG"


XBIOS MACRO   ; fn,pile
   move #\1,-(sp)
   trap #14
   if \2<=8
      addq.l #\2,sp
   else
      add.w #\2,sp
   endif
   ENDM

GEMDOS MACRO    ; fn,pile
   move #\1,-(sp)
   trap #1
   if \2<=8
      addq.l #\2,sp
   else
      add.w #\2,sp
   endif
   ENDM

	text
	
debut:
	jmp init									; saute la partie rsidente

; cette routine se place en tte des instructions AES/VDI
	
inter:
	movem.l d0-d1/a0-a2,-(sp)				; je m'en sers
	cmp #$73,d0								; appel VDI?
	bne .fin									; non, rien  faire
	move.l linea,a0
	cmp #4,(a0)					; nombre de plans
	bmi .fin						; 1 ou 2 plans, pas de couleur  mettre

	move.l d1,a0			; vdi_param_blk
	move.l (a0),a0			; control
	cmp #121,(a0)			; vrt_cpyfm?
	bne .fin					; non, rien  faire
	move.l 14(a0),a1		; MFBD source
	move.l (a1),d0			; adresse des donnes
	sub.l $7768,d0
	sub.l #2168,d0
	bmi.s .non					; pas alerte, alors voir bureau
	cmp.l #384,d0
	bpl.s .non					; pas alerte non plus
	move.l d1,a0
	move.l 4(a0),a0		; intin
	move #4,2(a0)			; couleur icone (du bleu au lieu du noir)
	bra .fin
.non:
	move.l (a1),d0			; adresse donnes
	move.l $76ce,a2		; adresse ressource
	add.w 14(a2),a2
	sub.l a2,d0
	bmi .fin					; pas une icone du bureau
	lsr.l #7,d0				; /128 = numero icone (0,2,4,6,8...)
	btst #0,d0				; pair?
	beq .pas_data			; oui, donc un masque.
	lsr.l #1,d0				; numro icone (0,1,2,3,4...)
	cmp ni,d0
	bpl .fin					; au dessus de la zone
	lsl.l #8,d0
	lsl.l d0					; une icone=512 octets
	add.l data_ptr,d0
	move.l d0,a1
	bsr adapt_icone		; selon les plans et NOVA ou ATARI
	move.l d1,a0
	move.l 4(a0),a0		; intin
	move #7,(a0)			; mode or
	cmp #16,plans
	bne.s .k1
	addq #2,(a0)			; mode 9 plus joli!
.k1:
	move.l #une_icone,mfdb			; adresse donnes
	move.l d1,a0
	move.l (a0),a1			; control
	move #109,(a1)			; vro_cpyfm (au lieu de vrt_cpyfm)
	move #1,6(a1)			; 1 seul intin
	move.l #mfdb,14(a1)	; nouvel mfdb
	bra.s .fin
.pas_data:
	lsr.l #1,d0				; numro icone (0,1,2,3,4...)
	cmp ni,d0
	bpl .fin					; au dessus de la zone
	lsl.l #7,d0				; un masque=128 octets
	add.l #zone,d0			; plus masque de dpart
	move.l d0,(a1)			; masque choisi comme donnes du MFDB
	move.l d1,a0
	move.l 4(a0),a0		; intin 
	move.l #1,2(a0)		; toujours mode normal pour viter inversion
.fin:
	movem.l (sp)+,d0-d1/a0-a2	; restaure les registres utiliss
	move.l sauve,-(sp)		; ancienne adresse VDI/AES
	rts							;  laquelle on saute
.annul:		
	movem.l (sp)+,d0-d1/a0-a2	; restaure
	rte							; et quitte VDI/AES
	
mfdb: dc.l 0					; mon mfdb couleur
	dc.w 32,32,2,0
plans: dc.w 4,0,0,0	; 32x32 en 4 plans
sauve: dc.l 0					; adresse ancien VDI/AES


adapt_icone:
	move.l d0,-(sp)
	move.l linea,a0
	move (a0),d0			; les plans
	move d0,plans			; pour le mfdb
	cmp p_actu,d0			; mme plans
	bne.s .adapt			; non, donnes non valides
	cmp.l adr_actu,a1		; mme adresse?
	bne.s .adapt			; non, donnes non valides
	move.l (sp)+,d0
	rts						; sinon, tout est bon!
.adapt:
	move.l a1,adr_actu
	move d0,p_actu			; la nouvelle icone
	lea une_icone,a0		; l ou vont les donnes
	cmp #4,d0
	beq.s prendre4
	cmp #8,d0
	beq prendre8
	cmp #16,d0
	beq prendre16
	
prendre4:
	tst.b nova
	bne.s .nova
	moveq #63,d0			; 64 * 4 mots = 512 octets
.lb1:
	move (a1),(a0)+
	move 128(a1),(a0)+
	move 256(a1),(a0)+
	move 384(a1),(a0)+	; TT sans carte, mler les 4 plans!
	addq.l #2,a1
	dbf d0,.lb1
	move.l (sp)+,d0
	rts
	dc.b "(PATCH HERE WITH $4E, $71)"
.nova:						; TT avec carte, meme codage!
	bra.s .matrix			; aiguillage vers Matrix temporaire
	moveq #127,d0			; 128 mots longs = 512 octets
.lb0:
	move.l (a1)+,(a0)+	; copie les donnes
	dbf d0,.lb0
	move.l (sp)+,d0
	rts
.matrix:
	movem.l d1-d6,-(sp)
	moveq #63,d0
.lb2:
	move 128(a1),d2
	move 256(a1),d3
	move 384(a1),d4
	move (a1)+,d1
	moveq #3,d6
.lb3:
	rept 4
	lsl d4
	roxl d5
	lsl d3
	roxl d5
	lsl d2
	roxl d5
	lsl d1
	roxl d5
	endr
	move d5,(a0)+		
	dbf d6,.lb3
	dbf d0,.lb2
	movem.l (sp)+,d1-d6
	move.l (sp)+,d0
	rts
	
prendre8:
	tst.b nova
	bne.s .nova
	moveq #63,d0			; 64 * 4 mots = 512 octets
.lb7:
	move (a1),(a0)+
	move 128(a1),(a0)+
	move 256(a1),(a0)+
	move 384(a1),(a0)+	; TT sans carte, mler les 4 plans!
	clr.l (a0)+
	clr.l (a0)+				; plus 4 plans vides! (les plus signifiants)
	addq.l #2,a1
	dbf d0,.lb7
	move.l (sp)+,d0
	rts
.nova:
	movem.l d1-d5,-(sp)
	moveq #31,d4			; pour les 32 lignes
.lb0:
	swap d4					; TT avec carte, plus de plans, 1 point=1 octet!
	move.l (a1),d0
	move.l 128(a1),d1
	move.l 256(a1),d2
	move.l 384(a1),d3
	moveq #31,d5			; pour les 32 points par ligne
.lb1:
	clr d4
	roxl.l d3
	roxl.b d4
	roxl.l d2
	roxl.b d4
	roxl.l d1
	roxl.b d4
	roxl.l d0
	roxl.b d4
	cmp.b #15,d4
	bne.s .lb6
	st d4						; le 1 devient 255
.lb6:
	move.b d4,(a0)+
	dbf d5,.lb1				; autre point sur la mme ligne
	swap d4
	addq.l #4,a1			; ligne suivante
	dbf d4,.lb0
	movem.l (sp)+,d1-d5
	move.l (sp)+,d0
	rts
	
	
prendre16:
	movem.l d1-d5,-(sp)
	lea .table,a2			; conversions en 16 bits
	moveq #31,d4			; pour les 32 lignes de l'icone
.lb0:
	swap d4					; l'autre mot de d4 est utilis ici
	move.l (a1),d0			; d0-d3 contienent les 4 bits de 32 points
	move.l 128(a1),d1
	move.l 256(a1),d2
	move.l 384(a1),d3
	moveq #31,d5			; pour les 32 points par ligne
.lb1:
	clr d4
	roxl.l d3
	roxl.b d4
	roxl.l d2
	roxl.b d4
	roxl.l d1
	roxl.b d4
	roxl.l d0
	roxl.b d4
	add d4,d4
	move 0(a2,d4.w),(a0)+
	dbf d5,.lb1				; autre point sur la mme ligne
	swap d4
	addq.l #4,a1			; ligne suivante
	dbf d4,.lb0
	movem.l (sp)+,d1-d5
	move.l (sp)+,d0
	rts
.table: dc.w $ff7f,$007c,$e003,$e07f,$1f00,$1f7c,$ff03,$f75e
		  dc.w $1042,$107e,$f043,$f07f,$1f42,$1f7e,$ff43,$0000

mt: dc.b 0			; pas de multitos ( priori), FF si prsent
nova: dc.b 0		; ni de carte NOVA, FF si prsente

	even

init:
   move.l  4(a7),a5
   move.l  $18(a5),d0
   add.l $1c(a5),d0
   add.l #$100,d0
   lea pile,sp
   sub.l a5,d0
   move.l  d0,-(sp)
   move.l  a5,-(sp)
   clr -(sp)
   GEMDOS $4a,12			; rduit l'espace  strict ncessaire

	pea cookie				; cherche MiNT (multitos) et NOVA (carte Nova)
	XBIOS 38,6
	tst.b mt
	bne quitter				; multitos!, pas de couleur  mettre!
	
	pea titre			; affiche COLOR TT et mon nom
	GEMDOS 9,6
	
	dc.w $A000				; line-A
	move.l d0,linea		; adresse du nombre de plans
	
	pea installe			; va dtourner l'AES/VDI
	XBIOS 38,6
		
	clr -(sp)
	pea nom
	GEMDOS 61,8				; ouvre C:\DESKCICN.RSC
	move d0,d7
	
	pea fichier				; zone mmoire ou placer le fichier
	move.l #200*1024,-(sp)	; 200 Ko semblent suffisants
	move d7,-(sp)
	GEMDOS 63,12			; lire
	
	move d7,-(sp)			; fermer
	GEMDOS 62,4
	
	lea zone,a0				; les masques
	lea fichier,a2			; le RSC
	move 20(a2),d7			; nombre d'objets
	subq #1,d7				; nombre d'icones (moins le BOX)
	move d7,ni
	move d7,d6
	muls #128,d6			; fois le nombre de masques
	lea 0(a0,d6.l),a1		; pointe sur les donnes
	move.l a1,data_ptr
	add.w 34(a2),a2		; vers l'extension
	move.l 4(a2),a2
	add.l #fichier+4,a2
	add.w d7,a2
	add.w d7,a2
	add.w d7,a2
	add.w d7,a2				; dbut des structures
	subq #1,d7				; pour la boucle
	
icone:
	lea 306(a2),a2			; saute l'icone monochrome
.lb2:
	move (a2),d6
	cmp #4,d6				; 4 plans pour l'icone?
	bne.s .lb0				; non...
	bsr copie_icone
.lb0:	
	addq #1,d6				; plus le plan masque
	muls #128,d6			; chaque plan fait 128 octets
	cmp.l #1,10(a2)		; flag pour selected?
	bne.s .lb1				; pas 1, une icone
	add.l d6,d6				; double la mise, avec l'icone selected
.lb1:
	move 18(a2),d0			; flag pour autre rsolution
	lea 22(a2,d6.l),a2	; saute l'icone
	tst d0
	bne.s .lb2				; flag=1 autre rsolution
	dbf d7,icone			; autre icone!
	
	move.l a1,data_end
	sub.l #debut,a1		; a1 pointait vers la fin des donnes
	add.w #$100,a1			; plus basepage
	
	clr -(sp)
	move.l a1,-(sp)		; taille  conserver
	move #49,-(sp)			; PTERMRES (rsident!)
	trap #1

quitter:
	clr -(sp)
	trap #1
		
installe:
	move.l $88,sauve		; ancien VDI/AES
	move.l #inter,$88		; le mien  la place
	rts
	
copie_icone:
	lea 22(a2),a3			; donnes de l'icone
	moveq #127,d0			; 128 mots longs = 512 octets
.lb0:
	move.l (a3)+,(a1)+	; copie les donnes
	dbf d0,.lb0
	moveq #31,d0			; pour le masque
.lb1:
	move.l (a3)+,(a0)+	; copie le masque
	dbf d0,.lb1
	rts	
	
cookie:
	move.l $5A0,a0
	cmp.l #0,a0
	beq.s .fin				; pas de cookie...
.lb0:
	tst.l (a0)
	beq.s .fin
	cmp.l #'MiNT',(a0)	; Multitos?
	bne.s .lb1
	st mt						; si oui, mt=FF
.lb1:
	cmp.l #'MagX',(a0)
	bne.s .lb3
	st mt						; magic = multiTOS
.lb3:
	cmp.l #'NOVA',(a0)	; cartes NOVA (anciennes IMAGINE)?
	bne.s .lb2
	st nova					; si oui, nova=FF
.lb2:
	addq.l #4,a0			; cookie suivant
	bra.s .lb0
.fin: 
	moveq #0,d0
	move $44e.w,d0
	cmp #$40,d0
	bmi.s .fin_fin
	st nova					; si au dela des 4Mo = carte graphique
.fin_fin:
	rts

nom: dc.b "C:\DESKCICN.RSC",0
titre: dc.b 13,10,10,27,"c8",27,"b3 COLOR Mega STE (c) 1997 "
			 dc.b 13,10,27,"b2  Tello Guillaume  "
			 dc.b 13,10,27,"c0",27,"b1",0

	even
	bss

linea: ds.l 1			; adresse des variables linea
adr_actu: ds.w 1			; adresse de l'icone actuelle
p_actu: ds.w 1			; nombre de plans actuels
une_icone: ds.b 32*32*2	; taille en 16 bits
ni: ds.w 1					; nombre d'icones
data_ptr: ds.l 1			; adresse pour les donnes
data_end: ds.l 1			; fin des donnes
zone: ds.b 200*1024		; avec 200k a suffit
fichier:  ds.b 200*1024	; l aussi
pile: ds.w 1
	end

