;----------------------------------------------------------------------------
;File name:	MPLAYER.S			Revision date:	1997.08.27
;Disassembler:	Ulf Ronald Andersson		Disassembled:	1995.01.08
;----------------------------------------------------------------------------
;Remarks:
;----------------------------------------------------------------------------
	include	URAn_SYS.S
	include	URAn_DOS.S
	include	URAn_XB.S
	include URAn_GEM.S
	include	URAn_AV.S
;----------------------------------------------------------------------------
	output	.APP
;----------------------------------------------------------------------------
ref_fq	=	614400
;
;;;norm_lf	=	  7680
;;;norm_hf	=	 19819
norm_lf	=	  7680
norm_hf	=	 19819
;;;fast_lf	=	  9452	;\/ Good values for 16 MHz
;;;fast_hf	=	 20480	;/\ speeder with cache
fast_lf	=	  9452
fast_hf	=	 20480
;----------------------------------------------------------------------------
	section	TEXT
;----------------------------------------------------------------------------
;
basepage:	= *-$100
;
start:
	move.l	a0,d0
	sne	d1
	bne.s	.got_basepage
	move.l	4(sp),d0
.got_basepage:
	lea	bss_end,sp
	lea	contrl(pc),a6
	move.l	d0,basepage_p-contrl(a6)
	move.b	d1,acc_f-contrl(a6)
	bmi.s	.done_shrink
	move.l	sp,d1
	sub.l	d0,d1
	gemdos	Mshrink|_ind,!,d0,d1
.done_shrink:
	sf	terminate_f		;assume non-terminating use
	tst.b	acc_f-contrl(a6)
	bne.s	.done_keys		;keep ACC non-terminating
	bios	Kbshift,?
	btst	#0,d0			;right shift key ?
	bne.s	.done_keys		;keep RSHIFT APP non-terminating
	st	terminate_f		;set termination flag
.done_keys
	moveq	#10,d0			;AES appl_init
	move.l	#$00010000,d1
	bsr	aes_call_d0_d1_ia6
	move	intout(pc),AV_sender_id
	move	intout(pc),MP_sender_id
	move	acc_f(pc),d0
	bpl	done_menu_reg
	moveq	#35,d0			;AES menu_register
	move.l	#$1010100,d1
	move	global+4-contrl(a6),intin-contrl(a6)	;ap_id
	lea	accessory_name(pc),a0
	move.l	a0,addrin-contrl(a6)
	bsr	aes_call_d0_d1_ia6
	bra	done_menu_reg
;
;----------------------------------------------------------------------------
	include	PATH_LIB.S
;----------------------------------------------------------------------------
;
	dc.w	'\\'
;
auto_path_s:	ds.b	128
valid_inf_f:	dc.w	0
auto_inf_s:	dc.b	'A:\AUTO_MOD.INF',NUL
auto_step_c:	dc.b	$0C
modfile_mask_s:	dc.b	'*.?OD',NUL
auto_fname_len	= *-modfile_mask_s
	even
my_name_s:	dc.b	'MPLAYER ',NUL
	even
auto_dta:	ds.b	44
mini_rect:	ds.w	4
real_rect:	ds.w	4
kbshift_p:	ds.l	1
basepage_p:	ds.l	1
temp_drv:	ds.w	1
temp_dta_p:	ds.l	1
autoswap_f:	dc.w	0
autoload_iz_f:	dc.w	0
autoload_f:	dc.w	0
auto_req_f:	dc.w	0	;flags KB cmd for MOD change
circuit_f:	dc.w	0	;flags MOD completed
speedup_f:	dc.w	$0000	;flags high-speed mode
multiplay_f:	dc.w	$FF00	;flags multiple MOD mode
loop_event_f:	dc.w	0	;set before MOD change
kb_midi_f:	dc.w	0
acc_f:		dc.w	0	;flags ACC mode
terminate_f:	dc.w	0	;flags terminated APP mode
;
;
done_menu_reg:
	lea	l0187(pc),a5
	move	global-contrl(a6),d0	;GEM version
	cmp	#$0100,d0
	beq.s	.l0004			;jump on GEM $0100
	st	(a5)
	cmp	#$0120,d0
	beq.s	.l0004			;jump on GEM $0120
	bsr	get_currbp_p_p
.l0004:
	bsr	clear_songname
	bsr	l008f
	bsr	adapt_environs
	tst.b	non_SDMA_f
	bmi.s	.l0005
	st	use_SDMA_f
	move	#1,t5_dma_stat
.l0005:
	lea	main_tree(pc),a0
	moveq	#(trees_end-main_tree)/24-1,d2
	moveq	#114,d0			;AES rsrc_obfix
	move.l	#$01010100,d1
.l0006:
	move	d2,intin-contrl(a6)
	move.l	a0,addrin-contrl(a6)
	bsr	aes_call_d0_d1_ia6
	dbra	d2,.l0006
;
	bsr	autoinit_sub
	bsr	validate_inf
	move	acc_f(pc),d0
	bpl	wake_up
accessory_loop:
	bsr	rand_long
	sf	loop_event_f
	move	acc_f(pc),d0
	bmi.s	await_multi		;do not terminate an ACC
	move	terminate_f(pc),d0
	beq.s	await_multi		;do not terminate unless wanted
	bsr	kill_music
	moveq	#19,d0			;AES appl_exit
	move.l	#$00010000,d1
	bsr	aes_call_d0_d1_ia6
	gemdos	Pterm0			;Terminate non-ACC
;
await_multi:
	moveq	#25,d0			;AES evnt_multi
	move.l	#$10070100,d1
	move.l	#message,addrin-contrl(a6)
	move	#$30,intin-contrl(a6)		;timer or message event
	move	#250,intin+28-contrl(a6)	;250 ms per timed event
	clr	intin+30-contrl(a6)
	bsr	aes_call_d0_d1_ia6		;call evnt_multi
;
	btst	#4,intout+1-contrl(a6)
	bne.s	eval_mesag
	cmp.b	#$0C,intout+9-contrl(a6)
kbsh_c_3	=	*-4
	bne.s	.no_new_cmd
	st	auto_req_f
.no_new_cmd:
	tst.b	auto_req_f
	bmi.s	autoload_event
	tst.b	multiplay_f
	beq.s	accessory_loop
	tst.b	circuit_f
	bpl.s	accessory_loop
autoload_event:
	st	loop_event_f
	lea	rref(pc),a3
	clr.b	error_f-rref(a3)
	bra	autoload_cmd
;
eval_mesag:
	cmp	#AC_OPEN,message-contrl(a6)	;AC_CALL ?
	beq	wake_up
	cmp	#AP_TERM,message-contrl(a6)	;AP_TERM ?
	beq	exec_AP_TERM
	cmp	#VA_START,message-contrl(a6)	;VA_START ?
	beq	exec_VA_START
	cmp	#MP_START,message-contrl(a6)	;MP_START ?
	beq	exec_MP_START
	cmp	#MP_STOP,message-contrl(a6)	;MP_STOP ?
	beq	exec_MP_STOP
	cmp	#MP_SHUTDOWN,message-contrl(a6)	;MP_SHUTDOWN ?
	beq	exec_MP_SHUTDOWN
	bra	accessory_loop
;
exec_VA_START:
	move	message+2(pc),AV_server_id
	move.l	message+6(pc),a0
	move.l	a0,d0
	beq	wake_up_AV
	tst.b	(a0)
	beq.s	wake_up_AV
	lea	current_path_s(pc),a1
	strcpy	a0,a1
	AV_send	PROTOKOLL,#w_VA_START,my_name_s
	bra	xx_START_load
;
wake_up_AV:
	AV_send	PROTOKOLL,#w_VA_START,my_name_s
	bra	wake_up
;
exec_AP_TERM:
	st	terminate_f
	bsr	kill_music
	bra	accessory_loop
;
exec_MP_SHUTDOWN:
	st	terminate_f
exec_MP_STOP:
	move	message+2(pc),MP_partner_id
	bsr	kill_music
	MP_send	ACK
	bra	accessory_loop
;
exec_MP_START:
	move	message+2(pc),MP_partner_id
	move.l	message+6(pc),a0
	move.l	a0,d0
	beq	wake_up_MP
	tst.b	(a0)
	beq.s	wake_up_MP
	lea	current_path_s(pc),a1
	strcpy	a0,a1
	MP_send	ACK
xx_START_load:
	lea	current_path_s(pc),a0
	lea	current_fname_s(pc),a1
	bsr	old_name
	st	loop_event_f
	lea	rref(pc),a3
	clr.b	error_f-rref(a3)
	bsr	kill_music
	bsr	load_filehead_selected
	bra	load_main
;
wake_up_MP:
	MP_send	ACK
	bra	wake_up
;
wake_up:
	bsr	validate_inf
	moveq	#78,d0			;AES graf_mouse
	move.l	#$01010100,d1
	clr	intin-contrl(a6)
	bsr	aes_call_d0_d1_ia6
;
	lea	error_f(pc),a3
	clr.b	(a3)
	lea	main_tree(pc),a0
	lea	l00c8(pc),a1
	lea	l00cd(pc),a2
	bsr	open_formwind_ia0
	tst.b	(a3)
	bmi	accessory_loop
redraw_tree_1:
	tst.b	loop_event_f
	bmi	accessory_loop
	lea	rref(pc),a3
	lea	tree_1(pc),a0
	bsr	form_draw_ia0
	tst.b	error_f-rref(a3)
	bmi	accessory_loop
reform_tree_1:
	tst.b	loop_event_f
	bmi	accessory_loop
	clr.b	error_f-rref(a3)
	lea	tree_1(pc),a0
	tst.b	auto_req_f
	bmi.s	autoload_cmd
	bsr	form_do_ia0		;d0 = form_do(tree_1)
;
	cmp	#t1_author_1,d0
	bne.s	.not_speedup
	not.b	speedup_f
	bra.s	reform_tree_1
;
.not_speedup:
	cmp	#t1_author_2,d0
	bne.s	.not_multiplay
	not.b	multiplay_f
	bra.s	reform_tree_1
;
.not_multiplay:
	cmp	#t1_songname,d0
	bne.s	not_new_cmd
autoload_cmd:
	bsr	stop_music
	bsr	autoload_filehead
	bra.s	load_main
;
not_new_cmd:
	cmp	#t1_info_butt,d0
	bne.s	l000a
	bsr	t1_info_sub
	bsr	form_draw_ia0
	tst.b	error_f-rref(a3)
	bmi	accessory_loop
l000a:
	cmp	#t1_stop_butt,d0
	bne.s	l000b
	sf	autoload_f
	bsr	l0017
	bra.s	reform_tree_1
;
l000b:
	cmp	#t1_play_butt,d0	;Play button ?
	bne.s	.l000c
	sf	autoload_f
	bsr	l0013
	tst.b	2(a3)
	bmi	reform_tree_1
	bsr	form_draw_ia0
	tst.b	error_f-rref(a3)
	bmi	accessory_loop
	bra	l000f
;
.l000c:
	cmp	#t1_load_butt,d0
	bne	l0011
	sf	autoload_f
	movem.l	a0-a6/d0-d7,-(sp)
	bsr	select_and_load_filehead
	movem.l	(sp)+,a0-a6/d0-d7
	tst.b	(a3)
	bmi.s	l000d
	tst.b	1(a3)
	bmi	redraw_tree_1
	st	autoswap_f
load_main:
	sf	auto_req_f
	sf	circuit_f
	tst.b	(a3)+
	bmi.s	l000d
	tst.b	(a3)
	bmi	redraw_tree_1
	tst.b	l0187
	bmi	redraw_tree_1
	movem.l	a0-a6/d0-d7,-(sp)
	move.l	allocated_ram_p(pc),loadfile_bf_p
	move.l	l00c5(pc),loadfile_ct
	bsr	loadfile_sub
	movem.l	(sp)+,a0-a6/d0-d7
	tst.b	-(a3)
	bmi.s	l000d
	movem.l	a0/d0-d1,-(sp)
	movea.l	allocated_ram_p(pc),a0
	move.l	l00c5(pc),d0
	move.l	d0,d1
	bsr	identify_mod
	movem.l	(sp)+,a0/d0-d1
	tst.b	2(a3)
	bpl.s	l000e
l000d:
	bsr	kill_music
	bra	redraw_tree_1
;
;
l000e:
	movem.l	a0-a1,-(sp)
	lea	current_path_s(pc),a0
	bsr	fix_path
	lea	auto_path_s(pc),a1
	strcpy	a0,a1
	movem.l	(sp)+,a0-a1
;
	bsr	l005e
	tst.b	loop_event_f
	bmi.s	.skip_form
	bsr	form_draw_ia0
.skip_form:
	tst.b	(a3)
	bmi	accessory_loop
	clr.b	4(a3)
	bsr	play_commander
	st	l00b8
l000f:
	cmpi.b	#1,5(a3)
	bne	reform_tree_1
	tst.b	new_CPU_f
	beq.s	l0010
	tst.b	use_SDMA_f
	bmi	reform_tree_1
l0010:
	tst.b	top_khz_f
	bpl	reform_tree_1
	bsr	play_best_until_space
	bra	reform_tree_1
;
;
l0011:
	cmp.b	#t1_quality_butt,d0
	bne.s	l0012
	cmpi.b	#1,5(a3)
	beq	reform_tree_1
	bsr	l0033
	bra	redraw_tree_1
;
;
l0012:
	cmpi	#t1_crazy_butt,d0
	bne	reform_tree_1
	lea	l00d6(pc),a4
	clr	(a4)
	bsr	close_formwind_ia0
	bra	accessory_loop
;
l0013:
	move.b	2(a3),d0
	bmi.s	l0014
	cmp.b	#1,d0
	beq.s	l0015
	cmp.b	#5,d0
	bgt.s	l0015
	tst.b	5(a3)
	bmi.s	l0015
	bsr	form_tree_4
	tst.b	4(a3)
	bmi.s	l0015
	bsr	play_commander
l0014:
play_got_it:
	rts
;
;
l0015:
	moveq	#$34,d0			;AES form_alert
	move.l	#$1010100,d1
	move	#3,intin-contrl(a6)
	lea	play_butt_alert_s(pc),a4
	move.l	a4,addrin-contrl(a6)
	bsr	aes_call_d0_d1_ia6
	move	intout-contrl(a6),d0
	cmpi	#1,d0
	bne.s	l0016
play_continue:
	addq	#1,d0		;d0=2
	move.b	d0,4(a3)
	bsr	play_commander
	rts
;
;
l0016:
	cmpi	#2,d0
	bne.s	l0014
play_new:
	subq	#1,d0		;d0=1
	move.b	d0,4(a3)
	bsr	play_commander
	rts
;
;
l0017:
	tst.b	2(a3)
	bmi.s	l0019
	moveq	#$34,d0			;AES form_alert
	move.l	#$1010100,d1
	move	#3,intin-contrl(a6)
	lea	stop_butt_alert_s(pc),a4
	move.l	a4,addrin-contrl(a6)
	bsr	aes_call_d0_d1_ia6
	move	intout-contrl(a6),d0
	cmpi	#1,d0
	bne.s	l0018
	bsr	kill_music
	bsr	form_draw_ia0
	rts
;
;
l0018:
	cmpi	#2,d0
	bne.s	l0019
	bsr	stop_music
l0019:
	rts
;
;----------------------------------------------------------------------------
;
select_random_mod:
	movem.l	d1-d4/a0-a3,-(sp)
	gemdos	Fgetdta
	move.l	d0,-(sp)
;
	gemdos	Fsetdta,local_dta(pc)
	moveq	#-1,d4
	tst.b	valid_inf_f
	beq.s	.exit
	bsr	count_files
	move.l	d0,d1
	beq.s	.exit
	st	autoload_iz_f
	bsr	rand_long
	clr	d0
	swap	d0
	divu	d1,d0
	clr	d0
	swap	d0
	move.l	d0,d3
	clr.l	d4
;
	lea	current_path_s(pc),a0
	bsr	fix_path
	lea	auto_path_s(pc),a1
	strcpy	a0,a1
;
	subq	#1,a1
	move.l	a1,a0
	lea	modfile_mask_s(pc),a1
	bsr	new_name
.loop_2:
	gemdos	Fsfirst,auto_path_s(pc),#1
	tst.l	d0
	bmi.s	.exit
.loop_3:
	cmp.l	d3,d4
	beq.s	.done_seek
	addq.l	#1,d4
	gemdos	Fsnext
	tst.l	d0
	bpl.s	.loop_3		;loop back to pass more files
	bra.s	.loop_2		;but loop back to first at end
;
.done_seek:
	addq	#1,d4
	lea	local_dta+dta_fname(pc),a0
	lea	current_fname_s(pc),a1
	strcpy	a0,a1
.exit:
	lea	current_path_s(pc),a0
	bsr	cut_name
;
	gemdos	Fsetdta,()
	move.l	d4,d0	
	movem.l	(sp)+,d1-d4/a0-a3
	rts
;
;----------------------------------------------------------------------------
;
Count_files:
	movem.l	d1-d3/a0-a3,-(sp)
	gemdos	Fgetdta
	move.l	d0,-(sp)
;
	gemdos	Fsetdta,local_dta(pc)
	clr.l	d3
	tst.b	valid_inf_f
	beq.s	.exit
;
	lea	current_path_s(pc),a0
	lea	modfile_mask_s(pc),a1
	bsr	new_name
;
	gemdos	Fsfirst,current_path_s(pc),#1
	tst.l	d0
	bmi.s	.exit
.loop_2:
	addq.l	#1,d3
	gemdos	Fsnext
	tst.l	d0
	bpl.s	.loop_2
.exit:
	lea	current_path_s(pc),a0
	bsr	cut_name
;
	gemdos	Fsetdta,()
	move.l	d3,d0
	movem.l	(sp)+,d1-d3/a0-a3
	rts
;
;----------------------------------------------------------------------------
;
rand_long:
	move.l	rand_seed(pc),d0
	bsr.s	rand_31_long
	move.l	d0,rand_seed
	rts
;
rand_seed:
	dc.l	'Rand'
;
;----------------------------------------------------------------------------
;
rand_31_long:
	bsr.s	rand_31_byte
	bsr.s	rand_31_byte
	bsr	rand_31_byte
rand_31_byte:
	movem.l	d1-d3/a0,-(sp)
	move.l	#1<<31,d3
	moveq	#$0F,d2
	lea	rand_t(pc),a0
;
	rept	8
	move	d0,d1
	and	d2,d1
	tst.b	(a0,d1)
	beq.s	*+4
	or.l	d3,d0
	lsr.l	#1,d0
	endr
;
	movem.l	(sp)+,d1-d3/a0
	rts
;
rand_t:
	dc.b	0,1,0,1,0,1,0,1
	dc.b	1,0,1,0,1,0,1,0
;
;----------------------------------------------------------------------------
;
validate_inf:
	tst	valid_inf_f
	bne	.validate_rts
	movem.l	d0-d3/a0-a3,-(sp)
	gemdos	Fopen,auto_inf_s(pc),!
	move	d0,d3
	bmi	.exit
	gemdos	Fread,d3,#1,auto_step_c(pc)
	cmp.l	#1,d0
	bne	.done_read
	clr	d0
	move.b	auto_step_c(pc),d0
	cmp.b	#'a',d0
	blo.s	.done_case
	sub.b	#$20,d0
.done_case:
	sub.b	#'0',d0
	blo.s	.done_read
	cmp.b	#9,d0
	bls.s	.have_char
	add.b	#'0'+10-'A',d0
	cmp.b	#10,d0
	blo.s	.done_read
	cmp.b	#15,d0
	bhi.s	.done_read
.have_char:
	move	d0,kbsh_c_1
	move	d0,kbsh_c_2
	move	d0,kbsh_c_3
	gemdos	Fread,d3,#127,auto_path_s(pc)
	tst.l	d0
	bmi.s	.done_read
;
	lea	auto_path_s(pc),a0
	lea	current_path_s(pc),a1
	moveq	#128-1,d1
.loop:
	move.b	(a0)+,d0
	beq.s	.done_term
	move.b	d0,(a1)+
	cmp.b	#' ',d0
	dbls	d1,.loop
;
	clr.b	-(a0)
	subq	#1,a1
	cmp.b	#'\',-1(a1)
	beq.s	.have_slash
	move.b	#'\',(a1)+
.have_slash:
	lea	modfile_mask_s(pc),a0
	strcpy	a0,a1
.done_term:
	st	valid_inf_f
.done_read:
	gemdos	Fclose,d3
	lea	auto_path_s(pc),a0
	bsr	fix_path
	
.exit:
	movem.l	(sp)+,d0-d3/a0-a3
.validate_rts:
	rts
;
;----------------------------------------------------------------------------
;
autoinit_sub:
	clr	autoload_iz_f
	clr	autoload_f
	clr	autoswap_f
	gemdos	Super,!
	move.l	d0,-(sp)
	move	(_bootdev).w,d0
	add	#'A',d0
	move.b	d0,auto_inf_s
	gemdos	Super,()
	rts
;
;----------------------------------------------------------------------------
;
autofind_sub:
	gemdos	Fgetdta
	move.l	d0,-(sp)
;
	bsr	validate_inf
	tst.b	valid_inf_f
	beq	.exit
	gemdos	Fsetdta,auto_dta(pc)
;
	tst.b	autoswap_f
	bmi.s	.try_other
	tst.b	autoload_iz_f
	bpl.s	.try_first
	gemdos	Fsnext
	tst.l	d0
	bpl.s	.found_one
	st	autoload_iz_f
	bra.s	.try_first
;
.try_other:
	lea	auto_path_s(pc),a0
	bsr	get_path
.try_first:
	lea	auto_path_s(pc),a0
	lea	modfile_mask_s(pc),a1
	bsr	new_name
;
	gemdos	Fsfirst,auto_path_s(pc),#1
;
	lea	auto_path_s(pc),a0
	bsr	cut_name
;
	tst.l	d0
	bpl.s	.found_one
	tas	autoload_iz_f
	bpl.s	.try_other
	sf	autoload_f
	bra.s	.exit
;
.found_one:
	tas	autoload_iz_f
	st	autoload_f
	sf	autoswap_f
	lea	auto_path_s(pc),a0
	bsr	fix_path
	lea	current_path_s(pc),a1
	strcpy	a0,a1
;
;;;	clr	d0
;;;	move.b	current_path_s(pc),d0
;;;	sub	#'A',d0
;;;	gemdos	Dsetdrv,d0
;;;	gemdos	Dsetpath,current_path_s(pc)
;
	lea	auto_dta+dta_fname(pc),a0
	lea	current_fname_s(pc),a1
	strcpy	a0,a1
;
.exit:
	gemdos	Fsetdta,()
	rts
;
;----------------------------------------------------------------------------
;
autoload_filehead:
	movem.l	d0-d7/a0-a6,-(sp)
	tst.b	multiplay_f
	bne.s	.load_randomly
.load_sequentially:
	bsr	autofind_sub
	tst.b	autoload_f
	bpl.s	.error
	bsr	load_head_sub
	bra.s	.test_load
;
.load_randomly:
	lea	auto_path_s(pc),a0
	lea	current_path_s(pc),a1
	strcpy	a0,a1
	clr.b	current_fname_s
	bsr.s load_filehead_selected
.test_load:
	tst.b	error_f
	bpl.s	.exit
.error:
	clr	autoload_f
	st	error_f
.exit:
	movem.l	(sp)+,d0-d7/a0-a6
	rts
;
;----------------------------------------------------------------------------
;
select_and_load_filehead:
	lea	l00bf(pc),a5
	clr.b	(a5)
	moveq	#$5a,d0			;AES fsel_input
	move.l	#$20200,d1
	move.l	#current_path_s,addrin-contrl(a6)
	move.l	#current_fname_s,addrin+4-contrl(a6)
	bsr	aes_call_d0_d1_ia6
	tst	intout-contrl(a6)
	beq	st_error_f_rts
	tst	intout+2-contrl(a6)
	bne.s	load_filehead_selected
l001f:
	st	(a5)
	rts
;
load_filehead_selected:
;;;	move.b	current_path_s(pc),d0
;;;	sub.b	#'A',d0
;;;	and	#$1f,d0
;;;	gemdos	Dsetdrv,d0
;;;	lea	current_path_s(pc),a0
;;;	bsr	cut_path_name
;
;;;	gemdos	Dsetpath,current_path_s(pc)
;;;	tst.l	d0
;;;	bmi	st_error_f_rts
;;;	st	valid_inf_f
;
	tst.b	current_fname_s
	bne.s	load_head_sub
	bsr	select_random_mod
;
load_head_sub:
	gemdos	Fgetdta
	move.l	d0,-(sp)
;
	lea	access_path_s(pc),a0
	lea	current_path_s(pc),a1
	strcpy	a1,a0
	lea	access_path_s(pc),a0
	lea	current_fname_s(pc),a1
	bsr	new_path_name
;
	gemdos	Fsetdta,local_dta(pc)
	gemdos	Fsfirst,access_path_s(pc),#1
	tst.l	d0
	bmi	st_error_f_rts
;
	lea	current_path_s(pc),a0
	lea	modfile_mask_s(pc),a1
	bsr	new_path_name
;
	move.l	local_dta+dta_fsize(pc),d0	;d0 = file size
	beq	st_error_f_rts
	movem.l	d0-d7/a0-a6,-(sp)
	lea	l0187(pc),a0
	movea.l	a0,a1
	moveq	#0,d2
	move	#$20b,d1
.l0022:
	move.l	d2,(a1)+
	dbra	d1,.l0022
	move.l	a0,loadfile_bf_p	;loadfile_bf_p -> l0187
	move.l	#$878,d1
	cmp.l	d1,d0
	bge.s	.l0023
	exg	d1,d0
.l0023:
	move.l	d1,loadfile_ct		;loadfile_ct = min($878,file_size)
	bsr.s	loadfile_sub
	movem.l	(sp)+,a0-a6/d0-d7
	tst.b	error_f
	bmi.s	.exit
	move.l	d0,d1
	bsr	l0090
	cmp.l	d0,d1
	bgt	l001f
	move.l	d1,-(sp)
	lea	l0187(pc),a0
	move.l	#$830,d0
	bsr	identify_mod
	move.l	(sp)+,d1
	tst.b	(a0)
	bmi.s	.exit
	lea	mod_type(pc),a1
	move.b	(a0),(a1)
	lea	l00c5(pc),a0
	move.l	d1,(a0)
	bsr	stop_music
	bsr	release_ram
	clr.b	l00b8
	bsr	allocate_ram
	tst.b	error_f
	bmi	show_bug_alert_sub
	bsr	clear_songname
	lea	l017d(pc),a0
	moveq	#$30,d0
	move.b	d0,(a0)+
	moveq	#$31,d0
	move.b	d0,(a0)
	lea	l00c1(pc),a0
	moveq	#1,d0
	move.b	d0,(a0)
.exit:
	gemdos	Fsetdta,()
	rts
;
;----------------------------------------------------------------------------
;
loadfile_sub:
	gemdos	Fopen,access_path_s,!
	tst	d0
	bmi	show_bug_alert_sub
	move	d0,-(sp)
	gemdos	Fread|_ind,d0,loadfile_ct(pc),loadfile_bf_p
	move	(sp)+,d1
	tst.l	d0
	bmi	show_bug_alert_sub
	gemdos	Fclose,d1
	tst.l	d0
	bmi	show_bug_alert_sub
	rts
;
;----------------------------------------------------------------------------
;
open_formwind_ia0:
	moveq	#54,d0			;AES form_center
	move.l	#$50100,d1
	move.l	a0,addrin-contrl(a6)
	bsr	aes_call_d0_d1_ia6
	move.l	intout+2-contrl(a6),(a2)
	move.l	intout+6-contrl(a6),4(a2)
;
	moveq	#107,d0			;AES wind_update
	move.l	#$01010000,d1
	move	#1,intin-contrl(a6)	;take screen
	bsr	aes_call_d0_d1_ia6
	tst	intout-contrl(a6)
	beq	st_error_f_rts
;
	moveq	#51,d0			;AES form_dial
	move.l	#$09010000,d1
	move.l	mini_rect(pc),intin+2-contrl(a6)
	move.l	mini_rect+4(pc),intin+6-contrl(a6)
	move.l	(a2),intin+10-contrl(a6)
	move.l	4(a2),intin+14-contrl(a6)
	move	#0,intin-contrl(a6)	;reserve area
	bsr	aes_call_d0_d1_ia6
	move	#1,intin-contrl(a6)	;Zoom out
	bsr	aes_call_d0_d1_ia6
;
	moveq	#100,d0			;AES wind_create
	move.l	#$5010000,d1
	clr	intin-contrl(a6)
	move.l	(a2),intin+2-contrl(a6)
	move.l	4(a2),intin+6-contrl(a6)
	bsr	aes_call_d0_d1_ia6
	move	intout-contrl(a6),d0
	bmi	st_error_f_rts
	move	d0,(a1)
;
	moveq	#101,d0			;AES wind_open
	move.l	#$5010100,d1
	move	(a1),intin-contrl(a6)
	move.l	(a2),intin+2-contrl(a6)
	move.l	4(a2),intin+6-contrl(a6)
	bsr	aes_call_d0_d1_ia6
	tst	intout-contrl(a6)
	bmi	st_error_f_rts
;
	moveq	#107,d0			;AES wind_update
	move.l	#$01010000,d1
	clr	intin-contrl(a6)	;return screen
	bsr	aes_call_d0_d1_ia6
	rts
;
;----------------------------------------------------------------------------
;
close_formwind_ia0:
	moveq	#107,d0			;AES wind_update
	move.l	#$01010000,d1
	move	#1,intin-contrl(a6)	;take screen
	bsr	aes_call_d0_d1_ia6
	tst	intout-contrl(a6)
	beq	st_error_f_rts
;
	moveq	#104,d0			;AES wind_get
	move.l	#$02050000,d1
	move	(a1),intin-contrl(a6)
	move	#5,intin+2-contrl(a6)	;get total window rectangle
	bsr	aes_call_d0_d1_ia6
	move.l	intout+2-contrl(a6),real_rect
	move.l	intout+6-contrl(a6),real_rect+4
;
	moveq	#102,d0			;AES wind_close
	move.l	#$1010000,d1
	move	(a1),intin-contrl(a6)
	bsr	aes_call_d0_d1_ia6
	tst	intout-contrl(a6)
	beq	st_error_f_rts
;
	moveq	#103,d0			;AES wind_delete
	move.l	#$1010000,d1
	move	(a1),intin-contrl(a6)
	bsr	aes_call_d0_d1_ia6
;
	moveq	#107,d0			;AES wind_update
	move.l	#$1010000,d1
	clr	intin-contrl(a6)	;return screen
	bsr	aes_call_d0_d1_ia6
;
	moveq	#51,d0			;AES form_dial
	move.l	#$09010000,d1
	move.l	mini_rect(pc),intin+2-contrl(a6)
	move.l	mini_rect+4(pc),intin+6-contrl(a6)
	move.l	real_rect(pc),intin+10-contrl(a6)
	move.l	real_rect+4(pc),intin+14-contrl(a6)
	move	#2,intin-contrl(a6)	;Zoom in
	bsr	aes_call_d0_d1_ia6
	move	#3,intin-contrl(a6)	;release area
	bsr	aes_call_d0_d1_ia6
;
	rts
;
;----------------------------------------------------------------------------
;
form_draw_ia0:
	moveq	#107,d0			;AES wind_update
	move.l	#$01010000,d1
	move	#1,intin-contrl(a6)	;take screen
	bsr	aes_call_d0_d1_ia6
;
	moveq	#42,d0			;AES objc_draw
	move.l	#$6010100,d1
	clr	intin-contrl(a6)
	move	#1,intin+2-contrl(a6)
	move.l	(a2),intin+4-contrl(a6)
	move.l	4(a2),intin+8-contrl(a6)
	move.l	a0,addrin-contrl(a6)
	bsr	aes_call_d0_d1_ia6
	tst	intout-contrl(a6)
	bmi	st_error_f_rts
;
	moveq	#107,d0			;AES wind_update
	move.l	#$1010000,d1
	clr	intin-contrl(a6)	;return screen
	bsr	aes_call_d0_d1_ia6
	rts
;
;----------------------------------------------------------------------------
;
form_do_ia0:
	moveq	#$32,d0			;AES form_do
	move.l	#$1010100,d1
	clr	intin-contrl(a6)
	move.l	a0,addrin-contrl(a6)
	bsr	aes_call_d0_d1_ia6
	move	intout-contrl(a6),d0
	bclr	#15,d0
	rts
;
;----------------------------------------------------------------------------
;
t1_info_sub:
	movem.l	a0-a4/d0,-(sp)
	lea	tree_2(pc),a0
	lea	l00c9(pc),a1
	lea	l00ce(pc),a2
	bsr	open_formwind_ia0
	tst.b	(a3)
	bmi.s	l002b
	bsr	form_draw_ia0
	tst.b	(a3)
	bmi.s	l002b
l0027:
	bsr	form_do_ia0		;d0 = form_do(tree_2)
	cmp	#$11,d0
	bne.s	l0027
	lea	l00d8(pc),a4
	clr	(a4)
	lea	tree_3(pc),a0
	lea	l00ca(pc),a1
	lea	l00cf(pc),a2
	bsr	open_formwind_ia0
	tst.b	(a3)
	bmi.s	l002a
	bsr	form_draw_ia0
	tst.b	(a3)
	bmi.s	l0029
l0028:
	bsr	form_do_ia0
	cmp	#$d,d0
	bne.s	l0028
	lea	l00da(pc),a4
	clr	(a4)
l0029:
	bsr	close_formwind_ia0
l002a:
	lea	tree_2(pc),a0
	lea	l00c9(pc),a1
	lea	l00ce(pc),a2
l002b:
	bsr	close_formwind_ia0
	movem.l	(sp)+,a0-a4/d0
	rts
;
;----------------------------------------------------------------------------
;
form_tree_4:
	movem.l	a4/a0-a2/d0-d3,-(sp)
	lea	tree_4(pc),a0
	lea	l00cb(pc),a1
	lea	l00d0(pc),a2
	bsr	open_formwind_ia0
	tst.b	(a3)
	bmi.s	l0032
redraw_tree_4:
	lea	l00dc(pc),a4
	clr	(a4)
	bsr	form_draw_ia0
	tst.b	(a3)
	bmi.s	l0031
reform_tree_4:
	bsr	form_do_ia0
	cmp	#4,d0
	beq.s	l0031
	cmp	#5,d0
	bne.s	reform_tree_4
	moveq	#$a,d3
	lea	l017d(pc),a4
	move.b	(a4),d0
	move.b	1(a4),d1
	bne.s	l002f
	move	d0,d1
	moveq	#$30,d0
l002f:
	moveq	#$30,d2
	sub.b	d2,d0
	sub.b	d2,d1
	ext	d0
	ext	d1
	mulu	d3,d0
	add	d1,d0
	cmp	#$14,d0
	bgt.s	redraw_tree_4
	lea	l00c1(pc),a4
	cmp.b	(a4),d0
	beq.s	l0030
	move.b	d0,(a4)+
	moveq	#1,d0
	move.b	d0,(a4)
l0030:
	lea	l00dc(pc),a4
	clr	(a4)
l0031:
	bsr	close_formwind_ia0
l0032:
	movem.l	(sp)+,a4/a0-a2/d0-d3
	rts
;
;----------------------------------------------------------------------------
;
l0033:
	movem.l	a4/a0-a2/d0-d3,-(sp)
	lea	tree_5(pc),a0
	lea	l00cc(pc),a1
	lea	l00d1(pc),a2
	bsr	open_formwind_ia0
	tst.b	(a3)
	bmi	l0041
	lea	t5_finito_stat(pc),a4
	clr	(a4)
redraw_tree_5:
	tst.b	non_SDMA_f
	beq.s	l0035
	moveq	#disabled,d1
	move	d1,t5_cache_stat
	move	d1,t5_dma_stat
	bra.s	draw_tree_5
;
l0035:
	tst.b	use_SDMA_f
	bpl.s	.non_dma_top_khz
.got_dma_top_khz:
	move	#'25',d1
	move	d1,top_khz_s
	tst.b	new_CPU_f
	bne.s	.l0036
	move	d1,top_khz_play_space_s
.l0036:
	tst	use_cache_f
	bmi.s	draw_tree_5
	clr	t5_cache_stat
	bra.s	draw_tree_5
;
.non_dma_top_khz:
	move	#'20',d1
	move	d1,top_khz_s
	tst.b	new_CPU_f
	bne.s	l0038
	move	d1,top_khz_play_space_s
l0038:
	move	#disabled,t5_cache_stat
	clr	use_cache_f
draw_tree_5:
	bsr	form_draw_ia0
	tst.b	(a3)
	bmi.s	l0041
reform_tree_5:
	bsr	form_do_ia0		;d0 = form_do(tree_5)
	moveq	#selected,d1
	tst.b	non_SDMA_f
	bmi.s	l003e
	cmp	#t5_cache_butt,d0
	bne.s	l003c
	not	use_cache_f
	bmi.s	l003b
	moveq	#normal,d1
l003b:
	move	d1,t5_cache_stat
	bra	redraw_tree_5
;
l003c:
	cmp	#t5_dma_butt,d0
	bne.s	l003e
	not.b	use_SDMA_f
	bmi.s	l003d
	moveq	#normal,d1
l003d:
	move	d1,t5_dma_stat
	bra	redraw_tree_5
;
l003e:
	cmp	#t5_top_khz_butt,d0		;set top khz ?
	bne.s	l0040
	not.b	top_khz_f
	bmi.s	l003f
	moveq	#normal,d1
l003f:
	move	d1,t5_top_khz_stat
	bra	redraw_tree_5
;
l0040:
	cmp	#t5_finito_butt,d0
	bne.s	reform_tree_5
l0041:
	bsr	close_formwind_ia0
	movem.l	(sp)+,a4/a0-a2/d0-d3
	rts
;
;----------------------------------------------------------------------------
;
allocate_ram:
	movem.l	a0-a6/d0-d7,-(sp)
	move.l	l00c5(pc),d4
	bmi.s	.l0044
	lea	mod_type(pc),a4
	cmpi.b	#1,(a4)
	bne.s	.l0043
	add.l	#$4a1c,d4
.l0043:
	add.l	#$100,d4
	clr.b	d4
	movea.l	loc_currbp_p_p(pc),a5
	movea.l	(a5),a4
	move.l	#basepage,(a5)
;
	gemdos	Malloc,?
	sub.l	#$10000,d0			;reserve 64KB minimum free
	sub.l	d4,d0
	gemdos	Malloc,d0
	move.l	d0,a3
	gemdos	Malloc,d4
	move.l	d0,allocated_ram_p
	gemdos	Mfree,(a3)
	tst.l	allocated_ram_p
	ble	st_error_f_rts
;
	move.l	a4,(a5)
.l0044:
	movem.l	(sp)+,a0-a6/d0-d7
	rts
;
;----------------------------------------------------------------------------
;
release_ram:
	movem.l	a0-a6/d0-d7,-(sp)
	lea	allocated_ram_p(pc),a4
	move.l	(a4),d0
	ble.s	.l0046
	movea.l	loc_currbp_p_p(pc),a5
	move.l	(a5),-(sp)
	move.l	#basepage,(a5)
	gemdos	Mfree|_ind,d0		;gemdos	Mfree(allocated_ram_p)
	move.l	(sp)+,(a5)
.l0046:
	moveq	#-1,d0
	move.l	d0,(a4)
	movem.l	(sp)+,a0-a6/d0-d7
	rts
;
;----------------------------------------------------------------------------
;
identify_mod:
	movem.l	a0-a6/d0-d7,-(sp)
	moveq	#0,d7
	move.l	d1,d6
	cmpi.l	#'M.K.',1080(a0)
	beq.s	.l004c
	cmpi.l	#'FLT4',1080(a0)
	bne.s	.l004d
.l004c:
	moveq	#1,d0
	bra	.l005c
;
.l004d:
	move.l	d0,d7
	movea.l	d0,a1
	adda.l	a0,a1
	move	#$6000,d0
	move	#$60fe,d1
	cmpi.l	#'LAP ',316(a0)
	bne.s	.l004e
	moveq	#5,d0
	bra	.l005c
;
.l004e:
	move.l	d6,d2
	move.l	d2,d3
	sub.l	#$12c,d3
	cmp.l	(a0),d2
	blt.s	.l004f
	cmp.l	(a0),d3
	bgt.s	.l004f
	cmp.l	4(a0),d2
	blt.s	.l004f
	cmp.l	4(a0),d3
	bgt.s	.l004f
	cmp.l	8(a0),d2
	blt.s	.l004f
	cmp.l	8(a0),d3
	bgt.s	.l004f
	moveq	#7,d0
	bra	.l005c
;
.l004f:
	move.l	#'Coun',d2
	cmp.l	10(a0),d2
	bne.s	.l0051
	move.l	#'t Ze',d2
	cmp.l	14(a0),d2
	bne.s	.l0051
	move	#'ro',d2
	cmp	18(a0),d2
	bne.s	.l0051
	cmp	(a0),d1
	bge.s	.l0050
	moveq	#3,d0
	bra	.l005c
;
.l0050:
	moveq	#4,d0
	bra	.l005c
;
.l0051:
	cmp	(a0)+,d0
	bne	.l005b
	addq	#2,a0
	cmp	(a0)+,d0
	bne	.l005b
	addq	#2,a0
	cmp	(a0)+,d0
	bne	.l005b
	addq	#2,a0
	cmp	(a0),d0
	bne.s	.l0052
	moveq	#0,d0
	cmp.l	d6,d7
	beq	.l0057
	bra	.l005c
;
.l0052:
	movea.l	a0,a2
	movea.l	a1,a3
	moveq	#'N',d2
.l0053:
	cmpa.l	a2,a3
	ble.s	.l0054
	cmp.b	(a2)+,d2
	bne.s	.l0053
	cmpi.b	#'o',(a2)+
	bne.s	.l0053
	cmpi.b	#'i',(a2)+
	bne.s	.l0053
	cmpi.b	#'s',(a2)+
	bne.s	.l0053
	cmpi.b	#'e',(a2)+
	bne.s	.l0053
	cmpi.b	#' ',(a2)+
	bne.s	.l0053
	cmpi.b	#'D',(a2)+
	bne.s	.l0053
	cmpi.b	#'e',(a2)+
	bne.s	.l0053
	moveq	#6,d0
	bra	.l005c
;
.l0054:
	movea.l	a0,a2
	movea.l	a1,a3
	moveq	#'S',d2
.l0055:
	cmpa.l	a2,a3
	ble.s	.l0056
	cmp.b	(a2)+,d2
	bne.s	.l0055
	cmpi.b	#'O',(a2)+
	bne.s	.l0055
	cmpi.b	#'U',(a2)+
	bne.s	.l0055
	cmpi.b	#'N',(a2)+
	bne.s	.l0055
	cmpi.b	#'D',(a2)+
	bne.s	.l0055
	cmpi.b	#'M',(a2)+
	bne.s	.l0055
	cmpi.b	#'A',(a2)+
	bne.s	.l0055
	cmpi.b	#'G',(a2)+
	bne.s	.l0055
	moveq	#8,d0
	bra.s	.l005c
;
.l0056:
	moveq	#0,d0
	cmp.l	d6,d7
	bne.s	.l005c
	moveq	#3,d0
.l0057:
	moveq	#'T',d1
.l0058:
	cmpa.l	a0,a1
	ble.s	.l005b
	cmp.b	(a0)+,d1
	bne.s	.l0058
	cmpi.b	#'F',(a0)+
	bne.s	.l0058
	cmpi.b	#'M',(a0)+
	bne.s	.l0058
	cmpi.b	#'X',(a0)+
	bne.s	.l0058
	cmp	#3,d0
	beq.s	.l005c
	subq	#4,a0
	move.l	a0,d0
	movea.l	allocated_ram_p(pc),a0
	adda.l	d6,a0
	moveq	#-$78,d1
.l0059:
	cmpa.l	d0,a0
	ble.s	.l005a
	cmp.b	-(a0),d1
	bne.s	.l0059
	cmp.b	-(a0),d1
	bne.s	.l0059
	cmp.b	-(a0),d1
	bne.s	.l0059
	cmp.b	-(a0),d1
	bne.s	.l0059
	cmp.b	-(a0),d1
	bne.s	.l0059
	cmp.b	-(a0),d1
	bne.s	.l0059
	moveq	#-1,d0
	bra.s	.l005c
;
.l005a:
	moveq	#2,d0
	bra.s	.l005c
;
.l005b:
	moveq	#-1,d0
.l005c:
	lea	mod_type(pc),a0
	lea	l0187(pc),a1
	tst.b	3(a0)
	bpl.s	.l005d
	tst.b	l00b8
	bmi.s	.l005d
	move.b	d0,(a0)
	move.b	d0,(a1)
	movem.l	(sp)+,a0-a6/d0-d7
	rts
;
;
.l005d:
	move.b	d0,(a1)
	movem.l	(sp)+,a0-a6/d0-d7
	rts
;
;----------------------------------------------------------------------------
;
l005e:
	movem.l	a0-a1/d0,-(sp)
	lea	songname_s(pc),a0
	lea	mod_type(pc),a1
	cmpi.b	#1,(a1)
	beq.s	l005f
	lea	current_fname_s(pc),a1
	moveq	#11,d0
	moveq	#'.',d1
	bra.s	l0060
;
l005f:
	movea.l	allocated_ram_p(pc),a1
	moveq	#$13,d0
	moveq	#-1,d1
l0060:
	cmp.b	(a1),d1
	bne.s	l0061
	moveq	#3,d0
l0061:
	tst.b	(a1)
	bne.s	l0062
	move.b	#$20,(a1)
l0062:
	move.b	(a1)+,(a0)+
	dbra	d0,l0060
	movem.l	(sp)+,a0-a1/d0
	rts
;
;
clear_songname:
	movem.l	a0/d0-d1,-(sp)
	lea	songname_s(pc),a0
	moveq	#$13,d0
	moveq	#$20,d1
l0064:
	move.b	d1,(a0)+
	dbra	d0,l0064
	movem.l	(sp)+,a0/d0-d1
	rts
;
;----------------------------------------------------------------------------
;
kill_music:
	movem.l	a0-a6/d0-d7,-(sp)
	bsr.s	stop_music
	bsr	release_ram
	bsr	l008f
	bsr.s	clear_songname
	clr.b	l00b8
	movem.l	(sp)+,a0-a6/d0-d7
	rts
;
;----------------------------------------------------------------------------
;
stop_music:
	movem.l	a0-a6/d0-d7,-(sp)
	bsr	enter_super_mode
	move.b	l00c3(pc),d0
	bmi.s	l006a
	cmp.b	#1,d0
	bne.s	l0068
	bsr	l022f
l0067:
;;;	move.l	kbrates(pc),-(sp)
;;;	xbios	Kbrate,(),()
	bra.s	l0069
;
l0068:
	move	#$2700,sr
	bsr	l0194
l0069:
	move.b	l00bd(pc),(conterm).w
	move.l	nu_xbios+8(pc),(ev_xbios).w
	bra.s	l006c
;
l006a:
	btst	#5,(hw_iera).w
	beq.s	l006c
	bclr	#5,(hw_iera).w
	bclr	#5,(hw_imra).w
	movea.l	(ev_xbios).w,a0
	subq.l	#8,a0
	cmpi.l	#'MPL!',(a0)+
	bne.s	l006c
	move.l	(a0),(ev_xbios).w
	lea	(iv_kb_midi).w,a0
	movea.l	(a0),a1			;a1 -> current kb_midi routine
	subq.l	#8,a1
	cmpi.l	#'SND!',(a1)+
	bne.s	.l006b
	move.l	(a1),(a0)		;relink old kb_midi routine
	lea	-16(a1),a1
	move.l	(a1)+,(iv_time_a).w	;relink old time_a routine
	movea.l	(a1),a1
	jsr	(a1)
	bra.s	l006c
;
.l006b:
	cmpi.l	#'MOD!',-4(a1)
	bne.s	l006c
	move.l	(a1),(a0)		;relink old kb_midi routine
	lea	-16(a1),a1
	move.l	(a1)+,(iv_time_a).w	;relink old time_a routine
	movea.l	(a1),a1
	jsr	(a1)
	lea	(iv_time_c).w,a0
	movea.l	(a0),a1
	subq.l	#8,a1
	cmpi.l	#'BMT!',(a1)+
	bne.s	l006c
	move.l	(a1),(a0)
l006c:
	bsr	clear_psg
	move	#$2300,sr
	bsr	exit_super_mode
	lea	l00c3(pc),a0
	st	(a0)
	movem.l	(sp)+,a0-a6/d0-d7
	rts
;
;----------------------------------------------------------------------------
;
play_commander:
	movem.l	a0-a6/d0-d7,-(sp)
	bsr	stop_music
	bsr	enter_super_mode
	movea.l	allocated_ram_p(pc),a0
	lea	(conterm).w,a1
	lea	l00bd(pc),a2
	move.b	(a1),(a2)
	moveq	#0,d0
	move.l	d0,d1
	moveq	#1,d2		;d2 = 1
	moveq	#2,d3		;d3 = 2
	move.b	mod_type(pc),d0	;d0 = music module type (-1 = error)
	bmi	l0083
	move.b	l00c2(pc),d1	;d1 = 0(init) 1(rewind) 2(continue)	
	bmi	l0083
	cmp	d2,d0		;type 1 music ?  (sampled)
	bne.s	l0075
	andi.b	#2,(a1)
;;;	movem.l	a0/d1-d3,-(sp)
;;;	pea	$100016
;;;	xbios	Kbrate,(),()
;;;	swap	d0
;;;	clr	d0
;;;	lsr.l	#8,d0
;;;	lsr	#8,d0
;;;	lea	kbrates(pc),a0
;;;	move.l	d0,(a0)
;;;	movem.l	(sp)+,a0/d1-d3
	move.l	l00c5(pc),d0
	tst.b	use_SDMA_f
	bpl.s	.non_dma_1
	tst.b	l00b8
	bpl.s	l0071
	tas	l00b9
	beq.s	l0072
	bra.s	l0071
;
.non_dma_1:
	tst.b	l00b9
	bpl.s	l006f
	clr.b	l00b9
	bra.s	l0072
;
l006f:
	tst.b	l00b8
	bpl.s	l0071
	tst.b	top_khz_f
	bmi.s	l0070
	tst.b	l00ba
	bmi.s	l0072
	bra.s	l0071
;
l0070:
	tst.b	l00ba
	bpl.s	l0072
l0071:
	tst	d1		;init sample_music ?
	bne.s	l0073
l0072:
	bsr	init_sample_mod_play
	bra	l0082
;
l0073:				;rewind sample_music ?
	cmp	d2,d1
	bne.s	l0074
	bsr	rewind_sample_mod_play
	bra	l0082
;
l0074:				;continue sample_music ? (after pause)
	cmp	d3,d1
	bne.s	l0075
	bsr	continue_sample_mod_play
	bra	l0082
;
l0075:
	bclr	#0,(a1)
	lea	l00c1(pc),a1
	cmp	#3,d0		;type 2 or 3 music ?  (chip)
	bgt.s	l0077
	cmp	d2,d1		;rewind chip_3_music ?
	beq.s	l0076
	tst	d1		;init chip_3_music ?
	bne	l0081
l0076:				;init/rewind chip_3_music !
	move.b	(a1),d0
	jsr	(a0)
	jsr	4(a0)
	bsr	l018e
	bra	l0082
;
l0077:
	cmp	#4,d0		;type 4 music ?  (chip)
	bne.s	l0079
	cmp	d2,d1		;rewind chip_4_music ?
	beq.s	l0078
	tst	d1		;init chip_4_music ?
	bne.s	l0081
l0078:				;init/rewind chip_4_music !
	move.b	(a1),d0
	jsr	(a0)
	jsr	2(a0)
	bsr	l018e
	bra.s	l0082
;
l0079:
	cmp	#5,d0		;type 5 music ?  (chip)
	bne.s	l007b
	cmp	d2,d1		;rewind chip_5_music ?
	beq.s	l007a
	tst	d1		;init chip_5_music ?
	bne.s	l0081
l007a:				;init/rewind chip_5_music !
	move.b	(a1),d0
	jsr	(a0)
	bsr	l018e
	bra.s	l0082
;
l007b:
	cmp	#6,d0		;type 6 music ?  (chip)
	bne.s	l007d
	cmp	d2,d1		;rewind chip_6_music ?
	beq.s	l007c
	tst	d1		;init chip_6_music ?
	bne.s	l0081
l007c:				;init/rewind chip_6_music !
	jsr	(a0)
	bsr	l018e
	bra.s	l0082
;
l007d:
	cmp	#7,d0		;type 7 music ?  (chip)
	bne.s	l007f
	cmp	d2,d1		;rewind chip_7_music ?
	beq.s	l007e
	tst	d1		;init chip_7_music ?
	bne.s	l0081
l007e:				;init/rewind chip_7_music !
	move.l	d2,d0
	bsr	l019d
	bsr	l018e
	bra.s	l0082
;
l007f:
	cmp	#8,d0		;type 8 music ?  (chip)
	bne.s	l0083
	cmp	d2,d1		;rewind chip_8_music ?
	beq.s	l0080
	tst	d1		;init chip_8_music ?
	bne.s	l0081
l0080:				;init/rewind chip_8_music !
	jsr	(a0)
	bsr	l018e
	bra.s	l0082
;
l0081:
	cmp	d3,d1		;continue chip-music ?
	bne.s	l0083
	bsr	l018e
l0082:
	move	#$2700,sr
	lea	(ev_xbios).w,a0
	lea	nu_xbios+8(pc),a1
	move.l	(a0),(a1)+
	move.l	a1,(a0)			;link MPL! xbios routine
	move	#$2300,sr
	lea	mod_type(pc),a4
	move.b	(a4),3(a4)
l0083:
	bsr	exit_super_mode
	st	2(a4)
	movem.l	(sp)+,a0-a6/d0-d7
	rts
;
;----------------------------------------------------------------------------
;
play_best_until_space:
	movem.l	a0-a6/d0-d7,-(sp)
	bsr	enter_super_mode
	move	#$2700,sr
	move.l	sp,old_sp_link
	lea	loc_stack_end(pc),sp
	st	l00ba
	bclr	#3,(hw_vr).w
	lea	l00bb(pc),a0
	move.b	(hw_tacr).w,(a0)+
	move.b	(hw_iera).w,(a0)+
	move.b	(hw_imra).w,(a0)
	clr.b	(hw_tacr).w
	bset	#5,(hw_iera).w
	bset	#5,(hw_imra).w
	lea	(ev_vbi).w,a0
	lea	vbi_link(pc),a1
	move.l	(a0),(a1)+
	move.l	a1,(a0)
	lea	(iv_kb_midi).w,a0
	lea	kb_midi_link(pc),a1
	move.l	(a0),(a1)+
	move.l	a1,(a0)
	lea	(iv_time_c).w,a0
	lea	time_c_link(pc),a1
	move.l	(a0),(a1)+
	move.l	a1,(a0)
	lea	(iv_time_a).w,a0
	lea	time_a_link(pc),a1
	move.l	(a0),(a1)
	tst.b	use_SDMA_f
	bmi.s	.l0085
	move.b	l02dd(pc),(hw_tadr).w
	move.b	#1,(hw_tacr).w
	move.l	nu_time_a_mod_psg_p(pc),(a0)
	bra.s	.l0086
;
.l0085:
	move.l	#l0279,(a0)
	move	#2,l02de
	move.b	(hw_sdmacont).w,l00b0
	bsr	setup_mywire
	clr	l02d6
	move.l	l02d9(pc),d0
	moveq	#0,d1
	move	l02db(pc),d1
	add	d1,d1
	add.l	d0,d1
	movea	#-$7700,a0
	movep	d0,5(a0)
	swap	d0
	move.b	d0,3(a0)
	movep	d1,17(a0)
	swap	d1
	move.b	d1,15(a0)
	bsr	l02e5
	bsr	music
	move.b	#3,(hw_sdmacont).w
	move.b	#1,(hw_tadr).w
	move.b	#8,(hw_tacr).w
.l0086:
	lea	(hw_kbdata).w,a0
	bsr	kb_tx_delay
	move.b	#$12,(a0)		;Mouse reports off
	bsr	kb_tx_delay
	move.b	#$1a,(a0)		;Joystick reports off
	move	#$2500,sr
.await_key:
	tst.b	circuit_f		;MOD completed ?
	bmi.s	.stop_top_play
	tst	kb_midi_f
	beq.s	.await_key
	clr	kb_midi_f
	move.b	(hw_kbdata).w,d0
	cmpi.b	#$B9,d0			;KB Space ?
	beq.s	.stop_top_play
	cmp.b	#$B8,d0			;KB Alt ?
	bne.s	.await_key
	st	auto_req_f		;request autoload
.stop_top_play:
	move	#$2700,sr
	clr.b	(hw_tacr).w
	bset	#3,(hw_vr).w
	lea	(hw_kbdata).w,a0
	bsr.s	kb_tx_delay
	move.b	#8,(a0)			;Relative mouse reports on
	bsr.s	kb_tx_delay
	move.b	#$16,(a0)		;Request Joystick report
	tst.b	use_SDMA_f
	bpl.s	.l0088
	move	#1,l02de
	move.b	l00b0(pc),(hw_sdmacont).w
.l0088:
	move.l	vbi_link(pc),(ev_vbi).w
	move.l	kb_midi_link(pc),(iv_kb_midi).w
	move.l	time_c_link(pc),(iv_time_c).w
	move.l	time_a_link(pc),(iv_time_a).w
	lea	l00bb(pc),a0
	move.b	(a0)+,(hw_tacr).w
	move.b	(a0)+,(hw_iera).w
	move.b	(a0),(hw_imra).w
	movea.l	old_sp_link(pc),sp
	bra	l0067
;
;
kb_tx_delay:
	btst	#1,(hw_kbstat).w
	beq.s	kb_tx_delay
	rts
;
;
vbi_link:
	dcb.w	2,0
	rte
;
;
kb_midi_link:
	dcb.w	2,0
	addq	#1,kb_midi_f
	rte
;
;
time_c_link:
	dcb.w	2,0
	rte
;
;
time_a_link:
	dcb.w	2,0
;
;
old_sp_link:
	dcb.w	2,0
;
;
l008f:
	movem.l	d0/a0,-(sp)
	lea	rref(pc),a0
	clr	(a0)+		;rref[0..1]   = $0000
	moveq	#-1,d0
	move.l	d0,(a0)+	;rref[2..5]   = $FFFFFFFF
	move.l	d0,(a0)+	;rref[6..9]   = $FFFFFFFF
	move.l	d0,(a0)		;rref[10..13] = $FFFFFFFF
	lea	l00c1(pc),a0
	move.b	#1,(a0)
	movem.l	(sp)+,d0/a0
	rts
;
;
l0090:
	movem.l	a0-a6/d1-d7,-(sp)
	gemdos	Malloc,?
	move.b	l00b8(pc),d1
	beq.s	.l0091
	add.l	l00c5(pc),d0
	cmp.b	#1,d1
	bne.s	.l0091
	add.l	#$4a1c,d0
.l0091:
	movem.l	(sp)+,a0-a6/d1-d7
	rts
;
;
get_currbp_p_p:
	movem.l	a0-a6/d0-d7,-(sp)
	bsr	enter_super_mode
	move.l	(_sysbase).w,a0
	move.l	os_selfbeg_p(a0),a0	;New code gets real header
	lea	loc_currbp_p_p(pc),a1
	move.l	os_currbp_p_p(a0),(a1)
	bsr	exit_super_mode
	movem.l	(sp)+,a0-a6/d0-d7
	rts
;
;
adapt_environs:
	movem.l	a0-a6/d0-d7,-(sp)
	bsr	enter_super_mode
	move	#$2700,sr
	movea.l	sp,a2		;protect sp from possible bus error
	lea	(ev_buserr).w,a0
	movea.l	(a0),a1		;a1 = original ev_buserr
	move.l	#.l0095,(a0)	;set first test vector
	tst.b	(hw_sdmacont).w	;bus error if sound dma hardware missing
	not.b	non_SDMA_f	;DMA => FF, so next opcode makes it 00
.l0095:
	not.b	non_SDMA_f	;ST => FF   STE/TT/Falcon => 00
	movea.l	a2,sp		;restore sp after hardware test
	move.l	#.l0096,(a0)	;set second test vector
	tst.b	$ffff8e21.w	;;;Bug? why not 8921? (alternative hardware? TT?)
	st	new_CPU_f
.l0096:
	move.l	a1,(a0)		;restore original ev_buserr
	movea.l	a2,sp		;restore sp after hardware test
	lea	(ev_illegal).w,a0
	movea.l	(a0),a1		;a1 = original ev_illegal
	move.l	#.l0097,(a0)	;set CPU test vector
	dc.w	$4E7A,$B804	;legal opcode for newer CPU's only
	lea	nu_xbios_frame_fix(pc),a3
	move	#$5088,(a3)
	dc.w	$4E7A,$0002
	st	new_CPU_f		;TT/Falcon => FF   ST/STE => 00
.l0097:
	move.l	a1,(a0)		;restore original ev_illegal
	movea.l	a2,sp		;restore sp after CPU test
	move	#$2300,sr
	tst.b	(a5)+
	beq.s	.exit
	movea.l	(_sysbase).w,a0
	move.l	os_selfbeg_p(a0),a0
	move.l	os_kbshift_p(a0),d0
	cmp	#$0104,os_version(a0)
	bhs.s	.have_kbshift
	xbios	Keytbl,?,?,?
	subq.l	#1,d0		;NB: In all old TOS Kbshift is at Keytbl-1
.have_kbshift:
	move.l	d0,kbshift_p
	lea	kbsh_p_1(pc),a0
	move.l	d0,(a0)
	move.l	d0,kbsh_p_2-kbsh_p_1(a0)
	move.l	d0,kbsh_p_3-kbsh_p_1(a0)
	move.l	d0,kbsh_p_4-kbsh_p_1(a0)
.exit:
	bsr.s	exit_super_mode
	movem.l	(sp)+,a0-a6/d0-d7
	rts
;
;
st_error_f_rts:
	st	error_f
	rts
;
;
show_bug_alert_sub:
	movem.l	a0-a6/d0-d7,-(sp)
	lea	contrl(pc),a6
	moveq	#$34,d0			;AES form_alert
	move.l	#$1010100,d1
	move	#1,intin-contrl(a6)
	lea	bug_alert_s(pc),a4
	move.l	a4,addrin-contrl(a6)
	bsr.s	aes_call_d0_d1_ia6
	bsr	kill_music
	st	error_f
	movem.l	(sp)+,a0-a6/d0-d7
	rts
;
;
aes_call_d0_d1_ia6:
	movem.l	a0-a6/d0-d7,-(sp)
	move	d0,(a6)
	movep.l	d1,3(a6)
	lea	aes_pb(pc),a0
	move.l	a0,d1
	move	#$c8,d0			;aes-aufruf
	trap	#2
	movem.l	(sp)+,a0-a6/d0-d7
	rts
;
;
enter_super_mode:
	gemdos	Super,!
	lea	l00b2(pc),a0
	move.l	d0,(a0)
	rts
;
;
exit_super_mode:
	gemdos	Super|_ind,l00b2(pc)
	rts
;
;
clear_psg:		;formerly 'hot_key_sub'
	lea	(hw_psgsel).w,a5
	moveq	#$d,d0
l00a1:
	cmp.b	#7,d0
	bne.s	l00a2
	move.b	d0,(a5)
	move.b	(a5),d1
	or.b	#$3f,d1
	move.b	d1,2(a5)
	bra.s	l00a3
;
l00a2:
	move.b	d0,(a5)
	clr.b	2(a5)
l00a3:
	dbra	d0,l00a1
	rts
;
;
non_accessory_err:
	gemdos	Cconws,file_is_acc_s(pc)
	gemdos	Cnecin
	gemdos	Pterm0
;
;
file_is_acc_s:
	dc.b	ESC,'E'
	dc.b	'Sorry, but this file is an ACCESSORY!',CR,LF
	dc.b	CR,LF
	dc.b	'Just change the extension into ACC...',CR,LF
	dc.b	'Now boot up your ST and enjoy this',CR,LF
	dc.b	'ultimate program...'
	dc.b	NUL
	even
;
;
;replaced;	aes_pb:
	dc.l	contrl
	dc.l	global
	dc.l	intin
	dc.l	intout
	dc.l	addrin
	dc.l	addrout
;
;NB: contrl is used as ref ptr in a6, for all aes table accesses
contrl:		;+00
	ds.w	12
;replaced;	global:		;+24
	ds.w	15
intin:		;+54
	ds.w	128
intout:		;+310
	ds.w	128
;replaced;	addrin:		;+566
	ds.l	64		;Idiotic, addrin can use max 3 longs
;replaced;	addrout:	;+822
	ds.l	64		;Even worse, addrout only needs ONE long
message:	;+1078
	dcb.w	8,0
;
loc_currbp_p_p:
	dc.l	$0000602C	;NB: used for some old TOS, else patched
accessory_name:
	dc.b	'  MPlayer v1.3',NUL
l00b0:
	dc.b	$00
kbrates:		;saves Kbrates, but is BUGGED !!! (can restore non-saved)
	dc.l	0
l00b2:
	dc.l	0
use_SDMA_f:	dc.b	$00
top_khz_f:	dc.b	$00
new_CPU_f:	dc.b	$00	;ST/STE => 00   TT/Falcon => FF
non_SDMA_f:	dc.b	$00	;ST => FF   STE/TT/Falcon => 00
l00b8:	dc.b	$00
l00b9:	dc.b	$00
l00ba:	dc.b	$00
l00bb:	dc.b	$00,$00,$00
l00bc:	dc.b	$00
l00bd:	dc.b	$00
rref:
error_f:
	dc.b	$00
l00bf:
	dc.b	$00
mod_type:
	dc.b	$00
l00c1:
	dc.b	$00
l00c2:
	dc.b	$00
l00c3:
	dc.b	$00
allocated_ram_p:
	dc.l	0
l00c5:
	dc.l	0
;
;
loadfile_bf_p:
	dc.l	0
loadfile_ct:
	dc.l	0
l00c8:
	dc.w	0
l00c9:
	dc.w	0
l00ca:
	dc.w	0
l00cb:
	dc.w	0
l00cc:
	dc.w	0
l00cd:
	dcb.w	4,0
l00ce:
	dcb.w	4,0
l00cf:
	dcb.w	4,0
l00d0:
	dcb.w	4,0
l00d1:
	dcb.w	4,0
access_path_s:
	ds.b	128
current_path_s:
	ds.b	128
current_fname_s:
	ds.b	14
local_dta:
	ds.b	44
;
;
main_tree:
tree_1:
	o_head	t1,treeroot,?,title,crazy_butt		;obj 0
	dc.w	g_box,none,normal
	dc.l	$21100
	dc.w	0,0,39,12
;
	o_head	t1,title,underscore,?,?			;obj 1
	dc.w	g_string,none,normal
	dc.l	t1_title_s
	dc.w	14,1,11,1
;
	o_head	t1,underscore,author_1,?,?		;obj 2
	dc.w	g_text,none,normal
	dc.l	t1_underscore_ted
	dc.w	14,2,11,1
;
	o_head	t1,author_1,author_2,?,?		;obj 3
	dc.w	g_text,touchexit+selectable,normal
	dc.l	t1_author_1_ted
	dc.w	7,3,25,1
;
	o_head	t1,author_2,songname,?,?		;obj 4
	dc.w	g_text,touchexit+selectable,normal
	dc.l	t1_author_2_ted
	dc.w	4,4,31,1
;
	o_head	t1,songname,info_butt,?,?		;obj 5
	dc.w	g_text,touchexit+rbutton,normal
	dc.l	t1_songname_ted
	dc.w	5,6,30,1
;
	o_head	t1,info_butt,stop_butt,?,?		;obj 6
	dc.w	g_button,touchexit+rbutton,normal
	dc.l	t1_info_s
	dc.w	2,8,8,1
;
	o_head	t1,stop_butt,play_butt,?,?		;obj 7
	dc.w	g_button,touchexit+rbutton,normal
	dc.l	t1_stop_s
	dc.w	11,8,8,1
;
	o_head	t1,play_butt,load_butt,?,?		;obj 8
	dc.w	g_button,touchexit+rbutton,normal
	dc.l	t1_play_s
	dc.w	20,8,8,1
;
	o_head	t1,load_butt,quality_butt,?,?		;obj 9
	dc.w	g_button,touchexit+rbutton,normal
	dc.l	t1_load_s
	dc.w	29,8,8,1
;
	o_head	t1,quality_butt,crazy_butt,?,?		;obj 10
	dc.w	g_button,touchexit+rbutton,normal
	dc.l	t1_quality_s
	dc.w	2,10,14,1
;
	o_head	t1,crazy_butt,treeroot,?,?		;obj 11
	dc.w	g_button,touchexit+lastob+rbutton+default
l00d6:
	dc.w	normal
	dc.l	t1_crazy_s
	dc.w	18,10,19,1
;
;
tree_2:
	dc.b	$ff,$ff,$00,$01,$00,$11,$00,$14
	dcb.w	2,0
	dc.b	$00,$02,$11,$00,$00,$00,$00,$00
	dc.b	$00,$21,$00,$17
;
	dc.b	$00,$02,$ff,$ff
	dc.b	$ff,$ff,$00,$15,$00,$00,$00,$00
	dc.l	l00e6
	dc.b	$00,$0b,$00,$01,$00,$0b,$00,$01
;
	dc.b	$00,$03,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00e7
	dc.b	$00,$0b,$00,$02,$00,$0b,$00,$01
;
	dc.b	$00,$04,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00e8
	dc.b	$00,$04,$00,$03,$00,$19,$00,$01
;
	dc.b	$00,$05,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00e9
	dc.b	$00,$07,$00,$04,$00,$13,$00,$01
;
	dc.b	$00,$06,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00ea
	dc.b	$00,$0d,$00,$06,$00,$08,$00,$01
;
	dc.b	$00,$07,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00eb
	dc.b	$00,$0d,$00,$07,$00,$08,$00,$01
;
	dc.b	$00,$08,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00ec
	dc.b	$00,$05,$00,$08,$00,$18,$00,$01
;
	dc.b	$00,$09,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00ed
	dc.b	$00,$01,$00,$09,$00,$1f,$00,$01
;
	dc.b	$00,$0a,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00ee
	dc.b	$00,$05,$00,$0a,$00,$17,$00,$01
;
	dc.b	$00,$0b,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00ef
	dc.b	$00,$0c,$00,$0b,$00,$0a,$00,$01
;
	dc.b	$00,$0c,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00f0
	dc.b	$00,$0f,$00,$0c,$00,$03,$00,$01
;
	dc.b	$00,$0d,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00f1
	dc.b	$00,$07,$00,$0d,$00,$14,$00,$01
;
	dc.b	$00,$0e,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00f2
	dc.b	$00,$08,$00,$0e,$00,$11,$00,$01
;
	dc.b	$00,$0f,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00f3
	dc.b	$00,$03,$00,$10,$00,$1c,$00,$01
;
	dc.b	$00,$10,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00f4
	dc.b	$00,$08,$00,$11,$00,$11,$00,$01
;
	dc.b	$00,$11,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00f5
	dc.b	$00,$0b,$00,$13,$00,$0c,$00,$01
;
	dc.b	$00,$00,$ff,$ff,$ff,$ff,$00,$1a
	dc.b	$00,$72
l00d8:
	dc.b	$00,$00
	dc.l	t2_great_s
	dc.b	$00,$0d,$00,$15,$00,$08,$00,$01
;
;
tree_3:
	dc.b	$ff,$ff,$00,$01,$00,$0d,$00,$14
	dcb.w	2,0
	dc.b	$00,$02,$11,$00,$00,$00,$00,$00
	dc.b	$00,$1e,$00,$11
;
	dc.b	$00,$02,$ff,$ff
	dc.b	$ff,$ff,$00,$15,$00,$00,$00,$00
	dc.l	l00f6
	dc.b	$00,$03,$00,$01,$00,$18,$00,$01
;
	dc.b	$00,$03,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00f7
	dc.b	$00,$03,$00,$02,$00,$18,$00,$01
;
	dc.b	$00,$04,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00f8
	dc.b	$00,$08,$00,$03,$00,$0e,$00,$01
;
	dc.b	$00,$05,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00f9
	dc.b	$00,$07,$00,$04,$00,$10,$00,$01
;
	dc.b	$00,$06,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00fa
	dc.b	$00,$08,$00,$05,$00,$0e,$00,$01
;
	dc.b	$00,$07,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00fb
	dc.b	$00,$0c,$00,$06,$00,$07,$00,$01
;
	dc.b	$00,$08,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00fc
	dc.b	$00,$05,$00,$08,$00,$14,$00,$01
;
	dc.b	$00,$09,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00fd
	dc.b	$00,$05,$00,$09,$00,$14,$00,$01
;
	dc.b	$00,$0a,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00fe
	dc.b	$00,$08,$00,$0a,$00,$0e,$00,$01
;
	dc.b	$00,$0b,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l00ff
	dc.b	$00,$09,$00,$0b,$00,$0c,$00,$01
;
	dc.b	$00,$0c,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l0100
	dc.b	$00,$09,$00,$0c,$00,$0c,$00,$01
;
	dc.b	$00,$0d,$ff,$ff,$ff,$ff,$00,$15
	dcb.w	2,0
	dc.l	l0101
	dc.b	$00,$08,$00,$0d,$00,$0e,$00,$01
;
	dc.b	$00,$00,$ff,$ff,$ff,$ff,$00,$1a
	dc.b	$00,$72
l00da:
	dc.b	$00,$00
	dc.l	t2_amazing_s
	dc.b	$00,$0b,$00,$0f,$00,$08,$00,$01
;
;
tree_4:
	o_head	t4,treeroot,?,obj_1,maxobj	;obj 0
	dc.w	g_box,none,normal
	dc.l	$021100
	dc.w	0,0,$424,$d07
;
	o_name	t4,obj_1
	o_head	t4,1,2,?,?		;obj 1
	dc.w	g_text,none,normal
	dc.l	t4_music_no_prompt_1_ted
	dc.w	3,1,31,1
;
	o_head	t4,2,3,?,?		;obj 2
	dc.w	g_text,none,normal
	dc.l	t4_music_no_prompt_2_ted
	dc.w	1,2,34,1
;
	o_head	t4,3,4,?,?		;obj 3
	dc.w	g_ftext,editable,normal
	dc.l	t4_music_no_ted
	dc.w	11,4,15,1
;
	o_head	t4,4,5,?,?		;obj 4
	dc.w	g_button,touchexit+rbutton,normal
	dc.l	t4_getaway_s
	dc.w	5,6,$609,$101
;
	o_name	t4,maxobj
	o_head	t4,5,treeroot,?,?	;obj 5
	dc.w	g_button,touchexit+lastob+rbutton+default
l00dc:
	dc.w	normal
	dc.l	t4_this_one_s
	dc.w	$214,$106,10,1
;
;
tree_5:
	o_head	t5,treeroot,?,obj_1,maxobj		;obj 0
	dc.w	g_box,none,normal
	dc.l	$21100
	dc.w	0,0,35,9
;
	o_name	t5,obj_1
	o_head	t5,config_text,exithelp_text,?,?	;obj 1
	dc.w	g_string,none,normal
	dc.l	t5_configuration_s
	dc.w	1,1,33,1
;
	o_head	t5,exithelp_text,cache_butt,?,?		;obj 2
	dc.w	g_text,none,normal
	dc.l	exit_top_khz_ted
	dc.w	2,2,31,1
;
	o_head	t5,cache_butt,dma_butt,?,?		;obj 3
	dc.w	g_button,touchexit+rbutton
t5_cache_stat:
	dc.w	normal
	dc.l	t5_cache_s
	dc.w	2,5,9,1
;
	o_head	t5,dma_butt,top_khz_butt,?,?		;obj 4
	dc.w	g_button,touchexit+rbutton
t5_dma_stat:
	dc.w	normal
	dc.l	t5_dma_s
	dc.w	13,5,9,1
;
	o_head	t5,top_khz_butt,finito_butt,?,?		;obj 5
	dc.w	g_button,touchexit+rbutton
t5_top_khz_stat:
	dc.w	normal
	dc.l	top_khz_s
	dc.w	24,5,9,1
;
	o_name	t5,maxobj
	o_head	t5,finito_butt,treeroot,?,?		;obj 6
	dc.w	g_button,touchexit+lastob+rbutton+default
t5_finito_stat:
	dc.w	normal
	dc.l	t5_finito_s
	dc.w	13,7,9,1
;
trees_end:
;
t1_underscore_ted:
	dc.l	t1_underscore_s
	dc.l	l0117
	dc.l	l0118
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$0c,$00,$01
t1_author_1_ted:
	dc.l	t1_author_1_s
	dc.l	l011a
	dc.l	l011b
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$1a,$00,$01
t1_author_2_ted:
	dc.l	t1_author_2_s
	dc.l	l011d
	dc.l	l011e
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$20,$00,$01
t1_songname_ted:
	dc.l	songname_head_s
	dc.l	l0121
	dc.l	l0122
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$1f,$00,$01
l00e6:
	dc.l	l0123
	dc.l	l0124
	dc.l	l0125
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$0c,$00,$01
l00e7:
	dc.l	l0126
	dc.l	l0127
	dc.l	l0128
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$0c,$00,$01
l00e8:
	dc.l	l0129
	dc.l	l012a
	dc.l	l012b
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$1a,$00,$01
l00e9:
	dc.l	l012c
	dc.l	l012d
	dc.l	l012e
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$14,$00,$01
l00ea:
	dc.l	l012f
	dc.l	l0130
	dc.l	l0131
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$09,$00,$01
l00eb:
	dc.l	l0132
	dc.l	l0133
	dc.l	l0134
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$09,$00,$01
l00ec:
	dc.l	l0135
	dc.l	l0136
	dc.l	l0137
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$19,$00,$01
l00ed:
	dc.l	l0138
	dc.l	l0139
	dc.l	l013a
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$20,$00,$01
l00ee:
	dc.l	l013b
	dc.l	l013c
	dc.l	l013d
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$18,$00,$01
l00ef:
	dc.l	l013e
	dc.l	l013f
	dc.l	l0140
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$0b,$00,$01
l00f0:
	dc.l	l0141
	dc.l	l0142
	dc.l	l0143
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$04,$00,$01
l00f1:
	dc.l	l0144
	dc.l	l0145
	dc.l	l0146
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$15,$00,$01
l00f2:
	dc.l	l0147
	dc.l	l0148
	dc.l	l0149
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$12,$00,$01
l00f3:
	dc.l	l014a
	dc.l	l014b
	dc.l	l014c
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$1d,$00,$01
l00f4:
	dc.l	l014d
	dc.l	l014e
	dc.l	l014f
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$12,$00,$01
l00f5:
	dc.l	l0150
	dc.l	l0151
	dc.l	l0152
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$0d,$00,$01
l00f6:
	dc.l	l0153
	dc.l	l0154
	dc.l	l0155
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$19,$00,$01
l00f7:
	dc.l	l0156
	dc.l	l0157
	dc.l	l0158
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$19,$00,$01
l00f8:
	dc.l	l0159
	dc.l	l015a
	dc.l	l015b
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$0f,$00,$01
l00f9:
	dc.l	l015c
	dc.l	l015d
	dc.l	l015e
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$11,$00,$01
l00fa:
	dc.l	l015f
	dc.l	l0160
	dc.l	l0161
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$0f,$00,$01
l00fb:
	dc.l	l0162
	dc.l	l0163
	dc.l	l0164
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$08,$00,$01
l00fc:
	dc.l	l0165
	dc.l	l0166
	dc.l	l0167
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$15,$00,$01
l00fd:
	dc.l	l0168
	dc.l	l0169
	dc.l	l016a
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$15,$00,$01
l00fe:
	dc.l	l016b
	dc.l	l016c
	dc.l	l016d
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$0f,$00,$01
l00ff:
	dc.l	l016e
	dc.l	l016f
	dc.l	l0170
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$0d,$00,$01
l0100:
	dc.l	l0171
	dc.l	l0172
	dc.l	l0173
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$0d,$00,$01
l0101:
	dc.l	l0174
	dc.l	l0175
	dc.l	l0176
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$0f,$00,$01
t4_music_no_prompt_1_ted:
	dc.l	l0177
	dc.l	l0178
	dc.l	l0179
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$20,$00,$01
t4_music_no_prompt_2_ted:
	dc.l	l017a
	dc.l	l017b
	dc.l	l017c
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$23,$00,$01
t4_music_no_ted:
	dc.l	l017d
	dc.l	l017e
	dc.l	l017f
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$03,$00,$10
exit_top_khz_ted:
	dc.l	exit_top_khz_play_space_s
	dc.l	l0182
	dc.l	l0183
	dc.b	$00,$03,$00,$06,$00,$00,$11,$80
	dc.b	$00,$00,$ff,$ff,$00,$20,$00,$01
t1_title_s:
	dc.b	'MultiPlayer',NUL
t1_info_s:
	dc.b	'info',$00
t1_stop_s:
	dc.b	'stop',$00
t1_play_s:
	dc.b	'play',$00
t1_load_s:
	dc.b	'load',$00
t1_quality_s:
	dc.b	'best quality',$00
t1_crazy_s:
	dc.b	'crazy',$00
t2_great_s:
	dc.b	'GREAT!',$00
t2_amazing_s:
	dc.b	'AMAZING!',NUL
t4_getaway_s:
	dc.b	'getaway',$00
t4_this_one_s:
	dc.b	'this one!',NUL
t5_configuration_s:
	dc.b	'Please select your configuration!',NUL
t5_cache_s:
	dc.b	'cache',$00
t5_dma_s:
	dc.b	'DMA!',$00
;
top_khz_s:
	dc.b	'20 khz',NUL
;
t5_finito_s:
	dc.b	' finito ',$00
;
t1_underscore_s:
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	dc.b	$ff,$ff,$ff,$00
l0117:
	dc.b	$00
l0118:
	dc.b	$00
t1_author_1_s:
	dc.b	'written by Hoang Viet Chi',$00
l011a:
	dc.b	$00
l011b:
	dc.b	$00
t1_author_2_s:
	dc.b	'TrackerPlayer by Michael Rausch',$00
l011d:
	dc.b	$00
l011e:
	dc.b	$00
songname_head_s:
	dc.b	'songname: '
songname_s:
	dc.b	'????????????????????',$00
l0121:
	dc.b	$00
l0122:
	dc.b	$00
l0123:
	dc.b	'MultiPlayer',$00
l0124:
	dc.b	$00
l0125:
	dc.b	$00
l0126:
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	dc.b	$ff,$ff,$00
l0127:
	dc.b	$00
l0128:
	dc.b	$00
l0129:
	dc.b	'MPlayer is PUBLIC DOMAIN!',NUL
l012a:
	dc.b	$00
l012b:
	dc.b	$00
l012c:
	dc.b	'No commercial sale!',NUL
l012d:
	dc.b	$00
l012e:
	dc.b	$00
l012f:
	dc.b	'Features',NUL
l0130:
	dc.b	$00
l0131:
	dc.b	$00
l0132:
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	dc.b	$00
l0133:
	dc.b	$00
l0134:
	dc.b	$00
l0135:
	dc.b	'NoiseTracker/StarTrekker',NUL
l0136:
	dc.b	$00
l0137:
	dc.b	$00
l0138:
	dc.b	"Jo 'Mad' Hippel Soundchip Music",NUL
l0139:
	dc.b	$00
l013a:
	dc.b	$00
l013b:
	dc.b	'Count Zero Music Driver',$00
l013c:
	dc.b	$00
l013d:
	dc.b	$00
l013e:
	dc.b	'SoundMagic',$00
l013f:
	dc.b	$00
l0140:
	dc.b	$00
l0141:
	dc.b	'LAP',$00
l0142:
	dc.b	$00
l0143:
	dc.b	$00
l0144:
	dc.b	'Noise Design YM-2149',$00
l0145:
	dc.b	$00
l0146:
	dc.b	$00
l0147:
	dc.b	'GALACTIC MusicMon',$00
l0148:
	dc.b	$00
l0149:
	dc.b	$00
l014a:
	dc.b	'59% processor time left with',$00
l014b:
	dc.b	$00
l014c:
	dc.b	$00
l014d:
	dc.b	'the TrackerPlayer',NUL
l014e:
	dc.b	$00
l014f:
	dc.b	$00
l0150:
	dc.b	'color & mono',NUL
l0151:
	dc.b	$00
l0152:
	dc.b	$00
l0153:
	dc.b	'Suggestions & bug report',NUL
l0154:
	dc.b	$00
l0155:
	dc.b	$00
l0156:
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$00
l0157:
	dc.b	$00
l0158:
	dc.b	$00
l0159:
	dc.b	'Hoang Viet Chi',$00
l015a:
	dc.b	$00
l015b:
	dc.b	$00
l015c:
	dc.b	'Karl-Korn-Str. 6',$00
l015d:
	dc.b	$00
l015e:
	dc.b	$00
l015f:
	dc.b	'5000 Cologne 1',$00
l0160:
	dc.b	$00
l0161:
	dc.b	$00
l0162:
	dc.b	'Germany',$00
l0163:
	dc.b	$00
l0164:
	dc.b	$00
l0165:
	dc.b	'Credits are going to',$00
l0166:
	dc.b	$00
l0167:
	dc.b	$00
l0168:
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	dc.b	$00
l0169:
	dc.b	$00
l016a:
	dc.b	$00
l016b:
	dc.b	'Michael Rausch',$00
l016c:
	dc.b	$00
l016d:
	dc.b	$00
l016e:
	dc.b	'Hrvoje Husic',$00
l016f:
	dc.b	$00
l0170:
	dc.b	$00
l0171:
	dc.b	'Martin  Wilz',$00
l0172:
	dc.b	$00
l0173:
	dc.b	$00
l0174:
	dc.b	'Carsten Jacobi',$00
l0175:
	dc.b	$00
l0176:
	dc.b	$00
l0177:
	dc.b	'Please enter your music choice!',$00
l0178:
	dc.b	$00
l0179:
	dc.b	$00
l017a:
	dc.b	'(usually a number between 1 to 10)',$00
l017b:
	dc.b	$00
l017c:
	dc.b	$00
l017d:
	dc.b	$30,$31,$00
l017e:
	dc.b	'Music number:__',$00
l017f:
	dc.b	'99',$00
	even
;
exit_top_khz_play_space_s:
	dc.b	'(exit '
top_khz_play_space_s:
	dc.b	"20 khz play with 'SPACE')",NUL
;
l0182:
	dc.b	$00
l0183:
	dc.b	$00
play_butt_alert_s:
	dc.b	'[0]['
	dc.b	'         MusicPlayer|'
	dc.b	'         ',$FF,$FF,$FF,$FF,$FF,$FF
	dc.b	$FF,$FF,$FF,$FF,$FF,'|'
	dc.b	'Greetings to everybody in the|'
	dc.b	'       ST-Demo-Scene!!]'
	dc.b	'[continue|new|got it!]'
	dc.b	NUL
;
stop_butt_alert_s:
	dc.b	'[0]['
	dc.b	"     ...is good, isn't it?!|"
	dc.b	' |'
	dc.b	'      Do you like the music?|]'
	dc.b	'[kill|stop|wonderful]'
	dc.b	NUL
;
bug_alert_s:
	dc.b	'[0]['
	dc.b	'   Something wonderful|'
	dc.b	'      has happened!|'
	dc.b	"I think I've caught a bug!|"
	dc.b	'  WHAT HAVE YOU DONE ?!?]'
	dc.b	"[I'm sorry...]"
	dc.b	NUL
;
;
	dc.b	'LEGALIZE POT!'
	dc.b	NUL
	even
;
;
l0187:
	dcb.l	$878/4,'PLAY'
loc_stack_end:
;
;----------------------------------------------------------------------------
;		XBRA linked XBIOS routine
;----------------------------------------------------------------------------
;NB:	Original had a bugged XBRA header of only 8 (not 12) bytes here,
;	which was the reason why the return link was useless (not used).
;	Instead the xbios link active at init of MPL!-xbios was assumed
;	to be valid forever, so XBRA digging might bomb the system.
;	The link would also overwrite the identifier, making identification
;	of double linking impossible (caused bombs!).
;----------------------------------------------------------------------------
;
	XB_define	nu_xbios,'MPL!'
	move.l	sp,a0
nu_xbios_frame_fix:
	addq.l	#6,a0		;this opcode is patched in case of new CPU !
	move	(sp),d1
	btst	#13,d1			;Super caller?
	bne.s	.l018b
	move	usp,a0
.l018b:
	move	(a0),d1			;d1 = xbios fun_code
	cmpi	#Giaccess&$ff,d1
	beq.s	.nu_giaccess		;go limit giaccess freedom
	cmpi	#Dosound&$ff,d1
	beq.s	.xbios_dummy		;go skip Dosound completely
	XB_gonext_d	nu_xbios(pc)
;
;
.nu_giaccess:			;;;Bug: access to regs 14 & 15 is blocked
	move	2(a0),d0
.xbios_dummy:
	rte
;
;----------------------------------------------------------------------------
;End of:	XBRA linked XBIOS routine
;----------------------------------------------------------------------------
;
l018e:
	move	#$2700,sr
	bsr	clear_psg
	lea	(iv_time_a).w,a0
	lea	snd_time_a_save_p(pc),a1
	lea	snd_time_a_call_p(pc),a2
	lea	type_7_player(pc),a3
	move.l	(a0),(a1)
	lea	nu_time_a_snd(pc),a1
	move.l	a1,(a0)
	move.l	allocated_ram_p(pc),(a2)	;call_p -> data start
	move.b	mod_type(pc),d0
	cmp.b	#4,d0
	beq.s	.type_4		;goto .type_4 for type 4 music
	cmp.b	#5,d0
	beq.s	.type_5		;goto .type_5 for type 5 music
	cmp.b	#6,d0
	beq.s	.type_6		;goto .type_6 for type 6 music
	cmp.b	#7,d0
	beq.s	.type_7		;goto .type_7 for type 7 music
;
.type_2_3_8:
	addq.l	#8,(a2)		;call_p -> data start + 8
	bra.s	l0193		;goto l0193 for types 2, 3 and 8
;
.type_4:
	addq.l	#6,(a2)		;call_p -> data start + 6
	bra.s	l0193
;
.type_5:
	addi.l	#$22,(a2)	;call_p -> data start + 34
	bra.s	l0193
;
.type_7:
	move.l	a3,(a2)		;call_p -> type_7_player
	bra.s	l0193
;
.type_6:
	addq.l	#4,(a2)		;call_p -> data start + 4
l0193:
	lea	(iv_kb_midi).w,a0
	lea	nu_kb_midi_snd+8(pc),a1
	move.l	(a0),(a1)+
	move.l	a1,(a0)
	bset	#5,(hw_imra).w
	bset	#5,(hw_iera).w
	clr.b	(hw_tacr).w
	move.b	#-$c,(hw_tadr).w
	move.b	#7,(hw_tacr).w
	move	#$2300,sr
	rts
;
;
l0194:
	move	#$2700,sr
	bsr	clear_psg
	clr.b	(hw_tacr).w
	bclr	#5,(hw_iera).w
	bclr	#5,(hw_imra).w
	move.b	#1,(hw_tacr).w
	lea	nu_kb_midi_snd+8(pc),a0
	move.l	(a0),(iv_kb_midi).w		;relink old kb_midi routine
	lea	-16(a0),a0
	move.l	(a0),(iv_time_a).w		;relink old time_a routine
	cmp	#6,d0
	bne.s	.l0195
	movea.l	allocated_ram_p(pc),a0
	jsr	8(a0)
	bra.s	.l0196
;
.l0195:
	cmpi	#7,d0
	bne.s	.l0196
	moveq	#0,d0
	bsr.s	l019d
.l0196:
	move	#$2300,sr
	rts
;
;----------------------------------------------------------------------------
;		XBRA linked TIME_A routine for sound effect modules
;----------------------------------------------------------------------------
;
nu_time_a_snd:
	movem.l	a0-a6/d0-d7,-(sp)
	jsr	$deadface.l
snd_time_a_call_p	equ	*-4
	movem.l	(sp)+,a0-a6/d0-d7
	bclr	#5,(hw_isra).w
	rte
;
;----------------------------------------------------------------------------
;End of:	XBRA linked TIME_A routine for sound effect modules
;----------------------------------------------------------------------------
;		XBRA linked KB_MIDI routine for sound effect modules
;----------------------------------------------------------------------------
;
snd_time_a_save_p:
	ds.l	1
	dc.l	release_ram
;
	XB_define	nu_kb_midi_snd,'SND!'
	tst.b	($feedface).l
kbsh_p_1	=	*-4
	beq.s	l019c
	cmpi.b	#$c,($feedface).l
kbsh_c_1	=	*-6
kbsh_p_2	=	*-4
	bne.s	l019c
	andi.b	#2,(conterm).w
	movem.l	a5/d0-d1,-(sp)
	st	auto_req_f
	bsr	clear_psg
	movem.l	(sp)+,a5/d0-d1
l019c:
	XB_gonext_d	nu_kb_midi_snd(pc)
;
;----------------------------------------------------------------------------
;End of:	XBRA linked KB_MIDI routine for sound effect modules
;----------------------------------------------------------------------------
;
l019d:
	movem.l	a0-a6/d0-d7,-(sp)
	lea	l0200(pc),a1
	tst	d0
	bne.s	.l019e
	cmpi.b	#-1,23(a1)
	beq.s	.l019f
	bsr	sound_out_1
	bra.s	.l019f
;
.l019e:
	movea.l	a0,a2
	move.l	a2,(a1)
	move.b	d0,4(a1)
	lea	l0201(pc),a3
	clr.l	(a3)
	lea	l0202(pc),a3
	clr.l	(a3)
	lea	l0203(pc),a3
	clr.l	(a3)
	lea	l01ff(pc),a3
	clr.l	8(a3)
	lea	l01fa(pc),a3
	move.b	#1,5(a3)
	move.b	12(a2),4(a3)
	clr	18(a1)
	move.l	a2,d1
	add.l	(a2),d1
	move.l	d1,6(a1)
	move.l	a2,d1
	add.l	4(a2),d1
	move.l	d1,10(a1)
	move.l	a2,d1
	add.l	8(a2),d1
	move.l	d1,14(a1)
	moveq	#0,d3
	bsr	l01f1
	cmpi.b	#-1,23(a1)
	bne.s	.l019f
	move.b	#1,23(a1)
.l019f:
	movem.l	(sp)+,a0-a6/d0-d7
	rts
;
;----------------------------------------------------------------------------
;	indirect linked TIME_A subroutine for type 7 sound effect modules
;----------------------------------------------------------------------------
;
type_7_player:
	movem.l	a1-a6/d1-d5,-(sp)
	move.b	l01fe(pc),d1
	tst.b	d1
	beq	l01ab
	lea	l0200(pc),a1	;a1 -> l0200
	lea	l0201(pc),a2	;a2 -> l0201
	subq.b	#1,19(a1)
	bhs.s	.l01a9
	move.b	l01fd(pc),19(a1)
	moveq	#0,d1
.loop_1:
	subq.b	#1,20(a1,d1.w)	;countdown ?
	bpl.s	.l01a8
	move	d1,d2
	add	d2,d2
	add	d2,d2
.loop_2:
	movea.l	24(a1,d2.w),a3	;current position = long(l0200+24+d1*4)
.loop_3:
	moveq	#0,d3
	move.b	(a3)+,d3	;d3 = note number or command (command > $3F)
	cmpi.b	#$7f,d3
	bne.s	.l01a4
	bsr	l01f0
	bra.s	.loop_2
;
.l01a4:
	btst	#7,d3
	beq.s	.l01a5
	andi.b	#$7f,d3
	move.b	d3,20(a1,d1.w)
	bra.s	.l01a7
;
.l01a5:
	btst	#6,d3
	beq.s	.l01a6
	andi.b	#$3f,d3
	add	d3,d3
	movea.l	10(a1),a4
	move	0(a4,d3.w),d3
	add.l	(a1),d3
	move.l	d3,(a2)
	bra.s	.loop_3
;
.l01a6:				;here d3 = note number
	clr.b	20(a1,d1.w)
	bsr.s	l01ac
	btst	#7,(a3)
	bne.s	.loop_3
.l01a7:
	move.l	a3,24(a1,d2.w)	;store new position = a3
.l01a8:
	lea	42(a2),a2
	addq	#1,d1
	cmpi	#3,d1
	bne.s	.loop_1
.l01a9:
	lea	l0201(pc),a2
	lea	l01ff(pc),a1
	moveq	#0,d3
	moveq	#0,d1
.l01aa:
	bsr	l01c1
	lea	42(a2),a2
	addq	#1,d1
	cmpi	#3,d1
	bne.s	.l01aa
	bsr	sound_out_2
l01ab:
	movem.l	(sp)+,a1-a6/d1-d5
	rts
;
;----------------------------------------------------------------------------
;End of indirect linked TIME_A subroutine for type 7 sound effect modules
;----------------------------------------------------------------------------
;
l01ac:
	lea	l01ff(pc),a5
	movea.l	(a2),a4
	clr.l	4(a2)
	clr.l	18(a2)
	move	d1,d4
	addq	#3,d4
	bset	d1,7(a5)
	bset	d4,7(a5)
	st	22(a2)
	btst	#0,(a4)
	beq.s	.l01ad
	bclr	d1,7(a5)
.l01ad:
	btst	#1,(a4)
	beq	.l01b4
	bclr	d4,7(a5)
	move.b	20(a4),23(a2)
	cmpi.b	#-1,1(a4)
	beq.s	.l01b4
	btst	#2,(a4)
	beq.s	.l01ae
	move.b	1(a4),22(a2)
	bra.s	.l01b1
;
.l01ae:
	move.b	d3,d4
	subi.b	#$3e,d4
	neg.b	d4
	lsr.b	#1,d4
	add.b	1(a4),d4
	subi.b	#$f,d4
	bpl.s	.l01af
	clr.b	d4
	bra.s	.l01b0
;
.l01af:
	cmpi.b	#$1f,d4
	ble.s	.l01b0
	moveq	#$1f,d4
.l01b0:
	move.b	d4,22(a2)
.l01b1:
	move.b	26(a4),38(a2)
	clr.b	37(a2)
	move.b	24(a4),39(a2)
	move.b	22(a4),41(a2)
	move.b	#1,40(a2)
	move.b	7(a4),d4
	lsr.b	#4,d4
	cmpi.b	#3,d4
	bne.s	.l01b2
	move.b	22(a4),d5
	add.b	d5,d5
	move.b	d5,40(a2)
	bra.s	.l01b4
;
.l01b2:
	tst.b	23(a4)
	bne.s	.l01b3
	move.b	#3,40(a2)
.l01b3:
	cmpi.b	#1,d4
	bne.s	.l01b4
	neg.b	40(a2)
.l01b4:
	move.b	12(a4),d4
	lsr.b	#4,d4
	move.b	d4,7(a2)
	move.b	10(a4),25(a2)
	move.b	7(a4),d4
	andi.b	#3,d4
	cmpi.b	#3,d4
	bne.s	.l01b5
	move.b	9(a4),d5
	bra.s	.l01b6
;
.l01b5:
	moveq	#1,d5
	tst.b	8(a4)
	bne.s	.l01b6
	moveq	#2,d5
.l01b6:
	move.b	d5,26(a2)
	neg.b	d5
	move.b	d5,24(a2)
	cmpi.b	#1,d4
	bne.s	.l01b7
	neg.b	26(a2)
.l01b7:
	move.b	13(a4),27(a2)
	moveq	#0,d5
	move.b	11(a4),d5
	move	d5,28(a2)
	move.b	7(a4),d4
	lsr.b	#2,d4
	andi.b	#3,d4
	cmpi.b	#3,d4
	bne.s	.l01b8
	add	d5,d5
	bra.s	.l01b9
;
.l01b8:
	move.b	2(a4),d5
	addq	#1,d5
	cmpi.b	#1,d4
	bne.s	.l01b9
	neg	d5
.l01b9:
	move	d5,30(a2)
	move.b	17(a4),36(a2)
	moveq	#0,d5
	move.b	16(a4),d5
	addq	#1,d5
	clr	32(a2)
	btst	#6,(a4)
	bne.s	.l01ba
	neg	d5
	move	14(a4),32(a2)
.l01ba:
	move	d5,34(a2)
	lea	snd_fq_time_t(pc),a5
	btst	#5,(a4)
	bne.s	.l01bb
	addi.b	#$c,d3
.l01bb:
	add	d3,d3
	move	0(a5,d3.w),8(a2)
	move.b	19(a4),20(a2)
	movea.l	a4,a6
	lea	3(a6),a6
	moveq	#0,d4
	moveq	#0,d5
.l01bc:
	move.b	(a6)+,d5
	cmpi.b	#-1,d5
	bne.s	.l01bd
	move	#$ff,10(a2,d4.w)
	tst	d4
	beq.s	.l01c0
	bra.s	.l01bf
;
.l01bd:
	add	d5,d5
	add	d3,d5
	cmpi	#$a8,d5
	ble.s	.l01be
	move	d3,d5
.l01be:
	move	0(a5,d5.w),10(a2,d4.w)
	addq	#2,d4
	cmpi.b	#6,d4
	bne.s	.l01bc
.l01bf:
	btst	#7,(a4)
	beq.s	.l01c0
	move.b	#2,18(a2)
.l01c0:
	rts
;
;-------------------------------------
;
l01c1:
	tst.l	(a2)
	beq	l01e1
	movea.l	(a2),a3
	move	d1,d2
	add	d2,d2
	subq.b	#1,25(a2)
	bhi.s	l01c2
	bsr	l01eb
l01c2:
	subq.b	#1,4(a2)
	bcc.s	l01c8
	move.b	21(a3),4(a2)
l01c3:
	move.b	6(a2),d3
	move.b	27(a3,d3.w),d3
	cmpi.b	#-1,d3
	bne.s	l01c7
	subq.b	#1,7(a2)
	bmi.s	l01c6
	move.b	12(a3),d3
	andi.b	#$f,d3
	add.b	d3,21(a2)
	clr.b	6(a2)
	btst	#1,(a3)
	beq.s	l01c4
	addq	#3,d1
	bclr	d1,7(a1)
	subq	#3,d1
	move.b	20(a3),23(a2)
l01c4:
	clr	32(a2)
	btst	#6,(a3)
	bne.s	l01c5
	move	14(a3),32(a2)
l01c5:
	clr.b	37(a2)
	move.b	19(a3),20(a2)
	clr.b	19(a2)
	bra.s	l01c3
;
l01c6:
	clr.b	7(a2)
	st	22(a2)
	bra.s	l01c8
;
l01c7:
	move.b	d3,5(a2)
	addq.b	#1,6(a2)
l01c8:
	move.b	5(a2),d3
	tst.b	24(a2)
	bmi.s	l01c9
	sub.b	24(a2),d3
l01c9:
	sub.b	l01fc(pc),d3
	sub.b	21(a2),d3
	bpl.s	l01ca
	moveq	#0,d3
l01ca:
	move.b	d3,8(a1,d1.w)
	subq.b	#1,27(a2)
	bcc.s	l01cb
	bsr	l01e5
l01cb:
	subq.b	#1,19(a2)
	bcc.s	l01d0
	move.b	6(a3),19(a2)
	move.b	18(a2),d3
	move	8(a2,d3.w),16(a2)
	tst.b	19(a3)
	beq.s	l01cd
	tst.b	d3
	beq.s	l01cc
	subq.b	#1,20(a2)
l01cc:
	tst.b	20(a2)
	beq.s	l01ce
l01cd:
	addq.b	#2,d3
	andi.b	#7,d3
	cmpi	#$ff,8(a2,d3.w)
	bne.s	l01cf
l01ce:
	moveq	#0,d3
l01cf:
	move.b	d3,18(a2)
l01d0:
	move	16(a2),d4
	tst.b	36(a2)
	bgt.s	l01d2
	btst	#3,(a3)
	bne.s	l01d1
	sub	32(a2),d4
	bra.s	l01d2
;
l01d1:
	add	32(a2),d4
l01d2:
	add	28(a2),d4
	move.b	11(a3),d3
	sub	d3,d4
	bpl.s	l01d3
	moveq	#0,d4
	bra.s	l01d4
;
l01d3:
	cmpi	#$fff,d4
	ble.s	l01d4
	move	#$fff,d4
l01d4:
	move	d4,14(a1)
	move.b	d4,0(a1,d2.w)
	move.b	14(a1),1(a1,d2.w)
	subq.b	#1,36(a2)
	bcc.s	l01d5
	bsr	l01e2
l01d5:
	tst.b	20(a3)
	beq.s	l01d6
	subq.b	#1,23(a2)
	bcc.s	l01d6
	clr.b	23(a2)
	addq.b	#3,d1
	bset	d1,7(a1)
	subq.b	#3,d1
	bra	l01e1
;
l01d6:
	cmpi.b	#-1,22(a2)
	beq	l01e1
	subq.b	#1,39(a2)
	bhi.s	l01db
	move.b	24(a3),39(a2)
	move.b	41(a2),d3
	move.b	22(a3),d4
	add.b	d4,d4
	add.b	40(a2),d3
	bpl.s	l01d8
	move.b	7(a3),d5
	lsr.b	#4,d5
	cmpi.b	#2,d5
	bne.s	l01d7
	moveq	#0,d3
	neg.b	40(a2)
	bra.s	l01d8
;
l01d7:
	move.b	d4,d3
l01d8:
	cmp.b	d4,d3
	ble.s	l01da
	cmpi.b	#2,d5
	bne.s	l01d9
	move.b	d4,d3
	neg.b	40(a2)
	bra.s	l01da
;
l01d9:
	moveq	#0,d3
l01da:
	move.b	d3,41(a2)
l01db:
	move.b	22(a2),d3
	btst	#4,(a3)
	beq.s	l01dc
	add.b	37(a2),d3
	bra.s	l01dd
;
l01dc:
	sub.b	37(a2),d3
l01dd:
	add.b	41(a2),d3
	sub.b	22(a3),d3
	bpl.s	l01de
	moveq	#0,d3
l01de:
	cmpi.b	#$1f,d3
	ble.s	l01df
	move.b	#$1f,d3
l01df:
	move.b	d3,6(a1)
	subq.b	#1,38(a2)
	bcc.s	l01e1
	clr.b	38(a2)
	move.b	37(a2),d4
	add.b	25(a3),d4
	addq.b	#1,d4
	cmp.b	18(a3),d4
	ble.s	l01e0
	move.b	18(a3),d4
l01e0:
	move.b	d4,37(a2)
l01e1:
	rts
;
;-------------------------------------
;
l01e2:
	clr.b	36(a2)
	move	32(a2),d4
	add	34(a2),d4
	bpl.s	l01e3
	moveq	#0,d4
	bra.s	l01e4
;
l01e3:
	move	14(a3),d5
	cmp	d5,d4
	ble.s	l01e4
	move	d5,d4
l01e4:
	move	d4,32(a2)
	rts
;
;-------------------------------------
;
l01e5:
	clr.b	27(a2)
	move.b	7(a3),d4
	lsr.b	#2,d4
	andi.b	#3,d4
	cmpi.b	#3,d4
	bne.s	.l01e6
	move.b	2(a3),27(a2)
.l01e6:
	move	28(a2),d5
	add	30(a2),d5
	move.b	11(a3),d3
	add	d3,d3
	cmp	d3,d5
	ble.s	.l01e8
	cmpi.b	#2,d4
	bne.s	.l01e7
	neg	30(a2)
	move	d3,d5
	bra.s	.l01ea
;
.l01e7:
	moveq	#0,d5
.l01e8:
	tst	d5
	bpl.s	.l01ea
	cmpi.b	#2,d4
	bne.s	.l01e9
	neg	30(a2)
	moveq	#0,d5
	bra.s	.l01ea
;
.l01e9:
	move	d3,d5
.l01ea:
	move	d5,28(a2)
	moveq	#0,d3
	rts
;
;-------------------------------------
;
l01eb:
	move.b	8(a3),25(a2)
	move.b	24(a2),d3
	add.b	26(a2),d3
	bpl.s	l01ed
	move.b	7(a3),d4
	andi.b	#3,d4
	cmpi.b	#2,d4
	bne.s	l01ec
	neg.b	26(a2)
	neg.b	d3
	bra.s	l01ed
;
l01ec:
	move.b	9(a3),d3
l01ed:
	cmp.b	9(a3),d3
	ble.s	l01ef
	cmpi.b	#2,d4
	bne.s	l01ee
	neg.b	26(a2)
	add.b	26(a2),d3
	add.b	26(a2),d3
	bra.s	l01ef
;
l01ee:
	moveq	#0,d3
l01ef:
	move.b	d3,24(a2)
	moveq	#0,d3
	rts
;
;-------------------------------------
;
l01f0:			;sub entry 1
	moveq	#0,d3
	move.b	5(a1),d3
	subq.b	#1,18(a1)
	bne.s	l01f4
	addq.b	#1,d3
l01f1:			;sub entry 2
	movea.l	14(a1),a4
	cmpi.b	#-1,0(a4,d3.w)
	bne.s	.l01f3
	cmpi.b	#1,4(a1)
	beq.s	.l01f2
	bsr.s	sound_out_1
	bra	l01ab
;
.l01f2:
	moveq	#0,d3
.l01f3:
	move.b	0(a4,d3.w),18(a1)
	move.b	d3,5(a1)
l01f4:
	add	d3,d3
	add	d3,d3
	clr	20(a1)
	clr.b	22(a1)
	movea.l	(a1),a4
	movea.l	6(a1),a5
	adda	0(a5,d3.w),a4
	moveq	#0,d4
	move.l	a4,24(a1)
	move.b	2(a5,d3.w),d4
	adda	d4,a4
	move.l	a4,28(a1)
	move.b	3(a5,d3.w),d4
	adda	d4,a4
	move.l	a4,32(a1)
	rts
;
;-------------------------------------
;
sound_out_1:			;sub entry 1
	move.b	#-1,23(a1)
	lea	l01fa(pc),a1	;a1 -> l01fa
	clr.b	5(a1)
	lea	l01ff(pc),a1	;a1 -> l01ff
	clr.l	8(a1)
sound_out_2:			;sub entry 2
	move.b	#7,(hw_psgsel).w
	move.b	(hw_psgrd).w,d4
	move.b	7(a1),d3
	move.b	d3,d5
	move.b	l01fb(pc),d2
	andi.b	#$3f,d2
	and.b	d2,d3
	not.b	d2
	and.b	d2,d4
	or.b	d4,d3
	move.b	d3,7(a1)
	move	l01fa(pc),d2
	lea	14(a1),a1	;a1 -> l01ff + 14
	moveq	#$d,d1
.l01f7:
	btst	d1,d2
	bne.s	.l01f8
	subq	#1,a1
	bra.s	.l01f9
;
.l01f8:
	move.b	d1,(hw_psgsel).w
	move.b	-(a1),(hw_psgwr).w
.l01f9:
	dbra	d1,.l01f7
	move.b	d5,7(a1)
	rts
;
;-------------------------------------
;
l01fa:
	dc.b	$ff,$ff
l01fb:
	dc.b	$ff
l01fc:
	dc.b	$00
l01fd:
	dc.b	$00
l01fe:
	dc.b	$00
l01ff:
	dcb.b	16,0
l0200:
	dcb.w	11,0
	dc.b	$00,$ff,$00,$00,$00,$00,$00,$00
	dcb.w	4,0
l0201:
	dcb.w	21,0
l0202:
	dcb.w	21,0
l0203:
	dcb.w	21,0
;
snd_fq_time_t:
	dc.w	$eec,$e1a,$d4e,$c8a,$bdb,$b31,$a8c,$9f8
	dc.w	$96a,$8e0,$862,$7e8,$777,$70c,$6a7,$647
	dc.w	$5ed,$598,$547,$4fc,$4b4,$470,$431,$3f4
	dc.w	$3bc,$386,$353,$324,$2f6,$2cc,$2a4,$27e
	dc.w	$25a,$238,$218,$1fa,$1de,$1c3,$1aa,$192
	dc.w	$17b,$166,$152,$13f,$12d,$11c,$10c,$fd
	dc.w	$ef,$e1,$d5,$c9,$be,$b3,$a9,$9f
	dc.w	$96,$8e,$86,$7f,$77,$71,$6a,$64
	dc.w	$5f,$59,$54,$50,$4b,$47,$43,$3f
	dc.w	$3b,$39,$35,$32,$30,$2d,$2a,$28
	dc.w	$26,$23,$21,$20,$1d
;
;----------------------------------------------------------------------------
;
	dc.b	'   Module player    V1.06   23.1.1991   '
	dc.b	'   This piece of software was written by Ford Perfect / BMT.        '
	dc.b	'   ...adpation and some changes for MPlayer by Gaston / BMT!    11.02.1992           '
	dc.b	'   UUUUUAAAHAHAHAHAHAH!'
	dc.b	" THIS IS SHITY SELF-MODIFYING CODE!             I LOVE ILLEGAL'S...."
	dc.b	" (HEY, THIS IS AN INSIDER JOKE, so don't look so stupid an scroll up or down!)  "
;
;----------------------------------------------------------------------------
;
init_sample_mod_play:
	move.l	a0,l02bc
	move.l	d0,l02bd
	clr.l	time_c_cnt
	move	#$40,l02d5
	moveq	#1,d2
	tst.b	use_SDMA_f
	bpl.s	l0206
	moveq	#2,d2
l0206:
	move	d2,psg_1_dma_2_f
	cmpi	#2,d2
	beq.s	l0208
	tst.b	top_khz_f
	bpl.s	l0207
	move	#ref_fq/norm_hf,psg_sample_fq_divisor	;Orig: 31 for 19820 Hz
	tst.b	speedup_f
	bpl.s	l020d
	move	#ref_fq/fast_hf,psg_sample_fq_divisor	;New:  30 for 20480 Hz
	bra.s	l020d
;
l0207:
	move	#ref_fq/norm_lf,psg_sample_fq_divisor	;Orig: 80 for 7680 Hz
	tst.b	speedup_f
	bpl.s	l020d
	move	#ref_fq/fast_lf,psg_sample_fq_divisor	;New:  65 for 9452 Hz
	bra.s	l020d
;
l0208:
	tst.b	top_khz_f
	bpl.s	l020a
	move	d2,l02de
	bra.s	l020b
;
l020a:
	move	#1,l02de
l020b:
	moveq	#0,d0
	move	l02de(pc),d0
	add	d0,d0
	move	sdma_freq_t(pc,d0.w),d0
	move	d0,sample_fq
	divu	#50,d0
	move	d0,l02db
	bra.s	l020e
;
;
sdma_freq_t:
	dc.w	6258,12516,25032,50086
;
;
l020d:
	move.l	#$96000,d0
	divu	psg_sample_fq_divisor(pc),d0
	move	d0,sample_fq
	ext.l	d0
	divu	#50,d0
	move	d0,l02db
	bsr	l0245
l020e:
	move	sample_fq(pc),d3
	move.l	#$367ee492,d1
	cmp	#14000,d3
	ble.s	.l0210
	divu	d3,d1
	moveq	#0,d0
	move	d1,d0
	clr	d1
	divu	d3,d1
	move.l	d1,d2
	swap	d2
	add	d2,d2
	cmp	d3,d2
	blt.s	.l020f
	addq.l	#1,d1
.l020f:
	and.l	#$ffff,d1
	bra.s	.l0212
;
.l0210:
	lsr.l	#1,d1
	divu	d3,d1
	moveq	#0,d0
	move	d1,d0
	add.l	d0,d0
	clr	d1
	divu	d3,d1
	move.l	d1,d2
	swap	d2
	add	d2,d2
	cmp	d3,d2
	blt.s	.l0211
	addq.l	#1,d1
.l0211:
	and.l	#$ffff,d1
	moveq	#0,d2
	add	d1,d1
	addx.l	d2,d0
.l0212:
	move.l	#$ffff,d7
	lea	l02f2,a0
	clr.l	(a0)+
	move	#$367,d2
.l0213:
	move	#$368,d5
	sub	d2,d5
	move.l	d0,d3
	divu	d5,d3
	move.l	d3,d6
	and.l	d7,d3
	lsl.l	#8,d3
	clr	d6
	swap	d6
	lsl.l	#8,d6
	divu	d5,d6
	and.l	d7,d6
	add.l	d6,d3
	move.l	d1,d4
	divu	d5,d4
	and.l	d7,d4
	lsr.l	#8,d4
	add.l	d4,d3
	move.l	d3,(a0)+
	dbra	d2,.l0213
	move.l	#l02f5,d0
	clr.b	d0
	move.l	d0,l02d4
	movea.l	l02d4(pc),a0
	lea	16640(a0),a0
	moveq	#$40,d0
	moveq	#$40,d5
.l0214:
	move	d0,d3
	moveq	#-$80,d4
	moveq	#$7f,d1
	cmpi	#1,psg_1_dma_2_f
	beq.s	.l0216
.l0215:
	move.l	d4,d2
	muls	d3,d2
	divs	d5,d2
	asr	#1,d2
	move	d2,-(a0)
	addq.l	#2,d4
	dbra	d1,.l0215
	bra.s	.l0217
;
.l0216:
	move.l	d4,d2
	muls	d3,d2
	divs	d5,d2
	add	#$80,d2
	add	d2,d2
	add	d2,d2
	move	d2,-(a0)
	addq.l	#2,d4
	dbra	d1,.l0216
.l0217:
	dbra	d0,.l0214
	lea	l02eb(pc),a0
	move	#7,d0
.l0218:
	move	#$8080,(a0)+
	dbra	d0,.l0218
	movea.l	l02bc(pc),a0
	lea	952(a0),a1
	moveq	#$7f,d0
	moveq	#0,d2
	moveq	#0,d1
.l0219:
	move.b	(a1)+,d1
	cmp.b	d2,d1
	ble.s	.l021a
	move.l	d1,d2
.l021a:
	dbra	d0,.l0219
	addq.b	#1,d2
	asl.l	#8,d2
	asl.l	#2,d2
	lea	4(a1,d2.l),a2
	lea	samplestarts(pc),a1	;a1 -> sample pointer table
	lea	42(a0),a0		;a0 -> sample length of first sample header
	movea.l	l02bc(pc),a4
	adda.l	l02bd(pc),a4
	tst.b	l00b8
	bmi	.l0224
	movea.l	a4,a3
	adda.l	#$4a1c,a3
.l021b:
	move	-(a4),d0
	eori	#$8080,d0
	and	#-$102,d0
	move	d0,-(a3)
	cmpa.l	a2,a4
	bgt.s	.l021b
	moveq	#$1e,d0
.l021c:				;loop to initialize each sample
	move.l	a4,(a1)+	;store ptr to new sample destination in table
	move	(a0),d1		;d1 = Sample_length
	beq.s	.l0223		;if no length, skip to next sample
	moveq	#0,d4		;d4 = 0
	moveq	#0,d2
	move	4(a0),d2	;d2 = Repeat_Start
	move.l	d2,d3		;d3 = Repeat_Start
	lea	0(a4,d2.l),a5	;\
	adda.l	d2,a5		;/ a5 -> loop start
	movea.l	a5,a6		;a6 -> loop start
	moveq	#0,d2
	move	6(a0),d2	;d2 = Repeat_Length
	cmp	#1,d2
	ble.s	.l021d		;if Repeat_Length < 1 goto .L021d
	add.l	d2,d3		;d3 = Repeat_Start + Repeat_Length
	cmp.l	d1,d3
	bge.s	.l021d		;if d3 >= Sample_Length goto .L021d
	move.l	d1,d4
	sub.l	d3,d4
	add.l	d4,d4		;d4 = 2*(Sample_Length - (Repeat_Start+Repeat_Lenght)
	move.l	d3,d1		;d1 = Repeat_Start+Repeat_Length
.l021d:
	subq	#1,d1		;prep d1 for dbra
.l021e:
	move	(a3)+,(a4)+	;copy 2 sample bytes
	dbra	d1,.l021e	;loop back for more sample data
	adda.l	d4,a3		;a3 -> next sample
	move.l	a4,d7
	add.l	#$264,d7	;d7 = demand $264 loop bytes minimum
	add.l	d4,d7		;d7 += sample excess bytes
	cmp	#1,d2
	bgt.s	.l0220		;goto .l0220 if Repeat_Length > 1
.l021f:
	cmpa.l	d7,a4
	bge.s	.l0223		;if padding complete goto .l0223
	move	#$8080,(a4)+	;pad 2 silent repeat data bytes
	bra.s	.l021f		;loop back for more silent data
;
.l0220:
	subq	#1,d2		;prep d2 for dbra as sample loop count
.l0221:
	move	d2,d1		;d1 = sample loop count for dbra
.l0222:
	cmpa.l	d7,a4
	bge.s	.l0223		;if sample loop data complete goto .l0223
	move	(a5)+,(a4)+	;copy 2 sample loop data bytes
	dbra	d1,.l0222	;loop back for more sample loop data
	movea.l	a6,a5		;a5 -> loop start again
	bra.s	.l0221		;loop back for more sample loops
;
.l0223:
	lea	30(a0),a0	;a0 -> sample length in next sample header
	dbra	d0,.l021c	;loop back to convert more samples
.l0224:
	movea.l	l02bc(pc),a3
	adda.l	l02bd(pc),a3
	adda.l	#$4a1c,a3
	bra.s	.l0226
;
.l0225:
	move	#$8080,(a4)+
.l0226:
	cmpa.l	a3,a4
	blt.s	.l0225
rewind_sample_mod_play:				;subroutine entry
	tst.b	l00b8
	bpl.s	.l0228
	cmpi.b	#2,l00c2	;continue music ? (after pause)
	beq.s	.l0229
.l0228:
	move.b	#6,speed
	clr.b	songpos
	clr.b	counter
	clr	pattpos
	clr	l02be
.l0229:
	clr.b	l00bc
	lea	l02c4(pc),a0
	lea	l02eb(pc),a1
	move.l	#$10000,d0
	moveq	#3,d1
.l022a:
	move.l	a1,(a0)+
	move.l	d0,(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	dbra	d1,.l022a
	move.l	#l02f4,l02d9
	move.l	#l02f3,l02da
	bsr	l025c
continue_sample_mod_play:				;subroutine entry
	move	sr,-(sp)
	ori	#$700,sr
	bsr	clear_psg
	lea	l00bb(pc),a0
	move.b	(hw_tacr).w,(a0)+
	move.b	(hw_iera).w,(a0)+
	move.b	(hw_imra).w,(a0)
	clr.b	(hw_tacr).w
	bset	#5,(hw_iera).w
	bset	#5,(hw_imra).w
	cmpi	#1,psg_1_dma_2_f
	beq	.l022d
	tst.b	top_khz_f
	bpl.s	.l022c
	tst.b	new_CPU_f
	beq	l0230
.l022c:
	bset	#5,(hw_ierb).w
	bset	#5,(hw_imrb).w
	ori.b	#$50,(hw_tcdcr).w
	lea	(iv_time_c).w,a0
	lea	nu_time_c_dma+8(pc),a1
	move.l	(a0),(a1)+
	move.l	a1,(a0)
	lea	(iv_kb_midi).w,a0
	lea	nu_kb_midi_mod+8(pc),a1
	move.l	(a0),(a1)+
	move.l	a1,(a0)
	lea	(iv_time_a).w,a0
	lea	mod_time_a_save_p(pc),a1
	move.l	(a0),(a1)
	move.l	#nu_time_a_mod_dma,(a0)
	move.b	(hw_sdmacont).w,l00b0
	bsr	setup_mywire
	clr	l02d6
	move.l	l02d9(pc),d0
	moveq	#0,d1
	move	l02db(pc),d1
	add	d1,d1
	add.l	d0,d1
	movea	#-$7700,a0
	movep	d0,5(a0)
	swap	d0
	move.b	d0,3(a0)
	movep	d1,17(a0)
	swap	d1
	move.b	d1,15(a0)
	bsr	l02e5
	bsr	music
	move.b	#3,(hw_sdmacont).w
	move.b	#1,(hw_tadr).w
	move.b	#8,(hw_tacr).w
	bra.s	.l022e
;
.l022d:
	tst.b	top_khz_f
	bmi.s	l0230
	lea	(iv_kb_midi).w,a0
	lea	nu_kb_midi_mod+8(pc),a1
	move.l	(a0),(a1)+
	move.l	a1,(a0)
	bset	#5,(hw_ierb).w
	bset	#5,(hw_imrb).w
	ori.b	#$50,(hw_tcdcr).w
	lea	(iv_time_c).w,a0
	lea	nu_time_c_psg+8(pc),a1
	move.l	(a0),(a1)+
	move.l	a1,(a0)
	lea	(iv_time_a).w,a0
	lea	mod_time_a_save_p(pc),a1
	move.l	(a0),(a1)
	lea	nu_time_a_mod_psg_p(pc),a1
	move.l	(a1),(a0)
	move.b	l02dd(pc),(hw_tadr).w
	move.b	#1,(hw_tacr).w
.l022e:
	move	(sp)+,sr
	rts
;
;
l022f:
	move	sr,-(sp)
	ori	#$700,sr
	move.l	nu_time_c_psg+8(pc),(iv_time_c).w
	move.l	nu_kb_midi_mod+8(pc),(iv_kb_midi).w
	move.l	mod_time_a_save_p(pc),(iv_time_a).w
	cmpi	#2,psg_1_dma_2_f
	bne.s	l0230
	move.b	l00b0(pc),(hw_sdmacont).w
	move.l	nu_time_c_dma+8(pc),(iv_time_c).w
l0230:
	lea	l00bb(pc),a0
	move.b	(a0)+,(hw_tacr).w
	move.b	(a0)+,(hw_iera).w
	move.b	(a0),(hw_imra).w
	move	(sp)+,sr
	rts
;
;----------------------------------------------------------------------------
;
setup_mywire:
	clr.b	(hw_sdmacont).w
	move.b	l02df(pc),(hw_sdmamode).w
	moveq	#$28,d0
	bsr.s	l0232
	moveq	#$14,d0
	bsr.s	l0233
	moveq	#$14,d0
	bsr.s	l0234
	moveq	#7,d0
	bsr.s	l0235
	moveq	#9,d0
	bsr.s	l0236
	moveq	#2,d0
	bra.s	l0237
;
l0232:
	or	#$4c0,d0
	bra.s	l0238
;
l0233:
	or	#$540,d0
	bra.s	l0238
;
l0234:
	or	#$500,d0
	bra.s	l0238
;
l0235:
	or	#$480,d0
	bra.s	l0238
;
l0236:
	or	#$440,d0
	bra.s	l0238
;
l0237:
	or	#$400,d0
l0238:
	move	#$7ff,(hw_mywiremask).w
	cmpi	#$7ff,(hw_mywiremask).w
	bne.s	l0238
	move	d0,(hw_mywiredata).w
	rts
;
;----------------------------------------------------------------------------
;
	make	AV_links
;
;----------------------------------------------------------------------------
;		XBRA linked TIME_C routine for PSG sound
;----------------------------------------------------------------------------
;
	XB_define	nu_time_c_psg,'BMT!'
	addq	#1,time_c_cnt
	andi	#3,time_c_cnt
	beq.s	.make_music
	XB_gonext_d	nu_time_c_psg(pc)
;
.make_music:
	push_ex		post_time_c_psg
	XB_gonext_d	nu_time_c_psg(pc)
;
post_time_c_psg:
	move	#$2500,sr
	movem.l	a0-a6/d0-d7,-(sp)
	st	l00bc
	bsr	l02e5
	bsr	music
	clr.b	l00bc
	movem.l	(sp)+,a0-a6/d0-d7
	rte
;
;----------------------------------------------------------------------------
;End of:	XBRA linked TIME_C routine for PSG sound
;----------------------------------------------------------------------------
;
time_c_cnt:
	dcb.w	2,0
;
;----------------------------------------------------------------------------
;		XBRA linked TIME_C routine for DMA sound
;----------------------------------------------------------------------------
;
	XB_define	nu_time_c_dma,'BMT!'
	addq	#1,time_c_cnt
	andi	#3,time_c_cnt
	beq.s	.make_music
	XB_gonext_d	nu_time_c_dma(pc)
;
.make_music:
	push_ex		post_time_c_dma
	XB_gonext_d	nu_time_c_dma(pc)
;
post_time_c_dma:
	move	#$2500,sr
	movem.l	a0-a6/d0-d7,-(sp)
.sync_loop:
	tst.b	l00bc
	bne.s	.sync_loop
	bsr	l02e5
	bsr	music
	movem.l	(sp)+,a0-a6/d0-d7
	rte
;
;----------------------------------------------------------------------------
;End of:	XBRA linked TIME_C routine for DMA sound
;----------------------------------------------------------------------------
;		XBRA linked KB_MIDI routine for music modules
;----------------------------------------------------------------------------
;
mod_time_a_save_p:
	ds.l	1
	dc.l	release_ram
;
	XB_define	nu_kb_midi_mod,'MOD!'
	move	#$2500,sr
	tst.b	($feedface).l
kbsh_p_3	=	*-4
	beq.s	l0244
	cmpi.b	#$c,($feedface).l
kbsh_c_2	=	*-6
kbsh_p_4	=	*-4
	bne.s	l0244
	andi.b	#2,(conterm).w
	movem.l	a5/d0-d1,-(sp)
	st	auto_req_f
	bsr	clear_psg
	movem.l	(sp)+,a5/d0-d1
l0244:
	XB_gonext_d	nu_kb_midi_mod(pc)
;
;----------------------------------------------------------------------------
;End of:	XBRA linked KB_MIDI routine for music modules
;----------------------------------------------------------------------------
;
l0245:
	lea	l02ec(pc),a0
	bsr.s	l0248
	move.l	a0,nu_time_a_mod_psg_p
	lea	l0256(pc),a1
	lea	l0259(pc),a2
l0246:
	move	(a1)+,(a0)+
	cmpa.l	a2,a1
	blt.s	l0246
	lea	l02ee(pc),a0
	bsr.s	l0248
	lea	l0259(pc),a1
	lea	l025c(pc),a2
l0247:
	move	(a1)+,(a0)+
	cmpa.l	a2,a1
	blt.s	l0247
	rts
;
;
l0248:
	move.l	l0254(pc),d7
	tst.b	top_khz_f
	bpl.s	l0249
	subq.l	#6,d7
l0249:
	move.l	d7,l0255
	lea	l0252(pc),a1
	lea	l0253(pc),a2
	move	l02db(pc),d0
	subq	#2,d0
l024a:
	move.l	a0,d1
	move.l	d1,d2
	add.l	d7,d2
	lea	l0251(pc),a3
	move.l	(a3)+,(a0)+
	move.l	(a3)+,(a0)+
	move.l	(a3)+,(a0)+
	move.l	(a3)+,(a0)+
	cmp	d1,d2
	bcs.s	l024d
	movea.l	a2,a3
	move	(a3)+,(a0)+
	move	d2,(a0)+
	addq.l	#2,a3
	move	(a3)+,(a0)+
	tst.b	top_khz_f
	bmi.s	l024b
	move.l	(a3)+,(a0)+
	move	(a3)+,(a0)+
	bra.s	l024c
;
l024b:
	addq.l	#6,a3
l024c:
	move.l	(a3)+,(a0)+
	bra.s	l0250
;
l024d:
	movea.l	a1,a3
	move	(a3)+,(a0)+
	move.l	d2,(a0)+
	addq.l	#4,a3
	move	(a3)+,(a0)+
	tst.b	top_khz_f
	bmi.s	l024e
	move.l	(a3)+,(a0)+
	move	(a3)+,(a0)+
	bra.s	l024f
;
l024e:
	addq.l	#6,a3
l024f:
	move	(a3)+,(a0)+
l0250:
	dbra	d0,l024a
	rts
;
;
l0251:
	move.l	#$8000f00,(hw_psgsel).w
	move.l	#$9000f00,(hw_psgsel).w
l0252:
	move.l	#0,(iv_time_a).w
	bclr	#5,(hw_isra).w
	rte
;
;
;NB: BUGGED !!! (but fortunately unused)
	move.l	#$8000f00,(hw_psgsel).w
	move.l	#$9000f00,(hw_psgsel).w
l0253:					;NB: BUGGED !!! (but hopefully unused)
	move	#0,$136.w
	bclr	#5,(hw_isra).w
	rte
;
;
	nop
l0254:
	dc.l	32
l0255:
	dc.l	32
;
;
l0256:
	move.l	#$8000f00,(hw_psgsel).w
	move.l	#$9000f00,(hw_psgsel).w
	move	#$2500,sr
	tst.b	l00bc
	bmi.s	l0257
	move.l	#l02ee,(iv_time_a).w
l0257:
	move.l	#l02ed,l02d8
	tst.b	top_khz_f
	bmi.s	l0258
	bclr	#5,(hw_isra).w
	rte
;
;
l0258:
	movem.l	a0-a6/d0-d7,-(sp)
	jsr	l02e5
	jsr	music
	movem.l	(sp)+,a0-a6/d0-d7
	rte
;
;
l0259:
	move.l	#$8000f00,(hw_psgsel).w
	move.l	#$9000f00,(hw_psgsel).w
	move	#$2500,sr
	tst.b	l00bc
	bmi.s	l025a
	move.l	#l02ec,(iv_time_a).w
l025a:
	move.l	#l02ef,l02d8
	tst.b	top_khz_f
	bmi.s	l025b
	bclr	#5,(hw_isra).w
	rte
;
;
l025b:
	movem.l	a0-a6/d0-d7,-(sp)
	jsr	l02e5
	jsr	music
	movem.l	(sp)+,a0-a6/d0-d7
	rte
;
;
l025c:
	cmpi	#1,psg_1_dma_2_f
	beq.s	l025e
	tst	use_cache_f
	bmi.s	l025d
	bsr	l0266
	move.l	#l0274,l02e3
	bsr	l026c
	move.l	#l026f,l02e4
	rts
;
;
l025d:
	move.l	#l0269,l02e3
	move.l	#l0270,l02e4
	rts
;
;
l025e:
	lea	l02f0,a0
	lea	l0276(pc),a1
	lea	l0277(pc),a2
	tst.b	top_khz_f
	bmi.s	l0260
	tst.b	l00ba
	bmi.s	l025f
	move	(a1),d0
	cmp	(a0),d0
	beq.s	l0263
l025f:
	clr.b	l00ba
l0260:
	move	#$1a3,d0
	moveq	#0,d1
l0261:
	movea.l	a1,a3
l0262:
	move	(a3)+,(a0)+
	cmpa.l	a2,a3
	blt.s	l0262
	move	(a3)+,(a0)+
	move	d1,(a0)+
	addq.l	#2,a3
	move	(a3)+,(a0)+
	move	(a3)+,(a0)
	add	d1,(a0)+
	add.l	l0255(pc),d1
	dbra	d0,l0261
	move.l	#l0275,l02e4
	bra.s	l0264
;
l0263:
	movea.l	l0265(pc),a0
	move	d0,(a0)
l0264:
	move	l02db(pc),d0
	mulu	#$26,d0
	lea	l02f0,a0
	adda.l	d0,a0
	move	#$4e75,(a0)
	move.l	a0,l0265
	bsr.s	l0266
	move.l	#l0274,l02e3
	rts
;
;
l0265:
	dcb.w	2,0
l0266:
	lea	l02f1,a0
	lea	l026a(pc),a1
	lea	l026b(pc),a2
	move	#$f9,d0
l0267:
	movea.l	a1,a3
l0268:
	move	(a3)+,(a0)+
	cmpa.l	a2,a3
	blt.s	l0268
	dbra	d0,l0267
	move	l02db(pc),d0
	move	d0,d1
	and	#1,d1
	mulu	#$1a,d1
	lsr	#1,d0
	mulu	#$1a,d0
	lea	l02f1,a0
	add.l	d1,d0
	move	#$4e75,0(a0,d0.l)
	adda.l	d1,a0
	move.l	a0,l0273
	rts
;
;
l0269:
	move	l02db(pc),d7
	subq	#1,d7
l026a:
	move.b	0(a0,d2.w),d0
	move.b	0(a1,d3.w),d5
	add.l	a2,d2
	addx	d4,d2
	add.l	d1,d3
	addx	d4,d3
	movea.l	d0,a3
	move	(a3),d6
	movea.l	d5,a3
	add	(a3),d6
	move	d6,(a4)+
l026b:
	dbra	d7,l026a
	rts
;
;
l026c:
	lea	l02f0,a0
	lea	l0271(pc),a1
	lea	l0272(pc),a2
	move	l02db(pc),d0
	lsr	#1,d0
	subq	#1,d0
l026d:
	movea.l	a1,a3
l026e:
	move	(a3)+,(a0)+
	cmpa.l	a2,a3
	blt.s	l026e
	dbra	d0,l026d
	move	#$4e75,(a0)
	rts
;
;
l026f:
	pea	l02f0
	jmp	l02f0
;
;
l0270:
	move	l02db(pc),d7
	subq	#1,d7
l0271:
	move.b	0(a0,d2.w),d0
	move.b	0(a1,d3.w),d5
	add.l	a2,d2
	addx	d4,d2
	add.l	d1,d3
	addx	d4,d3
	movea.l	d0,a3
	move	(a3),d6
	movea.l	d5,a3
	add	(a3),d6
	move.b	d6,(a4)
	addq.l	#2,a4
l0272:
	dbra	d7,l0271
	rts
;
;
l0273:
	dc.l	l02f1
l0274:
	move.l	l0273(pc),-(sp)
	jmp	l02f1
;
;
l0275:
	movea.l	l02d8(pc),a5
	lea	l02ea(pc),a6
	move.l	a6,d7
	jmp	l02f0
;
;
l0276:
	move.b	0(a0,d2.w),d0
	move.b	0(a1,d3.w),d5
	add.l	a2,d2
	addx	d4,d2
	add.l	d1,d3
	addx	d4,d3
	movea.l	d0,a3
	move	(a3),d6
	movea.l	d5,a3
	add	(a3),d6
	add	(a4)+,d6
	movea.l	d7,a6
	adda	d6,a6
l0277:
	move.b	(a6)+,0(a5)
	move.b	(a6),8(a5)
nu_time_a_mod_dma:
	move	#$2500,sr
	movem.l	a0/d0-d1,-(sp)
	st	l00bc
	move.l	l02d9(pc),d0
	moveq	#0,d1
	move	l02db(pc),d1
	add	d1,d1
	add.l	d0,d1
	movea	#-$7700,a0
	movep	d0,5(a0)
	swap	d0
	move.b	d0,3(a0)
	movep	d1,17(a0)
	swap	d1
	move.b	d1,15(a0)
	clr.b	l00bc
	movem.l	(sp)+,a0/d0-d1
	bclr	#5,(hw_isra).w
	rte
;
;
l0279:
	move	#$2500,sr
	movem.l	a0-a6/d0-d7,-(sp)
	move.l	l02d9(pc),d0
	moveq	#0,d1
	move	l02db(pc),d1
	add	d1,d1
	add.l	d0,d1
	movea	#-$7700,a0
	movep	d0,5(a0)
	swap	d0
	move.b	d0,3(a0)
	movep	d1,17(a0)
	swap	d1
	move.b	d1,15(a0)
	bsr	l02e5
	bsr.s	music
	movem.l	(sp)+,a0-a6/d0-d7
	rte
;
;----------------------------------------------------------------------------
;	Module pattern player
;
music:
	move	l02be(pc),l02bf
	movem.l	a0-a4/d0-d3,-(sp)
	addq.b	#1,counter
	move.b	counter(pc),d0
	cmp.b	speed(pc),d0
	blt	nonew
	clr.b	counter
;getnew:
	movea.l	l02bc(pc),a0
	lea	12(a0),a3
	lea	952(a0),a2
	lea	1084(a0),a0
	moveq	#0,d0
	moveq	#0,d1
	move.b	songpos(pc),d0
	move.b	0(a2,d0.w),d1
	lsl	#8,d1
	lsl	#2,d1
	add	pattpos(pc),d1
	clr	dmacon
	lea	aud1lc(pc),a1
	lea	voice1(pc),a4
	bsr	playvoice
	addq.l	#4,d1
	lea	aud2lc(pc),a1
	lea	voice2(pc),a4
	bsr	playvoice
	addq.l	#4,d1
	lea	aud3lc(pc),a1
	lea	voice3(pc),a4
	bsr	playvoice
	addq.l	#4,d1
	lea	aud4lc(pc),a1
	lea	voice4(pc),a4
	bsr	playvoice
	move	l02bf(pc),d0
	move	dmacon(pc),d1
	move	d0,d2
	or	d1,d2
	move	d2,l02be
	and	d1,d0
	eor	d1,d0
	lea	aud1lc(pc),a4
	lea	l02c4(pc),a0
	moveq	#3,d1
l027b:
	lsr	#1,d2
	bcs.s	l027c
	move.l	#l02eb,(a0)+
	move.l	#$10000,(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr	8(a4)
	lea	16(a4),a4
	lsr	#1,d0
	bra.s	l027e
;
l027c:
	lsr	#1,d0
	bcs.s	l027d
	lea	16(a0),a0
	lea	16(a4),a4
	bra.s	l027e
;
l027d:
	move.l	(a4)+,(a0)+
	move.l	(a4)+,(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	lea	8(a4),a4
l027e:
	dbra	d1,l027b
	lea	l02b8(pc),a4
	lea	aud1lc(pc),a3
	move.l	(a4),(a3)
	move	4(a4),4(a3)
	move.l	28(a4),16(a3)
	move	32(a4),20(a3)
	move.l	56(a4),32(a3)
	move	60(a4),36(a3)
	move.l	84(a4),48(a3)
	move	88(a4),52(a3)
	addi	#$10,pattpos
	cmpi	#$400,pattpos
	bne.s	l0280
l027f:
	clr	pattpos
	clr.b	break_f
	addq.b	#1,songpos
	andi.b	#$7f,songpos
	move.b	-2(a2),d0
	cmp.b	songpos(pc),d0
	bne.s	l0280
	st	circuit_f
	move.b	-1(a2),songpos
	cmp.b	songpos(pc),d0
	bge.s	l0280
	clr.b	songpos
l0280:
	tst.b	break_f
	bne.s	l027f
	movem.l	(sp)+,a0-a4/d0-d3
	rts
;
;
nonew:
	lea	voice1(pc),a4
	lea	aud1lc(pc),a1
	bsr	checkcom
	lea	voice2(pc),a4
	lea	aud2lc(pc),a1
	bsr	checkcom
	lea	voice3(pc),a4
	lea	aud3lc(pc),a1
	bsr	checkcom
	lea	voice4(pc),a4
	lea	aud4lc(pc),a1
	pea	l0280(pc)
	bra	checkcom
;
;----------------------------------------------------------------------------
;
l0282:	;table of words=index*30=(offset/2)*30
	dc.w	0,$1e,$3c,$5a,$78,$96,$b4,$d2
	dc.w	$f0,$10e,$12c,$14a,$168,$186,$1a4,$1c2
	dc.w	$1e0,$1fe,$21c,$23a,$258,$276,$294,$2b2
	dc.w	$2d0,$2ee,$30c,$32a,$348,$366,$384,$3a2
;
;----------------------------------------------------------------------------
;
playvoice:
	move.l	0(a0,d1.l),(a4)
	moveq	#0,d2
	move.b	2(a4),d2
	lsr.b	#4,d2			;d2 = low nybble of sample index
	move.b	(a4),d0
	and.b	#-$10,d0
	or.b	d0,d2			;d2 = sample index
	beq.s	setregs			;jump if no sample index
	asl	#2,d2			;d2 = sample index * 4
	move.l	a3,-(sp)
	lea	samplestarts-4(pc),a3
	move.l	0(a3,d2.l),4(a4)
	movea.l	(sp)+,a3
	lsr	#1,d2
	move	l0282(pc,d2.w),d2
	move	0(a3,d2.w),8(a4)
	move	2(a3,d2.w),18(a4)
	moveq	#0,d3
	move	4(a3,d2.w),d3
	beq.s	.noloop
	move.l	4(a4),d0
	add	d3,d3
	add.l	d3,d0
	move.l	d0,10(a4)
	move	4(a3,d2.w),d0
	add	6(a3,d2.w),d0
	move	d0,8(a4)
	bra.s	l0285
;
.noloop:
	move.l	4(a4),d0
	move.l	d0,10(a4)
l0285:
	move	6(a3,d2.w),14(a4)
	moveq	#0,d0
	move.b	19(a4),d0
	move	d0,8(a1)
setregs:
	move	(a4),d0
	and	#$fff,d0		;d0 = Note_Period
	beq	checkcom2		;jump if no period
	tst	8(a4)
	beq.s	l0287
	tst.b	18(a4)
	bne.s	l0287
	move.b	2(a4),d0
	and.b	#$f,d0			;d0 = main command nybble
	cmp.b	#5,d0
	beq.s	l0288
	cmp.b	#3,d0
	beq.s	l0288
setperiod:
	move	(a4),16(a4)
	andi	#$fff,16(a4)		;16(a4) = Note_Period
	move	26(a4),d0
	or	d0,dmacon
	not	d0
	and	d0,l02bf
	clr.b	25(a4)
	move.l	4(a4),(a1)
	move	8(a4),4(a1)
	move	16(a4),6(a1)
	bra	checkcom2
;
l0287:
	move	26(a4),d0
	not	d0
	and	d0,l02bf
	bra	checkcom2
;
l0288:
	move	(a4),d2
	and	#$fff,d2
	move	d2,22(a4)
	move	16(a4),d0
	clr.b	20(a4)
	cmp	d0,d2
	beq.s	l0289
	bge	checkcom2
	move.b	#1,20(a4)
	bra	checkcom2
;
l0289:
	clr	22(a4)
	rts
;
;----------------------------------------------------------------------------
;
com_myport:
	move.b	3(a4),d0
	beq.s	l028b
	move.b	d0,21(a4)
	clr.b	3(a4)
l028b:
	tst	22(a4)
	beq.s	l028d
	moveq	#0,d0
	move.b	21(a4),d0
	tst.b	20(a4)
	bne.s	l028e
	add	d0,16(a4)
	move	22(a4),d0
	cmp	16(a4),d0
	bgt.s	l028c
	move	22(a4),16(a4)
	clr	22(a4)
l028c:
	move	16(a4),6(a1)
l028d:
	rts
;
;
l028e:
	sub	d0,16(a4)
	move	22(a4),d0
	cmp	16(a4),d0
	blt.s	l028c
	move	22(a4),16(a4)
	clr	22(a4)
	move	16(a4),6(a1)
	rts
;
;----------------------------------------------------------------------------
;
l028f:
	dc.w	$18,$314a,$6178,-$725f,-$4b3b,-$2b20,-$140c,-$503
	dc.w	-3,-$50c,-$1420,-$2b3b,-$4b5f,-$7288,$614a,$3118
;
;----------------------------------------------------------------------------
;
com_vib:
	move.b	3(a4),d0
	beq.s	vib_sub
	move.b	d0,24(a4)
vib_sub:
	move.b	25(a4),d0
	lsr	#2,d0
	and	#$1f,d0
	moveq	#0,d2
	move.b	l028f(pc,d0.w),d2
	move.b	24(a4),d0
	and	#$f,d0
	mulu	d0,d2
	lsr	#7,d2
	move	16(a4),d0
	tst.b	25(a4)
	bmi.s	l0292
	add	d2,d0
	bra.s	l0293
;
l0292:
	sub	d2,d0
l0293:
	move	d0,6(a1)
	move.b	24(a4),d0
	lsr	#2,d0
	and	#$3c,d0
	add.b	d0,25(a4)
	rts
;
;----------------------------------------------------------------------------
;
arpeggio_t:
	dc.w	1,$200,$102,1,$200,$102,1,$200
	dc.w	$102,1,$200,$102,1,$200,$102,1
;
;----------------------------------------------------------------------------
;
com_arpeggio:
	moveq	#0,d0
	move.b	counter(pc),d0
	move.b	arpeggio_t(pc,d0.w),d0
	beq.s	.l0299
	cmp.b	#2,d0
	beq.s	.l0296
	moveq	#0,d0
	move.b	3(a4),d0
	lsr.b	#4,d0
	bra.s	.l0297
;
.l0296:
	moveq	#0,d0
	move.b	3(a4),d0
	and.b	#$f,d0
.l0297:
	add	d0,d0
	move	16(a4),d1
	and	#$fff,d1
	lea	Note_Period_t(pc),a0
	moveq	#$24,d2
.l0298:
	cmp	(a0)+,d1
	bge.s	l029a
	dbra	d2,.l0298
.l0299:
	move	16(a4),6(a1)
	rts
;
;
l029a:
	move	-2(a0,d0.w),6(a1)
	rts
;
;----------------------------------------------------------------------------
;
com_nop:
	move	16(a4),6(a1)
	rts
;
;----------------------------------------------------------------------------
;
checkcom:
	move	2(a4),d0
	and	#$fff,d0
	beq.s	com_nop
	move.b	2(a4),d0
	and.b	#$f,d0
	beq.s	com_arpeggio
	cmp.b	#2,d0
	beq.s	com_portdown
	blt.s	com_portup
	cmp.b	#4,d0
	beq	com_vib
	blt	com_myport
	cmp.b	#6,d0
	beq.s	com_vib_toneslide
	blt.s	com_port_toneslide
	move	16(a4),6(a1)
	cmp.b	#$a,d0
	beq.s	com_volslide
	rts
;
;----------------------------------------------------------------------------
;
com_portup:
	moveq	#0,d0
	move.b	3(a4),d0
	sub	d0,16(a4)
	move	16(a4),d0
	cmp	#$71,d0
	bpl.s	l029e
	move	#$71,16(a4)
l029e:
	move	16(a4),6(a1)
	rts
;
;
com_portdown:
	moveq	#0,d0
	move.b	3(a4),d0
	add	d0,16(a4)
	move	16(a4),d0
	cmp	#$358,d0
	bmi.s	l02a0
	move	#$358,16(a4)
l02a0:
	move	16(a4),6(a1)
	rts
;
;----------------------------------------------------------------------------
;
com_vib_toneslide:
	pea	com_volslide(pc)
	bra	vib_sub
;
com_port_toneslide:
	bsr	l028b
com_volslide:
	moveq	#0,d0
	move.b	3(a4),d0
	lsr.b	#4,d0
	beq.s	.l02a5
	add.b	d0,19(a4)
	cmpi.b	#$40,19(a4)
	ble.s	.l02a4
	move.b	#$40,19(a4)
.l02a4:
	moveq	#0,d0
	move.b	19(a4),d0
	move	d0,8(a1)
	rts
;
.l02a5:
	move.b	3(a4),d0
	and.b	#$f,d0
	sub.b	d0,19(a4)
	bge.s	.l02a4
	clr.b	19(a4)
	bra.s	.l02a4
;
;----------------------------------------------------------------------------
;
checkcom2:
	move.b	2(a4),d0
	and	#$f,d0		;d0 = main command nybble
	cmp.b	#$e,d0
	beq.s	.l02a7
	bgt.s	setspeed
	cmp.b	#$d,d0
	beq.s	pattbreak
	cmp.b	#$b,d0
	beq.s	posjmp
	bgt.s	setvol
	rts
;
;
.l02a7:
	rts
;
;----------------------------------------------------------------------------
;
pattbreak:
	move.b	#1,break_f
	rts
;
;----------------------------------------------------------------------------
;
posjmp:
	move.b	#1,break_f
	move.b	3(a4),d0
	subq.b	#1,d0
	move.b	d0,songpos
	rts
;
;----------------------------------------------------------------------------
;
setvol:
	cmpi.b	#$40,3(a4)
	bls.s	vol4
	move.b	#$40,3(a4)
vol4:
	moveq	#0,d0
	move.b	3(a4),d0
	move.b	d0,19(a4)
	move	d0,8(a1)
	rts
;
;----------------------------------------------------------------------------
;
setspeed:
	moveq	#0,d0
	move.b	3(a4),d0
	cmp.b	#$1f,d0
	bls.s	.l02ad
	moveq	#$1f,d0
.l02ad:
	tst	d0
	bne.s	.l02ae
	moveq	#1,d0
.l02ae:
	move.b	d0,speed
	rts
;
;----------------------------------------------------------------------------
;
Note_Period_t:
	dc.w	856,808,762,720,678,640,604,570
	dc.w	$21a,$1fc,$1e0,$1c5,$1ac,$194,$17d,$168
	dc.w	$153,$140,$12e,$11d,$10d,$fe,$f0,$e2
	dc.w	$d6,$ca,$be,$b4,$aa,$a0,$97,$8f
	dc.w	$87,$7f,$78,$71,0
;
;
speed:
	dc.b	$06
counter:
	dc.b	$00
pattpos:
	dc.w	$00
songpos:
	dc.b	$00
break_f:
	dc.b	$00
dmacon:
	dc.w	$00
samplestarts:
	ds.l	$1f
voice1:
	dcb.w	5,0
l02b8:
	dcb.w	8,0
	dc.b	$00,$01
voice2:
	dcb.w	13,0
	dc.b	$00,$02
voice3:
	dcb.w	13,0
	dc.b	$00,$04
voice4:
	dcb.w	13,0
	dc.b	$00,$08
l02bc:
	dc.l	0
l02bd:
	dcb.w	2,0
l02be:
	dc.b	$00,$00
l02bf:
	dc.b	$00,$00
aud1lc:
	dcb.w	8,0
aud2lc:
	dcb.w	8,0
aud3lc:
	dcb.w	8,0
aud4lc:
	dcb.w	8,0
l02c4:
	dcb.l	2,0
l02c5:
	dcb.l	1,0
l02c6:
	dcb.l	1,0
l02c7:
	dcb.l	2,0
l02c8:
	dcb.l	1,0
l02c9:
	dcb.l	1,0
l02ca:
	dcb.w	4,0
l02cb:
	dcb.w	2,0
l02cc:
	dcb.w	2,0
l02cd:
	dcb.w	4,0
l02ce:
	dcb.w	2,0
l02cf:
	dcb.w	2,0
l02d0:
	dc.b	$00,$00
l02d1:
	dc.b	$00,$00
l02d2:
	dc.b	$00,$00
l02d3:
	dc.b	$00,$00
l02d4:
	dcb.w	2,0
l02d5:
	dc.b	$00,$00
l02d6:
	dc.b	$00,$00
nu_time_a_mod_psg_p:
	dcb.w	2,0
l02d8:
	dc.l	l02ee
l02d9:
	dc.l	l02f4
l02da:
	dc.l	l02f3
l02db:
	dc.b	$00,$00
psg_sample_fq_divisor:
	dc.b	$00
l02dd:
	dc.b	$00
l02de:
	dc.b	$00
l02df:
	dc.b	$00
psg_1_dma_2_f:
	dc.w	0
use_cache_f:
	dc.w	0
sample_fq:
	dc.w	0
l02e3:
	dcb.w	2,0
l02e4:
	dcb.w	2,0
;
;
l02e5:
	move.l	l02d9(pc),d0
	move.l	l02da(pc),l02d9
	move.l	d0,l02da
	lea	l02f2,a2
	lea	aud1lc(pc),a0
	lea	l02c4(pc),a1
	lea	l02d0(pc),a4
	move	l02d5(pc),d3
	moveq	#3,d0
l02e6:
	moveq	#0,d1
	move	8(a1),d1
	lsr	#1,d1
	sub	4(a1),d1
	blt.s	l02e8
	movea.l	(a0),a3
	cmpa.l	#l02eb,a3
	beq.s	l02e7
	move	4(a0),d2
	cmpi	#1,d2
	ble.s	l02e7
	divu	d2,d1
	clr	d1
	add.l	d1,d1
	swap	d1
	move	d1,8(a1)
	move.l	a3,(a1)
	move.l	4(a0),4(a1)
	bra.s	l02e8
;
l02e7:
	move.l	#l02eb,(a1)
	move.l	#$10000,4(a1)
	clr.l	8(a1)
	clr.l	12(a1)
	bra.s	l02e9
;
l02e8:
	cmpi.l	#l02eb,(a1)
	beq.s	l02e7
	move	6(a0),d1
	add	d1,d1
	add	d1,d1
	move.l	0(a2,d1.w),12(a1)
l02e9:
	move	8(a0),d1
	mulu	d3,d1
	and	#-$40,d1
	add	d1,d1
	add	d1,d1
	move	d1,(a4)+
	lea	16(a0),a0
	lea	16(a1),a1
	dbra	d0,l02e6
	movea.l	l02d4(pc),a2
	move	l02d2(pc),d0
	lea	0(a2,d0.w),a3
	move	l02d1(pc),d0
	adda	d0,a2
	movea.l	l02c7(pc),a0
	move.l	#$8000,d6
	adda.l	d6,a0
	movea.l	l02ca(pc),a1
	adda.l	d6,a1
	move.l	l02c9(pc),d0
	swap	d0
	move.l	l02cc(pc),d1
	swap	d1
	move.l	l02c8(pc),d2
	swap	d2
	sub	d6,d2
	move.l	l02cb(pc),d3
	swap	d3
	sub	d6,d3
	movea.l	l02da(pc),a4
	moveq	#0,d6
	moveq	#0,d4
	exg	a2,d0
	move.l	a3,d5
	movea.l	l02e3(pc),a3
	jsr	(a3)
	add	#-$8000,d2
	swap	d2
	move.l	d2,l02c8
	add	#-$8000,d3
	swap	d3
	move.l	d3,l02cb
	movea.l	l02d4(pc),a2
	move	l02d3(pc),d0
	lea	0(a2,d0.w),a3
	move	l02d0(pc),d0
	adda	d0,a2
	movea.l	l02c4(pc),a0
	move.l	#$8000,d6
	adda.l	d6,a0
	movea.l	l02cd(pc),a1
	adda.l	d6,a1
	move.l	l02c6(pc),d0
	swap	d0
	move.l	l02cf(pc),d1
	swap	d1
	move.l	l02c5(pc),d2
	swap	d2
	sub	d6,d2
	move.l	l02ce(pc),d3
	swap	d3
	sub	d6,d3
	movea.l	l02da(pc),a4
	moveq	#0,d6
	moveq	#0,d4
	exg	a2,d0
	move.l	a3,d5
	movea.l	l02e4(pc),a3
	jsr	(a3)
	add	#-$8000,d2
	swap	d2
	move.l	d2,l02c5
	add	#-$8000,d3
	swap	d3
	move.l	d3,l02ce
	not	l02d6
	rts
;
;----------------------------------------------------------------------------
	section	DATA
;----------------------------------------------------------------------------
;
l02ea:
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,$200,0,$300,0
	dc.w	$400,0,$500,0,$501,0,$600,0
	dc.w	$600,0,$602,0,$700,0,$702,0
	dc.w	$703,0,$800,0,$800,0,$802,0
	dc.w	$803,0,$900,0,$901,0,$902,0
	dc.w	$903,0,$904,0,$905,0,$905,$100
	dc.w	$a00,0,$a02,0,$a03,0,$a04,0
	dc.w	$a05,0,$a05,0,$a05,$200,$a06,0
	dc.w	$a06,$200,$a07,0,$a07,$100,$b00,0
	dc.w	$b01,0,$b03,0,$b04,0,$b04,0
	dc.w	$b05,0,$b05,$200,$b06,0,$b06,$100
	dc.w	$b07,0,$b07,$100,$b07,$200,$b07,$300
	dc.w	$b08,0,$b08,$100,$b08,$300,$b08,$400
	dc.w	$b09,0,$c00,0,$c02,0,$c03,0
	dc.w	$c04,0,$c05,0,$c05,$100,$c05,$200
	dc.w	$c06,0,$c06,$200,$c07,0,$c07,$200
	dc.w	$c07,$300,$c08,0,$c08,0,$c08,$200
	dc.w	$c08,$300,$c09,0,$c09,0,$c09,$200
	dc.w	$c09,$300,$c09,$400,$c09,$500,$c09,$500
	dc.w	$c0a,0,$d00,0,$d02,0,$d03,0
	dc.w	$d04,0,$d05,0,$d05,0,$d05,$200
	dc.w	$d06,0,$d06,$200,$d07,0,$d07,$100
	dc.w	$d07,$300,$d07,$400,$d08,0,$d08,$200
	dc.w	$d08,$300,$d09,0,$d09,0,$d09,$200
	dc.w	$d09,$300,$d09,$400,$d09,$500,$d09,$500
	dc.w	$d0a,0,$d0a,$100,$d0a,$300,$d0a,$400
	dc.w	$d0a,$400,$d0a,$500,$d0a,$500,$d0a,$600
	dc.w	$d0a,$600,$d0a,$700,$d0a,$700,$d0b,0
	dc.w	$d0b,$100,$d0b,$200,$d0b,$300,$d0b,$400
	dc.w	$d0b,$500,$d0b,$500,$d0b,$600,$e00,0
	dc.w	$e01,0,$e03,0,$e04,0,$e04,$100
	dc.w	$e05,0,$e05,$200,$e06,0,$e06,$100
	dc.w	$e07,0,$e07,$100,$e07,$300,$e07,$400
	dc.w	$e08,0,$e08,$100,$e08,$300,$e08,$400
	dc.w	$e09,0,$e09,$200,$e09,$300,$e09,$400
	dc.w	$e09,$500,$e09,$500,$e0a,0,$e0a,$100
	dc.w	$e0a,$300,$e0a,$400,$e0a,$400,$e0a,$500
	dc.w	$e0a,$500,$e0a,$600,$e0a,$600,$e0a,$700
	dc.w	$e0a,$700,$e0a,$700,$e0b,0,$e0b,$200
	dc.w	$e0b,$300,$e0b,$400,$e0b,$500,$e0b,$500
	dc.w	$e0b,$500,$e0b,$600,$e0b,$600,$e0b,$700
	dc.w	$e0b,$700,$e0b,$700,$e0b,$800,$e0b,$800
	dc.w	$e0b,$800,$e0b,$800,$e0b,$900,$e0c,0
	dc.w	$e0c,$100,$e0c,$300,$e0c,$400,$e0c,$400
	dc.w	$e0c,$500,$f00,0,$f01,0,$f03,0
	dc.w	$f04,0,$f04,$100,$f05,0,$f05,$200
	dc.w	$f06,0,$f06,$100,$f07,0,$f07,$100
	dc.w	$f07,$300,$f07,$400,$f08,0,$f08,$200
	dc.w	$f08,$300,$f08,$400,$f09,0,$f09,$200
	dc.w	$f09,$300,$f09,$400,$f09,$500,$f09,$500
	dc.w	$f0a,0,$f0a,$100,$f0a,$300,$f0a,$400
	dc.w	$f0a,$400,$f0a,$500,$f0a,$500,$f0a,$600
	dc.w	$f0a,$600,$f0a,$700,$f0a,$700,$f0b,0
	dc.w	$f0b,0,$f0b,$200,$f0b,$300,$f0b,$400
	dc.w	$f0b,$500,$f0b,$500,$f0b,$600,$f0b,$600
	dc.w	$f0b,$600,$f0b,$700,$f0b,$700,$f0b,$700
	dc.w	$f0b,$800,$f0b,$800,$f0b,$800,$f0b,$800
	dc.w	$f0b,$900,$f0c,0,$f0c,$100,$f0c,$300
	dc.w	$f0c,$400,$f0c,$400,$f0c,$500,$f0c,$500
	dc.w	$f0c,$600,$f0c,$600,$f0c,$700,$f0c,$700
	dc.w	$f0c,$700,$f0c,$700,$f0c,$800,$f0c,$800
	dc.w	$f0c,$800,$f0c,$800,$f0c,$900,$f0c,$900
	dc.w	$f0c,$900,$f0c,$900,$f0c,$900,$f0c,$900
	dc.w	$f0c,$a00,$f0d,0,$f0d,$100,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
	dc.w	$f0d,$300,$f0d,$300,$f0d,$300,$f0d,$300
;
;----------------------------------------------------------------------------
	section	BSS
;----------------------------------------------------------------------------
;
l02eb:
	ds.b	16
l02ec:
	ds.l	1
l02ed:
	ds.b	13488
l02ee:
	ds.l	1
l02ef:
	ds.b	16840
l02f0:
	ds.b	15962
l02f1:
	ds.b	6502
l02f2:
	ds.b	3492
l02f3:
	ds.b	1004
l02f4:
	ds.b	1260
l02f5:
	ds.b	17152
bss_end:
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	MPLAYER.S
;----------------------------------------------------------------------------
