/* Beispielprogramm zur Ermittlung der AES-Zeichenstze (IBM und SMALL)
	(c) 1993-94 Harald Sommerfeldt */

/*
	16.12.93: erste Version fr das VdiFont 2.00-Paket
	 3. 2.94: um appl_find("?AGI")-Abfrage erweitert
	25. 2.94: neue Routine: appl_xgetinfo() nach einem
	          Implementationsvorschlag von Martin Osieka @ WI
	26. 2.94: um ein paar Kommentare erweitert
*/

#include <aes.h>
#include <vdi.h>
#include <tos.h>		/* bzw. osbind.h */
#include <stdio.h>

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

/* Wert eines Cookies holen, zurckgegeben wird TRUE bei Erfolg */
typedef struct {
	long	cookie, value;
} cookiejar;

int	get_cookie( long cookie, long *value )
{
	cookiejar *_p_cookies;
	void	*sp;

	sp = (void *)Super( NULL );
	_p_cookies = *(void **)0x5A0;		/* Zeiger auf Cookiejar holen */
	Super( sp );
	if ( _p_cookies != NULL )			/* wenn Cookiejar installiert ... */
	{											/* ... dann Cookies abklappern ... */
		for (; _p_cookies->cookie != 0L; _p_cookies++ )
		{
			if ( _p_cookies->cookie == cookie )
			{									/* ... bis der gewnschte Eintrag ist */
				if ( value != NULL ) *value = _p_cookies->value;
				return TRUE;
			}
		}
	}
	return FALSE;
}


/* appl_getinfo() fr Pure-C */
#ifdef __PUREC__
AESPB aespb = { _GemParBlk.contrl, _GemParBlk.global, _GemParBlk.intin,
                _GemParBlk.intout, (int *)_GemParBlk.addrin, (int *)_GemParBlk.addrout };

int	appl_getinfo( int type, int *out1, int *out2, int *out3, int *out4 )
{
	_GemParBlk.intin[0] = type;
	_GemParBlk.contrl[0] = 130;
	_GemParBlk.contrl[1] = 1;
	_GemParBlk.contrl[2] = 5;
	_GemParBlk.contrl[3] = 0;
	_crystal( &aespb );
	*out1 = _GemParBlk.intout[1];
	*out2 = _GemParBlk.intout[2];
	*out3 = _GemParBlk.intout[3];
	*out4 = _GemParBlk.intout[4];
	return _GemParBlk.intout[0];
}

#define ap_version	_GemParBlk.global[0]	/* AES-Versionsnummer (z.B. 0x140 = 1.40) */
#endif


/*
	appl_xgetinfo()

	Parameter: wie bei appl_getinfo()
	Ergebnis : != 0 wenn appl_getinfo() verfgbar und erfolgreich
*/
int	appl_xgetinfo( int type, int *out1, int *out2, int *out3, int *out4 )
{
	static int has_agi = -1;
	long	l;

	if ( has_agi < 0 )
	{
		has_agi = ( ap_version >= 0x400            /* MTOS? */
		            || (get_cookie( 'MagX', &l ) && ((short **)l)[2][24] >= 0x200) /* Mag!X 2.0? */
		            || appl_find( "?AGI" ) == 0 ); /* "?AGI"? */
	}

	if ( has_agi ) return appl_getinfo( type, out1, out2, out3, out4 );
	return 0;
}


int	vdi_handle;		/* unser VDI-Workstation-Handle */
int	fonts_loaded;	/* TRUE wenn vst_load_fonts() aufgerufen wurde */

/*
	appl_getfontinfo()

   Ermittelt die Kenndaten der AES-Zeichenstze (IBM und SMALL),
   nach Mglichkeit (Mag!X 2.0, MTOS oder "?AGI") wird hierbei auf
   die AES-Funktion appl_getinfo() zurckgegriffen

	Parameter:
     ap_gtype: 0 fr den IBM-Font, 1 fr den SMALL-Font
     height  : die ermittelte Gre in Pixeln (Basislinie<->Oberkante)
     id      : die ermittelte Font-ID
     type    : 1 wenn Speedo-Zeichensatz

   Der so ermittelte Zeichensatz kann mit
     vst_font( vdi_handle, id );
     vst_height( vdi_handle, height, &dummy, &dummy, &dummy, &dummy );
   eingestellt werden.
*/
void	appl_getfontinfo( int ap_gtype, int *height, int *id, int *type )
{
	int	attrib[10], dummy;

	/* ist appl_getinfo() vorhanden und erfolgreich? */
	if ( appl_xgetinfo( ap_gtype, height, id, type, &dummy ) )
	{
		/* dann haben wir schon alles was wir wissen wollen! */

		/* Patzer von den ersten Mag!X 2.0-Versionen umgehen,
		   nheres entnehme man MAGXPTCH.TXT */
		if ( *id == -12124 ) *id = 1;

		/* falls Zeichensatz (noch) nicht ansprechbar: GDOS-Zeichenstze laden */
		if ( vst_font( vdi_handle, *id ) != *id && !fonts_loaded && vq_gdos() )
		{
			vst_load_fonts( vdi_handle, 0 );
			fonts_loaded = TRUE;
		}
	}
	else
	{
		/* ansonsten aktuell eingestellte AES-Zeichensatz-ID bestimmen */
		vqt_attributes( graf_handle( &dummy, &dummy, &dummy, &dummy ), attrib );
		*id = attrib[0];

		/* und wieder ggf. GDOS-Zeichenstze laden */
		if ( vst_font( vdi_handle, *id ) != *id && !fonts_loaded && vq_gdos() )
		{
			vst_load_fonts( vdi_handle, 0 );
			fonts_loaded = TRUE;
		}

		/* fr SMALL-Font nehmen wir nun einfach die kleinste mgliche,
		   fr IBM-Font die akt. eingestellte Hhe */
		if ( ap_gtype == 1 )		/* SMALL-Daten erwnscht? */
		{
			vst_font( vdi_handle, *id );
			vst_point( vdi_handle, 1, &dummy, &dummy, &dummy, &dummy );
			vqt_attributes( vdi_handle, attrib );
		}
		*height = attrib[7];
		*type   = 0;
	}
}


/*
	Hauptprogramm

	Ermittelt die Kenndaten der AES-Zeichenstze mittels
	appl_getfontinfo() und zeigt sie in Alert-Boxen an
*/

int	work_in[11] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2 };
int	work_out[57];
char	buffer[256];

int	main( void )
{
	int	height, id, speedo, dummy;

	appl_init();
	vdi_handle = graf_handle( &dummy, &dummy, &dummy, &dummy );
	if ( !appl_xgetinfo( 2, &work_in[0], &dummy, &dummy, &dummy ) )
		work_in[0] = 2 + Getrez();
	v_opnvwk( work_in, &vdi_handle, work_out );

	appl_getfontinfo( 0, &height, &id, &speedo );
	sprintf( buffer, "[1][IBM-Zeichensatz|ID    : %d|Gre : %d|Speedo: %d][  OK  ]",
	         id, height, speedo );
	wind_update( BEG_UPDATE );
	form_alert( 1, buffer );
	wind_update( END_UPDATE );

	appl_getfontinfo( 1, &height, &id, &speedo );
	sprintf( buffer, "[1][SMALL-Zeichensatz|ID    : %d|Gre : %d|Speedo: %d][  OK  ]",
	         id, height, speedo );
	wind_update( BEG_UPDATE );
	form_alert( 1, buffer );
	wind_update( END_UPDATE );

	if ( fonts_loaded ) vst_unload_fonts( vdi_handle, 0 );
	v_clsvwk( vdi_handle );
	appl_exit();
	return 0;
}
