/* die internen System-Zeichenstze als GDOS-Fonts abspeichern
	(c) 1993 Harald Sommerfeldt */

/* neu 17.12.93: Die Zeichenstze werden im INTEL-Format abgelegt! */


#include <linea.h>
#include <stdio.h>

/* mit der folgenden Zeile kann man dem Systemzeichensatz eine
   neue Font-ID geben, um sich z.B. fr einen vorhandenen Zeichensatz
   einen passenden SMALL-Zeichensatz (fr die Laufwerks- und Datei-
   Icons) zu generieren */
/* #define NEWID 123 */

void	SINTEL( short *s )
{
	char	c;

	c = ((char *)s)[0];
	((char *)s)[0] = ((char *)s)[1];
	((char *)s)[1] = c;
}
void	LINTEL( long *l )
{
	short	s;

	s = ((short *)l)[0];
	((short *)l)[0] = ((short *)l)[1];
	((short *)l)[1] = s;
	SINTEL( &((short *)l)[0] );
	SINTEL( &((short *)l)[1] );
}

main()
{
	FONT_HDR	*font, f;
	short	ch_ofst[257];
	char	buffer[128];
	FILE	*fp;
	int	i;

	linea_init();
	font = Vdiesc->font_ring[0];
	for (;;)
	{
		printf( "id %d, size %d, name %s\n",
			font->id, font->size, font->facename );
		printf( "hor_table %p, off_table %p, dat_table %p\n",
			font->hz_ofst, font->ch_ofst, font->fnt_dta );
		printf( "form_width %d, form_height %d\n",
			font->frm_wdt, font->frm_hgt );
		printf( "flags.f68000: %s\n",
			(font->flags.f68000) ? "TRUE" : "FALSE" );
		printf( "\n" );

		f = *font;
#ifdef NEWID
		f.id = NEWID;
#endif
		sprintf( buffer, "SYS%d_%02d.FNT", f.id, f.size );
		fp = fopen( buffer, "wb" );
		f.hz_ofst = (void *)0L;
		f.ch_ofst = (void *)sizeof(FONT_HDR);
		f.fnt_dta = (short *)sizeof(FONT_HDR) + 257;
		f.next = (void *)0L;
		if ( font->flags.f68000 )
		{
			SINTEL( (short *)&f.id );
			SINTEL( (short *)&f.size );
			SINTEL( (short *)&f.ade_lo );
			SINTEL( (short *)&f.ade_hi );
			SINTEL( (short *)&f.top_dist );
			SINTEL( (short *)&f.asc_dist );
			SINTEL( (short *)&f.hlf_dist );
			SINTEL( (short *)&f.des_dist );
			SINTEL( (short *)&f.bot_dist );
			SINTEL( (short *)&f.wchr_wdt );
			SINTEL( (short *)&f.wcel_wdt );
			SINTEL( (short *)&f.lft_ofst );
			SINTEL( (short *)&f.rgt_ofst );
			SINTEL( (short *)&f.thckning );
			SINTEL( (short *)&f.undrline );
			SINTEL( (short *)&f.lghtng_m );
			SINTEL( (short *)&f.skewng_m );
			f.flags.f68000 = 0;
			SINTEL( (short *)&f.flags );
			f.flags.f68000 = 0;
			LINTEL( (long *)&f.hz_ofst );
			LINTEL( (long *)&f.ch_ofst );
			LINTEL( (long *)&f.fnt_dta );
			SINTEL( (short *)&f.frm_wdt );
			SINTEL( (short *)&f.frm_hgt );
			LINTEL( (long *)&f.next );
		}
		fwrite( &f, sizeof(FONT_HDR), 1, fp );

		for ( i = 0; i < 257; i++ )
		{
			ch_ofst[i] = font->ch_ofst[i];
			if ( font->flags.f68000 ) SINTEL( &ch_ofst[i] );
		}
		fwrite( ch_ofst, sizeof(short), 257, fp );

		fwrite( font->fnt_dta, font->frm_wdt, font->frm_hgt, fp );

		fclose( fp );
		if ( (font = font->next) == NULL ) break;
	}
	return 0;
}
