;----------------------------------------------------------------------------
;File name:	VDIFONT.S			Revision date:	1998.10.12
;Revised by:	Ulf Ronald Andersson		Disassembled:	1995.09.24
;Original by:	Harald Sommerfeldt		Creation date:	1993.09.18
;Release:	Version:	2.0		Revision:	1.5
;----------------------------------------------------------------------------
;Copyrights:	for original	(c) 1993 Harald Sommerfeldt @ KI
;		for revision	(c) 1995 Ulf Ronald Andersson
;----------------------------------------------------------------------------
;Released:	For free use and non-commercial distribution.
;----------------------------------------------------------------------------
	output	.GTP
;----------------------------------------------------------------------------
	include	RA_ARG.I
	include	RA_APP.I
	include	RA_SIM.I
	include	RA_JAR.I
	include	RA_XGEM.I
	include	RA_LA.I
;-------
	include	VDIFONT.I
;----------------------------------------------------------------------------
workstation_max	= 100	;max number of simultaneous screen workstations
MAX_LIST	= 100	;max number of entries in XGEM vector lists
;----------------------------------------------------------------------------
	SECTION	TEXT
;----------------------------------------------------------------------------
start:
	bra	startup
;----------------------------------------------------------------------------
;Start of:	resident data area
;----------------------------------------------------------------------------
la_base_p:		dc.l	0
opnwk_vdipb_p:		dc.l	0
ext_vdipb_p:		dc.l	0
;
stackframe_len:		dc.w	6
;
pre_install_f:		dc.w	0
new_install_f:		dc.w	0
bad_revision_f:		dc.w	0
late_XGEM_wanted_p:	dc.l	nu_XGEM_2
late_XGEM_linked_p:	dc.l	-1
XGEM_1_removed_f:	dc.w	0
vfnt_busy_f:		dc.w	0
;
VF_cookie_p:		dc.l	VF_cookie
VF_cookie:		VF_def
;
root_vdifont_cnf_s:	dc.b	'\VDIFONT.CNF',NUL
			even
;
			_unilab	contrl
			ds.w	12
intin:			ds.w	30
intout:			ds.w	45
ptsin:			ds.w	30
ptsout:			ds.w	12
message:		ds.b	16
;
load_font_count:	ds.w	1
load_font_resp_t:	ds.w	2*workstation_max
;----------------------------------------------------------------------------
;End of:	resident data area
;----------------------------------------------------------------------------
;early declarations of subroutine generating macros, to allow them to be
;used later in code with local labels.
;----------------------------------------------------------------------------
	XB_seek_code
	XB_kill_code
	XB_init
	XB_tail
	XB_retail
;----------------------------------------------------------------------------
;Start of:	BIOS functions with XBRA
;----------------------------------------------------------------------------
	XGEM_BIOS_define	nu_bios,VF_magic_con
	move.l	nu_bios+xb_next(pc),a0	;\/ use older bios dispatcher
	jmp	(a0)			;/\
;----------------------------------------------------------------------------
patch_XGEM_sub:			;uses d0/a0/a1
	btst	#nAES_bit,VF_partner_f+VF_cookie	;Running under nAES ?
	bne.s	.try_remove_XGEM_1			;then try removing nu_XGEM_1
	btst	#Gnva_bit,VF_partner_f+VF_cookie	;Running under GENEVA ?
	beq.s	.done_remove_XGEM_1			;else keep nu_XGEM_1
.try_remove_XGEM_1:
	tst.b	XGEM_1_removed_f	;nu_XGEM_1 already removed ?
	bne.s	.done_remove_XGEM_1	;don't try it twice
.remove_XGEM_1:
	lea	(ev_xgem).w,a0	;a0 -> ev_xgem
	lea	nu_XGEM_1(pc),a1	;a1 -> nu_XGEM_1
	bsr	remove_XB_code		;remove nu_XGEM_1 from the XBRA chain
	blt.s	.done_remove_XGEM_1	;skip flagging removal on failure
	lea	nu_XGEM_3(pc),a1	;a1 -> nu_XGEM_3
	move.l	a1,late_XGEM_wanted_p	;set this up for future linking
	st	XGEM_1_removed_f	;flag removal (for nu_XGEM_2)
.done_remove_XGEM_1:
	XGEM_patch	late_XGEM_linked_p,late_XGEM_wanted_p
	rts
;----------------------------------------------------------------------------
;End of:	BIOS functions with XBRA
;----------------------------------------------------------------------------
;Start of:	early XGEM exception functions with XBRA
;----------------------------------------------------------------------------
	illegal
	XB_define	nu_XGEM_1,VF_magic_con
	cmp	#$73,d0				;XGEM opcode for VDI ?
	bne.s	.go_old_XGEM			;if not, goto old routines
	movea.l	d1,a0				;a0 -> external VDIPB
	movea.l	(a0),a0				;a0 -> external contrl
	cmp	#v_opnwk&$ff,(a0)		;opcode = v_opnwk ?
	beq.s	.nu_v_opnwk
.go_old_XGEM:
	move.l	xb_next+nu_XGEM_1(pc),-(sp)	;\/ Use older xgem
	rts					;/\
;-------------------------------------
.nu_v_opnwk:				;open physical workstation
	move.l	d1,a0			;a0 -> external VDIPB
	movea.l	4(a0),a0		;a0 -> external intin
	cmp	#10,(a0)		;screen device ?  (<11)
	bgt.s	.go_old_XGEM		;if not, goto old routines
	move.l	d1,opnwk_vdipb_p	;VDIPB of physical screen workstation owner
	st	VF_opnwk_f+VF_cookie	;flag physical workstation
	move.l	d1,-(sp)		;push -> external VDIPB
	push_ex	end_opnwk(pc)		;push exception frame
	bra.s	.go_old_XGEM		;goto old routines
;-------------------------------------
;Above, older XGEM routines are _called_ by simulating an exception frame,
;so when they are finished we return to 'end_opnwk' below. (in nu_XGEM_3)
;CPU state is still super, and original entry frame is on stack,
;with a ptr -> callers VDIPB pushed on top.
;----------------------------------------------------------------------------
;End of:	early XGEM exception functions with XBRA
;----------------------------------------------------------------------------
;Start of:	late normal XGEM exception functions with XBRA
;----------------------------------------------------------------------------
	XGEM_define	nu_XGEM_2,VF_magic_con
	cmp	#$73,d0			;VDI call ?
	bne.s	.not_vdi_XGEM		;if not, go try AES
.vdi_XGEM:
	movea.l	d1,a0				;a0 -> external VDIPB
	movea.l	(a0),a0				;a0 -> external contrl
	cmp	#vst_font&$ff,(a0)		;opcode = vst_font ?
	beq.s	.nu_vst_font
	cmp	#vst_load_fonts&$ff,(a0)	;opcode = vst_load_fonts ?
	beq.s	.nu_vst_load_fonts
	cmp	#vst_unload_fonts&$ff,(a0)	;opcode = vst_unload_fonts ?
	beq.s	.nu_vst_unload_fonts
	cmp	#v_opnvwk&$ff,(a0)		;opcode = v_opnvwk ?
	beq.s	.nu_v_opnvwk
	cmp	#v_clsvwk&$ff,(a0)		;opcode = v_clsvwk ?
	beq.s	.nu_v_clsvwk
.go_old_XGEM:
	move.l	xb_next+nu_XGEM_2(pc),-(sp)
	rts
;-------------------------------------
.not_vdi_XGEM:
	cmp	#$C8,d0			;AES call ?
	bne.s	.go_old_XGEM		;if not, let older XGEM deal with it
.aes_XGEM:
	movea.l	d1,a0				;a0 -> external AESPB
	movea.l	(a0),a0				;a0 -> external contrl
	cmp	#appl_init&$ff,(a0)		;opcode = v_opnvwk ?
	bne.s	.go_old_XGEM
.nu_aes_patch:
	movem.l	d0/a0-a1,-(sp)
	bsr	patch_XGEM_sub
	movem.l	(sp)+,d0/a0-a1
	bra.s	.go_old_XGEM
;-------------------------------------
.nu_vst_font:
	bsr	font_fix
	bra.s	.go_old_XGEM
;-------------------------------------
.nu_vst_load_fonts:
	bsr	load_fonts_fix
	bra.s	.go_old_XGEM
;-------------------------------------
.nu_vst_unload_fonts:
	bsr	unload_fonts_fix
	bra.s	.go_old_XGEM
;-------------------------------------
.nu_v_clsvwk:
	bsr	clsvwk_fix
	bra.s	.go_old_XGEM
;-------------------------------------
.nu_v_opnvwk:				;open virtual workstation
	move.l	d1,a0			;a0 -> external VDIPB
	movea.l	4(a0),a0		;a0 -> external intin
	cmp	#10,(a0)			;screen device ?  (<11)
	bgt.s	.go_old_XGEM		;if not, goto old routines
	sf	VF_opnwk_f+VF_cookie	;flag virtual workstation
	tst.b	VF_allvwk_f+VF_cookie
	beq.s	.go_old_XGEM
;;;	move	VF_fnt_id+VF_cookie(pc),10(a0)
	move.l	d1,-(sp)		;push -> external VDIPB
	push_ex	end_opnvwk(pc)		;push exception frame
	bra	.go_old_XGEM		;goto old routines
;-------------------------------------
;Above, older XGEM routines are _called_ by simulating an exception frame,
;so when they are finished we return to 'end_opnvwk' below (in nu_XGEM_3)
;CPU state is still super, and original entry frame is on stack,
;with a ptr -> callers VDIPB pushed on top.
;----------------------------------------------------------------------------
;End of:	late normal XGEM exception functions with XBRA
;----------------------------------------------------------------------------
;Start of:	late GENEVA XGEM exception functions with XBRA
;----------------------------------------------------------------------------
	XGEM_define	nu_XGEM_3,VF_magic_con
	cmp	#$73,d0				;VDI call ?
	bne.s	.not_vdi_XGEM			;if not, go try AES
.vdi_XGEM:
	movea.l	d1,a0				;a0 -> external VDIPB
	movea.l	(a0),a0				;a0 -> external contrl
	cmp	#v_opnwk&$ff,(a0)		;opcode = v_opnwk ?
	beq.s	.nu_v_opnwk
	cmp	#vst_font&$ff,(a0)		;opcode = vst_font ?
	beq.s	.nu_vst_font
	cmp	#vst_load_fonts&$ff,(a0)	;opcode = vst_load_fonts ?
	beq.s	.nu_vst_load_fonts
	cmp	#vst_unload_fonts&$ff,(a0)	;opcode = vst_unload_fonts ?
	beq.s	.nu_vst_unload_fonts
	cmp	#v_opnvwk&$ff,(a0)		;opcode = v_opnvwk ?
	beq.s	.nu_v_opnvwk
	cmp	#v_clsvwk&$ff,(a0)		;opcode = v_clsvwk ?
	beq.s	.nu_v_clsvwk
.go_old_XGEM:
	move.l	xb_next+nu_XGEM_3(pc),-(sp)
	rts
;-------------------------------------
.not_vdi_XGEM:
	cmp	#$C8,d0			;AES call ?
	bne.s	.go_old_XGEM		;if not, let older XGEM deal with it
.aes_XGEM:
	movea.l	d1,a0				;a0 -> external AESPB
	movea.l	(a0),a0				;a0 -> external contrl
	cmp	#appl_init&$ff,(a0)		;opcode = v_opnvwk ?
	bne.s	.go_old_XGEM
.nu_aes_patch:
	movem.l	d0/a0-a1,-(sp)
	bsr	patch_XGEM_sub
	movem.l	(sp)+,d0/a0-a1
	bra.s	.go_old_XGEM
;----------------------------------------------------------------------------
.nu_v_opnwk:				;open physical workstation
	move.l	d1,a0			;a0 -> external VDIPB
	movea.l	4(a0),a0		;a0 -> external intin
	cmp	#10,(a0)		;screen device ?  (<11)
	bgt.s	.go_old_XGEM		;if not, goto old routines
	move.l	d1,opnwk_vdipb_p	;VDIPB of physical screen workstation owner
	st	VF_opnwk_f+VF_cookie	;flag physical workstation
	move.l	d1,-(sp)		;push -> external VDIPB
	push_ex	end_opnwk(pc)		;push exception frame
	bra.s	.go_old_XGEM		;goto old routines
;-------------------------------------
;Above, older XGEM routines are _called_ by simulating an exception frame,
;so when they are finished we return to 'end_opnwk' below. (beyond .nu_opnvwk)
;CPU state is still super, and original entry frame is on stack,
;with a ptr -> callers VDIPB pushed on top.
;----------------------------------------------------------------------------
.nu_vst_font:
	bsr	font_fix
	bra.s	.go_old_XGEM
;-------------------------------------
.nu_vst_load_fonts:
	bsr	load_fonts_fix
	bra.s	.go_old_XGEM
;-------------------------------------
.nu_vst_unload_fonts:
	bsr	unload_fonts_fix
	bra.s	.go_old_XGEM
;-------------------------------------
.nu_v_clsvwk:
	bsr	clsvwk_fix
	bra.s	.go_old_XGEM
;-------------------------------------
.nu_v_opnvwk:				;open virtual workstation
	move.l	d1,a0			;a0 -> external VDIPB
	movea.l	4(a0),a0		;a0 -> external intin
	cmp	#10,(a0)		;screen device ?  (<11)
	bgt.s	.go_old_XGEM		;if not, goto old routines
	sf	VF_opnwk_f+VF_cookie	;flag virtual workstation
	tst.b	VF_allvwk_f+VF_cookie
	beq.s	.go_old_XGEM
;;;	move	VF_fnt_id+VF_cookie(pc),10(a0)
	move.l	d1,-(sp)		;push -> external VDIPB
	push_ex	end_opnvwk(pc)		;push exception frame
	bra	.go_old_XGEM		;goto old routines
;-------------------------------------
;Above, older XGEM routines are _called_ by simulating an exception frame,
;so when they are finished we return to 'end_opnvwk' below.
;CPU state is still super, and original entry frame is on stack,
;with a ptr -> callers VDIPB pushed on top.
;-------------------------------------
end_opnvwk:				;NB: used by both nu_XGEM_2 & nu_XGEM_3
	move.l	(sp)+,ext_vdipb_p	;pull -> external VDIPB
	movem.l	d0-d2/a0-a2,-(sp)	;push d0/a0
	bsr	force_font_sub
	movem.l	(sp)+,d0-d2/a0-a2	;pull d0-d2/a0-a2
	sf	VF_opnwk_f+VF_cookie	;flag virtual workstations (default)
	rte
;-------------------------------------
end_opnwk:				;NB: used by both nu_XGEM_1 & nu_XGEM_3
	move.l	(sp)+,ext_vdipb_p	;pull -> external VDIPB
	movem.l	d0-d2/a0-a2,-(sp)	;push d0-d2/a0-a2
;
	clr	load_font_count		;new physical workstation => restart everything
;
	bclr	#Gnva_bit,VF_partner_f+VF_cookie
	eval_cookie	#'Gnva'
	ble.s	.done_Gnva_bit
	bset	#Gnva_bit,VF_partner_f+VF_cookie
.done_Gnva_bit:
;
	bclr	#MiNT_bit,VF_partner_f+VF_cookie
	eval_cookie	#'MiNT'
	ble.s	.done_MiNT_bit
	bset	#MiNT_bit,VF_partner_f+VF_cookie
.done_MiNT_bit:
;
	bclr	#nAES_bit,VF_partner_f+VF_cookie
	eval_cookie	#'nAES'
	ble.s	.done_nAES_bit
	bset	#nAES_bit,VF_partner_f+VF_cookie
.done_nAES_bit:
;
	bsr	load_cnf_sub
;
	tst.b	VF_inhibit_f+VF_cookie	;VF_inhibit_f
	bne.s	.done_end_font
	bsr	force_font_sub
.done_end_font:
;
	lea	(ev_bios).w,a0
	lea	nu_bios(pc),a1
	bsr	retop_XB_code		;retop VFnt BIOS routine
;
	bsr	patch_XGEM_sub
;
	movem.l	(sp)+,d0-d2/a0-a2	;pull d0-d2/a0-a2
	sf	VF_opnwk_f+VF_cookie	;flag virtual workstations (default)
	rte
;----------------------------------------------------------------------------
;End of:	late GENEVA XGEM exception functions with XBRA
;----------------------------------------------------------------------------
;Start of:	'font_fix' called by new VDI routines to select font
;----------------------------------------------------------------------------
font_fix:
	tas	vfnt_busy_f
	bmi.s	.exit_direct
	movem.l	d0-d2/a0-a2,-(sp)	;push d0-d2/a0-a2
	tst	load_font_count
	ble.s	.resp_not_found
	movea.l	d1,a0			;a0 -> VDIPB
	movea.l	4(a0),a1		;a1 -> intin
	cmp	#1,(a1)			;intin[0] == 1 ?
	bne.s	.resp_not_found
	movea.l	(a0),a0			;a0 -> contrl
	move	12(a0),d0		;d0 =  workstation handle
	ble.s	.resp_not_found		;skip fix for illegal handles
	move	#workstation_max-1,d2
	lea	load_font_resp_t(pc),a1
.find_resp_loop:
	cmp	(a1)+,d0		;does resp have same workstation handle ?
	addq	#2,a1
	dbeq	d2,.find_resp_loop
	bne.s	.resp_not_found
	tst	-2(a1)			;is this resp finished
	bpl.s	.simulate_font
.resp_not_found:
	movem.l	(sp)+,d0-d2/a0-a2	;pull d0-d2/a0-a2
	bclr	#7,vfnt_busy_f
.exit_direct:
	rts	;return from subroutine to continue exception in old XGEM
;
.simulate_font:
	lea	contrl(pc),a0
	move	d0,12(a0)		;use same workstation handle
	move	#vst_font&$ff,(a0)				;\
	clr	2(a0)						; \
	move	#1,6(a0)					;  \/ Call VDI
	move	VF_fnt_id+VF_cookie(pc),intin-contrl(a0)	;  /\ vst_font
	beq.s	.done_end_font					; /
	bsr	vdi_call_sub					;/
;
	cmp.w	VF_fnt_id+VF_cookie(pc),d0
	bne.s	.resp_not_found
;
	lea	contrl(pc),a0					;\
	move.w	#vst_height&$ff,(a0)				; \
	move.w	#1,2(a0)					;  \ / Call
	clr.w	6(a0)						;   X  VDI
	clr.w	ptsin-contrl(a0)				;  / \ vst_height
	move.w	VF_fnt_height+VF_cookie(pc),ptsin+2-contrl(a0)	; /
	bsr	vdi_call_sub					;/
.done_end_font:
	movem.l	(sp),d0/d1		;restore entry d0/d1
	movea.l	d1,a0			;a0 -> VDIPB
	movea.l	(a0),a1			;a1 -> contrl
	moveq	#1,d0
	move	d0,8(a1)		;sintout = 1
	move.l	d0,(sp)			;future d0 on stack = 1
	movea.l	12(a0),a1		;a1 -> intout
	move	d0,(a1)			;intout[0] = 1
	movem.l	(sp)+,d0-d2/a0-a2	;pull d0-d2/a0-a2
	addq	#4,sp			;pop return adress to avoid old XGEM
	bclr	#7,vfnt_busy_f
	rte				;return from exception
;----------------------------------------------------------------------------
;End of:	'font_fix' called by new VDI routines to select font
;----------------------------------------------------------------------------
;Start of:	'load_fonts_fix' called by new VDI routines to sim load fonts
;----------------------------------------------------------------------------
load_fonts_fix:
	tas	vfnt_busy_f
	bmi.s	.exit_direct
	movem.l	d0-d2/a0-a2,-(sp)	;push d0-d2/a0-a2
	tst	load_font_count
	ble.s	.resp_not_found
	movea.l	d1,a0			;a0 -> VDIPB
	movea.l	(a0),a0			;a0 -> contrl
	move	12(a0),d0		;d0 =  workstation handle
	ble.s	.resp_not_found		;skip fix for illegal handles
	move	#workstation_max-1,d2
	lea	load_font_resp_t(pc),a1
.find_resp_loop:
	cmp	(a1)+,d0		;does resp have same workstation handle ?
	addq	#2,a1
	dbeq	d2,.find_resp_loop
	bne.s	.resp_not_found
	tst	-2(a1)			;is this resp finished
	bpl.s	.simulate_load_fonts
.resp_not_found:
	movem.l	(sp)+,d0-d2/a0-a2	;pull d0-d2/a0-a2
	bclr	#7,vfnt_busy_f
.exit_direct:
	rts	;return from subroutine to continue exception in old XGEM
;
.simulate_load_fonts:
	move	#1,8(a0)		;sintout = 1
	move	-2(a1),d0		;d0 = resp_value
;;;	clr.l	-4(a1)			;free resp entry
;;;	subq	#1,load_font_count	;decrement table usage counter
	ext.l	d0
	move.l	d0,(sp)			;future d0 on stack = resp_value
	movea.l	d1,a0			;a0 -> VDIPB
	movea.l	12(a0),a0		;a0 -> intout
	move	d0,(a0)			;intout[0] = resp_value
	movem.l	(sp)+,d0-d2/a0-a2	;pull d0-d2/a0-a2
	addq	#4,sp			;pop return adress to avoid old XGEM
	bclr	#7,vfnt_busy_f
	rte				;return from exception
;----------------------------------------------------------------------------
;End of:	'load_fonts_fix' called by new VDI routines to sim load fonts
;----------------------------------------------------------------------------
;Start of:	'unload_fonts_fix' called by new VDI routines to sim unload
;----------------------------------------------------------------------------
unload_fonts_fix:
	tas	vfnt_busy_f
	bmi.s	.exit_direct
	movem.l	d0-d2/a0-a2,-(sp)	;push d0-d2/a0-a2
	tst	load_font_count
	ble.s	.resp_not_found
	movea.l	d1,a0			;a0 -> VDIPB
	movea.l	(a0),a0			;a0 -> contrl
	move	12(a0),d0		;d0 =  workstation handle
	ble.s	.resp_not_found		;skip fix for illegal handles
	move	#workstation_max-1,d2
	lea	load_font_resp_t(pc),a1
.find_resp_loop:
	cmp	(a1)+,d0		;does resp have same workstation handle ?
	addq	#2,a1
	dbeq	d2,.find_resp_loop
	bne.s	.resp_not_found
	tst	-2(a1)			;is this resp finished
	bpl.s	.simulate_unload_fonts
.resp_not_found:
	movem.l	(sp)+,d0-d2/a0-a2	;pull d0-d2/a0-a2
	bclr	#7,vfnt_busy_f
.exit_direct:
	rts	;return from subroutine to continue exception in old XGEM
;
.simulate_unload_fonts:
	movem.l	(sp)+,d0-d2/a0-a2	;pull d0-d2/a0-a2
	addq	#4,sp			;pop return adress to avoid old XGEM
	bclr	#7,vfnt_busy_f
	rte				;return from exception
;----------------------------------------------------------------------------
;End of:	'unload_fonts_fix' called by new VDI routines to sim unload
;----------------------------------------------------------------------------
;Start of:	'clsvwk_fix' called by new VDI routines to unload at clsvwk
;----------------------------------------------------------------------------
clsvwk_fix:
	tas	vfnt_busy_f
	bmi.s	.exit_direct
	movem.l	d0-d2/a0-a2,-(sp)	;push d0-d2/a0-a2
	tst	load_font_count
	ble.s	.resp_not_found
	movea.l	d1,a0			;a0 -> VDIPB
	movea.l	(a0),a0			;a0 -> contrl
	move	12(a0),d0		;d0 =  workstation handle
	ble.s	.resp_not_found		;skip fix for illegal handles
	move	#workstation_max-1,d2
	lea	load_font_resp_t(pc),a1
.find_resp_loop:
	cmp	(a1)+,d0		;does resp have same workstation handle ?
	addq	#2,a1
	dbeq	d2,.find_resp_loop
	bne.s	.resp_not_found
	tst	-2(a1)			;is this resp finished
	bpl.s	.unload_load_fonts
	clr.l	-4(a1)			;free resp entry
	subq	#1,load_font_count	;decrement table usage counter
.resp_not_found:
	movem.l	(sp)+,d0-d2/a0-a2	;pull d0-d2/a0-a2
	bclr	#7,vfnt_busy_f
.exit_direct:
	rts
;
.unload_load_fonts:
	clr.l	-4(a1)			;free resp entry
	subq	#1,load_font_count	;decrement table usage counter
	lea	contrl(pc),a0
	move	d0,12(a0)		;copy workstation handle
	move	#vst_unload_fonts&$ff,(a0)
	clr	2(a0)
	move	#1,6(a0)
	clr	intin-contrl(a0)
	bsr	vdi_call_sub
	movem.l	(sp)+,d0-d2/a0-a2	;pull d0-d2/a0-a2
	movea.l	d1,a0			;a0 -> VDIPB
	movea.l	(a0),a0			;a0 -> contrl
	move	#v_clsvwk&$ff,(a0)
	clr	2(a0)
	clr	6(a0)
	bclr	#7,vfnt_busy_f
	rts
;----------------------------------------------------------------------------
;End of:	'clsvwk_fix' called by new VDI routines to unload at clsvwk
;----------------------------------------------------------------------------
;Start of:	'force_font_sub' called by new VDI routines to force fonts
;----------------------------------------------------------------------------
force_font_sub:
	tas	vfnt_busy_f
	bmi	.exit_direct
;
	tst.b	VF_badcnf_f+VF_cookie	;VF_badcnf_f
	bne	.done_end_font
;
	movea.l	ext_vdipb_p(pc),a0	;a0 -> external VDIPB
	movea.l	(a0),a1			;a1 -> external contrl
	lea	contrl(pc),a0		;a0 -> local contrl
	move	12(a1),d0		;d0 =  workstation handle
	move	d0,12(a0)		;copy workstation handle to local contrl
;
	move	#workstation_max-1,d1
	lea	load_font_resp_t(pc),a1
.find_resp_loop_1:
	cmp	(a1)+,d0		;does resp have same workstation handle ?
	addq	#2,a1
	dbeq	d1,.find_resp_loop_1
	bne.s	.same_not_found
	move	#-1,-2(a1)		;mark resp as unfinished
	bra.s	.resp_found
;
.same_not_found:
	cmp	#workstation_max,load_font_count
	bhs	.done_end_font		;skip forcing if no free resps remain
;
	move	#workstation_max-1,d1
	lea	load_font_resp_t(pc),a1
.find_resp_loop_2:
	tst	(a1)+			;is this resp free ?
	addq	#2,a1
	dbeq	d1,.find_resp_loop_2
	bne	.done_end_font		;should _never_ happen
	move	d0,-4(a1)		;mark resp as used for this workstation
	move	#-1,-2(a1)		;mark resp as unfinished
	addq	#1,load_font_count	;count resp taken for use
;
.resp_found:
	lea	contrl(pc),a0			;\
	move	#vst_load_fonts&$ff,(a0)	; \
	clr	2(a0)				;  \/ Call VDI
	move	#1,6(a0)			;  /\ vst_load_fonts
	clr	intin-contrl(a0)		; /
	bsr	vdi_call_sub			;/
;
	moveq	#-1,d2			;d2 = -1
	move	12(a0),d2		;d2 = -1.handle
	swap	d2			;d2 = handle.-1
	move	#workstation_max-1,d1
	lea	load_font_resp_t(pc),a1
.find_resp_loop_3:
	cmp.l	(a1)+,d2		;does unfinished resp have same workstation handle ?
	dbeq	d1,.find_resp_loop_3
	bne.s	.done_end_font		;should _never_ happen
	move	d0,-2(a1)		;finish resp  (ready for user vst_load_fonts)
;
	move	#vst_font&$ff,(a0)				;\
	clr	2(a0)						; \
	move	#1,6(a0)					;  \/ Call VDI
	move	VF_fnt_id+VF_cookie(pc),intin-contrl(a0)	;  /\ vst_font
	beq.s	.done_end_font					; /
	bsr	vdi_call_sub					;/
;
	cmp.w	VF_fnt_id+VF_cookie(pc),d0
	bne.s	.done_end_font
;
	move.l	ext_vdipb_p(pc),a2	;a2 -> external VDIPB
	move.l	16(a2),a2		;a2 -> external ptsout
	moveq	#1,d0			;request minimum size = 1
	bsr	vst_point_sub		;try using this size
	move.l	ptsout-contrl(a0),d0	;d0 = actual minimum width.height
	move.l	d0,(a2)			;store min sizes at external ptsout+0
	move.w	#999,d0			;request enormous size = 999
	bsr	vst_point_sub		;try using this size
	lsr.w	#1,d0			;halve result, to ignore pixel doubling
	bsr	vst_point_sub		;try that size
	move.l	ptsout-contrl(a0),d0	;d0 = actual maximum width.height
	move.l	d0,4(a2)		;store max sizes at external ptsout+4
;
	lea	contrl(pc),a0					;\
	move.w	#vst_height&$ff,(a0)				; \
	move.w	#1,2(a0)					;  \ / Call
	clr.w	6(a0)						;   X  VDI
	clr.w	ptsin-contrl(a0)				;  / \ vst_height
	move.w	VF_fnt_height+VF_cookie(pc),ptsin+2-contrl(a0)	; /
	bsr	vdi_call_sub					;/
.done_end_font:
	bclr	#7,vfnt_busy_f
.exit_direct:
	rts
;----------------------------------------------------------------------------
;End of:	'force_font_sub' called by new VDI routines to force fonts
;----------------------------------------------------------------------------
	include	XB_SUBS.S
;----------------------------------------------------------------------------
;Start of:	VDI call subroutines
;----------------------------------------------------------------------------
vst_point_sub:			;d0==wanted size => d0=resulting size
	lea	contrl(pc),a0
	move	#vst_point&$ff,(a0)
	clr	2(a0)
	move	#1,6(a0)
	move	d0,intin-contrl(a0)
vdi_call_sub:
	move.l	#vdipb,d1
	move	#$73,d0
	trap	#2			;vdi
	lea	contrl(pc),a0
	move	intout-contrl(a0),d0
	rts
;----------------------------------------------------------------------------
;End of:	VDI call subroutines
;----------------------------------------------------------------------------
;Start of:	Subroutines to load/test configuration file
;----------------------------------------------------------------------------
test_cnf_sub:
	lea	VF_cookie(pc),a0
	bra.s	load_cnf_sub_ia0
;
load_cnf_sub:
	move.l	VF_cookie_p(pc),a0
load_cnf_sub_ia0:
	movem.l	d7/a3/a6,-(sp)
	move.l	a0,a6
	gemdos	Fopen|_ind,VF_cnf_path_p(a6),!
	move.l	d0,d7				;d7 = handle/errcode
	bmi.s	.error
	gemdos	Fread,d7,#VF_cnf_size,VF_cnf_buf(a6)
	cmp.l	#VF_cnf_size,d0
	beq.s	.done_read
	gemdos	Fclose,d7
	bra.s	.error
;
.done_read:
	gemdos	Fclose,d7
	cmp.l	#VF_cnf_con,VF_cnf_magic(a6)
	bne.s	.error
	sf	VF_badcnf_f(a6)
	moveq	#E_OK,d0
	bra.s	.exit
;
.error:
	cmp.l	VF_cookie_p(pc),a6
	bne.s	.done_badcnf_f
	st	VF_badcnf_f(a6)
.done_badcnf_f:
	moveq	#E_ERROR,d0
.exit:
	movem.l	(sp)+,d7/a3/a6
	rts
;----------------------------------------------------------------------------
;End of:	Subroutines to load/test configuration file
;----------------------------------------------------------------------------
;	Resident library routines
;
	_uniref	vdi_data
	make	SIM_links
;
	_uniref	reset_old_jar
	make	JAR_links
;
resident_end:	;code below is only present during installation
;----------------------------------------------------------------------------
;Start of:	non-resident installation routine
;----------------------------------------------------------------------------
startup:
	start_app
;----------------------------------------------------------------------------
init_app:
	start_arg
;-------
;The macro 'start_arg' defines two variables:
;arg_cnt	== number of strings on command line
;arg_ptr	-> NUL_separated argument strings + final NUL
;Both of the above include a dummy program name (first string==NUL).
;-------
	tst	acc_flag
	bne.s	.done_init
	xbios	Supexec,test_install
	tst	pre_install_f
	bne.s	.done_init
	bios	Kbshift,?
	andi.w	#15,d0				;d0 = Alt.Ctl.LSh.RSh bits
	sub.b	skip_inst_keys(pc),d0
	beq.s	.done_init
	xbios	Supexec,try_install
.done_init:
	rts
;----------------------------------------------------------------------------
exec_acc:
	xbios	Supexec,test_install
	clr.l	d0
	move	pre_install_f(pc),d0
	beq	acc_error_al
	move	bad_revision_f(pc),d0
	bne	bad_revision_al
	bra	configure_al
;------------------------------------
exec_app:
	tst	acc_flag
	bne.s	exec_acc
	move.l	VF_cookie_p(pc),a5		;a5 -> cookie
	tst	pre_install_f
	bne	reconfigure
	gemdos	Cconws,prog_title_s(pc)
	tst	new_install_f
	beq	no_gdos_al
	bsr	load_cnf_sub
	tst.b	VF_badcnf_f(a5)
	beq.s	.conf_is_ok
	gemdos	Cconws,vdifont_cnf_invalid_s(pc)
	bra.s	.conf_exit
;
.conf_is_ok:
	gemdos	Cconws,vdifont_cnf_loaded_s(pc)
	gemdos	Cconws,font_colon_s(pc)
	gemdos	Cconws,VF_fnt_name(a5)
	gemdos	Cconws,left_par_s(pc)
	move.w	VF_fnt_height(a5),d0
	bsr	show_dec_d0
	gemdos	Cconws,right_par_s(pc)
.conf_exit:
	gemdos	Cconws,keep_s(pc)
	lea	resident_end(pc),a3
	sub.l	basepage_p(pc),a3
	move.l	a3,d0
	bsr	show_dec_d0
	gemdos	Cconws,bytes_in_mem_s(pc)
	bra	exit_ok
;------------------------------------
reconfigure:
	move	bad_revision_f(pc),d0
	bne	bad_revision_al
	move.l	arg_ptr(pc),a4	;a4 = arg_ptr
	move	arg_cnt(pc),d0	;d0 = arg_cnt
	move	d0,d5
	subq	#1,d5		;arg 0 doesn't count (progname/dummy)
	ble	exec_acc	;no args => same dialogs as for accessory
	cmp	#3,d5		;3 arguments is maximum allowed
	bhi	usage_error_al
.loop_1:
	tst.b	(a4)+		;pass arg 0 (progname or dummy)
	bne.s	.loop_1
;
	subq	#1,d5		;prep for dbra
arg_loop:
	move.l	a4,a3
	bsr	eval_num
	bpl.s	arg_is_num
arg_is_path:
	move.l	a3,a4
	move.l	a4,VF_cnf_path_p+VF_cookie	;NB: local, not real cookie !
	bsr	test_cnf_sub			;test CNF via local cookie buffer
	tst.l	d0
	bmi	path_error_al
	lea	VF_cnf_path_s(a5),a3		;NB: real cookie, not local !
.move_path:
	move.b	(a4)+,(a3)+
	bne.s	.move_path
	lea	VF_cnf_path_s(a5),a3		;NB: real cookie, not local !
	move.l	a3,VF_cnf_path_p(a5)		;NB: real cookie, not local !
	bsr	load_cnf_sub			;load CNF into real cookie buffer
	bra.s	next_arg
;
arg_is_num:
	cmp	#3,d0
	bhi	usage_error_al
	beq.s	.turn_on_virtuals
	cmp	#1,d0
	bhi.s	.turn_off_virtuals
	beq.s	.direct_turn_on
.direct_turn_off:
	st	VF_inhibit_f(a5)
	bra.s	next_arg
;
.direct_turn_on:
	sf	VF_inhibit_f(a5)
	bra.s	next_arg
;
;
.turn_off_virtuals:
	sf	VF_allvwk_f(a5)
	bra.s	next_arg
;

.turn_on_virtuals:
	st	VF_allvwk_f(a5)
	bra.s	next_arg
;
next_arg:
	dbra	d5,arg_loop
	bra	exit_ok
;------------------------------------
bad_revision_al:
	sim_aes	form_alert,#1,bad_revision_al_s(pc)
	moveq	#E_ACCDN,d0
	bra	exit_err_d0
;------------------------------------
no_gdos_al:
	sim_aes	form_alert,#2,no_gdos_al_s(pc)
	move	d0,d3
	cmp	#2,d0
	beq	configure_al
	moveq	#0,d5
	cmp	#3,d0
	beq.s	usage_error_al_x
	bra	exit_ok
;------------------------------------
acc_error_al:
	sim_aes	form_alert,#2,acc_error_al_s(pc)
	move	d0,d3
	cmp	#2,d0
	beq	configure_al
	moveq	#0,d5
	cmp	#3,d0
	beq.s	usage_error_al_x
	bra	exit_ok
;------------------------------------
path_error_al:
	sim_aes	form_alert,#2,path_error_al_s(pc)
	move	d0,d3
	cmp	#2,d0
	beq.s	configure_al
	moveq	#2,d5
	cmp	#3,d0
	beq.s	usage_error_al
	bra	exit_ok
;------------------------------------
usage_error_al:
	moveq	#2,d3
	moveq	#1,d5
usage_error_al_x:
	and	#3,d5
	move	d5,d0
	asl	#2,d0
	lea	usage_al_t(pc),a0
	move.l	(a0,d0),a4
	sim_aes	form_alert,d3,(a4)
	move	d0,d3
	sub	#2,d0
	beq.s	configure_al
	add	d0,d5
	bra.s	usage_error_al_x
;
;------------------------------------
;
configure_al:
	move.l	VF_cookie_p(pc),a5
	lea	configure_4_al_s(pc),a4
	tst.b	VF_badcnf_f(a5)
	beq.s	.do_it
	lea	configure_5_al_s(pc),a4
.do_it:
	sim_aes	form_alert,#2,(a4)
	move	d0,d3
	cmp	#1,d0
	beq.s	fsel_VDIFont_CNF
	cmp	#3,d0
	beq.s	conf_flag_al
	bra	exit_ok
;
conf_flag_al:
	tst.b	VF_allvwk_f(a5)
	sne	d5
	and	#1,d5
	tst.b	VF_inhibit_f(a5)
	seq	d0
	and	#2,d0
	or	d0,d5
configure_al_x:
	and	#3,d5
	move	d5,d0
	asl	#2,d0
	lea	configure_al_t(pc),a0
	move.l	(a0,d0),a4
	sim_aes	form_alert,d3,(a4)
	move	d0,d3
	sub	#2,d0
	beq	configure_al
	blt.s	go_usage_0		;patch better info
	addq	#1,d5
	btst	#0,d5
	sne	VF_allvwk_f(a5)
	btst	#1,d5
	seq	VF_inhibit_f(a5)
	bra.s	configure_al_x
;
go_usage_0:
	clr	d5
	bra	usage_error_al_x
;
;------------------------------------
;
fsel_VDIFont_CNF:
	move.l	VF_cnf_path_p(a5),a0
	lea	aux_path_s(pc),a1
	move	#255-1,d0
.get_path_lp:
	move.b	(a0)+,(a1)+
	dbeq	d0,.get_path_lp
	clr.b	(a1)+
	pea	fsel_prompt_s(pc)
	pea	0.w
	pea	0.w
	pea	aux_path_s(pc)
	bsr	fselect_sub
	add	#4*4,sp
	move.l	d0,VF_cnf_path_p+VF_cookie	;NB: local, not real cookie !
	ble	configure_al
	bsr	test_cnf_sub			;test CNF via local cookie buffer
	tst.l	d0
	bmi	path_error_al
	lea	aux_path_s(pc),a0
	lea	VF_cnf_path_s(a5),a1		;NB: real cookie, not local !
	move.l	a1,VF_cnf_path_p(a5)		;NB: real cookie, not local !
	move	#255-1,d0
.put_path_lp:
	move.b	(a0)+,(a1)+
	dbeq	d0,.put_path_lp
	bsr	load_cnf_sub			;load CNF into real cookie buffer
	bra	configure_al
;
;------------------------------------
;
exit_ok:
	clr.l	d0
exit_err_d0:
	tst	tos_flag
	bmi.s	exit_tos
	aes_redraw
exit_tos:
	tst	acc_flag
	bne.s	norm_exit
	tst	pre_install_f
	bne.s	norm_exit
	tst	new_install_f
	beq.s	norm_exit
resident_exit:
	move.l	#resident_end,d1
	sub.l	basepage_p(pc),d1
	move.l	#$ADD1,d0
norm_exit:
	rts
;
;----------------------------------------------------------------------------
;End of:	non-resident installation routine
;----------------------------------------------------------------------------
;Start of:	installation subroutines
;----------------------------------------------------------------------------
;
eval_num:
	move.l	d1,-(sp)
	clr	d1
	clr.l	d0
.loop:
	move.b	(a4)+,d1
	beq.s	.exit
	sub	#'0',d1
	blo.s	.error
	cmp	#9,d1
	bhi.s	.error
	mulu	#10,d0
	add	d1,d0
	bra.s	.loop
;
.error:
	moveq	#-1,d0
.exit:
	movem.l	(sp)+,d1
	rts
;
;----------------------------------------------------------------------------
;
test_install:
	_a_init
	move.l	a0,la_base_p
;
	move.l	(ev_trap5).w,a0
	move.l	#.do_trap,(ev_trap5).w
	move.l	sp,d0
	trap	#5				;process exception at .do_trap
.do_trap:
	sub.l	sp,d0			;d0 = frame size
	add	d0,sp			;sp = pre_exception SSP
	move	d0,stackframe_len
	move.l	a0,(ev_trap5).w		;restore original trap5_handler
	cmp	#6,d0
;
	clr	pre_install_f
	eval_cookie	#VF_magic_con
	ble.s	.exit
	btst	#0,d0
	bne.s	.exit
	move.l	d0,a0
	cmp.l	#VF_magic_con,(a0)
	bne.s	.exit
	st	pre_install_f
	move.l	a0,VF_cookie_p
	move	#VF_int_con,d0		;d0 = version of our interface
	cmp	VF_interface(a0),d0	;same as found interface version ?
	sne	bad_revision_f
.exit:
	rts
;
;----------------------------------------------------------------------------
;
try_install:
	vq_gdos				;gdos present ?
	beq.s	.exit			;if not, skip installation
;
	lea	VF_cookie(pc),a5
	make_cookie	#VF_magic_con,a5
	bmi.s	.exit
	move.l	a5,VF_cookie_p
	move.l	#root_vdifont_cnf_s,VF_cnf_path_p(a5)
	st	VF_allvwk_f(a5)
;
	eval_cookie	#'MagX'
	move.l	d0,VF_MagX_p(a5)
	sgt	VF_MagX_f(a5)
;
	lea	(ev_xgem).w,a0
	lea	nu_XGEM_1(pc),a1
	bsr	install_XB
;
	st	new_install_f
;
.exit:
	rts
;
;----------------------------------------------------------------------------
;
show_dec_d0:
	clr.w	-(sp)
.loop_1:
	ext.l	d0
	divu	#10,d0
	swap	d0
	move.w	d0,-(sp)
	addi.w	#$30,(sp)
	swap	d0
	tst.w	d0
	bne.s	.loop_1
.loop_2:
	gemdos	Cconout,()
	tst.w	(sp)
	bne.s	.loop_2
	move.w	(sp)+,d0
	rts
;
;----------------------------------------------------------------------------
;Start of:	File select subroutine with support subroutines
;----------------------------------------------------------------------------
;
;arg1 -> path string, possibly with unwanted filename attached
;arg2 -> file mask, null => "*.*"
;arg3 -> initial file name, null => old name (from arg1)
;arg4 -> prompt string
;
;returns d0 -> path string (arg1) with selected filename, or null on CANCEL
;-------------------------------------
;
fselect_sub:
	link	a6,#0
	movem.l	d1-d2/a0-a2,-(sp)
	clr.l	addrin
	clr	intin
	move.l	#$4E010101,d0	;graf_mouse
	bsr	call_aes
	move.l	8(a6),a1
	tst.b	(a1)
	bne.s	.restart_name_1
	bsr	getdrvpath_ia1
.restart_name_1:
	move.l	a1,a2		;a2 -> prel name_start
.test_name_1:
	move.b	(a1)+,d0
	beq.s	.have_name_1
	cmp.b	#'\',d0
	bne.s	.test_name_1
	bra.s	.restart_name_1
;
.stars_s:
	dc.b	'*.*',NUL		;NB: 4 bytes
.old_name_s:
	ds.b	40
;
.have_name_1:
	move.l	a2,a0
	lea	.old_name_s(pc),a1
	moveq	#39-1,d0
.old_name_lp_1:			;save old name (if any)
	move.b	(a0)+,(a1)+
	dbeq	d0,.old_name_lp_1
	clr.b	(a1)
	move.l	12(a6),a1	;a1 -> file mask (if any)
	move.l	a1,d0
	bgt.s	.make_mask
	lea	.stars_s(pc),a1
.make_mask:
	move.b	(a1)+,(a2)+
	bne.s	.make_mask
	clr.b	(a2)
	lea	addrin(pc),a0
	move.l	8(a6),(a0)+		;addrin[0] -> path buffer
	move.l	16(a6),(a0)+		;addrin[1] -> name buffer
	bgt.s	.keep_def_name
	move.l	#.old_name_s,-4(a0)
.keep_def_name:
	move.l	20(a6),(a0)+		;addrin[2] -> prompt string
	bsr.s	try_fsel_exinput	;call AES fsel_exinput or fsel_input
	clr.l	d0
	tst	intout
	beq.s	.exit			;exit on error
	tst	intout+2
	beq.s	.exit			;exit on [CANCEL] button
	move.l	8(a6),a0
.restart_name_2:
	move.l	a0,a2		;a2 -> prel name_start after path
.test_name_2:
	move.b	(a0)+,d0
	beq.s	.have_name_2
	cmp.b	#'\',d0
	bne.s	.test_name_2
	bra.s	.restart_name_2
;
.have_name_2:
	move.l	16(a6),a1
	move.l	a1,d0
	bgt.s	.copy_name
	lea	.old_name_s(pc),a1
.copy_name:
	move.b	(a1)+,(a2)+
	bne.s	.copy_name
	move.l	8(a6),d0	;return path with name
.exit:
	movem.l	d1-d2/a0-a2,-(sp)
	unlk	a6
	rts
;
;-------------------------------------
;
try_fsel_exinput:
	move.l	addrin+2*4,d0
	ble.s	.use_fileselector
	move.l	#$5A000202,d1	;AES fsel_input
	move.l	#'FSEL',d0
	bsr.s	seek_cookie_d0
	bpl.s	.use_new_selector
	bsr.s	what_TOS_version
	cmp	#$0104,d0
	blt.s	.use_fileselector
.use_new_selector:
	move.l	#$5B000203,d1	;AES fsel_exinput
.use_fileselector:
	move.l	d1,d0
	bsr	call_aes
	rts
;
;-------------------------------------
;
what_TOS_version:
	movem.l	d1-d7/a0-a6,-(sp)
	gemdos	Super|_ind,#1
	move.l	d0,d7
	bmi.s	.sup_seek_1
	gemdos	Super,!
	move.l	d0,d7
.sup_seek_1:
	move.l	(_sysbase).w,a0
	move.l	os_version(a0),d0
	bra.s	super_return
;
;-------------------------------------
;
seek_cookie_d0:
	movem.l	d1-d7/a0-a6,-(sp)
	move.l	d0,d3
	gemdos	Super|_ind,#1
	move.l	d0,d7
	bmi.s	.sup_seek_1
	gemdos	Super,!
	move.l	d0,d7
.sup_seek_1:
	moveq	#-34,d0		;prep 'path not found' error
	move.l	(_cookies).w,d1
	beq.s	super_return
	move.l	d1,a0
	moveq	#-33,d0		;prep 'file not found' error
.seek_cookie_loop:
	tst.l	(a0)
	beq.s	super_return
	cmp.l	(a0),d3
	beq.s	.seek_cookie_found
	addq.l	#8,a0
	bra.s	.seek_cookie_loop
;
.seek_cookie_found:
	move.l	a0,d0
super_return:
	exg	d0,d7
	tst.l	d0
	bmi.s	.keep_super
	gemdos	Super|_ind,d0
.keep_super:
	move.l	d7,d0
	movem.l	(sp)+,d1-d7/a0-a6
	rts
;
;-------------------------------------
;
call_aes:
	movem.l	d1-d7/a0-a6,-(sp)
	lea	contrl(pc),a0
	clr.l	(a0)+
	clr.l	(a0)+
	clr	(a0)
	movep.l	d0,-7(a0)
	cmpi.b	#$70,-7(a0)
	bne.s	.done_saddrout
	move.b	#1,1(a0)
.done_saddrout:
	lea	aes_pb(pc),a0
	move.l	a0,d1
	move	#$C8,d0			;aes code
	trap	#2			;XGEM
	moveq	#0,d0
	move	intout(pc),d0
	movem.l	(sp)+,d1-d7/a0-a6
	rts
;
;-------------------------------------
;
getdrvpath_ia1:
	movem.l	d0-d2/a0-a2,-(sp)
	move.l	a1,-(sp)
	gemdos	Dgetdrv
	add	#'A',d0
	move.l	(sp),a1
	move.b	d0,(a1)+
	move.b	#':',(a1)+
	sub	#'A',d0
.get_path:
	addq	#1,d0
	gemdos	Dgetpath,(a1),d0
	move.l	(sp)+,a0
.pass_str:
	tst.b	(a0)+
	bne.s	.pass_str
	subq	#1,a0
	move.b	#'\',(a0)+
	move.b	#'*',(a0)+
	move.b	#'.',(a0)+
	move.b	#'*',(a0)+
	clr.b	(a0)
	movem.l	(sp)+,d0-d2/a0-a2
	rts
;
;----------------------------------------------------------------------------
;End of:	File select subroutine with support subroutines
;----------------------------------------------------------------------------
;Start of:	non-resident library routines
;----------------------------------------------------------------------------
;
	make	SIM_links
	make	JAR_links
;
;----------------------------------------------------------------------------
;End of:	non-resident library routines
;----------------------------------------------------------------------------
	SECTION	DATA
;----------------------------------------------------------------------------
;Start of:	installation data area
;----------------------------------------------------------------------------
;
acc_name:	dc.b	'  VDIFont ',NUL
id_app_name_s:	dc.b	'VDIFONT ',NUL
;
prog_title_s:
	dc.b	LF,CR,ESC,'p'
	dc.b	' VdiFont 2.00     Dec 25 1993 '
	dc.b	ESC,'q',LF,CR
	dc.b	' (c) 1993  Harald Sommerfeldt',LF,CR
	dc.b	' URAn Rev: 1.5    Oct 10 1998',CR,LF
	dc.b	' The package remains FREEWARE',CR,LF
	dc.b	NUL
;
keep_s:
	dc.b	' keep ',NUL
bytes_in_mem_s:
	dc.b	' bytes in memory',LF,CR,NUL
;
install_fail_s:
	dc.b	' Installation aborted',LF,CR,NUL
;
vdifont_cnf_loaded_s:
	dc.b	' VDIFONT.CNF loaded!',LF,CR,NUL
;
font_colon_s:
	dc.b	' Font: ',NUL
left_par_s:
	dc.b	' (',NUL
right_par_s:
	dc.b	')',LF,CR,NUL
;
vdifont_cnf_invalid_s:
	dc.b	' VDIFONT.CNF is not valid!',LF,CR,NUL
;
	dc.b	'VdiFontRVars',$2,$0,$3
;
skip_inst_keys:
	dc.b	$4	;Alt.Ctl.LSh.RSh bits for skip install command
	even
;
fsel_prompt_s:
	dc.b	"Load 'VDIFont' configuration:",NUL
	even
;
;------------------------------------
;
T___VDIFont_vvv_Errorx_xxxx___1	Macro	xxxx
	dc.b	'[3]['
	dc.b	'___VDIFont'
	dc.l		 VF_ver_con_s
	dc.b		      '_Error:_',\1
	dc.b				  '___|'
	endm
;
no_gdos_al_s:
		T___VDIFont_vvv_Errorx_xxxx___1	'GDOS'
	dc.b	'You must install _some_ GDOS |'
	dc.b	'driver (EG: NVDI or AMC_REV1)|'
	dc.b	'_before_  starting  VDIFONT. |'
	dc.b	'Installation was now skipped ]'
	dc.b	'[  Exit  |  Conf  |  Help  ]',NUL
	even
;
bad_revision_al_s:
		T___VDIFont_vvv_Errorx_xxxx___1	'Rev.'
	dc.b	'Installed  VDIFont  program  |'
	dc.b	'has interface of a different |'
	dc.b	'revision than this program.  |'
	dc.b	'Please use compatible tools. ]'
	dc.b	'[  Exit  ]',NUL
	even
;
acc_error_al_s:
		T___VDIFont_vvv_Errorx_xxxx___1	'Lost'
	dc.b	'You must install  VDIFont as |'
	dc.b	'a resident (non-acc) program |'
	dc.b	'after which  this  accessory |'
	dc.b	'will be able to configure it ]'
	dc.b	'[  Exit  |  Conf  |  Help  ]',NUL
	even
;
path_error_al_s:
		T___VDIFont_vvv_Errorx_xxxx___1	'Path'
	dc.b	'The specified path does not  |'
	dc.b	'lead to a valid  CNF  file.  |'
	dc.b	'The previous  CNF will thus  |'
	dc.b	'remain in use.               ]'
	dc.b	'[  Exit  |  Conf  |  Help  ]',NUL
	even
;
;------------------------------------
;
usage_al_t:
	dc.l	usage_0_al_s,usage_1_al_s
	dc.l	usage_2_al_s,usage_3_al_s
;
Y___VDIFont_vvv_Usagex_xxxx___1	Macro	xxxx
	dc.b	'[1]['
	dc.b	'___VDIFont'
	dc.l		 VF_ver_con_s
	dc.b		      '_Usage:_',\1
	dc.b				  '___|'
	endm
;
usage_0_al_s:
		Y___VDIFont_vvv_Usagex_xxxx___1	'Boot'
	dc.b	'To get the new fonts active  |'
	dc.b	'in desktop, they must be set |'
	dc.b	'before desktop starts/rezchg |'
	dc.b	'So try VDIFont.PRG in \AUTO\ ]'
	dc.b	'[  .TOS  |  Conf  |  Args  ]',NUL
	even
;
usage_1_al_s:
		Y___VDIFont_vvv_Usagex_xxxx___1	'Args'
	dc.b	'Use 1..3 args, digits (0..3) |'
	dc.b	'or CNF paths, in any order.  |'
	dc.b	'0:VDIFont off   1:VDIFont on |'
	dc.b	'2:vwk_fix off   3:vwk_fix on ]'
	dc.b	'[  Boot  |  Conf  |  WIMP  ]',NUL
	even
;
usage_2_al_s:
		Y___VDIFont_vvv_Usagex_xxxx___1	'WIMP'
	dc.b	'You may also install VDIFont |'
	dc.b	'as an ACC, or as non-ACC but |'
	dc.b	'without argument to make the |'
	dc.b	'configuration interactively. ]'
	dc.b	'[  Args  |  Conf  |  .TOS  ]',NUL
	even
;
usage_3_al_s:
		Y___VDIFont_vvv_Usagex_xxxx___1	'.TOS'
	dc.b	'You may also run  VDIFont as |'
	dc.b	'TOS or TTP program with same |'
	dc.b	'features as APP / GTP except |'
	dc.b	'that fileselector is absent. ]'
	dc.b	'[  WIMP  |  Conf  |  Boot  ]',NUL
	even
;
;------------------------------------
;
configure_al_t:
	dc.l	configure_0_al_s,configure_1_al_s
	dc.l	configure_2_al_s,configure_3_al_s
	dc.l	configure_4_al_s,configure_5_al_s
;
Z___VDIFont_vvv_Confxx_xxxx___1	Macro	xxxx
	dc.b	'[2]['
	dc.b	'___VDIFont'
	dc.l		 VF_ver_con_s
	dc.b		      '_Conf.:_',\1
	dc.b				  '___|'
	endm
;
T___VDIFont_vvv_Confxx_xxxx___1	Macro	xxxx
	dc.b	'[3]['
	dc.b	'___VDIFont'
	dc.l		 VF_ver_con_s
	dc.b		      '_Conf.:_',\1
	dc.b				  '___|'
	endm
;
configure_5_al_s:
		T___VDIFont_vvv_Confxx_xxxx___1	'Main'
	dc.b	'NB< Current CNF NOT valid >NB|'
	dc.b	'Use fileselector to choose a |'
	dc.b	'new VDIFont.CNF to set font. |'
	dc.b	"Press 'Flag' to choose flags ]"
	dc.b	'[  FSel  |  Exit  |  Flag  ]',NUL
	even
;
configure_4_al_s:
		Z___VDIFont_vvv_Confxx_xxxx___1	'Main'
	dc.b	'OK< Current CNF is valid >OK |'
	dc.b	'Use fileselector to choose a |'
	dc.b	'new VDIFont.CNF to set font. |'
	dc.b	"Press 'Flag' to choose flags ]"
	dc.b	'[  FSel  |  Exit  |  Flag  ]',NUL
	even
;
configure_0_al_s:
		Z___VDIFont_vvv_Confxx_xxxx___1	'Flag'
	dc.b	'VDIFont = off   vwk_fix = off|'
	dc.b	"Press 'Step' to change flags |"
	dc.b	'VDIFont => new desktop fonts |'
	dc.b	'vwk_fix => new program fonts ]'
	dc.b	'[  Info  |  Main  |  Step  ]',NUL
	even
;
configure_1_al_s:
		Z___VDIFont_vvv_Confxx_xxxx___1	'Flag'
	dc.b	'VDIFont = off   vwk_fix = on |'
	dc.b	"Press 'Step' to change flags |"
	dc.b	'VDIFont => new desktop fonts |'
	dc.b	'vwk_fix => new program fonts ]'
	dc.b	'[  Info  |  Main  |  Step  ]',NUL
	even
;
configure_2_al_s:
		Z___VDIFont_vvv_Confxx_xxxx___1	'Flag'
	dc.b	'VDIFont = on    vwk_fix = off|'
	dc.b	"Press 'Step' to change flags |"
	dc.b	'VDIFont => new desktop fonts |'
	dc.b	'vwk_fix => new program fonts ]'
	dc.b	'[  Info  |  Main  |  Step  ]',NUL
	even
;
configure_3_al_s:
		Z___VDIFont_vvv_Confxx_xxxx___1	'Flag'
	dc.b	'VDIFont = on    vwk_fix = on |'
	dc.b	"Press 'Step' to change flags |"
	dc.b	'VDIFont => new desktop fonts |'
	dc.b	'vwk_fix => new program fonts ]'
	dc.b	'[  Info  |  Main  |  Step  ]',NUL
	even
;
;----------------------------------------------------------------------------
;End of:	installation data area
;----------------------------------------------------------------------------
	SECTION	BSS
;----------------------------------------------------------------------------
;
aux_path_s:	ds.l	256/4
		ds.l	$1000
mystack:	ds.l	4
;
;----------------------------------------------------------------------------
	End
;----------------------------------------------------------------------------
;End of file:	VDIFONT.S
;----------------------------------------------------------------------------
