;----------------------------------------------------------------------------
;File name:	LACE_SPX.S		Revised:	1993.07.31
;Revised by:	Ulf Ronald Andersson	Revision date:	1993.05.19
;Release version:	1.0.A
;----------------------------------------------------------------------------
;
	output	.PRG
;
	include	URAn_APP.S
;
;----------------------------------------------------------------------------
;
		data
;
acc_name:	dc.b	NUL
		even
;
;----------------------------------------------------------------------------
		bss
;
mystack_data:	ds.l	$100
mystack:	ds.w	1	;User defined stack (goes backwards).
message:	ds.b	16	;Message pipe.
intin:		ds.w	30
intout:		ds.w	45
ptsin:		ds.w	30
ptsout:		ds.w	12
;
;----------------------------------------------------------------------------
;
	text
;
;----------------------------------------------------------------------------
;
init_app:
	tst	d7
	bmi.s	.TOS_init
	nop
.TOS_init:
	rts
;
;
exec_app:
	tst	d7
	bpl.s	GEM_app
TOS_app:
GEM_app:
	gemdos	Super,!
	move.l	d0,-(sp)
	bsr	take_swv_vec
	bsr.s	take_screen
	bsr	take_timers
	bsr	sync_fall_supx
	shi	entrylace_f
	bsr	small_lace_supx
	bsr	sync_lace_supx
	gemdos	Super,()
;-------------------------------------
	lea	progname_s(pc),a0
	bsr	get_path_tail_s
	gemdos	Pexec,!,progpath_s(pc),progtail_s,!
;-------------------------------------
	gemdos	Super,!
	move.l	d0,-(sp)
	bsr	give_timers
	bsr	give_screen
	tst	entrylace_f
	beq.s	.keep_small
	bsr	large_lace_supx
.keep_small:
	bsr	sync_lace_supx
	bsr	give_screen
	bsr	give_swv_vec
	gemdos	Super,()
	clr.l	d0
	rts	;This is the program exit, back to caller (or desktop)
;
;
;----------------------------------------------------------------------------
;
take_screen:
;
	xbios	Logbase
	move.l	d0,logbase_p
	xbios	Physbase
	move.l	d0,physbase_p
	xbios	Getrez
	move	d0,xbios_rez
;
	move.b	(hw_syn).w,syn_value
	and.b	#3,syn_value
	move.b	(hw_rez).w,rez_value
	and.b	#3,rez_value
	move.b	(sshiftmd).w,sshiftmd_value
;
	movem.l	(hw_pal).w,d0-d7	;\
	movem.l	d0-d7,pal_values	;/ pal_values = 16 words from hw_pal
;
	move	SR,-(sp)		;push int_mask
	or	#$0700,SR		;set int_mask 7
;
	move.b	(hw_ddr).w,d0
	move.b	d0,entry_ddr
	move.b	(hw_gpip).w,d1
	move.b	d1,entry_gpip
	or.b	#$80,d0
	move.b	d0,(hw_ddr).w
	or.b	#$80,d1
	move.b	d1,(hw_gpip).w
;
	xbios	Setscreen,?,?,#1
;
	move	(sp)+,SR		;pull int_mask
	rts
;
;
give_screen:	;called at main exit only
	xbios	Setscreen|_ind,?,physbase_p,xbios_rez
	xbios	Setscreen|_ind,logbase_p(pc),?,?
;
	movem.l	pal_values(pc),d0-d7	;\
	movem.l	d0-d7,(hw_pal).w	;/ hw_pal = 16 words from pal_values
;
	move	SR,-(sp)		;push int_mask
	or	#$0700,SR		;set int_mask 7
;
	move.b	rez_value(pc),(hw_rez).w
	move.b	syn_value(pc),(hw_syn).w
	move.b	sshiftmd_value(pc),(sshiftmd).w
;
	move.b	entry_gpip(pc),(hw_gpip).w
	move.b	entry_ddr(pc),(hw_ddr).w
;
	move	(sp)+,SR		;pull int_mask
;
	rts
;
;----------------------------------------------------------------------------
;
take_swv_vec:
	move	SR,-(sp)		;push int_mask
	or	#$0700,SR		;set int_mask 7
	move.b	(hw_iera).w,entry_iera
	and.b	#$7F,(hw_iera).w
	move.l	(swv_vec).w,entry_swv_vec
	move.l	#view_swv_vec,(swv_vec).w
	move	(sp)+,SR		;pull int_mask
	rts
;
;
give_swv_vec:
	move	SR,-(sp)		;push int_mask
	or	#$0700,SR		;set int_mask 7
	move.l	entry_swv_vec(pc),(swv_vec).w
	move.b	entry_iera(pc),(hw_iera).w
	move	(sp)+,SR		;pull int_mask
	rts
;
;
view_swv_vec:
	rts
;
;----------------------------------------------------------------------------
;
take_timers:	;Called at main entry only
	move	SR,-(sp)		;push int_mask
	or	#$0700,SR		;set int_mask 7
	lea	timer_values,a0
	move	USP,a1
	move.l	a1,(a0)+
	move.l	(ev_hbi).w,(a0)+
	move.l	(ev_vbi).w,(a0)+
	move.l	(iv_kb_midi).w,(a0)+
	move.l	(iv_time_a).w,(a0)+
	move.l	(iv_time_b).w,(a0)+
	move.b	(hw_iera).w,(a0)+
	move.b	(hw_ierb).w,(a0)+
	move.b	(hw_imra).w,(a0)+
	move.b	(hw_imrb).w,(a0)+
	move.b	(hw_tadr).w,(a0)+
	move.b	(hw_tbdr).w,(a0)+
	move.b	(hw_tacr).w,(a0)+
	move.b	(hw_tbcr).w,(a0)+
	move.b	(hw_vr).w,(a0)+
	move	(sp)+,SR		;pull int_mask
	rts
;
;
give_timers:	;called at main exit only
	move	SR,-(sp)		;push int_mask
	or	#$0700,SR		;set int_mask 7
	lea	timer_values,a0
	move.l	(a0)+,a1
	move	a1,USP
	move.l	(a0)+,(ev_hbi).w	;rest entry ev_hbi
	move.l	(a0)+,(ev_vbi).w	;rest entry ev_vbi
	move.l	(a0)+,(iv_kb_midi).w
	move.l	(a0)+,(iv_time_a).w
	move.l	(a0)+,(iv_time_b).w
	move.b	(a0)+,(hw_iera).w
	move.b	(a0)+,(hw_ierb).w
	move.b	(a0)+,(hw_imra).w
	move.b	(a0)+,(hw_imrb).w
	move.b	(a0)+,(hw_tadr).w
	move.b	(a0)+,(hw_tbdr).w
	move.b	(a0)+,(hw_tacr).w
	move.b	(a0)+,(hw_tbcr).w
	move.b	(a0)+,(hw_vr).w
	move	(sp)+,SR		;pull int_mask
	rts
;
;----------------------------------------------------------------------------
;
get_path_tail_s:
	move.l	a0,-(sp)
	gem_aes	shel_read,progpath_s(pc),progtail_s(pc)
	lea	progpath_s(pc),a0
	move.l	a0,a1
	tst	d0
	beq.s	.fill_name
	move	#240-1,d1
.find_end_lp:
	move.b	(a0)+,d0
	beq.s	.fill_name
	cmp.b	#'\',d0
	dbeq	d1,.find_end_lp
	bne.s	.fill_name
	move.l	a0,a1
	dbra	d1,.find_end_lp
.fill_name:
	move.l	(sp)+,a0
.fill_name_lp:
	move.b	(a0)+,(a1)+
	bne.s	.fill_name_lp
	rts
;
;
;----------------------------------------------------------------------------
;	LACESCAN support routines
;
	include	LACE_LIB.S
;
;----------------------------------------------------------------------------
;	Here starts the DATA area
;
	data
;
progname_s:
	dc.b	'SPX_VNEW.PRG',NUL
testname_s:
	dc.b	'TESTPROG.PRG',NUL
	even
;
;----------------------------------------------------------------------------
;
	bss
;
progpath_s:
	ds.b	256
progtail_s:
	ds.b	128
;
timer_values:	ds.b	40
logbase_p:	ds.l	1
physbase_p:	ds.l	1
xbios_rez:	ds.w	1
hardscreen_p:	ds.l	1
system_ssp:	ds.l	1
entry_ddr:	ds.w	1
entry_gpip:	ds.w	1
entry_swv_vec:	ds.l	1
entry_iera:	ds.w	1
sshiftmd_value:	ds.w	1
rez_value:	ds.w	1
syn_value:	ds.w	1
pal_values:	ds.w	16
entrylace_f	ds.w	1
;
;----------------------------------------------------------------------------
; End of file:	LACE_SPX.S
;----------------------------------------------------------------------------
