;----------------------------------------------------------------------------
;File name:	PCS_VIEW.S		Revised:	1996.02.13
;Revised by:	Ulf Ronald Andersson	Revision date:	1992.11.04
;Release version:	1.1
;----------------------------------------------------------------------------
;
	include	URAn_DOS.S
;
;----------------------------------------------------------------------------
;
MAX_flen	= 110000
;
;----------------------------------------------------------------------------
;
	text
	opt	o-
	output	.TOS
;
rz:	;relative zero
;
;----------------------------------------------------------------------------
;
main:
	moveq	#-1,d0
	move.l	a0,a5
	move.l	sp,a0
	lea	(mystack).l,sp
	move.l	a5,d0
	beq.s	.non_ACC
	gemdos	Pterm,d0
;
.non_ACC:
	move.l	4(a0),a5
	move.l	bp_textlen(a5),a0
	add.l	bp_datalen(a5),a0
	add.l	bp_bss_len(a5),a0
	lea	$100(a0),a0
	gemdos	Mshrink,!,(a5),a0
	gemdos	Super,!
	move.l	d0,system_ssp
	move.b	(hw_syn).w,syn_value
	and.b	#3,syn_value
	sf	escape_flag
	bsr	empty_key_buff
	bsr	take_screen
	bsr	take_timers
	gemdos	Dgetdrv
	move	d0,picfile_drive
	clr	files_total
	lea	files_typelist(pc),a0
	lea	files_viewlist(pc),a1
.types_loop:
	move.l	L240(pc),a2
	move.b	(a0)+,(a2)+
	beq.s	.done_types
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.l	(a1)+,typed_viewptr
	bsr	seek_files
	bra.s	.types_loop
;
.done_types:
	tst	files_total
	beq	exit_program
	clr	files_index
	lea	files_viewptrs,a0
	lea	files_pathnames,a1
	bsr	sync_fall_supx
	shi	entrylace_f
	bsr	small_lace_supx
	bsr	sync_lace_supx
;----------------------------------------------------------------------------
;	main slideshow loop '.slide_loop' in 'main'
.slide_loop:
	move	files_index(pc),d0
	move	d0,d1
	add	d0,d0
	add	d0,d0
	mulu	#$14,d1
	move.l	0(a0,d0.w),a2		;a2 -> view routine for file
	lea	0(a1,d1.w),a6		;a6 -> pathname to load file
	move.l	a6,load_fname_p
	movem.l	a0-a2,-(sp)
	move.l	#MAX_flen,load_fsize
	move.l	#packbase,load_buff_p
	bsr	load_picfile
	cmpi.l	#'ICE!',packbase
	bne.s	.non_ice
;here ICE! unpacking starts
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	load_fsize,d0
	add.l	d0,load_buff_p
	lea	(packbase).l,a0
	move.l	load_buff_p,a1
	bsr	unpack_ICE
	movem.l	(sp)+,d0-d7/a0-a6
;here ICE! unpacking ends
.non_ice:
	movem.l	(sp)+,a0-a2
	tst.l	d0
	bne.s	.L116
	movem.l	d0-d7/a0-a6,-(sp)
;;;patch	move	#5,vbl_count
		move	#1,vbl_count
.LF0:
	tst	vbl_count
	bne.s	.LF0
	bsr	stop_VIEW
	bsr	empty_hw_kbdata
	bsr	empty_key_buff
	jsr	(a2)			;Call view routine for file
;;;patch	move	#5,vbl_count
		move	#1,vbl_count
.L102:
	tst	vbl_count
	bne.s	.L102
	bsr	stop_VIEW
	bsr	empty_hw_kbdata
	bsr	empty_key_buff
	movem.l	(sp)+,d0-d7/a0-a6
.L116:
	tst.b	escape_flag
	bne	exit_program
	addq	#1,files_index
	move	files_total,d0
	cmp	files_index,d0
	bne	.slide_loop
	clr	files_index
	bra	.slide_loop
;
;End of main slideshow loop '.slide_loop' in 'main'
;----------------------------------------------------------------------------
;
;load_picfile:	;Called only from '.slide_loop' of 'main'
;entry:	load_fsize	== buffer size
;	load_buff_p	-> buffer
;	load_fname_p	-> files pathname
;exit:	load_fname	=  bytes loaded unless error occurred
;	d0		=  error code or zero
load_picfile:	;Called only from '.slide_loop' of 'main'
	gemdos	Fopen|_ind,load_fname_p(pc),!
	move.l	d0,d5
	tst.l	d0
	bmi.b	.L176
	gemdos	Fread|_ind,d5,load_fsize(pc),load_buff_p(pc)
	tst.l	d0
	bpl.b	.L17A
	gemdos	Fclose,d5
.L176:
	moveq	#-1,d0
	rts
;
.L17A:
	move.l	d0,load_fsize
	gemdos	Fclose,d5
	moveq	#0,d0
	rts
;
;
load_fname_p:	dc.l	0
load_buff_p:	dc.l	0
load_fsize:	dc.l	0
;
;
seek_files:	;Called only from 'main', before '.slide_loop', once per valid filetype
	pea	(a0)
	pea	(a1)
	lea	picfile_pathname(pc),a1
	move	picfile_drive,d0
	addi	#'A',d0
	move.b	d0,(a1)+
	move.b	#':',(a1)+
;;;patch	move.b	#'\',(a1)+	;original demanded root files !!!
	move.b	#'*',(a1)+
	move.b	#'.',(a1)+
	move.l	L240(pc),a0
	move.b	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	clr.b	(a1)
	gemdos	Fsetdta,loc_dta(pc)
	gemdos	Fsfirst,picfile_pathname(pc),#0
	tst.l	d0
	bne.s	.L1F8
.L1EA:	;here loc_dta holds the name of a valid picture file
	bsr.s	copy_pathname
	gemdos	Fsnext
	tst.l	d0
	beq.s	.L1EA
.L1F8:
	move.l	(sp)+,a1
	move.l	(sp)+,a0
	rts
;
;
copy_pathname:	;Called only from 'seek_files' (called only from 'main')
	lea	loc_dta_fname,a0	;a0 -> found filename
	lea	picfile_pathname(pc),a1	;a1 -> search pathname
	lea	files_pathnames(pc),a2
	lea	files_viewptrs(pc),a3
	move	files_total(pc),d0	;\
	move	d0,d1			;|
	add	d1,d1			; > a3 = files_viewptrs + ( 4 * files_total )
	add	d1,d1			;|
	adda	d1,a3			;/
	move.l	typed_viewptr(pc),(a3)
	mulu	#20,d0
	adda	d0,a2			; a2 = files_pathnames + ( 20 * files_total )
	move.b	(a1)+,(a2)+	;store drive number from search path
	move.b	(a1)+,(a2)+	;store ':' from search path
;;;patch move.b	(a1)+,(a2)+	;original demanded root files !!! (skipped now!)
	moveq	#13-1,d0		;\
.L22E:					; \
	move.b	(a0)+,(a2)+		; / store found 13 char name string (incl NUL)
	dbra	d0,.L22E		;/
	clr.b	(a2)		;store forced NUL after found name
	addq	#1,files_total
	rts
;
;
picfile_drive:		dc.w	$0
L240:			dc.l	L244
L244:			dc.l	0
loc_dta:		dcb.b	$1E,0
loc_dta_fname:		dcb.b	$0E,0
files_total:		dc.w	0
picfile_pathname:	dcb.b	$40,0
files_pathnames:	dcb.b	1600,0
files_viewptrs:		dcb.b	320,0
typed_viewptr:		dc.l	0
files_index:		dc.w	0
;
files_typelist:		dc.b	'PC1TN?PCS',NUL
;
files_viewlist:
	dc.l	PC1_viewer
	dc.l	TNx_viewer
	dc.l	PCS_viewer
;
;----------------------------------------------------------------------------
;
PC1_viewer:
	move.b	syn_value(pc),(hw_syn).w
	move.l	load_buff_p,a0
	bsr	prepare_PC1
	bra	static_view
;
;----------------------------------------------------------------------------
;
TNx_viewer:
	move.b	syn_value(pc),(hw_syn).w
	move.l	load_buff_p,a0
	bsr	prepare_TNx
static_view:
	bsr	screen_static
	move	slide_time,vbl_count
.static_viewloop:
	bsr	scan_kb_cmd
	tst.b	escape_flag
	bne.s	.static_escape
	tst.b	halt_flag
	bne.s	.static_halt
	tst	vbl_count
	bne.s	.static_viewloop
	bra.s	.static_escape
;
.static_halt:
	bsr	scan_kb_cmd
	tst.b	escape_flag
	bne.s	.static_escape
	tst.b	halt_flag
	bne.s	.static_halt
.static_escape:
	rts
;
;----------------------------------------------------------------------------
;
PCS_viewer:
	move.l	screen_bp_2,a0
	bsr	clear_32000_ia0
	move.l	screen_bp_1,a0
	bsr	clear_32000_ia0
	move.l	load_buff_p,a0
	bsr	fix_PCS_mode
	move	#1,vbl_count
.PCS_delay:
	tst	vbl_count
	bne.s	.PCS_delay
	bsr	start_PCS
	move	slide_time,d0
	move	d0,vbl_count
.PCS_viewloop:
	cmp	vbl_count,d0
	beq.s	.PCS_viewloop
	bsr	scan_kb_cmd
	tst.b	escape_flag
	bne.s	.PCS_escape
	tst.b	halt_flag
	bne.s	.PCS_halt
	move	vbl_count,d0
	bne.s	.PCS_viewloop
	bra.s	.PCS_escape
;
.PCS_halt:
	move	#1,vbl_count
.halt_wait:
	tst	vbl_count
	bne.s	.halt_wait
	bsr	scan_kb_cmd
	tst.b	escape_flag
	bne.s	.PCS_escape
	tst.b	halt_flag
	bne.s	.PCS_halt
.PCS_escape:
	rts
;
;
fix_PCS_mode:	;called only by 'PCS_viewer'
	sf	interlace_flag
	move.l	screen_bp_2,L6AE6
	move.l	screen_bp_1,L6AEA
	move.l	#pal_buff_1,pal_bp_1
	move.l	#pal_buff_2,pal_bp_2
	lea	6(a0),a1
	move.l	a0,a6
	move.b	#0,files_hw_syn
	btst	#0,5(a6)
	beq.s	LC36
	move.b	#2,files_hw_syn
LC36:
	move.b	files_hw_syn,(hw_syn).w
	move.l	L6AE6,a0
	bsr.s	LC8C
	move.l	pal_bp_1,a0
	bsr	LD22
	tst.b	4(a6)
	beq.s	LC76
	st	interlace_flag
	move.l	L6AEA,a0
	bsr.s	LC8C
	move.l	pal_bp_2,a0
	bsr	LD22
	bsr	LD6E
	bsr	LD98
LC76:
	addi.l	#$20,pal_bp_1
	addi.l	#$20,pal_bp_2
	rts
;
;
LC8C:
	moveq	#0,d6
	move	#$28,d2
	move	#$C8,d3
	moveq	#5,d4
	move.b	(a1)+,d7
	lsl.w	#8,d7
	move.b	(a1)+,d7
LC9E:
	moveq	#0,d0
	subq	#1,d7
	bmi.b	LCE6
	move.b	(a1)+,d0
	bmi.b	LCE8
	beq.s	LCB2
	cmp.b	#1,d0
	beq.s	LCEC
	bra.s	LCB8
;
LCB2:
	move.b	(a1)+,d0
	lsl.w	#8,d0
	move.b	(a1)+,d0
LCB8:
	subq	#1,d0
	move.b	(a1)+,d1
LCBC:
	move.b	d1,0(a0,d6.w)
	addq	#1,d6
	andi	#1,d6
	bne.s	LCCA
	addq	#8,a0
LCCA:
	subq	#1,d2
	bne.s	LCE0
	moveq	#40,d2
	subq	#1,d3
	bne.s	LCE0
	move	#$C8,d3
	lea	-31998(a0),a0
	subq	#1,d4
	beq.s	LCE6
LCE0:
	dbra	d0,LCBC
	bra.s	LC9E
;
LCE6:
	rts
;
LCE8:
	neg.b	d0
	bra.s	LCF2
LCEC:
	move.b	(a1)+,d0
	lsl.w	#8,d0
	move.b	(a1)+,d0
LCF2:
	subq	#1,d0
LCF4:
	move.b	(a1)+,d1
	move.b	d1,0(a0,d6.w)
	addq	#1,d6
	andi	#1,d6
	bne.s	LD04
	addq	#8,a0
LD04:
	subq	#1,d2
	bne.s	LD1A
	moveq	#40,d2
	subq	#1,d3
	bne.s	LD1A
	move	#$C8,d3
	lea	-31998(a0),a0
	subq	#1,d4
	beq.s	LCE6
LD1A:
	dbra	d0,LCF4
	bra	LC9E
;
LD22:
	move.b	(a1)+,d7
	lsl.w	#8,d7
	move.b	(a1)+,d7
LD28:
	moveq	#0,d0
	subq	#1,d7
	bmi.b	LD52
	move.b	(a1)+,d0
	bmi.b	LD54
	beq.s	LD3C
	cmp.b	#1,d0
	beq.s	LD58
	bra.s	LD42
LD3C:
	move.b	(a1)+,d0
	lsl.w	#8,d0
	move.b	(a1)+,d0
LD42:
	subq	#1,d0
	move.b	(a1)+,d1
	lsl.w	#8,d1
	move.b	(a1)+,d1
LD4A:
	move	d1,(a0)+
	dbra	d0,LD4A
	bra.s	LD28
LD52:
	rts
LD54:
	neg.b	d0
	bra.s	LD5E
LD58:
	move.b	(a1)+,d0
	lsl.w	#8,d0
	move.b	(a1)+,d0
LD5E:
	subq	#1,d0
LD60:
	move.b	(a1)+,d1
	lsl.w	#8,d1
	move.b	(a1)+,d1
	move	d1,(a0)+
	dbra	d0,LD60
	bra.s	LD28
LD6E:
	btst	#0,4(a6)
	bne.s	LD96
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	L6AE6,a0
	move.l	L6AEA,a1
	move	#8000-1,d0
LD8A:
	move.l	(a0)+,d1
	eor.l	d1,(a1)+
	dbra	d0,LD8A
	movem.l	(sp)+,d0-d7/a0-a6
LD96:
	rts
;
LD98:
	btst	#1,4(a6)
	bne.s	LDC0
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	pal_bp_1,a0
	move.l	pal_bp_2,a1
	move	#$2560-1,d0
LDB4:
	move	(a0)+,d1
	eor	d1,(a1)+
	dbra	d0,LDB4
	movem.l	(sp)+,d0-d7/a0-a6
LDC0:
	rts
;
;
files_hw_syn:	dc.b	0
interlace_flag:	dc.b	0
;
;
;----------------------------------------------------------------------------
;	Main display VBI subroutine  (linked via vbl_list)
;
disp_vbl_sub:
	btst	#1,(hw_syn).w
	bne.s	.LDDC
	move.b	#22,hbl_count
	move.l	#disp_60_Hz_hbi,(ev_hbi).w
	bra.s	.LDEA
;
.LDDC:
	move.b	#52,hbl_count
	move.l	#disp_50_Hz_hbi,(ev_hbi).w
.LDEA:
	move	#$2100,SR		;int_mask 1
	pea	(a0)
	pea	(a1)
	move.l	pal_bp_2(pc),a0
	lea	-30(a0),a0
	lea	(hw_pal+2).w,a1
	move	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(sp)+,a1
	move.l	(sp)+,a0
.LE12:
	tst.b	hbl_count
	bne.s	.LE12
	move	#$2300,SR		;int_mask 3
	move	d0,-(sp)	;push d0
.LE1E:					;\
	btst	#0,(hw_kbstat).w	;|
	beq.s	.LE2C			; > empty hw_kbdata
	move.b	(hw_kbdata).w,d0	;|
	bra.s	.LE1E			;/
;
.LE2C:
	move	(sp)+,d0	;pull d0
	tst	vbl_count		;\
	ble.s	.LE3C			; \
	subq	#1,vbl_count		; / decrement vbl_count if > 0
.LE3C:					;/
	move.l	d0,-(sp)
	move.l	pal_bp_1,d0		;\
	tst.b	interlace_flag		;|
	beq.s	.LE56			; \ if interlace swap pal's
	move.l	pal_bp_2,pal_bp_1	; / else force them equal
.LE56:					;|
	move.l	d0,pal_bp_2		;/
	move.l	L6AE6,d0		;\
	tst.b	interlace_flag		;|
	beq.s	.LE74			; \ if interlace swap screens
	move.l	L6AEA,L6AE6		; / else force them equal
.LE74:					;|
	move.l	d0,L6AEA		;/
	lsr.w	#8,d0
	move.l	d0,(hw_vbase2-1).w
	move.l	(sp)+,d0
	rts
;
;End of Main display VBI subroutine
;----------------------------------------------------------------------------
;	50 HZ display HBI exception routine  (linked via ev_hbi)
;
disp_50_Hz_hbi:
	subq.b	#1,hbl_count
	ble.s	.LE8C
	rte
;
.LE8C:
	move	#$2700,SR		;int_mask 7
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	sp,L3A42
	lea	(hw_vpos0).w,a6
	moveq	#0,d0
	moveq	#64,d7
.LEA2:
	move.b	(a6),d0
	beq.s	.LEA2
	sub	d0,d7
	lsl.w	d7,d0
	move	#$10,d0
.LEAE:
	dbra	d0,.LEAE
	nop
	move.l	pal_bp_2(pc),sp
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	rept	199			;\
	movem.l	(sp)+,d0-d7/a0-a6	; \
	movem.l	d0-d7,(hw_pal).w	; |
	movem.l	a0-a6,(hw_pal).w	; |
	move.l	(sp)+,(hw_pal+14*2).w	; |
	lea	(hw_pal).w,a0		; |
	move.l	(sp)+,(a0)+		; |
	move.l	(sp)+,(a0)+		; |
	move.l	(sp)+,(a0)+		; |
	move.l	(sp)+,(a0)+		;  \ This whole block repeats 199 times
	move.l	(sp)+,(a0)+		;  / (one block per picture line)
	move.l	(sp)+,(a0)+		; |
	move.l	(sp)+,(a0)+		; |
	move	#0,(hw_pal).w		; |
	move.l	(sp)+,(a0)+		; |
	move	#0,d0			; |
.LEEA_L3A3A	set	*		; |
	dbra	d0,.LEEA_L3A3A		; |
	nop				; /
	endr				;/
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	move.l	#0,sp
L3A42	=	*-4
	movem.l	(sp)+,d0-d7/a0-a6
	move.l	#nop_hbi,(ev_hbi).w	;link dummy routine after last line
	move.b	#35,(sp)
;----------------------------------------------------------------------------
;	'dummy' HBI exception routine  (linked via ev_hbi)
nop_hbi:
	rte
;
;End of	50 HZ and 'dummy' display HBI exception routines
;----------------------------------------------------------------------------
;	60 HZ display HBI exception routine  (linked via ev_hbi)
;
disp_60_Hz_hbi:
	subq.b	#1,hbl_count
	ble.s	L3A60
	rte
;
L3A60:
	move	#$2700,SR		;int_mask 7
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	sp,L6486
	lea	(hw_vpos0).w,a6
	moveq	#0,d0
	moveq	#64,d7
L3A76:
	move.b	(a6),d0
	beq.s	L3A76
	sub	d0,d7
	lsl.w	d7,d0
	move	#$10,d0
L3A82:
	dbra	d0,L3A82
	move.l	pal_bp_2(pc),sp
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	rept	199
	movem.l	(sp)+,d0-d7/a0-a6
	movem.l	d0-d7,(hw_pal).w
	movem.l	a0-a6,(hw_pal).w
	move.l	(sp)+,(hw_pal+14*2).w
	lea	(hw_pal).w,a0
	move.l	(sp)+,(a0)+
	move.l	(sp)+,(a0)+
	move.l	(sp)+,(a0)+
	move.l	(sp)+,(a0)+
	move.l	(sp)+,(a0)+
	move.l	(sp)+,(a0)+
	move.l	(sp)+,(a0)+
	move	#0,(hw_pal).w
	move.l	(sp)+,(a0)+
	move	#0,d0
.L3ABC_L6480	set	*
	dbra	d0,.L3ABC_L6480
	endr
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	move.l	#0,sp
L6486	=	*-4
	movem.l	(sp)+,d0-d7/a0-a6
	move.l	#nop_hbi,(ev_hbi).w	;link dummy routine after last line
	move.b	#35,(sp)
	rte
;
;End of	60 HZ display HBI exception routine
;----------------------------------------------------------------------------
;
start_PCS:
	move.b	#18,(hw_kbdata).w	;mouse off
	lea	L64D4(pc),a0
	move.l	new_vbl_list+4,(a0)+
	move	#$2700,SR		;int_mask 7
	move.l	#disp_vbl_sub,new_vbl_list+4
	move	#$2300,SR		;int_mask 3
	rts
;
;
stop_VIEW:
	lea	(hw_pal).w,a0
	rept	8
	clr.l	(a0)+			;Black out pallette
	endr
	lea	L64D4(pc),a0
	tst	(a0)
	beq.s	.no_act_PCS
	move	#$2700,SR		;int_mask 7
	move.l	(a0),new_vbl_list+4
	clr.l	(a0)
	move.l	screen_bp_1,d0		;\
	lsr.w	#8,d0			; > hw_vbase -> .l(screen_bp_1)
	move.l	d0,(hw_vbase2-1).w	;/
	move	#$2300,SR		;int_mask 3
	move.b	#8,(hw_kbdata).w	;mouse on
.no_act_PCS:
	rts
;
;
L64D4:	dc.l	0
;
;
empty_hw_kbdata:
	move	d7,-(sp)
.L64EA:
	btst	#0,(hw_kbstat).w
	beq.s	.L64F8
	move.b	(hw_kbdata).w,d7
	bra.s	.L64EA
.L64F8:
	move	(sp)+,d7
	rts
;
;
screen_static:	;only called from 'static_view'
	move.l	screen_bp_2,a0
	move.l	screen_bp_1,a1
	move	#8000-1,d0
.L650C:
	move.l	(a0)+,(a1)+
	dbra	d0,.L650C
	move	#1,vbl_count
.L651A:
	tst	vbl_count
	bne.s	.L651A
	movem.l	pal_static,d0-d7
	movem.l	d0-d7,(hw_pal).w
	rts
;
;----------------------------------------------------------------------------
;	Subroutine to prepare PC1 file for non-interlaced display
;
prepare_PC1:
	addq	#2,a0
	moveq	#16-1,d0
	lea	pal_static,a1
.L653C:
	move	(a0)+,d1
	move	d1,(a1)+
	dbra	d0,.L653C
	move.l	screen_bp_2,a1
	moveq	#0,d3
	moveq	#0,d4
	move	#$C7,d5
.L6552:
	move.b	(a0)+,d1
	ext.w	d1
	bpl.b	.L6592
	cmp.b	#128,d1
	beq.s	.L6552
	neg	d1
	move.b	(a0)+,d2
.L6562:
	move.b	d2,(a1)+
	addq	#1,d3
	cmp.b	#40,d3
	beq.s	.L657A
	btst	#0,d3
	bne.s	.L6574
	addq	#6,a1
.L6574:
	dbra	d1,.L6562
	bra.s	.L6552
;
.L657A:
	moveq	#0,d3
	addq	#1,d4
	cmp.b	#4,d4
	beq.s	.L658A
	suba	#$98,a1
	bra.s	.L6574
;
.L658A:
	moveq	#0,d4
	dbra	d5,.L6574
	bra.s	.L65C0
;
.L6592:
	move.b	(a0)+,(a1)+
	addq	#1,d3
	cmp.b	#40,d3
	beq.s	.L65AA
	btst	#0,d3
	bne.s	.L65A4
	addq	#6,a1
.L65A4:
	dbra	d1,.L6592
	bra.s	.L6552
;
.L65AA:
	moveq	#0,d3
	addq	#1,d4
	cmp.b	#4,d4
	beq.s	.L65BA
	suba	#$98,a1
	bra.s	.L65A4
.L65BA:
	moveq	#0,d4
	dbra	d5,.L65A4
.L65C0:
	rts
;
;End of	Subroutine to prepare PC1 file for non-interlaced display
;----------------------------------------------------------------------------
;	Subroutine to prepare TNx file for non-interlaced display
;
prepare_TNx:
	moveq	#8,d6
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	move.b	(a0)+,d0
	cmp.b	#2,d0
	ble.s	L65D6
	addq	#4,a0
	subq.b	#3,d0
L65D6:
	move.b	d0,(hw_rez).w
	moveq	#15,d0
	lea	pal_static(pc),a1
L65E0:
	move.b	(a0)+,d1
	lsl.w	d6,d1
	move.b	(a0)+,d1
	move	d1,(a1)+
	dbra	d0,L65E0
	move.b	(a0)+,d0
	lsl.w	d6,d0
	move.b	(a0)+,d0
	move	d0,d1
	addq	#2,a0
	move.l	a0,a1
	lea	0(a0,d1.w),a2
	move.l	screen_bp_2,a0
	move.l	a0,a3
L6604:
	moveq	#0,d0
	move.b	(a1)+,d0
	bmi.b	L6654
	beq.s	.L6614
	cmp.b	#1,d0
	beq.s	L6658
	bra.s	.L661A
.L6614:
	move.b	(a1)+,d0
	lsl.w	d6,d0
	move.b	(a1)+,d0
.L661A:
	subq	#1,d0
	move.b	(a2)+,d1
	lsl.w	d6,d1
	move.b	(a2)+,d1
.L6622:
	move	d1,(a0)
	lea	160(a0),a0
	addq	#1,d2
	cmp	#$C8,d2
	blt.b	.L664C
	moveq	#0,d2
	lea	-31992(a0),a0
	addq	#1,d3
	cmp	#$14,d3
	blt.b	.L664C
	moveq	#0,d3
	addq	#2,d4
	cmp	#6,d4
	bgt.b	L6652
	lea	0(a3,d4.w),a0
.L664C:
	dbra	d0,.L6622
	bra.s	L6604
L6652:
	rts
;
L6654:
	neg.b	d0
	bra.s	L665E
;
L6658:
	move.b	(a1)+,d0
	lsl.w	d6,d0
	move.b	(a1)+,d0
L665E:
	subq	#1,d0
.L6660:
	move.b	(a2)+,d1
	lsl.w	d6,d1
	move.b	(a2)+,d1
	move	d1,(a0)
	lea	160(a0),a0
	addq	#1,d2
	cmp	#$C8,d2
	blt.b	.L6690
	moveq	#0,d2
	lea	-31992(a0),a0
	addq	#1,d3
	cmp	#$14,d3
	blt.b	.L6690
	moveq	#0,d3
	addq	#2,d4
	cmp	#6,d4
	bgt.b	L6652
	lea	0(a3,d4.w),a0
.L6690:
	dbra	d0,.L6660
	bra	L6604
;
;End of	Subroutine to prepare TNx file for non-interlaced display
;----------------------------------------------------------------------------
;
exit_program:
	tst	entrylace_f
	beq.s	.keep_small
	bsr	large_lace_supx
.keep_small:
	bsr	sync_lace_supx
	bsr	give_timers
	bsr	give_screen
	gemdos	Super|_ind,system_ssp
	gemdos	Pterm0
;
;This is the program exit, back to caller (or desktop)
;----------------------------------------------------------------------------
;
take_screen:	;Called at main entry only
	xbios	Physbase			;\
	move.l	d0,physbase_p			;/ physbase_p -> physbase by xbios
;;;patch	xbios	Getrez			;\
;;;patch	move	d0,rez_value		;/ rez_value = screen rez by xbios
	move.b	(hw_rez).w,d0
	and	#3,d0
	move	d0,rez_value
	move.l	#screen_buff_2,d0
	clr.b	d0
	move.l	d0,screen_bp_2		;screen_bp_2 -> screen_buff_2 page truncated
	move.l	#screen_buff_1,d0
	clr.b	d0
	move.l	d0,screen_bp_1		;screen_bp_1 -> screen_buff_1 page truncated
;;;patch	xbios	Setscreen,?,?,#0		;screen_rez = 0 (low)
	movem.l	(hw_pal).w,d0-d7	;\
	movem.l	d0-d7,pal_values	;/ pal_values = 16 words from hw_pal
	move	#$2700,SR		;int_mask 7
	move.b	(hw_ddr).w,d0
	move.b	d0,entry_ddr
	move.b	(hw_gpip).w,d1
	move.b	d1,entry_gpip
	or.b	#$80,d0
	move.b	d0,(hw_ddr).w
;;;	and	#$7F,d1
	move.b	d1,(hw_gpip).w
	move.l	(swv_vec).w,entry_swv_vec
	move.l	#view_swv_vec,(swv_vec).w
	move.l	(_vblqueue).w,a0
	move.l	a0,entry_vbl_list
	move.l	(a0),new_vbl_list
	lea	new_vbl_list(pc),a1
	move.l	a1,(_vblqueue).w
	move.b	#0,(hw_rez).w
	move.l	screen_bp_1,d0
	lsr.w	#8,d0
	move.l	d0,(hw_vbase2-1).w	;hw_vbase = screen_bp_1
	move	#$2300,SR		;int_mask 3
dsub:
	rts
;
;
view_swv_vec:
	move.b	#0,(hw_rez).w
	and.b	#$7F,(hw_gpip).w
	or.b	#$80,(hw_gpip).w
	rts
;
;
give_screen:	;called at main exit only
	movem.l	pal_values,d0-d7	;\
	movem.l	d0-d7,(hw_pal).w	;/ hw_pal = 16 words from pal_values
;;;patch	xbios	Setscreen|_ind,?,?,rez_value	;xbios screen rez = rez_value
	move	#$2700,SR		;int_mask 7
	move.b	rez_value+1(pc),(hw_rez).w
	move.b	syn_value(pc),(hw_syn).w
	move.l	physbase_p,d0			;\
	lsr.w	#8,d0				; > hw_vbase = physbase_p
	move.l	d0,(hw_vbase2-1).w		;/
	move.l	entry_vbl_list(pc),(_vblqueue).w
	move.l	entry_swv_vec(pc),(swv_vec).w
	move.b	entry_ddr,d0
	or.b	#$7F,d0
	and.b	d0,(hw_ddr).w
	move	#$2300,SR		;int_mask 3
	rts
;
;
take_timers:	;Called at main entry only
	lea	timer_values,a0
	move	USP,a1
	move.l	a1,(a0)+
	move.l	(ev_hbi).w,(a0)+
	move.l	(ev_vbi).w,(a0)+
	move.l	(iv_kb_midi).w,(a0)+
	move.l	(iv_time_a).w,(a0)+
	move.l	(iv_time_b).w,(a0)+
	move.b	(hw_iera).w,(a0)+
	move.b	(hw_ierb).w,(a0)+
	move.b	(hw_imra).w,(a0)+
	move.b	(hw_imrb).w,(a0)+
	move.b	(hw_tadr).w,(a0)+
	move.b	(hw_tbdr).w,(a0)+
	move.b	(hw_tacr).w,(a0)+
	move.b	(hw_tbcr).w,(a0)+
	move.b	(hw_vr).w,(a0)+
	move	#$2700,SR		;int_mask 7
	move.l	#cntdn_vbl_sub,new_vbl_list+4
	move	#$2300,SR		;int_mask 3
	rts
;
;
give_timers:	;called at main exit only
	move	#$2700,SR		;int_mask 7
	clr.l	new_vbl_list+4
	lea	timer_values,a0
	move.l	(a0)+,a1
	move	a1,USP
	move.l	(a0)+,(ev_hbi).w	;rest entry ev_hbi
	move.l	(a0)+,(ev_vbi).w	;rest entry ev_vbi
	move.l	(a0)+,(iv_kb_midi).w
	move.l	(a0)+,(iv_time_a).w
	move.l	(a0)+,(iv_time_b).w
	move.b	(a0)+,(hw_iera).w
	move.b	(a0)+,(hw_ierb).w
	move.b	(a0)+,(hw_imra).w
	move.b	(a0)+,(hw_imrb).w
	move.b	(a0)+,(hw_tadr).w
	move.b	(a0)+,(hw_tbdr).w
	move.b	(a0)+,(hw_tacr).w
	move.b	(a0)+,(hw_tbcr).w
	move.b	(a0)+,(hw_vr).w
	move	#$2300,SR		;int_mask 3
	rts
;
;
;----------------------------------------------------------------------------
cntdn_vbl_sub:
	tst	vbl_count
	ble.s	.L680A
	subq	#1,vbl_count
.L680A:
	rts
;
;----------------------------------------------------------------------------
;
scan_kb_cmd:
	clr.l	kb_cmd_chr
.L6812:
	gemdos	Cconis
	tst.l	d0
	beq.s	.L682E
	gemdos	Cconin
	move.l	d0,kb_cmd_chr
	bra.s	.L6812
;
.L682E:
	move.l	kb_cmd_chr(pc),d0
	tst.b	d0
	beq.s	.L6856
	cmp.b	#ESC,d0
	seq	escape_flag
	cmp.b	#' ',d0
	seq	halt_flag
	cmp.b	#CR,d0
	bne.s	.L6856
	sf	halt_flag
	bra.s	.short_count
;
.L6856:
	swap	d0
	cmp.b	#$3B,d0		;key F1 ?
	blt.b	.exit_cmd	;exit if too low
	cmp.b	#$44,d0		;key F10 ?
	bgt.b	.exit_cmd	;exit if too high
	subi.b	#$3B,d0		;d0 = X = 0..9 for F1..F10
	ext.w	d0
;;;patch	lsl.w	#8,d0
;;;patch	add	d0,d0
;;;patch	addi	#$32,d0		;d0 = X * 512 + 32
	lsl	#2,d0
	addq	#1,d0
	lsl	#4,d0			;d0 = X * 64 +16
	move	slide_time(pc),d1
	move	d0,slide_time
	sub	d1,d0
	add	vbl_count,d0
	tst	d0
	bgt.s	.chg_count
.short_count:
	moveq	#1,d0
.chg_count:
	move	d0,vbl_count
.exit_cmd:
	rts
;
;
kb_cmd_chr:
	dc.l	0
;
	dc.l	0	;Unref ???
;
;
empty_key_buff:
	movem.l	d0-d7/a0-a6,-(sp)
.L6886:
	gemdos	Cconis
	tst.l	d0
	beq.s	.L689C
	gemdos	Crawcin
	bra.s	.L6886
;
.L689C:
	movem.l	(sp)+,d0-d7/a0-a6
	rts
;
;
slide_time:
;;;patch	dc.w	$0320	;orig default delay = 12.5 seconds
	dc.w	$E0		; new default delay = 3.5 seconds
syn_value:
	dc.w	$0
;
L68A6:	;Unref ???
	movem.l	pal_static,d0-d7
	movem.l	d0-d7,(hw_pal).w
	rts
;
;
L68B6:	;Unref ???
	move.l	screen_bp_2,d7
	move.l	screen_bp_1,screen_bp_2
	move.l	d7,screen_bp_1
	move.b	d7,d0
	lsr.w	#8,d7
	move.l	d7,(hw_vbase2-1).w
	move.b	d0,(hw_vbase0+1).w
	move	#1,vbl_count
.L68E0:
	tst	vbl_count
	bne.s	.L68E0
	rts
;
;
clear_32000_ia0:	
	lea	32000(a0),a0
	moveq	#0,d1
	move.l	d1,d2
	move.l	d1,d3
	move.l	d1,d4
	move.l	d1,d5
	move.l	d1,d6
	move.l	d1,d7
	move.l	d1,a1
	move.l	d1,a2
	move.l	d1,a3
	move.l	d1,a4
	move.l	d1,a5
	move.l	d1,a6
	moveq	#25-1,d0
.L690A:
	rept	24
	movem.l	d1-d7/a1-a6,-(a0)
	endr
	movem.l	d1-d4/a1-a4,-(a0)
	dbra	d0,.L690A
	rts
;
;
move_32000_ia0_ia1:	;Unref ???
	move	#8000-1,d0
.move_32000_lp:
	move.l	(a0)+,(a1)+
	dbra	d0,.move_32000_lp
	rts
;
;----------------------------------------------------------------------------
;
	include	LACE_LIB.S
;
;----------------------------------------------------------------------------
;	Here starts the ICE unpacker (which is the last routine)
;
;unpack_ICE:	;Called only from '.slide_loop' of 'main'
;entry:	a0	-> header of packed data to unpack, called 'packbase' below
unpack_ICE:	;Called only from '.slide_loop' of 'main'
	movem.l	d0-d7/a0-a6,-(sp)
	bsr.s	moveb_l_ia0p_d0
	cmpi.l	#'ICE!',d0
	bne	.exit_ICE
	bsr.s	moveb_l_ia0p_d0
	lea	-8(a0,d0.l),a5		;a5 -> packbase + .l(packbase+4)
	bsr.s	moveb_l_ia0p_d0
	move.l	d0,(sp)			;.l(sp) = .l(packbase+8)  a0 -> packbase+12
	move.l	a1,a4			;a4 = a1
	move.l	a1,a6			;\
	adda.l	d0,a6			; > a3 = a6 = a1 + .l(packbase+8)
	move.l	a6,a3			;/
	move.b	-(a5),d7
	bsr	L69FA
	move.l	a3,a6
	bsr	L6A26
	bcc.s	.exit_ICE
	move	#$F9F,d7
	bsr	L6A26
	bcc.s	.ICE_loop_1
	moveq	#15,d0
	bsr	L6A30
	move	d1,d7
.ICE_loop_1:
	moveq	#4-1,d6
.ICE_loop_2:
	move	-(a3),d4
	moveq	#4-1,d5
.ICE_loop_3:
	add	d4,d4	;\
	addx	d0,d0	;|
	add	d4,d4	;|
	addx	d1,d1	; \ 4 bits are shifted out of d4 and 1 each into d0..d3
	add	d4,d4	; / this is repeated 4 times per d4 word from -(a3)
	addx	d2,d2	;|
	add	d4,d4	;|
	addx	d3,d3	;/
	dbra	d5,.ICE_loop_3
	dbra	d6,.ICE_loop_2
	movem.w	d0-d3,(a3)
	dbra	d7,.ICE_loop_1
;NB: The above 3 loops perform no actual unpacking at all, but simply rearrange
;NB: bit patterns to decode an encryption inherent in ICE.
;NB: Thus, without this encryption unpacking would be MUCH faster.
;NB: All actual unpacking is made by the subroutines called before '.ICE_loop_1'
.exit_ICE:
	movem.l	(sp)+,d0-d7/a0-a6
	rts
;
;
moveb_l_ia0p_d0:
	moveq	#3,d1
.L69F0:
	lsl.l	#8,d0
	move.b	(a0)+,d0
	dbra	d1,.L69F0
	rts
;
;
L69FA:
	bsr.s	L6A26
	bcc.s	.L6A20
	moveq	#0,d1
	bsr.s	L6A26
	bcc.s	.L6A1A
	lea	L6ABE(pc),a1
	moveq	#4,d3
.L6A0A:
	move.l	-(a1),d0
	bsr.s	L6A30
	swap	d0
	cmp	d0,d1
	dbne	d3,.L6A0A
	add.l	20(a1),d1
.L6A1A:
	move.b	-(a5),-(a6)
	dbra	d1,.L6A1A
.L6A20:
	cmp.l	a4,a6
	bgt.b	L6A42
	rts
;
;
L6A26:
	add.b	d7,d7
	bne.s	.L6A2E
	move.b	-(a5),d7
	addx.b	d7,d7
.L6A2E:
	rts
;
;
L6A30:
	moveq	#0,d1
.L6A32:
	add.b	d7,d7
	bne.s	.L6A3A
	move.b	-(a5),d7
	addx.b	d7,d7
.L6A3A:
	addx	d1,d1
	dbra	d0,.L6A32
	rts
;
L6A42:
	lea	L6AD2(pc),a1
	moveq	#3,d2
.L6A48:
	bsr.s	L6A26
	dbcc	d2,.L6A48
	moveq	#0,d4
	moveq	#0,d1
	move.b	1(a1,d2.w),d0
	ext.w	d0
	bmi.b	.L6A5C
	bsr.s	L6A30
.L6A5C:
	move.b	6(a1,d2.w),d4
	add	d1,d4
	beq.s	.L6A86
	lea	L6ADC(pc),a1
	moveq	#1,d2
.L6A6A:
	bsr.s	L6A26
	dbcc	d2,.L6A6A
	moveq	#0,d1
	move.b	1(a1,d2.w),d0
	ext.w	d0
	bsr.s	L6A30
	add	d2,d2
	add	6(a1,d2.w),d1
	bpl.b	.L6A98
	sub	d4,d1
	bra.s	.L6A98
;
.L6A86:
	moveq	#0,d1
	moveq	#5,d0
	moveq	#-1,d2
	bsr.s	L6A26
	bcc.s	.L6A94
	moveq	#8,d0
	moveq	#63,d2
.L6A94:
	bsr.s	L6A30
	add	d2,d1
.L6A98:
	lea	2(a6,d4.w),a1
	adda	d1,a1
	move.b	-(a1),-(a6)
.L6AA0:
	move.b	-(a1),-(a6)
	dbra	d4,.L6AA0
	bra	L69FA
;
;
L6AAA:	;Unref! ???  (probably needed by ICE unpacker)
	dc.w	$7FFF
	dc.w	$E
	dc.w	$FF
	dc.w	7,7
	dc.w	2,3
	dc.w	1,3
	dc.w	1
L6ABE:	dc.l	$10D,$E,7,4,1
L6AD2:
	dc.b	9,1,0,$FF,$FF,8,4,2,1,0
L6ADC:
	dc.b	$B,4,7,0,1,$1F
	dc.w	$FFFF
	dc.w	$1F
;
;----------------------------------------------------------------------------
;	Here starts the DATA area
;
	data
;
new_vbl_list:
	dc.l	0
new_vbl_link:
	dc.l	0
;----------------------------------------------------------------------------
;	Here starts the BSS area
	ds.l	38
;
	bss
;
L6AE6:		ds.l	1
L6AEA:		ds.l	1
pal_bp_1:	ds.l	1
pal_bp_2:	ds.l	1
timer_values:	ds.b	40
escape_flag:	ds.b	1
halt_flag:	ds.b	1
hbl_count:	ds.b	2
vbl_count:	ds.b	2
screen_bp_1:	ds.l	1
screen_bp_2:	ds.l	1
physbase_p:	ds.l	1
system_ssp:	ds.l	1
entry_ddr:	ds.b	1
entry_gpip:	ds.b	1
entry_swv_vec:	ds.l	1
entry_vbl_list:	ds.l	1
rez_value:	ds.w	1
mystack_data:	ds.l	$100
mystack:	ds.l	4		;256 longs stack + 4 longs safety margin
entrylace_f	ds.w	1
pal_values:	ds.w	16
pal_zeros:	ds.w	16		;only used as data to black out pallette
pal_static:	ds.w	16
pal_buff_1:	ds.b	19232		;pallette buffer 1
pal_buff_2:	ds.b	19232		;pallette buffer 2
		ds.b	255		;allows page truncation for screen buffers
screen_buff_1:	ds.b	32000+256	;Screen buffer 1 with page alignment margin
screen_buff_2:	ds.b	32001		;Screen buffer 2 with page alignment margin
packbase:	ds.b	MAX_flen
;
;----------------------------------------------------------------------------
bss_end:
	end	;of file:	PCS_VIEW.S
