/* babel - News transport agent for STiK
 *
 * babel.h - Header file with prototypes for public functions
 *
 * (c)1996 Mark Baker. Distributable under the terms of the GNU
 *                     general public licence
 *
 * $Id: babel.h,v 1.5 1996/10/01 18:34:27 mnb20 Exp $
 */

/* Strings structure */
#include "babelstr.h"

/* Routines in main.c */

int main( int argc, char **argv ) ;
void parse_command_line( int argc, char **argv ) ;
void process_file( void ) ;
void new_server( char *server_name, char *groupfile ) ;
void new_groups( char *basefile, char *date ) ;
void byebye( int retstat ) ;

/* Routines in gem.c */

void initialise_gem( void ) ;
void status_line( char *message ) ;
void event_loop( void ) ;
void shutdown_gem( void ) ;
void alert( char *message ) ;

/* Routines in files.c */

void open_files( void ) ;
void close_files( void ) ;
void group_list_file( char *server_name, char *filename ) ;
void new_groups_file( char *basename ) ;
FILE *open_group_header( char *basename, char *mode ) ;
FILE *open_messages( char *basename ) ;
FILE *temp_messages( char *basename ) ;
void close_messages( FILE *old, FILE *temp, char *basename ) ;

/* Routines in socket.c */

void initialise_stik( void ) ;
int open_server( char *hostname ) ;
void close_server( void ) ;
void write_string( char *string ) ;
void read_line( char *line, int maxlength ) ;
void kick( void ) ;

/* Routines in group.c */

void do_group( char *group, char *filename, int headers_only, char *date ) ;
void read_header( char *filename ) ;
void write_header( char *filename ) ;
void free_header( void ) ;
void new_articles( char *group, char *date ) ;
void read_article_text( FILE *messages, int headers_only ) ;
void get_requested_articles( FILE *messages, int headers_only ) ;
void send_messages( FILE *messages, char *group ) ;
void expunge( FILE *old, FILE *temp ) ;
void *chk_malloc( size_t size ) ;



